# Edited version of Src/signames2.awk.
#
# {g,n}awk script to generate errnames.c
# This version relies on the previous output of the preprocessor
# on sigtmp.c, sigtmp.out, which is in turn generated by errnames1.awk.
#
# NB: On SunOS 4.1.3 - user-functions don\'t work properly, also \" problems
# Without 0 + hacks some nawks compare numbers as strings
#
/^XXNAMES XXE[A-Z0-9]*[\t ][\t ]*[1-9][0-9]*/ {
    eindex = index($0, "E")
    etail = substr($0, 11, 80)
    split(etail, tmp)
    enam = tmp[1]
    enum = tmp[2]
    if (errname[enum] == "") {
	errname[enum] = enam
	if (0 + max < 0 + enum && enum < 1024)
	    max = enum
    }
}

END {
    ps = "%s"
    printf "/** errnames.c                                 **/\n"
    printf "/** architecture-customized errnames.c for zsh **/\n"
    printf "\n"
    printf "#define ERRCOUNT\t%d\n", max
    printf "\n"
    printf "#include %csystem.mdh%c\n", 34, 34
    printf "\n"
    printf "/**/\n"
    printf "const char *sys_errnames[ERRCOUNT+1] = {\n"

    for (i = 1; i <= 0 + max; i++)
	if (errname[i] == "")
	    printf("\t%cE%d%c,\n", 34, i, 34)
	else
	    printf("\t%c%s%c,\n", 34, errname[i], 34)
    print "\tNULL"
    print "};"
}
