// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dataproc/v1beta2/jobs.proto

package dataproc

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The Log4j level for job execution. When running an
// [Apache Hive](http://hive.apache.org/) job, Cloud
// Dataproc configures the Hive client to an equivalent verbosity level.
type LoggingConfig_Level int32

const (
	// Level is unspecified. Use default level for log4j.
	LoggingConfig_LEVEL_UNSPECIFIED LoggingConfig_Level = 0
	// Use ALL level for log4j.
	LoggingConfig_ALL LoggingConfig_Level = 1
	// Use TRACE level for log4j.
	LoggingConfig_TRACE LoggingConfig_Level = 2
	// Use DEBUG level for log4j.
	LoggingConfig_DEBUG LoggingConfig_Level = 3
	// Use INFO level for log4j.
	LoggingConfig_INFO LoggingConfig_Level = 4
	// Use WARN level for log4j.
	LoggingConfig_WARN LoggingConfig_Level = 5
	// Use ERROR level for log4j.
	LoggingConfig_ERROR LoggingConfig_Level = 6
	// Use FATAL level for log4j.
	LoggingConfig_FATAL LoggingConfig_Level = 7
	// Turn off log4j.
	LoggingConfig_OFF LoggingConfig_Level = 8
)

var LoggingConfig_Level_name = map[int32]string{
	0: "LEVEL_UNSPECIFIED",
	1: "ALL",
	2: "TRACE",
	3: "DEBUG",
	4: "INFO",
	5: "WARN",
	6: "ERROR",
	7: "FATAL",
	8: "OFF",
}

var LoggingConfig_Level_value = map[string]int32{
	"LEVEL_UNSPECIFIED": 0,
	"ALL":               1,
	"TRACE":             2,
	"DEBUG":             3,
	"INFO":              4,
	"WARN":              5,
	"ERROR":             6,
	"FATAL":             7,
	"OFF":               8,
}

func (x LoggingConfig_Level) String() string {
	return proto.EnumName(LoggingConfig_Level_name, int32(x))
}

func (LoggingConfig_Level) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{0, 0}
}

// The job state.
type JobStatus_State int32

const (
	// The job state is unknown.
	JobStatus_STATE_UNSPECIFIED JobStatus_State = 0
	// The job is pending; it has been submitted, but is not yet running.
	JobStatus_PENDING JobStatus_State = 1
	// Job has been received by the service and completed initial setup;
	// it will soon be submitted to the cluster.
	JobStatus_SETUP_DONE JobStatus_State = 8
	// The job is running on the cluster.
	JobStatus_RUNNING JobStatus_State = 2
	// A CancelJob request has been received, but is pending.
	JobStatus_CANCEL_PENDING JobStatus_State = 3
	// Transient in-flight resources have been canceled, and the request to
	// cancel the running job has been issued to the cluster.
	JobStatus_CANCEL_STARTED JobStatus_State = 7
	// The job cancellation was successful.
	JobStatus_CANCELLED JobStatus_State = 4
	// The job has completed successfully.
	JobStatus_DONE JobStatus_State = 5
	// The job has completed, but encountered an error.
	JobStatus_ERROR JobStatus_State = 6
	// Job attempt has failed. The detail field contains failure details for
	// this attempt.
	//
	// Applies to restartable jobs only.
	JobStatus_ATTEMPT_FAILURE JobStatus_State = 9
)

var JobStatus_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "PENDING",
	8: "SETUP_DONE",
	2: "RUNNING",
	3: "CANCEL_PENDING",
	7: "CANCEL_STARTED",
	4: "CANCELLED",
	5: "DONE",
	6: "ERROR",
	9: "ATTEMPT_FAILURE",
}

var JobStatus_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"PENDING":           1,
	"SETUP_DONE":        8,
	"RUNNING":           2,
	"CANCEL_PENDING":    3,
	"CANCEL_STARTED":    7,
	"CANCELLED":         4,
	"DONE":              5,
	"ERROR":             6,
	"ATTEMPT_FAILURE":   9,
}

func (x JobStatus_State) String() string {
	return proto.EnumName(JobStatus_State_name, int32(x))
}

func (JobStatus_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{11, 0}
}

// The job substate.
type JobStatus_Substate int32

const (
	// The job substate is unknown.
	JobStatus_UNSPECIFIED JobStatus_Substate = 0
	// The Job is submitted to the agent.
	//
	// Applies to RUNNING state.
	JobStatus_SUBMITTED JobStatus_Substate = 1
	// The Job has been received and is awaiting execution (it may be waiting
	// for a condition to be met). See the "details" field for the reason for
	// the delay.
	//
	// Applies to RUNNING state.
	JobStatus_QUEUED JobStatus_Substate = 2
	// The agent-reported status is out of date, which may be caused by a
	// loss of communication between the agent and Dataproc. If the
	// agent does not send a timely update, the job will fail.
	//
	// Applies to RUNNING state.
	JobStatus_STALE_STATUS JobStatus_Substate = 3
)

var JobStatus_Substate_name = map[int32]string{
	0: "UNSPECIFIED",
	1: "SUBMITTED",
	2: "QUEUED",
	3: "STALE_STATUS",
}

var JobStatus_Substate_value = map[string]int32{
	"UNSPECIFIED":  0,
	"SUBMITTED":    1,
	"QUEUED":       2,
	"STALE_STATUS": 3,
}

func (x JobStatus_Substate) String() string {
	return proto.EnumName(JobStatus_Substate_name, int32(x))
}

func (JobStatus_Substate) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{11, 1}
}

// The application state, corresponding to
// <code>YarnProtos.YarnApplicationStateProto</code>.
type YarnApplication_State int32

const (
	// Status is unspecified.
	YarnApplication_STATE_UNSPECIFIED YarnApplication_State = 0
	// Status is NEW.
	YarnApplication_NEW YarnApplication_State = 1
	// Status is NEW_SAVING.
	YarnApplication_NEW_SAVING YarnApplication_State = 2
	// Status is SUBMITTED.
	YarnApplication_SUBMITTED YarnApplication_State = 3
	// Status is ACCEPTED.
	YarnApplication_ACCEPTED YarnApplication_State = 4
	// Status is RUNNING.
	YarnApplication_RUNNING YarnApplication_State = 5
	// Status is FINISHED.
	YarnApplication_FINISHED YarnApplication_State = 6
	// Status is FAILED.
	YarnApplication_FAILED YarnApplication_State = 7
	// Status is KILLED.
	YarnApplication_KILLED YarnApplication_State = 8
)

var YarnApplication_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "NEW",
	2: "NEW_SAVING",
	3: "SUBMITTED",
	4: "ACCEPTED",
	5: "RUNNING",
	6: "FINISHED",
	7: "FAILED",
	8: "KILLED",
}

var YarnApplication_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"NEW":               1,
	"NEW_SAVING":        2,
	"SUBMITTED":         3,
	"ACCEPTED":          4,
	"RUNNING":           5,
	"FINISHED":          6,
	"FAILED":            7,
	"KILLED":            8,
}

func (x YarnApplication_State) String() string {
	return proto.EnumName(YarnApplication_State_name, int32(x))
}

func (YarnApplication_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{13, 0}
}

// A matcher that specifies categories of job states.
type ListJobsRequest_JobStateMatcher int32

const (
	// Match all jobs, regardless of state.
	ListJobsRequest_ALL ListJobsRequest_JobStateMatcher = 0
	// Only match jobs in non-terminal states: PENDING, RUNNING, or
	// CANCEL_PENDING.
	ListJobsRequest_ACTIVE ListJobsRequest_JobStateMatcher = 1
	// Only match jobs in terminal states: CANCELLED, DONE, or ERROR.
	ListJobsRequest_NON_ACTIVE ListJobsRequest_JobStateMatcher = 2
)

var ListJobsRequest_JobStateMatcher_name = map[int32]string{
	0: "ALL",
	1: "ACTIVE",
	2: "NON_ACTIVE",
}

var ListJobsRequest_JobStateMatcher_value = map[string]int32{
	"ALL":        0,
	"ACTIVE":     1,
	"NON_ACTIVE": 2,
}

func (x ListJobsRequest_JobStateMatcher) String() string {
	return proto.EnumName(ListJobsRequest_JobStateMatcher_name, int32(x))
}

func (ListJobsRequest_JobStateMatcher) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{19, 0}
}

// The runtime logging config of the job.
type LoggingConfig struct {
	// The per-package log levels for the driver. This may include
	// "root" package name to configure rootLogger.
	// Examples:
	//   'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
	DriverLogLevels      map[string]LoggingConfig_Level `protobuf:"bytes,2,rep,name=driver_log_levels,json=driverLogLevels,proto3" json:"driver_log_levels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=google.cloud.dataproc.v1beta2.LoggingConfig_Level"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *LoggingConfig) Reset()         { *m = LoggingConfig{} }
func (m *LoggingConfig) String() string { return proto.CompactTextString(m) }
func (*LoggingConfig) ProtoMessage()    {}
func (*LoggingConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{0}
}

func (m *LoggingConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LoggingConfig.Unmarshal(m, b)
}
func (m *LoggingConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LoggingConfig.Marshal(b, m, deterministic)
}
func (m *LoggingConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LoggingConfig.Merge(m, src)
}
func (m *LoggingConfig) XXX_Size() int {
	return xxx_messageInfo_LoggingConfig.Size(m)
}
func (m *LoggingConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_LoggingConfig.DiscardUnknown(m)
}

var xxx_messageInfo_LoggingConfig proto.InternalMessageInfo

func (m *LoggingConfig) GetDriverLogLevels() map[string]LoggingConfig_Level {
	if m != nil {
		return m.DriverLogLevels
	}
	return nil
}

// A Dataproc job for running
// [Apache Hadoop
// MapReduce](https://hadoop.apache.org/docs/current/hadoop-mapreduce-client/hadoop-mapreduce-client-core/MapReduceTutorial.html)
// jobs on [Apache Hadoop
// YARN](https://hadoop.apache.org/docs/r2.7.1/hadoop-yarn/hadoop-yarn-site/YARN.html).
type HadoopJob struct {
	// Required. Indicates the location of the driver's main class. Specify
	// either the jar file that contains the main class or the main class name.
	// To specify both, add the jar file to `jar_file_uris`, and then specify
	// the main class name in this property.
	//
	// Types that are valid to be assigned to Driver:
	//	*HadoopJob_MainJarFileUri
	//	*HadoopJob_MainClass
	Driver isHadoopJob_Driver `protobuf_oneof:"driver"`
	// Optional. The arguments to pass to the driver. Do not
	// include arguments, such as `-libjars` or `-Dfoo=bar`, that can be set as
	// job properties, since a collision may occur that causes an incorrect job
	// submission.
	Args []string `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`
	// Optional. Jar file URIs to add to the CLASSPATHs of the
	// Hadoop driver and tasks.
	JarFileUris []string `protobuf:"bytes,4,rep,name=jar_file_uris,json=jarFileUris,proto3" json:"jar_file_uris,omitempty"`
	// Optional. HCFS (Hadoop Compatible Filesystem) URIs of files to be copied
	// to the working directory of Hadoop drivers and distributed tasks. Useful
	// for naively parallel tasks.
	FileUris []string `protobuf:"bytes,5,rep,name=file_uris,json=fileUris,proto3" json:"file_uris,omitempty"`
	// Optional. HCFS URIs of archives to be extracted in the working directory of
	// Hadoop drivers and tasks. Supported file types:
	// .jar, .tar, .tar.gz, .tgz, or .zip.
	ArchiveUris []string `protobuf:"bytes,6,rep,name=archive_uris,json=archiveUris,proto3" json:"archive_uris,omitempty"`
	// Optional. A mapping of property names to values, used to configure Hadoop.
	// Properties that conflict with values set by the Dataproc API may be
	// overwritten. Can include properties set in /etc/hadoop/conf/*-site and
	// classes in user code.
	Properties map[string]string `protobuf:"bytes,7,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The runtime log config for job execution.
	LoggingConfig        *LoggingConfig `protobuf:"bytes,8,opt,name=logging_config,json=loggingConfig,proto3" json:"logging_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *HadoopJob) Reset()         { *m = HadoopJob{} }
func (m *HadoopJob) String() string { return proto.CompactTextString(m) }
func (*HadoopJob) ProtoMessage()    {}
func (*HadoopJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{1}
}

func (m *HadoopJob) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HadoopJob.Unmarshal(m, b)
}
func (m *HadoopJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HadoopJob.Marshal(b, m, deterministic)
}
func (m *HadoopJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HadoopJob.Merge(m, src)
}
func (m *HadoopJob) XXX_Size() int {
	return xxx_messageInfo_HadoopJob.Size(m)
}
func (m *HadoopJob) XXX_DiscardUnknown() {
	xxx_messageInfo_HadoopJob.DiscardUnknown(m)
}

var xxx_messageInfo_HadoopJob proto.InternalMessageInfo

type isHadoopJob_Driver interface {
	isHadoopJob_Driver()
}

type HadoopJob_MainJarFileUri struct {
	MainJarFileUri string `protobuf:"bytes,1,opt,name=main_jar_file_uri,json=mainJarFileUri,proto3,oneof"`
}

type HadoopJob_MainClass struct {
	MainClass string `protobuf:"bytes,2,opt,name=main_class,json=mainClass,proto3,oneof"`
}

func (*HadoopJob_MainJarFileUri) isHadoopJob_Driver() {}

func (*HadoopJob_MainClass) isHadoopJob_Driver() {}

func (m *HadoopJob) GetDriver() isHadoopJob_Driver {
	if m != nil {
		return m.Driver
	}
	return nil
}

func (m *HadoopJob) GetMainJarFileUri() string {
	if x, ok := m.GetDriver().(*HadoopJob_MainJarFileUri); ok {
		return x.MainJarFileUri
	}
	return ""
}

func (m *HadoopJob) GetMainClass() string {
	if x, ok := m.GetDriver().(*HadoopJob_MainClass); ok {
		return x.MainClass
	}
	return ""
}

func (m *HadoopJob) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *HadoopJob) GetJarFileUris() []string {
	if m != nil {
		return m.JarFileUris
	}
	return nil
}

func (m *HadoopJob) GetFileUris() []string {
	if m != nil {
		return m.FileUris
	}
	return nil
}

func (m *HadoopJob) GetArchiveUris() []string {
	if m != nil {
		return m.ArchiveUris
	}
	return nil
}

func (m *HadoopJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *HadoopJob) GetLoggingConfig() *LoggingConfig {
	if m != nil {
		return m.LoggingConfig
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*HadoopJob) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*HadoopJob_MainJarFileUri)(nil),
		(*HadoopJob_MainClass)(nil),
	}
}

// A Dataproc job for running [Apache Spark](http://spark.apache.org/)
// applications on YARN.
// The specification of the main method to call to drive the job.
// Specify either the jar file that contains the main class or the main class
// name. To pass both a main jar and a main class in that jar, add the jar to
// `CommonJob.jar_file_uris`, and then specify the main class name in
// `main_class`.
type SparkJob struct {
	// Types that are valid to be assigned to Driver:
	//	*SparkJob_MainJarFileUri
	//	*SparkJob_MainClass
	Driver isSparkJob_Driver `protobuf_oneof:"driver"`
	// Optional. The arguments to pass to the driver. Do not include arguments,
	// such as `--conf`, that can be set as job properties, since a collision may
	// occur that causes an incorrect job submission.
	Args []string `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`
	// Optional. HCFS URIs of jar files to add to the CLASSPATHs of the
	// Spark driver and tasks.
	JarFileUris []string `protobuf:"bytes,4,rep,name=jar_file_uris,json=jarFileUris,proto3" json:"jar_file_uris,omitempty"`
	// Optional. HCFS URIs of files to be copied to the working directory of
	// Spark drivers and distributed tasks. Useful for naively parallel tasks.
	FileUris []string `protobuf:"bytes,5,rep,name=file_uris,json=fileUris,proto3" json:"file_uris,omitempty"`
	// Optional. HCFS URIs of archives to be extracted in the working directory
	// of Spark drivers and tasks. Supported file types:
	// .jar, .tar, .tar.gz, .tgz, and .zip.
	ArchiveUris []string `protobuf:"bytes,6,rep,name=archive_uris,json=archiveUris,proto3" json:"archive_uris,omitempty"`
	// Optional. A mapping of property names to values, used to configure Spark.
	// Properties that conflict with values set by the Dataproc API may be
	// overwritten. Can include properties set in
	// /etc/spark/conf/spark-defaults.conf and classes in user code.
	Properties map[string]string `protobuf:"bytes,7,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The runtime log config for job execution.
	LoggingConfig        *LoggingConfig `protobuf:"bytes,8,opt,name=logging_config,json=loggingConfig,proto3" json:"logging_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *SparkJob) Reset()         { *m = SparkJob{} }
func (m *SparkJob) String() string { return proto.CompactTextString(m) }
func (*SparkJob) ProtoMessage()    {}
func (*SparkJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{2}
}

func (m *SparkJob) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SparkJob.Unmarshal(m, b)
}
func (m *SparkJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SparkJob.Marshal(b, m, deterministic)
}
func (m *SparkJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SparkJob.Merge(m, src)
}
func (m *SparkJob) XXX_Size() int {
	return xxx_messageInfo_SparkJob.Size(m)
}
func (m *SparkJob) XXX_DiscardUnknown() {
	xxx_messageInfo_SparkJob.DiscardUnknown(m)
}

var xxx_messageInfo_SparkJob proto.InternalMessageInfo

type isSparkJob_Driver interface {
	isSparkJob_Driver()
}

type SparkJob_MainJarFileUri struct {
	MainJarFileUri string `protobuf:"bytes,1,opt,name=main_jar_file_uri,json=mainJarFileUri,proto3,oneof"`
}

type SparkJob_MainClass struct {
	MainClass string `protobuf:"bytes,2,opt,name=main_class,json=mainClass,proto3,oneof"`
}

func (*SparkJob_MainJarFileUri) isSparkJob_Driver() {}

func (*SparkJob_MainClass) isSparkJob_Driver() {}

func (m *SparkJob) GetDriver() isSparkJob_Driver {
	if m != nil {
		return m.Driver
	}
	return nil
}

func (m *SparkJob) GetMainJarFileUri() string {
	if x, ok := m.GetDriver().(*SparkJob_MainJarFileUri); ok {
		return x.MainJarFileUri
	}
	return ""
}

func (m *SparkJob) GetMainClass() string {
	if x, ok := m.GetDriver().(*SparkJob_MainClass); ok {
		return x.MainClass
	}
	return ""
}

func (m *SparkJob) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *SparkJob) GetJarFileUris() []string {
	if m != nil {
		return m.JarFileUris
	}
	return nil
}

func (m *SparkJob) GetFileUris() []string {
	if m != nil {
		return m.FileUris
	}
	return nil
}

func (m *SparkJob) GetArchiveUris() []string {
	if m != nil {
		return m.ArchiveUris
	}
	return nil
}

func (m *SparkJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *SparkJob) GetLoggingConfig() *LoggingConfig {
	if m != nil {
		return m.LoggingConfig
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SparkJob) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SparkJob_MainJarFileUri)(nil),
		(*SparkJob_MainClass)(nil),
	}
}

// A Dataproc job for running
// [Apache
// PySpark](https://spark.apache.org/docs/0.9.0/python-programming-guide.html)
// applications on YARN.
type PySparkJob struct {
	// Required. The HCFS URI of the main Python file to use as the driver. Must
	// be a .py file.
	MainPythonFileUri string `protobuf:"bytes,1,opt,name=main_python_file_uri,json=mainPythonFileUri,proto3" json:"main_python_file_uri,omitempty"`
	// Optional. The arguments to pass to the driver.  Do not include arguments,
	// such as `--conf`, that can be set as job properties, since a collision may
	// occur that causes an incorrect job submission.
	Args []string `protobuf:"bytes,2,rep,name=args,proto3" json:"args,omitempty"`
	// Optional. HCFS file URIs of Python files to pass to the PySpark
	// framework. Supported file types: .py, .egg, and .zip.
	PythonFileUris []string `protobuf:"bytes,3,rep,name=python_file_uris,json=pythonFileUris,proto3" json:"python_file_uris,omitempty"`
	// Optional. HCFS URIs of jar files to add to the CLASSPATHs of the
	// Python driver and tasks.
	JarFileUris []string `protobuf:"bytes,4,rep,name=jar_file_uris,json=jarFileUris,proto3" json:"jar_file_uris,omitempty"`
	// Optional. HCFS URIs of files to be copied to the working directory of
	// Python drivers and distributed tasks. Useful for naively parallel tasks.
	FileUris []string `protobuf:"bytes,5,rep,name=file_uris,json=fileUris,proto3" json:"file_uris,omitempty"`
	// Optional. HCFS URIs of archives to be extracted in the working directory of
	// .jar, .tar, .tar.gz, .tgz, and .zip.
	ArchiveUris []string `protobuf:"bytes,6,rep,name=archive_uris,json=archiveUris,proto3" json:"archive_uris,omitempty"`
	// Optional. A mapping of property names to values, used to configure PySpark.
	// Properties that conflict with values set by the Dataproc API may be
	// overwritten. Can include properties set in
	// /etc/spark/conf/spark-defaults.conf and classes in user code.
	Properties map[string]string `protobuf:"bytes,7,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The runtime log config for job execution.
	LoggingConfig        *LoggingConfig `protobuf:"bytes,8,opt,name=logging_config,json=loggingConfig,proto3" json:"logging_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *PySparkJob) Reset()         { *m = PySparkJob{} }
func (m *PySparkJob) String() string { return proto.CompactTextString(m) }
func (*PySparkJob) ProtoMessage()    {}
func (*PySparkJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{3}
}

func (m *PySparkJob) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PySparkJob.Unmarshal(m, b)
}
func (m *PySparkJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PySparkJob.Marshal(b, m, deterministic)
}
func (m *PySparkJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PySparkJob.Merge(m, src)
}
func (m *PySparkJob) XXX_Size() int {
	return xxx_messageInfo_PySparkJob.Size(m)
}
func (m *PySparkJob) XXX_DiscardUnknown() {
	xxx_messageInfo_PySparkJob.DiscardUnknown(m)
}

var xxx_messageInfo_PySparkJob proto.InternalMessageInfo

func (m *PySparkJob) GetMainPythonFileUri() string {
	if m != nil {
		return m.MainPythonFileUri
	}
	return ""
}

func (m *PySparkJob) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *PySparkJob) GetPythonFileUris() []string {
	if m != nil {
		return m.PythonFileUris
	}
	return nil
}

func (m *PySparkJob) GetJarFileUris() []string {
	if m != nil {
		return m.JarFileUris
	}
	return nil
}

func (m *PySparkJob) GetFileUris() []string {
	if m != nil {
		return m.FileUris
	}
	return nil
}

func (m *PySparkJob) GetArchiveUris() []string {
	if m != nil {
		return m.ArchiveUris
	}
	return nil
}

func (m *PySparkJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *PySparkJob) GetLoggingConfig() *LoggingConfig {
	if m != nil {
		return m.LoggingConfig
	}
	return nil
}

// A list of queries to run on a cluster.
type QueryList struct {
	// Required. The queries to execute. You do not need to terminate a query
	// with a semicolon. Multiple queries can be specified in one string
	// by separating each with a semicolon. Here is an example of an Cloud
	// Dataproc API snippet that uses a QueryList to specify a HiveJob:
	//
	//     "hiveJob": {
	//       "queryList": {
	//         "queries": [
	//           "query1",
	//           "query2",
	//           "query3;query4",
	//         ]
	//       }
	//     }
	Queries              []string `protobuf:"bytes,1,rep,name=queries,proto3" json:"queries,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *QueryList) Reset()         { *m = QueryList{} }
func (m *QueryList) String() string { return proto.CompactTextString(m) }
func (*QueryList) ProtoMessage()    {}
func (*QueryList) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{4}
}

func (m *QueryList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_QueryList.Unmarshal(m, b)
}
func (m *QueryList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_QueryList.Marshal(b, m, deterministic)
}
func (m *QueryList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_QueryList.Merge(m, src)
}
func (m *QueryList) XXX_Size() int {
	return xxx_messageInfo_QueryList.Size(m)
}
func (m *QueryList) XXX_DiscardUnknown() {
	xxx_messageInfo_QueryList.DiscardUnknown(m)
}

var xxx_messageInfo_QueryList proto.InternalMessageInfo

func (m *QueryList) GetQueries() []string {
	if m != nil {
		return m.Queries
	}
	return nil
}

// A Dataproc job for running [Apache Hive](https://hive.apache.org/)
// queries on YARN.
type HiveJob struct {
	// Required. The sequence of Hive queries to execute, specified as either
	// an HCFS file URI or a list of queries.
	//
	// Types that are valid to be assigned to Queries:
	//	*HiveJob_QueryFileUri
	//	*HiveJob_QueryList
	Queries isHiveJob_Queries `protobuf_oneof:"queries"`
	// Optional. Whether to continue executing queries if a query fails.
	// The default value is `false`. Setting to `true` can be useful when
	// executing independent parallel queries.
	ContinueOnFailure bool `protobuf:"varint,3,opt,name=continue_on_failure,json=continueOnFailure,proto3" json:"continue_on_failure,omitempty"`
	// Optional. Mapping of query variable names to values (equivalent to the
	// Hive command: `SET name="value";`).
	ScriptVariables map[string]string `protobuf:"bytes,4,rep,name=script_variables,json=scriptVariables,proto3" json:"script_variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. A mapping of property names and values, used to configure Hive.
	// Properties that conflict with values set by the Dataproc API may be
	// overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml,
	// /etc/hive/conf/hive-site.xml, and classes in user code.
	Properties map[string]string `protobuf:"bytes,5,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. HCFS URIs of jar files to add to the CLASSPATH of the
	// Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes
	// and UDFs.
	JarFileUris          []string `protobuf:"bytes,6,rep,name=jar_file_uris,json=jarFileUris,proto3" json:"jar_file_uris,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *HiveJob) Reset()         { *m = HiveJob{} }
func (m *HiveJob) String() string { return proto.CompactTextString(m) }
func (*HiveJob) ProtoMessage()    {}
func (*HiveJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{5}
}

func (m *HiveJob) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_HiveJob.Unmarshal(m, b)
}
func (m *HiveJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_HiveJob.Marshal(b, m, deterministic)
}
func (m *HiveJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_HiveJob.Merge(m, src)
}
func (m *HiveJob) XXX_Size() int {
	return xxx_messageInfo_HiveJob.Size(m)
}
func (m *HiveJob) XXX_DiscardUnknown() {
	xxx_messageInfo_HiveJob.DiscardUnknown(m)
}

var xxx_messageInfo_HiveJob proto.InternalMessageInfo

type isHiveJob_Queries interface {
	isHiveJob_Queries()
}

type HiveJob_QueryFileUri struct {
	QueryFileUri string `protobuf:"bytes,1,opt,name=query_file_uri,json=queryFileUri,proto3,oneof"`
}

type HiveJob_QueryList struct {
	QueryList *QueryList `protobuf:"bytes,2,opt,name=query_list,json=queryList,proto3,oneof"`
}

func (*HiveJob_QueryFileUri) isHiveJob_Queries() {}

func (*HiveJob_QueryList) isHiveJob_Queries() {}

func (m *HiveJob) GetQueries() isHiveJob_Queries {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *HiveJob) GetQueryFileUri() string {
	if x, ok := m.GetQueries().(*HiveJob_QueryFileUri); ok {
		return x.QueryFileUri
	}
	return ""
}

func (m *HiveJob) GetQueryList() *QueryList {
	if x, ok := m.GetQueries().(*HiveJob_QueryList); ok {
		return x.QueryList
	}
	return nil
}

func (m *HiveJob) GetContinueOnFailure() bool {
	if m != nil {
		return m.ContinueOnFailure
	}
	return false
}

func (m *HiveJob) GetScriptVariables() map[string]string {
	if m != nil {
		return m.ScriptVariables
	}
	return nil
}

func (m *HiveJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *HiveJob) GetJarFileUris() []string {
	if m != nil {
		return m.JarFileUris
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*HiveJob) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*HiveJob_QueryFileUri)(nil),
		(*HiveJob_QueryList)(nil),
	}
}

// A Dataproc job for running [Apache Spark
// SQL](http://spark.apache.org/sql/) queries.
type SparkSqlJob struct {
	// Required. The sequence of Spark SQL queries to execute, specified as
	// either an HCFS file URI or as a list of queries.
	//
	// Types that are valid to be assigned to Queries:
	//	*SparkSqlJob_QueryFileUri
	//	*SparkSqlJob_QueryList
	Queries isSparkSqlJob_Queries `protobuf_oneof:"queries"`
	// Optional. Mapping of query variable names to values (equivalent to the
	// Spark SQL command: SET `name="value";`).
	ScriptVariables map[string]string `protobuf:"bytes,3,rep,name=script_variables,json=scriptVariables,proto3" json:"script_variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. A mapping of property names to values, used to configure
	// Spark SQL's SparkConf. Properties that conflict with values set by the
	// Dataproc API may be overwritten.
	Properties map[string]string `protobuf:"bytes,4,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
	JarFileUris []string `protobuf:"bytes,56,rep,name=jar_file_uris,json=jarFileUris,proto3" json:"jar_file_uris,omitempty"`
	// Optional. The runtime log config for job execution.
	LoggingConfig        *LoggingConfig `protobuf:"bytes,6,opt,name=logging_config,json=loggingConfig,proto3" json:"logging_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *SparkSqlJob) Reset()         { *m = SparkSqlJob{} }
func (m *SparkSqlJob) String() string { return proto.CompactTextString(m) }
func (*SparkSqlJob) ProtoMessage()    {}
func (*SparkSqlJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{6}
}

func (m *SparkSqlJob) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SparkSqlJob.Unmarshal(m, b)
}
func (m *SparkSqlJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SparkSqlJob.Marshal(b, m, deterministic)
}
func (m *SparkSqlJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SparkSqlJob.Merge(m, src)
}
func (m *SparkSqlJob) XXX_Size() int {
	return xxx_messageInfo_SparkSqlJob.Size(m)
}
func (m *SparkSqlJob) XXX_DiscardUnknown() {
	xxx_messageInfo_SparkSqlJob.DiscardUnknown(m)
}

var xxx_messageInfo_SparkSqlJob proto.InternalMessageInfo

type isSparkSqlJob_Queries interface {
	isSparkSqlJob_Queries()
}

type SparkSqlJob_QueryFileUri struct {
	QueryFileUri string `protobuf:"bytes,1,opt,name=query_file_uri,json=queryFileUri,proto3,oneof"`
}

type SparkSqlJob_QueryList struct {
	QueryList *QueryList `protobuf:"bytes,2,opt,name=query_list,json=queryList,proto3,oneof"`
}

func (*SparkSqlJob_QueryFileUri) isSparkSqlJob_Queries() {}

func (*SparkSqlJob_QueryList) isSparkSqlJob_Queries() {}

func (m *SparkSqlJob) GetQueries() isSparkSqlJob_Queries {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *SparkSqlJob) GetQueryFileUri() string {
	if x, ok := m.GetQueries().(*SparkSqlJob_QueryFileUri); ok {
		return x.QueryFileUri
	}
	return ""
}

func (m *SparkSqlJob) GetQueryList() *QueryList {
	if x, ok := m.GetQueries().(*SparkSqlJob_QueryList); ok {
		return x.QueryList
	}
	return nil
}

func (m *SparkSqlJob) GetScriptVariables() map[string]string {
	if m != nil {
		return m.ScriptVariables
	}
	return nil
}

func (m *SparkSqlJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *SparkSqlJob) GetJarFileUris() []string {
	if m != nil {
		return m.JarFileUris
	}
	return nil
}

func (m *SparkSqlJob) GetLoggingConfig() *LoggingConfig {
	if m != nil {
		return m.LoggingConfig
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SparkSqlJob) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SparkSqlJob_QueryFileUri)(nil),
		(*SparkSqlJob_QueryList)(nil),
	}
}

// A Dataproc job for running [Apache Pig](https://pig.apache.org/)
// queries on YARN.
type PigJob struct {
	// Required. The sequence of Pig queries to execute, specified as an HCFS
	// file URI or a list of queries.
	//
	// Types that are valid to be assigned to Queries:
	//	*PigJob_QueryFileUri
	//	*PigJob_QueryList
	Queries isPigJob_Queries `protobuf_oneof:"queries"`
	// Optional. Whether to continue executing queries if a query fails.
	// The default value is `false`. Setting to `true` can be useful when
	// executing independent parallel queries.
	ContinueOnFailure bool `protobuf:"varint,3,opt,name=continue_on_failure,json=continueOnFailure,proto3" json:"continue_on_failure,omitempty"`
	// Optional. Mapping of query variable names to values (equivalent to the Pig
	// command: `name=[value]`).
	ScriptVariables map[string]string `protobuf:"bytes,4,rep,name=script_variables,json=scriptVariables,proto3" json:"script_variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. A mapping of property names to values, used to configure Pig.
	// Properties that conflict with values set by the Dataproc API may be
	// overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml,
	// /etc/pig/conf/pig.properties, and classes in user code.
	Properties map[string]string `protobuf:"bytes,5,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. HCFS URIs of jar files to add to the CLASSPATH of
	// the Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.
	JarFileUris []string `protobuf:"bytes,6,rep,name=jar_file_uris,json=jarFileUris,proto3" json:"jar_file_uris,omitempty"`
	// Optional. The runtime log config for job execution.
	LoggingConfig        *LoggingConfig `protobuf:"bytes,7,opt,name=logging_config,json=loggingConfig,proto3" json:"logging_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *PigJob) Reset()         { *m = PigJob{} }
func (m *PigJob) String() string { return proto.CompactTextString(m) }
func (*PigJob) ProtoMessage()    {}
func (*PigJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{7}
}

func (m *PigJob) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PigJob.Unmarshal(m, b)
}
func (m *PigJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PigJob.Marshal(b, m, deterministic)
}
func (m *PigJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PigJob.Merge(m, src)
}
func (m *PigJob) XXX_Size() int {
	return xxx_messageInfo_PigJob.Size(m)
}
func (m *PigJob) XXX_DiscardUnknown() {
	xxx_messageInfo_PigJob.DiscardUnknown(m)
}

var xxx_messageInfo_PigJob proto.InternalMessageInfo

type isPigJob_Queries interface {
	isPigJob_Queries()
}

type PigJob_QueryFileUri struct {
	QueryFileUri string `protobuf:"bytes,1,opt,name=query_file_uri,json=queryFileUri,proto3,oneof"`
}

type PigJob_QueryList struct {
	QueryList *QueryList `protobuf:"bytes,2,opt,name=query_list,json=queryList,proto3,oneof"`
}

func (*PigJob_QueryFileUri) isPigJob_Queries() {}

func (*PigJob_QueryList) isPigJob_Queries() {}

func (m *PigJob) GetQueries() isPigJob_Queries {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *PigJob) GetQueryFileUri() string {
	if x, ok := m.GetQueries().(*PigJob_QueryFileUri); ok {
		return x.QueryFileUri
	}
	return ""
}

func (m *PigJob) GetQueryList() *QueryList {
	if x, ok := m.GetQueries().(*PigJob_QueryList); ok {
		return x.QueryList
	}
	return nil
}

func (m *PigJob) GetContinueOnFailure() bool {
	if m != nil {
		return m.ContinueOnFailure
	}
	return false
}

func (m *PigJob) GetScriptVariables() map[string]string {
	if m != nil {
		return m.ScriptVariables
	}
	return nil
}

func (m *PigJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *PigJob) GetJarFileUris() []string {
	if m != nil {
		return m.JarFileUris
	}
	return nil
}

func (m *PigJob) GetLoggingConfig() *LoggingConfig {
	if m != nil {
		return m.LoggingConfig
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PigJob) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PigJob_QueryFileUri)(nil),
		(*PigJob_QueryList)(nil),
	}
}

// A Dataproc job for running
// [Apache SparkR](https://spark.apache.org/docs/latest/sparkr.html)
// applications on YARN.
type SparkRJob struct {
	// Required. The HCFS URI of the main R file to use as the driver.
	// Must be a .R file.
	MainRFileUri string `protobuf:"bytes,1,opt,name=main_r_file_uri,json=mainRFileUri,proto3" json:"main_r_file_uri,omitempty"`
	// Optional. The arguments to pass to the driver.  Do not include arguments,
	// such as `--conf`, that can be set as job properties, since a collision may
	// occur that causes an incorrect job submission.
	Args []string `protobuf:"bytes,2,rep,name=args,proto3" json:"args,omitempty"`
	// Optional. HCFS URIs of files to be copied to the working directory of
	// R drivers and distributed tasks. Useful for naively parallel tasks.
	FileUris []string `protobuf:"bytes,3,rep,name=file_uris,json=fileUris,proto3" json:"file_uris,omitempty"`
	// Optional. HCFS URIs of archives to be extracted in the working directory of
	// Spark drivers and tasks. Supported file types:
	// .jar, .tar, .tar.gz, .tgz, and .zip.
	ArchiveUris []string `protobuf:"bytes,4,rep,name=archive_uris,json=archiveUris,proto3" json:"archive_uris,omitempty"`
	// Optional. A mapping of property names to values, used to configure SparkR.
	// Properties that conflict with values set by the Dataproc API may be
	// overwritten. Can include properties set in
	// /etc/spark/conf/spark-defaults.conf and classes in user code.
	Properties map[string]string `protobuf:"bytes,5,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The runtime log config for job execution.
	LoggingConfig        *LoggingConfig `protobuf:"bytes,6,opt,name=logging_config,json=loggingConfig,proto3" json:"logging_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *SparkRJob) Reset()         { *m = SparkRJob{} }
func (m *SparkRJob) String() string { return proto.CompactTextString(m) }
func (*SparkRJob) ProtoMessage()    {}
func (*SparkRJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{8}
}

func (m *SparkRJob) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SparkRJob.Unmarshal(m, b)
}
func (m *SparkRJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SparkRJob.Marshal(b, m, deterministic)
}
func (m *SparkRJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SparkRJob.Merge(m, src)
}
func (m *SparkRJob) XXX_Size() int {
	return xxx_messageInfo_SparkRJob.Size(m)
}
func (m *SparkRJob) XXX_DiscardUnknown() {
	xxx_messageInfo_SparkRJob.DiscardUnknown(m)
}

var xxx_messageInfo_SparkRJob proto.InternalMessageInfo

func (m *SparkRJob) GetMainRFileUri() string {
	if m != nil {
		return m.MainRFileUri
	}
	return ""
}

func (m *SparkRJob) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *SparkRJob) GetFileUris() []string {
	if m != nil {
		return m.FileUris
	}
	return nil
}

func (m *SparkRJob) GetArchiveUris() []string {
	if m != nil {
		return m.ArchiveUris
	}
	return nil
}

func (m *SparkRJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *SparkRJob) GetLoggingConfig() *LoggingConfig {
	if m != nil {
		return m.LoggingConfig
	}
	return nil
}

// A Dataproc job for running [Presto](https://prestosql.io/) queries.
// **IMPORTANT**: The [Dataproc Presto Optional
// Component](/dataproc/docs/concepts/components/presto) must be enabled when
// the cluster is created to submit a Presto job to the cluster.
type PrestoJob struct {
	// Required. The sequence of Presto queries to execute, specified as
	// either an HCFS file URI or as a list of queries.
	//
	// Types that are valid to be assigned to Queries:
	//	*PrestoJob_QueryFileUri
	//	*PrestoJob_QueryList
	Queries isPrestoJob_Queries `protobuf_oneof:"queries"`
	// Optional. Whether to continue executing queries if a query fails.
	// The default value is `false`. Setting to `true` can be useful when
	// executing independent parallel queries.
	ContinueOnFailure bool `protobuf:"varint,3,opt,name=continue_on_failure,json=continueOnFailure,proto3" json:"continue_on_failure,omitempty"`
	// Optional. The format in which query output will be displayed. See the
	// Presto documentation for supported output formats
	OutputFormat string `protobuf:"bytes,4,opt,name=output_format,json=outputFormat,proto3" json:"output_format,omitempty"`
	// Optional. Presto client tags to attach to this query
	ClientTags []string `protobuf:"bytes,5,rep,name=client_tags,json=clientTags,proto3" json:"client_tags,omitempty"`
	// Optional. A mapping of property names to values. Used to set Presto
	// [session properties](https://prestodb.io/docs/current/sql/set-session.html)
	// Equivalent to using the --session flag in the Presto CLI
	Properties map[string]string `protobuf:"bytes,6,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The runtime log config for job execution.
	LoggingConfig        *LoggingConfig `protobuf:"bytes,7,opt,name=logging_config,json=loggingConfig,proto3" json:"logging_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *PrestoJob) Reset()         { *m = PrestoJob{} }
func (m *PrestoJob) String() string { return proto.CompactTextString(m) }
func (*PrestoJob) ProtoMessage()    {}
func (*PrestoJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{9}
}

func (m *PrestoJob) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PrestoJob.Unmarshal(m, b)
}
func (m *PrestoJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PrestoJob.Marshal(b, m, deterministic)
}
func (m *PrestoJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PrestoJob.Merge(m, src)
}
func (m *PrestoJob) XXX_Size() int {
	return xxx_messageInfo_PrestoJob.Size(m)
}
func (m *PrestoJob) XXX_DiscardUnknown() {
	xxx_messageInfo_PrestoJob.DiscardUnknown(m)
}

var xxx_messageInfo_PrestoJob proto.InternalMessageInfo

type isPrestoJob_Queries interface {
	isPrestoJob_Queries()
}

type PrestoJob_QueryFileUri struct {
	QueryFileUri string `protobuf:"bytes,1,opt,name=query_file_uri,json=queryFileUri,proto3,oneof"`
}

type PrestoJob_QueryList struct {
	QueryList *QueryList `protobuf:"bytes,2,opt,name=query_list,json=queryList,proto3,oneof"`
}

func (*PrestoJob_QueryFileUri) isPrestoJob_Queries() {}

func (*PrestoJob_QueryList) isPrestoJob_Queries() {}

func (m *PrestoJob) GetQueries() isPrestoJob_Queries {
	if m != nil {
		return m.Queries
	}
	return nil
}

func (m *PrestoJob) GetQueryFileUri() string {
	if x, ok := m.GetQueries().(*PrestoJob_QueryFileUri); ok {
		return x.QueryFileUri
	}
	return ""
}

func (m *PrestoJob) GetQueryList() *QueryList {
	if x, ok := m.GetQueries().(*PrestoJob_QueryList); ok {
		return x.QueryList
	}
	return nil
}

func (m *PrestoJob) GetContinueOnFailure() bool {
	if m != nil {
		return m.ContinueOnFailure
	}
	return false
}

func (m *PrestoJob) GetOutputFormat() string {
	if m != nil {
		return m.OutputFormat
	}
	return ""
}

func (m *PrestoJob) GetClientTags() []string {
	if m != nil {
		return m.ClientTags
	}
	return nil
}

func (m *PrestoJob) GetProperties() map[string]string {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *PrestoJob) GetLoggingConfig() *LoggingConfig {
	if m != nil {
		return m.LoggingConfig
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PrestoJob) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PrestoJob_QueryFileUri)(nil),
		(*PrestoJob_QueryList)(nil),
	}
}

// Dataproc job config.
type JobPlacement struct {
	// Required. The name of the cluster where the job will be submitted.
	ClusterName string `protobuf:"bytes,1,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// Output only. A cluster UUID generated by the Dataproc service when
	// the job is submitted.
	ClusterUuid          string   `protobuf:"bytes,2,opt,name=cluster_uuid,json=clusterUuid,proto3" json:"cluster_uuid,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobPlacement) Reset()         { *m = JobPlacement{} }
func (m *JobPlacement) String() string { return proto.CompactTextString(m) }
func (*JobPlacement) ProtoMessage()    {}
func (*JobPlacement) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{10}
}

func (m *JobPlacement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobPlacement.Unmarshal(m, b)
}
func (m *JobPlacement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobPlacement.Marshal(b, m, deterministic)
}
func (m *JobPlacement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobPlacement.Merge(m, src)
}
func (m *JobPlacement) XXX_Size() int {
	return xxx_messageInfo_JobPlacement.Size(m)
}
func (m *JobPlacement) XXX_DiscardUnknown() {
	xxx_messageInfo_JobPlacement.DiscardUnknown(m)
}

var xxx_messageInfo_JobPlacement proto.InternalMessageInfo

func (m *JobPlacement) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *JobPlacement) GetClusterUuid() string {
	if m != nil {
		return m.ClusterUuid
	}
	return ""
}

// Dataproc job status.
type JobStatus struct {
	// Output only. A state message specifying the overall job state.
	State JobStatus_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.dataproc.v1beta2.JobStatus_State" json:"state,omitempty"`
	// Output only. Optional Job state details, such as an error
	// description if the state is <code>ERROR</code>.
	Details string `protobuf:"bytes,2,opt,name=details,proto3" json:"details,omitempty"`
	// Output only. The time when this state was entered.
	StateStartTime *timestamp.Timestamp `protobuf:"bytes,6,opt,name=state_start_time,json=stateStartTime,proto3" json:"state_start_time,omitempty"`
	// Output only. Additional state information, which includes
	// status reported by the agent.
	Substate             JobStatus_Substate `protobuf:"varint,7,opt,name=substate,proto3,enum=google.cloud.dataproc.v1beta2.JobStatus_Substate" json:"substate,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *JobStatus) Reset()         { *m = JobStatus{} }
func (m *JobStatus) String() string { return proto.CompactTextString(m) }
func (*JobStatus) ProtoMessage()    {}
func (*JobStatus) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{11}
}

func (m *JobStatus) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobStatus.Unmarshal(m, b)
}
func (m *JobStatus) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobStatus.Marshal(b, m, deterministic)
}
func (m *JobStatus) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobStatus.Merge(m, src)
}
func (m *JobStatus) XXX_Size() int {
	return xxx_messageInfo_JobStatus.Size(m)
}
func (m *JobStatus) XXX_DiscardUnknown() {
	xxx_messageInfo_JobStatus.DiscardUnknown(m)
}

var xxx_messageInfo_JobStatus proto.InternalMessageInfo

func (m *JobStatus) GetState() JobStatus_State {
	if m != nil {
		return m.State
	}
	return JobStatus_STATE_UNSPECIFIED
}

func (m *JobStatus) GetDetails() string {
	if m != nil {
		return m.Details
	}
	return ""
}

func (m *JobStatus) GetStateStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StateStartTime
	}
	return nil
}

func (m *JobStatus) GetSubstate() JobStatus_Substate {
	if m != nil {
		return m.Substate
	}
	return JobStatus_UNSPECIFIED
}

// Encapsulates the full scoping used to reference a job.
type JobReference struct {
	// Required. The ID of the Google Cloud Platform project that the job
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Optional. The job ID, which must be unique within the project.
	// The ID must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), or hyphens (-). The maximum length is 100 characters.
	//
	// If not specified by the caller, the job ID will be provided by the server.
	JobId                string   `protobuf:"bytes,2,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobReference) Reset()         { *m = JobReference{} }
func (m *JobReference) String() string { return proto.CompactTextString(m) }
func (*JobReference) ProtoMessage()    {}
func (*JobReference) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{12}
}

func (m *JobReference) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobReference.Unmarshal(m, b)
}
func (m *JobReference) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobReference.Marshal(b, m, deterministic)
}
func (m *JobReference) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobReference.Merge(m, src)
}
func (m *JobReference) XXX_Size() int {
	return xxx_messageInfo_JobReference.Size(m)
}
func (m *JobReference) XXX_DiscardUnknown() {
	xxx_messageInfo_JobReference.DiscardUnknown(m)
}

var xxx_messageInfo_JobReference proto.InternalMessageInfo

func (m *JobReference) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *JobReference) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

// A YARN application created by a job. Application information is a subset of
// <code>org.apache.hadoop.yarn.proto.YarnProtos.ApplicationReportProto</code>.
//
// **Beta Feature**: This report is available for testing purposes only. It may
// be changed before final release.
type YarnApplication struct {
	// Output only. The application name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The application state.
	State YarnApplication_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.dataproc.v1beta2.YarnApplication_State" json:"state,omitempty"`
	// Output only. The numerical progress of the application, from 1 to 100.
	Progress float32 `protobuf:"fixed32,3,opt,name=progress,proto3" json:"progress,omitempty"`
	// Output only. The HTTP URL of the ApplicationMaster, HistoryServer, or
	// TimelineServer that provides application-specific information. The URL uses
	// the internal hostname, and requires a proxy server for resolution and,
	// possibly, access.
	TrackingUrl          string   `protobuf:"bytes,4,opt,name=tracking_url,json=trackingUrl,proto3" json:"tracking_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *YarnApplication) Reset()         { *m = YarnApplication{} }
func (m *YarnApplication) String() string { return proto.CompactTextString(m) }
func (*YarnApplication) ProtoMessage()    {}
func (*YarnApplication) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{13}
}

func (m *YarnApplication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_YarnApplication.Unmarshal(m, b)
}
func (m *YarnApplication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_YarnApplication.Marshal(b, m, deterministic)
}
func (m *YarnApplication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_YarnApplication.Merge(m, src)
}
func (m *YarnApplication) XXX_Size() int {
	return xxx_messageInfo_YarnApplication.Size(m)
}
func (m *YarnApplication) XXX_DiscardUnknown() {
	xxx_messageInfo_YarnApplication.DiscardUnknown(m)
}

var xxx_messageInfo_YarnApplication proto.InternalMessageInfo

func (m *YarnApplication) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *YarnApplication) GetState() YarnApplication_State {
	if m != nil {
		return m.State
	}
	return YarnApplication_STATE_UNSPECIFIED
}

func (m *YarnApplication) GetProgress() float32 {
	if m != nil {
		return m.Progress
	}
	return 0
}

func (m *YarnApplication) GetTrackingUrl() string {
	if m != nil {
		return m.TrackingUrl
	}
	return ""
}

// A Dataproc job resource.
type Job struct {
	// Optional. The fully qualified reference to the job, which can be used to
	// obtain the equivalent REST path of the job resource. If this property
	// is not specified when a job is created, the server generates a
	// <code>job_id</code>.
	Reference *JobReference `protobuf:"bytes,1,opt,name=reference,proto3" json:"reference,omitempty"`
	// Required. Job information, including how, when, and where to
	// run the job.
	Placement *JobPlacement `protobuf:"bytes,2,opt,name=placement,proto3" json:"placement,omitempty"`
	// Required. The application/framework-specific portion of the job.
	//
	// Types that are valid to be assigned to TypeJob:
	//	*Job_HadoopJob
	//	*Job_SparkJob
	//	*Job_PysparkJob
	//	*Job_HiveJob
	//	*Job_PigJob
	//	*Job_SparkRJob
	//	*Job_SparkSqlJob
	//	*Job_PrestoJob
	TypeJob isJob_TypeJob `protobuf_oneof:"type_job"`
	// Output only. The job status. Additional application-specific
	// status information may be contained in the <code>type_job</code>
	// and <code>yarn_applications</code> fields.
	Status *JobStatus `protobuf:"bytes,8,opt,name=status,proto3" json:"status,omitempty"`
	// Output only. The previous job status.
	StatusHistory []*JobStatus `protobuf:"bytes,13,rep,name=status_history,json=statusHistory,proto3" json:"status_history,omitempty"`
	// Output only. The collection of YARN applications spun up by this job.
	//
	// **Beta** Feature: This report is available for testing purposes only. It
	// may be changed before final release.
	YarnApplications []*YarnApplication `protobuf:"bytes,9,rep,name=yarn_applications,json=yarnApplications,proto3" json:"yarn_applications,omitempty"`
	// Output only. The email address of the user submitting the job. For jobs
	// submitted on the cluster, the address is <code>username@hostname</code>.
	SubmittedBy string `protobuf:"bytes,10,opt,name=submitted_by,json=submittedBy,proto3" json:"submitted_by,omitempty"`
	// Output only. A URI pointing to the location of the stdout of the job's
	// driver program.
	DriverOutputResourceUri string `protobuf:"bytes,17,opt,name=driver_output_resource_uri,json=driverOutputResourceUri,proto3" json:"driver_output_resource_uri,omitempty"`
	// Output only. If present, the location of miscellaneous control files
	// which may be used as part of job setup and handling. If not present,
	// control files may be placed in the same location as `driver_output_uri`.
	DriverControlFilesUri string `protobuf:"bytes,15,opt,name=driver_control_files_uri,json=driverControlFilesUri,proto3" json:"driver_control_files_uri,omitempty"`
	// Optional. The labels to associate with this job.
	// Label **keys** must contain 1 to 63 characters, and must conform to
	// [RFC 1035](https://www.ietf.org/rfc/rfc1035.txt).
	// Label **values** may be empty, but, if present, must contain 1 to 63
	// characters, and must conform to [RFC
	// 1035](https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be
	// associated with a job.
	Labels map[string]string `protobuf:"bytes,18,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Job scheduling configuration.
	Scheduling *JobScheduling `protobuf:"bytes,20,opt,name=scheduling,proto3" json:"scheduling,omitempty"`
	// Output only. A UUID that uniquely identifies a job within the project
	// over time. This is in contrast to a user-settable reference.job_id that
	// may be reused over time.
	JobUuid string `protobuf:"bytes,22,opt,name=job_uuid,json=jobUuid,proto3" json:"job_uuid,omitempty"`
	// Output only. Indicates whether the job is completed. If the value is `false`,
	// the job is still in progress. If `true`, the job is completed, and
	// `status.state` field will indicate if it was successful, failed,
	// or cancelled.
	Done                 bool     `protobuf:"varint,24,opt,name=done,proto3" json:"done,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Job) Reset()         { *m = Job{} }
func (m *Job) String() string { return proto.CompactTextString(m) }
func (*Job) ProtoMessage()    {}
func (*Job) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{14}
}

func (m *Job) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Job.Unmarshal(m, b)
}
func (m *Job) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Job.Marshal(b, m, deterministic)
}
func (m *Job) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Job.Merge(m, src)
}
func (m *Job) XXX_Size() int {
	return xxx_messageInfo_Job.Size(m)
}
func (m *Job) XXX_DiscardUnknown() {
	xxx_messageInfo_Job.DiscardUnknown(m)
}

var xxx_messageInfo_Job proto.InternalMessageInfo

func (m *Job) GetReference() *JobReference {
	if m != nil {
		return m.Reference
	}
	return nil
}

func (m *Job) GetPlacement() *JobPlacement {
	if m != nil {
		return m.Placement
	}
	return nil
}

type isJob_TypeJob interface {
	isJob_TypeJob()
}

type Job_HadoopJob struct {
	HadoopJob *HadoopJob `protobuf:"bytes,3,opt,name=hadoop_job,json=hadoopJob,proto3,oneof"`
}

type Job_SparkJob struct {
	SparkJob *SparkJob `protobuf:"bytes,4,opt,name=spark_job,json=sparkJob,proto3,oneof"`
}

type Job_PysparkJob struct {
	PysparkJob *PySparkJob `protobuf:"bytes,5,opt,name=pyspark_job,json=pysparkJob,proto3,oneof"`
}

type Job_HiveJob struct {
	HiveJob *HiveJob `protobuf:"bytes,6,opt,name=hive_job,json=hiveJob,proto3,oneof"`
}

type Job_PigJob struct {
	PigJob *PigJob `protobuf:"bytes,7,opt,name=pig_job,json=pigJob,proto3,oneof"`
}

type Job_SparkRJob struct {
	SparkRJob *SparkRJob `protobuf:"bytes,21,opt,name=spark_r_job,json=sparkRJob,proto3,oneof"`
}

type Job_SparkSqlJob struct {
	SparkSqlJob *SparkSqlJob `protobuf:"bytes,12,opt,name=spark_sql_job,json=sparkSqlJob,proto3,oneof"`
}

type Job_PrestoJob struct {
	PrestoJob *PrestoJob `protobuf:"bytes,23,opt,name=presto_job,json=prestoJob,proto3,oneof"`
}

func (*Job_HadoopJob) isJob_TypeJob() {}

func (*Job_SparkJob) isJob_TypeJob() {}

func (*Job_PysparkJob) isJob_TypeJob() {}

func (*Job_HiveJob) isJob_TypeJob() {}

func (*Job_PigJob) isJob_TypeJob() {}

func (*Job_SparkRJob) isJob_TypeJob() {}

func (*Job_SparkSqlJob) isJob_TypeJob() {}

func (*Job_PrestoJob) isJob_TypeJob() {}

func (m *Job) GetTypeJob() isJob_TypeJob {
	if m != nil {
		return m.TypeJob
	}
	return nil
}

func (m *Job) GetHadoopJob() *HadoopJob {
	if x, ok := m.GetTypeJob().(*Job_HadoopJob); ok {
		return x.HadoopJob
	}
	return nil
}

func (m *Job) GetSparkJob() *SparkJob {
	if x, ok := m.GetTypeJob().(*Job_SparkJob); ok {
		return x.SparkJob
	}
	return nil
}

func (m *Job) GetPysparkJob() *PySparkJob {
	if x, ok := m.GetTypeJob().(*Job_PysparkJob); ok {
		return x.PysparkJob
	}
	return nil
}

func (m *Job) GetHiveJob() *HiveJob {
	if x, ok := m.GetTypeJob().(*Job_HiveJob); ok {
		return x.HiveJob
	}
	return nil
}

func (m *Job) GetPigJob() *PigJob {
	if x, ok := m.GetTypeJob().(*Job_PigJob); ok {
		return x.PigJob
	}
	return nil
}

func (m *Job) GetSparkRJob() *SparkRJob {
	if x, ok := m.GetTypeJob().(*Job_SparkRJob); ok {
		return x.SparkRJob
	}
	return nil
}

func (m *Job) GetSparkSqlJob() *SparkSqlJob {
	if x, ok := m.GetTypeJob().(*Job_SparkSqlJob); ok {
		return x.SparkSqlJob
	}
	return nil
}

func (m *Job) GetPrestoJob() *PrestoJob {
	if x, ok := m.GetTypeJob().(*Job_PrestoJob); ok {
		return x.PrestoJob
	}
	return nil
}

func (m *Job) GetStatus() *JobStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *Job) GetStatusHistory() []*JobStatus {
	if m != nil {
		return m.StatusHistory
	}
	return nil
}

func (m *Job) GetYarnApplications() []*YarnApplication {
	if m != nil {
		return m.YarnApplications
	}
	return nil
}

func (m *Job) GetSubmittedBy() string {
	if m != nil {
		return m.SubmittedBy
	}
	return ""
}

func (m *Job) GetDriverOutputResourceUri() string {
	if m != nil {
		return m.DriverOutputResourceUri
	}
	return ""
}

func (m *Job) GetDriverControlFilesUri() string {
	if m != nil {
		return m.DriverControlFilesUri
	}
	return ""
}

func (m *Job) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *Job) GetScheduling() *JobScheduling {
	if m != nil {
		return m.Scheduling
	}
	return nil
}

func (m *Job) GetJobUuid() string {
	if m != nil {
		return m.JobUuid
	}
	return ""
}

func (m *Job) GetDone() bool {
	if m != nil {
		return m.Done
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Job) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Job_HadoopJob)(nil),
		(*Job_SparkJob)(nil),
		(*Job_PysparkJob)(nil),
		(*Job_HiveJob)(nil),
		(*Job_PigJob)(nil),
		(*Job_SparkRJob)(nil),
		(*Job_SparkSqlJob)(nil),
		(*Job_PrestoJob)(nil),
	}
}

// Job scheduling options.
type JobScheduling struct {
	// Optional. Maximum number of times per hour a driver may be restarted as
	// a result of driver terminating with non-zero code before job is
	// reported failed.
	//
	// A job may be reported as thrashing if driver exits with non-zero code
	// 4 times within 10 minute window.
	//
	// Maximum value is 10.
	MaxFailuresPerHour   int32    `protobuf:"varint,1,opt,name=max_failures_per_hour,json=maxFailuresPerHour,proto3" json:"max_failures_per_hour,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *JobScheduling) Reset()         { *m = JobScheduling{} }
func (m *JobScheduling) String() string { return proto.CompactTextString(m) }
func (*JobScheduling) ProtoMessage()    {}
func (*JobScheduling) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{15}
}

func (m *JobScheduling) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobScheduling.Unmarshal(m, b)
}
func (m *JobScheduling) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobScheduling.Marshal(b, m, deterministic)
}
func (m *JobScheduling) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobScheduling.Merge(m, src)
}
func (m *JobScheduling) XXX_Size() int {
	return xxx_messageInfo_JobScheduling.Size(m)
}
func (m *JobScheduling) XXX_DiscardUnknown() {
	xxx_messageInfo_JobScheduling.DiscardUnknown(m)
}

var xxx_messageInfo_JobScheduling proto.InternalMessageInfo

func (m *JobScheduling) GetMaxFailuresPerHour() int32 {
	if m != nil {
		return m.MaxFailuresPerHour
	}
	return 0
}

// Job Operation metadata.
type JobMetadata struct {
	// Output only. The job id.
	JobId string `protobuf:"bytes,1,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// Output only. Most recent job status.
	Status *JobStatus `protobuf:"bytes,2,opt,name=status,proto3" json:"status,omitempty"`
	// Output only. Operation type.
	OperationType string `protobuf:"bytes,3,opt,name=operation_type,json=operationType,proto3" json:"operation_type,omitempty"`
	// Output only. Job submission time.
	StartTime            *timestamp.Timestamp `protobuf:"bytes,4,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *JobMetadata) Reset()         { *m = JobMetadata{} }
func (m *JobMetadata) String() string { return proto.CompactTextString(m) }
func (*JobMetadata) ProtoMessage()    {}
func (*JobMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{16}
}

func (m *JobMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_JobMetadata.Unmarshal(m, b)
}
func (m *JobMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_JobMetadata.Marshal(b, m, deterministic)
}
func (m *JobMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_JobMetadata.Merge(m, src)
}
func (m *JobMetadata) XXX_Size() int {
	return xxx_messageInfo_JobMetadata.Size(m)
}
func (m *JobMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_JobMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_JobMetadata proto.InternalMessageInfo

func (m *JobMetadata) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

func (m *JobMetadata) GetStatus() *JobStatus {
	if m != nil {
		return m.Status
	}
	return nil
}

func (m *JobMetadata) GetOperationType() string {
	if m != nil {
		return m.OperationType
	}
	return ""
}

func (m *JobMetadata) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

// A request to submit a job.
type SubmitJobRequest struct {
	// Required. The ID of the Google Cloud Platform project that the job
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	// Required. The job resource.
	Job *Job `protobuf:"bytes,2,opt,name=job,proto3" json:"job,omitempty"`
	// Optional. A unique id used to identify the request. If the server
	// receives two [SubmitJobRequest][google.cloud.dataproc.v1beta2.SubmitJobRequest] requests  with the same
	// id, then the second request will be ignored and the
	// first [Job][google.cloud.dataproc.v1beta2.Job] created and stored in the backend
	// is returned.
	//
	// It is recommended to always set this value to a
	// [UUID](https://en.wikipedia.org/wiki/Universally_unique_identifier).
	//
	// The id must contain only letters (a-z, A-Z), numbers (0-9),
	// underscores (_), and hyphens (-). The maximum length is 40 characters.
	RequestId            string   `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SubmitJobRequest) Reset()         { *m = SubmitJobRequest{} }
func (m *SubmitJobRequest) String() string { return proto.CompactTextString(m) }
func (*SubmitJobRequest) ProtoMessage()    {}
func (*SubmitJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{17}
}

func (m *SubmitJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SubmitJobRequest.Unmarshal(m, b)
}
func (m *SubmitJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SubmitJobRequest.Marshal(b, m, deterministic)
}
func (m *SubmitJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SubmitJobRequest.Merge(m, src)
}
func (m *SubmitJobRequest) XXX_Size() int {
	return xxx_messageInfo_SubmitJobRequest.Size(m)
}
func (m *SubmitJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SubmitJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SubmitJobRequest proto.InternalMessageInfo

func (m *SubmitJobRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *SubmitJobRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *SubmitJobRequest) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

func (m *SubmitJobRequest) GetRequestId() string {
	if m != nil {
		return m.RequestId
	}
	return ""
}

// A request to get the resource representation for a job in a project.
type GetJobRequest struct {
	// Required. The ID of the Google Cloud Platform project that the job
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	// Required. The job ID.
	JobId                string   `protobuf:"bytes,2,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetJobRequest) Reset()         { *m = GetJobRequest{} }
func (m *GetJobRequest) String() string { return proto.CompactTextString(m) }
func (*GetJobRequest) ProtoMessage()    {}
func (*GetJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{18}
}

func (m *GetJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobRequest.Unmarshal(m, b)
}
func (m *GetJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobRequest.Marshal(b, m, deterministic)
}
func (m *GetJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobRequest.Merge(m, src)
}
func (m *GetJobRequest) XXX_Size() int {
	return xxx_messageInfo_GetJobRequest.Size(m)
}
func (m *GetJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobRequest proto.InternalMessageInfo

func (m *GetJobRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetJobRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *GetJobRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

// A request to list jobs in a project.
type ListJobsRequest struct {
	// Required. The ID of the Google Cloud Platform project that the job
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,6,opt,name=region,proto3" json:"region,omitempty"`
	// Optional. The number of results to return in each response.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The page token, returned by a previous call, to request the
	// next page of results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. If set, the returned jobs list includes only jobs that were
	// submitted to the named cluster.
	ClusterName string `protobuf:"bytes,4,opt,name=cluster_name,json=clusterName,proto3" json:"cluster_name,omitempty"`
	// Optional. Specifies enumerated categories of jobs to list.
	// (default = match ALL jobs).
	//
	// If `filter` is provided, `jobStateMatcher` will be ignored.
	JobStateMatcher ListJobsRequest_JobStateMatcher `protobuf:"varint,5,opt,name=job_state_matcher,json=jobStateMatcher,proto3,enum=google.cloud.dataproc.v1beta2.ListJobsRequest_JobStateMatcher" json:"job_state_matcher,omitempty"`
	// Optional. A filter constraining the jobs to list. Filters are
	// case-sensitive and have the following syntax:
	//
	// [field = value] AND [field [= value]] ...
	//
	// where **field** is `status.state` or `labels.[KEY]`, and `[KEY]` is a label
	// key. **value** can be `*` to match all values.
	// `status.state` can be either `ACTIVE` or `NON_ACTIVE`.
	// Only the logical `AND` operator is supported; space-separated items are
	// treated as having an implicit `AND` operator.
	//
	// Example filter:
	//
	// status.state = ACTIVE AND labels.env = staging AND labels.starred = *
	Filter               string   `protobuf:"bytes,7,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListJobsRequest) Reset()         { *m = ListJobsRequest{} }
func (m *ListJobsRequest) String() string { return proto.CompactTextString(m) }
func (*ListJobsRequest) ProtoMessage()    {}
func (*ListJobsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{19}
}

func (m *ListJobsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListJobsRequest.Unmarshal(m, b)
}
func (m *ListJobsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListJobsRequest.Marshal(b, m, deterministic)
}
func (m *ListJobsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListJobsRequest.Merge(m, src)
}
func (m *ListJobsRequest) XXX_Size() int {
	return xxx_messageInfo_ListJobsRequest.Size(m)
}
func (m *ListJobsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListJobsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListJobsRequest proto.InternalMessageInfo

func (m *ListJobsRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListJobsRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *ListJobsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListJobsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListJobsRequest) GetClusterName() string {
	if m != nil {
		return m.ClusterName
	}
	return ""
}

func (m *ListJobsRequest) GetJobStateMatcher() ListJobsRequest_JobStateMatcher {
	if m != nil {
		return m.JobStateMatcher
	}
	return ListJobsRequest_ALL
}

func (m *ListJobsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// A request to update a job.
type UpdateJobRequest struct {
	// Required. The ID of the Google Cloud Platform project that the job
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,2,opt,name=region,proto3" json:"region,omitempty"`
	// Required. The job ID.
	JobId string `protobuf:"bytes,3,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	// Required. The changes to the job.
	Job *Job `protobuf:"bytes,4,opt,name=job,proto3" json:"job,omitempty"`
	// Required. Specifies the path, relative to <code>Job</code>, of
	// the field to update. For example, to update the labels of a Job the
	// <code>update_mask</code> parameter would be specified as
	// <code>labels</code>, and the `PATCH` request body would specify the new
	// value. <strong>Note:</strong> Currently, <code>labels</code> is the only
	// field that can be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,5,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateJobRequest) Reset()         { *m = UpdateJobRequest{} }
func (m *UpdateJobRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateJobRequest) ProtoMessage()    {}
func (*UpdateJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{20}
}

func (m *UpdateJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateJobRequest.Unmarshal(m, b)
}
func (m *UpdateJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateJobRequest.Marshal(b, m, deterministic)
}
func (m *UpdateJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateJobRequest.Merge(m, src)
}
func (m *UpdateJobRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateJobRequest.Size(m)
}
func (m *UpdateJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateJobRequest proto.InternalMessageInfo

func (m *UpdateJobRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *UpdateJobRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *UpdateJobRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

func (m *UpdateJobRequest) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

func (m *UpdateJobRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// A list of jobs in a project.
type ListJobsResponse struct {
	// Output only. Jobs list.
	Jobs []*Job `protobuf:"bytes,1,rep,name=jobs,proto3" json:"jobs,omitempty"`
	// Optional. This token is included in the response if there are more results
	// to fetch. To fetch additional results, provide this value as the
	// `page_token` in a subsequent <code>ListJobsRequest</code>.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListJobsResponse) Reset()         { *m = ListJobsResponse{} }
func (m *ListJobsResponse) String() string { return proto.CompactTextString(m) }
func (*ListJobsResponse) ProtoMessage()    {}
func (*ListJobsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{21}
}

func (m *ListJobsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListJobsResponse.Unmarshal(m, b)
}
func (m *ListJobsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListJobsResponse.Marshal(b, m, deterministic)
}
func (m *ListJobsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListJobsResponse.Merge(m, src)
}
func (m *ListJobsResponse) XXX_Size() int {
	return xxx_messageInfo_ListJobsResponse.Size(m)
}
func (m *ListJobsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListJobsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListJobsResponse proto.InternalMessageInfo

func (m *ListJobsResponse) GetJobs() []*Job {
	if m != nil {
		return m.Jobs
	}
	return nil
}

func (m *ListJobsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to cancel a job.
type CancelJobRequest struct {
	// Required. The ID of the Google Cloud Platform project that the job
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	// Required. The job ID.
	JobId                string   `protobuf:"bytes,2,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CancelJobRequest) Reset()         { *m = CancelJobRequest{} }
func (m *CancelJobRequest) String() string { return proto.CompactTextString(m) }
func (*CancelJobRequest) ProtoMessage()    {}
func (*CancelJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{22}
}

func (m *CancelJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CancelJobRequest.Unmarshal(m, b)
}
func (m *CancelJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CancelJobRequest.Marshal(b, m, deterministic)
}
func (m *CancelJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CancelJobRequest.Merge(m, src)
}
func (m *CancelJobRequest) XXX_Size() int {
	return xxx_messageInfo_CancelJobRequest.Size(m)
}
func (m *CancelJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CancelJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CancelJobRequest proto.InternalMessageInfo

func (m *CancelJobRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *CancelJobRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *CancelJobRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

// A request to delete a job.
type DeleteJobRequest struct {
	// Required. The ID of the Google Cloud Platform project that the job
	// belongs to.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Required. The Dataproc region in which to handle the request.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
	// Required. The job ID.
	JobId                string   `protobuf:"bytes,2,opt,name=job_id,json=jobId,proto3" json:"job_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteJobRequest) Reset()         { *m = DeleteJobRequest{} }
func (m *DeleteJobRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteJobRequest) ProtoMessage()    {}
func (*DeleteJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_20fb118582e1d7de, []int{23}
}

func (m *DeleteJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteJobRequest.Unmarshal(m, b)
}
func (m *DeleteJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteJobRequest.Marshal(b, m, deterministic)
}
func (m *DeleteJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteJobRequest.Merge(m, src)
}
func (m *DeleteJobRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteJobRequest.Size(m)
}
func (m *DeleteJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteJobRequest proto.InternalMessageInfo

func (m *DeleteJobRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *DeleteJobRequest) GetRegion() string {
	if m != nil {
		return m.Region
	}
	return ""
}

func (m *DeleteJobRequest) GetJobId() string {
	if m != nil {
		return m.JobId
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.dataproc.v1beta2.LoggingConfig_Level", LoggingConfig_Level_name, LoggingConfig_Level_value)
	proto.RegisterEnum("google.cloud.dataproc.v1beta2.JobStatus_State", JobStatus_State_name, JobStatus_State_value)
	proto.RegisterEnum("google.cloud.dataproc.v1beta2.JobStatus_Substate", JobStatus_Substate_name, JobStatus_Substate_value)
	proto.RegisterEnum("google.cloud.dataproc.v1beta2.YarnApplication_State", YarnApplication_State_name, YarnApplication_State_value)
	proto.RegisterEnum("google.cloud.dataproc.v1beta2.ListJobsRequest_JobStateMatcher", ListJobsRequest_JobStateMatcher_name, ListJobsRequest_JobStateMatcher_value)
	proto.RegisterType((*LoggingConfig)(nil), "google.cloud.dataproc.v1beta2.LoggingConfig")
	proto.RegisterMapType((map[string]LoggingConfig_Level)(nil), "google.cloud.dataproc.v1beta2.LoggingConfig.DriverLogLevelsEntry")
	proto.RegisterType((*HadoopJob)(nil), "google.cloud.dataproc.v1beta2.HadoopJob")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.HadoopJob.PropertiesEntry")
	proto.RegisterType((*SparkJob)(nil), "google.cloud.dataproc.v1beta2.SparkJob")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.SparkJob.PropertiesEntry")
	proto.RegisterType((*PySparkJob)(nil), "google.cloud.dataproc.v1beta2.PySparkJob")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.PySparkJob.PropertiesEntry")
	proto.RegisterType((*QueryList)(nil), "google.cloud.dataproc.v1beta2.QueryList")
	proto.RegisterType((*HiveJob)(nil), "google.cloud.dataproc.v1beta2.HiveJob")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.HiveJob.PropertiesEntry")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.HiveJob.ScriptVariablesEntry")
	proto.RegisterType((*SparkSqlJob)(nil), "google.cloud.dataproc.v1beta2.SparkSqlJob")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.SparkSqlJob.PropertiesEntry")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.SparkSqlJob.ScriptVariablesEntry")
	proto.RegisterType((*PigJob)(nil), "google.cloud.dataproc.v1beta2.PigJob")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.PigJob.PropertiesEntry")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.PigJob.ScriptVariablesEntry")
	proto.RegisterType((*SparkRJob)(nil), "google.cloud.dataproc.v1beta2.SparkRJob")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.SparkRJob.PropertiesEntry")
	proto.RegisterType((*PrestoJob)(nil), "google.cloud.dataproc.v1beta2.PrestoJob")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.PrestoJob.PropertiesEntry")
	proto.RegisterType((*JobPlacement)(nil), "google.cloud.dataproc.v1beta2.JobPlacement")
	proto.RegisterType((*JobStatus)(nil), "google.cloud.dataproc.v1beta2.JobStatus")
	proto.RegisterType((*JobReference)(nil), "google.cloud.dataproc.v1beta2.JobReference")
	proto.RegisterType((*YarnApplication)(nil), "google.cloud.dataproc.v1beta2.YarnApplication")
	proto.RegisterType((*Job)(nil), "google.cloud.dataproc.v1beta2.Job")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.dataproc.v1beta2.Job.LabelsEntry")
	proto.RegisterType((*JobScheduling)(nil), "google.cloud.dataproc.v1beta2.JobScheduling")
	proto.RegisterType((*JobMetadata)(nil), "google.cloud.dataproc.v1beta2.JobMetadata")
	proto.RegisterType((*SubmitJobRequest)(nil), "google.cloud.dataproc.v1beta2.SubmitJobRequest")
	proto.RegisterType((*GetJobRequest)(nil), "google.cloud.dataproc.v1beta2.GetJobRequest")
	proto.RegisterType((*ListJobsRequest)(nil), "google.cloud.dataproc.v1beta2.ListJobsRequest")
	proto.RegisterType((*UpdateJobRequest)(nil), "google.cloud.dataproc.v1beta2.UpdateJobRequest")
	proto.RegisterType((*ListJobsResponse)(nil), "google.cloud.dataproc.v1beta2.ListJobsResponse")
	proto.RegisterType((*CancelJobRequest)(nil), "google.cloud.dataproc.v1beta2.CancelJobRequest")
	proto.RegisterType((*DeleteJobRequest)(nil), "google.cloud.dataproc.v1beta2.DeleteJobRequest")
}

func init() {
	proto.RegisterFile("google/cloud/dataproc/v1beta2/jobs.proto", fileDescriptor_20fb118582e1d7de)
}

var fileDescriptor_20fb118582e1d7de = []byte{
	// 2787 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xdc, 0x5a, 0xcf, 0x73, 0x23, 0x47,
	0xf5, 0xcf, 0x68, 0x24, 0x59, 0xf3, 0xe4, 0x1f, 0xe3, 0xce, 0x6e, 0x56, 0xa5, 0x7c, 0xf3, 0x8d,
	0x19, 0x20, 0x31, 0x9b, 0x44, 0xaa, 0x38, 0x61, 0x49, 0x76, 0xc9, 0x0f, 0xd9, 0x1e, 0xaf, 0xe5,
	0xd5, 0xca, 0xda, 0x91, 0xb4, 0x81, 0x00, 0x99, 0x8c, 0xa4, 0xb6, 0x3c, 0xf6, 0x68, 0x7a, 0x76,
	0x66, 0xe4, 0x8d, 0x12, 0x52, 0x45, 0x71, 0x08, 0x05, 0x47, 0xf8, 0x2b, 0xa8, 0xe2, 0x94, 0x13,
	0x27, 0x0e, 0x1c, 0x73, 0xc8, 0x01, 0x6e, 0x81, 0x03, 0x55, 0x90, 0x0a, 0x54, 0x71, 0xe6, 0x4c,
	0x75, 0xf7, 0xcc, 0x68, 0x24, 0x7b, 0xa3, 0x91, 0x9d, 0x22, 0xc9, 0x9e, 0x2c, 0xbf, 0x7e, 0xef,
	0xd3, 0xef, 0xf5, 0xfb, 0xf4, 0xeb, 0xd7, 0x2d, 0xc1, 0x7a, 0x9f, 0x90, 0xbe, 0x85, 0xcb, 0x5d,
	0x8b, 0x0c, 0x7b, 0xe5, 0x9e, 0xe1, 0x1b, 0x8e, 0x4b, 0xba, 0xe5, 0x93, 0xe7, 0x3b, 0xd8, 0x37,
	0x36, 0xca, 0x47, 0xa4, 0xe3, 0x95, 0x1c, 0x97, 0xf8, 0x04, 0x3d, 0xc1, 0x35, 0x4b, 0x4c, 0xb3,
	0x14, 0x6a, 0x96, 0x02, 0xcd, 0xe2, 0xff, 0x05, 0x40, 0x86, 0x63, 0x96, 0x0d, 0xdb, 0x26, 0xbe,
	0xe1, 0x9b, 0xc4, 0x0e, 0x8c, 0x8b, 0x57, 0x62, 0xa3, 0x5d, 0xcb, 0xc4, 0xb6, 0x1f, 0x0c, 0x3c,
	0x19, 0x1b, 0x38, 0x30, 0xb1, 0xd5, 0xd3, 0x3b, 0xf8, 0xd0, 0x38, 0x31, 0x89, 0x1b, 0x28, 0x7c,
	0x33, 0x50, 0xb0, 0x88, 0xdd, 0x77, 0x87, 0xb6, 0x6d, 0xda, 0xfd, 0x32, 0x71, 0xb0, 0x3b, 0x01,
	0xff, 0x78, 0xa0, 0xc4, 0xfe, 0xeb, 0x0c, 0x0f, 0xca, 0x78, 0xe0, 0xf8, 0xa3, 0x60, 0x70, 0x6d,
	0x7a, 0x90, 0xcf, 0x33, 0x30, 0xbc, 0xe3, 0x29, 0x27, 0x22, 0x0d, 0xdf, 0x1c, 0x60, 0xcf, 0x37,
	0x06, 0x0e, 0x57, 0x50, 0xfe, 0x99, 0x82, 0xa5, 0x1a, 0xe9, 0xf7, 0x4d, 0xbb, 0xbf, 0x45, 0xec,
	0x03, 0xb3, 0x8f, 0x06, 0xb0, 0xda, 0x73, 0xcd, 0x13, 0xec, 0xea, 0x16, 0xe9, 0xeb, 0x16, 0x3e,
	0xc1, 0x96, 0x57, 0x48, 0xad, 0x89, 0xeb, 0xf9, 0x8d, 0x4a, 0xe9, 0x73, 0x57, 0xaa, 0x34, 0x01,
	0x54, 0xda, 0x66, 0x28, 0x35, 0xd2, 0xaf, 0x31, 0x0c, 0xd5, 0xf6, 0xdd, 0x91, 0xb6, 0xd2, 0x9b,
	0x94, 0x16, 0x4f, 0xe0, 0xd2, 0x59, 0x8a, 0x48, 0x06, 0xf1, 0x18, 0x8f, 0x0a, 0xc2, 0x9a, 0xb0,
	0x2e, 0x69, 0xf4, 0x23, 0xda, 0x85, 0xcc, 0x89, 0x61, 0x0d, 0x71, 0x21, 0xb5, 0x26, 0xac, 0x2f,
	0x6f, 0x6c, 0xcc, 0xe5, 0x0c, 0x83, 0xd6, 0x38, 0xc0, 0xf5, 0xd4, 0x4b, 0x82, 0xe2, 0x40, 0x86,
	0xc9, 0xd0, 0x65, 0x58, 0xad, 0xa9, 0x77, 0xd5, 0x9a, 0xde, 0xae, 0x37, 0x1b, 0xea, 0x56, 0x75,
	0xa7, 0xaa, 0x6e, 0xcb, 0x8f, 0xa0, 0x05, 0x10, 0x2b, 0xb5, 0x9a, 0x2c, 0x20, 0x09, 0x32, 0x2d,
	0xad, 0xb2, 0xa5, 0xca, 0x29, 0xfa, 0x71, 0x5b, 0xdd, 0x6c, 0xdf, 0x94, 0x45, 0x94, 0x83, 0x74,
	0xb5, 0xbe, 0xb3, 0x2f, 0xa7, 0xe9, 0xa7, 0x37, 0x2a, 0x5a, 0x5d, 0xce, 0xd0, 0x61, 0x55, 0xd3,
	0xf6, 0x35, 0x39, 0x4b, 0x3f, 0xee, 0x54, 0x5a, 0x95, 0x9a, 0xbc, 0x40, 0x81, 0xf6, 0x77, 0x76,
	0xe4, 0x9c, 0xf2, 0x99, 0x08, 0xd2, 0xae, 0xd1, 0x23, 0xc4, 0xd9, 0x23, 0x1d, 0xf4, 0x0c, 0xac,
	0x0e, 0x0c, 0xd3, 0xd6, 0x8f, 0x0c, 0x57, 0x3f, 0x30, 0x2d, 0xac, 0x0f, 0x5d, 0x93, 0x47, 0xbb,
	0xfb, 0x88, 0xb6, 0x4c, 0x87, 0xf6, 0x0c, 0x77, 0xc7, 0xb4, 0x70, 0xdb, 0x35, 0xd1, 0x93, 0x00,
	0x4c, 0xb9, 0x6b, 0x19, 0x9e, 0xc7, 0xe2, 0xa7, 0x5a, 0x12, 0x95, 0x6d, 0x51, 0x11, 0xba, 0x02,
	0x69, 0xc3, 0xed, 0x7b, 0x05, 0x71, 0x4d, 0x5c, 0x97, 0x36, 0xc5, 0xbf, 0x55, 0x04, 0x8d, 0x09,
	0xd0, 0xd3, 0xb0, 0x14, 0x9f, 0xc1, 0x2b, 0xa4, 0xc7, 0x1a, 0xf9, 0xa3, 0x68, 0x06, 0x0f, 0xad,
	0x81, 0x34, 0x56, 0xca, 0x8c, 0x95, 0x72, 0x07, 0xa1, 0xc6, 0x53, 0xb0, 0x68, 0xb8, 0xdd, 0x43,
	0xf3, 0x24, 0x50, 0xca, 0xc6, 0x90, 0x82, 0x01, 0xa6, 0xf7, 0x13, 0x00, 0xc7, 0xa5, 0x44, 0xf6,
	0x4d, 0xec, 0x15, 0x16, 0x18, 0x73, 0x5e, 0x9a, 0x91, 0xac, 0x68, 0x5d, 0x4a, 0x8d, 0xc8, 0x94,
	0xf1, 0x80, 0xe3, 0xc7, 0x00, 0xd1, 0x0f, 0x60, 0xd9, 0xe2, 0xa9, 0xd5, 0xbb, 0x2c, 0xb7, 0x85,
	0xdc, 0x9a, 0xb0, 0x9e, 0xdf, 0x78, 0x76, 0x1e, 0x3e, 0x70, 0xd8, 0x25, 0x2b, 0x2e, 0x2b, 0xbe,
	0x02, 0x2b, 0x53, 0xb3, 0x9f, 0xc1, 0xc2, 0x4b, 0x71, 0x16, 0x4a, 0x31, 0x46, 0x6d, 0xe6, 0x20,
	0xcb, 0xc9, 0xad, 0x7c, 0x2a, 0x42, 0xae, 0xe9, 0x18, 0xee, 0xf1, 0xc3, 0x9d, 0xe8, 0x1f, 0x9f,
	0x91, 0xe8, 0xef, 0xcd, 0xc8, 0x42, 0xb8, 0x2c, 0x0f, 0x45, 0x9e, 0xff, 0x23, 0x02, 0x34, 0x46,
	0x51, 0xa6, 0x5f, 0x84, 0x4b, 0x2c, 0x79, 0xce, 0xc8, 0x3f, 0x24, 0xf6, 0x54, 0xb2, 0xa9, 0x27,
	0x29, 0x8d, 0x51, 0xa1, 0xc1, 0xc6, 0xc3, 0x94, 0x87, 0x19, 0x4d, 0x4d, 0x67, 0xf4, 0x39, 0x90,
	0xa7, 0x90, 0x26, 0xd2, 0xbe, 0xec, 0xc4, 0x61, 0xbe, 0x14, 0x02, 0xbc, 0x75, 0x06, 0x01, 0x5e,
	0x9e, 0x91, 0x9e, 0xf1, 0x7a, 0x7d, 0x7d, 0x29, 0xa0, 0x5c, 0x05, 0xe9, 0xce, 0x10, 0xbb, 0xa3,
	0x9a, 0xe9, 0xf9, 0xe8, 0x09, 0x58, 0xb8, 0x37, 0xc4, 0x2e, 0x5d, 0x02, 0x21, 0x5c, 0xa8, 0x94,
	0x16, 0xca, 0x94, 0x0f, 0xd3, 0xb0, 0xb0, 0x6b, 0x9e, 0x60, 0xca, 0x90, 0xa7, 0x60, 0x99, 0x8a,
	0x47, 0xa7, 0x0b, 0xc1, 0x22, 0x93, 0x87, 0x9c, 0xa8, 0x02, 0x70, 0x3d, 0xcb, 0xf4, 0x7c, 0x36,
	0x7d, 0x7e, 0x63, 0x7d, 0x46, 0xd0, 0x91, 0x43, 0xb4, 0x60, 0xdc, 0x8b, 0xbc, 0x7b, 0x01, 0x1e,
	0xed, 0x12, 0xdb, 0x37, 0xed, 0x21, 0xd6, 0x29, 0x95, 0x0c, 0xd3, 0x1a, 0xba, 0xb8, 0x20, 0xae,
	0x09, 0xeb, 0x39, 0xbe, 0x34, 0xab, 0xe1, 0xf8, 0xbe, 0xbd, 0xc3, 0x47, 0xd1, 0x31, 0xc8, 0x5e,
	0xd7, 0x35, 0x1d, 0x5f, 0x3f, 0x31, 0x5c, 0xd3, 0xe8, 0x58, 0x98, 0xd3, 0x29, 0xbf, 0x71, 0x63,
	0x56, 0x21, 0xe7, 0x91, 0x96, 0x9a, 0xcc, 0xfc, 0x6e, 0x68, 0x1d, 0x4b, 0xf0, 0x8a, 0x37, 0x39,
	0x84, 0x7e, 0x34, 0xc1, 0xa2, 0x0c, 0x9b, 0xe6, 0x5a, 0xc2, 0x69, 0x66, 0x52, 0xe8, 0xd4, 0xae,
	0xc8, 0x9e, 0xbd, 0x2b, 0x8a, 0x9b, 0x70, 0xe9, 0x2c, 0x9f, 0xe7, 0xa1, 0xc5, 0x45, 0x0b, 0x8b,
	0x14, 0x11, 0x49, 0xf9, 0x7b, 0x1a, 0xf2, 0x6c, 0x9f, 0x34, 0xef, 0x59, 0x5f, 0x12, 0x71, 0xc8,
	0x19, 0x1c, 0x10, 0x59, 0x72, 0x5e, 0x4b, 0x52, 0xe3, 0xb9, 0xe3, 0xf3, 0xf0, 0x40, 0x9f, 0xe0,
	0x01, 0xa7, 0xdb, 0xf5, 0x39, 0xa6, 0x9a, 0x9f, 0x0b, 0x2f, 0x3d, 0xa0, 0x42, 0x9e, 0xae, 0x3b,
	0xd9, 0x2f, 0xa8, 0xee, 0x7c, 0xb5, 0x58, 0xf6, 0xcb, 0x0c, 0x64, 0x1b, 0x66, 0xff, 0xeb, 0x54,
	0x99, 0x8e, 0x1e, 0x58, 0x99, 0x66, 0x51, 0x85, 0x07, 0x3a, 0x0f, 0x21, 0xdf, 0x3c, 0xa3, 0x30,
	0x7d, 0x37, 0xd9, 0x2c, 0x5f, 0x58, 0x5d, 0x3a, 0x83, 0x8b, 0x0b, 0x0f, 0x25, 0x17, 0x7f, 0x2d,
	0x82, 0xc4, 0x76, 0xb3, 0x46, 0xe9, 0x78, 0x15, 0x56, 0x58, 0x2b, 0xe5, 0x9e, 0xd9, 0x45, 0x2d,
	0xd2, 0x31, 0x6d, 0x66, 0x03, 0x35, 0xd1, 0xe8, 0x88, 0x49, 0x1a, 0x9d, 0x74, 0xa2, 0x2b, 0x4d,
	0x26, 0xd1, 0x95, 0x26, 0x0a, 0xe6, 0x3c, 0x7d, 0x4e, 0xf6, 0xab, 0xd1, 0xe7, 0x7c, 0x90, 0x06,
	0xa9, 0xe1, 0x62, 0xcf, 0x27, 0x5f, 0xa7, 0x1a, 0xb1, 0x0e, 0x4b, 0x64, 0xe8, 0x3b, 0x43, 0x5f,
	0x3f, 0x20, 0xee, 0xc0, 0xf0, 0x0b, 0xe9, 0x90, 0x3a, 0x82, 0xb6, 0xc8, 0x47, 0x76, 0xd8, 0x00,
	0xfa, 0x16, 0xe4, 0xf9, 0x9b, 0x8d, 0xee, 0x1b, 0xfd, 0x89, 0x66, 0x18, 0xb8, 0xbc, 0x65, 0xf4,
	0xa7, 0xb3, 0x9f, 0x4d, 0x94, 0xfd, 0x68, 0xd5, 0xce, 0x93, 0xfd, 0x85, 0xaf, 0xc6, 0x45, 0x27,
	0xb6, 0x3b, 0xdf, 0x82, 0xc5, 0x3d, 0xd2, 0x69, 0x58, 0x46, 0x17, 0x0f, 0xb0, 0xed, 0xd3, 0x8d,
	0xd3, 0xb5, 0x86, 0x9e, 0x8f, 0x5d, 0xdd, 0x36, 0x06, 0x38, 0xbe, 0x39, 0xf3, 0xc1, 0x40, 0xdd,
	0x18, 0xe0, 0xb8, 0xde, 0x70, 0x68, 0xf6, 0xf8, 0x1c, 0x54, 0x4f, 0x8c, 0xf4, 0xda, 0x43, 0xb3,
	0xa7, 0xfc, 0x2a, 0x0d, 0xd2, 0x1e, 0xe9, 0x34, 0x7d, 0xc3, 0x1f, 0x7a, 0xa8, 0x0a, 0x19, 0xcf,
	0x37, 0x7c, 0x0e, 0xbb, 0xbc, 0x51, 0x9a, 0xb1, 0x10, 0x91, 0x61, 0x89, 0xfe, 0xc1, 0x1c, 0x9e,
	0x23, 0xd0, 0xe6, 0xbc, 0x87, 0x7d, 0xc3, 0xb4, 0xbc, 0xf8, 0xdc, 0xa1, 0x0c, 0x55, 0x41, 0x66,
	0x7a, 0xba, 0xe7, 0x1b, 0xae, 0xaf, 0xfb, 0xe6, 0x00, 0x07, 0x7b, 0xaf, 0x18, 0x4e, 0x1a, 0x3e,
	0x9d, 0x95, 0x5a, 0xe1, 0xd3, 0x19, 0xc7, 0x58, 0x66, 0x86, 0x4d, 0x6a, 0x47, 0x47, 0x90, 0x06,
	0x39, 0x6f, 0xd8, 0xe1, 0x7e, 0x2f, 0x30, 0xbf, 0x9f, 0x4f, 0xee, 0x77, 0x60, 0xc8, 0x91, 0x23,
	0x1c, 0xe5, 0xb7, 0x02, 0x64, 0x58, 0x4c, 0xe8, 0x32, 0xac, 0x36, 0x5b, 0x95, 0x96, 0x3a, 0xf5,
	0x4a, 0x95, 0x87, 0x85, 0x86, 0x5a, 0xdf, 0xae, 0xd6, 0x6f, 0xca, 0x02, 0x5a, 0x06, 0x68, 0xaa,
	0xad, 0x76, 0x43, 0xdf, 0xde, 0xaf, 0xab, 0x72, 0x8e, 0x0e, 0x6a, 0xed, 0x7a, 0x9d, 0x0e, 0xa6,
	0x10, 0x82, 0xe5, 0xad, 0x4a, 0x7d, 0x4b, 0xad, 0xe9, 0xa1, 0x81, 0x18, 0x93, 0x35, 0x5b, 0x15,
	0xad, 0xa5, 0x6e, 0xcb, 0x0b, 0x68, 0x09, 0x24, 0x2e, 0xab, 0xa9, 0xdb, 0xfc, 0x75, 0x8b, 0xa1,
	0x4d, 0xbc, 0x6e, 0x3d, 0x0a, 0x2b, 0x95, 0x56, 0x4b, 0xbd, 0xdd, 0x68, 0xe9, 0x3b, 0x95, 0x6a,
	0xad, 0xad, 0xa9, 0xb2, 0xa4, 0xec, 0x42, 0x2e, 0x0c, 0x03, 0xad, 0x40, 0x7e, 0xd2, 0xcf, 0x25,
	0x90, 0x9a, 0xed, 0xcd, 0xdb, 0xd5, 0x16, 0x9d, 0x44, 0x40, 0x00, 0xd9, 0x3b, 0x6d, 0xb5, 0xad,
	0x6e, 0xcb, 0x29, 0x24, 0xc3, 0x62, 0xb3, 0x55, 0xa9, 0xa9, 0xd4, 0x87, 0x56, 0xbb, 0x29, 0x8b,
	0x4a, 0x9d, 0x91, 0x4d, 0xc3, 0x07, 0xd8, 0xc5, 0x76, 0x17, 0x23, 0x85, 0xed, 0xbf, 0x23, 0xdc,
	0xf5, 0x75, 0xb3, 0x17, 0xa7, 0x9a, 0x14, 0x88, 0xab, 0x3d, 0x54, 0x84, 0xec, 0x11, 0xe9, 0xe8,
	0x71, 0x8a, 0x09, 0x5a, 0xe6, 0x88, 0x74, 0xaa, 0x3d, 0xe5, 0xe3, 0x14, 0xac, 0xfc, 0xd0, 0x70,
	0xed, 0x8a, 0xe3, 0x58, 0x66, 0x97, 0x3d, 0xaf, 0xd2, 0x43, 0x63, 0x92, 0xb8, 0xa2, 0xc6, 0x04,
	0x68, 0x3f, 0xe4, 0x1e, 0x7f, 0x65, 0x7c, 0x71, 0x46, 0x0e, 0xa7, 0x70, 0xcf, 0x60, 0xe0, 0x93,
	0x90, 0x73, 0x5c, 0xd2, 0x77, 0xb1, 0xe7, 0xb1, 0xba, 0x95, 0x0a, 0x92, 0x1c, 0x0a, 0xe9, 0x1e,
	0xf1, 0x5d, 0xa3, 0x7b, 0x4c, 0x0b, 0xc0, 0xd0, 0xb5, 0xc6, 0xd5, 0x4a, 0xd4, 0xf2, 0xe1, 0x40,
	0xdb, 0xb5, 0x94, 0x5f, 0xcc, 0x22, 0xc3, 0x02, 0x88, 0x75, 0xf5, 0x0d, 0x4e, 0x84, 0xba, 0xfa,
	0x86, 0xde, 0xac, 0xdc, 0xe5, 0xb9, 0x9f, 0x58, 0x7d, 0x11, 0x2d, 0x42, 0xae, 0xb2, 0xb5, 0xa5,
	0x36, 0x5a, 0x2c, 0xc3, 0x31, 0x96, 0x64, 0xe8, 0xd0, 0x4e, 0xb5, 0x5e, 0x6d, 0xee, 0xaa, 0xdb,
	0x72, 0x96, 0xa6, 0x89, 0xe6, 0x97, 0xf1, 0x02, 0x20, 0x7b, 0xab, 0xca, 0x48, 0x91, 0x53, 0x3e,
	0xcd, 0x83, 0x48, 0x0f, 0x84, 0x3a, 0x48, 0x6e, 0x98, 0x25, 0xb6, 0x92, 0xf9, 0x8d, 0x67, 0x66,
	0x73, 0x3e, 0x4a, 0x2c, 0x4f, 0xd2, 0x18, 0x82, 0xe2, 0x39, 0x61, 0x89, 0x09, 0xce, 0x8d, 0x04,
	0x78, 0x51, 0x55, 0x0a, 0x49, 0x11, 0x55, 0xa9, 0x3a, 0xc0, 0x21, 0x7b, 0x58, 0xd4, 0x8f, 0x48,
	0x87, 0x2d, 0xfe, 0xec, 0x83, 0x28, 0x7a, 0x89, 0x64, 0xde, 0xd1, 0xd3, 0xe8, 0x30, 0x7a, 0xb3,
	0xbd, 0x05, 0x92, 0x47, 0x4f, 0x75, 0x06, 0x97, 0x66, 0x70, 0x4f, 0x27, 0x7c, 0xef, 0x0a, 0xd1,
	0x72, 0x5e, 0xf8, 0x5a, 0x74, 0x07, 0xf2, 0xce, 0x68, 0x0c, 0x97, 0x61, 0x70, 0xdf, 0x49, 0xfc,
	0x7a, 0x12, 0x02, 0x42, 0x00, 0x42, 0x21, 0x77, 0x21, 0xc7, 0x7a, 0x19, 0x8a, 0xc7, 0xab, 0xd8,
	0x53, 0xc9, 0xee, 0xd1, 0x21, 0xd8, 0xc2, 0x61, 0xf0, 0x50, 0xa1, 0xc2, 0x82, 0x63, 0xf6, 0x19,
	0x10, 0x3f, 0x8c, 0xbe, 0x9d, 0xa8, 0xef, 0x0d, 0x71, 0xb2, 0x0e, 0xbf, 0x55, 0xec, 0x43, 0x9e,
	0x47, 0xe8, 0x32, 0xa8, 0xcb, 0x89, 0x32, 0x10, 0x35, 0x4e, 0x51, 0x06, 0xbc, 0xa8, 0x2f, 0x6c,
	0xc3, 0x12, 0x07, 0xf4, 0xee, 0x59, 0x0c, 0x72, 0x91, 0x41, 0x5e, 0x4d, 0x7e, 0x4d, 0x0c, 0x41,
	0xb9, 0x63, 0xc1, 0xf5, 0xba, 0x4e, 0x2b, 0x0c, 0x3d, 0xb0, 0x19, 0xe6, 0x95, 0x44, 0x6e, 0x46,
	0x27, 0x7c, 0xe4, 0xa6, 0x13, 0x75, 0x4a, 0x2a, 0x64, 0x3d, 0x56, 0xd9, 0x83, 0x07, 0xab, 0xf5,
	0xa4, 0x27, 0x01, 0xdf, 0xf6, 0x81, 0x31, 0x6a, 0xc1, 0x32, 0xff, 0xa4, 0x1f, 0x9a, 0x9e, 0x4f,
	0xdc, 0x51, 0x61, 0x89, 0x35, 0x1f, 0x73, 0xc2, 0x2d, 0x71, 0x90, 0x5d, 0x8e, 0x81, 0xde, 0x86,
	0xd5, 0x91, 0xe1, 0xda, 0xba, 0x31, 0x2e, 0x5b, 0x5e, 0x41, 0x62, 0xc0, 0xa5, 0xf9, 0xaa, 0x1d,
	0x87, 0x97, 0x47, 0x93, 0x52, 0x56, 0xd1, 0xbc, 0x61, 0x67, 0x60, 0xfa, 0x3e, 0xee, 0xe9, 0x9d,
	0x51, 0x01, 0x62, 0x15, 0x2d, 0x1a, 0xd8, 0x1c, 0xa1, 0xd7, 0xa1, 0x18, 0x7c, 0xd5, 0x14, 0xf4,
	0x6b, 0x2e, 0xf6, 0xc8, 0xd0, 0xed, 0xf2, 0xe6, 0x72, 0x75, 0x6c, 0x75, 0x85, 0xab, 0xed, 0x33,
	0x2d, 0x2d, 0x50, 0xa2, 0xad, 0xe6, 0xf7, 0xa1, 0x10, 0x20, 0xd0, 0x36, 0xd0, 0x25, 0x16, 0xeb,
	0x4d, 0x3d, 0x66, 0xbf, 0x32, 0xb6, 0xbf, 0xcc, 0x95, 0xb6, 0xb8, 0x0e, 0xed, 0x53, 0x3d, 0x6a,
	0x7d, 0x0b, 0xb2, 0x96, 0xd1, 0xc1, 0x96, 0x57, 0x40, 0x89, 0xc2, 0xa7, 0xed, 0x5c, 0x8d, 0x19,
	0xc4, 0x5a, 0xb9, 0x00, 0x02, 0xdd, 0x01, 0xf0, 0xba, 0x87, 0xb8, 0x37, 0xb4, 0x4c, 0xbb, 0x5f,
	0xb8, 0x94, 0xa8, 0x85, 0xa3, 0x89, 0x8a, 0x6c, 0x82, 0xce, 0x70, 0x0c, 0x82, 0xfe, 0x1f, 0x72,
	0xf4, 0x50, 0x63, 0x9d, 0xd3, 0x63, 0xb1, 0xee, 0xe5, 0x88, 0x74, 0x68, 0xd7, 0x44, 0x0f, 0xb1,
	0x1e, 0xb1, 0x71, 0xa1, 0x10, 0xb6, 0xc3, 0xa2, 0xc6, 0x04, 0xc5, 0x97, 0x21, 0x1f, 0xf3, 0x73,
	0xae, 0xa6, 0x0f, 0x20, 0xe7, 0x8f, 0x1c, 0x56, 0x43, 0x94, 0x9b, 0xb0, 0x34, 0xe1, 0x21, 0xba,
	0x06, 0x97, 0x07, 0xc6, 0x3b, 0x61, 0x1b, 0xee, 0xe9, 0x0e, 0x76, 0xf5, 0x43, 0x32, 0x74, 0x19,
	0x74, 0x86, 0x07, 0x80, 0x06, 0xc6, 0x3b, 0x41, 0x27, 0xee, 0x35, 0xb0, 0xbb, 0x4b, 0x86, 0xae,
	0xf2, 0x57, 0x01, 0xf2, 0x7b, 0xa4, 0x73, 0x1b, 0xfb, 0x06, 0x5d, 0x83, 0xd8, 0x69, 0x1d, 0x3b,
	0x7f, 0xf9, 0x69, 0x1d, 0xdb, 0x3b, 0xa9, 0x8b, 0xec, 0x9d, 0xab, 0xb0, 0x1c, 0x7d, 0x99, 0xaa,
	0xd3, 0x88, 0x58, 0xfd, 0x0f, 0xa6, 0x5a, 0x8a, 0x86, 0x5a, 0x23, 0x07, 0xa3, 0x57, 0x01, 0x62,
	0xfd, 0x5f, 0x3a, 0x59, 0xff, 0x27, 0x79, 0x61, 0xeb, 0xa7, 0x7c, 0x28, 0x80, 0xdc, 0x64, 0xbc,
	0x66, 0xc7, 0xdb, 0xbd, 0x21, 0xf6, 0xfc, 0x44, 0x5d, 0xcb, 0xe3, 0x90, 0x75, 0x71, 0xdf, 0x24,
	0xf6, 0xd8, 0xb9, 0x94, 0x16, 0x88, 0xd0, 0xcb, 0x20, 0xd2, 0x6a, 0xc4, 0x57, 0x41, 0x99, 0xbd,
	0x0a, 0xdc, 0x9a, 0xda, 0xd0, 0xb9, 0x5d, 0xee, 0x06, 0x9d, 0x3b, 0x76, 0xfd, 0x91, 0x02, 0x71,
	0xb5, 0xa7, 0x58, 0xb0, 0x74, 0x13, 0x7f, 0xa1, 0x0e, 0x9f, 0xd1, 0x83, 0xa5, 0xc2, 0x1e, 0xec,
	0x03, 0x11, 0x56, 0xe8, 0x8d, 0x6e, 0x8f, 0x74, 0xbc, 0xf3, 0x4d, 0x98, 0x3d, 0x3d, 0xe1, 0x1a,
	0x48, 0x8e, 0xd1, 0xc7, 0xba, 0x67, 0xbe, 0xcb, 0x99, 0x1c, 0x50, 0x30, 0x47, 0xa5, 0x4d, 0xf3,
	0x5d, 0xde, 0x3a, 0x52, 0x0d, 0x9f, 0x1c, 0xe3, 0x98, 0xcf, 0x82, 0xc6, 0x0c, 0x5b, 0x54, 0x7a,
	0xea, 0x2e, 0x13, 0x5b, 0xae, 0x89, 0xbb, 0x0c, 0x81, 0x55, 0x1a, 0x1e, 0xbf, 0x2f, 0x0c, 0x0c,
	0xbf, 0x7b, 0x88, 0x5d, 0x76, 0x6c, 0x2f, 0x6f, 0xbc, 0x3a, 0xeb, 0xaa, 0x36, 0x19, 0x79, 0xc8,
	0x59, 0x7c, 0x9b, 0xa3, 0x04, 0xef, 0x4f, 0x47, 0x93, 0x52, 0x1a, 0xfb, 0x81, 0x69, 0xf9, 0xd8,
	0x65, 0x67, 0x70, 0xe0, 0x52, 0x20, 0x52, 0xae, 0xc1, 0xca, 0x14, 0x4a, 0xf8, 0x95, 0xf5, 0x23,
	0xb4, 0x57, 0xab, 0x6c, 0xb5, 0xaa, 0x77, 0xd5, 0xa0, 0x17, 0xdc, 0xaf, 0xeb, 0xc1, 0xff, 0x29,
	0xe5, 0xdf, 0x02, 0xc8, 0x6d, 0xa7, 0x67, 0xf8, 0xf8, 0xdc, 0xa9, 0x4f, 0x7d, 0x5e, 0xea, 0xc5,
	0xe9, 0xd4, 0x87, 0x3c, 0x4e, 0x9f, 0x83, 0xc7, 0xaf, 0x43, 0x7e, 0xc8, 0x7c, 0x65, 0xbf, 0x69,
	0x08, 0x7a, 0xa4, 0xd3, 0x3b, 0x73, 0xc7, 0xc4, 0x56, 0xef, 0xb6, 0xe1, 0x1d, 0x73, 0x53, 0xe0,
	0x36, 0x54, 0xa0, 0xfc, 0x14, 0xe4, 0xf1, 0xe2, 0x7b, 0x0e, 0xb1, 0x3d, 0x8c, 0x6e, 0x40, 0xfa,
	0x88, 0x74, 0xf8, 0xb7, 0x35, 0x89, 0x3d, 0x12, 0x35, 0x66, 0x84, 0x9e, 0x81, 0x15, 0x1b, 0xbf,
	0xe3, 0xeb, 0x31, 0x5a, 0xc5, 0x6e, 0x1c, 0x4b, 0x74, 0xac, 0x11, 0x52, 0x4b, 0x21, 0x20, 0x6f,
	0x19, 0x76, 0x17, 0x5b, 0xff, 0xab, 0x6d, 0x46, 0x40, 0xde, 0xc6, 0x16, 0xbe, 0x40, 0x72, 0xe7,
	0x9b, 0x70, 0xe3, 0xb3, 0x3c, 0x3b, 0x23, 0x82, 0x93, 0xd5, 0xc2, 0x2e, 0xfa, 0xa3, 0x00, 0x52,
	0x54, 0x0c, 0x51, 0x79, 0x56, 0x67, 0x36, 0x55, 0x36, 0x8b, 0x09, 0xd2, 0xa1, 0xbc, 0xfd, 0x49,
	0xe5, 0xca, 0x38, 0xa4, 0x67, 0xd7, 0xb8, 0x9f, 0xcf, 0xae, 0x1d, 0x91, 0xce, 0xcf, 0xff, 0xfc,
	0x8f, 0xdf, 0xa4, 0x5e, 0x57, 0x6e, 0x44, 0xbf, 0xf3, 0x09, 0xf4, 0xbc, 0xf2, 0x7b, 0x63, 0x8b,
	0xf7, 0xcb, 0xdc, 0xc2, 0x2b, 0xbf, 0xc7, 0x3f, 0xbc, 0xcf, 0x7e, 0x0e, 0x74, 0x9d, 0xf7, 0x26,
	0xd7, 0x85, 0xab, 0xe8, 0x5f, 0x02, 0x5c, 0x8a, 0x5c, 0xab, 0x78, 0xfb, 0xe1, 0x71, 0x31, 0x7f,
	0x3c, 0x4f, 0x84, 0x06, 0xb1, 0x9f, 0xf9, 0x94, 0x22, 0x3c, 0xe5, 0x67, 0xc2, 0x47, 0x15, 0xc4,
	0x6f, 0x53, 0xf1, 0x13, 0x72, 0x46, 0x80, 0xb7, 0x94, 0x9d, 0x0b, 0x04, 0x18, 0x8b, 0x87, 0xc6,
	0xfa, 0x07, 0x01, 0xb2, 0xfc, 0x24, 0x40, 0xb3, 0xfa, 0x95, 0x89, 0x03, 0x23, 0x51, 0xaa, 0x3a,
	0x9f, 0x54, 0x8a, 0x0f, 0x88, 0x44, 0x37, 0x7b, 0x2c, 0x98, 0xd7, 0xd0, 0x2b, 0xe7, 0x09, 0xa6,
	0xfc, 0x1e, 0xc7, 0x78, 0x1f, 0xfd, 0x45, 0x80, 0x5c, 0xb8, 0xc9, 0x51, 0x69, 0xbe, 0x52, 0x5c,
	0x2c, 0x27, 0xd6, 0xe7, 0xd5, 0x43, 0xb1, 0x3f, 0xa9, 0xa0, 0xd3, 0x11, 0x3d, 0x20, 0x4c, 0x5e,
	0xac, 0x59, 0x98, 0xd7, 0xd0, 0x8b, 0xe7, 0x09, 0x13, 0xfd, 0x4e, 0x00, 0x29, 0x2a, 0xd8, 0x33,
	0xf9, 0x37, 0x5d, 0xda, 0x13, 0x25, 0x69, 0x8f, 0x39, 0xb8, 0xbd, 0x71, 0xb1, 0x3c, 0x5c, 0x67,
	0x25, 0xfb, 0x63, 0x01, 0xa4, 0xa8, 0xe6, 0xcd, 0x74, 0x77, 0xba, 0x3a, 0x26, 0x72, 0xd7, 0x9a,
	0xcd, 0xa9, 0xaa, 0xb2, 0x7d, 0xb1, 0x58, 0xba, 0xcc, 0x31, 0xba, 0x3d, 0x7e, 0x2f, 0x80, 0x14,
	0xd5, 0xd4, 0x99, 0x01, 0x4d, 0x57, 0xdf, 0xe2, 0x63, 0xa7, 0x4e, 0x2b, 0x75, 0xe0, 0xf8, 0xa3,
	0x44, 0x1b, 0xe3, 0xea, 0xc5, 0x12, 0x52, 0xbc, 0xf5, 0x51, 0xe5, 0x4a, 0xe4, 0x21, 0x77, 0xc3,
	0x70, 0x4c, 0xaf, 0xd4, 0x25, 0x83, 0x3f, 0x55, 0x4a, 0x87, 0xbe, 0xef, 0x78, 0xd7, 0xcb, 0xe5,
	0xfb, 0xf7, 0xef, 0x4f, 0x0d, 0x96, 0x8d, 0xa1, 0x7f, 0xc8, 0x7f, 0x38, 0xf9, 0x9c, 0x63, 0x19,
	0xfe, 0x01, 0x71, 0x07, 0x9b, 0xf7, 0xe1, 0x1b, 0x5d, 0x32, 0xf8, 0xfc, 0xf0, 0x37, 0x25, 0xba,
	0x55, 0x1a, 0x34, 0xd2, 0x86, 0xf0, 0xa6, 0x1a, 0xe8, 0xf6, 0x89, 0x65, 0xd8, 0xfd, 0x12, 0x71,
	0xfb, 0xe5, 0x3e, 0xb6, 0xd9, 0x3a, 0x94, 0xc7, 0x13, 0x3e, 0xe0, 0x07, 0x9a, 0x37, 0x42, 0x41,
	0x27, 0xcb, 0x2c, 0x5e, 0xf8, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa0, 0xbc, 0xdf, 0x94, 0xd1,
	0x29, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// JobControllerClient is the client API for JobController service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type JobControllerClient interface {
	// Submits a job to a cluster.
	SubmitJob(ctx context.Context, in *SubmitJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Submits job to a cluster.
	SubmitJobAsOperation(ctx context.Context, in *SubmitJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets the resource representation for a job in a project.
	GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Lists regions/{region}/jobs in a project.
	ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error)
	// Updates a job in a project.
	UpdateJob(ctx context.Context, in *UpdateJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Starts a job cancellation request. To access the job resource
	// after cancellation, call
	// [regions/{region}/jobs.list](https://cloud.google.com/dataproc/docs/reference/rest/v1beta2/projects.regions.jobs/list)
	// or
	// [regions/{region}/jobs.get](https://cloud.google.com/dataproc/docs/reference/rest/v1beta2/projects.regions.jobs/get).
	CancelJob(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Deletes the job from the project. If the job is active, the delete fails,
	// and the response returns `FAILED_PRECONDITION`.
	DeleteJob(ctx context.Context, in *DeleteJobRequest, opts ...grpc.CallOption) (*empty.Empty, error)
}

type jobControllerClient struct {
	cc grpc.ClientConnInterface
}

func NewJobControllerClient(cc grpc.ClientConnInterface) JobControllerClient {
	return &jobControllerClient{cc}
}

func (c *jobControllerClient) SubmitJob(ctx context.Context, in *SubmitJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.JobController/SubmitJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobControllerClient) SubmitJobAsOperation(ctx context.Context, in *SubmitJobRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.JobController/SubmitJobAsOperation", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobControllerClient) GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.JobController/GetJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobControllerClient) ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error) {
	out := new(ListJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.JobController/ListJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobControllerClient) UpdateJob(ctx context.Context, in *UpdateJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.JobController/UpdateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobControllerClient) CancelJob(ctx context.Context, in *CancelJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.JobController/CancelJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobControllerClient) DeleteJob(ctx context.Context, in *DeleteJobRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dataproc.v1beta2.JobController/DeleteJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// JobControllerServer is the server API for JobController service.
type JobControllerServer interface {
	// Submits a job to a cluster.
	SubmitJob(context.Context, *SubmitJobRequest) (*Job, error)
	// Submits job to a cluster.
	SubmitJobAsOperation(context.Context, *SubmitJobRequest) (*longrunning.Operation, error)
	// Gets the resource representation for a job in a project.
	GetJob(context.Context, *GetJobRequest) (*Job, error)
	// Lists regions/{region}/jobs in a project.
	ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error)
	// Updates a job in a project.
	UpdateJob(context.Context, *UpdateJobRequest) (*Job, error)
	// Starts a job cancellation request. To access the job resource
	// after cancellation, call
	// [regions/{region}/jobs.list](https://cloud.google.com/dataproc/docs/reference/rest/v1beta2/projects.regions.jobs/list)
	// or
	// [regions/{region}/jobs.get](https://cloud.google.com/dataproc/docs/reference/rest/v1beta2/projects.regions.jobs/get).
	CancelJob(context.Context, *CancelJobRequest) (*Job, error)
	// Deletes the job from the project. If the job is active, the delete fails,
	// and the response returns `FAILED_PRECONDITION`.
	DeleteJob(context.Context, *DeleteJobRequest) (*empty.Empty, error)
}

// UnimplementedJobControllerServer can be embedded to have forward compatible implementations.
type UnimplementedJobControllerServer struct {
}

func (*UnimplementedJobControllerServer) SubmitJob(ctx context.Context, req *SubmitJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SubmitJob not implemented")
}
func (*UnimplementedJobControllerServer) SubmitJobAsOperation(ctx context.Context, req *SubmitJobRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SubmitJobAsOperation not implemented")
}
func (*UnimplementedJobControllerServer) GetJob(ctx context.Context, req *GetJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetJob not implemented")
}
func (*UnimplementedJobControllerServer) ListJobs(ctx context.Context, req *ListJobsRequest) (*ListJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListJobs not implemented")
}
func (*UnimplementedJobControllerServer) UpdateJob(ctx context.Context, req *UpdateJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateJob not implemented")
}
func (*UnimplementedJobControllerServer) CancelJob(ctx context.Context, req *CancelJobRequest) (*Job, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelJob not implemented")
}
func (*UnimplementedJobControllerServer) DeleteJob(ctx context.Context, req *DeleteJobRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteJob not implemented")
}

func RegisterJobControllerServer(s *grpc.Server, srv JobControllerServer) {
	s.RegisterService(&_JobController_serviceDesc, srv)
}

func _JobController_SubmitJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubmitJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobControllerServer).SubmitJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.JobController/SubmitJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobControllerServer).SubmitJob(ctx, req.(*SubmitJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobController_SubmitJobAsOperation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SubmitJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobControllerServer).SubmitJobAsOperation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.JobController/SubmitJobAsOperation",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobControllerServer).SubmitJobAsOperation(ctx, req.(*SubmitJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobController_GetJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobControllerServer).GetJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.JobController/GetJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobControllerServer).GetJob(ctx, req.(*GetJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobController_ListJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobControllerServer).ListJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.JobController/ListJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobControllerServer).ListJobs(ctx, req.(*ListJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobController_UpdateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobControllerServer).UpdateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.JobController/UpdateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobControllerServer).UpdateJob(ctx, req.(*UpdateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobController_CancelJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobControllerServer).CancelJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.JobController/CancelJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobControllerServer).CancelJob(ctx, req.(*CancelJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobController_DeleteJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobControllerServer).DeleteJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dataproc.v1beta2.JobController/DeleteJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobControllerServer).DeleteJob(ctx, req.(*DeleteJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _JobController_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1beta2.JobController",
	HandlerType: (*JobControllerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "SubmitJob",
			Handler:    _JobController_SubmitJob_Handler,
		},
		{
			MethodName: "SubmitJobAsOperation",
			Handler:    _JobController_SubmitJobAsOperation_Handler,
		},
		{
			MethodName: "GetJob",
			Handler:    _JobController_GetJob_Handler,
		},
		{
			MethodName: "ListJobs",
			Handler:    _JobController_ListJobs_Handler,
		},
		{
			MethodName: "UpdateJob",
			Handler:    _JobController_UpdateJob_Handler,
		},
		{
			MethodName: "CancelJob",
			Handler:    _JobController_CancelJob_Handler,
		},
		{
			MethodName: "DeleteJob",
			Handler:    _JobController_DeleteJob_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1beta2/jobs.proto",
}
