/*
 * Copyright (C) 2008 The Guava Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.google.common.collect;
public class MultisetsTest_gwt extends com.google.gwt.junit.client.GWTTestCase {
@Override public String getModuleName() {
  return "com.google.common.collect.testModule";
}
public void testContainsOccurrences() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testContainsOccurrences();
}

public void testContainsOccurrencesEmpty() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testContainsOccurrencesEmpty();
}

public void testDifferenceEmptyNonempty() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testDifferenceEmptyNonempty();
}

public void testDifferenceNonemptyEmpty() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testDifferenceNonemptyEmpty();
}

public void testDifferenceWithMoreElementsInSecondMultiset() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testDifferenceWithMoreElementsInSecondMultiset();
}

public void testDifferenceWithNoRemovedElements() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testDifferenceWithNoRemovedElements();
}

public void testDifferenceWithRemovedElement() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testDifferenceWithRemovedElement();
}

public void testHighestCountFirst() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testHighestCountFirst();
}

public void testIntersectEmptyNonempty() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testIntersectEmptyNonempty();
}

public void testIntersectNonemptyEmpty() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testIntersectNonemptyEmpty();
}

public void testNewTreeMultisetComparator() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testNewTreeMultisetComparator();
}

public void testNewTreeMultisetDerived() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testNewTreeMultisetDerived();
}

public void testNewTreeMultisetNonGeneric() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testNewTreeMultisetNonGeneric();
}

public void testRemoveEmptyOccurrences() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testRemoveEmptyOccurrences();
}

public void testRemoveOccurrences() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testRemoveOccurrences();
}

public void testRemoveOccurrencesEmpty() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testRemoveOccurrencesEmpty();
}

public void testRetainEmptyOccurrences() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testRetainEmptyOccurrences();
}

public void testRetainOccurrences() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testRetainOccurrences();
}

public void testRetainOccurrencesEmpty() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testRetainOccurrencesEmpty();
}

public void testSum() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testSum();
}

public void testSumEmptyNonempty() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testSumEmptyNonempty();
}

public void testSumNonemptyEmpty() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testSumNonemptyEmpty();
}

public void testUnion() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testUnion();
}

public void testUnionEmptyNonempty() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testUnionEmptyNonempty();
}

public void testUnionEqualMultisets() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testUnionEqualMultisets();
}

public void testUnionNonemptyEmpty() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testUnionNonemptyEmpty();
}

public void testUnmodifiableMultisetShortCircuit() throws Exception {
  com.google.common.collect.MultisetsTest testCase = new com.google.common.collect.MultisetsTest();
  testCase.testUnmodifiableMultisetShortCircuit();
}
}
