// Code generated by gen_tests.py and process_polyglot.py.
// Do not edit this file directly.
// The template for this file is located at:
// ../template.go.tpl
package reql_tests

import (
	"testing"
	"time"

	"github.com/stretchr/testify/suite"
	r "gopkg.in/gorethink/gorethink.v3"
	"gopkg.in/gorethink/gorethink.v3/internal/compare"
)

// Tests of conversion to and from the RQL null type
func TestDatumNullSuite(t *testing.T) {
	suite.Run(t, new(DatumNullSuite))
}

type DatumNullSuite struct {
	suite.Suite

	session *r.Session
}

func (suite *DatumNullSuite) SetupTest() {
	suite.T().Log("Setting up DatumNullSuite")
	// Use imports to prevent errors
	_ = time.Time{}
	_ = compare.AnythingIsFine

	session, err := r.Connect(r.ConnectOpts{
		Address: url,
	})
	suite.Require().NoError(err, "Error returned when connecting to server")
	suite.session = session

	r.DBDrop("test").Exec(suite.session)
	err = r.DBCreate("test").Exec(suite.session)
	suite.Require().NoError(err)
	err = r.DB("test").Wait().Exec(suite.session)
	suite.Require().NoError(err)

}

func (suite *DatumNullSuite) TearDownSuite() {
	suite.T().Log("Tearing down DatumNullSuite")

	if suite.session != nil {
		r.DB("rethinkdb").Table("_debug_scratch").Delete().Exec(suite.session)
		r.DBDrop("test").Exec(suite.session)

		suite.session.Close()
	}
}

func (suite *DatumNullSuite) TestCases() {
	suite.T().Log("Running DatumNullSuite: Tests of conversion to and from the RQL null type")

	{
		// datum/null.yaml line #6
		/* (null) */
		var expected_ interface{} = nil
		/* r.expr(null) */

		suite.T().Log("About to run line #6: r.Expr(nil)")

		runAndAssert(suite.Suite, expected_, r.Expr(nil), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #6")
	}

	{
		// datum/null.yaml line #9
		/* 'NULL' */
		var expected_ string = "NULL"
		/* r.expr(null).type_of() */

		suite.T().Log("About to run line #9: r.Expr(nil).TypeOf()")

		runAndAssert(suite.Suite, expected_, r.Expr(nil).TypeOf(), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #9")
	}

	{
		// datum/null.yaml line #14
		/* 'null' */
		var expected_ string = "null"
		/* r.expr(null).coerce_to('string') */

		suite.T().Log("About to run line #14: r.Expr(nil).CoerceTo('string')")

		runAndAssert(suite.Suite, expected_, r.Expr(nil).CoerceTo("string"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #14")
	}

	{
		// datum/null.yaml line #17
		/* null */
		var expected_ interface{} = nil
		/* r.expr(null).coerce_to('null') */

		suite.T().Log("About to run line #17: r.Expr(nil).CoerceTo('null')")

		runAndAssert(suite.Suite, expected_, r.Expr(nil).CoerceTo("null"), suite.session, r.RunOpts{
			GeometryFormat: "raw",
			GroupFormat:    "map",
		})
		suite.T().Log("Finished running line #17")
	}
}
