// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/secretmanager/v1/resources.proto

package secretmanager

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The state of a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion], indicating if it can be accessed.
type SecretVersion_State int32

const (
	// Not specified. This value is unused and invalid.
	SecretVersion_STATE_UNSPECIFIED SecretVersion_State = 0
	// The [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] may be accessed.
	SecretVersion_ENABLED SecretVersion_State = 1
	// The [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] may not be accessed, but the secret data
	// is still available and can be placed back into the [ENABLED][google.cloud.secretmanager.v1.SecretVersion.State.ENABLED]
	// state.
	SecretVersion_DISABLED SecretVersion_State = 2
	// The [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] is destroyed and the secret data is no longer
	// stored. A version may not leave this state once entered.
	SecretVersion_DESTROYED SecretVersion_State = 3
)

var SecretVersion_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "ENABLED",
	2: "DISABLED",
	3: "DESTROYED",
}

var SecretVersion_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"ENABLED":           1,
	"DISABLED":          2,
	"DESTROYED":         3,
}

func (x SecretVersion_State) String() string {
	return proto.EnumName(SecretVersion_State_name, int32(x))
}

func (SecretVersion_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_71e58bcc3ce7ff53, []int{1, 0}
}

// A [Secret][google.cloud.secretmanager.v1.Secret] is a logical secret whose value and versions can
// be accessed.
//
// A [Secret][google.cloud.secretmanager.v1.Secret] is made up of zero or more [SecretVersions][google.cloud.secretmanager.v1.SecretVersion] that
// represent the secret data.
type Secret struct {
	// Output only. The resource name of the [Secret][google.cloud.secretmanager.v1.Secret] in the format `projects/*/secrets/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Immutable. The replication policy of the secret data attached to the [Secret][google.cloud.secretmanager.v1.Secret].
	//
	// The replication policy cannot be changed after the Secret has been created.
	Replication *Replication `protobuf:"bytes,2,opt,name=replication,proto3" json:"replication,omitempty"`
	// Output only. The time at which the [Secret][google.cloud.secretmanager.v1.Secret] was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// The labels assigned to this Secret.
	//
	// Label keys must be between 1 and 63 characters long, have a UTF-8 encoding
	// of maximum 128 bytes, and must conform to the following PCRE regular
	// expression: `[\p{Ll}\p{Lo}][\p{Ll}\p{Lo}\p{N}_-]{0,62}`
	//
	// Label values must be between 0 and 63 characters long, have a UTF-8
	// encoding of maximum 128 bytes, and must conform to the following PCRE
	// regular expression: `[\p{Ll}\p{Lo}\p{N}_-]{0,63}`
	//
	// No more than 64 labels can be assigned to a given resource.
	Labels               map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Secret) Reset()         { *m = Secret{} }
func (m *Secret) String() string { return proto.CompactTextString(m) }
func (*Secret) ProtoMessage()    {}
func (*Secret) Descriptor() ([]byte, []int) {
	return fileDescriptor_71e58bcc3ce7ff53, []int{0}
}

func (m *Secret) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Secret.Unmarshal(m, b)
}
func (m *Secret) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Secret.Marshal(b, m, deterministic)
}
func (m *Secret) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Secret.Merge(m, src)
}
func (m *Secret) XXX_Size() int {
	return xxx_messageInfo_Secret.Size(m)
}
func (m *Secret) XXX_DiscardUnknown() {
	xxx_messageInfo_Secret.DiscardUnknown(m)
}

var xxx_messageInfo_Secret proto.InternalMessageInfo

func (m *Secret) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Secret) GetReplication() *Replication {
	if m != nil {
		return m.Replication
	}
	return nil
}

func (m *Secret) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Secret) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// A secret version resource in the Secret Manager API.
type SecretVersion struct {
	// Output only. The resource name of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] in the
	// format `projects/*/secrets/*/versions/*`.
	//
	// [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] IDs in a [Secret][google.cloud.secretmanager.v1.Secret] start at 1 and
	// are incremented for each subsequent version of the secret.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The time at which the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time this [SecretVersion][google.cloud.secretmanager.v1.SecretVersion] was destroyed.
	// Only present if [state][google.cloud.secretmanager.v1.SecretVersion.state] is
	// [DESTROYED][google.cloud.secretmanager.v1.SecretVersion.State.DESTROYED].
	DestroyTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=destroy_time,json=destroyTime,proto3" json:"destroy_time,omitempty"`
	// Output only. The current state of the [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
	State                SecretVersion_State `protobuf:"varint,4,opt,name=state,proto3,enum=google.cloud.secretmanager.v1.SecretVersion_State" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *SecretVersion) Reset()         { *m = SecretVersion{} }
func (m *SecretVersion) String() string { return proto.CompactTextString(m) }
func (*SecretVersion) ProtoMessage()    {}
func (*SecretVersion) Descriptor() ([]byte, []int) {
	return fileDescriptor_71e58bcc3ce7ff53, []int{1}
}

func (m *SecretVersion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecretVersion.Unmarshal(m, b)
}
func (m *SecretVersion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecretVersion.Marshal(b, m, deterministic)
}
func (m *SecretVersion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecretVersion.Merge(m, src)
}
func (m *SecretVersion) XXX_Size() int {
	return xxx_messageInfo_SecretVersion.Size(m)
}
func (m *SecretVersion) XXX_DiscardUnknown() {
	xxx_messageInfo_SecretVersion.DiscardUnknown(m)
}

var xxx_messageInfo_SecretVersion proto.InternalMessageInfo

func (m *SecretVersion) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SecretVersion) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *SecretVersion) GetDestroyTime() *timestamp.Timestamp {
	if m != nil {
		return m.DestroyTime
	}
	return nil
}

func (m *SecretVersion) GetState() SecretVersion_State {
	if m != nil {
		return m.State
	}
	return SecretVersion_STATE_UNSPECIFIED
}

// A policy that defines the replication configuration of data.
type Replication struct {
	// The replication policy for this secret.
	//
	// Types that are valid to be assigned to Replication:
	//	*Replication_Automatic_
	//	*Replication_UserManaged_
	Replication          isReplication_Replication `protobuf_oneof:"replication"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *Replication) Reset()         { *m = Replication{} }
func (m *Replication) String() string { return proto.CompactTextString(m) }
func (*Replication) ProtoMessage()    {}
func (*Replication) Descriptor() ([]byte, []int) {
	return fileDescriptor_71e58bcc3ce7ff53, []int{2}
}

func (m *Replication) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Replication.Unmarshal(m, b)
}
func (m *Replication) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Replication.Marshal(b, m, deterministic)
}
func (m *Replication) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Replication.Merge(m, src)
}
func (m *Replication) XXX_Size() int {
	return xxx_messageInfo_Replication.Size(m)
}
func (m *Replication) XXX_DiscardUnknown() {
	xxx_messageInfo_Replication.DiscardUnknown(m)
}

var xxx_messageInfo_Replication proto.InternalMessageInfo

type isReplication_Replication interface {
	isReplication_Replication()
}

type Replication_Automatic_ struct {
	Automatic *Replication_Automatic `protobuf:"bytes,1,opt,name=automatic,proto3,oneof"`
}

type Replication_UserManaged_ struct {
	UserManaged *Replication_UserManaged `protobuf:"bytes,2,opt,name=user_managed,json=userManaged,proto3,oneof"`
}

func (*Replication_Automatic_) isReplication_Replication() {}

func (*Replication_UserManaged_) isReplication_Replication() {}

func (m *Replication) GetReplication() isReplication_Replication {
	if m != nil {
		return m.Replication
	}
	return nil
}

func (m *Replication) GetAutomatic() *Replication_Automatic {
	if x, ok := m.GetReplication().(*Replication_Automatic_); ok {
		return x.Automatic
	}
	return nil
}

func (m *Replication) GetUserManaged() *Replication_UserManaged {
	if x, ok := m.GetReplication().(*Replication_UserManaged_); ok {
		return x.UserManaged
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Replication) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Replication_Automatic_)(nil),
		(*Replication_UserManaged_)(nil),
	}
}

// A replication policy that replicates the [Secret][google.cloud.secretmanager.v1.Secret] payload without any
// restrictions.
type Replication_Automatic struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Replication_Automatic) Reset()         { *m = Replication_Automatic{} }
func (m *Replication_Automatic) String() string { return proto.CompactTextString(m) }
func (*Replication_Automatic) ProtoMessage()    {}
func (*Replication_Automatic) Descriptor() ([]byte, []int) {
	return fileDescriptor_71e58bcc3ce7ff53, []int{2, 0}
}

func (m *Replication_Automatic) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Replication_Automatic.Unmarshal(m, b)
}
func (m *Replication_Automatic) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Replication_Automatic.Marshal(b, m, deterministic)
}
func (m *Replication_Automatic) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Replication_Automatic.Merge(m, src)
}
func (m *Replication_Automatic) XXX_Size() int {
	return xxx_messageInfo_Replication_Automatic.Size(m)
}
func (m *Replication_Automatic) XXX_DiscardUnknown() {
	xxx_messageInfo_Replication_Automatic.DiscardUnknown(m)
}

var xxx_messageInfo_Replication_Automatic proto.InternalMessageInfo

// A replication policy that replicates the [Secret][google.cloud.secretmanager.v1.Secret] payload into the
// locations specified in [Secret.replication.user_managed.replicas][]
type Replication_UserManaged struct {
	// Required. The list of Replicas for this [Secret][google.cloud.secretmanager.v1.Secret].
	//
	// Cannot be empty.
	Replicas             []*Replication_UserManaged_Replica `protobuf:"bytes,1,rep,name=replicas,proto3" json:"replicas,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *Replication_UserManaged) Reset()         { *m = Replication_UserManaged{} }
func (m *Replication_UserManaged) String() string { return proto.CompactTextString(m) }
func (*Replication_UserManaged) ProtoMessage()    {}
func (*Replication_UserManaged) Descriptor() ([]byte, []int) {
	return fileDescriptor_71e58bcc3ce7ff53, []int{2, 1}
}

func (m *Replication_UserManaged) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Replication_UserManaged.Unmarshal(m, b)
}
func (m *Replication_UserManaged) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Replication_UserManaged.Marshal(b, m, deterministic)
}
func (m *Replication_UserManaged) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Replication_UserManaged.Merge(m, src)
}
func (m *Replication_UserManaged) XXX_Size() int {
	return xxx_messageInfo_Replication_UserManaged.Size(m)
}
func (m *Replication_UserManaged) XXX_DiscardUnknown() {
	xxx_messageInfo_Replication_UserManaged.DiscardUnknown(m)
}

var xxx_messageInfo_Replication_UserManaged proto.InternalMessageInfo

func (m *Replication_UserManaged) GetReplicas() []*Replication_UserManaged_Replica {
	if m != nil {
		return m.Replicas
	}
	return nil
}

// Represents a Replica for this [Secret][google.cloud.secretmanager.v1.Secret].
type Replication_UserManaged_Replica struct {
	// The canonical IDs of the location to replicate data.
	// For example: `"us-east1"`.
	Location             string   `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Replication_UserManaged_Replica) Reset()         { *m = Replication_UserManaged_Replica{} }
func (m *Replication_UserManaged_Replica) String() string { return proto.CompactTextString(m) }
func (*Replication_UserManaged_Replica) ProtoMessage()    {}
func (*Replication_UserManaged_Replica) Descriptor() ([]byte, []int) {
	return fileDescriptor_71e58bcc3ce7ff53, []int{2, 1, 0}
}

func (m *Replication_UserManaged_Replica) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Replication_UserManaged_Replica.Unmarshal(m, b)
}
func (m *Replication_UserManaged_Replica) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Replication_UserManaged_Replica.Marshal(b, m, deterministic)
}
func (m *Replication_UserManaged_Replica) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Replication_UserManaged_Replica.Merge(m, src)
}
func (m *Replication_UserManaged_Replica) XXX_Size() int {
	return xxx_messageInfo_Replication_UserManaged_Replica.Size(m)
}
func (m *Replication_UserManaged_Replica) XXX_DiscardUnknown() {
	xxx_messageInfo_Replication_UserManaged_Replica.DiscardUnknown(m)
}

var xxx_messageInfo_Replication_UserManaged_Replica proto.InternalMessageInfo

func (m *Replication_UserManaged_Replica) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

// A secret payload resource in the Secret Manager API. This contains the
// sensitive secret data that is associated with a [SecretVersion][google.cloud.secretmanager.v1.SecretVersion].
type SecretPayload struct {
	// The secret data. Must be no larger than 64KiB.
	Data                 []byte   `protobuf:"bytes,1,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SecretPayload) Reset()         { *m = SecretPayload{} }
func (m *SecretPayload) String() string { return proto.CompactTextString(m) }
func (*SecretPayload) ProtoMessage()    {}
func (*SecretPayload) Descriptor() ([]byte, []int) {
	return fileDescriptor_71e58bcc3ce7ff53, []int{3}
}

func (m *SecretPayload) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SecretPayload.Unmarshal(m, b)
}
func (m *SecretPayload) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SecretPayload.Marshal(b, m, deterministic)
}
func (m *SecretPayload) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SecretPayload.Merge(m, src)
}
func (m *SecretPayload) XXX_Size() int {
	return xxx_messageInfo_SecretPayload.Size(m)
}
func (m *SecretPayload) XXX_DiscardUnknown() {
	xxx_messageInfo_SecretPayload.DiscardUnknown(m)
}

var xxx_messageInfo_SecretPayload proto.InternalMessageInfo

func (m *SecretPayload) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.secretmanager.v1.SecretVersion_State", SecretVersion_State_name, SecretVersion_State_value)
	proto.RegisterType((*Secret)(nil), "google.cloud.secretmanager.v1.Secret")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.secretmanager.v1.Secret.LabelsEntry")
	proto.RegisterType((*SecretVersion)(nil), "google.cloud.secretmanager.v1.SecretVersion")
	proto.RegisterType((*Replication)(nil), "google.cloud.secretmanager.v1.Replication")
	proto.RegisterType((*Replication_Automatic)(nil), "google.cloud.secretmanager.v1.Replication.Automatic")
	proto.RegisterType((*Replication_UserManaged)(nil), "google.cloud.secretmanager.v1.Replication.UserManaged")
	proto.RegisterType((*Replication_UserManaged_Replica)(nil), "google.cloud.secretmanager.v1.Replication.UserManaged.Replica")
	proto.RegisterType((*SecretPayload)(nil), "google.cloud.secretmanager.v1.SecretPayload")
}

func init() {
	proto.RegisterFile("google/cloud/secretmanager/v1/resources.proto", fileDescriptor_71e58bcc3ce7ff53)
}

var fileDescriptor_71e58bcc3ce7ff53 = []byte{
	// 754 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x55, 0xdd, 0x6a, 0xdb, 0x48,
	0x14, 0x8e, 0x24, 0xdb, 0x89, 0x47, 0x4e, 0xf0, 0x0e, 0xbb, 0xac, 0x57, 0x6c, 0x58, 0xaf, 0xc3,
	0x82, 0x09, 0xac, 0x84, 0xdd, 0x52, 0x5a, 0x95, 0x96, 0xca, 0xb1, 0x9a, 0x38, 0xc4, 0xa9, 0x91,
	0x1d, 0x43, 0xdb, 0x80, 0x19, 0xcb, 0x13, 0x57, 0x8d, 0xac, 0x31, 0xd2, 0xd8, 0x60, 0x42, 0x5e,
	0xa1, 0x77, 0x7d, 0x81, 0x5e, 0xf6, 0x05, 0xfa, 0x0e, 0x7d, 0x8a, 0x5c, 0x07, 0x7a, 0xd7, 0x8b,
	0x5e, 0x16, 0xcf, 0x8c, 0xfc, 0x53, 0x48, 0xea, 0xf4, 0x6e, 0xce, 0xcf, 0xf7, 0xe9, 0x3b, 0xe7,
	0xcc, 0x19, 0x81, 0xff, 0xfb, 0x84, 0xf4, 0x7d, 0x6c, 0xb8, 0x3e, 0x19, 0xf5, 0x8c, 0x08, 0xbb,
	0x21, 0xa6, 0x03, 0x14, 0xa0, 0x3e, 0x0e, 0x8d, 0x71, 0xc9, 0x08, 0x71, 0x44, 0x46, 0xa1, 0x8b,
	0x23, 0x7d, 0x18, 0x12, 0x4a, 0xe0, 0x36, 0x4f, 0xd7, 0x59, 0xba, 0xbe, 0x94, 0xae, 0x8f, 0x4b,
	0xda, 0x3f, 0x82, 0x0d, 0x0d, 0x3d, 0xe3, 0xcc, 0xc3, 0x7e, 0xaf, 0xd3, 0xc5, 0x6f, 0xd0, 0xd8,
	0x23, 0x21, 0xc7, 0x6b, 0x7f, 0x2d, 0x24, 0xc4, 0xdc, 0x22, 0x14, 0x63, 0x99, 0xd5, 0x1d, 0x9d,
	0x19, 0xd4, 0x1b, 0xe0, 0x88, 0xa2, 0xc1, 0x50, 0x24, 0xfc, 0xbd, 0x80, 0x45, 0x41, 0x40, 0x28,
	0xa2, 0x1e, 0x09, 0x84, 0xb2, 0xc2, 0x3b, 0x05, 0xa4, 0x9a, 0x4c, 0x0f, 0xfc, 0x13, 0x24, 0x02,
	0x34, 0xc0, 0x39, 0x29, 0x2f, 0x15, 0xd3, 0x15, 0xe5, 0xca, 0x52, 0x1c, 0xe6, 0x80, 0x2d, 0xa0,
	0x86, 0x78, 0xe8, 0x7b, 0x2e, 0x43, 0xe6, 0xe4, 0xbc, 0x54, 0x54, 0xcb, 0xbb, 0xfa, 0xad, 0x35,
	0xe9, 0xce, 0x1c, 0x51, 0x49, 0x5d, 0x59, 0xc9, 0x2b, 0x4b, 0x76, 0x16, 0x69, 0xe0, 0x33, 0xa0,
	0xba, 0x21, 0x46, 0x14, 0x77, 0xa6, 0x8a, 0x73, 0x0a, 0x63, 0xd5, 0x62, 0xd6, 0xb8, 0x1c, 0xbd,
	0x15, 0x97, 0xc3, 0x15, 0x01, 0x8e, 0x99, 0x7a, 0x61, 0x0d, 0xa4, 0x7c, 0xd4, 0xc5, 0x7e, 0x94,
	0x4b, 0xe4, 0x95, 0xa2, 0x5a, 0x2e, 0xfd, 0x44, 0x12, 0xaf, 0x53, 0x3f, 0x62, 0x18, 0x3b, 0xa0,
	0xe1, 0xc4, 0x11, 0x04, 0xda, 0x23, 0xa0, 0x2e, 0xb8, 0x61, 0x16, 0x28, 0xe7, 0x78, 0xc2, 0x3b,
	0xe1, 0x4c, 0x8f, 0xf0, 0x77, 0x90, 0x1c, 0x23, 0x7f, 0x84, 0x59, 0xf5, 0x69, 0x87, 0x1b, 0xa6,
	0xfc, 0x50, 0x32, 0xeb, 0xd7, 0xd6, 0x21, 0xd8, 0x59, 0xfe, 0x18, 0xd7, 0x81, 0x86, 0x5e, 0xa4,
	0xbb, 0x64, 0x60, 0x88, 0x06, 0xef, 0x0c, 0x43, 0xf2, 0x16, 0xbb, 0x34, 0x32, 0x2e, 0xc4, 0xe9,
	0x52, 0x5c, 0x9d, 0xc8, 0xb8, 0xe0, 0x87, 0xcb, 0xc2, 0x27, 0x05, 0x6c, 0xf2, 0xfc, 0x36, 0x0e,
	0xa3, 0x69, 0xa3, 0x6e, 0x9c, 0xcb, 0x0f, 0x1d, 0x94, 0xef, 0xde, 0xc1, 0x0a, 0xc8, 0xf4, 0x70,
	0x44, 0x43, 0x32, 0xb9, 0xd3, 0x10, 0x54, 0x01, 0x62, 0x1c, 0x75, 0x90, 0x8c, 0x28, 0xa2, 0x38,
	0x97, 0xc8, 0x4b, 0xc5, 0xad, 0x72, 0x79, 0xa5, 0x21, 0x88, 0xda, 0xf4, 0xe6, 0x14, 0xc9, 0x49,
	0x39, 0x4b, 0xe1, 0x00, 0x24, 0x99, 0x13, 0xfe, 0x01, 0x7e, 0x6b, 0xb6, 0xac, 0x96, 0xdd, 0x39,
	0x39, 0x6e, 0x36, 0xec, 0xbd, 0xda, 0xf3, 0x9a, 0x5d, 0xcd, 0xae, 0x41, 0x15, 0xac, 0xdb, 0xc7,
	0x56, 0xe5, 0xc8, 0xae, 0x66, 0x25, 0x98, 0x01, 0x1b, 0xd5, 0x5a, 0x93, 0x5b, 0x32, 0xdc, 0x04,
	0xe9, 0xaa, 0xdd, 0x6c, 0x39, 0x2f, 0x5e, 0xda, 0xd5, 0xac, 0x62, 0x06, 0xd7, 0xd6, 0x39, 0xd8,
	0x5d, 0x61, 0x30, 0x71, 0xa3, 0x9f, 0xac, 0x30, 0x1f, 0x63, 0xcc, 0x93, 0x67, 0x9e, 0x8e, 0x70,
	0x5c, 0x16, 0xbe, 0xca, 0x40, 0x5d, 0xb8, 0xf5, 0xb0, 0x05, 0xd2, 0x68, 0x44, 0xc9, 0x00, 0x51,
	0xcf, 0x65, 0xc3, 0x53, 0xcb, 0xf7, 0x57, 0x5f, 0x1a, 0xdd, 0x8a, 0xb1, 0x07, 0x6b, 0xce, 0x9c,
	0x08, 0xbe, 0x06, 0x99, 0x51, 0x84, 0xc3, 0x0e, 0x47, 0xf5, 0xc4, 0xd4, 0x1f, 0xdc, 0x81, 0xf8,
	0x24, 0xc2, 0x61, 0x9d, 0xa3, 0x0f, 0xd6, 0x1c, 0x75, 0x34, 0x37, 0x35, 0x15, 0xa4, 0x67, 0x9f,
	0xd5, 0xde, 0x4b, 0x40, 0x5d, 0xc8, 0x85, 0x1d, 0xb0, 0x21, 0xf6, 0x37, 0xca, 0x49, 0x6c, 0xe1,
	0x9e, 0xfe, 0xda, 0x57, 0x63, 0xff, 0x74, 0xee, 0xb2, 0x33, 0x23, 0xd5, 0xfe, 0x03, 0xeb, 0x22,
	0x02, 0x35, 0xb0, 0xe1, 0x13, 0xf1, 0xde, 0xf0, 0x2d, 0x9c, 0xd9, 0x95, 0xcd, 0xa5, 0xe7, 0xa8,
	0xb0, 0x13, 0xef, 0x4b, 0x03, 0x4d, 0x7c, 0x82, 0x7a, 0x10, 0x82, 0x44, 0x0f, 0x51, 0xc4, 0x70,
	0x19, 0x87, 0x9d, 0x2b, 0x5f, 0x24, 0xf0, 0xaf, 0x4b, 0x06, 0xb7, 0xeb, 0xad, 0x6c, 0x39, 0xf1,
	0xbb, 0xdd, 0x98, 0xde, 0xfc, 0x86, 0xf4, 0xea, 0x50, 0x00, 0xfa, 0xc4, 0x47, 0x41, 0x5f, 0x27,
	0x61, 0xdf, 0xe8, 0xe3, 0x80, 0xed, 0x85, 0x31, 0xbf, 0x4b, 0x37, 0xfc, 0x06, 0x1e, 0x2f, 0x39,
	0xbe, 0x49, 0xd2, 0x07, 0x59, 0xd9, 0x6f, 0xd6, 0x3f, 0xca, 0xdb, 0xfb, 0x9c, 0x75, 0x8f, 0xc9,
	0xe0, 0xea, 0xeb, 0x42, 0x46, 0xbb, 0xf4, 0x39, 0x8e, 0x9f, 0xb2, 0xf8, 0xe9, 0x52, 0xfc, 0xb4,
	0x5d, 0xba, 0x96, 0xf3, 0x3c, 0x6e, 0x9a, 0x2c, 0xc1, 0x34, 0x97, 0x32, 0x4c, 0xb3, 0x5d, 0xea,
	0xa6, 0x98, 0xc4, 0x7b, 0xdf, 0x03, 0x00, 0x00, 0xff, 0xff, 0xa5, 0xfc, 0x16, 0x7c, 0xa8, 0x06,
	0x00, 0x00,
}
