// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/billing/budgets/v1alpha1/budget_model.proto

package budgets

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	money "google.golang.org/genproto/googleapis/type/money"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The type of basis used to determine if spend has passed the threshold.
type ThresholdRule_Basis int32

const (
	// Unspecified threshold basis.
	ThresholdRule_BASIS_UNSPECIFIED ThresholdRule_Basis = 0
	// Use current spend as the basis for comparison against the threshold.
	ThresholdRule_CURRENT_SPEND ThresholdRule_Basis = 1
	// Use forecasted spend for the period as the basis for comparison against
	// the threshold.
	ThresholdRule_FORECASTED_SPEND ThresholdRule_Basis = 2
)

var ThresholdRule_Basis_name = map[int32]string{
	0: "BASIS_UNSPECIFIED",
	1: "CURRENT_SPEND",
	2: "FORECASTED_SPEND",
}

var ThresholdRule_Basis_value = map[string]int32{
	"BASIS_UNSPECIFIED": 0,
	"CURRENT_SPEND":     1,
	"FORECASTED_SPEND":  2,
}

func (x ThresholdRule_Basis) String() string {
	return proto.EnumName(ThresholdRule_Basis_name, int32(x))
}

func (ThresholdRule_Basis) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_2c65515af418c512, []int{3, 0}
}

// Specifies how credits should be treated when determining spend for
// threshold calculations.
type Filter_CreditTypesTreatment int32

const (
	Filter_CREDIT_TYPES_TREATMENT_UNSPECIFIED Filter_CreditTypesTreatment = 0
	// All types of credit are subtracted from the gross cost to determine the
	// spend for threshold calculations.
	Filter_INCLUDE_ALL_CREDITS Filter_CreditTypesTreatment = 1
	// All types of credit are added to the net cost to determine the spend for
	// threshold calculations.
	Filter_EXCLUDE_ALL_CREDITS Filter_CreditTypesTreatment = 2
)

var Filter_CreditTypesTreatment_name = map[int32]string{
	0: "CREDIT_TYPES_TREATMENT_UNSPECIFIED",
	1: "INCLUDE_ALL_CREDITS",
	2: "EXCLUDE_ALL_CREDITS",
}

var Filter_CreditTypesTreatment_value = map[string]int32{
	"CREDIT_TYPES_TREATMENT_UNSPECIFIED": 0,
	"INCLUDE_ALL_CREDITS":                1,
	"EXCLUDE_ALL_CREDITS":                2,
}

func (x Filter_CreditTypesTreatment) String() string {
	return proto.EnumName(Filter_CreditTypesTreatment_name, int32(x))
}

func (Filter_CreditTypesTreatment) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_2c65515af418c512, []int{5, 0}
}

// A budget is a plan that describes what you expect to spend on Cloud
// projects, plus the rules to execute as spend is tracked against that plan,
// (for example, send an alert when 90% of the target spend is met).
// Currently all plans are monthly budgets so the usage period(s) tracked are
// implied (calendar months of usage back-to-back).
type Budget struct {
	// Output only. Resource name of the budget.
	// The resource name implies the scope of a budget. Values are of the form
	// `billingAccounts/{billingAccountId}/budgets/{budgetId}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// User data for display name in UI.
	// Validation: <= 60 chars.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. Filters that define which resources are used to compute
	// the actual spend against the budget.
	BudgetFilter *Filter `protobuf:"bytes,3,opt,name=budget_filter,json=budgetFilter,proto3" json:"budget_filter,omitempty"`
	// Required. Budgeted amount.
	Amount *BudgetAmount `protobuf:"bytes,4,opt,name=amount,proto3" json:"amount,omitempty"`
	// Optional. Rules that trigger alerts (notifications of thresholds
	// being crossed) when spend exceeds the specified percentages of the budget.
	ThresholdRules []*ThresholdRule `protobuf:"bytes,5,rep,name=threshold_rules,json=thresholdRules,proto3" json:"threshold_rules,omitempty"`
	// Optional. Rules to apply to all updates to the actual spend, regardless
	// of the thresholds set in `threshold_rules`.
	AllUpdatesRule *AllUpdatesRule `protobuf:"bytes,6,opt,name=all_updates_rule,json=allUpdatesRule,proto3" json:"all_updates_rule,omitempty"`
	// Optional. Etag to validate that the object is unchanged for a
	// read-modify-write operation.
	// An empty etag will cause an update to overwrite other changes.
	Etag                 string   `protobuf:"bytes,7,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Budget) Reset()         { *m = Budget{} }
func (m *Budget) String() string { return proto.CompactTextString(m) }
func (*Budget) ProtoMessage()    {}
func (*Budget) Descriptor() ([]byte, []int) {
	return fileDescriptor_2c65515af418c512, []int{0}
}

func (m *Budget) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Budget.Unmarshal(m, b)
}
func (m *Budget) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Budget.Marshal(b, m, deterministic)
}
func (m *Budget) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Budget.Merge(m, src)
}
func (m *Budget) XXX_Size() int {
	return xxx_messageInfo_Budget.Size(m)
}
func (m *Budget) XXX_DiscardUnknown() {
	xxx_messageInfo_Budget.DiscardUnknown(m)
}

var xxx_messageInfo_Budget proto.InternalMessageInfo

func (m *Budget) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Budget) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Budget) GetBudgetFilter() *Filter {
	if m != nil {
		return m.BudgetFilter
	}
	return nil
}

func (m *Budget) GetAmount() *BudgetAmount {
	if m != nil {
		return m.Amount
	}
	return nil
}

func (m *Budget) GetThresholdRules() []*ThresholdRule {
	if m != nil {
		return m.ThresholdRules
	}
	return nil
}

func (m *Budget) GetAllUpdatesRule() *AllUpdatesRule {
	if m != nil {
		return m.AllUpdatesRule
	}
	return nil
}

func (m *Budget) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

// The budgeted amount for each usage period.
type BudgetAmount struct {
	// Specification for what amount to use as the budget.
	//
	// Types that are valid to be assigned to BudgetAmount:
	//	*BudgetAmount_SpecifiedAmount
	//	*BudgetAmount_LastPeriodAmount
	BudgetAmount         isBudgetAmount_BudgetAmount `protobuf_oneof:"budget_amount"`
	XXX_NoUnkeyedLiteral struct{}                    `json:"-"`
	XXX_unrecognized     []byte                      `json:"-"`
	XXX_sizecache        int32                       `json:"-"`
}

func (m *BudgetAmount) Reset()         { *m = BudgetAmount{} }
func (m *BudgetAmount) String() string { return proto.CompactTextString(m) }
func (*BudgetAmount) ProtoMessage()    {}
func (*BudgetAmount) Descriptor() ([]byte, []int) {
	return fileDescriptor_2c65515af418c512, []int{1}
}

func (m *BudgetAmount) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BudgetAmount.Unmarshal(m, b)
}
func (m *BudgetAmount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BudgetAmount.Marshal(b, m, deterministic)
}
func (m *BudgetAmount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BudgetAmount.Merge(m, src)
}
func (m *BudgetAmount) XXX_Size() int {
	return xxx_messageInfo_BudgetAmount.Size(m)
}
func (m *BudgetAmount) XXX_DiscardUnknown() {
	xxx_messageInfo_BudgetAmount.DiscardUnknown(m)
}

var xxx_messageInfo_BudgetAmount proto.InternalMessageInfo

type isBudgetAmount_BudgetAmount interface {
	isBudgetAmount_BudgetAmount()
}

type BudgetAmount_SpecifiedAmount struct {
	SpecifiedAmount *money.Money `protobuf:"bytes,1,opt,name=specified_amount,json=specifiedAmount,proto3,oneof"`
}

type BudgetAmount_LastPeriodAmount struct {
	LastPeriodAmount *LastPeriodAmount `protobuf:"bytes,2,opt,name=last_period_amount,json=lastPeriodAmount,proto3,oneof"`
}

func (*BudgetAmount_SpecifiedAmount) isBudgetAmount_BudgetAmount() {}

func (*BudgetAmount_LastPeriodAmount) isBudgetAmount_BudgetAmount() {}

func (m *BudgetAmount) GetBudgetAmount() isBudgetAmount_BudgetAmount {
	if m != nil {
		return m.BudgetAmount
	}
	return nil
}

func (m *BudgetAmount) GetSpecifiedAmount() *money.Money {
	if x, ok := m.GetBudgetAmount().(*BudgetAmount_SpecifiedAmount); ok {
		return x.SpecifiedAmount
	}
	return nil
}

func (m *BudgetAmount) GetLastPeriodAmount() *LastPeriodAmount {
	if x, ok := m.GetBudgetAmount().(*BudgetAmount_LastPeriodAmount); ok {
		return x.LastPeriodAmount
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*BudgetAmount) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*BudgetAmount_SpecifiedAmount)(nil),
		(*BudgetAmount_LastPeriodAmount)(nil),
	}
}

// Describes a budget amount targeted to last period's spend.
// At this time, the amount is automatically 100% of last period's spend;
// that is, there are no other options yet.
// Future configuration will be described here (for example, configuring a
// percentage of last period's spend).
type LastPeriodAmount struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LastPeriodAmount) Reset()         { *m = LastPeriodAmount{} }
func (m *LastPeriodAmount) String() string { return proto.CompactTextString(m) }
func (*LastPeriodAmount) ProtoMessage()    {}
func (*LastPeriodAmount) Descriptor() ([]byte, []int) {
	return fileDescriptor_2c65515af418c512, []int{2}
}

func (m *LastPeriodAmount) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LastPeriodAmount.Unmarshal(m, b)
}
func (m *LastPeriodAmount) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LastPeriodAmount.Marshal(b, m, deterministic)
}
func (m *LastPeriodAmount) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LastPeriodAmount.Merge(m, src)
}
func (m *LastPeriodAmount) XXX_Size() int {
	return xxx_messageInfo_LastPeriodAmount.Size(m)
}
func (m *LastPeriodAmount) XXX_DiscardUnknown() {
	xxx_messageInfo_LastPeriodAmount.DiscardUnknown(m)
}

var xxx_messageInfo_LastPeriodAmount proto.InternalMessageInfo

// ThresholdRule contains a definition of a threshold which triggers
// an alert (a notification of a threshold being crossed) to be sent when
// spend goes above the specified amount.
// Alerts are automatically e-mailed to users with the Billing Account
// Administrator role or the Billing Account User role.
// The thresholds here have no effect on notifications sent to anything
// configured under `Budget.all_updates_rule`.
type ThresholdRule struct {
	// Required. Send an alert when this threshold is exceeded.
	// This is a 1.0-based percentage, so 0.5 = 50%.
	// Validation: non-negative number.
	ThresholdPercent float64 `protobuf:"fixed64,1,opt,name=threshold_percent,json=thresholdPercent,proto3" json:"threshold_percent,omitempty"`
	// Optional. The type of basis used to determine if spend has passed the
	// threshold. Behavior defaults to CURRENT_SPEND if not set.
	SpendBasis           ThresholdRule_Basis `protobuf:"varint,2,opt,name=spend_basis,json=spendBasis,proto3,enum=google.cloud.billing.budgets.v1alpha1.ThresholdRule_Basis" json:"spend_basis,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *ThresholdRule) Reset()         { *m = ThresholdRule{} }
func (m *ThresholdRule) String() string { return proto.CompactTextString(m) }
func (*ThresholdRule) ProtoMessage()    {}
func (*ThresholdRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_2c65515af418c512, []int{3}
}

func (m *ThresholdRule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ThresholdRule.Unmarshal(m, b)
}
func (m *ThresholdRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ThresholdRule.Marshal(b, m, deterministic)
}
func (m *ThresholdRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ThresholdRule.Merge(m, src)
}
func (m *ThresholdRule) XXX_Size() int {
	return xxx_messageInfo_ThresholdRule.Size(m)
}
func (m *ThresholdRule) XXX_DiscardUnknown() {
	xxx_messageInfo_ThresholdRule.DiscardUnknown(m)
}

var xxx_messageInfo_ThresholdRule proto.InternalMessageInfo

func (m *ThresholdRule) GetThresholdPercent() float64 {
	if m != nil {
		return m.ThresholdPercent
	}
	return 0
}

func (m *ThresholdRule) GetSpendBasis() ThresholdRule_Basis {
	if m != nil {
		return m.SpendBasis
	}
	return ThresholdRule_BASIS_UNSPECIFIED
}

// AllUpdatesRule defines notifications that are sent on every update to the
// billing account's spend, regardless of the thresholds defined using
// threshold rules.
type AllUpdatesRule struct {
	// Required. The name of the Cloud Pub/Sub topic where budget related messages will be
	// published, in the form `projects/{project_id}/topics/{topic_id}`. Updates
	// are sent at regular intervals to the topic.
	// The topic needs to be created before the budget is created; see
	// https://cloud.google.com/billing/docs/how-to/budgets#manage-notifications
	// for more details.
	// Caller is expected to have
	// `pubsub.topics.setIamPolicy` permission on the topic when it's set for a
	// budget, otherwise, the API call will fail with PERMISSION_DENIED. See
	// https://cloud.google.com/pubsub/docs/access-control for more details on
	// Pub/Sub roles and permissions.
	PubsubTopic string `protobuf:"bytes,1,opt,name=pubsub_topic,json=pubsubTopic,proto3" json:"pubsub_topic,omitempty"`
	// Required. The schema version of the notification.
	// Only "1.0" is accepted. It represents the JSON schema as defined in
	// https://cloud.google.com/billing/docs/how-to/budgets#notification_format
	SchemaVersion        string   `protobuf:"bytes,2,opt,name=schema_version,json=schemaVersion,proto3" json:"schema_version,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AllUpdatesRule) Reset()         { *m = AllUpdatesRule{} }
func (m *AllUpdatesRule) String() string { return proto.CompactTextString(m) }
func (*AllUpdatesRule) ProtoMessage()    {}
func (*AllUpdatesRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_2c65515af418c512, []int{4}
}

func (m *AllUpdatesRule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AllUpdatesRule.Unmarshal(m, b)
}
func (m *AllUpdatesRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AllUpdatesRule.Marshal(b, m, deterministic)
}
func (m *AllUpdatesRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AllUpdatesRule.Merge(m, src)
}
func (m *AllUpdatesRule) XXX_Size() int {
	return xxx_messageInfo_AllUpdatesRule.Size(m)
}
func (m *AllUpdatesRule) XXX_DiscardUnknown() {
	xxx_messageInfo_AllUpdatesRule.DiscardUnknown(m)
}

var xxx_messageInfo_AllUpdatesRule proto.InternalMessageInfo

func (m *AllUpdatesRule) GetPubsubTopic() string {
	if m != nil {
		return m.PubsubTopic
	}
	return ""
}

func (m *AllUpdatesRule) GetSchemaVersion() string {
	if m != nil {
		return m.SchemaVersion
	}
	return ""
}

// A filter for a budget, limiting the scope of the cost to calculate.
type Filter struct {
	// Optional. A set of projects of the form `projects/{project}`,
	// specifying that usage from only this set of projects should be
	// included in the budget. If omitted, the report will include all usage for
	// the billing account, regardless of which project the usage occurred on.
	// Only zero or one project can be specified currently.
	Projects []string `protobuf:"bytes,1,rep,name=projects,proto3" json:"projects,omitempty"`
	// Optional. If not set, default behavior is `INCLUDE_ALL_CREDITS`.
	CreditTypesTreatment Filter_CreditTypesTreatment `protobuf:"varint,4,opt,name=credit_types_treatment,json=creditTypesTreatment,proto3,enum=google.cloud.billing.budgets.v1alpha1.Filter_CreditTypesTreatment" json:"credit_types_treatment,omitempty"`
	// Optional. A set of services of the form `services/{service_id}`,
	// specifying that usage from only this set of services should be
	// included in the budget. If omitted, the report will include usage for
	// all the services.
	// The service names are available through the Catalog API:
	// https://cloud.google.com/billing/v1/how-tos/catalog-api.
	Services             []string `protobuf:"bytes,3,rep,name=services,proto3" json:"services,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Filter) Reset()         { *m = Filter{} }
func (m *Filter) String() string { return proto.CompactTextString(m) }
func (*Filter) ProtoMessage()    {}
func (*Filter) Descriptor() ([]byte, []int) {
	return fileDescriptor_2c65515af418c512, []int{5}
}

func (m *Filter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Filter.Unmarshal(m, b)
}
func (m *Filter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Filter.Marshal(b, m, deterministic)
}
func (m *Filter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Filter.Merge(m, src)
}
func (m *Filter) XXX_Size() int {
	return xxx_messageInfo_Filter.Size(m)
}
func (m *Filter) XXX_DiscardUnknown() {
	xxx_messageInfo_Filter.DiscardUnknown(m)
}

var xxx_messageInfo_Filter proto.InternalMessageInfo

func (m *Filter) GetProjects() []string {
	if m != nil {
		return m.Projects
	}
	return nil
}

func (m *Filter) GetCreditTypesTreatment() Filter_CreditTypesTreatment {
	if m != nil {
		return m.CreditTypesTreatment
	}
	return Filter_CREDIT_TYPES_TREATMENT_UNSPECIFIED
}

func (m *Filter) GetServices() []string {
	if m != nil {
		return m.Services
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.billing.budgets.v1alpha1.ThresholdRule_Basis", ThresholdRule_Basis_name, ThresholdRule_Basis_value)
	proto.RegisterEnum("google.cloud.billing.budgets.v1alpha1.Filter_CreditTypesTreatment", Filter_CreditTypesTreatment_name, Filter_CreditTypesTreatment_value)
	proto.RegisterType((*Budget)(nil), "google.cloud.billing.budgets.v1alpha1.Budget")
	proto.RegisterType((*BudgetAmount)(nil), "google.cloud.billing.budgets.v1alpha1.BudgetAmount")
	proto.RegisterType((*LastPeriodAmount)(nil), "google.cloud.billing.budgets.v1alpha1.LastPeriodAmount")
	proto.RegisterType((*ThresholdRule)(nil), "google.cloud.billing.budgets.v1alpha1.ThresholdRule")
	proto.RegisterType((*AllUpdatesRule)(nil), "google.cloud.billing.budgets.v1alpha1.AllUpdatesRule")
	proto.RegisterType((*Filter)(nil), "google.cloud.billing.budgets.v1alpha1.Filter")
}

func init() {
	proto.RegisterFile("google/cloud/billing/budgets/v1alpha1/budget_model.proto", fileDescriptor_2c65515af418c512)
}

var fileDescriptor_2c65515af418c512 = []byte{
	// 811 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x55, 0xdd, 0x6e, 0xe3, 0x44,
	0x18, 0xad, 0x93, 0x6e, 0x80, 0x49, 0x9b, 0xba, 0x43, 0xa1, 0x61, 0x6f, 0xb6, 0x58, 0xb0, 0x2a,
	0x48, 0xd8, 0x6c, 0x16, 0x04, 0x5a, 0x2e, 0x90, 0x93, 0xb8, 0x6c, 0xa4, 0x6c, 0x88, 0x1c, 0x97,
	0x9f, 0x95, 0xd0, 0x30, 0xb1, 0xa7, 0xce, 0xa0, 0xb1, 0xc7, 0xf2, 0x8c, 0x2b, 0x55, 0x55, 0x1f,
	0x8a, 0x6b, 0x9e, 0x80, 0xb7, 0xe0, 0x1a, 0xf1, 0x10, 0xc8, 0x33, 0xe3, 0x34, 0x59, 0x56, 0x22,
	0x70, 0x67, 0x9d, 0xf3, 0x9d, 0xf3, 0xcd, 0x37, 0xdf, 0xc9, 0x04, 0x7c, 0x99, 0x72, 0x9e, 0x32,
	0xe2, 0xc5, 0x8c, 0x57, 0x89, 0xb7, 0xa4, 0x8c, 0xd1, 0x3c, 0xf5, 0x96, 0x55, 0x92, 0x12, 0x29,
	0xbc, 0xeb, 0x27, 0x98, 0x15, 0x2b, 0xfc, 0xc4, 0x00, 0x28, 0xe3, 0x09, 0x61, 0x6e, 0x51, 0x72,
	0xc9, 0xe1, 0x87, 0x5a, 0xe9, 0x2a, 0xa5, 0x6b, 0x94, 0xae, 0x51, 0xba, 0x8d, 0xf2, 0xe1, 0x23,
	0xd3, 0x00, 0x17, 0xd4, 0xbb, 0xa2, 0x84, 0x25, 0x68, 0x49, 0x56, 0xf8, 0x9a, 0xf2, 0x52, 0xfb,
	0x3c, 0x7c, 0x6f, 0xa3, 0xa0, 0x24, 0x82, 0x57, 0x65, 0x4c, 0x0c, 0x75, 0x6a, 0x28, 0x79, 0x53,
	0x10, 0x2f, 0xe3, 0x39, 0xb9, 0xd1, 0x84, 0xf3, 0xeb, 0x3e, 0xe8, 0x0c, 0x55, 0x27, 0x78, 0x0a,
	0xf6, 0x73, 0x9c, 0x91, 0xbe, 0x75, 0x66, 0x9d, 0xbf, 0x35, 0x6c, 0xff, 0xe1, 0xb7, 0x43, 0x05,
	0xc0, 0xf7, 0xc1, 0x41, 0x42, 0x45, 0xc1, 0xf0, 0x0d, 0x52, 0x05, 0xad, 0xba, 0x20, 0xec, 0x1a,
	0x6c, 0x56, 0x97, 0x7c, 0x0f, 0x0e, 0xcd, 0x60, 0x57, 0x94, 0x49, 0x52, 0xf6, 0xdb, 0x67, 0xd6,
	0x79, 0x77, 0xf0, 0x89, 0xbb, 0xd3, 0x68, 0xee, 0x85, 0x12, 0xd5, 0x3d, 0xad, 0xf0, 0x40, 0xb3,
	0x1a, 0x82, 0x73, 0xd0, 0xc1, 0x19, 0xaf, 0x72, 0xd9, 0xdf, 0x57, 0x8e, 0x4f, 0x77, 0x74, 0xd4,
	0x33, 0xf9, 0x4a, 0x5a, 0xfb, 0xb6, 0x42, 0xe3, 0x03, 0x97, 0xe0, 0x48, 0xae, 0x4a, 0x22, 0x56,
	0x9c, 0x25, 0xa8, 0xac, 0x18, 0x11, 0xfd, 0x07, 0x67, 0xed, 0xf3, 0xee, 0xe0, 0xb3, 0x1d, 0xad,
	0xa3, 0x46, 0x1d, 0x56, 0x8c, 0xe8, 0x33, 0xf7, 0xe4, 0x26, 0x26, 0x60, 0x02, 0x6c, 0xcc, 0x18,
	0xaa, 0x8a, 0x04, 0x4b, 0x22, 0x54, 0x97, 0x7e, 0x47, 0x9d, 0xff, 0xf3, 0x1d, 0x9b, 0xf8, 0x8c,
	0x5d, 0x6a, 0xf5, 0x46, 0x17, 0xbc, 0x05, 0xd6, 0x0b, 0x23, 0x12, 0xa7, 0xfd, 0x37, 0x9a, 0x85,
	0x59, 0xa1, 0x02, 0x9e, 0xfd, 0xf4, 0xa7, 0xff, 0x12, 0x7c, 0x60, 0xbc, 0x1b, 0x6b, 0xdd, 0x17,
	0x17, 0x54, 0xb8, 0x31, 0xcf, 0x3c, 0xb3, 0xf4, 0x81, 0xa9, 0xf2, 0xe3, 0xb8, 0xbe, 0x1d, 0xe1,
	0xdd, 0x1a, 0x00, 0x61, 0x8d, 0xdc, 0xad, 0x23, 0x7c, 0xab, 0x3f, 0xee, 0x9c, 0xdf, 0x2d, 0x70,
	0xb0, 0x79, 0xbf, 0xf0, 0x6b, 0x60, 0x8b, 0x82, 0xc4, 0xf4, 0x8a, 0x92, 0x04, 0x99, 0x75, 0x59,
	0x6a, 0x5c, 0xd8, 0x8c, 0x5b, 0x07, 0xcf, 0x7d, 0x51, 0x07, 0xef, 0xf9, 0x5e, 0x78, 0xb4, 0xae,
	0x36, 0x06, 0x29, 0x80, 0x0c, 0x0b, 0x89, 0x0a, 0x52, 0x52, 0xbe, 0xb6, 0x68, 0x29, 0x8b, 0x2f,
	0x76, 0xbc, 0xb1, 0x29, 0x16, 0x72, 0xae, 0xf4, 0xda, 0xf4, 0xf9, 0x5e, 0x68, 0xb3, 0x57, 0xb0,
	0xe1, 0xd1, 0x3a, 0xa7, 0xba, 0x87, 0x03, 0x81, 0xfd, 0xaa, 0xd0, 0xf9, 0xcb, 0x02, 0x87, 0x5b,
	0x4b, 0x86, 0x9f, 0x82, 0xe3, 0xfb, 0xcc, 0x14, 0xa4, 0x8c, 0x89, 0x99, 0xd0, 0xd2, 0xd9, 0xb2,
	0xd7, 0xec, 0x5c, 0x93, 0xf0, 0x67, 0xd0, 0x15, 0x05, 0xc9, 0x13, 0xb4, 0xc4, 0x82, 0x0a, 0x35,
	0x4a, 0x6f, 0xf0, 0xec, 0xff, 0x24, 0xcc, 0x1d, 0xd6, 0x0e, 0x7a, 0xbd, 0x40, 0x79, 0x2a, 0xc0,
	0xf9, 0x06, 0x3c, 0x50, 0x1f, 0xf0, 0x1d, 0x70, 0x3c, 0xf4, 0x17, 0x93, 0x05, 0xba, 0x9c, 0x2d,
	0xe6, 0xc1, 0x68, 0x72, 0x31, 0x09, 0xc6, 0xf6, 0x1e, 0x3c, 0x06, 0x87, 0xa3, 0xcb, 0x30, 0x0c,
	0x66, 0x11, 0x5a, 0xcc, 0x83, 0xd9, 0xd8, 0xb6, 0xe0, 0x09, 0xb0, 0x2f, 0xbe, 0x0d, 0x83, 0x91,
	0xbf, 0x88, 0x82, 0xb1, 0x41, 0x5b, 0x4e, 0x02, 0x7a, 0xdb, 0x69, 0x83, 0x8f, 0xc1, 0x41, 0x51,
	0x2d, 0x45, 0xb5, 0x44, 0x92, 0x17, 0x34, 0xbe, 0x7f, 0x11, 0x5a, 0x61, 0x57, 0x13, 0x51, 0x8d,
	0xc3, 0x8f, 0x41, 0x4f, 0xc4, 0x2b, 0x92, 0x61, 0x74, 0x4d, 0x4a, 0x41, 0x79, 0xae, 0x9f, 0x06,
	0x5d, 0x79, 0xa8, 0xa9, 0xef, 0x34, 0xe3, 0xfc, 0xd6, 0x02, 0x1d, 0xf3, 0x9b, 0x7e, 0x04, 0xde,
	0x2c, 0x4a, 0xfe, 0x0b, 0x89, 0xa5, 0xe8, 0x5b, 0x67, 0xed, 0x26, 0xbb, 0x6b, 0x10, 0xde, 0x81,
	0x77, 0xe3, 0x92, 0x24, 0x54, 0xa2, 0x3a, 0x36, 0x02, 0xc9, 0x92, 0x60, 0x99, 0x11, 0xf3, 0x08,
	0xf4, 0x06, 0xc3, 0xff, 0xf4, 0xac, 0xb8, 0x23, 0xe5, 0x15, 0xd5, 0x56, 0x51, 0xe3, 0xa4, 0x5b,
	0x9e, 0xc4, 0xaf, 0xa1, 0xea, 0xf3, 0x09, 0x52, 0x5e, 0xd3, 0x98, 0x88, 0x7e, 0x7b, 0xe3, 0x7c,
	0x0d, 0xe8, 0x14, 0xe0, 0xe4, 0x75, 0x9e, 0xf0, 0x31, 0x70, 0x46, 0x61, 0x30, 0x9e, 0x44, 0x28,
	0xfa, 0x71, 0x1e, 0x2c, 0x50, 0x14, 0x06, 0x7e, 0xf4, 0xa2, 0xde, 0xc0, 0xf6, 0x6a, 0x4e, 0xc1,
	0xdb, 0x93, 0xd9, 0x68, 0x7a, 0x39, 0x0e, 0x90, 0x3f, 0x9d, 0x22, 0xad, 0x59, 0xd8, 0x56, 0x4d,
	0x04, 0x3f, 0xfc, 0x93, 0x68, 0x0d, 0x6f, 0xc1, 0x47, 0x31, 0xcf, 0x76, 0x1b, 0x7b, 0x6e, 0xbd,
	0x9c, 0x9a, 0xc2, 0x94, 0x33, 0x9c, 0xa7, 0x2e, 0x2f, 0x53, 0x2f, 0x25, 0xb9, 0x7a, 0xf1, 0xbd,
	0xfb, 0x77, 0xe0, 0x5f, 0xfe, 0xaa, 0xbe, 0x32, 0xc0, 0xb2, 0xa3, 0x84, 0x4f, 0xff, 0x0e, 0x00,
	0x00, 0xff, 0xff, 0x2a, 0x2a, 0x2b, 0xda, 0xe2, 0x06, 0x00, 0x00,
}
