// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/asset/v1/assets.proto

package asset

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "github.com/golang/protobuf/ptypes/any"
	_struct "github.com/golang/protobuf/ptypes/struct"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v11 "google.golang.org/genproto/googleapis/cloud/orgpolicy/v1"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	v12 "google.golang.org/genproto/googleapis/identity/accesscontextmanager/v1"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An asset in Google Cloud and its temporal metadata, including the time window
// when it was observed and its status during that window.
type TemporalAsset struct {
	// The time window when the asset data and state was observed.
	Window *TimeWindow `protobuf:"bytes,1,opt,name=window,proto3" json:"window,omitempty"`
	// Whether the asset has been deleted or not.
	Deleted bool `protobuf:"varint,2,opt,name=deleted,proto3" json:"deleted,omitempty"`
	// An asset in Google Cloud.
	Asset                *Asset   `protobuf:"bytes,3,opt,name=asset,proto3" json:"asset,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TemporalAsset) Reset()         { *m = TemporalAsset{} }
func (m *TemporalAsset) String() string { return proto.CompactTextString(m) }
func (*TemporalAsset) ProtoMessage()    {}
func (*TemporalAsset) Descriptor() ([]byte, []int) {
	return fileDescriptor_e71186cd3ee2fb90, []int{0}
}

func (m *TemporalAsset) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TemporalAsset.Unmarshal(m, b)
}
func (m *TemporalAsset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TemporalAsset.Marshal(b, m, deterministic)
}
func (m *TemporalAsset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TemporalAsset.Merge(m, src)
}
func (m *TemporalAsset) XXX_Size() int {
	return xxx_messageInfo_TemporalAsset.Size(m)
}
func (m *TemporalAsset) XXX_DiscardUnknown() {
	xxx_messageInfo_TemporalAsset.DiscardUnknown(m)
}

var xxx_messageInfo_TemporalAsset proto.InternalMessageInfo

func (m *TemporalAsset) GetWindow() *TimeWindow {
	if m != nil {
		return m.Window
	}
	return nil
}

func (m *TemporalAsset) GetDeleted() bool {
	if m != nil {
		return m.Deleted
	}
	return false
}

func (m *TemporalAsset) GetAsset() *Asset {
	if m != nil {
		return m.Asset
	}
	return nil
}

// A time window specified by its "start_time" and "end_time".
type TimeWindow struct {
	// Start time of the time window (exclusive).
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End time of the time window (inclusive). If not specified, the current
	// timestamp is used instead.
	EndTime              *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *TimeWindow) Reset()         { *m = TimeWindow{} }
func (m *TimeWindow) String() string { return proto.CompactTextString(m) }
func (*TimeWindow) ProtoMessage()    {}
func (*TimeWindow) Descriptor() ([]byte, []int) {
	return fileDescriptor_e71186cd3ee2fb90, []int{1}
}

func (m *TimeWindow) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TimeWindow.Unmarshal(m, b)
}
func (m *TimeWindow) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TimeWindow.Marshal(b, m, deterministic)
}
func (m *TimeWindow) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TimeWindow.Merge(m, src)
}
func (m *TimeWindow) XXX_Size() int {
	return xxx_messageInfo_TimeWindow.Size(m)
}
func (m *TimeWindow) XXX_DiscardUnknown() {
	xxx_messageInfo_TimeWindow.DiscardUnknown(m)
}

var xxx_messageInfo_TimeWindow proto.InternalMessageInfo

func (m *TimeWindow) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *TimeWindow) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// An asset in Google Cloud. An asset can be any resource in the Google Cloud
// [resource
// hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
// a resource outside the Google Cloud resource hierarchy (such as Google
// Kubernetes Engine clusters and objects), or a Cloud IAM policy.
type Asset struct {
	// The full name of the asset. For example:
	// "//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1"
	//
	// See [Resource
	// names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// for more information.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The type of the asset. For example: "compute.googleapis.com/Disk"
	//
	// See [Supported asset
	// types](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
	// for more information.
	AssetType string `protobuf:"bytes,2,opt,name=asset_type,json=assetType,proto3" json:"asset_type,omitempty"`
	// A representation of the resource.
	Resource *Resource `protobuf:"bytes,3,opt,name=resource,proto3" json:"resource,omitempty"`
	// A representation of the Cloud IAM policy set on a Google Cloud resource.
	// There can be a maximum of one Cloud IAM policy set on any given resource.
	// In addition, Cloud IAM policies inherit their granted access scope from any
	// policies set on parent resources in the resource hierarchy. Therefore, the
	// effectively policy is the union of both the policy set on this resource
	// and each policy set on all of the resource's ancestry resource levels in
	// the hierarchy. See
	// [this topic](https://cloud.google.com/iam/docs/policies#inheritance) for
	// more information.
	IamPolicy *v1.Policy `protobuf:"bytes,4,opt,name=iam_policy,json=iamPolicy,proto3" json:"iam_policy,omitempty"`
	// A representation of an [organization
	// policy](https://cloud.google.com/resource-manager/docs/organization-policy/overview#organization_policy).
	// There can be more than one organization policy with different constraints
	// set on a given resource.
	OrgPolicy []*v11.Policy `protobuf:"bytes,6,rep,name=org_policy,json=orgPolicy,proto3" json:"org_policy,omitempty"`
	// A representation of an [access
	// policy](https://cloud.google.com/access-context-manager/docs/overview#access-policies).
	//
	// Types that are valid to be assigned to AccessContextPolicy:
	//	*Asset_AccessPolicy
	//	*Asset_AccessLevel
	//	*Asset_ServicePerimeter
	AccessContextPolicy isAsset_AccessContextPolicy `protobuf_oneof:"access_context_policy"`
	// The ancestry path of an asset in Google Cloud [resource
	// hierarchy](https://cloud.google.com/resource-manager/docs/cloud-platform-resource-hierarchy),
	// represented as a list of relative resource names. An ancestry path starts
	// with the closest ancestor in the hierarchy and ends at root. If the asset
	// is a project, folder, or organization, the ancestry path starts from the
	// asset itself.
	//
	// For example: `["projects/123456789", "folders/5432", "organizations/1234"]`
	Ancestors            []string `protobuf:"bytes,10,rep,name=ancestors,proto3" json:"ancestors,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Asset) Reset()         { *m = Asset{} }
func (m *Asset) String() string { return proto.CompactTextString(m) }
func (*Asset) ProtoMessage()    {}
func (*Asset) Descriptor() ([]byte, []int) {
	return fileDescriptor_e71186cd3ee2fb90, []int{2}
}

func (m *Asset) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Asset.Unmarshal(m, b)
}
func (m *Asset) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Asset.Marshal(b, m, deterministic)
}
func (m *Asset) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Asset.Merge(m, src)
}
func (m *Asset) XXX_Size() int {
	return xxx_messageInfo_Asset.Size(m)
}
func (m *Asset) XXX_DiscardUnknown() {
	xxx_messageInfo_Asset.DiscardUnknown(m)
}

var xxx_messageInfo_Asset proto.InternalMessageInfo

func (m *Asset) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Asset) GetAssetType() string {
	if m != nil {
		return m.AssetType
	}
	return ""
}

func (m *Asset) GetResource() *Resource {
	if m != nil {
		return m.Resource
	}
	return nil
}

func (m *Asset) GetIamPolicy() *v1.Policy {
	if m != nil {
		return m.IamPolicy
	}
	return nil
}

func (m *Asset) GetOrgPolicy() []*v11.Policy {
	if m != nil {
		return m.OrgPolicy
	}
	return nil
}

type isAsset_AccessContextPolicy interface {
	isAsset_AccessContextPolicy()
}

type Asset_AccessPolicy struct {
	AccessPolicy *v12.AccessPolicy `protobuf:"bytes,7,opt,name=access_policy,json=accessPolicy,proto3,oneof"`
}

type Asset_AccessLevel struct {
	AccessLevel *v12.AccessLevel `protobuf:"bytes,8,opt,name=access_level,json=accessLevel,proto3,oneof"`
}

type Asset_ServicePerimeter struct {
	ServicePerimeter *v12.ServicePerimeter `protobuf:"bytes,9,opt,name=service_perimeter,json=servicePerimeter,proto3,oneof"`
}

func (*Asset_AccessPolicy) isAsset_AccessContextPolicy() {}

func (*Asset_AccessLevel) isAsset_AccessContextPolicy() {}

func (*Asset_ServicePerimeter) isAsset_AccessContextPolicy() {}

func (m *Asset) GetAccessContextPolicy() isAsset_AccessContextPolicy {
	if m != nil {
		return m.AccessContextPolicy
	}
	return nil
}

func (m *Asset) GetAccessPolicy() *v12.AccessPolicy {
	if x, ok := m.GetAccessContextPolicy().(*Asset_AccessPolicy); ok {
		return x.AccessPolicy
	}
	return nil
}

func (m *Asset) GetAccessLevel() *v12.AccessLevel {
	if x, ok := m.GetAccessContextPolicy().(*Asset_AccessLevel); ok {
		return x.AccessLevel
	}
	return nil
}

func (m *Asset) GetServicePerimeter() *v12.ServicePerimeter {
	if x, ok := m.GetAccessContextPolicy().(*Asset_ServicePerimeter); ok {
		return x.ServicePerimeter
	}
	return nil
}

func (m *Asset) GetAncestors() []string {
	if m != nil {
		return m.Ancestors
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*Asset) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*Asset_AccessPolicy)(nil),
		(*Asset_AccessLevel)(nil),
		(*Asset_ServicePerimeter)(nil),
	}
}

// A representation of a Google Cloud resource.
type Resource struct {
	// The API version. For example: "v1"
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// The URL of the discovery document containing the resource's JSON schema.
	// For example:
	// "https://www.googleapis.com/discovery/v1/apis/compute/v1/rest"
	//
	// This value is unspecified for resources that do not have an API based on a
	// discovery document, such as Cloud Bigtable.
	DiscoveryDocumentUri string `protobuf:"bytes,2,opt,name=discovery_document_uri,json=discoveryDocumentUri,proto3" json:"discovery_document_uri,omitempty"`
	// The JSON schema name listed in the discovery document. For example:
	// "Project"
	//
	// This value is unspecified for resources that do not have an API based on a
	// discovery document, such as Cloud Bigtable.
	DiscoveryName string `protobuf:"bytes,3,opt,name=discovery_name,json=discoveryName,proto3" json:"discovery_name,omitempty"`
	// The REST URL for accessing the resource. An HTTP `GET` request using this
	// URL returns the resource itself. For example:
	// "https://cloudresourcemanager.googleapis.com/v1/projects/my-project-123"
	//
	// This value is unspecified for resources without a REST API.
	ResourceUrl string `protobuf:"bytes,4,opt,name=resource_url,json=resourceUrl,proto3" json:"resource_url,omitempty"`
	// The full name of the immediate parent of this resource. See
	// [Resource
	// Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
	// for more information.
	//
	// For Google Cloud assets, this value is the parent resource defined in the
	// [Cloud IAM policy
	// hierarchy](https://cloud.google.com/iam/docs/overview#policy_hierarchy).
	// For example:
	// "//cloudresourcemanager.googleapis.com/projects/my_project_123"
	//
	// For third-party assets, this field may be set differently.
	Parent string `protobuf:"bytes,5,opt,name=parent,proto3" json:"parent,omitempty"`
	// The content of the resource, in which some sensitive fields are removed
	// and may not be present.
	Data                 *_struct.Struct `protobuf:"bytes,6,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Resource) Reset()         { *m = Resource{} }
func (m *Resource) String() string { return proto.CompactTextString(m) }
func (*Resource) ProtoMessage()    {}
func (*Resource) Descriptor() ([]byte, []int) {
	return fileDescriptor_e71186cd3ee2fb90, []int{3}
}

func (m *Resource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Resource.Unmarshal(m, b)
}
func (m *Resource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Resource.Marshal(b, m, deterministic)
}
func (m *Resource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resource.Merge(m, src)
}
func (m *Resource) XXX_Size() int {
	return xxx_messageInfo_Resource.Size(m)
}
func (m *Resource) XXX_DiscardUnknown() {
	xxx_messageInfo_Resource.DiscardUnknown(m)
}

var xxx_messageInfo_Resource proto.InternalMessageInfo

func (m *Resource) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *Resource) GetDiscoveryDocumentUri() string {
	if m != nil {
		return m.DiscoveryDocumentUri
	}
	return ""
}

func (m *Resource) GetDiscoveryName() string {
	if m != nil {
		return m.DiscoveryName
	}
	return ""
}

func (m *Resource) GetResourceUrl() string {
	if m != nil {
		return m.ResourceUrl
	}
	return ""
}

func (m *Resource) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *Resource) GetData() *_struct.Struct {
	if m != nil {
		return m.Data
	}
	return nil
}

func init() {
	proto.RegisterType((*TemporalAsset)(nil), "google.cloud.asset.v1.TemporalAsset")
	proto.RegisterType((*TimeWindow)(nil), "google.cloud.asset.v1.TimeWindow")
	proto.RegisterType((*Asset)(nil), "google.cloud.asset.v1.Asset")
	proto.RegisterType((*Resource)(nil), "google.cloud.asset.v1.Resource")
}

func init() {
	proto.RegisterFile("google/cloud/asset/v1/assets.proto", fileDescriptor_e71186cd3ee2fb90)
}

var fileDescriptor_e71186cd3ee2fb90 = []byte{
	// 769 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x55, 0xcd, 0x6e, 0xeb, 0x44,
	0x14, 0xae, 0x9b, 0x34, 0x8d, 0x4f, 0x5b, 0x04, 0x23, 0x72, 0xaf, 0x6f, 0x54, 0xd4, 0xdc, 0x08,
	0xc4, 0x05, 0x24, 0x5b, 0x29, 0xed, 0xa2, 0xed, 0x02, 0x5a, 0x90, 0xe8, 0x02, 0xa1, 0xc8, 0xfd,
	0x41, 0xa0, 0x48, 0xd1, 0xd4, 0x1e, 0xcc, 0x48, 0xf6, 0x8c, 0x35, 0x33, 0x49, 0xc9, 0x86, 0xe7,
	0xe8, 0x33, 0xf0, 0x28, 0xbc, 0x09, 0x2c, 0x59, 0xb1, 0x44, 0x3e, 0x9e, 0x49, 0x9a, 0xb4, 0x15,
	0xed, 0x6e, 0xce, 0xcf, 0xf7, 0x9d, 0x99, 0x73, 0xbe, 0x63, 0x43, 0x3f, 0x93, 0x32, 0xcb, 0x59,
	0x94, 0xe4, 0x72, 0x92, 0x46, 0x54, 0x6b, 0x66, 0xa2, 0xe9, 0xa0, 0x3e, 0xe8, 0xb0, 0x54, 0xd2,
	0x48, 0xd2, 0xa9, 0x73, 0x42, 0xcc, 0x09, 0x31, 0x14, 0x4e, 0x07, 0xdd, 0x37, 0x16, 0x4a, 0x4b,
	0x1e, 0x29, 0xa6, 0xe5, 0x44, 0x25, 0xac, 0x46, 0x74, 0x3f, 0x5b, 0x62, 0x95, 0x2a, 0x2b, 0x65,
	0xce, 0x93, 0x59, 0xc5, 0x3c, 0x37, 0x6c, 0x6a, 0xd7, 0xa6, 0x72, 0x5a, 0x54, 0xe1, 0xa5, 0xd8,
	0xb1, 0x8b, 0xa5, 0x4c, 0x18, 0x6e, 0x66, 0x11, 0x4d, 0x12, 0xa6, 0x75, 0x22, 0x85, 0x61, 0xbf,
	0x99, 0x82, 0x0a, 0x9a, 0x31, 0x85, 0xd7, 0x45, 0xff, 0x38, 0x67, 0x53, 0x96, 0x5b, 0xec, 0xc9,
	0x0b, 0xb1, 0x4b, 0x85, 0xbf, 0x7a, 0x2e, 0x58, 0x33, 0x35, 0xe5, 0x09, 0x1b, 0x97, 0x4c, 0xf1,
	0x82, 0x19, 0xa6, 0x2c, 0x81, 0xeb, 0x0d, 0x5a, 0x37, 0x93, 0x5f, 0x22, 0x2a, 0x1c, 0xf7, 0xee,
	0x6a, 0x48, 0x1b, 0x35, 0x49, 0x8c, 0x8d, 0xee, 0xad, 0x46, 0x0d, 0x2f, 0x98, 0x36, 0xb4, 0x28,
	0x57, 0xe0, 0x55, 0xd7, 0xa9, 0x10, 0xd2, 0x50, 0xc3, 0xa5, 0xb0, 0xa3, 0xea, 0xdf, 0x79, 0xb0,
	0x73, 0xc9, 0x8a, 0x52, 0x2a, 0x9a, 0x9f, 0x56, 0x83, 0x22, 0x47, 0xd0, 0xba, 0xe5, 0x22, 0x95,
	0xb7, 0x81, 0xd7, 0xf3, 0xde, 0x6d, 0xed, 0xbf, 0x0d, 0x1f, 0x9d, 0x66, 0x78, 0xc9, 0x0b, 0xf6,
	0x23, 0x26, 0xc6, 0x16, 0x40, 0x02, 0xd8, 0x4c, 0x59, 0xce, 0x0c, 0x4b, 0x83, 0xf5, 0x9e, 0xf7,
	0xae, 0x1d, 0x3b, 0x93, 0xec, 0xc3, 0x06, 0x02, 0x83, 0x06, 0x72, 0xee, 0x3e, 0xc1, 0x89, 0x37,
	0x88, 0xeb, 0xd4, 0xfe, 0xef, 0x00, 0x8b, 0x1a, 0xe4, 0x08, 0x40, 0x1b, 0xaa, 0xcc, 0xb8, 0x7a,
	0x9f, 0xbd, 0x5a, 0xd7, 0xd1, 0xb8, 0xc7, 0xe3, 0xa5, 0xf0, 0xf1, 0xb1, 0x8f, 0xd9, 0x95, 0x4d,
	0x0e, 0xa1, 0xcd, 0x44, 0x5a, 0x03, 0xd7, 0xff, 0x17, 0xb8, 0xc9, 0x44, 0x5a, 0x59, 0xfd, 0x7f,
	0x9a, 0xb0, 0x51, 0xb7, 0x84, 0x40, 0x53, 0x50, 0x5b, 0xd5, 0x8f, 0xf1, 0x4c, 0x3e, 0x02, 0xc0,
	0x6b, 0x8e, 0xcd, 0xac, 0xac, 0x69, 0xfd, 0xd8, 0x47, 0xcf, 0xe5, 0xac, 0x64, 0xe4, 0x04, 0xda,
	0x4e, 0xe2, 0xf6, 0xcd, 0x7b, 0x4f, 0xbc, 0x39, 0xb6, 0x69, 0xf1, 0x1c, 0x40, 0x0e, 0x00, 0x38,
	0x2d, 0xac, 0xc2, 0x82, 0x26, 0xc2, 0x3b, 0x0e, 0xce, 0x69, 0x51, 0xc1, 0x86, 0x18, 0x8c, 0x7d,
	0x4e, 0x8b, 0xfa, 0x48, 0xbe, 0x06, 0x90, 0x2a, 0x73, 0xa8, 0x56, 0xaf, 0xf1, 0x70, 0x78, 0x8b,
	0x5d, 0xba, 0xc7, 0x20, 0x55, 0x66, 0x19, 0x46, 0xb0, 0xb3, 0x24, 0xee, 0x60, 0x13, 0x4b, 0x1f,
	0xce, 0x4b, 0x5b, 0x75, 0x87, 0x8f, 0xa9, 0x1b, 0xe7, 0x87, 0xfe, 0x9a, 0xed, 0x7c, 0x2d, 0xde,
	0xa6, 0xf7, 0x6c, 0xf2, 0x13, 0x6c, 0xdf, 0x5f, 0xbb, 0xa0, 0x8d, 0xe4, 0x07, 0x2f, 0x24, 0xff,
	0xbe, 0xc2, 0x9e, 0xaf, 0xc5, 0x5b, 0x74, 0x61, 0x92, 0x5f, 0xe1, 0x83, 0x07, 0x8b, 0x15, 0xf8,
	0xc8, 0x7f, 0xf4, 0x6c, 0xfe, 0x8b, 0x9a, 0x61, 0xe8, 0x08, 0xce, 0xd7, 0xe2, 0xf7, 0xf5, 0x8a,
	0x8f, 0xec, 0x82, 0x4f, 0x45, 0xc2, 0xb4, 0x91, 0x4a, 0x07, 0xd0, 0x6b, 0xe0, 0xd4, 0x9d, 0xe3,
	0xf8, 0xd3, 0xbf, 0x4f, 0x3f, 0x86, 0x3d, 0xec, 0x75, 0x3d, 0xdf, 0xba, 0x36, 0x2d, 0xb9, 0x0e,
	0x13, 0x59, 0x44, 0xb5, 0x9c, 0xbc, 0xcf, 0xcf, 0x5e, 0x43, 0xc7, 0xf6, 0xc2, 0xde, 0xc3, 0x76,
	0xbc, 0xff, 0x97, 0x07, 0x6d, 0xa7, 0x88, 0x6a, 0x9f, 0xa6, 0x4c, 0x69, 0x2e, 0x85, 0x95, 0x9e,
	0x33, 0xc9, 0x01, 0xbc, 0x4a, 0xb9, 0x4e, 0xe4, 0x94, 0xa9, 0xd9, 0x38, 0x95, 0xc9, 0xa4, 0x60,
	0xc2, 0x8c, 0x27, 0x8a, 0x5b, 0x25, 0x7e, 0x38, 0x8f, 0x7e, 0x6b, 0x83, 0x57, 0x8a, 0x93, 0x4f,
	0xe0, 0xbd, 0x05, 0x0a, 0x15, 0xdd, 0xc0, 0xec, 0x9d, 0xb9, 0xf7, 0x87, 0x4a, 0xda, 0x6f, 0x61,
	0xdb, 0x49, 0x71, 0x3c, 0x51, 0x39, 0x0a, 0xd0, 0x8f, 0xb7, 0x9c, 0xef, 0x4a, 0xe5, 0xe4, 0x15,
	0xb4, 0x4a, 0xaa, 0x98, 0x30, 0xc1, 0x06, 0x06, 0xad, 0x45, 0xbe, 0x80, 0x66, 0x4a, 0x0d, 0x0d,
	0x5a, 0xd8, 0xfb, 0xd7, 0x0f, 0xd6, 0xec, 0x02, 0x3f, 0x5d, 0x31, 0x26, 0x9d, 0xdd, 0x79, 0xf0,
	0x26, 0x91, 0xc5, 0xe3, 0x7b, 0x71, 0x06, 0xd8, 0xac, 0x61, 0x85, 0x1c, 0x7a, 0x3f, 0xdb, 0x2f,
	0x7b, 0x98, 0xc9, 0x9c, 0x8a, 0xac, 0x12, 0x72, 0x94, 0x31, 0x81, 0xbc, 0xd1, 0xa2, 0xc9, 0x2b,
	0x7f, 0xa5, 0x13, 0x3c, 0xfc, 0xeb, 0x79, 0x7f, 0xac, 0x77, 0xbe, 0xab, 0xf1, 0xdf, 0x60, 0x11,
	0xa4, 0x0e, 0xaf, 0x07, 0x7f, 0x3a, 0xff, 0x08, 0xfd, 0x23, 0xf4, 0x8f, 0xae, 0x07, 0x37, 0x2d,
	0x64, 0xfe, 0xf2, 0xbf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x79, 0x0d, 0x7a, 0x66, 0xee, 0x06, 0x00,
	0x00,
}
