// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v3/resources/extension_feed_item.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v3/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v3/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An extension feed item.
type ExtensionFeedItem struct {
	// Immutable. The resource name of the extension feed item.
	// Extension feed item resource names have the form:
	//
	// `customers/{customer_id}/extensionFeedItems/{feed_item_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Output only. The ID of this feed item. Read-only.
	Id *wrappers.Int64Value `protobuf:"bytes,24,opt,name=id,proto3" json:"id,omitempty"`
	// Output only. The extension type of the extension feed item.
	// This field is read-only.
	ExtensionType enums.ExtensionTypeEnum_ExtensionType `protobuf:"varint,13,opt,name=extension_type,json=extensionType,proto3,enum=google.ads.googleads.v3.enums.ExtensionTypeEnum_ExtensionType" json:"extension_type,omitempty"`
	// Start time in which this feed item is effective and can begin serving. The
	// time is in the customer's time zone.
	// The format is "YYYY-MM-DD HH:MM:SS".
	// Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
	StartDateTime *wrappers.StringValue `protobuf:"bytes,5,opt,name=start_date_time,json=startDateTime,proto3" json:"start_date_time,omitempty"`
	// End time in which this feed item is no longer effective and will stop
	// serving. The time is in the customer's time zone.
	// The format is "YYYY-MM-DD HH:MM:SS".
	// Examples: "2018-03-05 09:15:00" or "2018-02-01 14:34:30"
	EndDateTime *wrappers.StringValue `protobuf:"bytes,6,opt,name=end_date_time,json=endDateTime,proto3" json:"end_date_time,omitempty"`
	// List of non-overlapping schedules specifying all time intervals
	// for which the feed item may serve. There can be a maximum of 6 schedules
	// per day.
	AdSchedules []*common.AdScheduleInfo `protobuf:"bytes,16,rep,name=ad_schedules,json=adSchedules,proto3" json:"ad_schedules,omitempty"`
	// The targeted device.
	Device enums.FeedItemTargetDeviceEnum_FeedItemTargetDevice `protobuf:"varint,17,opt,name=device,proto3,enum=google.ads.googleads.v3.enums.FeedItemTargetDeviceEnum_FeedItemTargetDevice" json:"device,omitempty"`
	// The targeted geo target constant.
	TargetedGeoTargetConstant *wrappers.StringValue `protobuf:"bytes,20,opt,name=targeted_geo_target_constant,json=targetedGeoTargetConstant,proto3" json:"targeted_geo_target_constant,omitempty"`
	// The targeted keyword.
	TargetedKeyword *common.KeywordInfo `protobuf:"bytes,22,opt,name=targeted_keyword,json=targetedKeyword,proto3" json:"targeted_keyword,omitempty"`
	// Output only. Status of the feed item.
	// This field is read-only.
	Status enums.FeedItemStatusEnum_FeedItemStatus `protobuf:"varint,4,opt,name=status,proto3,enum=google.ads.googleads.v3.enums.FeedItemStatusEnum_FeedItemStatus" json:"status,omitempty"`
	// Extension type.
	//
	// Types that are valid to be assigned to Extension:
	//	*ExtensionFeedItem_SitelinkFeedItem
	//	*ExtensionFeedItem_StructuredSnippetFeedItem
	//	*ExtensionFeedItem_AppFeedItem
	//	*ExtensionFeedItem_CallFeedItem
	//	*ExtensionFeedItem_CalloutFeedItem
	//	*ExtensionFeedItem_TextMessageFeedItem
	//	*ExtensionFeedItem_PriceFeedItem
	//	*ExtensionFeedItem_PromotionFeedItem
	//	*ExtensionFeedItem_LocationFeedItem
	//	*ExtensionFeedItem_AffiliateLocationFeedItem
	//	*ExtensionFeedItem_HotelCalloutFeedItem
	Extension isExtensionFeedItem_Extension `protobuf_oneof:"extension"`
	// Targeting at either the campaign or ad group level. Feed items that target
	// a campaign or ad group will only serve with that resource.
	//
	// Types that are valid to be assigned to ServingResourceTargeting:
	//	*ExtensionFeedItem_TargetedCampaign
	//	*ExtensionFeedItem_TargetedAdGroup
	ServingResourceTargeting isExtensionFeedItem_ServingResourceTargeting `protobuf_oneof:"serving_resource_targeting"`
	XXX_NoUnkeyedLiteral     struct{}                                     `json:"-"`
	XXX_unrecognized         []byte                                       `json:"-"`
	XXX_sizecache            int32                                        `json:"-"`
}

func (m *ExtensionFeedItem) Reset()         { *m = ExtensionFeedItem{} }
func (m *ExtensionFeedItem) String() string { return proto.CompactTextString(m) }
func (*ExtensionFeedItem) ProtoMessage()    {}
func (*ExtensionFeedItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_d54452736e95564f, []int{0}
}

func (m *ExtensionFeedItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExtensionFeedItem.Unmarshal(m, b)
}
func (m *ExtensionFeedItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExtensionFeedItem.Marshal(b, m, deterministic)
}
func (m *ExtensionFeedItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExtensionFeedItem.Merge(m, src)
}
func (m *ExtensionFeedItem) XXX_Size() int {
	return xxx_messageInfo_ExtensionFeedItem.Size(m)
}
func (m *ExtensionFeedItem) XXX_DiscardUnknown() {
	xxx_messageInfo_ExtensionFeedItem.DiscardUnknown(m)
}

var xxx_messageInfo_ExtensionFeedItem proto.InternalMessageInfo

func (m *ExtensionFeedItem) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *ExtensionFeedItem) GetId() *wrappers.Int64Value {
	if m != nil {
		return m.Id
	}
	return nil
}

func (m *ExtensionFeedItem) GetExtensionType() enums.ExtensionTypeEnum_ExtensionType {
	if m != nil {
		return m.ExtensionType
	}
	return enums.ExtensionTypeEnum_UNSPECIFIED
}

func (m *ExtensionFeedItem) GetStartDateTime() *wrappers.StringValue {
	if m != nil {
		return m.StartDateTime
	}
	return nil
}

func (m *ExtensionFeedItem) GetEndDateTime() *wrappers.StringValue {
	if m != nil {
		return m.EndDateTime
	}
	return nil
}

func (m *ExtensionFeedItem) GetAdSchedules() []*common.AdScheduleInfo {
	if m != nil {
		return m.AdSchedules
	}
	return nil
}

func (m *ExtensionFeedItem) GetDevice() enums.FeedItemTargetDeviceEnum_FeedItemTargetDevice {
	if m != nil {
		return m.Device
	}
	return enums.FeedItemTargetDeviceEnum_UNSPECIFIED
}

func (m *ExtensionFeedItem) GetTargetedGeoTargetConstant() *wrappers.StringValue {
	if m != nil {
		return m.TargetedGeoTargetConstant
	}
	return nil
}

func (m *ExtensionFeedItem) GetTargetedKeyword() *common.KeywordInfo {
	if m != nil {
		return m.TargetedKeyword
	}
	return nil
}

func (m *ExtensionFeedItem) GetStatus() enums.FeedItemStatusEnum_FeedItemStatus {
	if m != nil {
		return m.Status
	}
	return enums.FeedItemStatusEnum_UNSPECIFIED
}

type isExtensionFeedItem_Extension interface {
	isExtensionFeedItem_Extension()
}

type ExtensionFeedItem_SitelinkFeedItem struct {
	SitelinkFeedItem *common.SitelinkFeedItem `protobuf:"bytes,2,opt,name=sitelink_feed_item,json=sitelinkFeedItem,proto3,oneof"`
}

type ExtensionFeedItem_StructuredSnippetFeedItem struct {
	StructuredSnippetFeedItem *common.StructuredSnippetFeedItem `protobuf:"bytes,3,opt,name=structured_snippet_feed_item,json=structuredSnippetFeedItem,proto3,oneof"`
}

type ExtensionFeedItem_AppFeedItem struct {
	AppFeedItem *common.AppFeedItem `protobuf:"bytes,7,opt,name=app_feed_item,json=appFeedItem,proto3,oneof"`
}

type ExtensionFeedItem_CallFeedItem struct {
	CallFeedItem *common.CallFeedItem `protobuf:"bytes,8,opt,name=call_feed_item,json=callFeedItem,proto3,oneof"`
}

type ExtensionFeedItem_CalloutFeedItem struct {
	CalloutFeedItem *common.CalloutFeedItem `protobuf:"bytes,9,opt,name=callout_feed_item,json=calloutFeedItem,proto3,oneof"`
}

type ExtensionFeedItem_TextMessageFeedItem struct {
	TextMessageFeedItem *common.TextMessageFeedItem `protobuf:"bytes,10,opt,name=text_message_feed_item,json=textMessageFeedItem,proto3,oneof"`
}

type ExtensionFeedItem_PriceFeedItem struct {
	PriceFeedItem *common.PriceFeedItem `protobuf:"bytes,11,opt,name=price_feed_item,json=priceFeedItem,proto3,oneof"`
}

type ExtensionFeedItem_PromotionFeedItem struct {
	PromotionFeedItem *common.PromotionFeedItem `protobuf:"bytes,12,opt,name=promotion_feed_item,json=promotionFeedItem,proto3,oneof"`
}

type ExtensionFeedItem_LocationFeedItem struct {
	LocationFeedItem *common.LocationFeedItem `protobuf:"bytes,14,opt,name=location_feed_item,json=locationFeedItem,proto3,oneof"`
}

type ExtensionFeedItem_AffiliateLocationFeedItem struct {
	AffiliateLocationFeedItem *common.AffiliateLocationFeedItem `protobuf:"bytes,15,opt,name=affiliate_location_feed_item,json=affiliateLocationFeedItem,proto3,oneof"`
}

type ExtensionFeedItem_HotelCalloutFeedItem struct {
	HotelCalloutFeedItem *common.HotelCalloutFeedItem `protobuf:"bytes,23,opt,name=hotel_callout_feed_item,json=hotelCalloutFeedItem,proto3,oneof"`
}

func (*ExtensionFeedItem_SitelinkFeedItem) isExtensionFeedItem_Extension() {}

func (*ExtensionFeedItem_StructuredSnippetFeedItem) isExtensionFeedItem_Extension() {}

func (*ExtensionFeedItem_AppFeedItem) isExtensionFeedItem_Extension() {}

func (*ExtensionFeedItem_CallFeedItem) isExtensionFeedItem_Extension() {}

func (*ExtensionFeedItem_CalloutFeedItem) isExtensionFeedItem_Extension() {}

func (*ExtensionFeedItem_TextMessageFeedItem) isExtensionFeedItem_Extension() {}

func (*ExtensionFeedItem_PriceFeedItem) isExtensionFeedItem_Extension() {}

func (*ExtensionFeedItem_PromotionFeedItem) isExtensionFeedItem_Extension() {}

func (*ExtensionFeedItem_LocationFeedItem) isExtensionFeedItem_Extension() {}

func (*ExtensionFeedItem_AffiliateLocationFeedItem) isExtensionFeedItem_Extension() {}

func (*ExtensionFeedItem_HotelCalloutFeedItem) isExtensionFeedItem_Extension() {}

func (m *ExtensionFeedItem) GetExtension() isExtensionFeedItem_Extension {
	if m != nil {
		return m.Extension
	}
	return nil
}

func (m *ExtensionFeedItem) GetSitelinkFeedItem() *common.SitelinkFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_SitelinkFeedItem); ok {
		return x.SitelinkFeedItem
	}
	return nil
}

func (m *ExtensionFeedItem) GetStructuredSnippetFeedItem() *common.StructuredSnippetFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_StructuredSnippetFeedItem); ok {
		return x.StructuredSnippetFeedItem
	}
	return nil
}

func (m *ExtensionFeedItem) GetAppFeedItem() *common.AppFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_AppFeedItem); ok {
		return x.AppFeedItem
	}
	return nil
}

func (m *ExtensionFeedItem) GetCallFeedItem() *common.CallFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_CallFeedItem); ok {
		return x.CallFeedItem
	}
	return nil
}

func (m *ExtensionFeedItem) GetCalloutFeedItem() *common.CalloutFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_CalloutFeedItem); ok {
		return x.CalloutFeedItem
	}
	return nil
}

func (m *ExtensionFeedItem) GetTextMessageFeedItem() *common.TextMessageFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_TextMessageFeedItem); ok {
		return x.TextMessageFeedItem
	}
	return nil
}

func (m *ExtensionFeedItem) GetPriceFeedItem() *common.PriceFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_PriceFeedItem); ok {
		return x.PriceFeedItem
	}
	return nil
}

func (m *ExtensionFeedItem) GetPromotionFeedItem() *common.PromotionFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_PromotionFeedItem); ok {
		return x.PromotionFeedItem
	}
	return nil
}

func (m *ExtensionFeedItem) GetLocationFeedItem() *common.LocationFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_LocationFeedItem); ok {
		return x.LocationFeedItem
	}
	return nil
}

func (m *ExtensionFeedItem) GetAffiliateLocationFeedItem() *common.AffiliateLocationFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_AffiliateLocationFeedItem); ok {
		return x.AffiliateLocationFeedItem
	}
	return nil
}

func (m *ExtensionFeedItem) GetHotelCalloutFeedItem() *common.HotelCalloutFeedItem {
	if x, ok := m.GetExtension().(*ExtensionFeedItem_HotelCalloutFeedItem); ok {
		return x.HotelCalloutFeedItem
	}
	return nil
}

type isExtensionFeedItem_ServingResourceTargeting interface {
	isExtensionFeedItem_ServingResourceTargeting()
}

type ExtensionFeedItem_TargetedCampaign struct {
	TargetedCampaign *wrappers.StringValue `protobuf:"bytes,18,opt,name=targeted_campaign,json=targetedCampaign,proto3,oneof"`
}

type ExtensionFeedItem_TargetedAdGroup struct {
	TargetedAdGroup *wrappers.StringValue `protobuf:"bytes,19,opt,name=targeted_ad_group,json=targetedAdGroup,proto3,oneof"`
}

func (*ExtensionFeedItem_TargetedCampaign) isExtensionFeedItem_ServingResourceTargeting() {}

func (*ExtensionFeedItem_TargetedAdGroup) isExtensionFeedItem_ServingResourceTargeting() {}

func (m *ExtensionFeedItem) GetServingResourceTargeting() isExtensionFeedItem_ServingResourceTargeting {
	if m != nil {
		return m.ServingResourceTargeting
	}
	return nil
}

func (m *ExtensionFeedItem) GetTargetedCampaign() *wrappers.StringValue {
	if x, ok := m.GetServingResourceTargeting().(*ExtensionFeedItem_TargetedCampaign); ok {
		return x.TargetedCampaign
	}
	return nil
}

func (m *ExtensionFeedItem) GetTargetedAdGroup() *wrappers.StringValue {
	if x, ok := m.GetServingResourceTargeting().(*ExtensionFeedItem_TargetedAdGroup); ok {
		return x.TargetedAdGroup
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*ExtensionFeedItem) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*ExtensionFeedItem_SitelinkFeedItem)(nil),
		(*ExtensionFeedItem_StructuredSnippetFeedItem)(nil),
		(*ExtensionFeedItem_AppFeedItem)(nil),
		(*ExtensionFeedItem_CallFeedItem)(nil),
		(*ExtensionFeedItem_CalloutFeedItem)(nil),
		(*ExtensionFeedItem_TextMessageFeedItem)(nil),
		(*ExtensionFeedItem_PriceFeedItem)(nil),
		(*ExtensionFeedItem_PromotionFeedItem)(nil),
		(*ExtensionFeedItem_LocationFeedItem)(nil),
		(*ExtensionFeedItem_AffiliateLocationFeedItem)(nil),
		(*ExtensionFeedItem_HotelCalloutFeedItem)(nil),
		(*ExtensionFeedItem_TargetedCampaign)(nil),
		(*ExtensionFeedItem_TargetedAdGroup)(nil),
	}
}

func init() {
	proto.RegisterType((*ExtensionFeedItem)(nil), "google.ads.googleads.v3.resources.ExtensionFeedItem")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v3/resources/extension_feed_item.proto", fileDescriptor_d54452736e95564f)
}

var fileDescriptor_d54452736e95564f = []byte{
	// 1091 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x56, 0xdd, 0x4e, 0xdc, 0x46,
	0x14, 0xee, 0x2e, 0x0d, 0x2d, 0xb3, 0x2c, 0x3f, 0x43, 0x44, 0x0c, 0x5d, 0xb5, 0x90, 0x8a, 0x0a,
	0xb5, 0x89, 0x9d, 0xb2, 0xa8, 0x52, 0x17, 0xb5, 0x8a, 0x17, 0x52, 0xa0, 0x4d, 0x2b, 0xb2, 0x20,
	0x22, 0x55, 0x44, 0xee, 0xe0, 0x39, 0x6b, 0x26, 0xd8, 0x33, 0xae, 0x67, 0x4c, 0x40, 0x69, 0x2e,
	0xda, 0xde, 0xf7, 0x21, 0x7a, 0xd9, 0x47, 0xe9, 0x53, 0xe4, 0x3a, 0x8f, 0xc0, 0x55, 0xb5, 0xe3,
	0x9f, 0x35, 0x2c, 0x8b, 0xb7, 0x77, 0x33, 0x67, 0xce, 0xf7, 0x7d, 0xc7, 0x9f, 0xcf, 0x8c, 0x0e,
	0xda, 0xf0, 0x84, 0xf0, 0x7c, 0xb0, 0x08, 0x95, 0x56, 0xb2, 0xec, 0xad, 0xce, 0x9a, 0x56, 0x04,
	0x52, 0xc4, 0x91, 0x0b, 0xd2, 0x82, 0x73, 0x05, 0x5c, 0x32, 0xc1, 0x9d, 0x2e, 0x00, 0x75, 0x98,
	0x82, 0xc0, 0x0c, 0x23, 0xa1, 0x04, 0x5e, 0x4e, 0x10, 0x26, 0xa1, 0xd2, 0xcc, 0xc1, 0xe6, 0x59,
	0xd3, 0xcc, 0xc1, 0x8b, 0x0f, 0x87, 0xf1, 0xbb, 0x22, 0x08, 0x04, 0xb7, 0xdc, 0x88, 0x29, 0x88,
	0x18, 0x49, 0x18, 0x17, 0xad, 0x92, 0xf4, 0xbc, 0x16, 0x99, 0x02, 0xd6, 0x86, 0x01, 0x80, 0xc7,
	0x41, 0xb1, 0x76, 0x75, 0x11, 0x42, 0x8a, 0x59, 0xbf, 0x1d, 0x93, 0x7f, 0xa5, 0x23, 0x15, 0x51,
	0x71, 0xa6, 0xb4, 0x31, 0x2a, 0x4a, 0x91, 0xc8, 0x03, 0xe5, 0x50, 0x38, 0x63, 0x6e, 0x26, 0xf9,
	0x49, 0x06, 0x0e, 0x99, 0xd5, 0x65, 0xe0, 0x53, 0xe7, 0x18, 0x4e, 0xc8, 0x19, 0x13, 0x51, 0x9a,
	0xb0, 0x50, 0x48, 0xc8, 0xdc, 0x4b, 0x8f, 0x3e, 0x4e, 0x8f, 0xf4, 0xee, 0x38, 0xee, 0x5a, 0xaf,
	0x22, 0x12, 0x86, 0x10, 0x65, 0x85, 0x35, 0x0a, 0x50, 0xc2, 0xb9, 0x50, 0x44, 0xf5, 0x0d, 0xba,
	0xff, 0xc7, 0x1c, 0x9a, 0x7d, 0x92, 0xb9, 0xf0, 0x1d, 0x00, 0xdd, 0x55, 0x10, 0xe0, 0xe7, 0xa8,
	0x9e, 0xa9, 0x38, 0x9c, 0x04, 0x60, 0x54, 0x96, 0x2a, 0xab, 0x13, 0xed, 0xb5, 0xb7, 0xf6, 0x9d,
	0x4b, 0xfb, 0x01, 0xfa, 0xbc, 0xff, 0x37, 0xd3, 0x55, 0xc8, 0xa4, 0xe9, 0x8a, 0xc0, 0x1a, 0xa0,
	0xea, 0x4c, 0x66, 0x44, 0x3f, 0x91, 0x00, 0xf0, 0x23, 0x54, 0x65, 0xd4, 0x30, 0x96, 0x2a, 0xab,
	0xb5, 0xb5, 0x8f, 0x52, 0xb0, 0x99, 0x55, 0x6e, 0xee, 0x72, 0xf5, 0xd5, 0xfa, 0x21, 0xf1, 0x63,
	0x68, 0x8f, 0xbd, 0xb5, 0xc7, 0x3a, 0x55, 0x46, 0xf1, 0x4b, 0x34, 0x75, 0xf5, 0x2f, 0x19, 0xf5,
	0xa5, 0xca, 0xea, 0xd4, 0xda, 0xb7, 0xe6, 0xb0, 0xee, 0xd2, 0x86, 0x9b, 0x79, 0x25, 0x07, 0x17,
	0x21, 0x3c, 0xe1, 0x71, 0x70, 0x35, 0x92, 0x08, 0xd4, 0xa1, 0x18, 0xc3, 0x5b, 0x68, 0x5a, 0x2a,
	0x12, 0x29, 0x87, 0x12, 0x05, 0x8e, 0x62, 0x01, 0x18, 0x77, 0x74, 0xa9, 0x8d, 0x81, 0x52, 0xf7,
	0x55, 0xc4, 0xb8, 0xa7, 0x6b, 0xed, 0xd4, 0x35, 0x68, 0x8b, 0x28, 0x38, 0x60, 0x01, 0xe0, 0xc7,
	0xa8, 0x0e, 0x9c, 0x16, 0x38, 0xc6, 0x47, 0xe0, 0xa8, 0x01, 0xa7, 0x39, 0xc3, 0x33, 0x34, 0x49,
	0xa8, 0x23, 0xdd, 0x13, 0xa0, 0xb1, 0x0f, 0xd2, 0x98, 0x59, 0x1a, 0x5b, 0xad, 0xad, 0x99, 0x43,
	0xbf, 0x38, 0xe9, 0x7e, 0xd3, 0xa6, 0xfb, 0x29, 0x64, 0x97, 0x77, 0x45, 0xa7, 0x46, 0xf2, 0xbd,
	0xc4, 0x14, 0x8d, 0x27, 0x1d, 0x67, 0xcc, 0x6a, 0xfb, 0x9e, 0x96, 0xd8, 0x97, 0xfd, 0xbf, 0x03,
	0xdd, 0xad, 0x5b, 0x1a, 0xaa, 0x5d, 0xbc, 0xe9, 0xa0, 0x93, 0x72, 0xe3, 0xbf, 0x2a, 0xa8, 0x91,
	0xf4, 0x37, 0x50, 0xc7, 0x03, 0x91, 0x35, 0xbb, 0x2b, 0xb8, 0x54, 0x84, 0x2b, 0xe3, 0x6e, 0xb9,
	0x15, 0x6d, 0xeb, 0xf6, 0x16, 0xdb, 0x06, 0x91, 0x68, 0x6f, 0xa6, 0xa4, 0x9d, 0x85, 0x4c, 0x72,
	0xe0, 0x08, 0x1f, 0xa2, 0x99, 0xbc, 0x9e, 0x53, 0xb8, 0x78, 0x25, 0x22, 0x6a, 0xcc, 0xeb, 0x1a,
	0xbe, 0x28, 0x73, 0xf3, 0x87, 0x24, 0x5d, 0x5b, 0x39, 0x9d, 0x91, 0xa4, 0x41, 0xfc, 0x02, 0x8d,
	0x27, 0xb7, 0xdf, 0x78, 0x5f, 0xdb, 0xf9, 0x78, 0x44, 0x3b, 0xf7, 0x35, 0xe8, 0x8a, 0x91, 0x49,
	0x28, 0xe9, 0xc7, 0x94, 0x14, 0xff, 0x82, 0xb0, 0x64, 0x0a, 0x7c, 0xc6, 0x4f, 0xfb, 0xaf, 0xaa,
	0x51, 0xd5, 0x85, 0x3f, 0x2a, 0x2b, 0x7c, 0x3f, 0x45, 0x66, 0x02, 0x3b, 0xef, 0x75, 0x66, 0xe4,
	0xb5, 0x18, 0xfe, 0x0d, 0x35, 0xa4, 0x8a, 0x62, 0x57, 0xc5, 0x11, 0x50, 0x47, 0x72, 0x16, 0x86,
	0xa0, 0x0a, 0x5a, 0x63, 0x5a, 0xeb, 0xeb, 0x52, 0xad, 0x9c, 0x63, 0x3f, 0xa1, 0x28, 0x88, 0x2e,
	0xc8, 0x61, 0x87, 0xf8, 0x19, 0xaa, 0x93, 0x30, 0x2c, 0xc8, 0x7d, 0x30, 0xda, 0x3f, 0xb1, 0xc3,
	0xb0, 0x20, 0x50, 0x23, 0xfd, 0x2d, 0x3e, 0x40, 0x53, 0x2e, 0xf1, 0xfd, 0x02, 0xe7, 0x87, 0x9a,
	0xf3, 0x41, 0x19, 0xe7, 0x26, 0xf1, 0xfd, 0x02, 0xe9, 0xa4, 0x5b, 0xd8, 0xe3, 0x17, 0x68, 0xb6,
	0xb7, 0x17, 0x71, 0xd1, 0x9b, 0x09, 0x4d, 0x6c, 0x8d, 0x42, 0x2c, 0xe2, 0xa2, 0x23, 0xd3, 0xee,
	0xd5, 0x10, 0x7e, 0x89, 0xe6, 0x15, 0x9c, 0x2b, 0x27, 0x00, 0x29, 0x89, 0x07, 0x05, 0x0d, 0xa4,
	0x35, 0x9a, 0x65, 0x1a, 0x07, 0x70, 0xae, 0x7e, 0x4c, 0xc0, 0x05, 0x9d, 0x39, 0x35, 0x18, 0xc6,
	0xcf, 0xd1, 0x74, 0x18, 0x31, 0xb7, 0x28, 0x52, 0xd3, 0x22, 0x0f, 0xcb, 0x44, 0xf6, 0x7a, 0xb0,
	0x02, 0x7d, 0x3d, 0x2c, 0x06, 0xb0, 0x8b, 0xe6, 0xc2, 0x48, 0x04, 0x42, 0x5d, 0x99, 0x01, 0x8c,
	0x49, 0x4d, 0xfe, 0x65, 0x39, 0x79, 0x0a, 0x2d, 0x08, 0xcc, 0x86, 0xd7, 0x83, 0x18, 0x10, 0xf6,
	0x85, 0x4b, 0xae, 0x69, 0x4c, 0x8d, 0x76, 0x23, 0x9e, 0xa6, 0xc8, 0x8c, 0x4d, 0x5f, 0xb6, 0xde,
	0xb5, 0xf0, 0xaf, 0x1d, 0xe0, 0xdf, 0x2b, 0xa8, 0x41, 0xba, 0x5d, 0xe6, 0xb3, 0xde, 0xeb, 0x7d,
	0x83, 0xe2, 0xf4, 0x68, 0xf7, 0xc2, 0xce, 0x38, 0x86, 0x49, 0x2f, 0x90, 0x61, 0x19, 0x38, 0x40,
	0xf7, 0x4e, 0x84, 0x02, 0xdf, 0x19, 0xec, 0xbc, 0x7b, 0x5a, 0x7d, 0xbd, 0x4c, 0x7d, 0xa7, 0x07,
	0x1f, 0x6c, 0xbf, 0xbb, 0x27, 0x37, 0xc4, 0xb1, 0x44, 0xb3, 0xf9, 0x13, 0xe9, 0x92, 0x20, 0x24,
	0xcc, 0xe3, 0x06, 0x1e, 0xe1, 0x9d, 0xfe, 0xec, 0xd2, 0xfe, 0x14, 0x2d, 0x0f, 0x7d, 0xa7, 0x37,
	0x53, 0xae, 0x9d, 0x4a, 0x27, 0x7f, 0x83, 0xb3, 0x18, 0xfe, 0xb5, 0x20, 0x4a, 0xa8, 0xe3, 0x45,
	0x22, 0x0e, 0x8d, 0xb9, 0x11, 0x44, 0x57, 0x2e, 0xed, 0xfb, 0x68, 0x69, 0xa8, 0xa8, 0x4d, 0xb7,
	0x7b, 0x54, 0x3b, 0x95, 0xfe, 0x93, 0x9d, 0x86, 0x5a, 0xfc, 0x9d, 0x7d, 0xfa, 0x7f, 0x26, 0x17,
	0xfc, 0x8d, 0x1b, 0x4b, 0x25, 0x02, 0x88, 0xa4, 0xf5, 0x3a, 0x5b, 0xbe, 0xe9, 0x8f, 0x8c, 0x59,
	0x9e, 0xb4, 0x5e, 0xdf, 0x30, 0x02, 0xbf, 0x69, 0xd7, 0xd0, 0x44, 0x1e, 0x6f, 0x37, 0xd0, 0xa2,
	0x84, 0xe8, 0x8c, 0x71, 0xcf, 0xc9, 0x07, 0xab, 0xa4, 0x40, 0xc6, 0xbd, 0xf6, 0x9f, 0x55, 0xb4,
	0xe2, 0x8a, 0xc0, 0x2c, 0x9d, 0x97, 0xdb, 0xf3, 0x03, 0x65, 0xee, 0xf5, 0x5c, 0xda, 0xab, 0xfc,
	0xfc, 0x7d, 0x0a, 0xf6, 0x84, 0x4f, 0xb8, 0x67, 0x8a, 0xc8, 0xb3, 0x3c, 0xe0, 0xda, 0x43, 0xab,
	0xff, 0xa9, 0xb7, 0x0c, 0xf2, 0x1b, 0xf9, 0xea, 0xef, 0xea, 0xd8, 0xb6, 0x6d, 0xff, 0x53, 0x5d,
	0xde, 0x4e, 0x28, 0x6d, 0x2a, 0xcd, 0x64, 0xd9, 0x5b, 0x1d, 0x36, 0xcd, 0x4e, 0x96, 0xf9, 0x6f,
	0x96, 0x73, 0x64, 0x53, 0x79, 0x94, 0xe7, 0x1c, 0x1d, 0x36, 0x8f, 0xf2, 0x9c, 0x77, 0xd5, 0x95,
	0xe4, 0xa0, 0xd5, 0xb2, 0xa9, 0x6c, 0xb5, 0xf2, 0xac, 0x56, 0xeb, 0xb0, 0xd9, 0x6a, 0xe5, 0x79,
	0xc7, 0xe3, 0xba, 0xd8, 0xe6, 0x7f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x34, 0x31, 0xb8, 0x2b, 0x74,
	0x0c, 0x00, 0x00,
}
