// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/resources/ad_group_criterion.proto

package resources

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	common "google.golang.org/genproto/googleapis/ads/googleads/v1/common"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An ad group criterion.
type AdGroupCriterion struct {
	// Immutable. The resource name of the ad group criterion.
	// Ad group criterion resource names have the form:
	//
	// `customers/{customer_id}/adGroupCriteria/{ad_group_id}~{criterion_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// Output only. The ID of the criterion.
	//
	// This field is ignored for mutates.
	CriterionId *wrappers.Int64Value `protobuf:"bytes,26,opt,name=criterion_id,json=criterionId,proto3" json:"criterion_id,omitempty"`
	// The status of the criterion.
	Status enums.AdGroupCriterionStatusEnum_AdGroupCriterionStatus `protobuf:"varint,3,opt,name=status,proto3,enum=google.ads.googleads.v1.enums.AdGroupCriterionStatusEnum_AdGroupCriterionStatus" json:"status,omitempty"`
	// Output only. Information regarding the quality of the criterion.
	QualityInfo *AdGroupCriterion_QualityInfo `protobuf:"bytes,4,opt,name=quality_info,json=qualityInfo,proto3" json:"quality_info,omitempty"`
	// Immutable. The ad group to which the criterion belongs.
	AdGroup *wrappers.StringValue `protobuf:"bytes,5,opt,name=ad_group,json=adGroup,proto3" json:"ad_group,omitempty"`
	// Output only. The type of the criterion.
	Type enums.CriterionTypeEnum_CriterionType `protobuf:"varint,25,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.CriterionTypeEnum_CriterionType" json:"type,omitempty"`
	// Immutable. Whether to target (`false`) or exclude (`true`) the criterion.
	//
	// This field is immutable. To switch a criterion from positive to negative,
	// remove then re-add it.
	Negative *wrappers.BoolValue `protobuf:"bytes,31,opt,name=negative,proto3" json:"negative,omitempty"`
	// Output only. Serving status of the criterion.
	SystemServingStatus enums.CriterionSystemServingStatusEnum_CriterionSystemServingStatus `protobuf:"varint,52,opt,name=system_serving_status,json=systemServingStatus,proto3,enum=google.ads.googleads.v1.enums.CriterionSystemServingStatusEnum_CriterionSystemServingStatus" json:"system_serving_status,omitempty"`
	// Output only. Approval status of the criterion.
	ApprovalStatus enums.AdGroupCriterionApprovalStatusEnum_AdGroupCriterionApprovalStatus `protobuf:"varint,53,opt,name=approval_status,json=approvalStatus,proto3,enum=google.ads.googleads.v1.enums.AdGroupCriterionApprovalStatusEnum_AdGroupCriterionApprovalStatus" json:"approval_status,omitempty"`
	// The modifier for the bid when the criterion matches. The modifier must be
	// in the range: 0.1 - 10.0. Most targetable criteria types support modifiers.
	BidModifier *wrappers.DoubleValue `protobuf:"bytes,44,opt,name=bid_modifier,json=bidModifier,proto3" json:"bid_modifier,omitempty"`
	// The CPC (cost-per-click) bid.
	CpcBidMicros *wrappers.Int64Value `protobuf:"bytes,16,opt,name=cpc_bid_micros,json=cpcBidMicros,proto3" json:"cpc_bid_micros,omitempty"`
	// The CPM (cost-per-thousand viewable impressions) bid.
	CpmBidMicros *wrappers.Int64Value `protobuf:"bytes,17,opt,name=cpm_bid_micros,json=cpmBidMicros,proto3" json:"cpm_bid_micros,omitempty"`
	// The CPV (cost-per-view) bid.
	CpvBidMicros *wrappers.Int64Value `protobuf:"bytes,24,opt,name=cpv_bid_micros,json=cpvBidMicros,proto3" json:"cpv_bid_micros,omitempty"`
	// The CPC bid amount, expressed as a fraction of the advertised price
	// for some good or service. The valid range for the fraction is [0,1) and the
	// value stored here is 1,000,000 * [fraction].
	PercentCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,33,opt,name=percent_cpc_bid_micros,json=percentCpcBidMicros,proto3" json:"percent_cpc_bid_micros,omitempty"`
	// Output only. The effective CPC (cost-per-click) bid.
	EffectiveCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,18,opt,name=effective_cpc_bid_micros,json=effectiveCpcBidMicros,proto3" json:"effective_cpc_bid_micros,omitempty"`
	// Output only. The effective CPM (cost-per-thousand viewable impressions) bid.
	EffectiveCpmBidMicros *wrappers.Int64Value `protobuf:"bytes,19,opt,name=effective_cpm_bid_micros,json=effectiveCpmBidMicros,proto3" json:"effective_cpm_bid_micros,omitempty"`
	// Output only. The effective CPV (cost-per-view) bid.
	EffectiveCpvBidMicros *wrappers.Int64Value `protobuf:"bytes,20,opt,name=effective_cpv_bid_micros,json=effectiveCpvBidMicros,proto3" json:"effective_cpv_bid_micros,omitempty"`
	// Output only. The effective Percent CPC bid amount.
	EffectivePercentCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,34,opt,name=effective_percent_cpc_bid_micros,json=effectivePercentCpcBidMicros,proto3" json:"effective_percent_cpc_bid_micros,omitempty"`
	// Output only. Source of the effective CPC bid.
	EffectiveCpcBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,21,opt,name=effective_cpc_bid_source,json=effectiveCpcBidSource,proto3,enum=google.ads.googleads.v1.enums.BiddingSourceEnum_BiddingSource" json:"effective_cpc_bid_source,omitempty"`
	// Output only. Source of the effective CPM bid.
	EffectiveCpmBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,22,opt,name=effective_cpm_bid_source,json=effectiveCpmBidSource,proto3,enum=google.ads.googleads.v1.enums.BiddingSourceEnum_BiddingSource" json:"effective_cpm_bid_source,omitempty"`
	// Output only. Source of the effective CPV bid.
	EffectiveCpvBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,23,opt,name=effective_cpv_bid_source,json=effectiveCpvBidSource,proto3,enum=google.ads.googleads.v1.enums.BiddingSourceEnum_BiddingSource" json:"effective_cpv_bid_source,omitempty"`
	// Output only. Source of the effective Percent CPC bid.
	EffectivePercentCpcBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,35,opt,name=effective_percent_cpc_bid_source,json=effectivePercentCpcBidSource,proto3,enum=google.ads.googleads.v1.enums.BiddingSourceEnum_BiddingSource" json:"effective_percent_cpc_bid_source,omitempty"`
	// Output only. Estimates for criterion bids at various positions.
	PositionEstimates *AdGroupCriterion_PositionEstimates `protobuf:"bytes,10,opt,name=position_estimates,json=positionEstimates,proto3" json:"position_estimates,omitempty"`
	// The list of possible final URLs after all cross-domain redirects for the
	// ad.
	FinalUrls []*wrappers.StringValue `protobuf:"bytes,11,rep,name=final_urls,json=finalUrls,proto3" json:"final_urls,omitempty"`
	// The list of possible final mobile URLs after all cross-domain redirects.
	FinalMobileUrls []*wrappers.StringValue `protobuf:"bytes,51,rep,name=final_mobile_urls,json=finalMobileUrls,proto3" json:"final_mobile_urls,omitempty"`
	// URL template for appending params to final URL.
	FinalUrlSuffix *wrappers.StringValue `protobuf:"bytes,50,opt,name=final_url_suffix,json=finalUrlSuffix,proto3" json:"final_url_suffix,omitempty"`
	// The URL template for constructing a tracking URL.
	TrackingUrlTemplate *wrappers.StringValue `protobuf:"bytes,13,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3" json:"tracking_url_template,omitempty"`
	// The list of mappings used to substitute custom parameter tags in a
	// `tracking_url_template`, `final_urls`, or `mobile_final_urls`.
	UrlCustomParameters []*common.CustomParameter `protobuf:"bytes,14,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// The ad group criterion.
	//
	// Exactly one must be set.
	//
	// Types that are valid to be assigned to Criterion:
	//	*AdGroupCriterion_Keyword
	//	*AdGroupCriterion_Placement
	//	*AdGroupCriterion_MobileAppCategory
	//	*AdGroupCriterion_MobileApplication
	//	*AdGroupCriterion_ListingGroup
	//	*AdGroupCriterion_AgeRange
	//	*AdGroupCriterion_Gender
	//	*AdGroupCriterion_IncomeRange
	//	*AdGroupCriterion_ParentalStatus
	//	*AdGroupCriterion_UserList
	//	*AdGroupCriterion_YoutubeVideo
	//	*AdGroupCriterion_YoutubeChannel
	//	*AdGroupCriterion_Topic
	//	*AdGroupCriterion_UserInterest
	//	*AdGroupCriterion_Webpage
	//	*AdGroupCriterion_AppPaymentModel
	//	*AdGroupCriterion_CustomAffinity
	//	*AdGroupCriterion_CustomIntent
	Criterion            isAdGroupCriterion_Criterion `protobuf_oneof:"criterion"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *AdGroupCriterion) Reset()         { *m = AdGroupCriterion{} }
func (m *AdGroupCriterion) String() string { return proto.CompactTextString(m) }
func (*AdGroupCriterion) ProtoMessage()    {}
func (*AdGroupCriterion) Descriptor() ([]byte, []int) {
	return fileDescriptor_762d1b0ee6b4b0d4, []int{0}
}

func (m *AdGroupCriterion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupCriterion.Unmarshal(m, b)
}
func (m *AdGroupCriterion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupCriterion.Marshal(b, m, deterministic)
}
func (m *AdGroupCriterion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupCriterion.Merge(m, src)
}
func (m *AdGroupCriterion) XXX_Size() int {
	return xxx_messageInfo_AdGroupCriterion.Size(m)
}
func (m *AdGroupCriterion) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupCriterion.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupCriterion proto.InternalMessageInfo

func (m *AdGroupCriterion) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *AdGroupCriterion) GetCriterionId() *wrappers.Int64Value {
	if m != nil {
		return m.CriterionId
	}
	return nil
}

func (m *AdGroupCriterion) GetStatus() enums.AdGroupCriterionStatusEnum_AdGroupCriterionStatus {
	if m != nil {
		return m.Status
	}
	return enums.AdGroupCriterionStatusEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetQualityInfo() *AdGroupCriterion_QualityInfo {
	if m != nil {
		return m.QualityInfo
	}
	return nil
}

func (m *AdGroupCriterion) GetAdGroup() *wrappers.StringValue {
	if m != nil {
		return m.AdGroup
	}
	return nil
}

func (m *AdGroupCriterion) GetType() enums.CriterionTypeEnum_CriterionType {
	if m != nil {
		return m.Type
	}
	return enums.CriterionTypeEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetNegative() *wrappers.BoolValue {
	if m != nil {
		return m.Negative
	}
	return nil
}

func (m *AdGroupCriterion) GetSystemServingStatus() enums.CriterionSystemServingStatusEnum_CriterionSystemServingStatus {
	if m != nil {
		return m.SystemServingStatus
	}
	return enums.CriterionSystemServingStatusEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetApprovalStatus() enums.AdGroupCriterionApprovalStatusEnum_AdGroupCriterionApprovalStatus {
	if m != nil {
		return m.ApprovalStatus
	}
	return enums.AdGroupCriterionApprovalStatusEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetBidModifier() *wrappers.DoubleValue {
	if m != nil {
		return m.BidModifier
	}
	return nil
}

func (m *AdGroupCriterion) GetCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpcBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetCpmBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpmBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetCpvBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpvBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetPercentCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.PercentCpcBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectiveCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectiveCpcBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectiveCpmBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectiveCpmBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectiveCpvBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectiveCpvBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectivePercentCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectivePercentCpcBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectiveCpcBidSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectiveCpcBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetEffectiveCpmBidSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectiveCpmBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetEffectiveCpvBidSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectiveCpvBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetEffectivePercentCpcBidSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectivePercentCpcBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetPositionEstimates() *AdGroupCriterion_PositionEstimates {
	if m != nil {
		return m.PositionEstimates
	}
	return nil
}

func (m *AdGroupCriterion) GetFinalUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalUrls
	}
	return nil
}

func (m *AdGroupCriterion) GetFinalMobileUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalMobileUrls
	}
	return nil
}

func (m *AdGroupCriterion) GetFinalUrlSuffix() *wrappers.StringValue {
	if m != nil {
		return m.FinalUrlSuffix
	}
	return nil
}

func (m *AdGroupCriterion) GetTrackingUrlTemplate() *wrappers.StringValue {
	if m != nil {
		return m.TrackingUrlTemplate
	}
	return nil
}

func (m *AdGroupCriterion) GetUrlCustomParameters() []*common.CustomParameter {
	if m != nil {
		return m.UrlCustomParameters
	}
	return nil
}

type isAdGroupCriterion_Criterion interface {
	isAdGroupCriterion_Criterion()
}

type AdGroupCriterion_Keyword struct {
	Keyword *common.KeywordInfo `protobuf:"bytes,27,opt,name=keyword,proto3,oneof"`
}

type AdGroupCriterion_Placement struct {
	Placement *common.PlacementInfo `protobuf:"bytes,28,opt,name=placement,proto3,oneof"`
}

type AdGroupCriterion_MobileAppCategory struct {
	MobileAppCategory *common.MobileAppCategoryInfo `protobuf:"bytes,29,opt,name=mobile_app_category,json=mobileAppCategory,proto3,oneof"`
}

type AdGroupCriterion_MobileApplication struct {
	MobileApplication *common.MobileApplicationInfo `protobuf:"bytes,30,opt,name=mobile_application,json=mobileApplication,proto3,oneof"`
}

type AdGroupCriterion_ListingGroup struct {
	ListingGroup *common.ListingGroupInfo `protobuf:"bytes,32,opt,name=listing_group,json=listingGroup,proto3,oneof"`
}

type AdGroupCriterion_AgeRange struct {
	AgeRange *common.AgeRangeInfo `protobuf:"bytes,36,opt,name=age_range,json=ageRange,proto3,oneof"`
}

type AdGroupCriterion_Gender struct {
	Gender *common.GenderInfo `protobuf:"bytes,37,opt,name=gender,proto3,oneof"`
}

type AdGroupCriterion_IncomeRange struct {
	IncomeRange *common.IncomeRangeInfo `protobuf:"bytes,38,opt,name=income_range,json=incomeRange,proto3,oneof"`
}

type AdGroupCriterion_ParentalStatus struct {
	ParentalStatus *common.ParentalStatusInfo `protobuf:"bytes,39,opt,name=parental_status,json=parentalStatus,proto3,oneof"`
}

type AdGroupCriterion_UserList struct {
	UserList *common.UserListInfo `protobuf:"bytes,42,opt,name=user_list,json=userList,proto3,oneof"`
}

type AdGroupCriterion_YoutubeVideo struct {
	YoutubeVideo *common.YouTubeVideoInfo `protobuf:"bytes,40,opt,name=youtube_video,json=youtubeVideo,proto3,oneof"`
}

type AdGroupCriterion_YoutubeChannel struct {
	YoutubeChannel *common.YouTubeChannelInfo `protobuf:"bytes,41,opt,name=youtube_channel,json=youtubeChannel,proto3,oneof"`
}

type AdGroupCriterion_Topic struct {
	Topic *common.TopicInfo `protobuf:"bytes,43,opt,name=topic,proto3,oneof"`
}

type AdGroupCriterion_UserInterest struct {
	UserInterest *common.UserInterestInfo `protobuf:"bytes,45,opt,name=user_interest,json=userInterest,proto3,oneof"`
}

type AdGroupCriterion_Webpage struct {
	Webpage *common.WebpageInfo `protobuf:"bytes,46,opt,name=webpage,proto3,oneof"`
}

type AdGroupCriterion_AppPaymentModel struct {
	AppPaymentModel *common.AppPaymentModelInfo `protobuf:"bytes,47,opt,name=app_payment_model,json=appPaymentModel,proto3,oneof"`
}

type AdGroupCriterion_CustomAffinity struct {
	CustomAffinity *common.CustomAffinityInfo `protobuf:"bytes,48,opt,name=custom_affinity,json=customAffinity,proto3,oneof"`
}

type AdGroupCriterion_CustomIntent struct {
	CustomIntent *common.CustomIntentInfo `protobuf:"bytes,49,opt,name=custom_intent,json=customIntent,proto3,oneof"`
}

func (*AdGroupCriterion_Keyword) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Placement) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_MobileAppCategory) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_MobileApplication) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_ListingGroup) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_AgeRange) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Gender) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_IncomeRange) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_ParentalStatus) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_UserList) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_YoutubeVideo) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_YoutubeChannel) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Topic) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_UserInterest) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Webpage) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_AppPaymentModel) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_CustomAffinity) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_CustomIntent) isAdGroupCriterion_Criterion() {}

func (m *AdGroupCriterion) GetCriterion() isAdGroupCriterion_Criterion {
	if m != nil {
		return m.Criterion
	}
	return nil
}

func (m *AdGroupCriterion) GetKeyword() *common.KeywordInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Keyword); ok {
		return x.Keyword
	}
	return nil
}

func (m *AdGroupCriterion) GetPlacement() *common.PlacementInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Placement); ok {
		return x.Placement
	}
	return nil
}

func (m *AdGroupCriterion) GetMobileAppCategory() *common.MobileAppCategoryInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_MobileAppCategory); ok {
		return x.MobileAppCategory
	}
	return nil
}

func (m *AdGroupCriterion) GetMobileApplication() *common.MobileApplicationInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_MobileApplication); ok {
		return x.MobileApplication
	}
	return nil
}

func (m *AdGroupCriterion) GetListingGroup() *common.ListingGroupInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_ListingGroup); ok {
		return x.ListingGroup
	}
	return nil
}

func (m *AdGroupCriterion) GetAgeRange() *common.AgeRangeInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_AgeRange); ok {
		return x.AgeRange
	}
	return nil
}

func (m *AdGroupCriterion) GetGender() *common.GenderInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Gender); ok {
		return x.Gender
	}
	return nil
}

func (m *AdGroupCriterion) GetIncomeRange() *common.IncomeRangeInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_IncomeRange); ok {
		return x.IncomeRange
	}
	return nil
}

func (m *AdGroupCriterion) GetParentalStatus() *common.ParentalStatusInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_ParentalStatus); ok {
		return x.ParentalStatus
	}
	return nil
}

func (m *AdGroupCriterion) GetUserList() *common.UserListInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_UserList); ok {
		return x.UserList
	}
	return nil
}

func (m *AdGroupCriterion) GetYoutubeVideo() *common.YouTubeVideoInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_YoutubeVideo); ok {
		return x.YoutubeVideo
	}
	return nil
}

func (m *AdGroupCriterion) GetYoutubeChannel() *common.YouTubeChannelInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_YoutubeChannel); ok {
		return x.YoutubeChannel
	}
	return nil
}

func (m *AdGroupCriterion) GetTopic() *common.TopicInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Topic); ok {
		return x.Topic
	}
	return nil
}

func (m *AdGroupCriterion) GetUserInterest() *common.UserInterestInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_UserInterest); ok {
		return x.UserInterest
	}
	return nil
}

func (m *AdGroupCriterion) GetWebpage() *common.WebpageInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Webpage); ok {
		return x.Webpage
	}
	return nil
}

func (m *AdGroupCriterion) GetAppPaymentModel() *common.AppPaymentModelInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_AppPaymentModel); ok {
		return x.AppPaymentModel
	}
	return nil
}

func (m *AdGroupCriterion) GetCustomAffinity() *common.CustomAffinityInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_CustomAffinity); ok {
		return x.CustomAffinity
	}
	return nil
}

func (m *AdGroupCriterion) GetCustomIntent() *common.CustomIntentInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_CustomIntent); ok {
		return x.CustomIntent
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*AdGroupCriterion) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*AdGroupCriterion_Keyword)(nil),
		(*AdGroupCriterion_Placement)(nil),
		(*AdGroupCriterion_MobileAppCategory)(nil),
		(*AdGroupCriterion_MobileApplication)(nil),
		(*AdGroupCriterion_ListingGroup)(nil),
		(*AdGroupCriterion_AgeRange)(nil),
		(*AdGroupCriterion_Gender)(nil),
		(*AdGroupCriterion_IncomeRange)(nil),
		(*AdGroupCriterion_ParentalStatus)(nil),
		(*AdGroupCriterion_UserList)(nil),
		(*AdGroupCriterion_YoutubeVideo)(nil),
		(*AdGroupCriterion_YoutubeChannel)(nil),
		(*AdGroupCriterion_Topic)(nil),
		(*AdGroupCriterion_UserInterest)(nil),
		(*AdGroupCriterion_Webpage)(nil),
		(*AdGroupCriterion_AppPaymentModel)(nil),
		(*AdGroupCriterion_CustomAffinity)(nil),
		(*AdGroupCriterion_CustomIntent)(nil),
	}
}

// A container for ad group criterion quality information.
type AdGroupCriterion_QualityInfo struct {
	// Output only. The quality score.
	//
	// This field may not be populated if Google does not have enough
	// information to determine a value.
	QualityScore *wrappers.Int32Value `protobuf:"bytes,1,opt,name=quality_score,json=qualityScore,proto3" json:"quality_score,omitempty"`
	// Output only. The performance of the ad compared to other advertisers.
	CreativeQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,2,opt,name=creative_quality_score,json=creativeQualityScore,proto3,enum=google.ads.googleads.v1.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"creative_quality_score,omitempty"`
	// Output only. The quality score of the landing page.
	PostClickQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,3,opt,name=post_click_quality_score,json=postClickQualityScore,proto3,enum=google.ads.googleads.v1.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"post_click_quality_score,omitempty"`
	// Output only. The click-through rate compared to that of other advertisers.
	SearchPredictedCtr   enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,4,opt,name=search_predicted_ctr,json=searchPredictedCtr,proto3,enum=google.ads.googleads.v1.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"search_predicted_ctr,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                        `json:"-"`
	XXX_unrecognized     []byte                                          `json:"-"`
	XXX_sizecache        int32                                           `json:"-"`
}

func (m *AdGroupCriterion_QualityInfo) Reset()         { *m = AdGroupCriterion_QualityInfo{} }
func (m *AdGroupCriterion_QualityInfo) String() string { return proto.CompactTextString(m) }
func (*AdGroupCriterion_QualityInfo) ProtoMessage()    {}
func (*AdGroupCriterion_QualityInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_762d1b0ee6b4b0d4, []int{0, 0}
}

func (m *AdGroupCriterion_QualityInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupCriterion_QualityInfo.Unmarshal(m, b)
}
func (m *AdGroupCriterion_QualityInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupCriterion_QualityInfo.Marshal(b, m, deterministic)
}
func (m *AdGroupCriterion_QualityInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupCriterion_QualityInfo.Merge(m, src)
}
func (m *AdGroupCriterion_QualityInfo) XXX_Size() int {
	return xxx_messageInfo_AdGroupCriterion_QualityInfo.Size(m)
}
func (m *AdGroupCriterion_QualityInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupCriterion_QualityInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupCriterion_QualityInfo proto.InternalMessageInfo

func (m *AdGroupCriterion_QualityInfo) GetQualityScore() *wrappers.Int32Value {
	if m != nil {
		return m.QualityScore
	}
	return nil
}

func (m *AdGroupCriterion_QualityInfo) GetCreativeQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.CreativeQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (m *AdGroupCriterion_QualityInfo) GetPostClickQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.PostClickQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (m *AdGroupCriterion_QualityInfo) GetSearchPredictedCtr() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.SearchPredictedCtr
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

// Estimates for criterion bids at various positions.
type AdGroupCriterion_PositionEstimates struct {
	// Output only. The estimate of the CPC bid required for ad to be shown on first
	// page of search results.
	FirstPageCpcMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=first_page_cpc_micros,json=firstPageCpcMicros,proto3" json:"first_page_cpc_micros,omitempty"`
	// Output only. The estimate of the CPC bid required for ad to be displayed in first
	// position, at the top of the first page of search results.
	FirstPositionCpcMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=first_position_cpc_micros,json=firstPositionCpcMicros,proto3" json:"first_position_cpc_micros,omitempty"`
	// Output only. The estimate of the CPC bid required for ad to be displayed at the top
	// of the first page of search results.
	TopOfPageCpcMicros *wrappers.Int64Value `protobuf:"bytes,3,opt,name=top_of_page_cpc_micros,json=topOfPageCpcMicros,proto3" json:"top_of_page_cpc_micros,omitempty"`
	// Output only. Estimate of how many clicks per week you might get by changing your
	// keyword bid to the value in first_position_cpc_micros.
	EstimatedAddClicksAtFirstPositionCpc *wrappers.Int64Value `protobuf:"bytes,4,opt,name=estimated_add_clicks_at_first_position_cpc,json=estimatedAddClicksAtFirstPositionCpc,proto3" json:"estimated_add_clicks_at_first_position_cpc,omitempty"`
	// Output only. Estimate of how your cost per week might change when changing your
	// keyword bid to the value in first_position_cpc_micros.
	EstimatedAddCostAtFirstPositionCpc *wrappers.Int64Value `protobuf:"bytes,5,opt,name=estimated_add_cost_at_first_position_cpc,json=estimatedAddCostAtFirstPositionCpc,proto3" json:"estimated_add_cost_at_first_position_cpc,omitempty"`
	XXX_NoUnkeyedLiteral               struct{}             `json:"-"`
	XXX_unrecognized                   []byte               `json:"-"`
	XXX_sizecache                      int32                `json:"-"`
}

func (m *AdGroupCriterion_PositionEstimates) Reset()         { *m = AdGroupCriterion_PositionEstimates{} }
func (m *AdGroupCriterion_PositionEstimates) String() string { return proto.CompactTextString(m) }
func (*AdGroupCriterion_PositionEstimates) ProtoMessage()    {}
func (*AdGroupCriterion_PositionEstimates) Descriptor() ([]byte, []int) {
	return fileDescriptor_762d1b0ee6b4b0d4, []int{0, 1}
}

func (m *AdGroupCriterion_PositionEstimates) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupCriterion_PositionEstimates.Unmarshal(m, b)
}
func (m *AdGroupCriterion_PositionEstimates) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupCriterion_PositionEstimates.Marshal(b, m, deterministic)
}
func (m *AdGroupCriterion_PositionEstimates) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupCriterion_PositionEstimates.Merge(m, src)
}
func (m *AdGroupCriterion_PositionEstimates) XXX_Size() int {
	return xxx_messageInfo_AdGroupCriterion_PositionEstimates.Size(m)
}
func (m *AdGroupCriterion_PositionEstimates) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupCriterion_PositionEstimates.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupCriterion_PositionEstimates proto.InternalMessageInfo

func (m *AdGroupCriterion_PositionEstimates) GetFirstPageCpcMicros() *wrappers.Int64Value {
	if m != nil {
		return m.FirstPageCpcMicros
	}
	return nil
}

func (m *AdGroupCriterion_PositionEstimates) GetFirstPositionCpcMicros() *wrappers.Int64Value {
	if m != nil {
		return m.FirstPositionCpcMicros
	}
	return nil
}

func (m *AdGroupCriterion_PositionEstimates) GetTopOfPageCpcMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TopOfPageCpcMicros
	}
	return nil
}

func (m *AdGroupCriterion_PositionEstimates) GetEstimatedAddClicksAtFirstPositionCpc() *wrappers.Int64Value {
	if m != nil {
		return m.EstimatedAddClicksAtFirstPositionCpc
	}
	return nil
}

func (m *AdGroupCriterion_PositionEstimates) GetEstimatedAddCostAtFirstPositionCpc() *wrappers.Int64Value {
	if m != nil {
		return m.EstimatedAddCostAtFirstPositionCpc
	}
	return nil
}

func init() {
	proto.RegisterType((*AdGroupCriterion)(nil), "google.ads.googleads.v1.resources.AdGroupCriterion")
	proto.RegisterType((*AdGroupCriterion_QualityInfo)(nil), "google.ads.googleads.v1.resources.AdGroupCriterion.QualityInfo")
	proto.RegisterType((*AdGroupCriterion_PositionEstimates)(nil), "google.ads.googleads.v1.resources.AdGroupCriterion.PositionEstimates")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/resources/ad_group_criterion.proto", fileDescriptor_762d1b0ee6b4b0d4)
}

var fileDescriptor_762d1b0ee6b4b0d4 = []byte{
	// 1821 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x99, 0x4d, 0x73, 0x1c, 0x39,
	0x19, 0xc7, 0x19, 0x3b, 0xce, 0xc6, 0xb2, 0xe3, 0xc4, 0x72, 0x6c, 0x14, 0x6f, 0xd8, 0x75, 0xc2,
	0x06, 0x9c, 0x64, 0x33, 0xb3, 0x76, 0x36, 0x14, 0x4c, 0x0a, 0xb6, 0x66, 0x86, 0xbc, 0x18, 0x36,
	0x30, 0x3b, 0x76, 0xbc, 0x15, 0x70, 0x55, 0xa3, 0xe9, 0x56, 0xb7, 0x55, 0xee, 0x6e, 0xf5, 0x4a,
	0xea, 0x09, 0xc3, 0xb2, 0x45, 0x15, 0x54, 0x71, 0xa1, 0x0a, 0x4e, 0x7c, 0x01, 0x8e, 0x7c, 0x14,
	0x3e, 0x04, 0xb5, 0x07, 0x4e, 0xfb, 0x11, 0x38, 0x6d, 0xe9, 0xa5, 0x67, 0xba, 0x67, 0x3c, 0xee,
	0x76, 0x2a, 0xb9, 0xb5, 0x25, 0xfd, 0x7f, 0xff, 0x47, 0x8f, 0x9e, 0xd6, 0x48, 0x6d, 0xd0, 0x0c,
	0x18, 0x0b, 0x42, 0xd2, 0xc0, 0x9e, 0x68, 0x98, 0x47, 0xf5, 0x34, 0xd8, 0x69, 0x70, 0x22, 0x58,
	0xca, 0x5d, 0x22, 0x1a, 0xd8, 0x73, 0x02, 0xce, 0xd2, 0xc4, 0x71, 0x39, 0x95, 0x84, 0x53, 0x16,
	0xd7, 0x13, 0xce, 0x24, 0x83, 0x37, 0x8d, 0xa0, 0x8e, 0x3d, 0x51, 0x1f, 0x69, 0xeb, 0x83, 0x9d,
	0xfa, 0x48, 0xbb, 0x79, 0x7f, 0x16, 0xde, 0x65, 0x51, 0xc4, 0xe2, 0x86, 0x45, 0x62, 0x43, 0xdc,
	0x7c, 0x58, 0x36, 0x3c, 0x15, 0x92, 0x45, 0x4e, 0x82, 0x39, 0x8e, 0x88, 0x24, 0xdc, 0xca, 0x9e,
	0xcc, 0x92, 0x91, 0x38, 0x8d, 0x4e, 0x9b, 0x80, 0x83, 0x93, 0x84, 0xb3, 0x01, 0x0e, 0x1d, 0x21,
	0xb1, 0x4c, 0x85, 0xe5, 0xfc, 0xf4, 0xdc, 0x9c, 0x82, 0x7c, 0xf7, 0x6c, 0x79, 0x9f, 0x7a, 0x1e,
	0x8d, 0x03, 0xc7, 0xe4, 0xc6, 0x6a, 0x3a, 0x67, 0x6b, 0x72, 0x4e, 0x43, 0x21, 0x49, 0xe4, 0x08,
	0xc2, 0x07, 0x1a, 0x72, 0x0e, 0xe3, 0x31, 0x44, 0x0e, 0x93, 0xcc, 0xf8, 0xc7, 0x67, 0x6b, 0xbe,
	0x48, 0x71, 0x48, 0xe5, 0xd0, 0x11, 0x2e, 0xe3, 0xc4, 0xe9, 0xa7, 0xee, 0x09, 0x91, 0x56, 0xf9,
	0x7e, 0xa6, 0x4c, 0x68, 0xc3, 0xa7, 0x24, 0xf4, 0x9c, 0x3e, 0x39, 0xc6, 0x03, 0xca, 0xb2, 0xe5,
	0xb8, 0x9e, 0x1b, 0x90, 0x95, 0x82, 0xed, 0x7a, 0xcf, 0x76, 0xe9, 0xbf, 0xfa, 0xa9, 0xdf, 0x78,
	0xc5, 0x71, 0x92, 0x10, 0x9e, 0xcd, 0xe4, 0x46, 0x4e, 0x8a, 0xe3, 0x98, 0x49, 0x2c, 0x29, 0x8b,
	0x6d, 0xef, 0xad, 0xff, 0xde, 0x05, 0x57, 0x5b, 0xde, 0x53, 0xb5, 0x06, 0x9d, 0x6c, 0x4e, 0xf0,
	0x10, 0x5c, 0xce, 0x4c, 0x9c, 0x18, 0x47, 0x04, 0xd5, 0xb6, 0x6a, 0xdb, 0x8b, 0xed, 0x9d, 0xaf,
	0x5b, 0x0b, 0xff, 0x6f, 0xdd, 0x03, 0x77, 0xc6, 0x95, 0x69, 0x9f, 0x12, 0x2a, 0xea, 0x2e, 0x8b,
	0x1a, 0x93, 0xa4, 0xde, 0x72, 0xc6, 0xf9, 0x15, 0x8e, 0x08, 0xec, 0x80, 0xe5, 0x71, 0xe2, 0xa8,
	0x87, 0x36, 0xb7, 0x6a, 0xdb, 0x4b, 0xbb, 0xef, 0x5a, 0x4a, 0x3d, 0x9b, 0x41, 0x7d, 0x2f, 0x96,
	0x3f, 0xfa, 0xf8, 0x10, 0x87, 0x29, 0x69, 0xcf, 0x7f, 0xdd, 0x9a, 0xef, 0x2d, 0x8d, 0x54, 0x7b,
	0x1e, 0x3c, 0x06, 0x17, 0xcd, 0x4a, 0xa1, 0xf9, 0xad, 0xda, 0xf6, 0xca, 0x6e, 0xb7, 0x3e, 0xeb,
	0x9d, 0xd1, 0x69, 0xaf, 0x4f, 0xc6, 0xb4, 0xaf, 0xc5, 0x8f, 0xe3, 0x34, 0x9a, 0xd1, 0xd5, 0xb3,
	0x7c, 0x18, 0x80, 0xe5, 0x6c, 0xcd, 0x68, 0xec, 0x33, 0x74, 0x41, 0x87, 0xfb, 0x49, 0xbd, 0xf4,
	0x1d, 0x9d, 0x02, 0xd7, 0x3f, 0x33, 0x9c, 0xbd, 0xd8, 0x67, 0x76, 0x4a, 0x5f, 0x8c, 0x5b, 0x20,
	0x06, 0x97, 0xb2, 0x17, 0x01, 0x2d, 0x68, 0x93, 0x1b, 0x53, 0x39, 0xd9, 0x97, 0x9c, 0xc6, 0x81,
	0x49, 0xca, 0xb6, 0x5e, 0x88, 0x5b, 0x60, 0xab, 0x6c, 0x21, 0x7a, 0xef, 0x60, 0xf3, 0x00, 0x3f,
	0x07, 0x17, 0x54, 0xa5, 0xa2, 0xeb, 0x3a, 0x67, 0x3f, 0x2b, 0xc9, 0xd9, 0x28, 0xf0, 0x83, 0x61,
	0x42, 0x74, 0xaa, 0x0a, 0x2d, 0x66, 0x0a, 0x1a, 0x08, 0x1f, 0x81, 0x4b, 0x31, 0x09, 0xb0, 0xa4,
	0x03, 0x82, 0xde, 0xd7, 0xb1, 0x6f, 0x4e, 0xc5, 0xde, 0x66, 0x2c, 0x1c, 0x2d, 0xe7, 0x42, 0x6f,
	0x24, 0x80, 0xff, 0xac, 0x81, 0xf5, 0x53, 0xdf, 0x42, 0xf4, 0xb1, 0x8e, 0xf3, 0xa8, 0x6a, 0x9c,
	0xfb, 0x1a, 0xb2, 0x6f, 0x18, 0xb9, 0x15, 0x3e, 0x6b, 0x80, 0x99, 0xc5, 0x9a, 0x98, 0xee, 0x81,
	0x7f, 0xaf, 0x81, 0x2b, 0x13, 0xfb, 0x19, 0x7a, 0xa8, 0x23, 0xfa, 0xdd, 0x39, 0xab, 0xad, 0x65,
	0x29, 0x67, 0x54, 0x5d, 0x71, 0x88, 0x89, 0x6a, 0x05, 0x17, 0x1a, 0xe1, 0x27, 0x60, 0xb9, 0x4f,
	0x3d, 0x27, 0x62, 0x1e, 0xf5, 0x29, 0xe1, 0xe8, 0xc3, 0x19, 0x55, 0xf2, 0x73, 0x96, 0xf6, 0x43,
	0xa2, 0x73, 0xdd, 0x5b, 0xea, 0x53, 0xef, 0xb9, 0x15, 0xc0, 0x16, 0x58, 0x71, 0x13, 0xd7, 0xd1,
	0x10, 0xea, 0x72, 0x26, 0xd0, 0xd5, 0xd2, 0x97, 0xaf, 0xb7, 0xec, 0x26, 0x6e, 0x9b, 0x7a, 0xcf,
	0xb5, 0xc0, 0x20, 0xa2, 0x3c, 0x62, 0xb5, 0x12, 0x22, 0x9a, 0x40, 0x0c, 0xf2, 0x08, 0x54, 0x09,
	0x31, 0x18, 0x23, 0xba, 0x60, 0x23, 0x21, 0xdc, 0x25, 0xb1, 0x74, 0x26, 0x26, 0x74, 0xb3, 0x1c,
	0xb5, 0x66, 0xa5, 0x9d, 0xfc, 0xbc, 0x5e, 0x02, 0x44, 0x7c, 0x9f, 0xb8, 0xaa, 0x22, 0x27, 0x99,
	0xb0, 0xe2, 0x0e, 0xb5, 0x3e, 0x22, 0x9c, 0x85, 0x2e, 0x24, 0x6f, 0xed, 0x35, 0xd0, 0xd1, 0x4c,
	0x74, 0x21, 0xa9, 0xd7, 0x5e, 0x03, 0x9d, 0x4b, 0xf1, 0x31, 0xd8, 0x1a, 0xa3, 0x67, 0x24, 0xfb,
	0x56, 0x45, 0x8b, 0x1b, 0x23, 0x52, 0xf7, 0x94, 0xd4, 0xff, 0xf1, 0xb4, 0xd4, 0x9b, 0x4d, 0x14,
	0xad, 0x57, 0xda, 0xa9, 0xda, 0xe6, 0x04, 0xb0, 0xaf, 0x35, 0xfa, 0xf5, 0x2a, 0xb4, 0x9c, 0xbe,
	0x3a, 0xa6, 0x6f, 0xd2, 0x3d, 0xca, 0xbb, 0x6f, 0xbc, 0x1d, 0xf7, 0x68, 0xa6, 0xfb, 0x20, 0xef,
	0xfe, 0xdd, 0xb7, 0xe3, 0x3e, 0x18, 0xbb, 0xff, 0xad, 0x76, 0xd6, 0x22, 0xdb, 0x30, 0xbe, 0xff,
	0xe6, 0xc2, 0x98, 0x51, 0x07, 0x36, 0x9a, 0x21, 0x80, 0x09, 0x13, 0x54, 0x1d, 0x4c, 0x1c, 0x22,
	0x24, 0x8d, 0xb0, 0x24, 0x02, 0x01, 0x5d, 0x63, 0x8f, 0x5f, 0xe7, 0xf7, 0xb6, 0x6b, 0x69, 0x8f,
	0x33, 0x98, 0x89, 0x62, 0x35, 0x99, 0x6c, 0x87, 0x8f, 0x00, 0xf0, 0x69, 0x8c, 0x43, 0x27, 0xe5,
	0xa1, 0x40, 0x4b, 0x5b, 0xf3, 0x65, 0xbf, 0xbe, 0xbd, 0x45, 0x3d, 0xfe, 0x05, 0x0f, 0x05, 0x7c,
	0x06, 0x56, 0x8d, 0x38, 0x62, 0x7d, 0x1a, 0x12, 0xc3, 0x78, 0x50, 0x81, 0x71, 0x45, 0xcb, 0x9e,
	0x6b, 0x95, 0x26, 0x3d, 0x01, 0x57, 0x47, 0x61, 0x38, 0x22, 0xf5, 0x7d, 0xfa, 0x7b, 0xb4, 0x5b,
	0x7e, 0x14, 0xe8, 0xad, 0x64, 0xc1, 0xec, 0x6b, 0x0d, 0xec, 0x82, 0x75, 0xc9, 0xb1, 0x7b, 0xa2,
	0x7e, 0x4a, 0x15, 0x4a, 0x92, 0x28, 0x09, 0xb1, 0x24, 0xe8, 0x72, 0x05, 0xd8, 0x5a, 0x26, 0x7d,
	0xc1, 0xc3, 0x03, 0x2b, 0x84, 0x2e, 0x58, 0x57, 0xa0, 0xc9, 0x7b, 0x82, 0x40, 0x2b, 0x7a, 0x9e,
	0x8d, 0x99, 0xcb, 0x63, 0x2e, 0x18, 0xf5, 0x8e, 0x16, 0x76, 0x33, 0x5d, 0x6f, 0x2d, 0xe5, 0xe1,
	0x44, 0x9b, 0x80, 0x9f, 0x82, 0x77, 0x4e, 0xc8, 0xf0, 0x15, 0xe3, 0x1e, 0x7a, 0x57, 0x07, 0x7a,
	0xaf, 0x0c, 0xfb, 0x4b, 0x33, 0x3c, 0x3b, 0x51, 0x2d, 0x3c, 0xfb, 0x4e, 0x2f, 0x43, 0xc0, 0x1e,
	0x58, 0x4c, 0x42, 0xec, 0x92, 0x88, 0xc4, 0x12, 0xdd, 0xd0, 0xbc, 0xfb, 0x65, 0xbc, 0x6e, 0x26,
	0xc8, 0x13, 0xc7, 0x18, 0x18, 0x82, 0x35, 0xbb, 0xc8, 0x38, 0x49, 0x1c, 0x17, 0x4b, 0x12, 0x30,
	0x3e, 0x44, 0xdf, 0xd3, 0xf4, 0x87, 0x65, 0x74, 0xb3, 0xd2, 0xad, 0x24, 0xe9, 0x58, 0x61, 0xde,
	0x65, 0x35, 0x9a, 0xec, 0x85, 0x27, 0x00, 0x8e, 0xdd, 0x42, 0xea, 0xea, 0x33, 0x3b, 0x7a, 0xef,
	0x9c, 0x66, 0x99, 0xf0, 0x74, 0xb3, 0xac, 0x17, 0x1e, 0x81, 0xcb, 0x21, 0x15, 0x52, 0x95, 0x8c,
	0x39, 0x83, 0x6e, 0x69, 0x9f, 0x8f, 0xca, 0x7c, 0x3e, 0x35, 0x22, 0xfd, 0xea, 0xe5, 0x2d, 0x96,
	0xc3, 0x5c, 0x07, 0xec, 0x82, 0x45, 0x1c, 0x10, 0x87, 0xe3, 0x38, 0x20, 0xe8, 0x03, 0x4d, 0xfe,
	0xb0, 0x8c, 0xdc, 0x0a, 0x48, 0x4f, 0x8d, 0xcf, 0x53, 0x2f, 0x61, 0xdb, 0x08, 0xf7, 0xc0, 0xc5,
	0x80, 0xc4, 0x1e, 0xe1, 0xe8, 0xb6, 0xc6, 0xdd, 0x2d, 0xc3, 0x3d, 0xd5, 0xa3, 0xf3, 0x30, 0x0b,
	0x80, 0x2f, 0xc1, 0x32, 0x8d, 0x5d, 0x16, 0x65, 0xf1, 0xfd, 0x40, 0x03, 0x4b, 0x6b, 0x7a, 0x4f,
	0x6b, 0xa6, 0x42, 0x5c, 0xa2, 0xe3, 0x76, 0xd8, 0x07, 0x57, 0x12, 0xcc, 0x49, 0x2c, 0xc7, 0x47,
	0xc8, 0x1f, 0x6a, 0xfa, 0x6e, 0x69, 0x29, 0x5a, 0x99, 0x39, 0xfb, 0xe5, 0x0d, 0x56, 0x92, 0x42,
	0x97, 0xca, 0x6d, 0x2a, 0x08, 0x77, 0x54, 0xc2, 0xd1, 0xdd, 0x6a, 0xb9, 0x7d, 0x21, 0x08, 0x57,
	0x2b, 0x57, 0xc8, 0x6d, 0x6a, 0x1b, 0x55, 0x2d, 0x0c, 0x59, 0x2a, 0xd3, 0x3e, 0x71, 0x06, 0xd4,
	0x23, 0x0c, 0x6d, 0x57, 0xab, 0x85, 0x97, 0x2c, 0x3d, 0x48, 0xfb, 0xe4, 0x50, 0x69, 0x0a, 0xb5,
	0x60, 0x69, 0xba, 0x43, 0xe5, 0x24, 0xa3, 0xbb, 0xc7, 0x38, 0x8e, 0x49, 0x88, 0xee, 0x54, 0xcb,
	0x89, 0xe5, 0x77, 0x8c, 0xaa, 0x90, 0x13, 0x4b, 0xb4, 0x5d, 0xf0, 0x09, 0x58, 0x90, 0x2c, 0xa1,
	0x2e, 0xba, 0xa7, 0xc9, 0x77, 0xca, 0xc8, 0x07, 0x6a, 0x70, 0x1e, 0x68, 0xe4, 0x2a, 0x13, 0x3a,
	0xb7, 0x34, 0x96, 0x84, 0x13, 0x21, 0xd1, 0xfd, 0x6a, 0x99, 0x50, 0xf9, 0xdd, 0xb3, 0x9a, 0x42,
	0x26, 0xd2, 0x5c, 0x87, 0xda, 0xf0, 0x5e, 0x91, 0x7e, 0x82, 0x03, 0x82, 0xea, 0xd5, 0x36, 0xbc,
	0xcf, 0xcd, 0xf0, 0xc2, 0x86, 0x67, 0x11, 0xd0, 0x07, 0xab, 0x6a, 0x57, 0x4a, 0xf0, 0x50, 0xed,
	0x55, 0xea, 0x9a, 0x40, 0x42, 0xd4, 0xd0, 0xdc, 0x07, 0xa5, 0xef, 0x5a, 0x92, 0x74, 0x8d, 0xee,
	0xb9, 0x92, 0xe5, 0xf9, 0xea, 0x0e, 0x94, 0xef, 0x53, 0xeb, 0x67, 0x7f, 0x07, 0xb0, 0xef, 0xd3,
	0x98, 0xca, 0x21, 0xfa, 0xa8, 0xda, 0xfa, 0x99, 0x1d, 0xbf, 0x65, 0x55, 0x85, 0xf5, 0x73, 0x0b,
	0x5d, 0x2a, 0xef, 0xd6, 0x43, 0x65, 0x3e, 0x96, 0x68, 0xa7, 0x5a, 0xde, 0x8d, 0xc3, 0x9e, 0xd6,
	0x14, 0xf2, 0xee, 0xe6, 0x3a, 0x36, 0xff, 0x37, 0x0f, 0x96, 0x72, 0x97, 0x71, 0xf8, 0x18, 0x5c,
	0x2e, 0x7c, 0x97, 0xd1, 0x9f, 0x3a, 0x66, 0x1c, 0x6c, 0x1f, 0xec, 0xe6, 0x0e, 0xb6, 0xd9, 0xa7,
	0x81, 0x7d, 0xa5, 0x82, 0x7f, 0xa9, 0x81, 0x0d, 0x97, 0x13, 0x7d, 0xab, 0x75, 0x8a, 0xc0, 0x39,
	0x7d, 0x88, 0x7a, 0x56, 0x72, 0x88, 0xfa, 0x2c, 0x47, 0x6b, 0xeb, 0x4f, 0x43, 0xfa, 0x24, 0x35,
	0xdd, 0x6c, 0xdc, 0xaf, 0x65, 0x66, 0xf9, 0x01, 0xf0, 0xaf, 0x35, 0x80, 0x12, 0x26, 0xa4, 0xe3,
	0x86, 0xd4, 0x3d, 0x99, 0x88, 0x63, 0xfe, 0x6d, 0xc4, 0xb1, 0xae, 0xec, 0x3a, 0xca, 0xad, 0x10,
	0xc8, 0x9f, 0xc0, 0x35, 0x41, 0x30, 0x77, 0x8f, 0x9d, 0x84, 0x13, 0x8f, 0xba, 0x92, 0x78, 0x8e,
	0x2b, 0xb9, 0xfe, 0x82, 0xf2, 0xc6, 0x63, 0x80, 0xc6, 0xaa, 0x9b, 0x39, 0x75, 0x24, 0xdf, 0xfc,
	0xc7, 0x05, 0xb0, 0x3a, 0x75, 0x06, 0x84, 0xfb, 0x60, 0xdd, 0xa7, 0x5c, 0x48, 0x47, 0xbd, 0x34,
	0xfa, 0xb0, 0x6b, 0x6f, 0x33, 0xb5, 0x8a, 0xb7, 0x19, 0xa8, 0xe5, 0x5d, 0x1c, 0xa8, 0x8b, 0x84,
	0xbd, 0xc3, 0xfc, 0x16, 0x5c, 0xb7, 0xd0, 0xec, 0x04, 0x9b, 0x03, 0xcf, 0x55, 0x04, 0x6f, 0x18,
	0xb0, 0x25, 0x8c, 0xe1, 0x07, 0x60, 0x43, 0xb2, 0xc4, 0x61, 0xfe, 0x54, 0xc8, 0xf3, 0x55, 0x43,
	0x96, 0x2c, 0xf9, 0xb5, 0x5f, 0x0c, 0xf9, 0x0f, 0xe0, 0x6e, 0x76, 0xca, 0xf6, 0x1c, 0xec, 0x79,
	0xa6, 0x5e, 0x84, 0x83, 0xa5, 0x33, 0x3d, 0x15, 0xfb, 0xd9, 0xab, 0xdc, 0xe9, 0x83, 0x11, 0xb3,
	0xe5, 0x79, 0xba, 0x26, 0x44, 0x4b, 0x3e, 0x99, 0x98, 0x17, 0x1c, 0x80, 0xed, 0x09, 0x6f, 0x55,
	0xb0, 0xa7, 0x3b, 0x2f, 0x54, 0x74, 0xbe, 0x55, 0x70, 0x66, 0x42, 0x4e, 0xfb, 0x36, 0xe9, 0x37,
	0x2d, 0xff, 0x1c, 0x5f, 0x2e, 0xe1, 0x4f, 0xcc, 0xb6, 0x41, 0xb8, 0x68, 0x7c, 0x99, 0x3d, 0x7e,
	0xd5, 0xc0, 0x85, 0x61, 0xb8, 0xf1, 0xe5, 0xf4, 0x07, 0xec, 0xaf, 0xda, 0x4b, 0x60, 0x71, 0xf4,
	0x57, 0xfb, 0xcf, 0x73, 0xe0, 0xb6, 0xcb, 0xa2, 0xf2, 0x4b, 0x4c, 0x7b, 0x7d, 0x32, 0x86, 0xae,
	0x9a, 0x6f, 0xb7, 0xf6, 0x9b, 0x5f, 0x58, 0x6d, 0xc0, 0x42, 0x1c, 0x07, 0x75, 0xc6, 0x83, 0x46,
	0x40, 0x62, 0x9d, 0x8d, 0xc6, 0x78, 0x1a, 0x67, 0xfc, 0xbf, 0xe1, 0xd1, 0xe8, 0xe9, 0x5f, 0x73,
	0xf3, 0x4f, 0x5b, 0xad, 0x7f, 0xcf, 0xdd, 0x7c, 0x6a, 0x90, 0x2d, 0x4f, 0xd4, 0xcd, 0xa3, 0x7a,
	0x3a, 0xdc, 0xa9, 0xf7, 0xb2, 0x91, 0xff, 0xc9, 0xc6, 0x1c, 0xb5, 0x3c, 0x71, 0x34, 0x1a, 0x73,
	0x74, 0xb8, 0x73, 0x34, 0x1a, 0xf3, 0xcd, 0xdc, 0x6d, 0xd3, 0xd1, 0x6c, 0xb6, 0x3c, 0xd1, 0x6c,
	0x8e, 0x46, 0x35, 0x9b, 0x87, 0x3b, 0xcd, 0xe6, 0x68, 0x5c, 0xff, 0xa2, 0x0e, 0xf6, 0xc1, 0xb7,
	0x01, 0x00, 0x00, 0xff, 0xff, 0x6d, 0xc0, 0x26, 0xea, 0x1b, 0x19, 0x00, 0x00,
}
