package apimdeployment

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 1.0.1.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"net/http"
)

// HostnameType enumerates the values for hostname type.
type HostnameType string

const (
	// Management specifies the management state for hostname type.
	Management HostnameType = "Management"
	// Portal specifies the portal state for hostname type.
	Portal HostnameType = "Portal"
	// Proxy specifies the proxy state for hostname type.
	Proxy HostnameType = "Proxy"
	// Scm specifies the scm state for hostname type.
	Scm HostnameType = "Scm"
)

// NameAvailabilityReason enumerates the values for name availability reason.
type NameAvailabilityReason string

const (
	// AlreadyExists specifies the already exists state for name availability
	// reason.
	AlreadyExists NameAvailabilityReason = "AlreadyExists"
	// Invalid specifies the invalid state for name availability reason.
	Invalid NameAvailabilityReason = "Invalid"
	// Valid specifies the valid state for name availability reason.
	Valid NameAvailabilityReason = "Valid"
)

// SkuType enumerates the values for sku type.
type SkuType string

const (
	// Developer specifies the developer state for sku type.
	Developer SkuType = "Developer"
	// Premium specifies the premium state for sku type.
	Premium SkuType = "Premium"
	// Standard specifies the standard state for sku type.
	Standard SkuType = "Standard"
)

// VirtualNetworkType enumerates the values for virtual network type.
type VirtualNetworkType string

const (
	// External specifies the external state for virtual network type.
	External VirtualNetworkType = "External"
	// Internal specifies the internal state for virtual network type.
	Internal VirtualNetworkType = "Internal"
	// None specifies the none state for virtual network type.
	None VirtualNetworkType = "None"
)

// AdditionalRegion is description of an additional API Management resource
// location.
type AdditionalRegion struct {
	Location         *string                      `json:"location,omitempty"`
	SkuType          SkuType                      `json:"skuType,omitempty"`
	SkuUnitCount     *int32                       `json:"skuUnitCount,omitempty"`
	StaticIPs        *[]string                    `json:"staticIPs,omitempty"`
	Vpnconfiguration *VirtualNetworkConfiguration `json:"vpnconfiguration,omitempty"`
}

// APIManagementServiceBackupRestoreParameters is parameters supplied to the
// Backup/Restore of an API Management service operation.
type APIManagementServiceBackupRestoreParameters struct {
	StorageAccount *string `json:"storageAccount,omitempty"`
	AccessKey      *string `json:"accessKey,omitempty"`
	ContainerName  *string `json:"containerName,omitempty"`
	BackupName     *string `json:"backupName,omitempty"`
}

// APIManagementServiceBaseParameters is parameters supplied to the Update API
// Management service operation.
type APIManagementServiceBaseParameters struct {
	Tags                            *map[string]*string `json:"tags,omitempty"`
	*APIManagementServiceProperties `json:"properties,omitempty"`
	Sku                             *APIManagementServiceSkuProperties `json:"sku,omitempty"`
}

// APIManagementServiceCheckNameAvailabilityParameters is parameters supplied
// to the CheckNameAvailability operation.
type APIManagementServiceCheckNameAvailabilityParameters struct {
	Name *string `json:"name,omitempty"`
}

// APIManagementServiceGetSsoTokenResult is the response of the GetSsoToken
// operation.
type APIManagementServiceGetSsoTokenResult struct {
	autorest.Response `json:"-"`
	RedirectURI       *string `json:"redirect_uri,omitempty"`
}

// APIManagementServiceListResult is the response of the List API Management
// services operation.
type APIManagementServiceListResult struct {
	autorest.Response `json:"-"`
	Value             *[]APIManagementServiceResource `json:"value,omitempty"`
	NextLink          *string                         `json:"nextLink,omitempty"`
}

// APIManagementServiceListResultPreparer prepares a request to retrieve the next set of results. It returns
// nil if no more results exist.
func (client APIManagementServiceListResult) APIManagementServiceListResultPreparer() (*http.Request, error) {
	if client.NextLink == nil || len(to.String(client.NextLink)) <= 0 {
		return nil, nil
	}
	return autorest.Prepare(&http.Request{},
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(client.NextLink)))
}

// APIManagementServiceManageDeploymentsParameters is parameters supplied to
// the ManageDeployments operation.
type APIManagementServiceManageDeploymentsParameters struct {
	Location            *string                      `json:"location,omitempty"`
	SkuType             SkuType                      `json:"skuType,omitempty"`
	SkuUnitCount        *int32                       `json:"skuUnitCount,omitempty"`
	AdditionalLocations *[]AdditionalRegion          `json:"additionalLocations,omitempty"`
	VpnConfiguration    *VirtualNetworkConfiguration `json:"vpnConfiguration,omitempty"`
	VpnType             VirtualNetworkType           `json:"vpnType,omitempty"`
}

// APIManagementServiceNameAvailabilityResult is response of the
// CheckNameAvailability operation.
type APIManagementServiceNameAvailabilityResult struct {
	autorest.Response `json:"-"`
	NameAvailable     *bool                  `json:"nameAvailable,omitempty"`
	Message           *string                `json:"message,omitempty"`
	Reason            NameAvailabilityReason `json:"reason,omitempty"`
}

// APIManagementServiceProperties is properties of an API Management service
// resource description.
type APIManagementServiceProperties struct {
	PublisherEmail          *string                      `json:"publisherEmail,omitempty"`
	PublisherName           *string                      `json:"publisherName,omitempty"`
	ProvisioningState       *string                      `json:"provisioningState,omitempty"`
	TargetProvisioningState *string                      `json:"targetProvisioningState,omitempty"`
	CreatedAtUtc            *date.Time                   `json:"createdAtUtc,omitempty"`
	RuntimeURL              *string                      `json:"runtimeUrl,omitempty"`
	PortalURL               *string                      `json:"portalUrl,omitempty"`
	ManagementAPIURL        *string                      `json:"managementApiUrl,omitempty"`
	ScmURL                  *string                      `json:"scmUrl,omitempty"`
	AddresserEmail          *string                      `json:"addresserEmail,omitempty"`
	HostnameConfigurations  *[]HostnameConfiguration     `json:"hostnameConfigurations,omitempty"`
	StaticIPs               *[]string                    `json:"staticIPs,omitempty"`
	Vpnconfiguration        *VirtualNetworkConfiguration `json:"vpnconfiguration,omitempty"`
	AdditionalLocations     *[]AdditionalRegion          `json:"additionalLocations,omitempty"`
	CustomProperties        *map[string]*string          `json:"customProperties,omitempty"`
	VpnType                 VirtualNetworkType           `json:"vpnType,omitempty"`
}

// APIManagementServiceResource is description of an API Management service
// resource.
type APIManagementServiceResource struct {
	autorest.Response               `json:"-"`
	Tags                            *map[string]*string `json:"tags,omitempty"`
	*APIManagementServiceProperties `json:"properties,omitempty"`
	Sku                             *APIManagementServiceSkuProperties `json:"sku,omitempty"`
	ID                              *string                            `json:"id,omitempty"`
	Location                        *string                            `json:"location,omitempty"`
	Name                            *string                            `json:"name,omitempty"`
	Type                            *string                            `json:"type,omitempty"`
	Etag                            *string                            `json:"etag,omitempty"`
}

// APIManagementServiceSkuProperties is aPI Management service resource SKU
// properties.
type APIManagementServiceSkuProperties struct {
	Name     SkuType `json:"name,omitempty"`
	Capacity *int32  `json:"capacity,omitempty"`
}

// APIManagementServiceUpdateHostnameParameters is parameters supplied to the
// UpdateHostname operation.
type APIManagementServiceUpdateHostnameParameters struct {
	Update *[]HostnameConfiguration `json:"update,omitempty"`
	Delete *[]HostnameType          `json:"delete,omitempty"`
}

// APIManagementServiceUploadCertificateParameters is parameters supplied to
// the Upload SSL certificate for an API Management service operation.
type APIManagementServiceUploadCertificateParameters struct {
	Type                HostnameType `json:"type,omitempty"`
	Certificate         *string      `json:"certificate,omitempty"`
	CertificatePassword *string      `json:"certificate_password,omitempty"`
}

// CertificateInformation is sSL certificate information.
type CertificateInformation struct {
	autorest.Response `json:"-"`
	Expiry            *date.Time `json:"expiry,omitempty"`
	Thumbprint        *string    `json:"thumbprint,omitempty"`
	Subject           *string    `json:"subject,omitempty"`
}

// ErrorResponse is error Response.
type ErrorResponse struct {
	autorest.Response `json:"-"`
	Code              *string `json:"code,omitempty"`
	Message           *string `json:"message,omitempty"`
}

// HostnameConfiguration is custom hostname configuration.
type HostnameConfiguration struct {
	Type        HostnameType            `json:"type,omitempty"`
	Hostname    *string                 `json:"hostname,omitempty"`
	Certificate *CertificateInformation `json:"certificate,omitempty"`
}

// SetObject is
type SetObject struct {
	autorest.Response `json:"-"`
	Value             *map[string]interface{} `json:"value,omitempty"`
}

// VirtualNetworkConfiguration is configuration of a virtual network to which
// API Management service is deployed.
type VirtualNetworkConfiguration struct {
	Vnetid           *string `json:"vnetid,omitempty"`
	Subnetname       *string `json:"subnetname,omitempty"`
	SubnetResourceID *string `json:"subnetResourceId,omitempty"`
	Location         *string `json:"location,omitempty"`
}
