// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package lexmodelsv2iface provides an interface to enable mocking the Amazon Lex Model Building V2 service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package lexmodelsv2iface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/lexmodelsv2"
)

// LexModelsV2API provides an interface to enable mocking the
// lexmodelsv2.LexModelsV2 service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon Lex Model Building V2.
//    func myFunc(svc lexmodelsv2iface.LexModelsV2API) bool {
//        // Make svc.BuildBotLocale request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := lexmodelsv2.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockLexModelsV2Client struct {
//        lexmodelsv2iface.LexModelsV2API
//    }
//    func (m *mockLexModelsV2Client) BuildBotLocale(input *lexmodelsv2.BuildBotLocaleInput) (*lexmodelsv2.BuildBotLocaleOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockLexModelsV2Client{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type LexModelsV2API interface {
	BuildBotLocale(*lexmodelsv2.BuildBotLocaleInput) (*lexmodelsv2.BuildBotLocaleOutput, error)
	BuildBotLocaleWithContext(aws.Context, *lexmodelsv2.BuildBotLocaleInput, ...request.Option) (*lexmodelsv2.BuildBotLocaleOutput, error)
	BuildBotLocaleRequest(*lexmodelsv2.BuildBotLocaleInput) (*request.Request, *lexmodelsv2.BuildBotLocaleOutput)

	CreateBot(*lexmodelsv2.CreateBotInput) (*lexmodelsv2.CreateBotOutput, error)
	CreateBotWithContext(aws.Context, *lexmodelsv2.CreateBotInput, ...request.Option) (*lexmodelsv2.CreateBotOutput, error)
	CreateBotRequest(*lexmodelsv2.CreateBotInput) (*request.Request, *lexmodelsv2.CreateBotOutput)

	CreateBotAlias(*lexmodelsv2.CreateBotAliasInput) (*lexmodelsv2.CreateBotAliasOutput, error)
	CreateBotAliasWithContext(aws.Context, *lexmodelsv2.CreateBotAliasInput, ...request.Option) (*lexmodelsv2.CreateBotAliasOutput, error)
	CreateBotAliasRequest(*lexmodelsv2.CreateBotAliasInput) (*request.Request, *lexmodelsv2.CreateBotAliasOutput)

	CreateBotLocale(*lexmodelsv2.CreateBotLocaleInput) (*lexmodelsv2.CreateBotLocaleOutput, error)
	CreateBotLocaleWithContext(aws.Context, *lexmodelsv2.CreateBotLocaleInput, ...request.Option) (*lexmodelsv2.CreateBotLocaleOutput, error)
	CreateBotLocaleRequest(*lexmodelsv2.CreateBotLocaleInput) (*request.Request, *lexmodelsv2.CreateBotLocaleOutput)

	CreateBotVersion(*lexmodelsv2.CreateBotVersionInput) (*lexmodelsv2.CreateBotVersionOutput, error)
	CreateBotVersionWithContext(aws.Context, *lexmodelsv2.CreateBotVersionInput, ...request.Option) (*lexmodelsv2.CreateBotVersionOutput, error)
	CreateBotVersionRequest(*lexmodelsv2.CreateBotVersionInput) (*request.Request, *lexmodelsv2.CreateBotVersionOutput)

	CreateIntent(*lexmodelsv2.CreateIntentInput) (*lexmodelsv2.CreateIntentOutput, error)
	CreateIntentWithContext(aws.Context, *lexmodelsv2.CreateIntentInput, ...request.Option) (*lexmodelsv2.CreateIntentOutput, error)
	CreateIntentRequest(*lexmodelsv2.CreateIntentInput) (*request.Request, *lexmodelsv2.CreateIntentOutput)

	CreateSlot(*lexmodelsv2.CreateSlotInput) (*lexmodelsv2.CreateSlotOutput, error)
	CreateSlotWithContext(aws.Context, *lexmodelsv2.CreateSlotInput, ...request.Option) (*lexmodelsv2.CreateSlotOutput, error)
	CreateSlotRequest(*lexmodelsv2.CreateSlotInput) (*request.Request, *lexmodelsv2.CreateSlotOutput)

	CreateSlotType(*lexmodelsv2.CreateSlotTypeInput) (*lexmodelsv2.CreateSlotTypeOutput, error)
	CreateSlotTypeWithContext(aws.Context, *lexmodelsv2.CreateSlotTypeInput, ...request.Option) (*lexmodelsv2.CreateSlotTypeOutput, error)
	CreateSlotTypeRequest(*lexmodelsv2.CreateSlotTypeInput) (*request.Request, *lexmodelsv2.CreateSlotTypeOutput)

	DeleteBot(*lexmodelsv2.DeleteBotInput) (*lexmodelsv2.DeleteBotOutput, error)
	DeleteBotWithContext(aws.Context, *lexmodelsv2.DeleteBotInput, ...request.Option) (*lexmodelsv2.DeleteBotOutput, error)
	DeleteBotRequest(*lexmodelsv2.DeleteBotInput) (*request.Request, *lexmodelsv2.DeleteBotOutput)

	DeleteBotAlias(*lexmodelsv2.DeleteBotAliasInput) (*lexmodelsv2.DeleteBotAliasOutput, error)
	DeleteBotAliasWithContext(aws.Context, *lexmodelsv2.DeleteBotAliasInput, ...request.Option) (*lexmodelsv2.DeleteBotAliasOutput, error)
	DeleteBotAliasRequest(*lexmodelsv2.DeleteBotAliasInput) (*request.Request, *lexmodelsv2.DeleteBotAliasOutput)

	DeleteBotLocale(*lexmodelsv2.DeleteBotLocaleInput) (*lexmodelsv2.DeleteBotLocaleOutput, error)
	DeleteBotLocaleWithContext(aws.Context, *lexmodelsv2.DeleteBotLocaleInput, ...request.Option) (*lexmodelsv2.DeleteBotLocaleOutput, error)
	DeleteBotLocaleRequest(*lexmodelsv2.DeleteBotLocaleInput) (*request.Request, *lexmodelsv2.DeleteBotLocaleOutput)

	DeleteBotVersion(*lexmodelsv2.DeleteBotVersionInput) (*lexmodelsv2.DeleteBotVersionOutput, error)
	DeleteBotVersionWithContext(aws.Context, *lexmodelsv2.DeleteBotVersionInput, ...request.Option) (*lexmodelsv2.DeleteBotVersionOutput, error)
	DeleteBotVersionRequest(*lexmodelsv2.DeleteBotVersionInput) (*request.Request, *lexmodelsv2.DeleteBotVersionOutput)

	DeleteIntent(*lexmodelsv2.DeleteIntentInput) (*lexmodelsv2.DeleteIntentOutput, error)
	DeleteIntentWithContext(aws.Context, *lexmodelsv2.DeleteIntentInput, ...request.Option) (*lexmodelsv2.DeleteIntentOutput, error)
	DeleteIntentRequest(*lexmodelsv2.DeleteIntentInput) (*request.Request, *lexmodelsv2.DeleteIntentOutput)

	DeleteSlot(*lexmodelsv2.DeleteSlotInput) (*lexmodelsv2.DeleteSlotOutput, error)
	DeleteSlotWithContext(aws.Context, *lexmodelsv2.DeleteSlotInput, ...request.Option) (*lexmodelsv2.DeleteSlotOutput, error)
	DeleteSlotRequest(*lexmodelsv2.DeleteSlotInput) (*request.Request, *lexmodelsv2.DeleteSlotOutput)

	DeleteSlotType(*lexmodelsv2.DeleteSlotTypeInput) (*lexmodelsv2.DeleteSlotTypeOutput, error)
	DeleteSlotTypeWithContext(aws.Context, *lexmodelsv2.DeleteSlotTypeInput, ...request.Option) (*lexmodelsv2.DeleteSlotTypeOutput, error)
	DeleteSlotTypeRequest(*lexmodelsv2.DeleteSlotTypeInput) (*request.Request, *lexmodelsv2.DeleteSlotTypeOutput)

	DescribeBot(*lexmodelsv2.DescribeBotInput) (*lexmodelsv2.DescribeBotOutput, error)
	DescribeBotWithContext(aws.Context, *lexmodelsv2.DescribeBotInput, ...request.Option) (*lexmodelsv2.DescribeBotOutput, error)
	DescribeBotRequest(*lexmodelsv2.DescribeBotInput) (*request.Request, *lexmodelsv2.DescribeBotOutput)

	DescribeBotAlias(*lexmodelsv2.DescribeBotAliasInput) (*lexmodelsv2.DescribeBotAliasOutput, error)
	DescribeBotAliasWithContext(aws.Context, *lexmodelsv2.DescribeBotAliasInput, ...request.Option) (*lexmodelsv2.DescribeBotAliasOutput, error)
	DescribeBotAliasRequest(*lexmodelsv2.DescribeBotAliasInput) (*request.Request, *lexmodelsv2.DescribeBotAliasOutput)

	DescribeBotLocale(*lexmodelsv2.DescribeBotLocaleInput) (*lexmodelsv2.DescribeBotLocaleOutput, error)
	DescribeBotLocaleWithContext(aws.Context, *lexmodelsv2.DescribeBotLocaleInput, ...request.Option) (*lexmodelsv2.DescribeBotLocaleOutput, error)
	DescribeBotLocaleRequest(*lexmodelsv2.DescribeBotLocaleInput) (*request.Request, *lexmodelsv2.DescribeBotLocaleOutput)

	DescribeBotVersion(*lexmodelsv2.DescribeBotVersionInput) (*lexmodelsv2.DescribeBotVersionOutput, error)
	DescribeBotVersionWithContext(aws.Context, *lexmodelsv2.DescribeBotVersionInput, ...request.Option) (*lexmodelsv2.DescribeBotVersionOutput, error)
	DescribeBotVersionRequest(*lexmodelsv2.DescribeBotVersionInput) (*request.Request, *lexmodelsv2.DescribeBotVersionOutput)

	DescribeIntent(*lexmodelsv2.DescribeIntentInput) (*lexmodelsv2.DescribeIntentOutput, error)
	DescribeIntentWithContext(aws.Context, *lexmodelsv2.DescribeIntentInput, ...request.Option) (*lexmodelsv2.DescribeIntentOutput, error)
	DescribeIntentRequest(*lexmodelsv2.DescribeIntentInput) (*request.Request, *lexmodelsv2.DescribeIntentOutput)

	DescribeSlot(*lexmodelsv2.DescribeSlotInput) (*lexmodelsv2.DescribeSlotOutput, error)
	DescribeSlotWithContext(aws.Context, *lexmodelsv2.DescribeSlotInput, ...request.Option) (*lexmodelsv2.DescribeSlotOutput, error)
	DescribeSlotRequest(*lexmodelsv2.DescribeSlotInput) (*request.Request, *lexmodelsv2.DescribeSlotOutput)

	DescribeSlotType(*lexmodelsv2.DescribeSlotTypeInput) (*lexmodelsv2.DescribeSlotTypeOutput, error)
	DescribeSlotTypeWithContext(aws.Context, *lexmodelsv2.DescribeSlotTypeInput, ...request.Option) (*lexmodelsv2.DescribeSlotTypeOutput, error)
	DescribeSlotTypeRequest(*lexmodelsv2.DescribeSlotTypeInput) (*request.Request, *lexmodelsv2.DescribeSlotTypeOutput)

	ListBotAliases(*lexmodelsv2.ListBotAliasesInput) (*lexmodelsv2.ListBotAliasesOutput, error)
	ListBotAliasesWithContext(aws.Context, *lexmodelsv2.ListBotAliasesInput, ...request.Option) (*lexmodelsv2.ListBotAliasesOutput, error)
	ListBotAliasesRequest(*lexmodelsv2.ListBotAliasesInput) (*request.Request, *lexmodelsv2.ListBotAliasesOutput)

	ListBotAliasesPages(*lexmodelsv2.ListBotAliasesInput, func(*lexmodelsv2.ListBotAliasesOutput, bool) bool) error
	ListBotAliasesPagesWithContext(aws.Context, *lexmodelsv2.ListBotAliasesInput, func(*lexmodelsv2.ListBotAliasesOutput, bool) bool, ...request.Option) error

	ListBotLocales(*lexmodelsv2.ListBotLocalesInput) (*lexmodelsv2.ListBotLocalesOutput, error)
	ListBotLocalesWithContext(aws.Context, *lexmodelsv2.ListBotLocalesInput, ...request.Option) (*lexmodelsv2.ListBotLocalesOutput, error)
	ListBotLocalesRequest(*lexmodelsv2.ListBotLocalesInput) (*request.Request, *lexmodelsv2.ListBotLocalesOutput)

	ListBotLocalesPages(*lexmodelsv2.ListBotLocalesInput, func(*lexmodelsv2.ListBotLocalesOutput, bool) bool) error
	ListBotLocalesPagesWithContext(aws.Context, *lexmodelsv2.ListBotLocalesInput, func(*lexmodelsv2.ListBotLocalesOutput, bool) bool, ...request.Option) error

	ListBotVersions(*lexmodelsv2.ListBotVersionsInput) (*lexmodelsv2.ListBotVersionsOutput, error)
	ListBotVersionsWithContext(aws.Context, *lexmodelsv2.ListBotVersionsInput, ...request.Option) (*lexmodelsv2.ListBotVersionsOutput, error)
	ListBotVersionsRequest(*lexmodelsv2.ListBotVersionsInput) (*request.Request, *lexmodelsv2.ListBotVersionsOutput)

	ListBotVersionsPages(*lexmodelsv2.ListBotVersionsInput, func(*lexmodelsv2.ListBotVersionsOutput, bool) bool) error
	ListBotVersionsPagesWithContext(aws.Context, *lexmodelsv2.ListBotVersionsInput, func(*lexmodelsv2.ListBotVersionsOutput, bool) bool, ...request.Option) error

	ListBots(*lexmodelsv2.ListBotsInput) (*lexmodelsv2.ListBotsOutput, error)
	ListBotsWithContext(aws.Context, *lexmodelsv2.ListBotsInput, ...request.Option) (*lexmodelsv2.ListBotsOutput, error)
	ListBotsRequest(*lexmodelsv2.ListBotsInput) (*request.Request, *lexmodelsv2.ListBotsOutput)

	ListBotsPages(*lexmodelsv2.ListBotsInput, func(*lexmodelsv2.ListBotsOutput, bool) bool) error
	ListBotsPagesWithContext(aws.Context, *lexmodelsv2.ListBotsInput, func(*lexmodelsv2.ListBotsOutput, bool) bool, ...request.Option) error

	ListBuiltInIntents(*lexmodelsv2.ListBuiltInIntentsInput) (*lexmodelsv2.ListBuiltInIntentsOutput, error)
	ListBuiltInIntentsWithContext(aws.Context, *lexmodelsv2.ListBuiltInIntentsInput, ...request.Option) (*lexmodelsv2.ListBuiltInIntentsOutput, error)
	ListBuiltInIntentsRequest(*lexmodelsv2.ListBuiltInIntentsInput) (*request.Request, *lexmodelsv2.ListBuiltInIntentsOutput)

	ListBuiltInIntentsPages(*lexmodelsv2.ListBuiltInIntentsInput, func(*lexmodelsv2.ListBuiltInIntentsOutput, bool) bool) error
	ListBuiltInIntentsPagesWithContext(aws.Context, *lexmodelsv2.ListBuiltInIntentsInput, func(*lexmodelsv2.ListBuiltInIntentsOutput, bool) bool, ...request.Option) error

	ListBuiltInSlotTypes(*lexmodelsv2.ListBuiltInSlotTypesInput) (*lexmodelsv2.ListBuiltInSlotTypesOutput, error)
	ListBuiltInSlotTypesWithContext(aws.Context, *lexmodelsv2.ListBuiltInSlotTypesInput, ...request.Option) (*lexmodelsv2.ListBuiltInSlotTypesOutput, error)
	ListBuiltInSlotTypesRequest(*lexmodelsv2.ListBuiltInSlotTypesInput) (*request.Request, *lexmodelsv2.ListBuiltInSlotTypesOutput)

	ListBuiltInSlotTypesPages(*lexmodelsv2.ListBuiltInSlotTypesInput, func(*lexmodelsv2.ListBuiltInSlotTypesOutput, bool) bool) error
	ListBuiltInSlotTypesPagesWithContext(aws.Context, *lexmodelsv2.ListBuiltInSlotTypesInput, func(*lexmodelsv2.ListBuiltInSlotTypesOutput, bool) bool, ...request.Option) error

	ListIntents(*lexmodelsv2.ListIntentsInput) (*lexmodelsv2.ListIntentsOutput, error)
	ListIntentsWithContext(aws.Context, *lexmodelsv2.ListIntentsInput, ...request.Option) (*lexmodelsv2.ListIntentsOutput, error)
	ListIntentsRequest(*lexmodelsv2.ListIntentsInput) (*request.Request, *lexmodelsv2.ListIntentsOutput)

	ListIntentsPages(*lexmodelsv2.ListIntentsInput, func(*lexmodelsv2.ListIntentsOutput, bool) bool) error
	ListIntentsPagesWithContext(aws.Context, *lexmodelsv2.ListIntentsInput, func(*lexmodelsv2.ListIntentsOutput, bool) bool, ...request.Option) error

	ListSlotTypes(*lexmodelsv2.ListSlotTypesInput) (*lexmodelsv2.ListSlotTypesOutput, error)
	ListSlotTypesWithContext(aws.Context, *lexmodelsv2.ListSlotTypesInput, ...request.Option) (*lexmodelsv2.ListSlotTypesOutput, error)
	ListSlotTypesRequest(*lexmodelsv2.ListSlotTypesInput) (*request.Request, *lexmodelsv2.ListSlotTypesOutput)

	ListSlotTypesPages(*lexmodelsv2.ListSlotTypesInput, func(*lexmodelsv2.ListSlotTypesOutput, bool) bool) error
	ListSlotTypesPagesWithContext(aws.Context, *lexmodelsv2.ListSlotTypesInput, func(*lexmodelsv2.ListSlotTypesOutput, bool) bool, ...request.Option) error

	ListSlots(*lexmodelsv2.ListSlotsInput) (*lexmodelsv2.ListSlotsOutput, error)
	ListSlotsWithContext(aws.Context, *lexmodelsv2.ListSlotsInput, ...request.Option) (*lexmodelsv2.ListSlotsOutput, error)
	ListSlotsRequest(*lexmodelsv2.ListSlotsInput) (*request.Request, *lexmodelsv2.ListSlotsOutput)

	ListSlotsPages(*lexmodelsv2.ListSlotsInput, func(*lexmodelsv2.ListSlotsOutput, bool) bool) error
	ListSlotsPagesWithContext(aws.Context, *lexmodelsv2.ListSlotsInput, func(*lexmodelsv2.ListSlotsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*lexmodelsv2.ListTagsForResourceInput) (*lexmodelsv2.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *lexmodelsv2.ListTagsForResourceInput, ...request.Option) (*lexmodelsv2.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*lexmodelsv2.ListTagsForResourceInput) (*request.Request, *lexmodelsv2.ListTagsForResourceOutput)

	TagResource(*lexmodelsv2.TagResourceInput) (*lexmodelsv2.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *lexmodelsv2.TagResourceInput, ...request.Option) (*lexmodelsv2.TagResourceOutput, error)
	TagResourceRequest(*lexmodelsv2.TagResourceInput) (*request.Request, *lexmodelsv2.TagResourceOutput)

	UntagResource(*lexmodelsv2.UntagResourceInput) (*lexmodelsv2.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *lexmodelsv2.UntagResourceInput, ...request.Option) (*lexmodelsv2.UntagResourceOutput, error)
	UntagResourceRequest(*lexmodelsv2.UntagResourceInput) (*request.Request, *lexmodelsv2.UntagResourceOutput)

	UpdateBot(*lexmodelsv2.UpdateBotInput) (*lexmodelsv2.UpdateBotOutput, error)
	UpdateBotWithContext(aws.Context, *lexmodelsv2.UpdateBotInput, ...request.Option) (*lexmodelsv2.UpdateBotOutput, error)
	UpdateBotRequest(*lexmodelsv2.UpdateBotInput) (*request.Request, *lexmodelsv2.UpdateBotOutput)

	UpdateBotAlias(*lexmodelsv2.UpdateBotAliasInput) (*lexmodelsv2.UpdateBotAliasOutput, error)
	UpdateBotAliasWithContext(aws.Context, *lexmodelsv2.UpdateBotAliasInput, ...request.Option) (*lexmodelsv2.UpdateBotAliasOutput, error)
	UpdateBotAliasRequest(*lexmodelsv2.UpdateBotAliasInput) (*request.Request, *lexmodelsv2.UpdateBotAliasOutput)

	UpdateBotLocale(*lexmodelsv2.UpdateBotLocaleInput) (*lexmodelsv2.UpdateBotLocaleOutput, error)
	UpdateBotLocaleWithContext(aws.Context, *lexmodelsv2.UpdateBotLocaleInput, ...request.Option) (*lexmodelsv2.UpdateBotLocaleOutput, error)
	UpdateBotLocaleRequest(*lexmodelsv2.UpdateBotLocaleInput) (*request.Request, *lexmodelsv2.UpdateBotLocaleOutput)

	UpdateIntent(*lexmodelsv2.UpdateIntentInput) (*lexmodelsv2.UpdateIntentOutput, error)
	UpdateIntentWithContext(aws.Context, *lexmodelsv2.UpdateIntentInput, ...request.Option) (*lexmodelsv2.UpdateIntentOutput, error)
	UpdateIntentRequest(*lexmodelsv2.UpdateIntentInput) (*request.Request, *lexmodelsv2.UpdateIntentOutput)

	UpdateSlot(*lexmodelsv2.UpdateSlotInput) (*lexmodelsv2.UpdateSlotOutput, error)
	UpdateSlotWithContext(aws.Context, *lexmodelsv2.UpdateSlotInput, ...request.Option) (*lexmodelsv2.UpdateSlotOutput, error)
	UpdateSlotRequest(*lexmodelsv2.UpdateSlotInput) (*request.Request, *lexmodelsv2.UpdateSlotOutput)

	UpdateSlotType(*lexmodelsv2.UpdateSlotTypeInput) (*lexmodelsv2.UpdateSlotTypeOutput, error)
	UpdateSlotTypeWithContext(aws.Context, *lexmodelsv2.UpdateSlotTypeInput, ...request.Option) (*lexmodelsv2.UpdateSlotTypeOutput, error)
	UpdateSlotTypeRequest(*lexmodelsv2.UpdateSlotTypeInput) (*request.Request, *lexmodelsv2.UpdateSlotTypeOutput)
}

var _ LexModelsV2API = (*lexmodelsv2.LexModelsV2)(nil)
