/* -*- Mode: C++; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "xrandr-adaptor.h"
#include <QtCore/QMetaObject>
#include <QtCore/QByteArray>
#include <QtCore/QList>
#include <QtCore/QMap>
#include <QtCore/QString>
#include <QtCore/QStringList>
#include <QtCore/QVariant>
#include "clib-syslog.h"
/*
 * Implementation of adaptor class WaylandAdaptor
 */

XrandrAdaptor::XrandrAdaptor(QObject *parent)
    : QDBusAbstractAdaptor(parent)
{
    // constructor
    setAutoRelaySignals(true);
}

XrandrAdaptor::~XrandrAdaptor()
{
    // destructor
}

int XrandrAdaptor::setScreensParam(const QString &screensParam, const QString &appName){
    int out0;
    USD_LOG(LOG_DEBUG," appName:%s", appName.toLatin1().data());
    QMetaObject::invokeMethod(parent(), "setScreensParam", Q_RETURN_ARG(int, out0),  Q_ARG(QString, screensParam),  Q_ARG(QString, appName));
    return out0;
}

QString XrandrAdaptor::getScreensParam( const QString &appName){
    QString out0;
    USD_LOG(LOG_DEBUG," appName:%s", appName.toLatin1().data());
    QMetaObject::invokeMethod(parent(), "getScreensParam", Q_RETURN_ARG(QString, out0),  Q_ARG(QString, appName));
    return out0;
}

int XrandrAdaptor::setScreenMode(const QString &modeName, const QString &appName){
    int out0;
    USD_LOG(LOG_DEBUG,"change screen :%s, appName:%s",modeName.toLatin1().data(), appName.toLatin1().data());
    QMetaObject::invokeMethod(parent(), "setScreenMode", Q_RETURN_ARG(int, out0),  Q_ARG(QString, modeName),  Q_ARG(QString, appName));
    return out0;
}

int XrandrAdaptor::getScreenMode(const QString &appName){
    int out0;
    USD_LOG(LOG_DEBUG,"get screen mode request from appName:%s", appName.toLatin1().data());
    QMetaObject::invokeMethod(parent(), "getScreenMode", Q_RETURN_ARG(int, out0),  Q_ARG(QString, appName));
    return out0;
}

