% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sass.R
\name{output_template}
\alias{output_template}
\title{An intelligent (temporary) output file}
\usage{
output_template(basename = "sass", dirname = basename, fileext = NULL)
}
\arguments{
\item{basename}{a non-empty character vector giving the outfile name (without
the extension).}

\item{dirname}{a non-empty character vector giving the initial part of the
directory name.}

\item{fileext}{the output file extension. The default is \code{".min.css"} for
compressed and compact output styles; otherwise, its \code{".css"}.}
}
\value{
A function with two arguments: \code{options} and \code{suffix}. When called inside
\code{\link[=sass]{sass()}} with caching enabled, the caching key is supplied to \code{suffix}.
}
\description{
Intended for use with \code{\link[=sass]{sass()}}'s \code{output} argument for temporary file
generation that is \code{cache} and \code{options} aware. In particular, this ensures
that new redundant file(s) aren't generated on a \code{\link[=sass]{sass()}} cache hit, and that
the file's extension is suitable for the \code{\link[=sass_options]{sass_options()}}'s \code{output_style}.
}
\examples{
sass("body {color: red}", output = output_template())

func <- output_template(basename = "foo", dirname = "bar-")
func(suffix = "baz")

}
