% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/components.R
\name{is_biconnected}
\alias{is_biconnected}
\title{Check biconnectedness}
\usage{
is_biconnected(graph)
}
\arguments{
\item{graph}{The input graph. Edge directions are ignored.}
}
\value{
Logical, \code{TRUE} if the graph is biconnected.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Tests whether a graph is biconnected.
}
\details{
A graph is biconnected if the removal of any single vertex (and its adjacent
edges) does not disconnect it.

igraph does not consider single-vertex graphs biconnected.

Note that some authors do not consider the graph consisting of
two connected vertices as biconnected, however, igraph does.
}
\examples{
is_biconnected(make_graph("bull"))
is_biconnected(make_graph("dodecahedron"))
is_biconnected(make_full_graph(1))
is_biconnected(make_full_graph(2))
}
\seealso{
\code{\link[=articulation_points]{articulation_points()}}, \code{\link[=biconnected_components]{biconnected_components()}},
\code{\link[=is_connected]{is_connected()}}, \code{\link[=vertex_connectivity]{vertex_connectivity()}}

Connected components
\code{\link{articulation_points}()},
\code{\link{biconnected_components}()},
\code{\link{component_distribution}()},
\code{\link{decompose}()}
}
\concept{components}
\keyword{graphs}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/0.10.17/igraph-Structural.html#igraph_is_biconnected}{\code{is_biconnected()}}.}

