% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmTMB.R
\name{getXReTrms}
\alias{getXReTrms}
\title{Create X and random effect terms from formula}
\usage{
getXReTrms(
  formula,
  mf,
  fr,
  ranOK = TRUE,
  type = "",
  contrasts,
  sparse = FALSE,
  old_smooths = NULL
)
}
\arguments{
\item{formula}{current formula, containing both fixed & random effects}

\item{mf}{matched call}

\item{fr}{full model frame}

\item{ranOK}{random effects allowed here?}

\item{type}{label for model type}

\item{contrasts}{a list of contrasts (see ?glmmTMB)}

\item{sparse}{(logical) return sparse model matrix?}

\item{old_smooths}{smooth information from a prior model fit (for prediction)}
}
\value{
a list composed of
\item{X}{design matrix for fixed effects}
\item{Z}{design matrix for random effects}
\item{reTrms}{output from \code{\link[reformulas]{mkReTrms}}, possibly augmented with information about \code{mgcv}-style smooth terms}
\item{ss}{splitform of the formula}
\item{aa}{additional arguments, used to obtain rank}
\item{terms}{terms for the fixed effects}
\item{offset}{offset vector, or vector of zeros if offset not specified}
\item{reXterms}{terms for the model matrix in each RE term}
}
\description{
Create X and random effect terms from formula
}
