% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_f.R
\name{dist_f}
\alias{dist_f}
\title{The F Distribution}
\usage{
dist_f(df1, df2, ncp = NULL)
}
\arguments{
\item{df1}{Degrees of freedom for the numerator. Can be any positive number.}

\item{df2}{Degrees of freedom for the denominator. Can be any positive number.}

\item{ncp}{Non-centrality parameter. If \code{NULL} (default), the central F
distribution is used. If specified, must be non-negative.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

The F distribution is commonly used in statistical inference, particularly
in the analysis of variance (ANOVA), testing the equality of variances,
and in regression analysis. It arises as the ratio of two scaled
chi-squared distributions divided by their respective degrees of freedom.
}
\details{
We recommend reading this documentation on \href{https://pkg.mitchelloharawild.com/distributional/reference/dist_f.html}{pkgdown} which renders math nicely.
\url{https://pkg.mitchelloharawild.com/distributional/reference/dist_f.html}

In the following, let \eqn{X} be an F random variable with numerator
degrees of freedom \code{df1} = \eqn{d_1} and denominator degrees of freedom
\code{df2} = \eqn{d_2}.

\strong{Support}: \eqn{x \in (0, \infty)}

\strong{Mean}:

For the central F distribution (\code{ncp = NULL}):

\deqn{
    E(X) = \frac{d_2}{d_2 - 2}
  }{
    E(X) = d_2 / (d_2 - 2)
  }

for \eqn{d_2 > 2}, otherwise undefined.

For the non-central F distribution with non-centrality parameter
\code{ncp} = \eqn{\lambda}:

\deqn{
    E(X) = \frac{d_2 (d_1 + \lambda)}{d_1 (d_2 - 2)}
  }{
    E(X) = d_2 (d_1 + \lambda) / (d_1 (d_2 - 2))
  }

for \eqn{d_2 > 2}, otherwise undefined.

\strong{Variance}:

For the central F distribution (\code{ncp = NULL}):

\deqn{
    \text{Var}(X) = \frac{2 d_2^2 (d_1 + d_2 - 2)}{d_1 (d_2 - 2)^2 (d_2 - 4)}
  }{
    Var(X) = 2 d_2^2 (d_1 + d_2 - 2) / (d_1 (d_2 - 2)^2 (d_2 - 4))
  }

for \eqn{d_2 > 4}, otherwise undefined.

For the non-central F distribution with non-centrality parameter
\code{ncp} = \eqn{\lambda}:

\deqn{
    \text{Var}(X) = \frac{2 d_2^2}{d_1^2} \cdot \frac{(d_1 + \lambda)^2 + (d_1 + 2\lambda)(d_2 - 2)}{(d_2 - 2)^2 (d_2 - 4)}
  }{
    Var(X) = 2 d_2^2 / d_1^2 * ((d_1 + lambda)^2 + (d_1 + 2*lambda)(d_2 - 2)) / ((d_2 - 2)^2 (d_2 - 4))
  }

for \eqn{d_2 > 4}, otherwise undefined.

\strong{Skewness}:

For the central F distribution (\code{ncp = NULL}):

\deqn{
    \text{Skew}(X) = \frac{(2 d_1 + d_2 - 2) \sqrt{8 (d_2 - 4)}}{(d_2 - 6) \sqrt{d_1 (d_1 + d_2 - 2)}}
  }{
    Skew(X) = (2 d_1 + d_2 - 2) sqrt(8 (d_2 - 4)) / ((d_2 - 6) sqrt(d_1 (d_1 + d_2 - 2)))
  }

for \eqn{d_2 > 6}, otherwise undefined.

For the non-central F distribution, skewness has no simple closed form
and is not computed.

\strong{Excess Kurtosis}:

For the central F distribution (\code{ncp = NULL}):

\deqn{
    \text{Kurt}(X) = \frac{12[d_1 (5 d_2 - 22)(d_1 + d_2 - 2) + (d_2 - 4)(d_2 - 2)^2]}{d_1 (d_2 - 6)(d_2 - 8)(d_1 + d_2 - 2)}
  }{
    Kurt(X) = 12[d_1 (5 d_2 - 22)(d_1 + d_2 - 2) + (d_2 - 4)(d_2 - 2)^2] / (d_1 (d_2 - 6)(d_2 - 8)(d_1 + d_2 - 2))
  }

for \eqn{d_2 > 8}, otherwise undefined.

For the non-central F distribution, kurtosis has no simple closed form
and is not computed.

\strong{Probability density function (p.d.f)}:

For the central F distribution (\code{ncp = NULL}):

\deqn{
    f(x) = \frac{\sqrt{\frac{(d_1 x)^{d_1} d_2^{d_2}}{(d_1 x + d_2)^{d_1 + d_2}}}}{x \, B(d_1/2, d_2/2)}
  }{
    f(x) = sqrt((d_1 x)^d_1 d_2^d_2 / (d_1 x + d_2)^(d_1 + d_2)) / (x B(d_1/2, d_2/2))
  }

where \eqn{B(\cdot, \cdot)} is the beta function.

For the non-central F distribution, the density involves an infinite
series and is approximated numerically.

\strong{Cumulative distribution function (c.d.f)}:

The c.d.f. does not have a simple closed form expression and is
approximated numerically using regularized incomplete beta functions
and related special functions.

\strong{Moment generating function (m.g.f)}:

The moment generating function for the F distribution does not exist
in general (it diverges for \eqn{t > 0}).
}
\examples{
dist <- dist_f(df1 = c(1,2,5,10,100), df2 = c(1,1,2,1,100))

dist
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

}
\seealso{
\link[stats:Fdist]{stats::FDist}
}
