% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_disambiguate_terms.R
\name{tidy_disambiguate_terms}
\alias{tidy_disambiguate_terms}
\title{Disambiguate terms}
\usage{
tidy_disambiguate_terms(x, sep = ".", model = tidy_get_model(x), quiet = FALSE)
}
\arguments{
\item{x}{(\code{data.frame})\cr
A tidy tibble as produced by \verb{tidy_*()} functions.}

\item{sep}{(\code{string})\cr
Separator added between group name and term.}

\item{model}{(a model object, e.g. \code{glm})\cr
The corresponding model, if not attached to \code{x}.}

\item{quiet}{(\code{logical})\cr
Whether \code{broom.helpers} should not return a message when requested output
cannot be generated. Default is \code{FALSE}.}
}
\description{
For mixed models, the \code{term} column returned by \code{broom.mixed} may have
duplicated values for random-effect parameters and random-effect values.
In such case, the terms could be disambiguated be prefixing them with the
value of the \code{group} column. \code{tidy_disambiguate_terms()} will not change
any term if there is no \code{group} column in \code{x}. The original term value
is kept in a new column \code{original_term}.
}
\examples{
\donttest{
if (
  .assert_package("lme4", boolean = TRUE) &&
    .assert_package("broom.mixed", boolean = TRUE) &&
    .assert_package("gtsummary", boolean = TRUE)
) {
  mod <- lme4::lmer(marker ~ stage + (1 | grade) + (death | response), gtsummary::trial)
  mod |>
    tidy_and_attach() |>
    tidy_disambiguate_terms()
}
}
}
\seealso{
Other tidy_helpers: 
\code{\link{tidy_add_coefficients_type}()},
\code{\link{tidy_add_contrasts}()},
\code{\link{tidy_add_estimate_to_reference_rows}()},
\code{\link{tidy_add_header_rows}()},
\code{\link{tidy_add_n}()},
\code{\link{tidy_add_pairwise_contrasts}()},
\code{\link{tidy_add_reference_rows}()},
\code{\link{tidy_add_term_labels}()},
\code{\link{tidy_add_variable_labels}()},
\code{\link{tidy_attach_model}()},
\code{\link{tidy_group_by}()},
\code{\link{tidy_identify_variables}()},
\code{\link{tidy_plus_plus}()},
\code{\link{tidy_remove_intercept}()},
\code{\link{tidy_select_variables}()}
}
\concept{tidy_helpers}
