% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/ballgown-expr-methods.R
\docType{methods}
\name{iexpr}
\alias{iexpr}
\alias{iexpr,ballgown-method}
\title{extract transcript-level expression measurements from ballgown objects}
\usage{
iexpr(x, meas = "rcount")

\S4method{iexpr}{ballgown}(x, meas = "rcount")
}
\arguments{
\item{x}{a ballgown object}

\item{meas}{type of measurement to extract. Can be "rcount", "ucount", 
"mrcount", or "all". Default "rcount".}
}
\value{
intron-by-sample matrix containing the number of reads (measured as
  specified by \code{meas}) supporting each intron, in each sample. If
  \code{meas} is \code{"all"}, a data frame is returned, containing all
  measurements and location information.
}
\description{
extract transcript-level expression measurements from ballgown objects
}
\examples{
data(bg)
intron_rcount_matrix = iexpr(bg)
intron_data_frame = iexpr(bg, 'all')
}
