/* 
 * File: gtrackinfo.h
 *
 * GKrellM 2 Plugin to control XMMS2
 * Copyright (c) 2005 Johannes Heimansberg
 *
 * requires GKrellM 2.0.0 or better and XMMS2 DR1 or better
 *
 * Released under the GNU General Public License v2
 */

#ifndef __GTRACKINFO_H__
#define __GTRACKINFO_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtkdialog.h>
#include "trackinfo.h"

G_BEGIN_DECLS

#define GTRACKINFO_TYPE            (gtrackinfo_get_type ())
#define GTRACKINFO(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), GTRACKINFO_TYPE, GTrackinfo))
#define GTRACKINFO_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), GTRACKINFO_TYPE, GTrackinfoClass))
#define IS_GTRACKINFO(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GTRACKINFO_TYPE))
#define IS_GTRACKINFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GTRACKINFO_TYPE))

typedef struct _GTrackinfo       GTrackinfo;
typedef struct _GTrackinfoClass  GTrackinfoClass;

gboolean gtrackinfo_set_info(GTrackinfo *gti, trackinfo *info);

struct _GTrackinfo
{
	GtkDialog dialog;

	GtkWidget *hbox;
	GtkWidget *table;
	GtkWidget *entry_title, *entry_artist,  *entry_album;
	GtkWidget *entry_date,  *entry_comment, *entry_url, *entry_genre;
	GtkWidget *label_title, *label_artist,  *label_album;
	GtkWidget *label_date,  *label_comment, *label_url, *label_genre;
	GtkWidget *ok_button;
	GtkWidget *frame, *frame_vbox;
	GtkWidget *label_length, *label_bitrate, *label_filetype, *label_id;
	GtkWidget *label_samplerate, *label_filesize;
};

struct _GTrackinfoClass
{
  GtkDialogClass parent_class;

  void (* gtrackinfo) (GTrackinfo *gti);
};

GType      gtrackinfo_get_type(void);
GtkWidget* gtrackinfo_new(void);

G_END_DECLS

#endif
