---
title: Staticcheck 2017.2 release notes
linkTitle: 2017.2
weight: -1
---

The 2017.2 release of the staticcheck suite of tools focuses on
reducing friction – fewer false positives, more tools for suppressing
unwanted output, and JSON output for easier integration with other
tools.

## New features

### Linter directives for ignoring problems

In the past, the only ways to ignore reported problems was by using
the `-ignore` flag. This led to overreaching ignore rules
which weren't maintained regularly. Now, `//lint:ignore` and
`//lint:file-ignore` comments can be used to ignore
problems, either on specific lines or file-wide. A full description of
these directives, their syntax and their behavior can be found
in [the documentation]({{< relref "/docs/configuration#ignoring-problems" >}}).

A related change adds the `-show-ignored` command line
flag, which outputs problems that would otherwise be ignored by
directives. This is primarily of use with the JSON output format,
for custom front ends.

### Output formats

All staticcheck tools now support multiple output formats, selectable
with the `-f` flag.

Currently, two formats are supported. The first format is
`text`, which is the default and uses the existing terminal
output format. The other is `json`, which emits JSON. The
output is a stream of objects, allowing for a future streaming output
mode. Each object uses the following example schema:

```json
{
  "checker": "staticcheck",
  "code": "SA4006",
  "location": {
    "file": "/usr/lib/go/src/database/sql/sql_test.go",
    "line": 2701,
    "column": 5
  },
  "message": "this value of err is never used",
  "ignored": false
}
```

### Control over the exit code of megacheck

Megacheck, the tool for running multiple checkers at once, now has
per checker flags for controlling the overall exit code. Previously,
megacheck would exit non-zero if any checker found a problem. Now it
is possible to configure for each checker whether it should cause a
non-zero exit, by using the `-&lt;checker&gt;.exit-non-zero`
flags. This flag defaults to false for _gosimple_ and to true for
the other checkers.

## Changes to checks

### Support for `NoCopy` in _unused_

The _unused_ tool now understands `NoCopy` sentinel types. The
`NoCopy` type, which is canonically a struct with no fields and only a
single, empty `Lock` method, can be used to mark structs as not safe
for copying. By declaring a field of this type, _go vet_ will complain
when it sees instances of the struct being copied.

In the past, _unused_ marked these fields as unused, now it ignores
them.

### Detection of deprecated identifiers

{{< check "SA1019" >}} now
correctly identifies deprecated methods, in addition to fields and
package-level objects. Additionally, staticcheck now keeps track of
when each identifier in the Go standard library was deprecated, so
that using `-go &lt;version&gt;` can correctly
ignore deprecation warnings that don't apply to the targeted Go
version.

### Other

- {{< check "SA4017" >}} no longer reports pure functions that are stubs – functions that immediately panic or return a constant.
- {{< check "SA5007" >}} no longer flags infinite recursion when the function call is spawned as a new goroutine.
- {{< check "SA6002" >}} now recognizes that `unsafe.Pointer` is a pointer type.
- {{< check "S1005"  >}} no longer suggests `for range` when targeting a version older than Go 1.4.
- {{< check "S1026"  >}} has been removed. In some rare instances, copying a string is necessary, and all common ways of doing this were incorrectly flagged by the check.


## Other changes

- The `-ignore` flag now supports ignoring checks in all packages, by using `*` as the path.
- `//line` directives are now being ignored when reporting problems. That is, problems will always be reported for the actual position in the Go files they occur.
- From now on, only the first compilation error encountered will be reported. 
The tools expect to be run on valid Go code and there was little (if any) value in reporting all compilation errors encountered, especially because simple errors can lead to many follow-up errors.

## Staticcheck 2017.2.1 Release Notes {#2017.2.1}

The 2017.2.1 release of the staticcheck suite of tools is the first
bug fix release, fixing one bug.

### Fixed bugs

Staticcheck 2017.2 made the detection of deprecated objects
Go-version aware. Unfortunately, this only worked correctly for
fields and methods, but not package-level objects. This release
fixes that.

## Staticcheck 2017.2.2 Release Notes {#2017.2.2}

The 2017.2.2 release of the staticcheck suite of tools is the second
bug fix release, fixing several bugs.

### Fixed bugs

- _unused_: correctly apply the NoCopy exemption when using the `-exported` flag.
- _keyify_: support external test packages (`package foo_test`)
- _staticcheck_: disable {{< check "SA4005" >}} – the check, in its current form, is prone to false positives and will be reimplemented in a future release.
