//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/securityinsights/armsecurityinsights"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// SentinelOnboardingStatesServer is a fake server for instances of the armsecurityinsights.SentinelOnboardingStatesClient type.
type SentinelOnboardingStatesServer struct {
	// Create is the fake for method SentinelOnboardingStatesClient.Create
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Create func(ctx context.Context, resourceGroupName string, workspaceName string, sentinelOnboardingStateName string, options *armsecurityinsights.SentinelOnboardingStatesClientCreateOptions) (resp azfake.Responder[armsecurityinsights.SentinelOnboardingStatesClientCreateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method SentinelOnboardingStatesClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, resourceGroupName string, workspaceName string, sentinelOnboardingStateName string, options *armsecurityinsights.SentinelOnboardingStatesClientDeleteOptions) (resp azfake.Responder[armsecurityinsights.SentinelOnboardingStatesClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method SentinelOnboardingStatesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, workspaceName string, sentinelOnboardingStateName string, options *armsecurityinsights.SentinelOnboardingStatesClientGetOptions) (resp azfake.Responder[armsecurityinsights.SentinelOnboardingStatesClientGetResponse], errResp azfake.ErrorResponder)

	// List is the fake for method SentinelOnboardingStatesClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, resourceGroupName string, workspaceName string, options *armsecurityinsights.SentinelOnboardingStatesClientListOptions) (resp azfake.Responder[armsecurityinsights.SentinelOnboardingStatesClientListResponse], errResp azfake.ErrorResponder)
}

// NewSentinelOnboardingStatesServerTransport creates a new instance of SentinelOnboardingStatesServerTransport with the provided implementation.
// The returned SentinelOnboardingStatesServerTransport instance is connected to an instance of armsecurityinsights.SentinelOnboardingStatesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSentinelOnboardingStatesServerTransport(srv *SentinelOnboardingStatesServer) *SentinelOnboardingStatesServerTransport {
	return &SentinelOnboardingStatesServerTransport{srv: srv}
}

// SentinelOnboardingStatesServerTransport connects instances of armsecurityinsights.SentinelOnboardingStatesClient to instances of SentinelOnboardingStatesServer.
// Don't use this type directly, use NewSentinelOnboardingStatesServerTransport instead.
type SentinelOnboardingStatesServerTransport struct {
	srv *SentinelOnboardingStatesServer
}

// Do implements the policy.Transporter interface for SentinelOnboardingStatesServerTransport.
func (s *SentinelOnboardingStatesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SentinelOnboardingStatesClient.Create":
		resp, err = s.dispatchCreate(req)
	case "SentinelOnboardingStatesClient.Delete":
		resp, err = s.dispatchDelete(req)
	case "SentinelOnboardingStatesClient.Get":
		resp, err = s.dispatchGet(req)
	case "SentinelOnboardingStatesClient.List":
		resp, err = s.dispatchList(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SentinelOnboardingStatesServerTransport) dispatchCreate(req *http.Request) (*http.Response, error) {
	if s.srv.Create == nil {
		return nil, &nonRetriableError{errors.New("fake for method Create not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityInsights/onboardingStates/(?P<sentinelOnboardingStateName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsecurityinsights.SentinelOnboardingState](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	sentinelOnboardingStateNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sentinelOnboardingStateName")])
	if err != nil {
		return nil, err
	}
	var options *armsecurityinsights.SentinelOnboardingStatesClientCreateOptions
	if !reflect.ValueOf(body).IsZero() {
		options = &armsecurityinsights.SentinelOnboardingStatesClientCreateOptions{
			SentinelOnboardingStateParameter: &body,
		}
	}
	respr, errRespr := s.srv.Create(req.Context(), resourceGroupNameParam, workspaceNameParam, sentinelOnboardingStateNameParam, options)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SentinelOnboardingState, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SentinelOnboardingStatesServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if s.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityInsights/onboardingStates/(?P<sentinelOnboardingStateName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	sentinelOnboardingStateNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sentinelOnboardingStateName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Delete(req.Context(), resourceGroupNameParam, workspaceNameParam, sentinelOnboardingStateNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SentinelOnboardingStatesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityInsights/onboardingStates/(?P<sentinelOnboardingStateName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	sentinelOnboardingStateNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sentinelOnboardingStateName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, workspaceNameParam, sentinelOnboardingStateNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SentinelOnboardingState, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *SentinelOnboardingStatesServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if s.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.OperationalInsights/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.SecurityInsights/onboardingStates`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.List(req.Context(), resourceGroupNameParam, workspaceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).SentinelOnboardingStatesList, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
