//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armrecoveryservicesdatareplication

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AzStackHCIClusterProperties.
func (a AzStackHCIClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clusterName", a.ClusterName)
	populate(objectMap, "resourceName", a.ResourceName)
	populate(objectMap, "storageAccountName", a.StorageAccountName)
	populate(objectMap, "storageContainers", a.StorageContainers)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzStackHCIClusterProperties.
func (a *AzStackHCIClusterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clusterName":
			err = unpopulate(val, "ClusterName", &a.ClusterName)
			delete(rawMsg, key)
		case "resourceName":
			err = unpopulate(val, "ResourceName", &a.ResourceName)
			delete(rawMsg, key)
		case "storageAccountName":
			err = unpopulate(val, "StorageAccountName", &a.StorageAccountName)
			delete(rawMsg, key)
		case "storageContainers":
			err = unpopulate(val, "StorageContainers", &a.StorageContainers)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzStackHCIFabricModelCustomProperties.
func (a AzStackHCIFabricModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "applianceName", a.ApplianceName)
	populate(objectMap, "azStackHciSiteId", a.AzStackHciSiteID)
	populate(objectMap, "cluster", a.Cluster)
	populate(objectMap, "fabricContainerId", a.FabricContainerID)
	populate(objectMap, "fabricResourceId", a.FabricResourceID)
	objectMap["instanceType"] = "AzStackHCI"
	populate(objectMap, "migrationHubUri", a.MigrationHubURI)
	populate(objectMap, "migrationSolutionId", a.MigrationSolutionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzStackHCIFabricModelCustomProperties.
func (a *AzStackHCIFabricModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "applianceName":
			err = unpopulate(val, "ApplianceName", &a.ApplianceName)
			delete(rawMsg, key)
		case "azStackHciSiteId":
			err = unpopulate(val, "AzStackHciSiteID", &a.AzStackHciSiteID)
			delete(rawMsg, key)
		case "cluster":
			err = unpopulate(val, "Cluster", &a.Cluster)
			delete(rawMsg, key)
		case "fabricContainerId":
			err = unpopulate(val, "FabricContainerID", &a.FabricContainerID)
			delete(rawMsg, key)
		case "fabricResourceId":
			err = unpopulate(val, "FabricResourceID", &a.FabricResourceID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &a.InstanceType)
			delete(rawMsg, key)
		case "migrationHubUri":
			err = unpopulate(val, "MigrationHubURI", &a.MigrationHubURI)
			delete(rawMsg, key)
		case "migrationSolutionId":
			err = unpopulate(val, "MigrationSolutionID", &a.MigrationSolutionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityModel.
func (c CheckNameAvailabilityModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "type", c.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityModel.
func (c *CheckNameAvailabilityModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &c.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CheckNameAvailabilityResponseModel.
func (c CheckNameAvailabilityResponseModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "message", c.Message)
	populate(objectMap, "nameAvailable", c.NameAvailable)
	populate(objectMap, "reason", c.Reason)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CheckNameAvailabilityResponseModel.
func (c *CheckNameAvailabilityResponseModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "message":
			err = unpopulate(val, "Message", &c.Message)
			delete(rawMsg, key)
		case "nameAvailable":
			err = unpopulate(val, "NameAvailable", &c.NameAvailable)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeploymentPreflightModel.
func (d DeploymentPreflightModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "resources", d.Resources)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeploymentPreflightModel.
func (d *DeploymentPreflightModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "resources":
			err = unpopulate(val, "Resources", &d.Resources)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DeploymentPreflightResource.
func (d DeploymentPreflightResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiVersion", d.APIVersion)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DeploymentPreflightResource.
func (d *DeploymentPreflightResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiVersion":
			err = unpopulate(val, "APIVersion", &d.APIVersion)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DraModel.
func (d DraModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", d.ID)
	populate(objectMap, "name", d.Name)
	populate(objectMap, "properties", d.Properties)
	populate(objectMap, "systemData", d.SystemData)
	populate(objectMap, "type", d.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DraModel.
func (d *DraModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &d.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &d.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &d.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &d.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &d.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DraModelCollection.
func (d DraModelCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", d.NextLink)
	populate(objectMap, "value", d.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DraModelCollection.
func (d *DraModelCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &d.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &d.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DraModelCustomProperties.
func (d DraModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = d.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DraModelCustomProperties.
func (d *DraModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &d.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DraModelProperties.
func (d DraModelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authenticationIdentity", d.AuthenticationIdentity)
	populate(objectMap, "correlationId", d.CorrelationID)
	populate(objectMap, "customProperties", d.CustomProperties)
	populate(objectMap, "healthErrors", d.HealthErrors)
	populate(objectMap, "isResponsive", d.IsResponsive)
	populateDateTimeRFC3339(objectMap, "lastHeartbeat", d.LastHeartbeat)
	populate(objectMap, "machineId", d.MachineID)
	populate(objectMap, "machineName", d.MachineName)
	populate(objectMap, "provisioningState", d.ProvisioningState)
	populate(objectMap, "resourceAccessIdentity", d.ResourceAccessIdentity)
	populate(objectMap, "versionNumber", d.VersionNumber)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DraModelProperties.
func (d *DraModelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authenticationIdentity":
			err = unpopulate(val, "AuthenticationIdentity", &d.AuthenticationIdentity)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &d.CorrelationID)
			delete(rawMsg, key)
		case "customProperties":
			d.CustomProperties, err = unmarshalDraModelCustomPropertiesClassification(val)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &d.HealthErrors)
			delete(rawMsg, key)
		case "isResponsive":
			err = unpopulate(val, "IsResponsive", &d.IsResponsive)
			delete(rawMsg, key)
		case "lastHeartbeat":
			err = unpopulateDateTimeRFC3339(val, "LastHeartbeat", &d.LastHeartbeat)
			delete(rawMsg, key)
		case "machineId":
			err = unpopulate(val, "MachineID", &d.MachineID)
			delete(rawMsg, key)
		case "machineName":
			err = unpopulate(val, "MachineName", &d.MachineName)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &d.ProvisioningState)
			delete(rawMsg, key)
		case "resourceAccessIdentity":
			err = unpopulate(val, "ResourceAccessIdentity", &d.ResourceAccessIdentity)
			delete(rawMsg, key)
		case "versionNumber":
			err = unpopulate(val, "VersionNumber", &d.VersionNumber)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DraModelSystemData.
func (d DraModelSystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", d.CreatedAt)
	populate(objectMap, "createdBy", d.CreatedBy)
	populate(objectMap, "createdByType", d.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", d.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", d.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", d.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DraModelSystemData.
func (d *DraModelSystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &d.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &d.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &d.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &d.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &d.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &d.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmailConfigurationModel.
func (e EmailConfigurationModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "systemData", e.SystemData)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmailConfigurationModel.
func (e *EmailConfigurationModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &e.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmailConfigurationModelCollection.
func (e EmailConfigurationModelCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmailConfigurationModelCollection.
func (e *EmailConfigurationModelCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmailConfigurationModelProperties.
func (e EmailConfigurationModelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customEmailAddresses", e.CustomEmailAddresses)
	populate(objectMap, "locale", e.Locale)
	populate(objectMap, "sendToOwners", e.SendToOwners)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmailConfigurationModelProperties.
func (e *EmailConfigurationModelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customEmailAddresses":
			err = unpopulate(val, "CustomEmailAddresses", &e.CustomEmailAddresses)
			delete(rawMsg, key)
		case "locale":
			err = unpopulate(val, "Locale", &e.Locale)
			delete(rawMsg, key)
		case "sendToOwners":
			err = unpopulate(val, "SendToOwners", &e.SendToOwners)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EmailConfigurationModelSystemData.
func (e EmailConfigurationModelSystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", e.CreatedAt)
	populate(objectMap, "createdBy", e.CreatedBy)
	populate(objectMap, "createdByType", e.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", e.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", e.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", e.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EmailConfigurationModelSystemData.
func (e *EmailConfigurationModelSystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &e.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &e.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &e.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &e.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &e.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &e.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ErrorModel.
func (e ErrorModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "causes", e.Causes)
	populate(objectMap, "code", e.Code)
	populateDateTimeRFC3339(objectMap, "creationTime", e.CreationTime)
	populate(objectMap, "message", e.Message)
	populate(objectMap, "recommendation", e.Recommendation)
	populate(objectMap, "severity", e.Severity)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ErrorModel.
func (e *ErrorModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "causes":
			err = unpopulate(val, "Causes", &e.Causes)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &e.Code)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &e.CreationTime)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &e.Message)
			delete(rawMsg, key)
		case "recommendation":
			err = unpopulate(val, "Recommendation", &e.Recommendation)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &e.Severity)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventModel.
func (e EventModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", e.ID)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "properties", e.Properties)
	populate(objectMap, "systemData", e.SystemData)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventModel.
func (e *EventModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &e.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &e.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &e.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventModelCollection.
func (e EventModelCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", e.NextLink)
	populate(objectMap, "value", e.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventModelCollection.
func (e *EventModelCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &e.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &e.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventModelCustomProperties.
func (e EventModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = e.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventModelCustomProperties.
func (e *EventModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &e.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventModelProperties.
func (e EventModelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "correlationId", e.CorrelationID)
	populate(objectMap, "customProperties", e.CustomProperties)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "eventName", e.EventName)
	populate(objectMap, "eventType", e.EventType)
	populate(objectMap, "healthErrors", e.HealthErrors)
	populate(objectMap, "resourceName", e.ResourceName)
	populate(objectMap, "resourceType", e.ResourceType)
	populate(objectMap, "severity", e.Severity)
	populateDateTimeRFC3339(objectMap, "timeOfOccurrence", e.TimeOfOccurrence)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventModelProperties.
func (e *EventModelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &e.CorrelationID)
			delete(rawMsg, key)
		case "customProperties":
			e.CustomProperties, err = unmarshalEventModelCustomPropertiesClassification(val)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "eventName":
			err = unpopulate(val, "EventName", &e.EventName)
			delete(rawMsg, key)
		case "eventType":
			err = unpopulate(val, "EventType", &e.EventType)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &e.HealthErrors)
			delete(rawMsg, key)
		case "resourceName":
			err = unpopulate(val, "ResourceName", &e.ResourceName)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &e.ResourceType)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &e.Severity)
			delete(rawMsg, key)
		case "timeOfOccurrence":
			err = unpopulateDateTimeRFC3339(val, "TimeOfOccurrence", &e.TimeOfOccurrence)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EventModelSystemData.
func (e EventModelSystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", e.CreatedAt)
	populate(objectMap, "createdBy", e.CreatedBy)
	populate(objectMap, "createdByType", e.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", e.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", e.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", e.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EventModelSystemData.
func (e *EventModelSystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &e.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &e.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &e.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &e.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &e.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &e.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FabricModel.
func (f FabricModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "location", f.Location)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "systemData", f.SystemData)
	populate(objectMap, "tags", f.Tags)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FabricModel.
func (f *FabricModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &f.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &f.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &f.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FabricModelCollection.
func (f FabricModelCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", f.NextLink)
	populate(objectMap, "value", f.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FabricModelCollection.
func (f *FabricModelCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &f.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &f.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FabricModelCustomProperties.
func (f FabricModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = f.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FabricModelCustomProperties.
func (f *FabricModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &f.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FabricModelProperties.
func (f FabricModelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customProperties", f.CustomProperties)
	populate(objectMap, "health", f.Health)
	populate(objectMap, "healthErrors", f.HealthErrors)
	populate(objectMap, "provisioningState", f.ProvisioningState)
	populate(objectMap, "serviceEndpoint", f.ServiceEndpoint)
	populate(objectMap, "serviceResourceId", f.ServiceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FabricModelProperties.
func (f *FabricModelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customProperties":
			f.CustomProperties, err = unmarshalFabricModelCustomPropertiesClassification(val)
			delete(rawMsg, key)
		case "health":
			err = unpopulate(val, "Health", &f.Health)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &f.HealthErrors)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &f.ProvisioningState)
			delete(rawMsg, key)
		case "serviceEndpoint":
			err = unpopulate(val, "ServiceEndpoint", &f.ServiceEndpoint)
			delete(rawMsg, key)
		case "serviceResourceId":
			err = unpopulate(val, "ServiceResourceID", &f.ServiceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FabricModelSystemData.
func (f FabricModelSystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", f.CreatedAt)
	populate(objectMap, "createdBy", f.CreatedBy)
	populate(objectMap, "createdByType", f.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", f.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", f.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", f.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FabricModelSystemData.
func (f *FabricModelSystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &f.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &f.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &f.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &f.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &f.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &f.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FabricModelUpdate.
func (f FabricModelUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", f.ID)
	populate(objectMap, "name", f.Name)
	populate(objectMap, "properties", f.Properties)
	populate(objectMap, "systemData", f.SystemData)
	populate(objectMap, "tags", f.Tags)
	populate(objectMap, "type", f.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FabricModelUpdate.
func (f *FabricModelUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &f.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &f.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &f.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &f.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &f.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &f.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FabricModelUpdateSystemData.
func (f FabricModelUpdateSystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", f.CreatedAt)
	populate(objectMap, "createdBy", f.CreatedBy)
	populate(objectMap, "createdByType", f.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", f.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", f.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", f.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FabricModelUpdateSystemData.
func (f *FabricModelUpdateSystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &f.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &f.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &f.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &f.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &f.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &f.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FailoverProtectedItemProperties.
func (f FailoverProtectedItemProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkName", f.NetworkName)
	populate(objectMap, "protectedItemName", f.ProtectedItemName)
	populate(objectMap, "recoveryPointId", f.RecoveryPointID)
	populateDateTimeRFC3339(objectMap, "recoveryPointTime", f.RecoveryPointTime)
	populate(objectMap, "subnet", f.Subnet)
	populate(objectMap, "testVmName", f.TestVMName)
	populate(objectMap, "vmName", f.VMName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FailoverProtectedItemProperties.
func (f *FailoverProtectedItemProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkName":
			err = unpopulate(val, "NetworkName", &f.NetworkName)
			delete(rawMsg, key)
		case "protectedItemName":
			err = unpopulate(val, "ProtectedItemName", &f.ProtectedItemName)
			delete(rawMsg, key)
		case "recoveryPointId":
			err = unpopulate(val, "RecoveryPointID", &f.RecoveryPointID)
			delete(rawMsg, key)
		case "recoveryPointTime":
			err = unpopulateDateTimeRFC3339(val, "RecoveryPointTime", &f.RecoveryPointTime)
			delete(rawMsg, key)
		case "subnet":
			err = unpopulate(val, "Subnet", &f.Subnet)
			delete(rawMsg, key)
		case "testVmName":
			err = unpopulate(val, "TestVMName", &f.TestVMName)
			delete(rawMsg, key)
		case "vmName":
			err = unpopulate(val, "VMName", &f.VMName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type FailoverWorkflowModelCustomProperties.
func (f FailoverWorkflowModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "affectedObjectDetails", f.AffectedObjectDetails)
	objectMap["instanceType"] = "FailoverWorkflowDetails"
	populate(objectMap, "protectedItemDetails", f.ProtectedItemDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type FailoverWorkflowModelCustomProperties.
func (f *FailoverWorkflowModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", f, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectDetails":
			err = unpopulate(val, "AffectedObjectDetails", &f.AffectedObjectDetails)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &f.InstanceType)
			delete(rawMsg, key)
		case "protectedItemDetails":
			err = unpopulate(val, "ProtectedItemDetails", &f.ProtectedItemDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", f, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HealthErrorModel.
func (h HealthErrorModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "affectedResourceCorrelationIds", h.AffectedResourceCorrelationIDs)
	populate(objectMap, "affectedResourceType", h.AffectedResourceType)
	populate(objectMap, "category", h.Category)
	populate(objectMap, "causes", h.Causes)
	populate(objectMap, "childErrors", h.ChildErrors)
	populate(objectMap, "code", h.Code)
	populateDateTimeRFC3339(objectMap, "creationTime", h.CreationTime)
	populate(objectMap, "healthCategory", h.HealthCategory)
	populate(objectMap, "isCustomerResolvable", h.IsCustomerResolvable)
	populate(objectMap, "message", h.Message)
	populate(objectMap, "recommendation", h.Recommendation)
	populate(objectMap, "severity", h.Severity)
	populate(objectMap, "source", h.Source)
	populate(objectMap, "summary", h.Summary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HealthErrorModel.
func (h *HealthErrorModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedResourceCorrelationIds":
			err = unpopulate(val, "AffectedResourceCorrelationIDs", &h.AffectedResourceCorrelationIDs)
			delete(rawMsg, key)
		case "affectedResourceType":
			err = unpopulate(val, "AffectedResourceType", &h.AffectedResourceType)
			delete(rawMsg, key)
		case "category":
			err = unpopulate(val, "Category", &h.Category)
			delete(rawMsg, key)
		case "causes":
			err = unpopulate(val, "Causes", &h.Causes)
			delete(rawMsg, key)
		case "childErrors":
			err = unpopulate(val, "ChildErrors", &h.ChildErrors)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &h.Code)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &h.CreationTime)
			delete(rawMsg, key)
		case "healthCategory":
			err = unpopulate(val, "HealthCategory", &h.HealthCategory)
			delete(rawMsg, key)
		case "isCustomerResolvable":
			err = unpopulate(val, "IsCustomerResolvable", &h.IsCustomerResolvable)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &h.Message)
			delete(rawMsg, key)
		case "recommendation":
			err = unpopulate(val, "Recommendation", &h.Recommendation)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &h.Severity)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &h.Source)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &h.Summary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVMigrateFabricModelCustomProperties.
func (h HyperVMigrateFabricModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fabricContainerId", h.FabricContainerID)
	populate(objectMap, "fabricResourceId", h.FabricResourceID)
	populate(objectMap, "hyperVSiteId", h.HyperVSiteID)
	objectMap["instanceType"] = "HyperVMigrate"
	populate(objectMap, "migrationHubUri", h.MigrationHubURI)
	populate(objectMap, "migrationSolutionId", h.MigrationSolutionID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVMigrateFabricModelCustomProperties.
func (h *HyperVMigrateFabricModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fabricContainerId":
			err = unpopulate(val, "FabricContainerID", &h.FabricContainerID)
			delete(rawMsg, key)
		case "fabricResourceId":
			err = unpopulate(val, "FabricResourceID", &h.FabricResourceID)
			delete(rawMsg, key)
		case "hyperVSiteId":
			err = unpopulate(val, "HyperVSiteID", &h.HyperVSiteID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "migrationHubUri":
			err = unpopulate(val, "MigrationHubURI", &h.MigrationHubURI)
			delete(rawMsg, key)
		case "migrationSolutionId":
			err = unpopulate(val, "MigrationSolutionID", &h.MigrationSolutionID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVToAzStackHCIDiskInput.
func (h HyperVToAzStackHCIDiskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskFileFormat", h.DiskFileFormat)
	populate(objectMap, "diskId", h.DiskID)
	populate(objectMap, "diskSizeGB", h.DiskSizeGB)
	populate(objectMap, "isDynamic", h.IsDynamic)
	populate(objectMap, "isOsDisk", h.IsOsDisk)
	populate(objectMap, "storageContainerId", h.StorageContainerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVToAzStackHCIDiskInput.
func (h *HyperVToAzStackHCIDiskInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskFileFormat":
			err = unpopulate(val, "DiskFileFormat", &h.DiskFileFormat)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &h.DiskID)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &h.DiskSizeGB)
			delete(rawMsg, key)
		case "isDynamic":
			err = unpopulate(val, "IsDynamic", &h.IsDynamic)
			delete(rawMsg, key)
		case "isOsDisk":
			err = unpopulate(val, "IsOsDisk", &h.IsOsDisk)
			delete(rawMsg, key)
		case "storageContainerId":
			err = unpopulate(val, "StorageContainerID", &h.StorageContainerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVToAzStackHCIEventModelCustomProperties.
func (h HyperVToAzStackHCIEventModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "eventSourceFriendlyName", h.EventSourceFriendlyName)
	objectMap["instanceType"] = "HyperVToAzStackHCI"
	populate(objectMap, "protectedItemFriendlyName", h.ProtectedItemFriendlyName)
	populate(objectMap, "serverType", h.ServerType)
	populate(objectMap, "sourceApplianceName", h.SourceApplianceName)
	populate(objectMap, "targetApplianceName", h.TargetApplianceName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVToAzStackHCIEventModelCustomProperties.
func (h *HyperVToAzStackHCIEventModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "eventSourceFriendlyName":
			err = unpopulate(val, "EventSourceFriendlyName", &h.EventSourceFriendlyName)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "protectedItemFriendlyName":
			err = unpopulate(val, "ProtectedItemFriendlyName", &h.ProtectedItemFriendlyName)
			delete(rawMsg, key)
		case "serverType":
			err = unpopulate(val, "ServerType", &h.ServerType)
			delete(rawMsg, key)
		case "sourceApplianceName":
			err = unpopulate(val, "SourceApplianceName", &h.SourceApplianceName)
			delete(rawMsg, key)
		case "targetApplianceName":
			err = unpopulate(val, "TargetApplianceName", &h.TargetApplianceName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVToAzStackHCINicInput.
func (h HyperVToAzStackHCINicInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "networkName", h.NetworkName)
	populate(objectMap, "nicId", h.NicID)
	populate(objectMap, "selectionTypeForFailover", h.SelectionTypeForFailover)
	populate(objectMap, "targetNetworkId", h.TargetNetworkID)
	populate(objectMap, "testNetworkId", h.TestNetworkID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVToAzStackHCINicInput.
func (h *HyperVToAzStackHCINicInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "networkName":
			err = unpopulate(val, "NetworkName", &h.NetworkName)
			delete(rawMsg, key)
		case "nicId":
			err = unpopulate(val, "NicID", &h.NicID)
			delete(rawMsg, key)
		case "selectionTypeForFailover":
			err = unpopulate(val, "SelectionTypeForFailover", &h.SelectionTypeForFailover)
			delete(rawMsg, key)
		case "targetNetworkId":
			err = unpopulate(val, "TargetNetworkID", &h.TargetNetworkID)
			delete(rawMsg, key)
		case "testNetworkId":
			err = unpopulate(val, "TestNetworkID", &h.TestNetworkID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVToAzStackHCIPlannedFailoverModelCustomProperties.
func (h HyperVToAzStackHCIPlannedFailoverModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "HyperVToAzStackHCI"
	populate(objectMap, "shutdownSourceVM", h.ShutdownSourceVM)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVToAzStackHCIPlannedFailoverModelCustomProperties.
func (h *HyperVToAzStackHCIPlannedFailoverModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "shutdownSourceVM":
			err = unpopulate(val, "ShutdownSourceVM", &h.ShutdownSourceVM)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVToAzStackHCIPolicyModelCustomProperties.
func (h HyperVToAzStackHCIPolicyModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appConsistentFrequencyInMinutes", h.AppConsistentFrequencyInMinutes)
	populate(objectMap, "crashConsistentFrequencyInMinutes", h.CrashConsistentFrequencyInMinutes)
	objectMap["instanceType"] = "HyperVToAzStackHCI"
	populate(objectMap, "recoveryPointHistoryInMinutes", h.RecoveryPointHistoryInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVToAzStackHCIPolicyModelCustomProperties.
func (h *HyperVToAzStackHCIPolicyModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &h.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &h.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointHistoryInMinutes":
			err = unpopulate(val, "RecoveryPointHistoryInMinutes", &h.RecoveryPointHistoryInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVToAzStackHCIProtectedDiskProperties.
func (h HyperVToAzStackHCIProtectedDiskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacityInBytes", h.CapacityInBytes)
	populate(objectMap, "diskType", h.DiskType)
	populate(objectMap, "isDynamic", h.IsDynamic)
	populate(objectMap, "isOsDisk", h.IsOsDisk)
	populate(objectMap, "migrateDiskName", h.MigrateDiskName)
	populate(objectMap, "seedDiskName", h.SeedDiskName)
	populate(objectMap, "sourceDiskId", h.SourceDiskID)
	populate(objectMap, "sourceDiskName", h.SourceDiskName)
	populate(objectMap, "storageContainerId", h.StorageContainerID)
	populate(objectMap, "storageContainerLocalPath", h.StorageContainerLocalPath)
	populate(objectMap, "testMigrateDiskName", h.TestMigrateDiskName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVToAzStackHCIProtectedDiskProperties.
func (h *HyperVToAzStackHCIProtectedDiskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacityInBytes":
			err = unpopulate(val, "CapacityInBytes", &h.CapacityInBytes)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &h.DiskType)
			delete(rawMsg, key)
		case "isDynamic":
			err = unpopulate(val, "IsDynamic", &h.IsDynamic)
			delete(rawMsg, key)
		case "isOsDisk":
			err = unpopulate(val, "IsOsDisk", &h.IsOsDisk)
			delete(rawMsg, key)
		case "migrateDiskName":
			err = unpopulate(val, "MigrateDiskName", &h.MigrateDiskName)
			delete(rawMsg, key)
		case "seedDiskName":
			err = unpopulate(val, "SeedDiskName", &h.SeedDiskName)
			delete(rawMsg, key)
		case "sourceDiskId":
			err = unpopulate(val, "SourceDiskID", &h.SourceDiskID)
			delete(rawMsg, key)
		case "sourceDiskName":
			err = unpopulate(val, "SourceDiskName", &h.SourceDiskName)
			delete(rawMsg, key)
		case "storageContainerId":
			err = unpopulate(val, "StorageContainerID", &h.StorageContainerID)
			delete(rawMsg, key)
		case "storageContainerLocalPath":
			err = unpopulate(val, "StorageContainerLocalPath", &h.StorageContainerLocalPath)
			delete(rawMsg, key)
		case "testMigrateDiskName":
			err = unpopulate(val, "TestMigrateDiskName", &h.TestMigrateDiskName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVToAzStackHCIProtectedItemModelCustomProperties.
func (h HyperVToAzStackHCIProtectedItemModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activeLocation", h.ActiveLocation)
	populate(objectMap, "customLocationRegion", h.CustomLocationRegion)
	populate(objectMap, "disksToInclude", h.DisksToInclude)
	populate(objectMap, "dynamicMemoryConfig", h.DynamicMemoryConfig)
	populate(objectMap, "fabricDiscoveryMachineId", h.FabricDiscoveryMachineID)
	populate(objectMap, "failoverRecoveryPointId", h.FailoverRecoveryPointID)
	populate(objectMap, "firmwareType", h.FirmwareType)
	populate(objectMap, "hyperVGeneration", h.HyperVGeneration)
	populate(objectMap, "initialReplicationProgressPercentage", h.InitialReplicationProgressPercentage)
	objectMap["instanceType"] = "HyperVToAzStackHCI"
	populate(objectMap, "isDynamicRam", h.IsDynamicRAM)
	populate(objectMap, "lastRecoveryPointId", h.LastRecoveryPointID)
	populateDateTimeRFC3339(objectMap, "lastRecoveryPointReceived", h.LastRecoveryPointReceived)
	populateDateTimeRFC3339(objectMap, "lastReplicationUpdateTime", h.LastReplicationUpdateTime)
	populate(objectMap, "nicsToInclude", h.NicsToInclude)
	populate(objectMap, "osName", h.OSName)
	populate(objectMap, "osType", h.OSType)
	populate(objectMap, "protectedDisks", h.ProtectedDisks)
	populate(objectMap, "protectedNics", h.ProtectedNics)
	populate(objectMap, "resyncProgressPercentage", h.ResyncProgressPercentage)
	populate(objectMap, "runAsAccountId", h.RunAsAccountID)
	populate(objectMap, "sourceApplianceName", h.SourceApplianceName)
	populate(objectMap, "sourceCpuCores", h.SourceCPUCores)
	populate(objectMap, "sourceDraName", h.SourceDraName)
	populate(objectMap, "sourceMemoryInMegaBytes", h.SourceMemoryInMegaBytes)
	populate(objectMap, "sourceVmName", h.SourceVMName)
	populate(objectMap, "storageContainerId", h.StorageContainerID)
	populate(objectMap, "targetApplianceName", h.TargetApplianceName)
	populate(objectMap, "targetArcClusterCustomLocationId", h.TargetArcClusterCustomLocationID)
	populate(objectMap, "targetAzStackHciClusterName", h.TargetAzStackHciClusterName)
	populate(objectMap, "targetCpuCores", h.TargetCPUCores)
	populate(objectMap, "targetDraName", h.TargetDraName)
	populate(objectMap, "targetHciClusterId", h.TargetHciClusterID)
	populate(objectMap, "targetLocation", h.TargetLocation)
	populate(objectMap, "targetMemoryInMegaBytes", h.TargetMemoryInMegaBytes)
	populate(objectMap, "targetNetworkId", h.TargetNetworkID)
	populate(objectMap, "targetResourceGroupId", h.TargetResourceGroupID)
	populate(objectMap, "targetVmBiosId", h.TargetVMBiosID)
	populate(objectMap, "targetVmName", h.TargetVMName)
	populate(objectMap, "testNetworkId", h.TestNetworkID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVToAzStackHCIProtectedItemModelCustomProperties.
func (h *HyperVToAzStackHCIProtectedItemModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeLocation":
			err = unpopulate(val, "ActiveLocation", &h.ActiveLocation)
			delete(rawMsg, key)
		case "customLocationRegion":
			err = unpopulate(val, "CustomLocationRegion", &h.CustomLocationRegion)
			delete(rawMsg, key)
		case "disksToInclude":
			err = unpopulate(val, "DisksToInclude", &h.DisksToInclude)
			delete(rawMsg, key)
		case "dynamicMemoryConfig":
			err = unpopulate(val, "DynamicMemoryConfig", &h.DynamicMemoryConfig)
			delete(rawMsg, key)
		case "fabricDiscoveryMachineId":
			err = unpopulate(val, "FabricDiscoveryMachineID", &h.FabricDiscoveryMachineID)
			delete(rawMsg, key)
		case "failoverRecoveryPointId":
			err = unpopulate(val, "FailoverRecoveryPointID", &h.FailoverRecoveryPointID)
			delete(rawMsg, key)
		case "firmwareType":
			err = unpopulate(val, "FirmwareType", &h.FirmwareType)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &h.HyperVGeneration)
			delete(rawMsg, key)
		case "initialReplicationProgressPercentage":
			err = unpopulate(val, "InitialReplicationProgressPercentage", &h.InitialReplicationProgressPercentage)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "isDynamicRam":
			err = unpopulate(val, "IsDynamicRAM", &h.IsDynamicRAM)
			delete(rawMsg, key)
		case "lastRecoveryPointId":
			err = unpopulate(val, "LastRecoveryPointID", &h.LastRecoveryPointID)
			delete(rawMsg, key)
		case "lastRecoveryPointReceived":
			err = unpopulateDateTimeRFC3339(val, "LastRecoveryPointReceived", &h.LastRecoveryPointReceived)
			delete(rawMsg, key)
		case "lastReplicationUpdateTime":
			err = unpopulateDateTimeRFC3339(val, "LastReplicationUpdateTime", &h.LastReplicationUpdateTime)
			delete(rawMsg, key)
		case "nicsToInclude":
			err = unpopulate(val, "NicsToInclude", &h.NicsToInclude)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &h.OSName)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &h.OSType)
			delete(rawMsg, key)
		case "protectedDisks":
			err = unpopulate(val, "ProtectedDisks", &h.ProtectedDisks)
			delete(rawMsg, key)
		case "protectedNics":
			err = unpopulate(val, "ProtectedNics", &h.ProtectedNics)
			delete(rawMsg, key)
		case "resyncProgressPercentage":
			err = unpopulate(val, "ResyncProgressPercentage", &h.ResyncProgressPercentage)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &h.RunAsAccountID)
			delete(rawMsg, key)
		case "sourceApplianceName":
			err = unpopulate(val, "SourceApplianceName", &h.SourceApplianceName)
			delete(rawMsg, key)
		case "sourceCpuCores":
			err = unpopulate(val, "SourceCPUCores", &h.SourceCPUCores)
			delete(rawMsg, key)
		case "sourceDraName":
			err = unpopulate(val, "SourceDraName", &h.SourceDraName)
			delete(rawMsg, key)
		case "sourceMemoryInMegaBytes":
			err = unpopulate(val, "SourceMemoryInMegaBytes", &h.SourceMemoryInMegaBytes)
			delete(rawMsg, key)
		case "sourceVmName":
			err = unpopulate(val, "SourceVMName", &h.SourceVMName)
			delete(rawMsg, key)
		case "storageContainerId":
			err = unpopulate(val, "StorageContainerID", &h.StorageContainerID)
			delete(rawMsg, key)
		case "targetApplianceName":
			err = unpopulate(val, "TargetApplianceName", &h.TargetApplianceName)
			delete(rawMsg, key)
		case "targetArcClusterCustomLocationId":
			err = unpopulate(val, "TargetArcClusterCustomLocationID", &h.TargetArcClusterCustomLocationID)
			delete(rawMsg, key)
		case "targetAzStackHciClusterName":
			err = unpopulate(val, "TargetAzStackHciClusterName", &h.TargetAzStackHciClusterName)
			delete(rawMsg, key)
		case "targetCpuCores":
			err = unpopulate(val, "TargetCPUCores", &h.TargetCPUCores)
			delete(rawMsg, key)
		case "targetDraName":
			err = unpopulate(val, "TargetDraName", &h.TargetDraName)
			delete(rawMsg, key)
		case "targetHciClusterId":
			err = unpopulate(val, "TargetHciClusterID", &h.TargetHciClusterID)
			delete(rawMsg, key)
		case "targetLocation":
			err = unpopulate(val, "TargetLocation", &h.TargetLocation)
			delete(rawMsg, key)
		case "targetMemoryInMegaBytes":
			err = unpopulate(val, "TargetMemoryInMegaBytes", &h.TargetMemoryInMegaBytes)
			delete(rawMsg, key)
		case "targetNetworkId":
			err = unpopulate(val, "TargetNetworkID", &h.TargetNetworkID)
			delete(rawMsg, key)
		case "targetResourceGroupId":
			err = unpopulate(val, "TargetResourceGroupID", &h.TargetResourceGroupID)
			delete(rawMsg, key)
		case "targetVmBiosId":
			err = unpopulate(val, "TargetVMBiosID", &h.TargetVMBiosID)
			delete(rawMsg, key)
		case "targetVmName":
			err = unpopulate(val, "TargetVMName", &h.TargetVMName)
			delete(rawMsg, key)
		case "testNetworkId":
			err = unpopulate(val, "TestNetworkID", &h.TestNetworkID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVToAzStackHCIProtectedNicProperties.
func (h HyperVToAzStackHCIProtectedNicProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "macAddress", h.MacAddress)
	populate(objectMap, "networkName", h.NetworkName)
	populate(objectMap, "nicId", h.NicID)
	populate(objectMap, "selectionTypeForFailover", h.SelectionTypeForFailover)
	populate(objectMap, "targetNetworkId", h.TargetNetworkID)
	populate(objectMap, "testNetworkId", h.TestNetworkID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVToAzStackHCIProtectedNicProperties.
func (h *HyperVToAzStackHCIProtectedNicProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "macAddress":
			err = unpopulate(val, "MacAddress", &h.MacAddress)
			delete(rawMsg, key)
		case "networkName":
			err = unpopulate(val, "NetworkName", &h.NetworkName)
			delete(rawMsg, key)
		case "nicId":
			err = unpopulate(val, "NicID", &h.NicID)
			delete(rawMsg, key)
		case "selectionTypeForFailover":
			err = unpopulate(val, "SelectionTypeForFailover", &h.SelectionTypeForFailover)
			delete(rawMsg, key)
		case "targetNetworkId":
			err = unpopulate(val, "TargetNetworkID", &h.TargetNetworkID)
			delete(rawMsg, key)
		case "testNetworkId":
			err = unpopulate(val, "TestNetworkID", &h.TestNetworkID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVToAzStackHCIRecoveryPointModelCustomProperties.
func (h HyperVToAzStackHCIRecoveryPointModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskIds", h.DiskIDs)
	objectMap["instanceType"] = "HyperVToAzStackHCI"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVToAzStackHCIRecoveryPointModelCustomProperties.
func (h *HyperVToAzStackHCIRecoveryPointModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskIds":
			err = unpopulate(val, "DiskIDs", &h.DiskIDs)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HyperVToAzStackHCIReplicationExtensionModelCustomProperties.
func (h HyperVToAzStackHCIReplicationExtensionModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "asrServiceUri", h.AsrServiceURI)
	populate(objectMap, "azStackHciFabricArmId", h.AzStackHciFabricArmID)
	populate(objectMap, "azStackHciSiteId", h.AzStackHciSiteID)
	populate(objectMap, "gatewayServiceUri", h.GatewayServiceURI)
	populate(objectMap, "hyperVFabricArmId", h.HyperVFabricArmID)
	populate(objectMap, "hyperVSiteId", h.HyperVSiteID)
	objectMap["instanceType"] = "HyperVToAzStackHCI"
	populate(objectMap, "rcmServiceUri", h.RcmServiceURI)
	populate(objectMap, "resourceGroup", h.ResourceGroup)
	populate(objectMap, "resourceLocation", h.ResourceLocation)
	populate(objectMap, "sourceGatewayServiceId", h.SourceGatewayServiceID)
	populate(objectMap, "sourceStorageContainerName", h.SourceStorageContainerName)
	populate(objectMap, "storageAccountId", h.StorageAccountID)
	populate(objectMap, "storageAccountSasSecretName", h.StorageAccountSasSecretName)
	populate(objectMap, "subscriptionId", h.SubscriptionID)
	populate(objectMap, "targetGatewayServiceId", h.TargetGatewayServiceID)
	populate(objectMap, "targetStorageContainerName", h.TargetStorageContainerName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HyperVToAzStackHCIReplicationExtensionModelCustomProperties.
func (h *HyperVToAzStackHCIReplicationExtensionModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "asrServiceUri":
			err = unpopulate(val, "AsrServiceURI", &h.AsrServiceURI)
			delete(rawMsg, key)
		case "azStackHciFabricArmId":
			err = unpopulate(val, "AzStackHciFabricArmID", &h.AzStackHciFabricArmID)
			delete(rawMsg, key)
		case "azStackHciSiteId":
			err = unpopulate(val, "AzStackHciSiteID", &h.AzStackHciSiteID)
			delete(rawMsg, key)
		case "gatewayServiceUri":
			err = unpopulate(val, "GatewayServiceURI", &h.GatewayServiceURI)
			delete(rawMsg, key)
		case "hyperVFabricArmId":
			err = unpopulate(val, "HyperVFabricArmID", &h.HyperVFabricArmID)
			delete(rawMsg, key)
		case "hyperVSiteId":
			err = unpopulate(val, "HyperVSiteID", &h.HyperVSiteID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &h.InstanceType)
			delete(rawMsg, key)
		case "rcmServiceUri":
			err = unpopulate(val, "RcmServiceURI", &h.RcmServiceURI)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &h.ResourceGroup)
			delete(rawMsg, key)
		case "resourceLocation":
			err = unpopulate(val, "ResourceLocation", &h.ResourceLocation)
			delete(rawMsg, key)
		case "sourceGatewayServiceId":
			err = unpopulate(val, "SourceGatewayServiceID", &h.SourceGatewayServiceID)
			delete(rawMsg, key)
		case "sourceStorageContainerName":
			err = unpopulate(val, "SourceStorageContainerName", &h.SourceStorageContainerName)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &h.StorageAccountID)
			delete(rawMsg, key)
		case "storageAccountSasSecretName":
			err = unpopulate(val, "StorageAccountSasSecretName", &h.StorageAccountSasSecretName)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &h.SubscriptionID)
			delete(rawMsg, key)
		case "targetGatewayServiceId":
			err = unpopulate(val, "TargetGatewayServiceID", &h.TargetGatewayServiceID)
			delete(rawMsg, key)
		case "targetStorageContainerName":
			err = unpopulate(val, "TargetStorageContainerName", &h.TargetStorageContainerName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IdentityModel.
func (i IdentityModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aadAuthority", i.AADAuthority)
	populate(objectMap, "applicationId", i.ApplicationID)
	populate(objectMap, "audience", i.Audience)
	populate(objectMap, "objectId", i.ObjectID)
	populate(objectMap, "tenantId", i.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IdentityModel.
func (i *IdentityModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aadAuthority":
			err = unpopulate(val, "AADAuthority", &i.AADAuthority)
			delete(rawMsg, key)
		case "applicationId":
			err = unpopulate(val, "ApplicationID", &i.ApplicationID)
			delete(rawMsg, key)
		case "audience":
			err = unpopulate(val, "Audience", &i.Audience)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &i.ObjectID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &i.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type InnerHealthErrorModel.
func (i InnerHealthErrorModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", i.Category)
	populate(objectMap, "causes", i.Causes)
	populate(objectMap, "code", i.Code)
	populateDateTimeRFC3339(objectMap, "creationTime", i.CreationTime)
	populate(objectMap, "healthCategory", i.HealthCategory)
	populate(objectMap, "isCustomerResolvable", i.IsCustomerResolvable)
	populate(objectMap, "message", i.Message)
	populate(objectMap, "recommendation", i.Recommendation)
	populate(objectMap, "severity", i.Severity)
	populate(objectMap, "source", i.Source)
	populate(objectMap, "summary", i.Summary)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type InnerHealthErrorModel.
func (i *InnerHealthErrorModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &i.Category)
			delete(rawMsg, key)
		case "causes":
			err = unpopulate(val, "Causes", &i.Causes)
			delete(rawMsg, key)
		case "code":
			err = unpopulate(val, "Code", &i.Code)
			delete(rawMsg, key)
		case "creationTime":
			err = unpopulateDateTimeRFC3339(val, "CreationTime", &i.CreationTime)
			delete(rawMsg, key)
		case "healthCategory":
			err = unpopulate(val, "HealthCategory", &i.HealthCategory)
			delete(rawMsg, key)
		case "isCustomerResolvable":
			err = unpopulate(val, "IsCustomerResolvable", &i.IsCustomerResolvable)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &i.Message)
			delete(rawMsg, key)
		case "recommendation":
			err = unpopulate(val, "Recommendation", &i.Recommendation)
			delete(rawMsg, key)
		case "severity":
			err = unpopulate(val, "Severity", &i.Severity)
			delete(rawMsg, key)
		case "source":
			err = unpopulate(val, "Source", &i.Source)
			delete(rawMsg, key)
		case "summary":
			err = unpopulate(val, "Summary", &i.Summary)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionType", o.ActionType)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &o.ActionType)
			delete(rawMsg, key)
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationStatus.
func (o OperationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endTime", o.EndTime)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "startTime", o.StartTime)
	populate(objectMap, "status", o.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationStatus.
func (o *OperationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endTime":
			err = unpopulate(val, "EndTime", &o.EndTime)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &o.StartTime)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &o.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlannedFailoverModel.
func (p PlannedFailoverModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "properties", p.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlannedFailoverModel.
func (p *PlannedFailoverModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlannedFailoverModelCustomProperties.
func (p PlannedFailoverModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = p.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlannedFailoverModelCustomProperties.
func (p *PlannedFailoverModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &p.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PlannedFailoverModelProperties.
func (p PlannedFailoverModelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customProperties", p.CustomProperties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PlannedFailoverModelProperties.
func (p *PlannedFailoverModelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customProperties":
			p.CustomProperties, err = unmarshalPlannedFailoverModelCustomPropertiesClassification(val)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyModel.
func (p PolicyModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyModel.
func (p *PolicyModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyModelCollection.
func (p PolicyModelCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyModelCollection.
func (p *PolicyModelCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyModelCustomProperties.
func (p PolicyModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = p.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyModelCustomProperties.
func (p *PolicyModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &p.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyModelProperties.
func (p PolicyModelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customProperties", p.CustomProperties)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyModelProperties.
func (p *PolicyModelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customProperties":
			p.CustomProperties, err = unmarshalPolicyModelCustomPropertiesClassification(val)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PolicyModelSystemData.
func (p PolicyModelSystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", p.CreatedAt)
	populate(objectMap, "createdBy", p.CreatedBy)
	populate(objectMap, "createdByType", p.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", p.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", p.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", p.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PolicyModelSystemData.
func (p *PolicyModelSystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &p.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &p.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &p.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &p.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &p.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &p.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectedItemDynamicMemoryConfig.
func (p ProtectedItemDynamicMemoryConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maximumMemoryInMegaBytes", p.MaximumMemoryInMegaBytes)
	populate(objectMap, "minimumMemoryInMegaBytes", p.MinimumMemoryInMegaBytes)
	populate(objectMap, "targetMemoryBufferPercentage", p.TargetMemoryBufferPercentage)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectedItemDynamicMemoryConfig.
func (p *ProtectedItemDynamicMemoryConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maximumMemoryInMegaBytes":
			err = unpopulate(val, "MaximumMemoryInMegaBytes", &p.MaximumMemoryInMegaBytes)
			delete(rawMsg, key)
		case "minimumMemoryInMegaBytes":
			err = unpopulate(val, "MinimumMemoryInMegaBytes", &p.MinimumMemoryInMegaBytes)
			delete(rawMsg, key)
		case "targetMemoryBufferPercentage":
			err = unpopulate(val, "TargetMemoryBufferPercentage", &p.TargetMemoryBufferPercentage)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectedItemModel.
func (p ProtectedItemModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectedItemModel.
func (p *ProtectedItemModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectedItemModelCollection.
func (p ProtectedItemModelCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectedItemModelCollection.
func (p *ProtectedItemModelCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectedItemModelCustomProperties.
func (p ProtectedItemModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = p.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectedItemModelCustomProperties.
func (p *ProtectedItemModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &p.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectedItemModelProperties.
func (p ProtectedItemModelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedJobs", p.AllowedJobs)
	populate(objectMap, "correlationId", p.CorrelationID)
	populate(objectMap, "currentJob", p.CurrentJob)
	populate(objectMap, "customProperties", p.CustomProperties)
	populate(objectMap, "draId", p.DraID)
	populate(objectMap, "fabricId", p.FabricID)
	populate(objectMap, "fabricObjectId", p.FabricObjectID)
	populate(objectMap, "fabricObjectName", p.FabricObjectName)
	populate(objectMap, "healthErrors", p.HealthErrors)
	populate(objectMap, "lastFailedEnableProtectionJob", p.LastFailedEnableProtectionJob)
	populate(objectMap, "lastFailedPlannedFailoverJob", p.LastFailedPlannedFailoverJob)
	populateDateTimeRFC3339(objectMap, "lastSuccessfulPlannedFailoverTime", p.LastSuccessfulPlannedFailoverTime)
	populateDateTimeRFC3339(objectMap, "lastSuccessfulTestFailoverTime", p.LastSuccessfulTestFailoverTime)
	populateDateTimeRFC3339(objectMap, "lastSuccessfulUnplannedFailoverTime", p.LastSuccessfulUnplannedFailoverTime)
	populate(objectMap, "lastTestFailoverJob", p.LastTestFailoverJob)
	populate(objectMap, "policyName", p.PolicyName)
	populate(objectMap, "protectionState", p.ProtectionState)
	populate(objectMap, "protectionStateDescription", p.ProtectionStateDescription)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "replicationExtensionName", p.ReplicationExtensionName)
	populate(objectMap, "replicationHealth", p.ReplicationHealth)
	populate(objectMap, "resyncRequired", p.ResyncRequired)
	populate(objectMap, "resynchronizationState", p.ResynchronizationState)
	populate(objectMap, "sourceFabricProviderId", p.SourceFabricProviderID)
	populate(objectMap, "targetDraId", p.TargetDraID)
	populate(objectMap, "targetFabricId", p.TargetFabricID)
	populate(objectMap, "targetFabricProviderId", p.TargetFabricProviderID)
	populate(objectMap, "testFailoverState", p.TestFailoverState)
	populate(objectMap, "testFailoverStateDescription", p.TestFailoverStateDescription)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectedItemModelProperties.
func (p *ProtectedItemModelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedJobs":
			err = unpopulate(val, "AllowedJobs", &p.AllowedJobs)
			delete(rawMsg, key)
		case "correlationId":
			err = unpopulate(val, "CorrelationID", &p.CorrelationID)
			delete(rawMsg, key)
		case "currentJob":
			err = unpopulate(val, "CurrentJob", &p.CurrentJob)
			delete(rawMsg, key)
		case "customProperties":
			p.CustomProperties, err = unmarshalProtectedItemModelCustomPropertiesClassification(val)
			delete(rawMsg, key)
		case "draId":
			err = unpopulate(val, "DraID", &p.DraID)
			delete(rawMsg, key)
		case "fabricId":
			err = unpopulate(val, "FabricID", &p.FabricID)
			delete(rawMsg, key)
		case "fabricObjectId":
			err = unpopulate(val, "FabricObjectID", &p.FabricObjectID)
			delete(rawMsg, key)
		case "fabricObjectName":
			err = unpopulate(val, "FabricObjectName", &p.FabricObjectName)
			delete(rawMsg, key)
		case "healthErrors":
			err = unpopulate(val, "HealthErrors", &p.HealthErrors)
			delete(rawMsg, key)
		case "lastFailedEnableProtectionJob":
			err = unpopulate(val, "LastFailedEnableProtectionJob", &p.LastFailedEnableProtectionJob)
			delete(rawMsg, key)
		case "lastFailedPlannedFailoverJob":
			err = unpopulate(val, "LastFailedPlannedFailoverJob", &p.LastFailedPlannedFailoverJob)
			delete(rawMsg, key)
		case "lastSuccessfulPlannedFailoverTime":
			err = unpopulateDateTimeRFC3339(val, "LastSuccessfulPlannedFailoverTime", &p.LastSuccessfulPlannedFailoverTime)
			delete(rawMsg, key)
		case "lastSuccessfulTestFailoverTime":
			err = unpopulateDateTimeRFC3339(val, "LastSuccessfulTestFailoverTime", &p.LastSuccessfulTestFailoverTime)
			delete(rawMsg, key)
		case "lastSuccessfulUnplannedFailoverTime":
			err = unpopulateDateTimeRFC3339(val, "LastSuccessfulUnplannedFailoverTime", &p.LastSuccessfulUnplannedFailoverTime)
			delete(rawMsg, key)
		case "lastTestFailoverJob":
			err = unpopulate(val, "LastTestFailoverJob", &p.LastTestFailoverJob)
			delete(rawMsg, key)
		case "policyName":
			err = unpopulate(val, "PolicyName", &p.PolicyName)
			delete(rawMsg, key)
		case "protectionState":
			err = unpopulate(val, "ProtectionState", &p.ProtectionState)
			delete(rawMsg, key)
		case "protectionStateDescription":
			err = unpopulate(val, "ProtectionStateDescription", &p.ProtectionStateDescription)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "replicationExtensionName":
			err = unpopulate(val, "ReplicationExtensionName", &p.ReplicationExtensionName)
			delete(rawMsg, key)
		case "replicationHealth":
			err = unpopulate(val, "ReplicationHealth", &p.ReplicationHealth)
			delete(rawMsg, key)
		case "resyncRequired":
			err = unpopulate(val, "ResyncRequired", &p.ResyncRequired)
			delete(rawMsg, key)
		case "resynchronizationState":
			err = unpopulate(val, "ResynchronizationState", &p.ResynchronizationState)
			delete(rawMsg, key)
		case "sourceFabricProviderId":
			err = unpopulate(val, "SourceFabricProviderID", &p.SourceFabricProviderID)
			delete(rawMsg, key)
		case "targetDraId":
			err = unpopulate(val, "TargetDraID", &p.TargetDraID)
			delete(rawMsg, key)
		case "targetFabricId":
			err = unpopulate(val, "TargetFabricID", &p.TargetFabricID)
			delete(rawMsg, key)
		case "targetFabricProviderId":
			err = unpopulate(val, "TargetFabricProviderID", &p.TargetFabricProviderID)
			delete(rawMsg, key)
		case "testFailoverState":
			err = unpopulate(val, "TestFailoverState", &p.TestFailoverState)
			delete(rawMsg, key)
		case "testFailoverStateDescription":
			err = unpopulate(val, "TestFailoverStateDescription", &p.TestFailoverStateDescription)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectedItemModelPropertiesCurrentJob.
func (p ProtectedItemModelPropertiesCurrentJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", p.DisplayName)
	populateDateTimeRFC3339(objectMap, "endTime", p.EndTime)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "scenarioName", p.ScenarioName)
	populateDateTimeRFC3339(objectMap, "startTime", p.StartTime)
	populate(objectMap, "state", p.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectedItemModelPropertiesCurrentJob.
func (p *ProtectedItemModelPropertiesCurrentJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &p.EndTime)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "scenarioName":
			err = unpopulate(val, "ScenarioName", &p.ScenarioName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &p.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectedItemModelPropertiesLastFailedEnableProtectionJob.
func (p ProtectedItemModelPropertiesLastFailedEnableProtectionJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", p.DisplayName)
	populateDateTimeRFC3339(objectMap, "endTime", p.EndTime)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "scenarioName", p.ScenarioName)
	populateDateTimeRFC3339(objectMap, "startTime", p.StartTime)
	populate(objectMap, "state", p.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectedItemModelPropertiesLastFailedEnableProtectionJob.
func (p *ProtectedItemModelPropertiesLastFailedEnableProtectionJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &p.EndTime)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "scenarioName":
			err = unpopulate(val, "ScenarioName", &p.ScenarioName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &p.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectedItemModelPropertiesLastFailedPlannedFailoverJob.
func (p ProtectedItemModelPropertiesLastFailedPlannedFailoverJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", p.DisplayName)
	populateDateTimeRFC3339(objectMap, "endTime", p.EndTime)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "scenarioName", p.ScenarioName)
	populateDateTimeRFC3339(objectMap, "startTime", p.StartTime)
	populate(objectMap, "state", p.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectedItemModelPropertiesLastFailedPlannedFailoverJob.
func (p *ProtectedItemModelPropertiesLastFailedPlannedFailoverJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &p.EndTime)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "scenarioName":
			err = unpopulate(val, "ScenarioName", &p.ScenarioName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &p.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectedItemModelPropertiesLastTestFailoverJob.
func (p ProtectedItemModelPropertiesLastTestFailoverJob) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "displayName", p.DisplayName)
	populateDateTimeRFC3339(objectMap, "endTime", p.EndTime)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "scenarioName", p.ScenarioName)
	populateDateTimeRFC3339(objectMap, "startTime", p.StartTime)
	populate(objectMap, "state", p.State)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectedItemModelPropertiesLastTestFailoverJob.
func (p *ProtectedItemModelPropertiesLastTestFailoverJob) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "displayName":
			err = unpopulate(val, "DisplayName", &p.DisplayName)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &p.EndTime)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "scenarioName":
			err = unpopulate(val, "ScenarioName", &p.ScenarioName)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &p.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &p.State)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProtectedItemModelSystemData.
func (p ProtectedItemModelSystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", p.CreatedAt)
	populate(objectMap, "createdBy", p.CreatedBy)
	populate(objectMap, "createdByType", p.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", p.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", p.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", p.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProtectedItemModelSystemData.
func (p *ProtectedItemModelSystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &p.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &p.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &p.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &p.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &p.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &p.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPointModel.
func (r RecoveryPointModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPointModel.
func (r *RecoveryPointModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPointModelCollection.
func (r RecoveryPointModelCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPointModelCollection.
func (r *RecoveryPointModelCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPointModelCustomProperties.
func (r RecoveryPointModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = r.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPointModelCustomProperties.
func (r *RecoveryPointModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPointModelProperties.
func (r RecoveryPointModelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customProperties", r.CustomProperties)
	populateDateTimeRFC3339(objectMap, "recoveryPointTime", r.RecoveryPointTime)
	populate(objectMap, "recoveryPointType", r.RecoveryPointType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPointModelProperties.
func (r *RecoveryPointModelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customProperties":
			r.CustomProperties, err = unmarshalRecoveryPointModelCustomPropertiesClassification(val)
			delete(rawMsg, key)
		case "recoveryPointTime":
			err = unpopulateDateTimeRFC3339(val, "RecoveryPointTime", &r.RecoveryPointTime)
			delete(rawMsg, key)
		case "recoveryPointType":
			err = unpopulate(val, "RecoveryPointType", &r.RecoveryPointType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RecoveryPointModelSystemData.
func (r RecoveryPointModelSystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", r.CreatedAt)
	populate(objectMap, "createdBy", r.CreatedBy)
	populate(objectMap, "createdByType", r.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", r.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", r.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", r.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RecoveryPointModelSystemData.
func (r *RecoveryPointModelSystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &r.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &r.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &r.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &r.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &r.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &r.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationExtensionModel.
func (r ReplicationExtensionModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "name", r.Name)
	populate(objectMap, "properties", r.Properties)
	populate(objectMap, "systemData", r.SystemData)
	populate(objectMap, "type", r.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationExtensionModel.
func (r *ReplicationExtensionModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &r.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &r.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &r.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationExtensionModelCollection.
func (r ReplicationExtensionModelCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", r.NextLink)
	populate(objectMap, "value", r.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationExtensionModelCollection.
func (r *ReplicationExtensionModelCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &r.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &r.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationExtensionModelCustomProperties.
func (r ReplicationExtensionModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = r.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationExtensionModelCustomProperties.
func (r *ReplicationExtensionModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &r.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationExtensionModelProperties.
func (r ReplicationExtensionModelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "customProperties", r.CustomProperties)
	populate(objectMap, "provisioningState", r.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationExtensionModelProperties.
func (r *ReplicationExtensionModelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "customProperties":
			r.CustomProperties, err = unmarshalReplicationExtensionModelCustomPropertiesClassification(val)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &r.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ReplicationExtensionModelSystemData.
func (r ReplicationExtensionModelSystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", r.CreatedAt)
	populate(objectMap, "createdBy", r.CreatedBy)
	populate(objectMap, "createdByType", r.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", r.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", r.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", r.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ReplicationExtensionModelSystemData.
func (r *ReplicationExtensionModelSystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &r.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &r.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &r.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &r.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &r.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &r.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type StorageContainerProperties.
func (s StorageContainerProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clusterSharedVolumePath", s.ClusterSharedVolumePath)
	populate(objectMap, "name", s.Name)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type StorageContainerProperties.
func (s *StorageContainerProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clusterSharedVolumePath":
			err = unpopulate(val, "ClusterSharedVolumePath", &s.ClusterSharedVolumePath)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TaskModel.
func (t TaskModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "childrenWorkflows", t.ChildrenWorkflows)
	populate(objectMap, "customProperties", t.CustomProperties)
	populateDateTimeRFC3339(objectMap, "endTime", t.EndTime)
	populateDateTimeRFC3339(objectMap, "startTime", t.StartTime)
	populate(objectMap, "state", t.State)
	populate(objectMap, "taskName", t.TaskName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TaskModel.
func (t *TaskModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "childrenWorkflows":
			err = unpopulate(val, "ChildrenWorkflows", &t.ChildrenWorkflows)
			delete(rawMsg, key)
		case "customProperties":
			err = unpopulate(val, "CustomProperties", &t.CustomProperties)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &t.EndTime)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &t.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &t.State)
			delete(rawMsg, key)
		case "taskName":
			err = unpopulate(val, "TaskName", &t.TaskName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TaskModelCustomProperties.
func (t TaskModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "instanceType", t.InstanceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TaskModelCustomProperties.
func (t *TaskModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &t.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestFailoverCleanupWorkflowModelCustomProperties.
func (t TestFailoverCleanupWorkflowModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "affectedObjectDetails", t.AffectedObjectDetails)
	populate(objectMap, "comments", t.Comments)
	objectMap["instanceType"] = "TestFailoverCleanupWorkflowDetails"
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestFailoverCleanupWorkflowModelCustomProperties.
func (t *TestFailoverCleanupWorkflowModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectDetails":
			err = unpopulate(val, "AffectedObjectDetails", &t.AffectedObjectDetails)
			delete(rawMsg, key)
		case "comments":
			err = unpopulate(val, "Comments", &t.Comments)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &t.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TestFailoverWorkflowModelCustomProperties.
func (t TestFailoverWorkflowModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "affectedObjectDetails", t.AffectedObjectDetails)
	objectMap["instanceType"] = "TestFailoverWorkflowDetails"
	populate(objectMap, "protectedItemDetails", t.ProtectedItemDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TestFailoverWorkflowModelCustomProperties.
func (t *TestFailoverWorkflowModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectDetails":
			err = unpopulate(val, "AffectedObjectDetails", &t.AffectedObjectDetails)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &t.InstanceType)
			delete(rawMsg, key)
		case "protectedItemDetails":
			err = unpopulate(val, "ProtectedItemDetails", &t.ProtectedItemDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareDraModelCustomProperties.
func (v VMwareDraModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "biosId", v.BiosID)
	objectMap["instanceType"] = "VMware"
	populate(objectMap, "marsAuthenticationIdentity", v.MarsAuthenticationIdentity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareDraModelCustomProperties.
func (v *VMwareDraModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "biosId":
			err = unpopulate(val, "BiosID", &v.BiosID)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "marsAuthenticationIdentity":
			err = unpopulate(val, "MarsAuthenticationIdentity", &v.MarsAuthenticationIdentity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareMigrateFabricModelCustomProperties.
func (v VMwareMigrateFabricModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "VMwareMigrate"
	populate(objectMap, "migrationSolutionId", v.MigrationSolutionID)
	populate(objectMap, "vmwareSiteId", v.VmwareSiteID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareMigrateFabricModelCustomProperties.
func (v *VMwareMigrateFabricModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "migrationSolutionId":
			err = unpopulate(val, "MigrationSolutionID", &v.MigrationSolutionID)
			delete(rawMsg, key)
		case "vmwareSiteId":
			err = unpopulate(val, "VmwareSiteID", &v.VmwareSiteID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareToAzStackHCIDiskInput.
func (v VMwareToAzStackHCIDiskInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "diskFileFormat", v.DiskFileFormat)
	populate(objectMap, "diskId", v.DiskID)
	populate(objectMap, "diskSizeGB", v.DiskSizeGB)
	populate(objectMap, "isDynamic", v.IsDynamic)
	populate(objectMap, "isOsDisk", v.IsOsDisk)
	populate(objectMap, "storageContainerId", v.StorageContainerID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareToAzStackHCIDiskInput.
func (v *VMwareToAzStackHCIDiskInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "diskFileFormat":
			err = unpopulate(val, "DiskFileFormat", &v.DiskFileFormat)
			delete(rawMsg, key)
		case "diskId":
			err = unpopulate(val, "DiskID", &v.DiskID)
			delete(rawMsg, key)
		case "diskSizeGB":
			err = unpopulate(val, "DiskSizeGB", &v.DiskSizeGB)
			delete(rawMsg, key)
		case "isDynamic":
			err = unpopulate(val, "IsDynamic", &v.IsDynamic)
			delete(rawMsg, key)
		case "isOsDisk":
			err = unpopulate(val, "IsOsDisk", &v.IsOsDisk)
			delete(rawMsg, key)
		case "storageContainerId":
			err = unpopulate(val, "StorageContainerID", &v.StorageContainerID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareToAzStackHCINicInput.
func (v VMwareToAzStackHCINicInput) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "label", v.Label)
	populate(objectMap, "networkName", v.NetworkName)
	populate(objectMap, "nicId", v.NicID)
	populate(objectMap, "selectionTypeForFailover", v.SelectionTypeForFailover)
	populate(objectMap, "targetNetworkId", v.TargetNetworkID)
	populate(objectMap, "testNetworkId", v.TestNetworkID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareToAzStackHCINicInput.
func (v *VMwareToAzStackHCINicInput) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "label":
			err = unpopulate(val, "Label", &v.Label)
			delete(rawMsg, key)
		case "networkName":
			err = unpopulate(val, "NetworkName", &v.NetworkName)
			delete(rawMsg, key)
		case "nicId":
			err = unpopulate(val, "NicID", &v.NicID)
			delete(rawMsg, key)
		case "selectionTypeForFailover":
			err = unpopulate(val, "SelectionTypeForFailover", &v.SelectionTypeForFailover)
			delete(rawMsg, key)
		case "targetNetworkId":
			err = unpopulate(val, "TargetNetworkID", &v.TargetNetworkID)
			delete(rawMsg, key)
		case "testNetworkId":
			err = unpopulate(val, "TestNetworkID", &v.TestNetworkID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareToAzStackHCIPlannedFailoverModelCustomProperties.
func (v VMwareToAzStackHCIPlannedFailoverModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	objectMap["instanceType"] = "VMwareToAzStackHCI"
	populate(objectMap, "shutdownSourceVM", v.ShutdownSourceVM)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareToAzStackHCIPlannedFailoverModelCustomProperties.
func (v *VMwareToAzStackHCIPlannedFailoverModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "shutdownSourceVM":
			err = unpopulate(val, "ShutdownSourceVM", &v.ShutdownSourceVM)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareToAzStackHCIPolicyModelCustomProperties.
func (v VMwareToAzStackHCIPolicyModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "appConsistentFrequencyInMinutes", v.AppConsistentFrequencyInMinutes)
	populate(objectMap, "crashConsistentFrequencyInMinutes", v.CrashConsistentFrequencyInMinutes)
	objectMap["instanceType"] = "VMwareToAzStackHCI"
	populate(objectMap, "recoveryPointHistoryInMinutes", v.RecoveryPointHistoryInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareToAzStackHCIPolicyModelCustomProperties.
func (v *VMwareToAzStackHCIPolicyModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "appConsistentFrequencyInMinutes":
			err = unpopulate(val, "AppConsistentFrequencyInMinutes", &v.AppConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "crashConsistentFrequencyInMinutes":
			err = unpopulate(val, "CrashConsistentFrequencyInMinutes", &v.CrashConsistentFrequencyInMinutes)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "recoveryPointHistoryInMinutes":
			err = unpopulate(val, "RecoveryPointHistoryInMinutes", &v.RecoveryPointHistoryInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareToAzStackHCIProtectedDiskProperties.
func (v VMwareToAzStackHCIProtectedDiskProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capacityInBytes", v.CapacityInBytes)
	populate(objectMap, "diskType", v.DiskType)
	populate(objectMap, "isDynamic", v.IsDynamic)
	populate(objectMap, "isOsDisk", v.IsOsDisk)
	populate(objectMap, "migrateDiskName", v.MigrateDiskName)
	populate(objectMap, "seedDiskName", v.SeedDiskName)
	populate(objectMap, "sourceDiskId", v.SourceDiskID)
	populate(objectMap, "sourceDiskName", v.SourceDiskName)
	populate(objectMap, "storageContainerId", v.StorageContainerID)
	populate(objectMap, "storageContainerLocalPath", v.StorageContainerLocalPath)
	populate(objectMap, "testMigrateDiskName", v.TestMigrateDiskName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareToAzStackHCIProtectedDiskProperties.
func (v *VMwareToAzStackHCIProtectedDiskProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capacityInBytes":
			err = unpopulate(val, "CapacityInBytes", &v.CapacityInBytes)
			delete(rawMsg, key)
		case "diskType":
			err = unpopulate(val, "DiskType", &v.DiskType)
			delete(rawMsg, key)
		case "isDynamic":
			err = unpopulate(val, "IsDynamic", &v.IsDynamic)
			delete(rawMsg, key)
		case "isOsDisk":
			err = unpopulate(val, "IsOsDisk", &v.IsOsDisk)
			delete(rawMsg, key)
		case "migrateDiskName":
			err = unpopulate(val, "MigrateDiskName", &v.MigrateDiskName)
			delete(rawMsg, key)
		case "seedDiskName":
			err = unpopulate(val, "SeedDiskName", &v.SeedDiskName)
			delete(rawMsg, key)
		case "sourceDiskId":
			err = unpopulate(val, "SourceDiskID", &v.SourceDiskID)
			delete(rawMsg, key)
		case "sourceDiskName":
			err = unpopulate(val, "SourceDiskName", &v.SourceDiskName)
			delete(rawMsg, key)
		case "storageContainerId":
			err = unpopulate(val, "StorageContainerID", &v.StorageContainerID)
			delete(rawMsg, key)
		case "storageContainerLocalPath":
			err = unpopulate(val, "StorageContainerLocalPath", &v.StorageContainerLocalPath)
			delete(rawMsg, key)
		case "testMigrateDiskName":
			err = unpopulate(val, "TestMigrateDiskName", &v.TestMigrateDiskName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareToAzStackHCIProtectedItemModelCustomProperties.
func (v VMwareToAzStackHCIProtectedItemModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activeLocation", v.ActiveLocation)
	populate(objectMap, "customLocationRegion", v.CustomLocationRegion)
	populate(objectMap, "disksToInclude", v.DisksToInclude)
	populate(objectMap, "dynamicMemoryConfig", v.DynamicMemoryConfig)
	populate(objectMap, "fabricDiscoveryMachineId", v.FabricDiscoveryMachineID)
	populate(objectMap, "failoverRecoveryPointId", v.FailoverRecoveryPointID)
	populate(objectMap, "firmwareType", v.FirmwareType)
	populate(objectMap, "hyperVGeneration", v.HyperVGeneration)
	populate(objectMap, "initialReplicationProgressPercentage", v.InitialReplicationProgressPercentage)
	objectMap["instanceType"] = "VMwareToAzStackHCI"
	populate(objectMap, "isDynamicRam", v.IsDynamicRAM)
	populate(objectMap, "lastRecoveryPointId", v.LastRecoveryPointID)
	populateDateTimeRFC3339(objectMap, "lastRecoveryPointReceived", v.LastRecoveryPointReceived)
	populateDateTimeRFC3339(objectMap, "lastReplicationUpdateTime", v.LastReplicationUpdateTime)
	populate(objectMap, "migrationProgressPercentage", v.MigrationProgressPercentage)
	populate(objectMap, "nicsToInclude", v.NicsToInclude)
	populate(objectMap, "osName", v.OSName)
	populate(objectMap, "osType", v.OSType)
	populate(objectMap, "performAutoResync", v.PerformAutoResync)
	populate(objectMap, "protectedDisks", v.ProtectedDisks)
	populate(objectMap, "protectedNics", v.ProtectedNics)
	populate(objectMap, "resumeProgressPercentage", v.ResumeProgressPercentage)
	populate(objectMap, "resumeRetryCount", v.ResumeRetryCount)
	populate(objectMap, "resyncProgressPercentage", v.ResyncProgressPercentage)
	populate(objectMap, "resyncRequired", v.ResyncRequired)
	populate(objectMap, "resyncRetryCount", v.ResyncRetryCount)
	populate(objectMap, "resyncState", v.ResyncState)
	populate(objectMap, "runAsAccountId", v.RunAsAccountID)
	populate(objectMap, "sourceApplianceName", v.SourceApplianceName)
	populate(objectMap, "sourceCpuCores", v.SourceCPUCores)
	populate(objectMap, "sourceDraName", v.SourceDraName)
	populate(objectMap, "sourceMemoryInMegaBytes", v.SourceMemoryInMegaBytes)
	populate(objectMap, "sourceVmName", v.SourceVMName)
	populate(objectMap, "storageContainerId", v.StorageContainerID)
	populate(objectMap, "targetApplianceName", v.TargetApplianceName)
	populate(objectMap, "targetArcClusterCustomLocationId", v.TargetArcClusterCustomLocationID)
	populate(objectMap, "targetAzStackHciClusterName", v.TargetAzStackHciClusterName)
	populate(objectMap, "targetCpuCores", v.TargetCPUCores)
	populate(objectMap, "targetDraName", v.TargetDraName)
	populate(objectMap, "targetHciClusterId", v.TargetHciClusterID)
	populate(objectMap, "targetLocation", v.TargetLocation)
	populate(objectMap, "targetMemoryInMegaBytes", v.TargetMemoryInMegaBytes)
	populate(objectMap, "targetNetworkId", v.TargetNetworkID)
	populate(objectMap, "targetResourceGroupId", v.TargetResourceGroupID)
	populate(objectMap, "targetVmBiosId", v.TargetVMBiosID)
	populate(objectMap, "targetVmName", v.TargetVMName)
	populate(objectMap, "testNetworkId", v.TestNetworkID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareToAzStackHCIProtectedItemModelCustomProperties.
func (v *VMwareToAzStackHCIProtectedItemModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activeLocation":
			err = unpopulate(val, "ActiveLocation", &v.ActiveLocation)
			delete(rawMsg, key)
		case "customLocationRegion":
			err = unpopulate(val, "CustomLocationRegion", &v.CustomLocationRegion)
			delete(rawMsg, key)
		case "disksToInclude":
			err = unpopulate(val, "DisksToInclude", &v.DisksToInclude)
			delete(rawMsg, key)
		case "dynamicMemoryConfig":
			err = unpopulate(val, "DynamicMemoryConfig", &v.DynamicMemoryConfig)
			delete(rawMsg, key)
		case "fabricDiscoveryMachineId":
			err = unpopulate(val, "FabricDiscoveryMachineID", &v.FabricDiscoveryMachineID)
			delete(rawMsg, key)
		case "failoverRecoveryPointId":
			err = unpopulate(val, "FailoverRecoveryPointID", &v.FailoverRecoveryPointID)
			delete(rawMsg, key)
		case "firmwareType":
			err = unpopulate(val, "FirmwareType", &v.FirmwareType)
			delete(rawMsg, key)
		case "hyperVGeneration":
			err = unpopulate(val, "HyperVGeneration", &v.HyperVGeneration)
			delete(rawMsg, key)
		case "initialReplicationProgressPercentage":
			err = unpopulate(val, "InitialReplicationProgressPercentage", &v.InitialReplicationProgressPercentage)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "isDynamicRam":
			err = unpopulate(val, "IsDynamicRAM", &v.IsDynamicRAM)
			delete(rawMsg, key)
		case "lastRecoveryPointId":
			err = unpopulate(val, "LastRecoveryPointID", &v.LastRecoveryPointID)
			delete(rawMsg, key)
		case "lastRecoveryPointReceived":
			err = unpopulateDateTimeRFC3339(val, "LastRecoveryPointReceived", &v.LastRecoveryPointReceived)
			delete(rawMsg, key)
		case "lastReplicationUpdateTime":
			err = unpopulateDateTimeRFC3339(val, "LastReplicationUpdateTime", &v.LastReplicationUpdateTime)
			delete(rawMsg, key)
		case "migrationProgressPercentage":
			err = unpopulate(val, "MigrationProgressPercentage", &v.MigrationProgressPercentage)
			delete(rawMsg, key)
		case "nicsToInclude":
			err = unpopulate(val, "NicsToInclude", &v.NicsToInclude)
			delete(rawMsg, key)
		case "osName":
			err = unpopulate(val, "OSName", &v.OSName)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &v.OSType)
			delete(rawMsg, key)
		case "performAutoResync":
			err = unpopulate(val, "PerformAutoResync", &v.PerformAutoResync)
			delete(rawMsg, key)
		case "protectedDisks":
			err = unpopulate(val, "ProtectedDisks", &v.ProtectedDisks)
			delete(rawMsg, key)
		case "protectedNics":
			err = unpopulate(val, "ProtectedNics", &v.ProtectedNics)
			delete(rawMsg, key)
		case "resumeProgressPercentage":
			err = unpopulate(val, "ResumeProgressPercentage", &v.ResumeProgressPercentage)
			delete(rawMsg, key)
		case "resumeRetryCount":
			err = unpopulate(val, "ResumeRetryCount", &v.ResumeRetryCount)
			delete(rawMsg, key)
		case "resyncProgressPercentage":
			err = unpopulate(val, "ResyncProgressPercentage", &v.ResyncProgressPercentage)
			delete(rawMsg, key)
		case "resyncRequired":
			err = unpopulate(val, "ResyncRequired", &v.ResyncRequired)
			delete(rawMsg, key)
		case "resyncRetryCount":
			err = unpopulate(val, "ResyncRetryCount", &v.ResyncRetryCount)
			delete(rawMsg, key)
		case "resyncState":
			err = unpopulate(val, "ResyncState", &v.ResyncState)
			delete(rawMsg, key)
		case "runAsAccountId":
			err = unpopulate(val, "RunAsAccountID", &v.RunAsAccountID)
			delete(rawMsg, key)
		case "sourceApplianceName":
			err = unpopulate(val, "SourceApplianceName", &v.SourceApplianceName)
			delete(rawMsg, key)
		case "sourceCpuCores":
			err = unpopulate(val, "SourceCPUCores", &v.SourceCPUCores)
			delete(rawMsg, key)
		case "sourceDraName":
			err = unpopulate(val, "SourceDraName", &v.SourceDraName)
			delete(rawMsg, key)
		case "sourceMemoryInMegaBytes":
			err = unpopulate(val, "SourceMemoryInMegaBytes", &v.SourceMemoryInMegaBytes)
			delete(rawMsg, key)
		case "sourceVmName":
			err = unpopulate(val, "SourceVMName", &v.SourceVMName)
			delete(rawMsg, key)
		case "storageContainerId":
			err = unpopulate(val, "StorageContainerID", &v.StorageContainerID)
			delete(rawMsg, key)
		case "targetApplianceName":
			err = unpopulate(val, "TargetApplianceName", &v.TargetApplianceName)
			delete(rawMsg, key)
		case "targetArcClusterCustomLocationId":
			err = unpopulate(val, "TargetArcClusterCustomLocationID", &v.TargetArcClusterCustomLocationID)
			delete(rawMsg, key)
		case "targetAzStackHciClusterName":
			err = unpopulate(val, "TargetAzStackHciClusterName", &v.TargetAzStackHciClusterName)
			delete(rawMsg, key)
		case "targetCpuCores":
			err = unpopulate(val, "TargetCPUCores", &v.TargetCPUCores)
			delete(rawMsg, key)
		case "targetDraName":
			err = unpopulate(val, "TargetDraName", &v.TargetDraName)
			delete(rawMsg, key)
		case "targetHciClusterId":
			err = unpopulate(val, "TargetHciClusterID", &v.TargetHciClusterID)
			delete(rawMsg, key)
		case "targetLocation":
			err = unpopulate(val, "TargetLocation", &v.TargetLocation)
			delete(rawMsg, key)
		case "targetMemoryInMegaBytes":
			err = unpopulate(val, "TargetMemoryInMegaBytes", &v.TargetMemoryInMegaBytes)
			delete(rawMsg, key)
		case "targetNetworkId":
			err = unpopulate(val, "TargetNetworkID", &v.TargetNetworkID)
			delete(rawMsg, key)
		case "targetResourceGroupId":
			err = unpopulate(val, "TargetResourceGroupID", &v.TargetResourceGroupID)
			delete(rawMsg, key)
		case "targetVmBiosId":
			err = unpopulate(val, "TargetVMBiosID", &v.TargetVMBiosID)
			delete(rawMsg, key)
		case "targetVmName":
			err = unpopulate(val, "TargetVMName", &v.TargetVMName)
			delete(rawMsg, key)
		case "testNetworkId":
			err = unpopulate(val, "TestNetworkID", &v.TestNetworkID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareToAzStackHCIProtectedNicProperties.
func (v VMwareToAzStackHCIProtectedNicProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isPrimaryNic", v.IsPrimaryNic)
	populate(objectMap, "label", v.Label)
	populate(objectMap, "macAddress", v.MacAddress)
	populate(objectMap, "networkName", v.NetworkName)
	populate(objectMap, "nicId", v.NicID)
	populate(objectMap, "selectionTypeForFailover", v.SelectionTypeForFailover)
	populate(objectMap, "targetNetworkId", v.TargetNetworkID)
	populate(objectMap, "testNetworkId", v.TestNetworkID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareToAzStackHCIProtectedNicProperties.
func (v *VMwareToAzStackHCIProtectedNicProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isPrimaryNic":
			err = unpopulate(val, "IsPrimaryNic", &v.IsPrimaryNic)
			delete(rawMsg, key)
		case "label":
			err = unpopulate(val, "Label", &v.Label)
			delete(rawMsg, key)
		case "macAddress":
			err = unpopulate(val, "MacAddress", &v.MacAddress)
			delete(rawMsg, key)
		case "networkName":
			err = unpopulate(val, "NetworkName", &v.NetworkName)
			delete(rawMsg, key)
		case "nicId":
			err = unpopulate(val, "NicID", &v.NicID)
			delete(rawMsg, key)
		case "selectionTypeForFailover":
			err = unpopulate(val, "SelectionTypeForFailover", &v.SelectionTypeForFailover)
			delete(rawMsg, key)
		case "targetNetworkId":
			err = unpopulate(val, "TargetNetworkID", &v.TargetNetworkID)
			delete(rawMsg, key)
		case "testNetworkId":
			err = unpopulate(val, "TestNetworkID", &v.TestNetworkID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMwareToAzStackHCIReplicationExtensionModelCustomProperties.
func (v VMwareToAzStackHCIReplicationExtensionModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "asrServiceUri", v.AsrServiceURI)
	populate(objectMap, "azStackHciFabricArmId", v.AzStackHciFabricArmID)
	populate(objectMap, "azStackHciSiteId", v.AzStackHciSiteID)
	populate(objectMap, "gatewayServiceUri", v.GatewayServiceURI)
	objectMap["instanceType"] = "VMwareToAzStackHCI"
	populate(objectMap, "rcmServiceUri", v.RcmServiceURI)
	populate(objectMap, "resourceGroup", v.ResourceGroup)
	populate(objectMap, "resourceLocation", v.ResourceLocation)
	populate(objectMap, "sourceGatewayServiceId", v.SourceGatewayServiceID)
	populate(objectMap, "sourceStorageContainerName", v.SourceStorageContainerName)
	populate(objectMap, "storageAccountId", v.StorageAccountID)
	populate(objectMap, "storageAccountSasSecretName", v.StorageAccountSasSecretName)
	populate(objectMap, "subscriptionId", v.SubscriptionID)
	populate(objectMap, "targetGatewayServiceId", v.TargetGatewayServiceID)
	populate(objectMap, "targetStorageContainerName", v.TargetStorageContainerName)
	populate(objectMap, "vmwareFabricArmId", v.VmwareFabricArmID)
	populate(objectMap, "vmwareSiteId", v.VmwareSiteID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMwareToAzStackHCIReplicationExtensionModelCustomProperties.
func (v *VMwareToAzStackHCIReplicationExtensionModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "asrServiceUri":
			err = unpopulate(val, "AsrServiceURI", &v.AsrServiceURI)
			delete(rawMsg, key)
		case "azStackHciFabricArmId":
			err = unpopulate(val, "AzStackHciFabricArmID", &v.AzStackHciFabricArmID)
			delete(rawMsg, key)
		case "azStackHciSiteId":
			err = unpopulate(val, "AzStackHciSiteID", &v.AzStackHciSiteID)
			delete(rawMsg, key)
		case "gatewayServiceUri":
			err = unpopulate(val, "GatewayServiceURI", &v.GatewayServiceURI)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &v.InstanceType)
			delete(rawMsg, key)
		case "rcmServiceUri":
			err = unpopulate(val, "RcmServiceURI", &v.RcmServiceURI)
			delete(rawMsg, key)
		case "resourceGroup":
			err = unpopulate(val, "ResourceGroup", &v.ResourceGroup)
			delete(rawMsg, key)
		case "resourceLocation":
			err = unpopulate(val, "ResourceLocation", &v.ResourceLocation)
			delete(rawMsg, key)
		case "sourceGatewayServiceId":
			err = unpopulate(val, "SourceGatewayServiceID", &v.SourceGatewayServiceID)
			delete(rawMsg, key)
		case "sourceStorageContainerName":
			err = unpopulate(val, "SourceStorageContainerName", &v.SourceStorageContainerName)
			delete(rawMsg, key)
		case "storageAccountId":
			err = unpopulate(val, "StorageAccountID", &v.StorageAccountID)
			delete(rawMsg, key)
		case "storageAccountSasSecretName":
			err = unpopulate(val, "StorageAccountSasSecretName", &v.StorageAccountSasSecretName)
			delete(rawMsg, key)
		case "subscriptionId":
			err = unpopulate(val, "SubscriptionID", &v.SubscriptionID)
			delete(rawMsg, key)
		case "targetGatewayServiceId":
			err = unpopulate(val, "TargetGatewayServiceID", &v.TargetGatewayServiceID)
			delete(rawMsg, key)
		case "targetStorageContainerName":
			err = unpopulate(val, "TargetStorageContainerName", &v.TargetStorageContainerName)
			delete(rawMsg, key)
		case "vmwareFabricArmId":
			err = unpopulate(val, "VmwareFabricArmID", &v.VmwareFabricArmID)
			delete(rawMsg, key)
		case "vmwareSiteId":
			err = unpopulate(val, "VmwareSiteID", &v.VmwareSiteID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaultModel.
func (v VaultModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "systemData", v.SystemData)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VaultModel.
func (v *VaultModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &v.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaultModelCollection.
func (v VaultModelCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VaultModelCollection.
func (v *VaultModelCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaultModelProperties.
func (v VaultModelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "serviceResourceId", v.ServiceResourceID)
	populate(objectMap, "vaultType", v.VaultType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VaultModelProperties.
func (v *VaultModelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "serviceResourceId":
			err = unpopulate(val, "ServiceResourceID", &v.ServiceResourceID)
			delete(rawMsg, key)
		case "vaultType":
			err = unpopulate(val, "VaultType", &v.VaultType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaultModelSystemData.
func (v VaultModelSystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", v.CreatedAt)
	populate(objectMap, "createdBy", v.CreatedBy)
	populate(objectMap, "createdByType", v.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", v.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", v.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", v.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VaultModelSystemData.
func (v *VaultModelSystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &v.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &v.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &v.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &v.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &v.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &v.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaultModelUpdate.
func (v VaultModelUpdate) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "systemData", v.SystemData)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VaultModelUpdate.
func (v *VaultModelUpdate) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &v.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VaultModelUpdateSystemData.
func (v VaultModelUpdateSystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", v.CreatedAt)
	populate(objectMap, "createdBy", v.CreatedBy)
	populate(objectMap, "createdByType", v.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", v.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", v.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", v.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VaultModelUpdateSystemData.
func (v *VaultModelUpdateSystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &v.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &v.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &v.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &v.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &v.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &v.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowModel.
func (w WorkflowModel) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", w.ID)
	populate(objectMap, "name", w.Name)
	populate(objectMap, "properties", w.Properties)
	populate(objectMap, "systemData", w.SystemData)
	populate(objectMap, "type", w.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowModel.
func (w *WorkflowModel) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &w.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &w.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &w.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &w.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &w.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowModelCollection.
func (w WorkflowModelCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", w.NextLink)
	populate(objectMap, "value", w.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowModelCollection.
func (w *WorkflowModelCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &w.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &w.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowModelCustomProperties.
func (w WorkflowModelCustomProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "affectedObjectDetails", w.AffectedObjectDetails)
	objectMap["instanceType"] = w.InstanceType
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowModelCustomProperties.
func (w *WorkflowModelCustomProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "affectedObjectDetails":
			err = unpopulate(val, "AffectedObjectDetails", &w.AffectedObjectDetails)
			delete(rawMsg, key)
		case "instanceType":
			err = unpopulate(val, "InstanceType", &w.InstanceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowModelProperties.
func (w WorkflowModelProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "activityId", w.ActivityID)
	populate(objectMap, "allowedActions", w.AllowedActions)
	populate(objectMap, "customProperties", w.CustomProperties)
	populate(objectMap, "displayName", w.DisplayName)
	populateDateTimeRFC3339(objectMap, "endTime", w.EndTime)
	populate(objectMap, "errors", w.Errors)
	populate(objectMap, "objectId", w.ObjectID)
	populate(objectMap, "objectInternalId", w.ObjectInternalID)
	populate(objectMap, "objectInternalName", w.ObjectInternalName)
	populate(objectMap, "objectName", w.ObjectName)
	populate(objectMap, "objectType", w.ObjectType)
	populate(objectMap, "replicationProviderId", w.ReplicationProviderID)
	populate(objectMap, "sourceFabricProviderId", w.SourceFabricProviderID)
	populateDateTimeRFC3339(objectMap, "startTime", w.StartTime)
	populate(objectMap, "state", w.State)
	populate(objectMap, "targetFabricProviderId", w.TargetFabricProviderID)
	populate(objectMap, "tasks", w.Tasks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowModelProperties.
func (w *WorkflowModelProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "activityId":
			err = unpopulate(val, "ActivityID", &w.ActivityID)
			delete(rawMsg, key)
		case "allowedActions":
			err = unpopulate(val, "AllowedActions", &w.AllowedActions)
			delete(rawMsg, key)
		case "customProperties":
			w.CustomProperties, err = unmarshalWorkflowModelCustomPropertiesClassification(val)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &w.DisplayName)
			delete(rawMsg, key)
		case "endTime":
			err = unpopulateDateTimeRFC3339(val, "EndTime", &w.EndTime)
			delete(rawMsg, key)
		case "errors":
			err = unpopulate(val, "Errors", &w.Errors)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &w.ObjectID)
			delete(rawMsg, key)
		case "objectInternalId":
			err = unpopulate(val, "ObjectInternalID", &w.ObjectInternalID)
			delete(rawMsg, key)
		case "objectInternalName":
			err = unpopulate(val, "ObjectInternalName", &w.ObjectInternalName)
			delete(rawMsg, key)
		case "objectName":
			err = unpopulate(val, "ObjectName", &w.ObjectName)
			delete(rawMsg, key)
		case "objectType":
			err = unpopulate(val, "ObjectType", &w.ObjectType)
			delete(rawMsg, key)
		case "replicationProviderId":
			err = unpopulate(val, "ReplicationProviderID", &w.ReplicationProviderID)
			delete(rawMsg, key)
		case "sourceFabricProviderId":
			err = unpopulate(val, "SourceFabricProviderID", &w.SourceFabricProviderID)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulateDateTimeRFC3339(val, "StartTime", &w.StartTime)
			delete(rawMsg, key)
		case "state":
			err = unpopulate(val, "State", &w.State)
			delete(rawMsg, key)
		case "targetFabricProviderId":
			err = unpopulate(val, "TargetFabricProviderID", &w.TargetFabricProviderID)
			delete(rawMsg, key)
		case "tasks":
			err = unpopulate(val, "Tasks", &w.Tasks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WorkflowModelSystemData.
func (w WorkflowModelSystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", w.CreatedAt)
	populate(objectMap, "createdBy", w.CreatedBy)
	populate(objectMap, "createdByType", w.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", w.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", w.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", w.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WorkflowModelSystemData.
func (w *WorkflowModelSystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &w.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &w.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &w.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &w.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &w.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &w.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
