//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/iotsecurity/armiotsecurity"
	"net/http"
	"regexp"
)

// DefenderSettingsServer is a fake server for instances of the armiotsecurity.DefenderSettingsClient type.
type DefenderSettingsServer struct {
	// CreateOrUpdate is the fake for method DefenderSettingsClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	CreateOrUpdate func(ctx context.Context, defenderSettingsModel armiotsecurity.DefenderSettingsModel, options *armiotsecurity.DefenderSettingsClientCreateOrUpdateOptions) (resp azfake.Responder[armiotsecurity.DefenderSettingsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// Delete is the fake for method DefenderSettingsClient.Delete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	Delete func(ctx context.Context, options *armiotsecurity.DefenderSettingsClientDeleteOptions) (resp azfake.Responder[armiotsecurity.DefenderSettingsClientDeleteResponse], errResp azfake.ErrorResponder)

	// DownloadManagerActivation is the fake for method DefenderSettingsClient.DownloadManagerActivation
	// HTTP status codes to indicate success: http.StatusOK
	DownloadManagerActivation func(ctx context.Context, options *armiotsecurity.DefenderSettingsClientDownloadManagerActivationOptions) (resp azfake.Responder[armiotsecurity.DefenderSettingsClientDownloadManagerActivationResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DefenderSettingsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, options *armiotsecurity.DefenderSettingsClientGetOptions) (resp azfake.Responder[armiotsecurity.DefenderSettingsClientGetResponse], errResp azfake.ErrorResponder)

	// List is the fake for method DefenderSettingsClient.List
	// HTTP status codes to indicate success: http.StatusOK
	List func(ctx context.Context, options *armiotsecurity.DefenderSettingsClientListOptions) (resp azfake.Responder[armiotsecurity.DefenderSettingsClientListResponse], errResp azfake.ErrorResponder)

	// PackageDownloads is the fake for method DefenderSettingsClient.PackageDownloads
	// HTTP status codes to indicate success: http.StatusOK
	PackageDownloads func(ctx context.Context, options *armiotsecurity.DefenderSettingsClientPackageDownloadsOptions) (resp azfake.Responder[armiotsecurity.DefenderSettingsClientPackageDownloadsResponse], errResp azfake.ErrorResponder)
}

// NewDefenderSettingsServerTransport creates a new instance of DefenderSettingsServerTransport with the provided implementation.
// The returned DefenderSettingsServerTransport instance is connected to an instance of armiotsecurity.DefenderSettingsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDefenderSettingsServerTransport(srv *DefenderSettingsServer) *DefenderSettingsServerTransport {
	return &DefenderSettingsServerTransport{srv: srv}
}

// DefenderSettingsServerTransport connects instances of armiotsecurity.DefenderSettingsClient to instances of DefenderSettingsServer.
// Don't use this type directly, use NewDefenderSettingsServerTransport instead.
type DefenderSettingsServerTransport struct {
	srv *DefenderSettingsServer
}

// Do implements the policy.Transporter interface for DefenderSettingsServerTransport.
func (d *DefenderSettingsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DefenderSettingsClient.CreateOrUpdate":
		resp, err = d.dispatchCreateOrUpdate(req)
	case "DefenderSettingsClient.Delete":
		resp, err = d.dispatchDelete(req)
	case "DefenderSettingsClient.DownloadManagerActivation":
		resp, err = d.dispatchDownloadManagerActivation(req)
	case "DefenderSettingsClient.Get":
		resp, err = d.dispatchGet(req)
	case "DefenderSettingsClient.List":
		resp, err = d.dispatchList(req)
	case "DefenderSettingsClient.PackageDownloads":
		resp, err = d.dispatchPackageDownloads(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DefenderSettingsServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTSecurity/defenderSettings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armiotsecurity.DefenderSettingsModel](req)
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.CreateOrUpdate(req.Context(), body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DefenderSettingsModel, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DefenderSettingsServerTransport) dispatchDelete(req *http.Request) (*http.Response, error) {
	if d.srv.Delete == nil {
		return nil, &nonRetriableError{errors.New("fake for method Delete not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTSecurity/defenderSettings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := d.srv.Delete(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DefenderSettingsServerTransport) dispatchDownloadManagerActivation(req *http.Request) (*http.Response, error) {
	if d.srv.DownloadManagerActivation == nil {
		return nil, &nonRetriableError{errors.New("fake for method DownloadManagerActivation not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTSecurity/defenderSettings/default/downloadManagerActivation`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := d.srv.DownloadManagerActivation(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, &server.ResponseOptions{
		Body:        server.GetResponse(respr).Body,
		ContentType: "application/octet-stream",
	})
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DefenderSettingsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTSecurity/defenderSettings/default`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := d.srv.Get(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DefenderSettingsModel, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DefenderSettingsServerTransport) dispatchList(req *http.Request) (*http.Response, error) {
	if d.srv.List == nil {
		return nil, &nonRetriableError{errors.New("fake for method List not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTSecurity/defenderSettings`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := d.srv.List(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DefenderSettingsList, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DefenderSettingsServerTransport) dispatchPackageDownloads(req *http.Request) (*http.Response, error) {
	if d.srv.PackageDownloads == nil {
		return nil, &nonRetriableError{errors.New("fake for method PackageDownloads not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.IoTSecurity/defenderSettings/default/packageDownloads`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 1 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	respr, errRespr := d.srv.PackageDownloads(req.Context(), nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).PackageDownloads, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
