//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armhybridcontainerservice

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AddonStatusProfile.
func (a AddonStatusProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorMessage", a.ErrorMessage)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "phase", a.Phase)
	populate(objectMap, "ready", a.Ready)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AddonStatusProfile.
func (a *AddonStatusProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &a.ErrorMessage)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "phase":
			err = unpopulate(val, "Phase", &a.Phase)
			delete(rawMsg, key)
		case "ready":
			err = unpopulate(val, "Ready", &a.Ready)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPool.
func (a AgentPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", a.ExtendedLocation)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "location", a.Location)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "systemData", a.SystemData)
	populate(objectMap, "tags", a.Tags)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPool.
func (a *AgentPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &a.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &a.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &a.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolListResult.
func (a AgentPoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolListResult.
func (a *AgentPoolListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolPatch.
func (a AgentPoolPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", a.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolPatch.
func (a *AgentPoolPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &a.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolProperties.
func (a AgentPoolProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityZones", a.AvailabilityZones)
	populate(objectMap, "count", a.Count)
	populate(objectMap, "nodeImageVersion", a.NodeImageVersion)
	populate(objectMap, "osSKU", a.OSSKU)
	populate(objectMap, "osType", a.OSType)
	populate(objectMap, "provisioningState", a.ProvisioningState)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "vmSize", a.VMSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolProperties.
func (a *AgentPoolProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityZones":
			err = unpopulate(val, "AvailabilityZones", &a.AvailabilityZones)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &a.Count)
			delete(rawMsg, key)
		case "nodeImageVersion":
			err = unpopulate(val, "NodeImageVersion", &a.NodeImageVersion)
			delete(rawMsg, key)
		case "osSKU":
			err = unpopulate(val, "OSSKU", &a.OSSKU)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &a.OSType)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &a.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &a.VMSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolProvisioningStatusOperationStatus.
func (a AgentPoolProvisioningStatusOperationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", a.Error)
	populate(objectMap, "operationId", a.OperationID)
	populate(objectMap, "status", a.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolProvisioningStatusOperationStatus.
func (a *AgentPoolProvisioningStatusOperationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &a.Error)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &a.OperationID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolProvisioningStatusOperationStatusError.
func (a AgentPoolProvisioningStatusOperationStatusError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", a.Code)
	populate(objectMap, "message", a.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolProvisioningStatusOperationStatusError.
func (a *AgentPoolProvisioningStatusOperationStatusError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &a.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &a.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolProvisioningStatusStatus.
func (a AgentPoolProvisioningStatusStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorMessage", a.ErrorMessage)
	populate(objectMap, "operationStatus", a.OperationStatus)
	populate(objectMap, "readyReplicas", a.ReadyReplicas)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolProvisioningStatusStatus.
func (a *AgentPoolProvisioningStatusStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &a.ErrorMessage)
			delete(rawMsg, key)
		case "operationStatus":
			err = unpopulate(val, "OperationStatus", &a.OperationStatus)
			delete(rawMsg, key)
		case "readyReplicas":
			err = unpopulate(val, "ReadyReplicas", &a.ReadyReplicas)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolUpdateProfile.
func (a AgentPoolUpdateProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", a.Count)
	populate(objectMap, "vmSize", a.VMSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolUpdateProfile.
func (a *AgentPoolUpdateProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &a.Count)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &a.VMSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudProviderProfile.
func (c CloudProviderProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "infraNetworkProfile", c.InfraNetworkProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudProviderProfile.
func (c *CloudProviderProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "infraNetworkProfile":
			err = unpopulate(val, "InfraNetworkProfile", &c.InfraNetworkProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CloudProviderProfileInfraNetworkProfile.
func (c CloudProviderProfileInfraNetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "vnetSubnetIds", c.VnetSubnetIDs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CloudProviderProfileInfraNetworkProfile.
func (c *CloudProviderProfileInfraNetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "vnetSubnetIds":
			err = unpopulate(val, "VnetSubnetIDs", &c.VnetSubnetIDs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ControlPlaneEndpointProfileControlPlaneEndpoint.
func (c ControlPlaneEndpointProfileControlPlaneEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hostIP", c.HostIP)
	populate(objectMap, "port", c.Port)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ControlPlaneEndpointProfileControlPlaneEndpoint.
func (c *ControlPlaneEndpointProfileControlPlaneEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hostIP":
			err = unpopulate(val, "HostIP", &c.HostIP)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &c.Port)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ControlPlaneProfile.
func (c ControlPlaneProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityZones", c.AvailabilityZones)
	populate(objectMap, "controlPlaneEndpoint", c.ControlPlaneEndpoint)
	populate(objectMap, "count", c.Count)
	populate(objectMap, "linuxProfile", c.LinuxProfile)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "nodeImageVersion", c.NodeImageVersion)
	populate(objectMap, "osSKU", c.OSSKU)
	populate(objectMap, "osType", c.OSType)
	populate(objectMap, "vmSize", c.VMSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ControlPlaneProfile.
func (c *ControlPlaneProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityZones":
			err = unpopulate(val, "AvailabilityZones", &c.AvailabilityZones)
			delete(rawMsg, key)
		case "controlPlaneEndpoint":
			err = unpopulate(val, "ControlPlaneEndpoint", &c.ControlPlaneEndpoint)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &c.Count)
			delete(rawMsg, key)
		case "linuxProfile":
			err = unpopulate(val, "LinuxProfile", &c.LinuxProfile)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "nodeImageVersion":
			err = unpopulate(val, "NodeImageVersion", &c.NodeImageVersion)
			delete(rawMsg, key)
		case "osSKU":
			err = unpopulate(val, "OSSKU", &c.OSSKU)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &c.OSType)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &c.VMSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CredentialResult.
func (c CredentialResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populateByteArray(objectMap, "value", c.Value, runtime.Base64StdFormat)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CredentialResult.
func (c *CredentialResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "value":
			err = runtime.DecodeByteArray(string(val), &c.Value, runtime.Base64StdFormat)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedLocation.
func (e ExtendedLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedLocation.
func (e *ExtendedLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridIdentityMetadata.
func (h HybridIdentityMetadata) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", h.ID)
	populate(objectMap, "name", h.Name)
	populate(objectMap, "properties", h.Properties)
	populate(objectMap, "systemData", h.SystemData)
	populate(objectMap, "type", h.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridIdentityMetadata.
func (h *HybridIdentityMetadata) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &h.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &h.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &h.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &h.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &h.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridIdentityMetadataList.
func (h HybridIdentityMetadataList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", h.NextLink)
	populate(objectMap, "value", h.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridIdentityMetadataList.
func (h *HybridIdentityMetadataList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &h.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &h.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type HybridIdentityMetadataProperties.
func (h HybridIdentityMetadataProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", h.ProvisioningState)
	populate(objectMap, "publicKey", h.PublicKey)
	populate(objectMap, "resourceUid", h.ResourceUID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type HybridIdentityMetadataProperties.
func (h *HybridIdentityMetadataProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", h, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &h.ProvisioningState)
			delete(rawMsg, key)
		case "publicKey":
			err = unpopulate(val, "PublicKey", &h.PublicKey)
			delete(rawMsg, key)
		case "resourceUid":
			err = unpopulate(val, "ResourceUID", &h.ResourceUID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", h, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesPatchVersions.
func (k KubernetesPatchVersions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "readiness", k.Readiness)
	populate(objectMap, "upgrades", k.Upgrades)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesPatchVersions.
func (k *KubernetesPatchVersions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "readiness":
			err = unpopulate(val, "Readiness", &k.Readiness)
			delete(rawMsg, key)
		case "upgrades":
			err = unpopulate(val, "Upgrades", &k.Upgrades)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesVersionCapabilities.
func (k KubernetesVersionCapabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "supportPlan", k.SupportPlan)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesVersionCapabilities.
func (k *KubernetesVersionCapabilities) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "supportPlan":
			err = unpopulate(val, "SupportPlan", &k.SupportPlan)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesVersionProfile.
func (k KubernetesVersionProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", k.ExtendedLocation)
	populate(objectMap, "id", k.ID)
	populate(objectMap, "name", k.Name)
	populate(objectMap, "properties", k.Properties)
	populate(objectMap, "systemData", k.SystemData)
	populate(objectMap, "type", k.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesVersionProfile.
func (k *KubernetesVersionProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &k.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &k.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &k.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &k.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &k.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &k.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesVersionProfileList.
func (k KubernetesVersionProfileList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", k.NextLink)
	populate(objectMap, "value", k.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesVersionProfileList.
func (k *KubernetesVersionProfileList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &k.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &k.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesVersionProfileProperties.
func (k KubernetesVersionProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", k.ProvisioningState)
	populate(objectMap, "values", k.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesVersionProfileProperties.
func (k *KubernetesVersionProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &k.ProvisioningState)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &k.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesVersionProperties.
func (k KubernetesVersionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capabilities", k.Capabilities)
	populate(objectMap, "isPreview", k.IsPreview)
	populate(objectMap, "patchVersions", k.PatchVersions)
	populate(objectMap, "version", k.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesVersionProperties.
func (k *KubernetesVersionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &k.Capabilities)
			delete(rawMsg, key)
		case "isPreview":
			err = unpopulate(val, "IsPreview", &k.IsPreview)
			delete(rawMsg, key)
		case "patchVersions":
			err = unpopulate(val, "PatchVersions", &k.PatchVersions)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &k.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesVersionReadiness.
func (k KubernetesVersionReadiness) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "errorMessage", k.ErrorMessage)
	populate(objectMap, "osSku", k.OSSKU)
	populate(objectMap, "osType", k.OSType)
	populate(objectMap, "ready", k.Ready)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesVersionReadiness.
func (k *KubernetesVersionReadiness) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &k.ErrorMessage)
			delete(rawMsg, key)
		case "osSku":
			err = unpopulate(val, "OSSKU", &k.OSSKU)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &k.OSType)
			delete(rawMsg, key)
		case "ready":
			err = unpopulate(val, "Ready", &k.Ready)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxProfileProperties.
func (l LinuxProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ssh", l.SSH)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxProfileProperties.
func (l *LinuxProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ssh":
			err = unpopulate(val, "SSH", &l.SSH)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxProfilePropertiesSSH.
func (l LinuxProfilePropertiesSSH) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "publicKeys", l.PublicKeys)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxProfilePropertiesSSH.
func (l *LinuxProfilePropertiesSSH) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publicKeys":
			err = unpopulate(val, "PublicKeys", &l.PublicKeys)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxProfilePropertiesSSHPublicKeysItem.
func (l LinuxProfilePropertiesSSHPublicKeysItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyData", l.KeyData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxProfilePropertiesSSHPublicKeysItem.
func (l *LinuxProfilePropertiesSSHPublicKeysItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyData":
			err = unpopulate(val, "KeyData", &l.KeyData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListCredentialResponse.
func (l ListCredentialResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", l.Error)
	populate(objectMap, "id", l.ID)
	populate(objectMap, "name", l.Name)
	populate(objectMap, "properties", l.Properties)
	populate(objectMap, "resourceId", l.ResourceID)
	populate(objectMap, "status", l.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListCredentialResponse.
func (l *ListCredentialResponse) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &l.Error)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &l.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &l.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &l.Properties)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &l.ResourceID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &l.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListCredentialResponseError.
func (l ListCredentialResponseError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", l.Code)
	populate(objectMap, "message", l.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListCredentialResponseError.
func (l *ListCredentialResponseError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &l.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &l.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ListCredentialResponseProperties.
func (l ListCredentialResponseProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "kubeconfigs", l.Kubeconfigs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ListCredentialResponseProperties.
func (l *ListCredentialResponseProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kubeconfigs":
			err = unpopulate(val, "Kubeconfigs", &l.Kubeconfigs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NamedAgentPoolProfile.
func (n NamedAgentPoolProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityZones", n.AvailabilityZones)
	populate(objectMap, "count", n.Count)
	populate(objectMap, "name", n.Name)
	populate(objectMap, "nodeImageVersion", n.NodeImageVersion)
	populate(objectMap, "osSKU", n.OSSKU)
	populate(objectMap, "osType", n.OSType)
	populate(objectMap, "vmSize", n.VMSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NamedAgentPoolProfile.
func (n *NamedAgentPoolProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityZones":
			err = unpopulate(val, "AvailabilityZones", &n.AvailabilityZones)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &n.Count)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &n.Name)
			delete(rawMsg, key)
		case "nodeImageVersion":
			err = unpopulate(val, "NodeImageVersion", &n.NodeImageVersion)
			delete(rawMsg, key)
		case "osSKU":
			err = unpopulate(val, "OSSKU", &n.OSSKU)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &n.OSType)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &n.VMSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkProfile.
func (n NetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "loadBalancerProfile", n.LoadBalancerProfile)
	populate(objectMap, "networkPolicy", n.NetworkPolicy)
	populate(objectMap, "podCidr", n.PodCidr)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkProfile.
func (n *NetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "loadBalancerProfile":
			err = unpopulate(val, "LoadBalancerProfile", &n.LoadBalancerProfile)
			delete(rawMsg, key)
		case "networkPolicy":
			err = unpopulate(val, "NetworkPolicy", &n.NetworkPolicy)
			delete(rawMsg, key)
		case "podCidr":
			err = unpopulate(val, "PodCidr", &n.PodCidr)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkProfileLoadBalancerProfile.
func (n NetworkProfileLoadBalancerProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", n.Count)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkProfileLoadBalancerProfile.
func (n *NetworkProfileLoadBalancerProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &n.Count)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "actionType", o.ActionType)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "isDataAction", o.IsDataAction)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Operation.
func (o *Operation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "actionType":
			err = unpopulate(val, "ActionType", &o.ActionType)
			delete(rawMsg, key)
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "isDataAction":
			err = unpopulate(val, "IsDataAction", &o.IsDataAction)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationDisplay.
func (o *OperationDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClusterLicenseProfile.
func (p ProvisionedClusterLicenseProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureHybridBenefit", p.AzureHybridBenefit)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClusterLicenseProfile.
func (p *ProvisionedClusterLicenseProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureHybridBenefit":
			err = unpopulate(val, "AzureHybridBenefit", &p.AzureHybridBenefit)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClusterPoolUpgradeProfile.
func (p ProvisionedClusterPoolUpgradeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "kubernetesVersion", p.KubernetesVersion)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "osType", p.OSType)
	populate(objectMap, "upgrades", p.Upgrades)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClusterPoolUpgradeProfile.
func (p *ProvisionedClusterPoolUpgradeProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &p.KubernetesVersion)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &p.OSType)
			delete(rawMsg, key)
		case "upgrades":
			err = unpopulate(val, "Upgrades", &p.Upgrades)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClusterPoolUpgradeProfileProperties.
func (p ProvisionedClusterPoolUpgradeProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isPreview", p.IsPreview)
	populate(objectMap, "kubernetesVersion", p.KubernetesVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClusterPoolUpgradeProfileProperties.
func (p *ProvisionedClusterPoolUpgradeProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isPreview":
			err = unpopulate(val, "IsPreview", &p.IsPreview)
			delete(rawMsg, key)
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &p.KubernetesVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClusterProperties.
func (p ProvisionedClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentPoolProfiles", p.AgentPoolProfiles)
	populate(objectMap, "cloudProviderProfile", p.CloudProviderProfile)
	populate(objectMap, "controlPlane", p.ControlPlane)
	populate(objectMap, "kubernetesVersion", p.KubernetesVersion)
	populate(objectMap, "licenseProfile", p.LicenseProfile)
	populate(objectMap, "linuxProfile", p.LinuxProfile)
	populate(objectMap, "networkProfile", p.NetworkProfile)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClusterProperties.
func (p *ProvisionedClusterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentPoolProfiles":
			err = unpopulate(val, "AgentPoolProfiles", &p.AgentPoolProfiles)
			delete(rawMsg, key)
		case "cloudProviderProfile":
			err = unpopulate(val, "CloudProviderProfile", &p.CloudProviderProfile)
			delete(rawMsg, key)
		case "controlPlane":
			err = unpopulate(val, "ControlPlane", &p.ControlPlane)
			delete(rawMsg, key)
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &p.KubernetesVersion)
			delete(rawMsg, key)
		case "licenseProfile":
			err = unpopulate(val, "LicenseProfile", &p.LicenseProfile)
			delete(rawMsg, key)
		case "linuxProfile":
			err = unpopulate(val, "LinuxProfile", &p.LinuxProfile)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &p.NetworkProfile)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClusterPropertiesStatus.
func (p ProvisionedClusterPropertiesStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "controlPlaneStatus", p.ControlPlaneStatus)
	populate(objectMap, "errorMessage", p.ErrorMessage)
	populate(objectMap, "operationStatus", p.OperationStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClusterPropertiesStatus.
func (p *ProvisionedClusterPropertiesStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "controlPlaneStatus":
			err = unpopulate(val, "ControlPlaneStatus", &p.ControlPlaneStatus)
			delete(rawMsg, key)
		case "errorMessage":
			err = unpopulate(val, "ErrorMessage", &p.ErrorMessage)
			delete(rawMsg, key)
		case "operationStatus":
			err = unpopulate(val, "OperationStatus", &p.OperationStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClusterPropertiesStatusOperationStatus.
func (p ProvisionedClusterPropertiesStatusOperationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", p.Error)
	populate(objectMap, "operationId", p.OperationID)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClusterPropertiesStatusOperationStatus.
func (p *ProvisionedClusterPropertiesStatusOperationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &p.Error)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &p.OperationID)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClusterPropertiesStatusOperationStatusError.
func (p ProvisionedClusterPropertiesStatusOperationStatusError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", p.Code)
	populate(objectMap, "message", p.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClusterPropertiesStatusOperationStatusError.
func (p *ProvisionedClusterPropertiesStatusOperationStatusError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &p.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &p.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClusterUpgradeProfile.
func (p ProvisionedClusterUpgradeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClusterUpgradeProfile.
func (p *ProvisionedClusterUpgradeProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClusterUpgradeProfileProperties.
func (p ProvisionedClusterUpgradeProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentPoolProfiles", p.AgentPoolProfiles)
	populate(objectMap, "controlPlaneProfile", p.ControlPlaneProfile)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClusterUpgradeProfileProperties.
func (p *ProvisionedClusterUpgradeProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentPoolProfiles":
			err = unpopulate(val, "AgentPoolProfiles", &p.AgentPoolProfiles)
			delete(rawMsg, key)
		case "controlPlaneProfile":
			err = unpopulate(val, "ControlPlaneProfile", &p.ControlPlaneProfile)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClusters.
func (p ProvisionedClusters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", p.ExtendedLocation)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "systemData", p.SystemData)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClusters.
func (p *ProvisionedClusters) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &p.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &p.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ProvisionedClustersListResult.
func (p ProvisionedClustersListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", p.NextLink)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProvisionedClustersListResult.
func (p *ProvisionedClustersListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &p.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMSKUCapabilities.
func (v VMSKUCapabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMSKUCapabilities.
func (v *VMSKUCapabilities) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMSKUProfile.
func (v VMSKUProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "systemData", v.SystemData)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMSKUProfile.
func (v *VMSKUProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &v.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &v.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMSKUProfileList.
func (v VMSKUProfileList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMSKUProfileList.
func (v *VMSKUProfileList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMSKUProfileProperties.
func (v VMSKUProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "values", v.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMSKUProfileProperties.
func (v *VMSKUProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "values":
			err = unpopulate(val, "Values", &v.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VMSKUProperties.
func (v VMSKUProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capabilities", v.Capabilities)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "resourceType", v.ResourceType)
	populate(objectMap, "size", v.Size)
	populate(objectMap, "tier", v.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VMSKUProperties.
func (v *VMSKUProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &v.Capabilities)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "resourceType":
			err = unpopulate(val, "ResourceType", &v.ResourceType)
			delete(rawMsg, key)
		case "size":
			err = unpopulate(val, "Size", &v.Size)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &v.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetwork.
func (v VirtualNetwork) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", v.ExtendedLocation)
	populate(objectMap, "id", v.ID)
	populate(objectMap, "location", v.Location)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "properties", v.Properties)
	populate(objectMap, "systemData", v.SystemData)
	populate(objectMap, "tags", v.Tags)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetwork.
func (v *VirtualNetwork) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &v.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &v.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &v.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &v.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &v.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkExtendedLocation.
func (v VirtualNetworkExtendedLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", v.Name)
	populate(objectMap, "type", v.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkExtendedLocation.
func (v *VirtualNetworkExtendedLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &v.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &v.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkProperties.
func (v VirtualNetworkProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsServers", v.DNSServers)
	populate(objectMap, "dhcpServers", v.DhcpServers)
	populate(objectMap, "gateway", v.Gateway)
	populate(objectMap, "ipAddressPrefix", v.IPAddressPrefix)
	populate(objectMap, "infraVnetProfile", v.InfraVnetProfile)
	populate(objectMap, "provisioningState", v.ProvisioningState)
	populate(objectMap, "status", v.Status)
	populate(objectMap, "vipPool", v.VipPool)
	populate(objectMap, "vlanID", v.VlanID)
	populate(objectMap, "vmipPool", v.VmipPool)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkProperties.
func (v *VirtualNetworkProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsServers":
			err = unpopulate(val, "DNSServers", &v.DNSServers)
			delete(rawMsg, key)
		case "dhcpServers":
			err = unpopulate(val, "DhcpServers", &v.DhcpServers)
			delete(rawMsg, key)
		case "gateway":
			err = unpopulate(val, "Gateway", &v.Gateway)
			delete(rawMsg, key)
		case "ipAddressPrefix":
			err = unpopulate(val, "IPAddressPrefix", &v.IPAddressPrefix)
			delete(rawMsg, key)
		case "infraVnetProfile":
			err = unpopulate(val, "InfraVnetProfile", &v.InfraVnetProfile)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &v.ProvisioningState)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		case "vipPool":
			err = unpopulate(val, "VipPool", &v.VipPool)
			delete(rawMsg, key)
		case "vlanID":
			err = unpopulate(val, "VlanID", &v.VlanID)
			delete(rawMsg, key)
		case "vmipPool":
			err = unpopulate(val, "VmipPool", &v.VmipPool)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkPropertiesInfraVnetProfile.
func (v VirtualNetworkPropertiesInfraVnetProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "hci", v.Hci)
	populate(objectMap, "vmware", v.Vmware)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkPropertiesInfraVnetProfile.
func (v *VirtualNetworkPropertiesInfraVnetProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "hci":
			err = unpopulate(val, "Hci", &v.Hci)
			delete(rawMsg, key)
		case "vmware":
			err = unpopulate(val, "Vmware", &v.Vmware)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkPropertiesInfraVnetProfileHci.
func (v VirtualNetworkPropertiesInfraVnetProfileHci) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "mocGroup", v.MocGroup)
	populate(objectMap, "mocLocation", v.MocLocation)
	populate(objectMap, "mocVnetName", v.MocVnetName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkPropertiesInfraVnetProfileHci.
func (v *VirtualNetworkPropertiesInfraVnetProfileHci) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "mocGroup":
			err = unpopulate(val, "MocGroup", &v.MocGroup)
			delete(rawMsg, key)
		case "mocLocation":
			err = unpopulate(val, "MocLocation", &v.MocLocation)
			delete(rawMsg, key)
		case "mocVnetName":
			err = unpopulate(val, "MocVnetName", &v.MocVnetName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkPropertiesInfraVnetProfileVmware.
func (v VirtualNetworkPropertiesInfraVnetProfileVmware) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "segmentName", v.SegmentName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkPropertiesInfraVnetProfileVmware.
func (v *VirtualNetworkPropertiesInfraVnetProfileVmware) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "segmentName":
			err = unpopulate(val, "SegmentName", &v.SegmentName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkPropertiesStatus.
func (v VirtualNetworkPropertiesStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "operationStatus", v.OperationStatus)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkPropertiesStatus.
func (v *VirtualNetworkPropertiesStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "operationStatus":
			err = unpopulate(val, "OperationStatus", &v.OperationStatus)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkPropertiesStatusOperationStatus.
func (v VirtualNetworkPropertiesStatusOperationStatus) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", v.Error)
	populate(objectMap, "operationId", v.OperationID)
	populate(objectMap, "phase", v.Phase)
	populate(objectMap, "status", v.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkPropertiesStatusOperationStatus.
func (v *VirtualNetworkPropertiesStatusOperationStatus) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &v.Error)
			delete(rawMsg, key)
		case "operationId":
			err = unpopulate(val, "OperationID", &v.OperationID)
			delete(rawMsg, key)
		case "phase":
			err = unpopulate(val, "Phase", &v.Phase)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &v.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkPropertiesStatusOperationStatusError.
func (v VirtualNetworkPropertiesStatusOperationStatusError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", v.Code)
	populate(objectMap, "message", v.Message)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkPropertiesStatusOperationStatusError.
func (v *VirtualNetworkPropertiesStatusOperationStatusError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &v.Code)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &v.Message)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkPropertiesVipPoolItem.
func (v VirtualNetworkPropertiesVipPoolItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endIP", v.EndIP)
	populate(objectMap, "startIP", v.StartIP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkPropertiesVipPoolItem.
func (v *VirtualNetworkPropertiesVipPoolItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endIP":
			err = unpopulate(val, "EndIP", &v.EndIP)
			delete(rawMsg, key)
		case "startIP":
			err = unpopulate(val, "StartIP", &v.StartIP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworkPropertiesVmipPoolItem.
func (v VirtualNetworkPropertiesVmipPoolItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "endIP", v.EndIP)
	populate(objectMap, "startIP", v.StartIP)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworkPropertiesVmipPoolItem.
func (v *VirtualNetworkPropertiesVmipPoolItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "endIP":
			err = unpopulate(val, "EndIP", &v.EndIP)
			delete(rawMsg, key)
		case "startIP":
			err = unpopulate(val, "StartIP", &v.StartIP)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworksListResult.
func (v VirtualNetworksListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", v.NextLink)
	populate(objectMap, "value", v.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworksListResult.
func (v *VirtualNetworksListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &v.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &v.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type VirtualNetworksPatch.
func (v VirtualNetworksPatch) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", v.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type VirtualNetworksPatch.
func (v *VirtualNetworksPatch) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", v, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &v.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", v, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateByteArray(m map[string]any, k string, b []byte, f runtime.Base64Encoding) {
	if azcore.IsNullValue(b) {
		m[k] = nil
	} else if len(b) == 0 {
		return
	} else {
		m[k] = runtime.EncodeByteArray(b, f)
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
