//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armapimanagement_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/apimanagement/armapimanagement/v2"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementTenantConfigurationDeploy.json
func ExampleTenantConfigurationClient_BeginDeploy() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewTenantConfigurationClient().BeginDeploy(ctx, "rg1", "apimService1", armapimanagement.ConfigurationIDNameConfiguration, armapimanagement.DeployConfigurationParameters{
		Properties: &armapimanagement.DeployConfigurationParameterProperties{
			Branch: to.Ptr("master"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationResultContract = armapimanagement.OperationResultContract{
	// 	Name: to.Ptr("6074e652093a9d0dac3d733c"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service/tenant/operationResults"),
	// 	ID: to.Ptr("6074e652093a9d0dac3d733c"),
	// 	Properties: &armapimanagement.OperationResultContractProperties{
	// 		Error: &armapimanagement.ErrorResponseBody{
	// 			Code: to.Ptr("ValidationError"),
	// 			Message: to.Ptr("File not found: 'api-management/configuration.json'"),
	// 		},
	// 		Started: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-26T17:06:54.303Z"); return t}()),
	// 		Status: to.Ptr(armapimanagement.AsyncOperationStatusFailed),
	// 		Updated: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2017-11-26T17:07:21.777Z"); return t}()),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementTenantConfigurationSave.json
func ExampleTenantConfigurationClient_BeginSave() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewTenantConfigurationClient().BeginSave(ctx, "rg1", "apimService1", armapimanagement.ConfigurationIDNameConfiguration, armapimanagement.SaveConfigurationParameter{
		Properties: &armapimanagement.SaveConfigurationParameterProperties{
			Branch: to.Ptr("master"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationResultContract = armapimanagement.OperationResultContract{
	// 	Name: to.Ptr("6074e652093a9d0dac3d733c"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service/tenant/operationResults"),
	// 	ID: to.Ptr("6074e652093a9d0dac3d733c"),
	// 	Properties: &armapimanagement.OperationResultContractProperties{
	// 		ActionLog: []*armapimanagement.OperationResultLogItemContract{
	// 		},
	// 		ResultInfo: to.Ptr("The configuration was successfully saved to master as commit c0ae274f6046912107bad734834cbf65918668b6."),
	// 		Started: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-13T00:31:14.940Z"); return t}()),
	// 		Status: to.Ptr(armapimanagement.AsyncOperationStatusSucceeded),
	// 		Updated: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-13T00:31:27.590Z"); return t}()),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementTenantConfigurationValidate.json
func ExampleTenantConfigurationClient_BeginValidate() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	poller, err := clientFactory.NewTenantConfigurationClient().BeginValidate(ctx, "rg1", "apimService1", armapimanagement.ConfigurationIDNameConfiguration, armapimanagement.DeployConfigurationParameters{
		Properties: &armapimanagement.DeployConfigurationParameterProperties{
			Branch: to.Ptr("master"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	res, err := poller.PollUntilDone(ctx, nil)
	if err != nil {
		log.Fatalf("failed to pull the result: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.OperationResultContract = armapimanagement.OperationResultContract{
	// 	Name: to.Ptr("6074ec02093a9d0dac3d7345"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service/tenant/operationResults"),
	// 	ID: to.Ptr("6074ec02093a9d0dac3d7345"),
	// 	Properties: &armapimanagement.OperationResultContractProperties{
	// 		ActionLog: []*armapimanagement.OperationResultLogItemContract{
	// 		},
	// 		ResultInfo: to.Ptr("Validation is successfull"),
	// 		Started: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-13T00:55:30.620Z"); return t}()),
	// 		Status: to.Ptr(armapimanagement.AsyncOperationStatusSucceeded),
	// 		Updated: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-13T00:55:39.857Z"); return t}()),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/4cd95123fb961c68740565a1efcaa5e43bd35802/specification/apimanagement/resource-manager/Microsoft.ApiManagement/stable/2022-08-01/examples/ApiManagementTenantAccessSyncState.json
func ExampleTenantConfigurationClient_GetSyncState() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armapimanagement.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewTenantConfigurationClient().GetSyncState(ctx, "rg1", "apimService1", armapimanagement.ConfigurationIDNameConfiguration, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.TenantConfigurationSyncStateContract = armapimanagement.TenantConfigurationSyncStateContract{
	// 	Name: to.Ptr("syncState"),
	// 	Type: to.Ptr("Microsoft.ApiManagement/service/tenant/syncState"),
	// 	ID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/tenant/configuration/syncState"),
	// 	Properties: &armapimanagement.TenantConfigurationSyncStateContractProperties{
	// 		Branch: to.Ptr("master"),
	// 		CommitID: to.Ptr("de891c2342c7058dde45e5e624eae7e558c94683"),
	// 		ConfigurationChangeDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-13T00:11:43.862Z"); return t}()),
	// 		IsExport: to.Ptr(true),
	// 		IsGitEnabled: to.Ptr(true),
	// 		IsSynced: to.Ptr(true),
	// 		LastOperationID: to.Ptr("/subscriptions/subid/resourceGroups/rg1/providers/Microsoft.ApiManagement/service/apimService1/tenant/configuration/operationResults/6074f0bd093a9d0dac3d7347"),
	// 		SyncDate: to.Ptr(func() time.Time { t, _ := time.Parse(time.RFC3339Nano, "2021-04-13T01:15:53.982Z"); return t}()),
	// 	},
	// }
}
