// Code generated by smithy-go-codegen DO NOT EDIT.

package sesv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sesv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List all tenants associated with your account in the current Amazon Web
// Services Region.
//
// This operation returns basic information about each tenant, such as tenant
// name, ID, ARN, and creation timestamp.
func (c *Client) ListTenants(ctx context.Context, params *ListTenantsInput, optFns ...func(*Options)) (*ListTenantsOutput, error) {
	if params == nil {
		params = &ListTenantsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListTenants", params, optFns, c.addOperationListTenantsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListTenantsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents a request to list all tenants associated with your account in the
// current Amazon Web Services Region.
type ListTenantsInput struct {

	// A token returned from a previous call to ListTenants to indicate the position
	// in the list of tenants.
	NextToken *string

	// The number of results to show in a single call to ListTenants . If the number of
	// results is larger than the number you specified in this parameter, then the
	// response includes a NextToken element, which you can use to obtain additional
	// results.
	PageSize *int32

	noSmithyDocumentSerde
}

// Information about tenants associated with your account.
type ListTenantsOutput struct {

	// A token that indicates that there are additional tenants to list. To view
	// additional tenants, issue another request to ListTenants , and pass this token
	// in the NextToken parameter.
	NextToken *string

	// An array that contains basic information about each tenant.
	Tenants []types.TenantInfo

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListTenantsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListTenants{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListTenants{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListTenants"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListTenants(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListTenantsPaginatorOptions is the paginator options for ListTenants
type ListTenantsPaginatorOptions struct {
	// The number of results to show in a single call to ListTenants . If the number of
	// results is larger than the number you specified in this parameter, then the
	// response includes a NextToken element, which you can use to obtain additional
	// results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListTenantsPaginator is a paginator for ListTenants
type ListTenantsPaginator struct {
	options   ListTenantsPaginatorOptions
	client    ListTenantsAPIClient
	params    *ListTenantsInput
	nextToken *string
	firstPage bool
}

// NewListTenantsPaginator returns a new ListTenantsPaginator
func NewListTenantsPaginator(client ListTenantsAPIClient, params *ListTenantsInput, optFns ...func(*ListTenantsPaginatorOptions)) *ListTenantsPaginator {
	if params == nil {
		params = &ListTenantsInput{}
	}

	options := ListTenantsPaginatorOptions{}
	if params.PageSize != nil {
		options.Limit = *params.PageSize
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListTenantsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListTenantsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListTenants page.
func (p *ListTenantsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListTenantsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.PageSize = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListTenants(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListTenantsAPIClient is a client that implements the ListTenants operation.
type ListTenantsAPIClient interface {
	ListTenants(context.Context, *ListTenantsInput, ...func(*Options)) (*ListTenantsOutput, error)
}

var _ ListTenantsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListTenants(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListTenants",
	}
}
