# Copyright © 2018, 2020, 2022  Rafael Laboissière <rafael@debian.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation,
# Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.

1;
function out = sysout (cmd)
    [~, out] = system (cmd);
    out = deblank (out);
endfunction

if (exist ("./PKG_ADD") == 2)
    movefile ("PKG_ADD", "PKG_ADD.bak");
endif

pkg ("prefix", argv(){1}, argv(){2});

pkg ("local_list", fullfile (pwd (), "local-list"));
pkg ("global_list", fullfile (pwd (), "global-list"));

save_header_format_string ("# Generated by Octave during Debian package build");

if (exist ("PKG_ADD.bak") == 2)
    movefile ("PKG_ADD.bak", "PKG_ADD");
endif

pkg -verbose -nodeps install .
