if(NOT USE_CCACHE)
    return()
endif()

find_program(CCACHE_COMMAND sccache)
if(CCACHE_COMMAND)
    mark_as_advanced(CCACHE_COMMAND)
    message(STATUS "Using sccache; disable with '-DUSE_CCACHE=OFF'")
else()
    find_program(CCACHE_COMMAND ccache)
    if(CCACHE_COMMAND)
        mark_as_advanced(CCACHE_COMMAND)
        message(STATUS "Using ccache; disable with '-DUSE_CCACHE=OFF'")
    else()
        message(WARNING "Neither sccache nor ccache found")
        return()
    endif()
endif()

set(CMAKE_C_COMPILER_LAUNCHER "${CCACHE_COMMAND}")
set(CMAKE_CXX_COMPILER_LAUNCHER "${CCACHE_COMMAND}")
set(CMAKE_CUDA_COMPILER_LAUNCHER "${CCACHE_COMMAND}")
