% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gowerD.R
\name{gowerD}
\alias{gowerD}
\title{Computes the extended Gower distance of two data sets}
\usage{
gowerD(
  data.x,
  data.y = data.x,
  weights = rep(1, ncol(data.x)),
  numerical = colnames(data.x),
  factors = vector(),
  orders = vector(),
  mixed = vector(),
  levOrders = vector(),
  mixed.constant = rep(0, length(mixed)),
  returnIndex = FALSE,
  nMin = 1L,
  returnMin = FALSE
)
}
\arguments{
\item{data.x}{data frame}

\item{data.y}{data frame}

\item{weights}{numeric vector providing weights for the observations in x}

\item{numerical}{names of numerical variables}

\item{factors}{names of factor variables}

\item{orders}{names of ordered variables}

\item{mixed}{names of mixed variables}

\item{levOrders}{vector with number of levels for each orders variable}

\item{mixed.constant}{vector with length equal to the number of semi-continuous variables specifying the point of the semi-continuous distribution with non-zero probability}

\item{returnIndex}{logical if TRUE return the index of the minimum distance}

\item{nMin}{integer number of values with smallest distance to be returned}

\item{returnMin}{logical if the computed distances for the indices should be returned}
}
\description{
The function gowerD is used by kNN to compute the distances for numerical,
factor ordered and semi-continous variables.
}
\details{
returnIndex=FALSE: a numerical matrix n x m with the computed distances
returnIndex=TRUE: a named list with "ind" containing the requested indices and "mins" the computed distances
}
\examples{
data(sleep)
# all variables used as numerical
gowerD(sleep)

# split in numerical an
gowerD(sleep, numerical = c("BodyWgt", "BrainWgt", "NonD", "Dream", "Sleep", "Span", "Gest"),
  orders = c("Pred","Exp","Danger"), levOrders = c(5,5,5))

# as before but only returning the index of the closest observation
gowerD(sleep, numerical = c("BodyWgt", "BrainWgt", "NonD", "Dream", "Sleep", "Span", "Gest"),
  orders = c("Pred","Exp","Danger"), levOrders = c(5,5,5), returnIndex = TRUE)
}
