% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rle_utils.R
\name{rep.rle}
\alias{rep.rle}
\title{A \code{\link{rep}} method for \code{\link{rle}} objects}
\usage{
\method{rep}{rle}(
  x,
  ...,
  scale = c("element", "run"),
  doNotCompact = FALSE,
  doNotCompress = doNotCompact
)
}
\arguments{
\item{x}{an \code{\link{rle}} object.}

\item{...}{see documentation for \code{\link{rep}}.}

\item{scale}{whether to replicate the elements of the
RLE-compressed vector or the runs.}

\item{doNotCompress, doNotCompact}{whether the method should call
\code{\link{compress.rle}} the results before returning. Methods liable to
produce very long output vectors, like \code{\link{rep}}, have this set
\code{FALSE} by default. \code{doNotCompact} is an old name for this argument.}
}
\description{
A \code{\link{rep}} method for \code{\link{rle}} objects
}
\note{
The \code{\link{rep}} method for \code{\link{rle}} objects is very limited at
this time. Even though the default setting is to replicate
elements of the vector, only the run-replicating functionality is
implemented at this time except for the simplest case (scalar
\code{times} argument).
}
\examples{

x <- rle(sample(c(-1,+1), 10, c(.7,.3), replace=TRUE))
y <- rpois(length(x$lengths), 2)

stopifnot(isTRUE(all.equal(rep(inverse.rle(x), rep(y, x$lengths)),
                               inverse.rle(rep(x, y, scale="run")))))

stopifnot(isTRUE(all.equal(rep(inverse.rle(x), max(y)),
                               inverse.rle(rep(x, max(y), scale="element")))))

}
