% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditions.R
\name{condition}
\alias{condition}
\alias{pkg_error}
\alias{pkg_warning}
\alias{pkg_message}
\title{Raise a mutable and classed condition.}
\usage{
condition(msg, cond = .conditions, ..., scope = find_scope(),
  type = NULL, call = sys.call(1))

pkg_error(msg, ..., scope = find_scope(), call = sys.call(1))

pkg_warning(msg, ..., scope = find_scope(), call = sys.call(1))

pkg_message(msg, ..., scope = find_scope(), call = sys.call(1))
}
\arguments{
\item{msg}{The message to convey}

\item{cond}{The severity of the condition, or what to do;
give a 'message' (default), a 'warning', an 'error'
or do 'none' and ignore.}

\item{...}{Attributes to be added to condition object for \code{condition},
arguments passed to condition for all others.}

\item{scope}{A character vector of the scope(s) of the signal.
Defaults to the package name but could be longer such as
package name, a class name, and a method call.
This should be used as a where the error occurred.}

\item{type}{Used with \code{scope} and \code{cond} to set the class of the condition object to raise.
This should be a type of error; out of bounds, type mismatch, etcetera.}

\item{call}{The call to use to include in the condition.}
}
\description{
Raising Classed conditions helps with catching errors.
These allow for typing errors as they arise and adding scopes
to better catch errors from specific locations.
}
\details{
The \code{condition()} function alone provides a flexible and dynamic way of
producing conditions in code. The functions \code{pkg_error}, \code{pkg_warning},
and \code{pkg_message} do the same as condition except restricted to errors, warnings,
and messages respectively.
}
