% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_calibratR.R
\name{visualize_calibratR}
\alias{visualize_calibratR}
\title{visualize_calibratR}
\usage{
visualize_calibratR(calibrate_object, visualize_models = FALSE,
  plot_distributions = FALSE, rd_partitions = FALSE,
  training_set_calibrated = FALSE)
}
\arguments{
\item{calibrate_object}{the list component \code{calibration_models} from the \code{\link{calibrate}} method}

\item{visualize_models}{returns the list components \code{plot_calibration_models} and \code{plot_single_models}}

\item{plot_distributions}{returns a density distribution plot of the calibrated predictions after CV (External) or without CV (internal)}

\item{rd_partitions}{returns a reliability diagram for each model}

\item{training_set_calibrated}{returns a list of ggplots. Each plot represents the calibrated predictions by the respective calibration model of the training set.
If the list object \code{predictions} in the \code{calibrate_object} is empty, \code{training_set_calibrated} is returned as NULL.}
}
\value{
An object of class list, with the following components:
\item{histogram_distribution}{returns a histogram of the original ML score distribution}
\item{density_calibration_internal}{returns a list of density distribution plots for each calibration method, the original
and the two input-preprocessing methods scaling and transforming. The plot visualises the density distribution of the calibrated predictions of the training set. In this case, training and test set values are identical, so be careful to evaluate the plots.}
\item{density_calibration_external}{returns a list of density distribution plots for each calibration method, the original
and the two input-preprocessing methods scaling and transforming. The plot visualises the density distribution of the calibrated predictions, that were returned during Cross Validation. If more than one repetition of CV was performed,
run number 1 is evaluated}
\item{plot_calibration_models}{ maps the original ML scores to their calibrated prediction estimates for each model.
This enables easy model comparison over the range of ML scores See also \code{\link{compare_models_visual}}. }
\item{plot_single_models}{returns a list of ggplots for each calibration model, also mapping the original ML scores to their calibrated prediction. Significance values are indicated.
See also \code{\link{plot_model}}}
\item{rd_plot}{returns a list of reliability diagrams for each of the implemented calibration models and the two input-preprocessing methods "scaled" and "transformed". The returned plot visualises the calibrated predictions that
were returned for the test set during each of the n run of the n-times repeated CV. Each grey line represents one of the n runs. The blue line represents the median of all calibrated bin predictions.
Insignificant bin estimates are indicated with "ns". If no CV was performed during calibration model building using the \code{\link{calibrate}} method, \code{rd_plot} is returned as NULL}
\item{calibration_error}{returns a list of boxplots for the calibration error metrics ECE, MCE, CLE and RMSE. The n values for each model represent the obtained error values during the
n times repeated CV. If no CV was performed during calibration model building using the \code{\link{calibrate}} method, \code{calibration_error} is returned as NULL}
\item{discrimination_error}{returns a list of boxplots for the discrimination error AUC, sensitivity and specificity. The n values for each model represent the obtained error values during the
n times repeated CV. If no CV was performed during calibration model building using the \code{\link{calibrate}} method, \code{discrimination_error} is returned as NULL}
\item{cle_class_specific_error}{If no CV was performed during calibration model building using the \code{\link{calibrate}} method, \code{cle_class_specific_error} is returned as NULL}
\item{training_set_calibrated}{returns a list of ggplots. Each plot represents the calibrated predictions by the respective calibration model of the training set.
If the list object \code{predictions} in the \code{calibrate_object} is empty, \code{training_set_calibrated} is returned as NULL.}
\item{GUESS_1_final_model}{plots the the returned conditional probability p(x|Class) values of the GUESS_1 model}
\item{GUESS_2_final_model}{plots the the returned conditional probability p(x|Class) values of the GUESS_2 model}
}
\description{
this method offers a variety of visualisations to compare implemented calibration models
}
\examples{
## Loading dataset in environment
 data(example)
 calibration_model <- example$calibration_model

 visualisation <- visualize_calibratR(calibration_model, plot_distributions=FALSE,
 rd_partitions=FALSE, training_set_calibrated=FALSE)
}
\seealso{
\code{\link[ggplot2]{ggplot}},\code{\link[ggplot2]{geom_density}},\code{\link[ggplot2]{aes}},\code{\link[ggplot2]{scale_colour_manual}},\code{\link[ggplot2]{scale_fill_manual}},\code{\link[ggplot2]{labs}},\code{\link[ggplot2]{geom_point}},\code{\link[ggplot2]{geom_hline}},\code{\link[ggplot2]{theme}},\code{\link[ggplot2]{element_text}}
 \code{\link[reshape2]{melt}}
}
\author{
Johanna Schwarz
}
