# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from tests import IntegrationTestCase
from tests.holodeck import Request
from twilio.base.exceptions import TwilioException
from twilio.http.response import Response


class IpRecordTestCase(IntegrationTestCase):

    def test_create_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.voice.v1.ip_records.create(ip_address="ip_address")

        values = {'IpAddress': "ip_address", }

        self.holodeck.assert_has_request(Request(
            'post',
            'https://voice.twilio.com/v1/IpRecords',
            data=values,
        ))

    def test_create_response(self):
        self.holodeck.mock(Response(
            201,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "sid": "ILaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "friendly_name": "friendly_name",
                "ip_address": "10.2.3.4",
                "cidr_prefix_length": 30,
                "date_created": "2020-03-18T23:31:36Z",
                "date_updated": "2020-03-18T23:31:36Z",
                "url": "https://voice.twilio.com/v1/IpRecords/ILaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.voice.v1.ip_records.create(ip_address="ip_address")

        self.assertIsNotNone(actual)

    def test_fetch_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.voice.v1.ip_records("ILXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://voice.twilio.com/v1/IpRecords/ILXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_fetch_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "sid": "ILaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "friendly_name": "friendly_name",
                "ip_address": "10.2.3.4",
                "cidr_prefix_length": 30,
                "date_created": "2020-03-18T23:31:36Z",
                "date_updated": "2020-03-18T23:31:37Z",
                "url": "https://voice.twilio.com/v1/IpRecords/ILaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.voice.v1.ip_records("ILXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").fetch()

        self.assertIsNotNone(actual)

    def test_list_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.voice.v1.ip_records.list()

        self.holodeck.assert_has_request(Request(
            'get',
            'https://voice.twilio.com/v1/IpRecords',
        ))

    def test_read_full_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://voice.twilio.com/v1/IpRecords?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://voice.twilio.com/v1/IpRecords?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "ip_records"
                },
                "ip_records": [
                    {
                        "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "sid": "ILaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                        "friendly_name": "friendly_name",
                        "ip_address": "10.2.3.4",
                        "cidr_prefix_length": 30,
                        "date_created": "2020-03-18T23:31:36Z",
                        "date_updated": "2020-03-18T23:31:37Z",
                        "url": "https://voice.twilio.com/v1/IpRecords/ILaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
                    }
                ]
            }
            '''
        ))

        actual = self.client.voice.v1.ip_records.list()

        self.assertIsNotNone(actual)

    def test_read_empty_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "meta": {
                    "page": 0,
                    "page_size": 50,
                    "first_page_url": "https://voice.twilio.com/v1/IpRecords?PageSize=50&Page=0",
                    "previous_page_url": null,
                    "url": "https://voice.twilio.com/v1/IpRecords?PageSize=50&Page=0",
                    "next_page_url": null,
                    "key": "ip_records"
                },
                "ip_records": []
            }
            '''
        ))

        actual = self.client.voice.v1.ip_records.list()

        self.assertIsNotNone(actual)

    def test_update_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.voice.v1.ip_records("ILXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").update()

        self.holodeck.assert_has_request(Request(
            'post',
            'https://voice.twilio.com/v1/IpRecords/ILXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_update_response(self):
        self.holodeck.mock(Response(
            200,
            '''
            {
                "account_sid": "ACaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "sid": "ILaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa",
                "friendly_name": "update_name",
                "ip_address": "10.2.3.4",
                "cidr_prefix_length": 30,
                "date_created": "2020-03-18T23:31:36Z",
                "date_updated": "2020-03-18T23:31:37Z",
                "url": "https://voice.twilio.com/v1/IpRecords/ILaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa"
            }
            '''
        ))

        actual = self.client.voice.v1.ip_records("ILXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").update()

        self.assertIsNotNone(actual)

    def test_delete_request(self):
        self.holodeck.mock(Response(500, ''))

        with self.assertRaises(TwilioException):
            self.client.voice.v1.ip_records("ILXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").delete()

        self.holodeck.assert_has_request(Request(
            'delete',
            'https://voice.twilio.com/v1/IpRecords/ILXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX',
        ))

    def test_delete_response(self):
        self.holodeck.mock(Response(
            204,
            None,
        ))

        actual = self.client.voice.v1.ip_records("ILXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX").delete()

        self.assertTrue(actual)
