# This file is auto-generated by /codegen/x86_64_test_encoding.py
# Reference opcodes are generated by:
#     GNU assembler (GNU Binutils) 2.28.51.20170402

from peachpy.x86_64 import *
import unittest


class TestVMOVSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7A, 0x11, 0x64, 0x24, 0xC0]), VMOVSS(dword[r12 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x7E, 0x8A, 0x10, 0x74, 0x24, 0x10]), VMOVSS(xmm30(k2.z), dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7A, 0x10, 0x4C, 0xCC, 0x9D]), VMOVSS(xmm1, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xC4, 0x41, 0x7A, 0x11, 0x74, 0xCC, 0x9D]), VMOVSS(dword[r12 + rcx*8 - 99], xmm14).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5E, 0x8A, 0x10, 0xF3]), VMOVSS(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0xC5, 0x8A, 0x10, 0xCB]), VMOVSS(xmm1, xmm14, xmm3).encode())


class TestVEXTRACTPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0x63, 0x79, 0x17, 0xF5, 0x02]), VEXTRACTPS(ebp, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xE3, 0x79, 0x17, 0xE5, 0x02]), VEXTRACTPS(ebp, xmm4, 2).encode())
        self.assertEqual(bytearray([0xC4, 0x43, 0x79, 0x17, 0x74, 0xCC, 0x9D, 0x02]), VEXTRACTPS(dword[r12 + rcx*8 - 99], xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x17, 0x64, 0x24, 0xC0, 0x02]), VEXTRACTPS(dword[r12 - 64], xmm4, 2).encode())


class TestVINSERTPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x09, 0x21, 0xCB, 0x02]), VINSERTPS(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0x62, 0xA3, 0x5D, 0x08, 0x21, 0xC3, 0x02]), VINSERTPS(xmm16, xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x09, 0x21, 0x4C, 0xCC, 0x9D, 0x02]), VINSERTPS(xmm1, xmm14, dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0x5D, 0x08, 0x21, 0x44, 0x24, 0xE0, 0x02]), VINSERTPS(xmm16, xmm4, dword[r12 - 128], 2).encode())


class TestVADDSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5E, 0x8A, 0x58, 0x74, 0x24, 0xE0]), VADDSS(xmm30(k2.z), xmm4, dword[r12 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x8A, 0x58, 0xCB]), VADDSS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0A, 0x58, 0x4C, 0xCC, 0x9D]), VADDSS(xmm1, xmm14, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5E, 0x9A, 0x58, 0xF3]), VADDSS(xmm30(k2.z), xmm4, xmm19, {rn_sae}).encode())


class TestVSUBSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5E, 0x8A, 0x5C, 0x74, 0x24, 0xE0]), VSUBSS(xmm30(k2.z), xmm4, dword[r12 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x8A, 0x5C, 0xCB]), VSUBSS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0A, 0x5C, 0x4C, 0xCC, 0x9D]), VSUBSS(xmm1, xmm14, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5E, 0x9A, 0x5C, 0xF3]), VSUBSS(xmm30(k2.z), xmm4, xmm19, {rn_sae}).encode())


class TestVMULSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5E, 0x8A, 0x59, 0x74, 0x24, 0xE0]), VMULSS(xmm30(k2.z), xmm4, dword[r12 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x8A, 0x59, 0xCB]), VMULSS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0A, 0x59, 0x4C, 0xCC, 0x9D]), VMULSS(xmm1, xmm14, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5E, 0x9A, 0x59, 0xF3]), VMULSS(xmm30(k2.z), xmm4, xmm19, {rn_sae}).encode())


class TestVDIVSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5E, 0x8A, 0x5E, 0x74, 0x24, 0xE0]), VDIVSS(xmm30(k2.z), xmm4, dword[r12 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x8A, 0x5E, 0xCB]), VDIVSS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0A, 0x5E, 0x4C, 0xCC, 0x9D]), VDIVSS(xmm1, xmm14, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5E, 0x9A, 0x5E, 0xF3]), VDIVSS(xmm30(k2.z), xmm4, xmm19, {rn_sae}).encode())


class TestVSQRTSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5E, 0x8A, 0x51, 0x74, 0x24, 0xE0]), VSQRTSS(xmm30(k2.z), xmm4, dword[r12 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x8A, 0x51, 0xCB]), VSQRTSS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0A, 0x51, 0x4C, 0xCC, 0x9D]), VSQRTSS(xmm1, xmm14, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5E, 0x9A, 0x51, 0xF3]), VSQRTSS(xmm30(k2.z), xmm4, xmm19, {rn_sae}).encode())


class TestVROUNDSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x09, 0x0A, 0xCB, 0x02]), VROUNDSS(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x09, 0x0A, 0x4C, 0xCC, 0x9D, 0x02]), VROUNDSS(xmm1, xmm14, dword[r12 + rcx*8 - 99], 2).encode())


class TestVRNDSCALESS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0x5D, 0x8A, 0x0A, 0x74, 0x24, 0xE0, 0x02]), VRNDSCALESS(xmm30(k2.z), xmm4, dword[r12 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0x23, 0x5D, 0x9A, 0x0A, 0xF3, 0x02]), VRNDSCALESS(xmm30(k2.z), xmm4, xmm19, {sae}, 2).encode())


class TestVRANGESS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0x5D, 0x8A, 0x51, 0x74, 0x24, 0xE0, 0x02]), VRANGESS(xmm30(k2.z), xmm4, dword[r12 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0x23, 0x5D, 0x9A, 0x51, 0xF3, 0x02]), VRANGESS(xmm30(k2.z), xmm4, xmm19, {sae}, 2).encode())


class TestVMINSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5E, 0x8A, 0x5D, 0x74, 0x24, 0xE0]), VMINSS(xmm30(k2.z), xmm4, dword[r12 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x8A, 0x5D, 0xCB]), VMINSS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0A, 0x5D, 0x4C, 0xCC, 0x9D]), VMINSS(xmm1, xmm14, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5E, 0x9A, 0x5D, 0xF3]), VMINSS(xmm30(k2.z), xmm4, xmm19, {sae}).encode())


class TestVMAXSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5E, 0x8A, 0x5F, 0x74, 0x24, 0xE0]), VMAXSS(xmm30(k2.z), xmm4, dword[r12 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x8A, 0x5F, 0xCB]), VMAXSS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0A, 0x5F, 0x4C, 0xCC, 0x9D]), VMAXSS(xmm1, xmm14, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5E, 0x9A, 0x5F, 0xF3]), VMAXSS(xmm30(k2.z), xmm4, xmm19, {sae}).encode())


class TestVREDUCESS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x23, 0x5D, 0x8A, 0x57, 0xF3, 0x02]), VREDUCESS(xmm30(k2.z), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0x43, 0x5D, 0x8A, 0x57, 0x74, 0x24, 0xE0, 0x02]), VREDUCESS(xmm30(k2.z), xmm4, dword[r12 - 128], 2).encode())


class TestVGETMANTSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0x5D, 0x8A, 0x27, 0x74, 0x24, 0xE0, 0x02]), VGETMANTSS(xmm30(k2.z), xmm4, dword[r12 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0x23, 0x5D, 0x9A, 0x27, 0xF3, 0x02]), VGETMANTSS(xmm30(k2.z), xmm4, xmm19, {sae}, 2).encode())


class TestVGETEXPSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x43, 0x74, 0x24, 0xE0]), VGETEXPSS(xmm30(k2.z), xmm4, dword[r12 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x9A, 0x43, 0xF3]), VGETEXPSS(xmm30(k2.z), xmm4, xmm19, {sae}).encode())


class TestVSCALEFSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x2D, 0x74, 0x24, 0xE0]), VSCALEFSS(xmm30(k2.z), xmm4, dword[r12 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x9A, 0x2D, 0xF3]), VSCALEFSS(xmm30(k2.z), xmm4, xmm19, {rn_sae}).encode())


class TestVFIXUPIMMSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0x5D, 0x8A, 0x55, 0x74, 0x24, 0xE0, 0x02]), VFIXUPIMMSS(xmm30(k2.z), xmm4, dword[r12 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0x23, 0x5D, 0x9A, 0x55, 0xF3, 0x02]), VFIXUPIMMSS(xmm30(k2.z), xmm4, xmm19, {sae}, 2).encode())


class TestVFPCLASSSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF3, 0x7D, 0x0E, 0x67, 0xE4, 0x02]), VFPCLASSSS(k4(k6), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0x7D, 0x0E, 0x67, 0x64, 0x24, 0x10, 0x02]), VFPCLASSSS(k4(k6), dword[r12 + 64], 2).encode())


class TestVRCPSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x8A, 0x53, 0xCB]), VRCPSS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0A, 0x53, 0x4C, 0xCC, 0x9D]), VRCPSS(xmm1, xmm14, dword[r12 + rcx*8 - 99]).encode())


class TestVRSQRTSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x8A, 0x52, 0xCB]), VRSQRTSS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0A, 0x52, 0x4C, 0xCC, 0x9D]), VRSQRTSS(xmm1, xmm14, dword[r12 + rcx*8 - 99]).encode())


class TestVRCP14SS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x4D, 0xF3]), VRCP14SS(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x4D, 0x74, 0x24, 0xE0]), VRCP14SS(xmm30(k2.z), xmm4, dword[r12 - 128]).encode())


class TestVRSQRT14SS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x4F, 0xF3]), VRSQRT14SS(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x4F, 0x74, 0x24, 0xE0]), VRSQRT14SS(xmm30(k2.z), xmm4, dword[r12 - 128]).encode())


class TestVRCP28SS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0xCB, 0x74, 0x24, 0xE0]), VRCP28SS(xmm30(k2.z), xmm4, dword[r12 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x9A, 0xCB, 0xF3]), VRCP28SS(xmm30(k2.z), xmm4, xmm19, {sae}).encode())


class TestVRSQRT28SS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0xCD, 0x74, 0x24, 0xE0]), VRSQRT28SS(xmm30(k2.z), xmm4, dword[r12 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x9A, 0xCD, 0xF3]), VRSQRT28SS(xmm30(k2.z), xmm4, xmm19, {sae}).encode())


class TestVCMPSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x5E, 0x0E, 0xC2, 0x64, 0x24, 0xE0, 0x02]), VCMPSS(k4(k6), xmm4, dword[r12 - 128], 2).encode())
        self.assertEqual(bytearray([0xC5, 0x8A, 0xC2, 0xCB, 0x02]), VCMPSS(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0A, 0xC2, 0x4C, 0xCC, 0x9D, 0x02]), VCMPSS(xmm1, xmm14, dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x62, 0xB1, 0x5E, 0x1E, 0xC2, 0xE3, 0x02]), VCMPSS(k4(k6), xmm4, xmm19, {sae}, 2).encode())


class TestVCOMISS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x2F, 0xCE]), VCOMISS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x2F, 0x4C, 0xCC, 0x9D]), VCOMISS(xmm1, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7C, 0x08, 0x2F, 0x44, 0x24, 0x10]), VCOMISS(xmm16, dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7C, 0x18, 0x2F, 0xC4]), VCOMISS(xmm16, xmm4, {sae}).encode())


class TestVUCOMISS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x2E, 0xCE]), VUCOMISS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x2E, 0x4C, 0xCC, 0x9D]), VUCOMISS(xmm1, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7C, 0x08, 0x2E, 0x44, 0x24, 0x10]), VUCOMISS(xmm16, dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7C, 0x18, 0x2E, 0xC4]), VUCOMISS(xmm16, xmm4, {sae}).encode())


class TestVMOVSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7B, 0x11, 0x63, 0xC0]), VMOVSD(qword[r11 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xFF, 0x8A, 0x10, 0x73, 0x08]), VMOVSD(xmm30(k2.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7B, 0x10, 0x4C, 0xD3, 0xA8]), VMOVSD(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0xC4, 0x41, 0x7B, 0x11, 0x74, 0xD3, 0xA8]), VMOVSD(qword[r11 + rdx*8 - 88], xmm14).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDF, 0x8A, 0x10, 0xF3]), VMOVSD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0xC5, 0x8B, 0x10, 0xCB]), VMOVSD(xmm1, xmm14, xmm3).encode())


class TestVADDSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDF, 0x8A, 0x58, 0x73, 0xF0]), VADDSD(xmm30(k2.z), xmm4, qword[r11 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x8B, 0x58, 0xCB]), VADDSD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0B, 0x58, 0x4C, 0xD3, 0xA8]), VADDSD(xmm1, xmm14, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDF, 0x9A, 0x58, 0xF3]), VADDSD(xmm30(k2.z), xmm4, xmm19, {rn_sae}).encode())


class TestVSUBSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDF, 0x8A, 0x5C, 0x73, 0xF0]), VSUBSD(xmm30(k2.z), xmm4, qword[r11 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x8B, 0x5C, 0xCB]), VSUBSD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0B, 0x5C, 0x4C, 0xD3, 0xA8]), VSUBSD(xmm1, xmm14, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDF, 0x9A, 0x5C, 0xF3]), VSUBSD(xmm30(k2.z), xmm4, xmm19, {rn_sae}).encode())


class TestVMULSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDF, 0x8A, 0x59, 0x73, 0xF0]), VMULSD(xmm30(k2.z), xmm4, qword[r11 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x8B, 0x59, 0xCB]), VMULSD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0B, 0x59, 0x4C, 0xD3, 0xA8]), VMULSD(xmm1, xmm14, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDF, 0x9A, 0x59, 0xF3]), VMULSD(xmm30(k2.z), xmm4, xmm19, {rn_sae}).encode())


class TestVDIVSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDF, 0x8A, 0x5E, 0x73, 0xF0]), VDIVSD(xmm30(k2.z), xmm4, qword[r11 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x8B, 0x5E, 0xCB]), VDIVSD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0B, 0x5E, 0x4C, 0xD3, 0xA8]), VDIVSD(xmm1, xmm14, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDF, 0x9A, 0x5E, 0xF3]), VDIVSD(xmm30(k2.z), xmm4, xmm19, {rn_sae}).encode())


class TestVSQRTSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDF, 0x8A, 0x51, 0x73, 0xF0]), VSQRTSD(xmm30(k2.z), xmm4, qword[r11 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x8B, 0x51, 0xCB]), VSQRTSD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0B, 0x51, 0x4C, 0xD3, 0xA8]), VSQRTSD(xmm1, xmm14, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDF, 0x9A, 0x51, 0xF3]), VSQRTSD(xmm30(k2.z), xmm4, xmm19, {rn_sae}).encode())


class TestVROUNDSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x09, 0x0B, 0xCB, 0x02]), VROUNDSD(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x09, 0x0B, 0x4C, 0xD3, 0xA8, 0x02]), VROUNDSD(xmm1, xmm14, qword[r11 + rdx*8 - 88], 2).encode())


class TestVRNDSCALESD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0xDD, 0x8A, 0x0B, 0x73, 0xF0, 0x02]), VRNDSCALESD(xmm30(k2.z), xmm4, qword[r11 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0x23, 0xDD, 0x9A, 0x0B, 0xF3, 0x02]), VRNDSCALESD(xmm30(k2.z), xmm4, xmm19, {sae}, 2).encode())


class TestVRANGESD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0xDD, 0x8A, 0x51, 0x73, 0xF0, 0x02]), VRANGESD(xmm30(k2.z), xmm4, qword[r11 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0x23, 0xDD, 0x9A, 0x51, 0xF3, 0x02]), VRANGESD(xmm30(k2.z), xmm4, xmm19, {sae}, 2).encode())


class TestVMINSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDF, 0x8A, 0x5D, 0x73, 0xF0]), VMINSD(xmm30(k2.z), xmm4, qword[r11 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x8B, 0x5D, 0xCB]), VMINSD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0B, 0x5D, 0x4C, 0xD3, 0xA8]), VMINSD(xmm1, xmm14, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDF, 0x9A, 0x5D, 0xF3]), VMINSD(xmm30(k2.z), xmm4, xmm19, {sae}).encode())


class TestVMAXSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDF, 0x8A, 0x5F, 0x73, 0xF0]), VMAXSD(xmm30(k2.z), xmm4, qword[r11 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x8B, 0x5F, 0xCB]), VMAXSD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0B, 0x5F, 0x4C, 0xD3, 0xA8]), VMAXSD(xmm1, xmm14, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDF, 0x9A, 0x5F, 0xF3]), VMAXSD(xmm30(k2.z), xmm4, xmm19, {sae}).encode())


class TestVREDUCESD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x23, 0xDD, 0x8A, 0x57, 0xF3, 0x02]), VREDUCESD(xmm30(k2.z), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0x43, 0xDD, 0x8A, 0x57, 0x73, 0xF0, 0x02]), VREDUCESD(xmm30(k2.z), xmm4, qword[r11 - 128], 2).encode())


class TestVGETMANTSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0xDD, 0x8A, 0x27, 0x73, 0xF0, 0x02]), VGETMANTSD(xmm30(k2.z), xmm4, qword[r11 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0x23, 0xDD, 0x9A, 0x27, 0xF3, 0x02]), VGETMANTSD(xmm30(k2.z), xmm4, xmm19, {sae}, 2).encode())


class TestVGETEXPSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x43, 0x73, 0xF0]), VGETEXPSD(xmm30(k2.z), xmm4, qword[r11 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x9A, 0x43, 0xF3]), VGETEXPSD(xmm30(k2.z), xmm4, xmm19, {sae}).encode())


class TestVSCALEFSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x2D, 0x73, 0xF0]), VSCALEFSD(xmm30(k2.z), xmm4, qword[r11 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x9A, 0x2D, 0xF3]), VSCALEFSD(xmm30(k2.z), xmm4, xmm19, {rn_sae}).encode())


class TestVFIXUPIMMSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0xDD, 0x8A, 0x55, 0x73, 0xF0, 0x02]), VFIXUPIMMSD(xmm30(k2.z), xmm4, qword[r11 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0x23, 0xDD, 0x9A, 0x55, 0xF3, 0x02]), VFIXUPIMMSD(xmm30(k2.z), xmm4, xmm19, {sae}, 2).encode())


class TestVFPCLASSSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF3, 0xFD, 0x0E, 0x67, 0xE4, 0x02]), VFPCLASSSD(k4(k6), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0xFD, 0x0E, 0x67, 0x63, 0x08, 0x02]), VFPCLASSSD(k4(k6), qword[r11 + 64], 2).encode())


class TestVRCP14SD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x4D, 0xF3]), VRCP14SD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x4D, 0x73, 0xF0]), VRCP14SD(xmm30(k2.z), xmm4, qword[r11 - 128]).encode())


class TestVRSQRT14SD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x4F, 0xF3]), VRSQRT14SD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x4F, 0x73, 0xF0]), VRSQRT14SD(xmm30(k2.z), xmm4, qword[r11 - 128]).encode())


class TestVRCP28SD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0xCB, 0x73, 0xF0]), VRCP28SD(xmm30(k2.z), xmm4, qword[r11 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x9A, 0xCB, 0xF3]), VRCP28SD(xmm30(k2.z), xmm4, xmm19, {sae}).encode())


class TestVRSQRT28SD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0xCD, 0x73, 0xF0]), VRSQRT28SD(xmm30(k2.z), xmm4, qword[r11 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x9A, 0xCD, 0xF3]), VRSQRT28SD(xmm30(k2.z), xmm4, xmm19, {sae}).encode())


class TestVCMPSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0xDF, 0x0E, 0xC2, 0x63, 0xF0, 0x02]), VCMPSD(k4(k6), xmm4, qword[r11 - 128], 2).encode())
        self.assertEqual(bytearray([0xC5, 0x8B, 0xC2, 0xCB, 0x02]), VCMPSD(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0B, 0xC2, 0x4C, 0xD3, 0xA8, 0x02]), VCMPSD(xmm1, xmm14, qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x62, 0xB1, 0xDF, 0x1E, 0xC2, 0xE3, 0x02]), VCMPSD(k4(k6), xmm4, xmm19, {sae}, 2).encode())


class TestVCOMISD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x2F, 0xCE]), VCOMISD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x2F, 0x4C, 0xD3, 0xA8]), VCOMISD(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFD, 0x08, 0x2F, 0x43, 0x08]), VCOMISD(xmm16, qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0xFD, 0x18, 0x2F, 0xC4]), VCOMISD(xmm16, xmm4, {sae}).encode())


class TestVUCOMISD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x2E, 0xCE]), VUCOMISD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x2E, 0x4C, 0xD3, 0xA8]), VUCOMISD(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFD, 0x08, 0x2E, 0x43, 0x08]), VUCOMISD(xmm16, qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0xFD, 0x18, 0x2E, 0xC4]), VUCOMISD(xmm16, xmm4, {sae}).encode())


class TestVMOVAPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x29, 0x62, 0xC0]), VMOVAPS(oword[r10 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0x7C, 0x8A, 0x28, 0xF4]), VMOVAPS(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7C, 0x29, 0x69, 0xC0]), VMOVAPS(hword[r9 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7C, 0xAD, 0x28, 0xDD]), VMOVAPS(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x7C, 0x48, 0x29, 0x50, 0xFF]), VMOVAPS(zword[r8 - 64], zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0x7C, 0xCE, 0x28, 0xCA]), VMOVAPS(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x7C, 0x8A, 0x28, 0x72, 0x04]), VMOVAPS(xmm30(k2.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7C, 0xAD, 0x28, 0x59, 0x02]), VMOVAPS(ymm19(k5.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7C, 0xCE, 0x28, 0x48, 0x01]), VMOVAPS(zmm9(k6.z), zword[r8 + 64]).encode())
        self.assertEqual(bytearray([0xC5, 0x78, 0x29, 0xF1]), VMOVAPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x28, 0x4C, 0xC2, 0xB3]), VMOVAPS(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x7C, 0x29, 0xFA]), VMOVAPS(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7C, 0x28, 0x54, 0xD9, 0xBE]), VMOVAPS(ymm2, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC4, 0x41, 0x78, 0x29, 0x74, 0xC2, 0xB3]), VMOVAPS(oword[r10 + rax*8 - 77], xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0x41, 0x7C, 0x29, 0x7C, 0xD9, 0xBE]), VMOVAPS(hword[r9 + rbx*8 - 66], ymm15).encode())


class TestVMOVUPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x11, 0x62, 0xC0]), VMOVUPS(oword[r10 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0x7C, 0x8A, 0x10, 0xF4]), VMOVUPS(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7C, 0x11, 0x69, 0xC0]), VMOVUPS(hword[r9 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7C, 0xAD, 0x10, 0xDD]), VMOVUPS(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x7C, 0x48, 0x11, 0x50, 0xFF]), VMOVUPS(zword[r8 - 64], zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0x7C, 0xCE, 0x10, 0xCA]), VMOVUPS(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x7C, 0x8A, 0x10, 0x72, 0x04]), VMOVUPS(xmm30(k2.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7C, 0xAD, 0x10, 0x59, 0x02]), VMOVUPS(ymm19(k5.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7C, 0xCE, 0x10, 0x48, 0x01]), VMOVUPS(zmm9(k6.z), zword[r8 + 64]).encode())
        self.assertEqual(bytearray([0xC5, 0x78, 0x11, 0xF1]), VMOVUPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x10, 0x4C, 0xC2, 0xB3]), VMOVUPS(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x7C, 0x11, 0xFA]), VMOVUPS(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7C, 0x10, 0x54, 0xD9, 0xBE]), VMOVUPS(ymm2, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC4, 0x41, 0x78, 0x11, 0x74, 0xC2, 0xB3]), VMOVUPS(oword[r10 + rax*8 - 77], xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0x41, 0x7C, 0x11, 0x7C, 0xD9, 0xBE]), VMOVUPS(hword[r9 + rbx*8 - 66], ymm15).encode())


class TestVMOVLPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0x41, 0x78, 0x13, 0x74, 0xD3, 0xA8]), VMOVLPS(qword[r11 + rdx*8 - 88], xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x13, 0x63, 0xC0]), VMOVLPS(qword[r11 - 64], xmm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x08, 0x12, 0x4C, 0xD3, 0xA8]), VMOVLPS(xmm1, xmm14, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x5C, 0x08, 0x12, 0x43, 0xF0]), VMOVLPS(xmm16, xmm4, qword[r11 - 128]).encode())


class TestVMOVHPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0x41, 0x78, 0x17, 0x74, 0xD3, 0xA8]), VMOVHPS(qword[r11 + rdx*8 - 88], xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x17, 0x63, 0xC0]), VMOVHPS(qword[r11 - 64], xmm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x08, 0x16, 0x4C, 0xD3, 0xA8]), VMOVHPS(xmm1, xmm14, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x5C, 0x08, 0x16, 0x43, 0xF0]), VMOVHPS(xmm16, xmm4, qword[r11 - 128]).encode())


class TestVMASKMOVPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x2C, 0x4C, 0xC2, 0xB3]), VMASKMOVPS(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x2C, 0x54, 0xD9, 0xBE]), VMASKMOVPS(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x2E, 0x5C, 0xC2, 0xB3]), VMASKMOVPS(oword[r10 + rax*8 - 77], xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x2E, 0x64, 0xD9, 0xBE]), VMASKMOVPS(hword[r9 + rbx*8 - 66], ymm15, ymm4).encode())


class TestVMOVMSKPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x50, 0xEE]), VMOVMSKPS(ebp, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7C, 0x50, 0xEF]), VMOVMSKPS(ebp, ymm15).encode())


class TestVMOVNTPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0x41, 0x78, 0x2B, 0x74, 0xC2, 0xB3]), VMOVNTPS(oword[r10 + rax*8 - 77], xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x2B, 0x62, 0xC0]), VMOVNTPS(oword[r10 - 64], xmm4).encode())
        self.assertEqual(bytearray([0xC4, 0x41, 0x7C, 0x2B, 0x7C, 0xD9, 0xBE]), VMOVNTPS(hword[r9 + rbx*8 - 66], ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7C, 0x2B, 0x69, 0xC0]), VMOVNTPS(hword[r9 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x7C, 0x48, 0x2B, 0x50, 0xFF]), VMOVNTPS(zword[r8 - 64], zmm26).encode())


class TestVBROADCASTSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x18, 0xDC]), VBROADCASTSS(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0x7D, 0xCE, 0x18, 0xCC]), VBROADCASTSS(zmm9(k6.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x18, 0x5C, 0x24, 0x10]), VBROADCASTSS(ymm19(k5.z), dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x18, 0x4C, 0x24, 0x10]), VBROADCASTSS(zmm9(k6.z), dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x18, 0xCE]), VBROADCASTSS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x18, 0x4C, 0xCC, 0x9D]), VBROADCASTSS(xmm1, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x18, 0xD6]), VBROADCASTSS(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x18, 0x54, 0xCC, 0x9D]), VBROADCASTSS(ymm2, dword[r12 + rcx*8 - 99]).encode())


class TestVMOVSLDUP(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x61, 0x7E, 0x8A, 0x12, 0xF4]), VMOVSLDUP(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7E, 0xAD, 0x12, 0xDD]), VMOVSLDUP(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0x7E, 0xCE, 0x12, 0xCA]), VMOVSLDUP(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x7E, 0x8A, 0x12, 0x72, 0x04]), VMOVSLDUP(xmm30(k2.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7E, 0xAD, 0x12, 0x59, 0x02]), VMOVSLDUP(ymm19(k5.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7E, 0xCE, 0x12, 0x48, 0x01]), VMOVSLDUP(zmm9(k6.z), zword[r8 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7A, 0x12, 0xCE]), VMOVSLDUP(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7A, 0x12, 0x4C, 0xC2, 0xB3]), VMOVSLDUP(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7E, 0x12, 0xD7]), VMOVSLDUP(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7E, 0x12, 0x54, 0xD9, 0xBE]), VMOVSLDUP(ymm2, hword[r9 + rbx*8 - 66]).encode())


class TestVMOVSHDUP(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x61, 0x7E, 0x8A, 0x16, 0xF4]), VMOVSHDUP(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7E, 0xAD, 0x16, 0xDD]), VMOVSHDUP(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0x7E, 0xCE, 0x16, 0xCA]), VMOVSHDUP(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x7E, 0x8A, 0x16, 0x72, 0x04]), VMOVSHDUP(xmm30(k2.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7E, 0xAD, 0x16, 0x59, 0x02]), VMOVSHDUP(ymm19(k5.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7E, 0xCE, 0x16, 0x48, 0x01]), VMOVSHDUP(zmm9(k6.z), zword[r8 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7A, 0x16, 0xCE]), VMOVSHDUP(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7A, 0x16, 0x4C, 0xC2, 0xB3]), VMOVSHDUP(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7E, 0x16, 0xD7]), VMOVSHDUP(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7E, 0x16, 0x54, 0xD9, 0xBE]), VMOVSHDUP(ymm2, hword[r9 + rbx*8 - 66]).encode())


class TestVEXPANDPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x88, 0xF4]), VEXPANDPS(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x88, 0xDD]), VEXPANDPS(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0x7D, 0xCE, 0x88, 0xCA]), VEXPANDPS(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x88, 0x72, 0x10]), VEXPANDPS(xmm30(k2.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x88, 0x59, 0x10]), VEXPANDPS(ymm19(k5.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x88, 0x48, 0x10]), VEXPANDPS(zmm9(k6.z), zword[r8 + 64]).encode())


class TestVCOMPRESSPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0x7D, 0x8A, 0x8A, 0xE6]), VCOMPRESSPS(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7D, 0x08, 0x8A, 0x62, 0xF0]), VCOMPRESSPS(oword[r10 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xB2, 0x7D, 0xAD, 0x8A, 0xEB]), VCOMPRESSPS(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7D, 0x28, 0x8A, 0x69, 0xF0]), VCOMPRESSPS(hword[r9 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0xCE, 0x8A, 0xD1]), VCOMPRESSPS(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x48, 0x8A, 0x50, 0xF0]), VCOMPRESSPS(zword[r8 - 64], zmm26).encode())


class TestVGATHERDPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF2, 0x7D, 0x09, 0x92, 0x6C, 0x86, 0xE0]), VGATHERDPS(xmm5(k1), [rsi + xmm0 * 4 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x02, 0x7D, 0x2B, 0x92, 0x44, 0x83, 0x0C]), VGATHERDPS(ymm24(k3), [r11 + ymm8 * 4 + 48]).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x47, 0x92, 0x54, 0x9F, 0xFC]), VGATHERDPS(zmm26(k7), [r15 + zmm19 * 4 - 16]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x61, 0x92, 0x4C, 0x86, 0x80]), VGATHERDPS(xmm1, [rsi + xmm0 * 4 - 128], xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0x82, 0x5D, 0x92, 0x54, 0x83, 0x30]), VGATHERDPS(ymm2, [r11 + ymm8 * 4 + 48], ymm4).encode())


class TestVGATHERQPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF2, 0x7D, 0x09, 0x93, 0x6C, 0xCE, 0x0A]), VGATHERQPS(xmm5(k1), [rsi + xmm1 * 8 + 40]).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7D, 0x29, 0x93, 0x6C, 0xCB, 0xF2]), VGATHERQPS(xmm5(k1), [r11 + ymm9 * 8 - 56]).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x43, 0x93, 0x44, 0xE7, 0x12]), VGATHERQPS(ymm24(k3), [r15 + zmm20 * 8 + 72]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x61, 0x93, 0x4C, 0xCE, 0x28]), VGATHERQPS(xmm1, [rsi + xmm1 * 8 + 40], xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0x82, 0x65, 0x93, 0x4C, 0xCB, 0xC8]), VGATHERQPS(xmm1, [r11 + ymm9 * 8 - 56], xmm3).encode())


class TestVGATHERPF0DPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD2, 0x7D, 0x43, 0xC6, 0x4C, 0x9F, 0xFC]), VGATHERPF0DPS([r15 + zmm19(k3) * 4 - 16]).encode())


class TestVGATHERPF0QPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD2, 0x7D, 0x46, 0xC7, 0x4C, 0xE7, 0x12]), VGATHERPF0QPS([r15 + zmm20(k6) * 8 + 72]).encode())


class TestVGATHERPF1DPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD2, 0x7D, 0x43, 0xC6, 0x54, 0x9F, 0xFC]), VGATHERPF1DPS([r15 + zmm19(k3) * 4 - 16]).encode())


class TestVGATHERPF1QPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD2, 0x7D, 0x46, 0xC7, 0x54, 0xE7, 0x12]), VGATHERPF1QPS([r15 + zmm20(k6) * 8 + 72]).encode())


class TestVSCATTERDPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF2, 0x7D, 0x09, 0xA2, 0x64, 0x86, 0xE0]), VSCATTERDPS([rsi + xmm0(k1) * 4 - 128], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7D, 0x2A, 0xA2, 0x6C, 0x83, 0x0C]), VSCATTERDPS([r11 + ymm8(k2) * 4 + 48], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x43, 0xA2, 0x54, 0x9F, 0xFC]), VSCATTERDPS([r15 + zmm19(k3) * 4 - 16], zmm26).encode())


class TestVSCATTERQPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF2, 0x7D, 0x0C, 0xA3, 0x64, 0xCE, 0x0A]), VSCATTERQPS([rsi + xmm1(k4) * 8 + 40], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7D, 0x2D, 0xA3, 0x64, 0xCB, 0xF2]), VSCATTERQPS([r11 + ymm9(k5) * 8 - 56], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7D, 0x46, 0xA3, 0x6C, 0xE7, 0x12]), VSCATTERQPS([r15 + zmm20(k6) * 8 + 72], ymm5).encode())


class TestVSCATTERPF0DPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD2, 0x7D, 0x43, 0xC6, 0x6C, 0x9F, 0xFC]), VSCATTERPF0DPS([r15 + zmm19(k3) * 4 - 16]).encode())


class TestVSCATTERPF0QPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD2, 0x7D, 0x46, 0xC7, 0x6C, 0xE7, 0x12]), VSCATTERPF0QPS([r15 + zmm20(k6) * 8 + 72]).encode())


class TestVSCATTERPF1DPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD2, 0x7D, 0x43, 0xC6, 0x74, 0x9F, 0xFC]), VSCATTERPF1DPS([r15 + zmm19(k3) * 4 - 16]).encode())


class TestVSCATTERPF1QPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD2, 0x7D, 0x46, 0xC7, 0x74, 0xE7, 0x12]), VSCATTERPF1QPS([r15 + zmm20(k6) * 8 + 72]).encode())


class TestVMOVAPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x29, 0x62, 0xC0]), VMOVAPD(oword[r10 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFD, 0x8A, 0x28, 0xF4]), VMOVAPD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7D, 0x29, 0x69, 0xC0]), VMOVAPD(hword[r9 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0xFD, 0xAD, 0x28, 0xDD]), VMOVAPD(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xFD, 0x48, 0x29, 0x50, 0xFF]), VMOVAPD(zword[r8 - 64], zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0xFD, 0xCE, 0x28, 0xCA]), VMOVAPD(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xFD, 0x8A, 0x28, 0x72, 0x04]), VMOVAPD(xmm30(k2.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFD, 0xAD, 0x28, 0x59, 0x02]), VMOVAPD(ymm19(k5.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xFD, 0xCE, 0x28, 0x48, 0x01]), VMOVAPD(zmm9(k6.z), zword[r8 + 64]).encode())
        self.assertEqual(bytearray([0xC5, 0x79, 0x29, 0xF1]), VMOVAPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x28, 0x4C, 0xC2, 0xB3]), VMOVAPD(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x7D, 0x29, 0xFA]), VMOVAPD(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7D, 0x28, 0x54, 0xD9, 0xBE]), VMOVAPD(ymm2, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC4, 0x41, 0x79, 0x29, 0x74, 0xC2, 0xB3]), VMOVAPD(oword[r10 + rax*8 - 77], xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0x41, 0x7D, 0x29, 0x7C, 0xD9, 0xBE]), VMOVAPD(hword[r9 + rbx*8 - 66], ymm15).encode())


class TestVMOVUPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x11, 0x62, 0xC0]), VMOVUPD(oword[r10 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFD, 0x8A, 0x10, 0xF4]), VMOVUPD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7D, 0x11, 0x69, 0xC0]), VMOVUPD(hword[r9 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0xFD, 0xAD, 0x10, 0xDD]), VMOVUPD(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xFD, 0x48, 0x11, 0x50, 0xFF]), VMOVUPD(zword[r8 - 64], zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0xFD, 0xCE, 0x10, 0xCA]), VMOVUPD(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xFD, 0x8A, 0x10, 0x72, 0x04]), VMOVUPD(xmm30(k2.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFD, 0xAD, 0x10, 0x59, 0x02]), VMOVUPD(ymm19(k5.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xFD, 0xCE, 0x10, 0x48, 0x01]), VMOVUPD(zmm9(k6.z), zword[r8 + 64]).encode())
        self.assertEqual(bytearray([0xC5, 0x79, 0x11, 0xF1]), VMOVUPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x10, 0x4C, 0xC2, 0xB3]), VMOVUPD(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x7D, 0x11, 0xFA]), VMOVUPD(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7D, 0x10, 0x54, 0xD9, 0xBE]), VMOVUPD(ymm2, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC4, 0x41, 0x79, 0x11, 0x74, 0xC2, 0xB3]), VMOVUPD(oword[r10 + rax*8 - 77], xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0x41, 0x7D, 0x11, 0x7C, 0xD9, 0xBE]), VMOVUPD(hword[r9 + rbx*8 - 66], ymm15).encode())


class TestVMOVLPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0x41, 0x79, 0x13, 0x74, 0xD3, 0xA8]), VMOVLPD(qword[r11 + rdx*8 - 88], xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x13, 0x63, 0xC0]), VMOVLPD(qword[r11 - 64], xmm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x12, 0x4C, 0xD3, 0xA8]), VMOVLPD(xmm1, xmm14, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xDD, 0x08, 0x12, 0x43, 0xF0]), VMOVLPD(xmm16, xmm4, qword[r11 - 128]).encode())


class TestVMOVHPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0x41, 0x79, 0x17, 0x74, 0xD3, 0xA8]), VMOVHPD(qword[r11 + rdx*8 - 88], xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x17, 0x63, 0xC0]), VMOVHPD(qword[r11 - 64], xmm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x16, 0x4C, 0xD3, 0xA8]), VMOVHPD(xmm1, xmm14, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xDD, 0x08, 0x16, 0x43, 0xF0]), VMOVHPD(xmm16, xmm4, qword[r11 - 128]).encode())


class TestVMASKMOVPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x2D, 0x4C, 0xC2, 0xB3]), VMASKMOVPD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x2D, 0x54, 0xD9, 0xBE]), VMASKMOVPD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x2F, 0x5C, 0xC2, 0xB3]), VMASKMOVPD(oword[r10 + rax*8 - 77], xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x2F, 0x64, 0xD9, 0xBE]), VMASKMOVPD(hword[r9 + rbx*8 - 66], ymm15, ymm4).encode())


class TestVMOVMSKPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x50, 0xEE]), VMOVMSKPD(ebp, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7D, 0x50, 0xEF]), VMOVMSKPD(ebp, ymm15).encode())


class TestVMOVNTPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0x41, 0x79, 0x2B, 0x74, 0xC2, 0xB3]), VMOVNTPD(oword[r10 + rax*8 - 77], xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x2B, 0x62, 0xC0]), VMOVNTPD(oword[r10 - 64], xmm4).encode())
        self.assertEqual(bytearray([0xC4, 0x41, 0x7D, 0x2B, 0x7C, 0xD9, 0xBE]), VMOVNTPD(hword[r9 + rbx*8 - 66], ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7D, 0x2B, 0x69, 0xC0]), VMOVNTPD(hword[r9 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xFD, 0x48, 0x2B, 0x50, 0xFF]), VMOVNTPD(zword[r8 - 64], zmm26).encode())


class TestVBROADCASTSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xE2, 0xFD, 0xAD, 0x19, 0xDC]), VBROADCASTSD(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0xFD, 0xCE, 0x19, 0xCC]), VBROADCASTSD(zmm9(k6.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xFD, 0xAD, 0x19, 0x5B, 0x08]), VBROADCASTSD(ymm19(k5.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xFD, 0xCE, 0x19, 0x4B, 0x08]), VBROADCASTSD(zmm9(k6.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x19, 0xD6]), VBROADCASTSD(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x19, 0x54, 0xD3, 0xA8]), VBROADCASTSD(ymm2, qword[r11 + rdx*8 - 88]).encode())


class TestVMOVDDUP(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x61, 0xFF, 0x8A, 0x12, 0xF4]), VMOVDDUP(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0xFF, 0xAD, 0x12, 0xDD]), VMOVDDUP(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0xFF, 0xCE, 0x12, 0xCA]), VMOVDDUP(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xFF, 0x8A, 0x12, 0x73, 0x08]), VMOVDDUP(xmm30(k2.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFF, 0xAD, 0x12, 0x59, 0x02]), VMOVDDUP(ymm19(k5.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xFF, 0xCE, 0x12, 0x48, 0x01]), VMOVDDUP(zmm9(k6.z), zword[r8 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7B, 0x12, 0xCE]), VMOVDDUP(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7B, 0x12, 0x4C, 0xD3, 0xA8]), VMOVDDUP(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7F, 0x12, 0xD7]), VMOVDDUP(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7F, 0x12, 0x54, 0xD9, 0xBE]), VMOVDDUP(ymm2, hword[r9 + rbx*8 - 66]).encode())


class TestVEXPANDPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x62, 0xFD, 0x8A, 0x88, 0xF4]), VEXPANDPD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0xFD, 0xAD, 0x88, 0xDD]), VEXPANDPD(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0xFD, 0xCE, 0x88, 0xCA]), VEXPANDPD(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xFD, 0x8A, 0x88, 0x72, 0x08]), VEXPANDPD(xmm30(k2.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xFD, 0xAD, 0x88, 0x59, 0x08]), VEXPANDPD(ymm19(k5.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xFD, 0xCE, 0x88, 0x48, 0x08]), VEXPANDPD(zmm9(k6.z), zword[r8 + 64]).encode())


class TestVCOMPRESSPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0xFD, 0x8A, 0x8A, 0xE6]), VCOMPRESSPD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xFD, 0x08, 0x8A, 0x62, 0xF8]), VCOMPRESSPD(oword[r10 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xB2, 0xFD, 0xAD, 0x8A, 0xEB]), VCOMPRESSPD(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xFD, 0x28, 0x8A, 0x69, 0xF8]), VCOMPRESSPD(hword[r9 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xFD, 0xCE, 0x8A, 0xD1]), VCOMPRESSPD(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xFD, 0x48, 0x8A, 0x50, 0xF8]), VCOMPRESSPD(zword[r8 - 64], zmm26).encode())


class TestVGATHERDPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF2, 0xFD, 0x09, 0x92, 0x6C, 0x86, 0xF0]), VGATHERDPD(xmm5(k1), [rsi + xmm0 * 4 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x62, 0xFD, 0x2B, 0x92, 0x44, 0x86, 0xF0]), VGATHERDPD(ymm24(k3), [rsi + xmm0 * 4 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x02, 0xFD, 0x4F, 0x92, 0x54, 0x83, 0x06]), VGATHERDPD(zmm26(k7), [r11 + ymm8 * 4 + 48]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0xE1, 0x92, 0x4C, 0x86, 0x80]), VGATHERDPD(xmm1, [rsi + xmm0 * 4 - 128], xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0xDD, 0x92, 0x54, 0x86, 0x80]), VGATHERDPD(ymm2, [rsi + xmm0 * 4 - 128], ymm4).encode())


class TestVGATHERQPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF2, 0xFD, 0x09, 0x93, 0x6C, 0xCE, 0x05]), VGATHERQPD(xmm5(k1), [rsi + xmm1 * 8 + 40]).encode())
        self.assertEqual(bytearray([0x62, 0x02, 0xFD, 0x2B, 0x93, 0x44, 0xCB, 0xF9]), VGATHERQPD(ymm24(k3), [r11 + ymm9 * 8 - 56]).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xFD, 0x47, 0x93, 0x54, 0xE7, 0x09]), VGATHERQPD(zmm26(k7), [r15 + zmm20 * 8 + 72]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0xE1, 0x93, 0x4C, 0xCE, 0x28]), VGATHERQPD(xmm1, [rsi + xmm1 * 8 + 40], xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0x82, 0xDD, 0x93, 0x54, 0xCB, 0xC8]), VGATHERQPD(ymm2, [r11 + ymm9 * 8 - 56], ymm4).encode())


class TestVGATHERPF0DPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0xFD, 0x4A, 0xC6, 0x4C, 0x83, 0x06]), VGATHERPF0DPD([r11 + ymm8(k2) * 4 + 48]).encode())


class TestVGATHERPF0QPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD2, 0xFD, 0x46, 0xC7, 0x4C, 0xE7, 0x09]), VGATHERPF0QPD([r15 + zmm20(k6) * 8 + 72]).encode())


class TestVGATHERPF1DPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0xFD, 0x4A, 0xC6, 0x54, 0x83, 0x06]), VGATHERPF1DPD([r11 + ymm8(k2) * 4 + 48]).encode())


class TestVGATHERPF1QPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD2, 0xFD, 0x46, 0xC7, 0x54, 0xE7, 0x09]), VGATHERPF1QPD([r15 + zmm20(k6) * 8 + 72]).encode())


class TestVSCATTERDPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF2, 0xFD, 0x09, 0xA2, 0x64, 0x86, 0xF0]), VSCATTERDPD([rsi + xmm0(k1) * 4 - 128], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xF2, 0xFD, 0x29, 0xA2, 0x6C, 0x86, 0xF0]), VSCATTERDPD([rsi + xmm0(k1) * 4 - 128], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x02, 0xFD, 0x4A, 0xA2, 0x54, 0x83, 0x06]), VSCATTERDPD([r11 + ymm8(k2) * 4 + 48], zmm26).encode())


class TestVSCATTERQPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF2, 0xFD, 0x0C, 0xA3, 0x64, 0xCE, 0x05]), VSCATTERQPD([rsi + xmm1(k4) * 8 + 40], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0xFD, 0x2D, 0xA3, 0x6C, 0xCB, 0xF9]), VSCATTERQPD([r11 + ymm9(k5) * 8 - 56], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xFD, 0x46, 0xA3, 0x54, 0xE7, 0x09]), VSCATTERQPD([r15 + zmm20(k6) * 8 + 72], zmm26).encode())


class TestVSCATTERPF0DPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0xFD, 0x4A, 0xC6, 0x6C, 0x83, 0x06]), VSCATTERPF0DPD([r11 + ymm8(k2) * 4 + 48]).encode())


class TestVSCATTERPF0QPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD2, 0xFD, 0x46, 0xC7, 0x6C, 0xE7, 0x09]), VSCATTERPF0QPD([r15 + zmm20(k6) * 8 + 72]).encode())


class TestVSCATTERPF1DPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0xFD, 0x4A, 0xC6, 0x74, 0x83, 0x06]), VSCATTERPF1DPD([r11 + ymm8(k2) * 4 + 48]).encode())


class TestVSCATTERPF1QPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD2, 0xFD, 0x46, 0xC7, 0x74, 0xE7, 0x09]), VSCATTERPF1QPD([r15 + zmm20(k6) * 8 + 72]).encode())


class TestVADDPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5C, 0x8A, 0x58, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VADDPS(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5C, 0x8A, 0x58, 0xF3]), VADDPS(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x54, 0xAD, 0x58, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VADDPS(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x54, 0xAD, 0x58, 0xDC]), VADDPS(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0xC6, 0x58, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VADDPS(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC5, 0x88, 0x58, 0xCB]), VADDPS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x08, 0x58, 0x4C, 0xC2, 0xB3]), VADDPS(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x84, 0x58, 0xD4]), VADDPS(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x04, 0x58, 0x54, 0xD9, 0xBE]), VADDPS(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0x96, 0x58, 0xC9]), VADDPS(zmm9(k6.z), zmm26, zmm9, {rn_sae}).encode())


class TestVHADDPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x8B, 0x7C, 0xCB]), VHADDPS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0B, 0x7C, 0x4C, 0xC2, 0xB3]), VHADDPS(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x87, 0x7C, 0xD4]), VHADDPS(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x07, 0x7C, 0x54, 0xD9, 0xBE]), VHADDPS(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVSUBPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5C, 0x8A, 0x5C, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VSUBPS(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5C, 0x8A, 0x5C, 0xF3]), VSUBPS(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x54, 0xAD, 0x5C, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VSUBPS(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x54, 0xAD, 0x5C, 0xDC]), VSUBPS(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0xC6, 0x5C, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VSUBPS(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC5, 0x88, 0x5C, 0xCB]), VSUBPS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x08, 0x5C, 0x4C, 0xC2, 0xB3]), VSUBPS(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x84, 0x5C, 0xD4]), VSUBPS(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x04, 0x5C, 0x54, 0xD9, 0xBE]), VSUBPS(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0x96, 0x5C, 0xC9]), VSUBPS(zmm9(k6.z), zmm26, zmm9, {rn_sae}).encode())


class TestVHSUBPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x8B, 0x7D, 0xCB]), VHSUBPS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0B, 0x7D, 0x4C, 0xC2, 0xB3]), VHSUBPS(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x87, 0x7D, 0xD4]), VHSUBPS(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x07, 0x7D, 0x54, 0xD9, 0xBE]), VHSUBPS(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVADDSUBPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x8B, 0xD0, 0xCB]), VADDSUBPS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0B, 0xD0, 0x4C, 0xC2, 0xB3]), VADDSUBPS(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x87, 0xD0, 0xD4]), VADDSUBPS(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x07, 0xD0, 0x54, 0xD9, 0xBE]), VADDSUBPS(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVMULPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5C, 0x8A, 0x59, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VMULPS(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5C, 0x8A, 0x59, 0xF3]), VMULPS(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x54, 0xAD, 0x59, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VMULPS(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x54, 0xAD, 0x59, 0xDC]), VMULPS(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0xC6, 0x59, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VMULPS(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC5, 0x88, 0x59, 0xCB]), VMULPS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x08, 0x59, 0x4C, 0xC2, 0xB3]), VMULPS(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x84, 0x59, 0xD4]), VMULPS(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x04, 0x59, 0x54, 0xD9, 0xBE]), VMULPS(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0x96, 0x59, 0xC9]), VMULPS(zmm9(k6.z), zmm26, zmm9, {rn_sae}).encode())


class TestVDIVPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5C, 0x8A, 0x5E, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VDIVPS(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5C, 0x8A, 0x5E, 0xF3]), VDIVPS(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x54, 0xAD, 0x5E, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VDIVPS(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x54, 0xAD, 0x5E, 0xDC]), VDIVPS(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0xC6, 0x5E, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VDIVPS(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC5, 0x88, 0x5E, 0xCB]), VDIVPS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x08, 0x5E, 0x4C, 0xC2, 0xB3]), VDIVPS(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x84, 0x5E, 0xD4]), VDIVPS(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x04, 0x5E, 0x54, 0xD9, 0xBE]), VDIVPS(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0x96, 0x5E, 0xC9]), VDIVPS(zmm9(k6.z), zmm26, zmm9, {rn_sae}).encode())


class TestVSQRTPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x7C, 0x8A, 0x51, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VSQRTPS(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7C, 0xAD, 0x51, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VSQRTPS(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7C, 0xCE, 0x51, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VSQRTPS(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0x7C, 0x8A, 0x51, 0xF4]), VSQRTPS(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7C, 0xAD, 0x51, 0xDD]), VSQRTPS(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x51, 0xCE]), VSQRTPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x51, 0x4C, 0xC2, 0xB3]), VSQRTPS(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7C, 0x51, 0xD7]), VSQRTPS(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7C, 0x51, 0x54, 0xD9, 0xBE]), VSQRTPS(ymm2, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0x7C, 0x9E, 0x51, 0xCA]), VSQRTPS(zmm9(k6.z), zmm26, {rn_sae}).encode())


class TestVADDPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0x58, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VADDPD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0x58, 0xF3]), VADDPD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0x58, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VADDPD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0x58, 0xDC]), VADDPD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x58, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VADDPD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x58, 0xCB]), VADDPD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x58, 0x4C, 0xC2, 0xB3]), VADDPD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x58, 0xD4]), VADDPD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x58, 0x54, 0xD9, 0xBE]), VADDPD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0x96, 0x58, 0xC9]), VADDPD(zmm9(k6.z), zmm26, zmm9, {rn_sae}).encode())


class TestVHADDPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x89, 0x7C, 0xCB]), VHADDPD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x7C, 0x4C, 0xC2, 0xB3]), VHADDPD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x7C, 0xD4]), VHADDPD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x7C, 0x54, 0xD9, 0xBE]), VHADDPD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVSUBPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0x5C, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VSUBPD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0x5C, 0xF3]), VSUBPD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0x5C, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VSUBPD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0x5C, 0xDC]), VSUBPD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x5C, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VSUBPD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x5C, 0xCB]), VSUBPD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x5C, 0x4C, 0xC2, 0xB3]), VSUBPD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x5C, 0xD4]), VSUBPD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x5C, 0x54, 0xD9, 0xBE]), VSUBPD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0x96, 0x5C, 0xC9]), VSUBPD(zmm9(k6.z), zmm26, zmm9, {rn_sae}).encode())


class TestVHSUBPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x89, 0x7D, 0xCB]), VHSUBPD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x7D, 0x4C, 0xC2, 0xB3]), VHSUBPD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x7D, 0xD4]), VHSUBPD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x7D, 0x54, 0xD9, 0xBE]), VHSUBPD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVADDSUBPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x89, 0xD0, 0xCB]), VADDSUBPD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xD0, 0x4C, 0xC2, 0xB3]), VADDSUBPD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xD0, 0xD4]), VADDSUBPD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xD0, 0x54, 0xD9, 0xBE]), VADDSUBPD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVMULPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0x59, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VMULPD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0x59, 0xF3]), VMULPD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0x59, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VMULPD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0x59, 0xDC]), VMULPD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x59, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VMULPD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x59, 0xCB]), VMULPD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x59, 0x4C, 0xC2, 0xB3]), VMULPD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x59, 0xD4]), VMULPD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x59, 0x54, 0xD9, 0xBE]), VMULPD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0x96, 0x59, 0xC9]), VMULPD(zmm9(k6.z), zmm26, zmm9, {rn_sae}).encode())


class TestVDIVPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0x5E, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VDIVPD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0x5E, 0xF3]), VDIVPD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0x5E, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VDIVPD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0x5E, 0xDC]), VDIVPD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x5E, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VDIVPD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x5E, 0xCB]), VDIVPD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x5E, 0x4C, 0xC2, 0xB3]), VDIVPD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x5E, 0xD4]), VDIVPD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x5E, 0x54, 0xD9, 0xBE]), VDIVPD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0x96, 0x5E, 0xC9]), VDIVPD(zmm9(k6.z), zmm26, zmm9, {rn_sae}).encode())


class TestVSQRTPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xFD, 0x8A, 0x51, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VSQRTPD(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFD, 0xAD, 0x51, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VSQRTPD(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xFD, 0xCE, 0x51, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VSQRTPD(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFD, 0x8A, 0x51, 0xF4]), VSQRTPD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0xFD, 0xAD, 0x51, 0xDD]), VSQRTPD(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x51, 0xCE]), VSQRTPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x51, 0x4C, 0xC2, 0xB3]), VSQRTPD(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7D, 0x51, 0xD7]), VSQRTPD(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7D, 0x51, 0x54, 0xD9, 0xBE]), VSQRTPD(ymm2, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0xFD, 0x9E, 0x51, 0xCA]), VSQRTPD(zmm9(k6.z), zmm26, {rn_sae}).encode())


class TestVROUNDPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x08, 0xCE, 0x02]), VROUNDPS(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x08, 0x4C, 0xC2, 0xB3, 0x02]), VROUNDPS(xmm1, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x7D, 0x08, 0xD7, 0x02]), VROUNDPS(ymm2, ymm15, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x7D, 0x08, 0x54, 0xD9, 0xBE, 0x02]), VROUNDPS(ymm2, hword[r9 + rbx*8 - 66], 2).encode())


class TestVRNDSCALEPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0x7D, 0x8A, 0x08, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VRNDSCALEPS(xmm30(k2.z), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0x7D, 0xAD, 0x08, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VRNDSCALEPS(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x7D, 0xCE, 0x08, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VRNDSCALEPS(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x63, 0x7D, 0x8A, 0x08, 0xF4, 0x02]), VRNDSCALEPS(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0xE3, 0x7D, 0xAD, 0x08, 0xDD, 0x02]), VRNDSCALEPS(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0x13, 0x7D, 0x9E, 0x08, 0xCA, 0x02]), VRNDSCALEPS(zmm9(k6.z), zmm26, {sae}, 2).encode())


class TestVRANGEPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0x5D, 0x8A, 0x50, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VRANGEPS(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0x23, 0x5D, 0x8A, 0x50, 0xF3, 0x02]), VRANGEPS(xmm30(k2.z), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0x55, 0xAD, 0x50, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VRANGEPS(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xA3, 0x55, 0xAD, 0x50, 0xDC, 0x02]), VRANGEPS(ymm19(k5.z), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x2D, 0xC6, 0x50, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VRANGEPS(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x2D, 0x96, 0x50, 0xC9, 0x02]), VRANGEPS(zmm9(k6.z), zmm26, zmm9, {sae}, 2).encode())


class TestVMINPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5C, 0x8A, 0x5D, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VMINPS(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5C, 0x8A, 0x5D, 0xF3]), VMINPS(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x54, 0xAD, 0x5D, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VMINPS(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x54, 0xAD, 0x5D, 0xDC]), VMINPS(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0xC6, 0x5D, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VMINPS(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC5, 0x88, 0x5D, 0xCB]), VMINPS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x08, 0x5D, 0x4C, 0xC2, 0xB3]), VMINPS(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x84, 0x5D, 0xD4]), VMINPS(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x04, 0x5D, 0x54, 0xD9, 0xBE]), VMINPS(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0x96, 0x5D, 0xC9]), VMINPS(zmm9(k6.z), zmm26, zmm9, {sae}).encode())


class TestVMAXPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5C, 0x8A, 0x5F, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VMAXPS(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5C, 0x8A, 0x5F, 0xF3]), VMAXPS(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x54, 0xAD, 0x5F, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VMAXPS(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x54, 0xAD, 0x5F, 0xDC]), VMAXPS(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0xC6, 0x5F, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VMAXPS(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC5, 0x88, 0x5F, 0xCB]), VMAXPS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x08, 0x5F, 0x4C, 0xC2, 0xB3]), VMAXPS(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x84, 0x5F, 0xD4]), VMAXPS(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x04, 0x5F, 0x54, 0xD9, 0xBE]), VMAXPS(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0x96, 0x5F, 0xC9]), VMAXPS(zmm9(k6.z), zmm26, zmm9, {sae}).encode())


class TestVREDUCEPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0x7D, 0x8A, 0x56, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VREDUCEPS(xmm30(k2.z), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0x7D, 0xAD, 0x56, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VREDUCEPS(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x7D, 0xCE, 0x56, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VREDUCEPS(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x63, 0x7D, 0x8A, 0x56, 0xF4, 0x02]), VREDUCEPS(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0xE3, 0x7D, 0xAD, 0x56, 0xDD, 0x02]), VREDUCEPS(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0x13, 0x7D, 0xCE, 0x56, 0xCA, 0x02]), VREDUCEPS(zmm9(k6.z), zmm26, 2).encode())


class TestVDPPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x09, 0x40, 0xCB, 0x02]), VDPPS(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x09, 0x40, 0x4C, 0xC2, 0xB3, 0x02]), VDPPS(xmm1, xmm14, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xE3, 0x05, 0x40, 0xD4, 0x02]), VDPPS(ymm2, ymm15, ymm4, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x05, 0x40, 0x54, 0xD9, 0xBE, 0x02]), VDPPS(ymm2, ymm15, hword[r9 + rbx*8 - 66], 2).encode())


class TestVGETMANTPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0x7D, 0x8A, 0x26, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VGETMANTPS(xmm30(k2.z), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0x7D, 0xAD, 0x26, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VGETMANTPS(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x7D, 0xCE, 0x26, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VGETMANTPS(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x63, 0x7D, 0x8A, 0x26, 0xF4, 0x02]), VGETMANTPS(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0xE3, 0x7D, 0xAD, 0x26, 0xDD, 0x02]), VGETMANTPS(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0x13, 0x7D, 0x9E, 0x26, 0xCA, 0x02]), VGETMANTPS(zmm9(k6.z), zmm26, {sae}, 2).encode())


class TestVGETEXPPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x42, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VGETEXPPS(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x42, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VGETEXPPS(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x42, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VGETEXPPS(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x42, 0xF4]), VGETEXPPS(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x42, 0xDD]), VGETEXPPS(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0x7D, 0x9E, 0x42, 0xCA]), VGETEXPPS(zmm9(k6.z), zmm26, {sae}).encode())


class TestVSCALEFPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x2C, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VSCALEFPS(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x2C, 0xF3]), VSCALEFPS(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x2C, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VSCALEFPS(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x2C, 0xDC]), VSCALEFPS(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x2C, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VSCALEFPS(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0x96, 0x2C, 0xC9]), VSCALEFPS(zmm9(k6.z), zmm26, zmm9, {rn_sae}).encode())


class TestVFIXUPIMMPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0x5D, 0x8A, 0x54, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VFIXUPIMMPS(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0x23, 0x5D, 0x8A, 0x54, 0xF3, 0x02]), VFIXUPIMMPS(xmm30(k2.z), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0x55, 0xAD, 0x54, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VFIXUPIMMPS(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xA3, 0x55, 0xAD, 0x54, 0xDC, 0x02]), VFIXUPIMMPS(ymm19(k5.z), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x2D, 0xC6, 0x54, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VFIXUPIMMPS(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x2D, 0x96, 0x54, 0xC9, 0x02]), VFIXUPIMMPS(zmm9(k6.z), zmm26, zmm9, {sae}, 2).encode())


class TestVFPCLASSPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD3, 0x7D, 0x0E, 0x66, 0xA4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VFPCLASSPS(k4(k6), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0x7D, 0x2E, 0x66, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VFPCLASSPS(k4(k6), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0x7D, 0x4E, 0x66, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VFPCLASSPS(k4(k6), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xF3, 0x7D, 0x0E, 0x66, 0xE4, 0x02]), VFPCLASSPS(k4(k6), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0xF3, 0x7D, 0x2E, 0x66, 0xE5, 0x02]), VFPCLASSPS(k4(k6), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0x93, 0x7D, 0x4E, 0x66, 0xE2, 0x02]), VFPCLASSPS(k4(k6), zmm26, 2).encode())


class TestVRCPPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x53, 0xCE]), VRCPPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x53, 0x4C, 0xC2, 0xB3]), VRCPPS(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7C, 0x53, 0xD7]), VRCPPS(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7C, 0x53, 0x54, 0xD9, 0xBE]), VRCPPS(ymm2, hword[r9 + rbx*8 - 66]).encode())


class TestVRSQRTPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x52, 0xCE]), VRSQRTPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x52, 0x4C, 0xC2, 0xB3]), VRSQRTPS(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7C, 0x52, 0xD7]), VRSQRTPS(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7C, 0x52, 0x54, 0xD9, 0xBE]), VRSQRTPS(ymm2, hword[r9 + rbx*8 - 66]).encode())


class TestVRCP14PS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x4C, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VRCP14PS(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x4C, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VRCP14PS(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x4C, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VRCP14PS(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x4C, 0xF4]), VRCP14PS(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x4C, 0xDD]), VRCP14PS(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0x7D, 0xCE, 0x4C, 0xCA]), VRCP14PS(zmm9(k6.z), zmm26).encode())


class TestVRSQRT14PS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x4E, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VRSQRT14PS(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x4E, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VRSQRT14PS(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x4E, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VRSQRT14PS(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x4E, 0xF4]), VRSQRT14PS(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x4E, 0xDD]), VRSQRT14PS(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0x7D, 0xCE, 0x4E, 0xCA]), VRSQRT14PS(zmm9(k6.z), zmm26).encode())


class TestVRCP28PS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0xCA, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VRCP28PS(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0x7D, 0x9E, 0xCA, 0xCA]), VRCP28PS(zmm9(k6.z), zmm26, {sae}).encode())


class TestVRSQRT28PS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0xCC, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VRSQRT28PS(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0x7D, 0x9E, 0xCC, 0xCA]), VRSQRT28PS(zmm9(k6.z), zmm26, {sae}).encode())


class TestVEXP2PS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0xC8, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VEXP2PS(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0x7D, 0x9E, 0xC8, 0xCA]), VEXP2PS(zmm9(k6.z), zmm26, {sae}).encode())


class TestVCMPPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x5C, 0x0E, 0xC2, 0xA4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VCMPPS(k4(k6), xmm4, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xB1, 0x5C, 0x0E, 0xC2, 0xE3, 0x02]), VCMPPS(k4(k6), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x54, 0x2E, 0xC2, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VCMPPS(k4(k6), ymm5, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xB1, 0x54, 0x2E, 0xC2, 0xE4, 0x02]), VCMPPS(k4(k6), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x2C, 0x46, 0xC2, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VCMPPS(k4(k6), zmm26, zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0xC5, 0x88, 0xC2, 0xCB, 0x02]), VCMPPS(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x08, 0xC2, 0x4C, 0xC2, 0xB3, 0x02]), VCMPPS(xmm1, xmm14, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0xC5, 0x84, 0xC2, 0xD4, 0x02]), VCMPPS(ymm2, ymm15, ymm4, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x04, 0xC2, 0x54, 0xD9, 0xBE, 0x02]), VCMPPS(ymm2, ymm15, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x2C, 0x16, 0xC2, 0xE1, 0x02]), VCMPPS(k4(k6), zmm26, zmm9, {sae}, 2).encode())


class TestVTESTPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x0E, 0xCE]), VTESTPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x0E, 0x4C, 0xC2, 0xB3]), VTESTPS(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x0E, 0xD7]), VTESTPS(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x0E, 0x54, 0xD9, 0xBE]), VTESTPS(ymm2, hword[r9 + rbx*8 - 66]).encode())


class TestVROUNDPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x09, 0xCE, 0x02]), VROUNDPD(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x09, 0x4C, 0xC2, 0xB3, 0x02]), VROUNDPD(xmm1, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x7D, 0x09, 0xD7, 0x02]), VROUNDPD(ymm2, ymm15, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x7D, 0x09, 0x54, 0xD9, 0xBE, 0x02]), VROUNDPD(ymm2, hword[r9 + rbx*8 - 66], 2).encode())


class TestVRNDSCALEPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0xFD, 0x8A, 0x09, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VRNDSCALEPD(xmm30(k2.z), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0xFD, 0xAD, 0x09, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VRNDSCALEPD(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xFD, 0xCE, 0x09, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VRNDSCALEPD(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x63, 0xFD, 0x8A, 0x09, 0xF4, 0x02]), VRNDSCALEPD(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0xE3, 0xFD, 0xAD, 0x09, 0xDD, 0x02]), VRNDSCALEPD(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0x13, 0xFD, 0x9E, 0x09, 0xCA, 0x02]), VRNDSCALEPD(zmm9(k6.z), zmm26, {sae}, 2).encode())


class TestVRANGEPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0xDD, 0x8A, 0x50, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VRANGEPD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0x23, 0xDD, 0x8A, 0x50, 0xF3, 0x02]), VRANGEPD(xmm30(k2.z), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0xD5, 0xAD, 0x50, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VRANGEPD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xA3, 0xD5, 0xAD, 0x50, 0xDC, 0x02]), VRANGEPD(ymm19(k5.z), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xAD, 0xC6, 0x50, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VRANGEPD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xAD, 0x96, 0x50, 0xC9, 0x02]), VRANGEPD(zmm9(k6.z), zmm26, zmm9, {sae}, 2).encode())


class TestVMINPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0x5D, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VMINPD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0x5D, 0xF3]), VMINPD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0x5D, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VMINPD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0x5D, 0xDC]), VMINPD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x5D, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VMINPD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x5D, 0xCB]), VMINPD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x5D, 0x4C, 0xC2, 0xB3]), VMINPD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x5D, 0xD4]), VMINPD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x5D, 0x54, 0xD9, 0xBE]), VMINPD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0x96, 0x5D, 0xC9]), VMINPD(zmm9(k6.z), zmm26, zmm9, {sae}).encode())


class TestVMAXPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0x5F, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VMAXPD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0x5F, 0xF3]), VMAXPD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0x5F, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VMAXPD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0x5F, 0xDC]), VMAXPD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x5F, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VMAXPD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x5F, 0xCB]), VMAXPD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x5F, 0x4C, 0xC2, 0xB3]), VMAXPD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x5F, 0xD4]), VMAXPD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x5F, 0x54, 0xD9, 0xBE]), VMAXPD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0x96, 0x5F, 0xC9]), VMAXPD(zmm9(k6.z), zmm26, zmm9, {sae}).encode())


class TestVREDUCEPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0xFD, 0x8A, 0x56, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VREDUCEPD(xmm30(k2.z), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0xFD, 0xAD, 0x56, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VREDUCEPD(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xFD, 0xCE, 0x56, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VREDUCEPD(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x63, 0xFD, 0x8A, 0x56, 0xF4, 0x02]), VREDUCEPD(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0xE3, 0xFD, 0xAD, 0x56, 0xDD, 0x02]), VREDUCEPD(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0x13, 0xFD, 0xCE, 0x56, 0xCA, 0x02]), VREDUCEPD(zmm9(k6.z), zmm26, 2).encode())


class TestVDPPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x09, 0x41, 0xCB, 0x02]), VDPPD(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x09, 0x41, 0x4C, 0xC2, 0xB3, 0x02]), VDPPD(xmm1, xmm14, oword[r10 + rax*8 - 77], 2).encode())


class TestVGETMANTPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0xFD, 0x8A, 0x26, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VGETMANTPD(xmm30(k2.z), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0xFD, 0xAD, 0x26, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VGETMANTPD(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xFD, 0xCE, 0x26, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VGETMANTPD(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x63, 0xFD, 0x8A, 0x26, 0xF4, 0x02]), VGETMANTPD(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0xE3, 0xFD, 0xAD, 0x26, 0xDD, 0x02]), VGETMANTPD(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0x13, 0xFD, 0x9E, 0x26, 0xCA, 0x02]), VGETMANTPD(zmm9(k6.z), zmm26, {sae}, 2).encode())


class TestVGETEXPPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xFD, 0x8A, 0x42, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VGETEXPPD(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xFD, 0xAD, 0x42, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VGETEXPPD(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xFD, 0xCE, 0x42, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VGETEXPPD(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x62, 0xFD, 0x8A, 0x42, 0xF4]), VGETEXPPD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0xFD, 0xAD, 0x42, 0xDD]), VGETEXPPD(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0xFD, 0x9E, 0x42, 0xCA]), VGETEXPPD(zmm9(k6.z), zmm26, {sae}).encode())


class TestVSCALEFPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x2C, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VSCALEFPD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x2C, 0xF3]), VSCALEFPD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x2C, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VSCALEFPD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x2C, 0xDC]), VSCALEFPD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x2C, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VSCALEFPD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0x96, 0x2C, 0xC9]), VSCALEFPD(zmm9(k6.z), zmm26, zmm9, {rn_sae}).encode())


class TestVFIXUPIMMPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0xDD, 0x8A, 0x54, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VFIXUPIMMPD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0x23, 0xDD, 0x8A, 0x54, 0xF3, 0x02]), VFIXUPIMMPD(xmm30(k2.z), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0xD5, 0xAD, 0x54, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VFIXUPIMMPD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xA3, 0xD5, 0xAD, 0x54, 0xDC, 0x02]), VFIXUPIMMPD(ymm19(k5.z), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xAD, 0xC6, 0x54, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VFIXUPIMMPD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xAD, 0x96, 0x54, 0xC9, 0x02]), VFIXUPIMMPD(zmm9(k6.z), zmm26, zmm9, {sae}, 2).encode())


class TestVFPCLASSPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD3, 0xFD, 0x0E, 0x66, 0xA4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VFPCLASSPD(k4(k6), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0xFD, 0x2E, 0x66, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VFPCLASSPD(k4(k6), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0xFD, 0x4E, 0x66, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VFPCLASSPD(k4(k6), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xF3, 0xFD, 0x0E, 0x66, 0xE4, 0x02]), VFPCLASSPD(k4(k6), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0xF3, 0xFD, 0x2E, 0x66, 0xE5, 0x02]), VFPCLASSPD(k4(k6), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0x93, 0xFD, 0x4E, 0x66, 0xE2, 0x02]), VFPCLASSPD(k4(k6), zmm26, 2).encode())


class TestVRCP14PD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xFD, 0x8A, 0x4C, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VRCP14PD(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xFD, 0xAD, 0x4C, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VRCP14PD(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xFD, 0xCE, 0x4C, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VRCP14PD(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x62, 0xFD, 0x8A, 0x4C, 0xF4]), VRCP14PD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0xFD, 0xAD, 0x4C, 0xDD]), VRCP14PD(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0xFD, 0xCE, 0x4C, 0xCA]), VRCP14PD(zmm9(k6.z), zmm26).encode())


class TestVRSQRT14PD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xFD, 0x8A, 0x4E, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VRSQRT14PD(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xFD, 0xAD, 0x4E, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VRSQRT14PD(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xFD, 0xCE, 0x4E, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VRSQRT14PD(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x62, 0xFD, 0x8A, 0x4E, 0xF4]), VRSQRT14PD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0xFD, 0xAD, 0x4E, 0xDD]), VRSQRT14PD(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0xFD, 0xCE, 0x4E, 0xCA]), VRSQRT14PD(zmm9(k6.z), zmm26).encode())


class TestVRCP28PD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x52, 0xFD, 0xCE, 0xCA, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VRCP28PD(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0xFD, 0x9E, 0xCA, 0xCA]), VRCP28PD(zmm9(k6.z), zmm26, {sae}).encode())


class TestVRSQRT28PD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x52, 0xFD, 0xCE, 0xCC, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VRSQRT28PD(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0xFD, 0x9E, 0xCC, 0xCA]), VRSQRT28PD(zmm9(k6.z), zmm26, {sae}).encode())


class TestVEXP2PD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x52, 0xFD, 0xCE, 0xC8, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VEXP2PD(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0xFD, 0x9E, 0xC8, 0xCA]), VEXP2PD(zmm9(k6.z), zmm26, {sae}).encode())


class TestVCMPPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0xDD, 0x0E, 0xC2, 0xA4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VCMPPD(k4(k6), xmm4, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xB1, 0xDD, 0x0E, 0xC2, 0xE3, 0x02]), VCMPPD(k4(k6), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0xD5, 0x2E, 0xC2, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VCMPPD(k4(k6), ymm5, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xB1, 0xD5, 0x2E, 0xC2, 0xE4, 0x02]), VCMPPD(k4(k6), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0xAD, 0x46, 0xC2, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VCMPPD(k4(k6), zmm26, zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xC2, 0xCB, 0x02]), VCMPPD(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xC2, 0x4C, 0xC2, 0xB3, 0x02]), VCMPPD(xmm1, xmm14, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xC2, 0xD4, 0x02]), VCMPPD(ymm2, ymm15, ymm4, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xC2, 0x54, 0xD9, 0xBE, 0x02]), VCMPPD(ymm2, ymm15, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0xAD, 0x16, 0xC2, 0xE1, 0x02]), VCMPPD(k4(k6), zmm26, zmm9, {sae}, 2).encode())


class TestVTESTPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x0F, 0xCE]), VTESTPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x0F, 0x4C, 0xC2, 0xB3]), VTESTPD(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x0F, 0xD7]), VTESTPD(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x0F, 0x54, 0xD9, 0xBE]), VTESTPD(ymm2, hword[r9 + rbx*8 - 66]).encode())


class TestVANDPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5C, 0x8A, 0x54, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VANDPS(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5C, 0x8A, 0x54, 0xF3]), VANDPS(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x54, 0xAD, 0x54, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VANDPS(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x54, 0xAD, 0x54, 0xDC]), VANDPS(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0xC6, 0x54, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VANDPS(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0xC6, 0x54, 0xC9]), VANDPS(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x88, 0x54, 0xCB]), VANDPS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x08, 0x54, 0x4C, 0xC2, 0xB3]), VANDPS(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x84, 0x54, 0xD4]), VANDPS(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x04, 0x54, 0x54, 0xD9, 0xBE]), VANDPS(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVANDNPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x88, 0x55, 0xCB]), VANDNPS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x08, 0x55, 0x4C, 0xC2, 0xB3]), VANDNPS(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x84, 0x55, 0xD4]), VANDNPS(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x04, 0x55, 0x54, 0xD9, 0xBE]), VANDNPS(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVORPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5C, 0x8A, 0x56, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VORPS(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5C, 0x8A, 0x56, 0xF3]), VORPS(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x54, 0xAD, 0x56, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VORPS(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x54, 0xAD, 0x56, 0xDC]), VORPS(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0xC6, 0x56, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VORPS(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0xC6, 0x56, 0xC9]), VORPS(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x88, 0x56, 0xCB]), VORPS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x08, 0x56, 0x4C, 0xC2, 0xB3]), VORPS(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x84, 0x56, 0xD4]), VORPS(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x04, 0x56, 0x54, 0xD9, 0xBE]), VORPS(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVXORPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5C, 0x8A, 0x57, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VXORPS(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5C, 0x8A, 0x57, 0xF3]), VXORPS(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x54, 0xAD, 0x57, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VXORPS(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x54, 0xAD, 0x57, 0xDC]), VXORPS(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0xC6, 0x57, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VXORPS(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0xC6, 0x57, 0xC9]), VXORPS(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x88, 0x57, 0xCB]), VXORPS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x08, 0x57, 0x4C, 0xC2, 0xB3]), VXORPS(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x84, 0x57, 0xD4]), VXORPS(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x04, 0x57, 0x54, 0xD9, 0xBE]), VXORPS(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVBLENDPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x09, 0x0C, 0xCB, 0x02]), VBLENDPS(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x09, 0x0C, 0x4C, 0xC2, 0xB3, 0x02]), VBLENDPS(xmm1, xmm14, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xE3, 0x05, 0x0C, 0xD4, 0x02]), VBLENDPS(ymm2, ymm15, ymm4, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x05, 0x0C, 0x54, 0xD9, 0xBE, 0x02]), VBLENDPS(ymm2, ymm15, hword[r9 + rbx*8 - 66], 2).encode())


class TestVBLENDVPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x09, 0x4A, 0xCB, 0x90]), VBLENDVPS(xmm1, xmm14, xmm3, xmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x09, 0x4A, 0x4C, 0xC2, 0xB3, 0x90]), VBLENDVPS(xmm1, xmm14, oword[r10 + rax*8 - 77], xmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xE3, 0x05, 0x4A, 0xD4, 0xA0]), VBLENDVPS(ymm2, ymm15, ymm4, ymm10).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x05, 0x4A, 0x54, 0xD9, 0xBE, 0xA0]), VBLENDVPS(ymm2, ymm15, hword[r9 + rbx*8 - 66], ymm10).encode())


class TestVBLENDMPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x65, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VBLENDMPS(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x65, 0xF3]), VBLENDMPS(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x65, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VBLENDMPS(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x65, 0xDC]), VBLENDMPS(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x65, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VBLENDMPS(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x65, 0xC9]), VBLENDMPS(zmm9(k6.z), zmm26, zmm9).encode())


class TestVANDPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0x54, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VANDPD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0x54, 0xF3]), VANDPD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0x54, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VANDPD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0x54, 0xDC]), VANDPD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x54, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VANDPD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x54, 0xC9]), VANDPD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x54, 0xCB]), VANDPD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x54, 0x4C, 0xC2, 0xB3]), VANDPD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x54, 0xD4]), VANDPD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x54, 0x54, 0xD9, 0xBE]), VANDPD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVANDNPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0x55, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VANDNPD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0x55, 0xF3]), VANDNPD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0x55, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VANDNPD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0x55, 0xDC]), VANDNPD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x55, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VANDNPD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x55, 0xC9]), VANDNPD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x55, 0xCB]), VANDNPD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x55, 0x4C, 0xC2, 0xB3]), VANDNPD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x55, 0xD4]), VANDNPD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x55, 0x54, 0xD9, 0xBE]), VANDNPD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVORPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0x56, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VORPD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0x56, 0xF3]), VORPD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0x56, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VORPD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0x56, 0xDC]), VORPD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x56, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VORPD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x56, 0xC9]), VORPD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x56, 0xCB]), VORPD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x56, 0x4C, 0xC2, 0xB3]), VORPD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x56, 0xD4]), VORPD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x56, 0x54, 0xD9, 0xBE]), VORPD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVXORPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0x57, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VXORPD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0x57, 0xF3]), VXORPD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0x57, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VXORPD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0x57, 0xDC]), VXORPD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x57, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VXORPD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x57, 0xC9]), VXORPD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x57, 0xCB]), VXORPD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x57, 0x4C, 0xC2, 0xB3]), VXORPD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x57, 0xD4]), VXORPD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x57, 0x54, 0xD9, 0xBE]), VXORPD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVBLENDPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x09, 0x0D, 0xCB, 0x02]), VBLENDPD(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x09, 0x0D, 0x4C, 0xC2, 0xB3, 0x02]), VBLENDPD(xmm1, xmm14, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xE3, 0x05, 0x0D, 0xD4, 0x02]), VBLENDPD(ymm2, ymm15, ymm4, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x05, 0x0D, 0x54, 0xD9, 0xBE, 0x02]), VBLENDPD(ymm2, ymm15, hword[r9 + rbx*8 - 66], 2).encode())


class TestVBLENDVPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x09, 0x4B, 0xCB, 0x90]), VBLENDVPD(xmm1, xmm14, xmm3, xmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x09, 0x4B, 0x4C, 0xC2, 0xB3, 0x90]), VBLENDVPD(xmm1, xmm14, oword[r10 + rax*8 - 77], xmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xE3, 0x05, 0x4B, 0xD4, 0xA0]), VBLENDVPD(ymm2, ymm15, ymm4, ymm10).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x05, 0x4B, 0x54, 0xD9, 0xBE, 0xA0]), VBLENDVPD(ymm2, ymm15, hword[r9 + rbx*8 - 66], ymm10).encode())


class TestVBLENDMPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x65, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VBLENDMPD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x65, 0xF3]), VBLENDMPD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x65, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VBLENDMPD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x65, 0xDC]), VBLENDMPD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x65, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VBLENDMPD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x65, 0xC9]), VBLENDMPD(zmm9(k6.z), zmm26, zmm9).encode())


class TestVUNPCKLPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5C, 0x8A, 0x14, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VUNPCKLPS(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5C, 0x8A, 0x14, 0xF3]), VUNPCKLPS(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x54, 0xAD, 0x14, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VUNPCKLPS(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x54, 0xAD, 0x14, 0xDC]), VUNPCKLPS(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0xC6, 0x14, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VUNPCKLPS(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0xC6, 0x14, 0xC9]), VUNPCKLPS(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x88, 0x14, 0xCB]), VUNPCKLPS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x08, 0x14, 0x4C, 0xC2, 0xB3]), VUNPCKLPS(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x84, 0x14, 0xD4]), VUNPCKLPS(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x04, 0x14, 0x54, 0xD9, 0xBE]), VUNPCKLPS(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVUNPCKHPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5C, 0x8A, 0x15, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VUNPCKHPS(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5C, 0x8A, 0x15, 0xF3]), VUNPCKHPS(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x54, 0xAD, 0x15, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VUNPCKHPS(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x54, 0xAD, 0x15, 0xDC]), VUNPCKHPS(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0xC6, 0x15, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VUNPCKHPS(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0xC6, 0x15, 0xC9]), VUNPCKHPS(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x88, 0x15, 0xCB]), VUNPCKHPS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x08, 0x15, 0x4C, 0xC2, 0xB3]), VUNPCKHPS(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x84, 0x15, 0xD4]), VUNPCKHPS(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x04, 0x15, 0x54, 0xD9, 0xBE]), VUNPCKHPS(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVMOVLHPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x88, 0x16, 0xCB]), VMOVLHPS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x5C, 0x08, 0x16, 0xC3]), VMOVLHPS(xmm16, xmm4, xmm19).encode())


class TestVMOVHLPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x88, 0x12, 0xCB]), VMOVHLPS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x5C, 0x08, 0x12, 0xC3]), VMOVHLPS(xmm16, xmm4, xmm19).encode())


class TestVSHUFPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5C, 0x8A, 0xC6, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VSHUFPS(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5C, 0x8A, 0xC6, 0xF3, 0x02]), VSHUFPS(xmm30(k2.z), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x54, 0xAD, 0xC6, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VSHUFPS(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x54, 0xAD, 0xC6, 0xDC, 0x02]), VSHUFPS(ymm19(k5.z), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0xC6, 0xC6, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VSHUFPS(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2C, 0xC6, 0xC6, 0xC9, 0x02]), VSHUFPS(zmm9(k6.z), zmm26, zmm9, 2).encode())
        self.assertEqual(bytearray([0xC5, 0x88, 0xC6, 0xCB, 0x02]), VSHUFPS(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x08, 0xC6, 0x4C, 0xC2, 0xB3, 0x02]), VSHUFPS(xmm1, xmm14, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0xC5, 0x84, 0xC6, 0xD4, 0x02]), VSHUFPS(ymm2, ymm15, ymm4, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x04, 0xC6, 0x54, 0xD9, 0xBE, 0x02]), VSHUFPS(ymm2, ymm15, hword[r9 + rbx*8 - 66], 2).encode())


class TestVUNPCKLPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0x14, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VUNPCKLPD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0x14, 0xF3]), VUNPCKLPD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0x14, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VUNPCKLPD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0x14, 0xDC]), VUNPCKLPD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x14, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VUNPCKLPD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x14, 0xC9]), VUNPCKLPD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x14, 0xCB]), VUNPCKLPD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x14, 0x4C, 0xC2, 0xB3]), VUNPCKLPD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x14, 0xD4]), VUNPCKLPD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x14, 0x54, 0xD9, 0xBE]), VUNPCKLPD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVUNPCKHPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0x15, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VUNPCKHPD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0x15, 0xF3]), VUNPCKHPD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0x15, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VUNPCKHPD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0x15, 0xDC]), VUNPCKHPD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x15, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VUNPCKHPD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x15, 0xC9]), VUNPCKHPD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x15, 0xCB]), VUNPCKHPD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x15, 0x4C, 0xC2, 0xB3]), VUNPCKHPD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x15, 0xD4]), VUNPCKHPD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x15, 0x54, 0xD9, 0xBE]), VUNPCKHPD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVSHUFPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0xC6, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VSHUFPD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0xC6, 0xF3, 0x02]), VSHUFPD(xmm30(k2.z), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0xC6, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VSHUFPD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0xC6, 0xDC, 0x02]), VSHUFPD(ymm19(k5.z), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0xC6, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VSHUFPD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0xC6, 0xC9, 0x02]), VSHUFPD(zmm9(k6.z), zmm26, zmm9, 2).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xC6, 0xCB, 0x02]), VSHUFPD(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xC6, 0x4C, 0xC2, 0xB3, 0x02]), VSHUFPD(xmm1, xmm14, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xC6, 0xD4, 0x02]), VSHUFPD(ymm2, ymm15, ymm4, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xC6, 0x54, 0xD9, 0xBE, 0x02]), VSHUFPD(ymm2, ymm15, hword[r9 + rbx*8 - 66], 2).encode())


class TestVPERMPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x16, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMPS(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x16, 0xDC]), VPERMPS(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x16, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMPS(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x16, 0xC9]), VPERMPS(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x16, 0xD4]), VPERMPS(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x16, 0x54, 0xD9, 0xBE]), VPERMPS(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPERMILPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0x7D, 0x8A, 0x04, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VPERMILPS(xmm30(k2.z), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0x7D, 0xAD, 0x04, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPERMILPS(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x7D, 0xCE, 0x04, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPERMILPS(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x0C, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPERMILPS(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x63, 0x7D, 0x8A, 0x04, 0xF4, 0x02]), VPERMILPS(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x0C, 0xF3]), VPERMILPS(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x0C, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMILPS(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xE3, 0x7D, 0xAD, 0x04, 0xDD, 0x02]), VPERMILPS(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x0C, 0xDC]), VPERMILPS(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x0C, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMILPS(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x13, 0x7D, 0xCE, 0x04, 0xCA, 0x02]), VPERMILPS(zmm9(k6.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x0C, 0xC9]), VPERMILPS(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x04, 0xCE, 0x02]), VPERMILPS(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x0C, 0xCB]), VPERMILPS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x0C, 0x4C, 0xC2, 0xB3]), VPERMILPS(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x04, 0x4C, 0xC2, 0xB3, 0x02]), VPERMILPS(xmm1, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x7D, 0x04, 0xD7, 0x02]), VPERMILPS(ymm2, ymm15, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x0C, 0xD4]), VPERMILPS(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x0C, 0x54, 0xD9, 0xBE]), VPERMILPS(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x7D, 0x04, 0x54, 0xD9, 0xBE, 0x02]), VPERMILPS(ymm2, hword[r9 + rbx*8 - 66], 2).encode())


class TestVPERMT2PS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x7F, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPERMT2PS(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x7F, 0xF3]), VPERMT2PS(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x7F, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMT2PS(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x7F, 0xDC]), VPERMT2PS(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x7F, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMT2PS(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x7F, 0xC9]), VPERMT2PS(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPERMI2PS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x77, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPERMI2PS(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x77, 0xF3]), VPERMI2PS(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x77, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMI2PS(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x77, 0xDC]), VPERMI2PS(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x77, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMI2PS(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x77, 0xC9]), VPERMI2PS(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPERMPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xC3, 0xFD, 0xAD, 0x01, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPERMPD(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xFD, 0xCE, 0x01, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPERMPD(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x16, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMPD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xE3, 0xFD, 0xAD, 0x01, 0xDD, 0x02]), VPERMPD(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x16, 0xDC]), VPERMPD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x16, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMPD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x13, 0xFD, 0xCE, 0x01, 0xCA, 0x02]), VPERMPD(zmm9(k6.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x16, 0xC9]), VPERMPD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0xFD, 0x01, 0xD7, 0x02]), VPERMPD(ymm2, ymm15, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0xFD, 0x01, 0x54, 0xD9, 0xBE, 0x02]), VPERMPD(ymm2, hword[r9 + rbx*8 - 66], 2).encode())


class TestVPERMILPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0xFD, 0x8A, 0x05, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VPERMILPD(xmm30(k2.z), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0xFD, 0xAD, 0x05, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPERMILPD(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xFD, 0xCE, 0x05, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPERMILPD(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x0D, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPERMILPD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x63, 0xFD, 0x8A, 0x05, 0xF4, 0x02]), VPERMILPD(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x0D, 0xF3]), VPERMILPD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x0D, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMILPD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xE3, 0xFD, 0xAD, 0x05, 0xDD, 0x02]), VPERMILPD(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x0D, 0xDC]), VPERMILPD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x0D, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMILPD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x13, 0xFD, 0xCE, 0x05, 0xCA, 0x02]), VPERMILPD(zmm9(k6.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x0D, 0xC9]), VPERMILPD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x05, 0xCE, 0x02]), VPERMILPD(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x0D, 0xCB]), VPERMILPD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x0D, 0x4C, 0xC2, 0xB3]), VPERMILPD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x05, 0x4C, 0xC2, 0xB3, 0x02]), VPERMILPD(xmm1, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x7D, 0x05, 0xD7, 0x02]), VPERMILPD(ymm2, ymm15, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x0D, 0xD4]), VPERMILPD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x0D, 0x54, 0xD9, 0xBE]), VPERMILPD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x7D, 0x05, 0x54, 0xD9, 0xBE, 0x02]), VPERMILPD(ymm2, hword[r9 + rbx*8 - 66], 2).encode())


class TestVPERMT2PD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x7F, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPERMT2PD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x7F, 0xF3]), VPERMT2PD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x7F, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMT2PD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x7F, 0xDC]), VPERMT2PD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x7F, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMT2PD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x7F, 0xC9]), VPERMT2PD(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPERMI2PD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x77, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPERMI2PD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x77, 0xF3]), VPERMI2PD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x77, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMI2PD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x77, 0xDC]), VPERMI2PD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x77, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMI2PD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x77, 0xC9]), VPERMI2PD(zmm9(k6.z), zmm26, zmm9).encode())


class TestVMOVD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x79, 0x7E, 0xF5]), VMOVD(ebp, xmm14).encode())
        self.assertEqual(bytearray([0xC5, 0xF9, 0x7E, 0xE5]), VMOVD(ebp, xmm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x6E, 0xC8]), VMOVD(xmm1, r8d).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7D, 0x08, 0x6E, 0xC0]), VMOVD(xmm16, r8d).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x6E, 0x4C, 0xCC, 0x9D]), VMOVD(xmm1, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7D, 0x08, 0x6E, 0x44, 0x24, 0x10]), VMOVD(xmm16, dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0x41, 0x79, 0x7E, 0x74, 0xCC, 0x9D]), VMOVD(dword[r12 + rcx*8 - 99], xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x7E, 0x64, 0x24, 0xC0]), VMOVD(dword[r12 - 64], xmm4).encode())


class TestVMOVQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0x61, 0xF9, 0x7E, 0xF1]), VMOVQ(rcx, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xE1, 0xF9, 0x7E, 0xE1]), VMOVQ(rcx, xmm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0xF9, 0x6E, 0xCF]), VMOVQ(xmm1, r15).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFD, 0x08, 0x6E, 0xC7]), VMOVQ(xmm16, r15).encode())
        self.assertEqual(bytearray([0xC5, 0x79, 0xD6, 0xF1]), VMOVQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0xFE, 0x08, 0x7E, 0xC4]), VMOVQ(xmm16, xmm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7A, 0x7E, 0x4C, 0xD3, 0xA8]), VMOVQ(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFD, 0x08, 0x6E, 0x43, 0x08]), VMOVQ(xmm16, qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0x41, 0x79, 0xD6, 0x74, 0xD3, 0xA8]), VMOVQ(qword[r11 + rdx*8 - 88], xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0xD6, 0x63, 0xC0]), VMOVQ(qword[r11 - 64], xmm4).encode())


class TestVMOVDQA(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x79, 0x7F, 0xF1]), VMOVDQA(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x6F, 0x4C, 0xC2, 0xB3]), VMOVDQA(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x7D, 0x7F, 0xFA]), VMOVDQA(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7D, 0x6F, 0x54, 0xD9, 0xBE]), VMOVDQA(ymm2, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC4, 0x41, 0x79, 0x7F, 0x74, 0xC2, 0xB3]), VMOVDQA(oword[r10 + rax*8 - 77], xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0x41, 0x7D, 0x7F, 0x7C, 0xD9, 0xBE]), VMOVDQA(hword[r9 + rbx*8 - 66], ymm15).encode())


class TestVMOVDQA32(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x7D, 0x08, 0x7F, 0x62, 0xFC]), VMOVDQA32(oword[r10 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0x7D, 0x8A, 0x6F, 0xF4]), VMOVDQA32(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x7D, 0x28, 0x7F, 0x69, 0xFE]), VMOVDQA32(hword[r9 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7D, 0xAD, 0x6F, 0xDD]), VMOVDQA32(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x7D, 0x48, 0x7F, 0x50, 0xFF]), VMOVDQA32(zword[r8 - 64], zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0x7D, 0xCE, 0x6F, 0xCA]), VMOVDQA32(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x7D, 0x8A, 0x6F, 0x72, 0x04]), VMOVDQA32(xmm30(k2.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7D, 0xAD, 0x6F, 0x59, 0x02]), VMOVDQA32(ymm19(k5.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7D, 0xCE, 0x6F, 0x48, 0x01]), VMOVDQA32(zmm9(k6.z), zword[r8 + 64]).encode())


class TestVMOVDQA64(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0xFD, 0x08, 0x7F, 0x62, 0xFC]), VMOVDQA64(oword[r10 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFD, 0x8A, 0x6F, 0xF4]), VMOVDQA64(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0xFD, 0x28, 0x7F, 0x69, 0xFE]), VMOVDQA64(hword[r9 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0xFD, 0xAD, 0x6F, 0xDD]), VMOVDQA64(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xFD, 0x48, 0x7F, 0x50, 0xFF]), VMOVDQA64(zword[r8 - 64], zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0xFD, 0xCE, 0x6F, 0xCA]), VMOVDQA64(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xFD, 0x8A, 0x6F, 0x72, 0x04]), VMOVDQA64(xmm30(k2.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFD, 0xAD, 0x6F, 0x59, 0x02]), VMOVDQA64(ymm19(k5.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xFD, 0xCE, 0x6F, 0x48, 0x01]), VMOVDQA64(zmm9(k6.z), zword[r8 + 64]).encode())


class TestVMOVDQU(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x7A, 0x7F, 0xF1]), VMOVDQU(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7A, 0x6F, 0x4C, 0xC2, 0xB3]), VMOVDQU(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x7E, 0x7F, 0xFA]), VMOVDQU(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7E, 0x6F, 0x54, 0xD9, 0xBE]), VMOVDQU(ymm2, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC4, 0x41, 0x7A, 0x7F, 0x74, 0xC2, 0xB3]), VMOVDQU(oword[r10 + rax*8 - 77], xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0x41, 0x7E, 0x7F, 0x7C, 0xD9, 0xBE]), VMOVDQU(hword[r9 + rbx*8 - 66], ymm15).encode())


class TestVMOVDQU8(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x7F, 0x08, 0x7F, 0x62, 0xFC]), VMOVDQU8(oword[r10 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0x7F, 0x8A, 0x6F, 0xF4]), VMOVDQU8(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x7F, 0x28, 0x7F, 0x69, 0xFE]), VMOVDQU8(hword[r9 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7F, 0xAD, 0x6F, 0xDD]), VMOVDQU8(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x7F, 0x48, 0x7F, 0x50, 0xFF]), VMOVDQU8(zword[r8 - 64], zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0x7F, 0xCE, 0x6F, 0xCA]), VMOVDQU8(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x7F, 0x8A, 0x6F, 0x72, 0x04]), VMOVDQU8(xmm30(k2.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7F, 0xAD, 0x6F, 0x59, 0x02]), VMOVDQU8(ymm19(k5.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7F, 0xCE, 0x6F, 0x48, 0x01]), VMOVDQU8(zmm9(k6.z), zword[r8 + 64]).encode())


class TestVMOVDQU16(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0xFF, 0x08, 0x7F, 0x62, 0xFC]), VMOVDQU16(oword[r10 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFF, 0x8A, 0x6F, 0xF4]), VMOVDQU16(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0xFF, 0x28, 0x7F, 0x69, 0xFE]), VMOVDQU16(hword[r9 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0xFF, 0xAD, 0x6F, 0xDD]), VMOVDQU16(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xFF, 0x48, 0x7F, 0x50, 0xFF]), VMOVDQU16(zword[r8 - 64], zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0xFF, 0xCE, 0x6F, 0xCA]), VMOVDQU16(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xFF, 0x8A, 0x6F, 0x72, 0x04]), VMOVDQU16(xmm30(k2.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFF, 0xAD, 0x6F, 0x59, 0x02]), VMOVDQU16(ymm19(k5.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xFF, 0xCE, 0x6F, 0x48, 0x01]), VMOVDQU16(zmm9(k6.z), zword[r8 + 64]).encode())


class TestVMOVDQU32(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x7E, 0x08, 0x7F, 0x62, 0xFC]), VMOVDQU32(oword[r10 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0x7E, 0x8A, 0x6F, 0xF4]), VMOVDQU32(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x7E, 0x28, 0x7F, 0x69, 0xFE]), VMOVDQU32(hword[r9 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7E, 0xAD, 0x6F, 0xDD]), VMOVDQU32(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x7E, 0x48, 0x7F, 0x50, 0xFF]), VMOVDQU32(zword[r8 - 64], zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0x7E, 0xCE, 0x6F, 0xCA]), VMOVDQU32(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x7E, 0x8A, 0x6F, 0x72, 0x04]), VMOVDQU32(xmm30(k2.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7E, 0xAD, 0x6F, 0x59, 0x02]), VMOVDQU32(ymm19(k5.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7E, 0xCE, 0x6F, 0x48, 0x01]), VMOVDQU32(zmm9(k6.z), zword[r8 + 64]).encode())


class TestVMOVDQU64(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0xFE, 0x08, 0x7F, 0x62, 0xFC]), VMOVDQU64(oword[r10 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFE, 0x8A, 0x6F, 0xF4]), VMOVDQU64(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0xFE, 0x28, 0x7F, 0x69, 0xFE]), VMOVDQU64(hword[r9 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0xFE, 0xAD, 0x6F, 0xDD]), VMOVDQU64(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xFE, 0x48, 0x7F, 0x50, 0xFF]), VMOVDQU64(zword[r8 - 64], zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0xFE, 0xCE, 0x6F, 0xCA]), VMOVDQU64(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xFE, 0x8A, 0x6F, 0x72, 0x04]), VMOVDQU64(xmm30(k2.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFE, 0xAD, 0x6F, 0x59, 0x02]), VMOVDQU64(ymm19(k5.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xFE, 0xCE, 0x6F, 0x48, 0x01]), VMOVDQU64(zmm9(k6.z), zword[r8 + 64]).encode())


class TestVLDDQU(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7B, 0xF0, 0x4C, 0xC2, 0xB3]), VLDDQU(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7F, 0xF0, 0x54, 0xD9, 0xBE]), VLDDQU(ymm2, hword[r9 + rbx*8 - 66]).encode())


class TestVPBROADCASTB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x7A, 0xF0]), VPBROADCASTB(xmm30(k2.z), r8d).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x7A, 0xD8]), VPBROADCASTB(ymm19(k5.z), r8d).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x7A, 0xC8]), VPBROADCASTB(zmm9(k6.z), r8d).encode())
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x78, 0xF4]), VPBROADCASTB(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x78, 0xDC]), VPBROADCASTB(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0x7D, 0xCE, 0x78, 0xCC]), VPBROADCASTB(zmm9(k6.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x78, 0x76, 0x40]), VPBROADCASTB(xmm30(k2.z), byte[r14 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x78, 0x5E, 0x40]), VPBROADCASTB(ymm19(k5.z), byte[r14 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x78, 0x4E, 0x40]), VPBROADCASTB(zmm9(k6.z), byte[r14 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x78, 0xCE]), VPBROADCASTB(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x78, 0x4C, 0xBE, 0x85]), VPBROADCASTB(xmm1, byte[r14 + rdi*4 - 123]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x78, 0xD6]), VPBROADCASTB(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x78, 0x54, 0xBE, 0x85]), VPBROADCASTB(ymm2, byte[r14 + rdi*4 - 123]).encode())


class TestVPBROADCASTW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x7B, 0xF0]), VPBROADCASTW(xmm30(k2.z), r8d).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x7B, 0xD8]), VPBROADCASTW(ymm19(k5.z), r8d).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x7B, 0xC8]), VPBROADCASTW(zmm9(k6.z), r8d).encode())
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x79, 0xF4]), VPBROADCASTW(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x79, 0xDC]), VPBROADCASTW(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0x7D, 0xCE, 0x79, 0xCC]), VPBROADCASTW(zmm9(k6.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x79, 0x75, 0x20]), VPBROADCASTW(xmm30(k2.z), word[r13 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x79, 0x5D, 0x20]), VPBROADCASTW(ymm19(k5.z), word[r13 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x79, 0x4D, 0x20]), VPBROADCASTW(zmm9(k6.z), word[r13 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x79, 0xCE]), VPBROADCASTW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x79, 0x4C, 0xED, 0x95]), VPBROADCASTW(xmm1, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x79, 0xD6]), VPBROADCASTW(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x79, 0x54, 0xED, 0x95]), VPBROADCASTW(ymm2, word[r13 + rbp*8 - 107]).encode())


class TestVPBROADCASTD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x7C, 0xF0]), VPBROADCASTD(xmm30(k2.z), r8d).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x7C, 0xD8]), VPBROADCASTD(ymm19(k5.z), r8d).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x7C, 0xC8]), VPBROADCASTD(zmm9(k6.z), r8d).encode())
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x58, 0xF4]), VPBROADCASTD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x58, 0xDC]), VPBROADCASTD(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0x7D, 0xCE, 0x58, 0xCC]), VPBROADCASTD(zmm9(k6.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x58, 0x74, 0x24, 0x10]), VPBROADCASTD(xmm30(k2.z), dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x58, 0x5C, 0x24, 0x10]), VPBROADCASTD(ymm19(k5.z), dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x58, 0x4C, 0x24, 0x10]), VPBROADCASTD(zmm9(k6.z), dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x58, 0xCE]), VPBROADCASTD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x58, 0x4C, 0xCC, 0x9D]), VPBROADCASTD(xmm1, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x58, 0xD6]), VPBROADCASTD(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x58, 0x54, 0xCC, 0x9D]), VPBROADCASTD(ymm2, dword[r12 + rcx*8 - 99]).encode())


class TestVPBROADCASTQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xFD, 0x8A, 0x7C, 0xF7]), VPBROADCASTQ(xmm30(k2.z), r15).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xFD, 0xAD, 0x7C, 0xDF]), VPBROADCASTQ(ymm19(k5.z), r15).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xFD, 0xCE, 0x7C, 0xCF]), VPBROADCASTQ(zmm9(k6.z), r15).encode())
        self.assertEqual(bytearray([0x62, 0x62, 0xFD, 0x8A, 0x59, 0xF4]), VPBROADCASTQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0xFD, 0xAD, 0x59, 0xDC]), VPBROADCASTQ(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0xFD, 0xCE, 0x59, 0xCC]), VPBROADCASTQ(zmm9(k6.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xFD, 0x8A, 0x59, 0x73, 0x08]), VPBROADCASTQ(xmm30(k2.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xFD, 0xAD, 0x59, 0x5B, 0x08]), VPBROADCASTQ(ymm19(k5.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xFD, 0xCE, 0x59, 0x4B, 0x08]), VPBROADCASTQ(zmm9(k6.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x59, 0xCE]), VPBROADCASTQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x59, 0x4C, 0xD3, 0xA8]), VPBROADCASTQ(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x59, 0xD6]), VPBROADCASTQ(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x59, 0x54, 0xD3, 0xA8]), VPBROADCASTQ(ymm2, qword[r11 + rdx*8 - 88]).encode())


class TestVPEXPANDD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x89, 0xF4]), VPEXPANDD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x89, 0xDD]), VPEXPANDD(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0x7D, 0xCE, 0x89, 0xCA]), VPEXPANDD(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x89, 0x72, 0x10]), VPEXPANDD(xmm30(k2.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x89, 0x59, 0x10]), VPEXPANDD(ymm19(k5.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x89, 0x48, 0x10]), VPEXPANDD(zmm9(k6.z), zword[r8 + 64]).encode())


class TestVPEXPANDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x62, 0xFD, 0x8A, 0x89, 0xF4]), VPEXPANDQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0xFD, 0xAD, 0x89, 0xDD]), VPEXPANDQ(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0xFD, 0xCE, 0x89, 0xCA]), VPEXPANDQ(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xFD, 0x8A, 0x89, 0x72, 0x08]), VPEXPANDQ(xmm30(k2.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xFD, 0xAD, 0x89, 0x59, 0x08]), VPEXPANDQ(ymm19(k5.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xFD, 0xCE, 0x89, 0x48, 0x08]), VPEXPANDQ(zmm9(k6.z), zword[r8 + 64]).encode())


class TestVPCOMPRESSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0x7D, 0x8A, 0x8B, 0xE6]), VPCOMPRESSD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7D, 0x08, 0x8B, 0x62, 0xF0]), VPCOMPRESSD(oword[r10 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xB2, 0x7D, 0xAD, 0x8B, 0xEB]), VPCOMPRESSD(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7D, 0x28, 0x8B, 0x69, 0xF0]), VPCOMPRESSD(hword[r9 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0xCE, 0x8B, 0xD1]), VPCOMPRESSD(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x48, 0x8B, 0x50, 0xF0]), VPCOMPRESSD(zword[r8 - 64], zmm26).encode())


class TestVPCOMPRESSQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0xFD, 0x8A, 0x8B, 0xE6]), VPCOMPRESSQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xFD, 0x08, 0x8B, 0x62, 0xF8]), VPCOMPRESSQ(oword[r10 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xB2, 0xFD, 0xAD, 0x8B, 0xEB]), VPCOMPRESSQ(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xFD, 0x28, 0x8B, 0x69, 0xF8]), VPCOMPRESSQ(hword[r9 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xFD, 0xCE, 0x8B, 0xD1]), VPCOMPRESSQ(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xFD, 0x48, 0x8B, 0x50, 0xF8]), VPCOMPRESSQ(zword[r8 - 64], zmm26).encode())


class TestVPMASKMOVD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x8C, 0x4C, 0xC2, 0xB3]), VPMASKMOVD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x8C, 0x54, 0xD9, 0xBE]), VPMASKMOVD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x8E, 0x5C, 0xC2, 0xB3]), VPMASKMOVD(oword[r10 + rax*8 - 77], xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x8E, 0x64, 0xD9, 0xBE]), VPMASKMOVD(hword[r9 + rbx*8 - 66], ymm15, ymm4).encode())


class TestVPMASKMOVQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC2, 0x89, 0x8C, 0x4C, 0xC2, 0xB3]), VPMASKMOVQ(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x85, 0x8C, 0x54, 0xD9, 0xBE]), VPMASKMOVQ(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x89, 0x8E, 0x5C, 0xC2, 0xB3]), VPMASKMOVQ(oword[r10 + rax*8 - 77], xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x85, 0x8E, 0x64, 0xD9, 0xBE]), VPMASKMOVQ(hword[r9 + rbx*8 - 66], ymm15, ymm4).encode())


class TestVMASKMOVDQU(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0xF7, 0xCE]), VMASKMOVDQU(xmm1, xmm14).encode())


class TestVMOVNTDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0x41, 0x79, 0xE7, 0x74, 0xC2, 0xB3]), VMOVNTDQ(oword[r10 + rax*8 - 77], xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0xE7, 0x62, 0xC0]), VMOVNTDQ(oword[r10 - 64], xmm4).encode())
        self.assertEqual(bytearray([0xC4, 0x41, 0x7D, 0xE7, 0x7C, 0xD9, 0xBE]), VMOVNTDQ(hword[r9 + rbx*8 - 66], ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7D, 0xE7, 0x69, 0xC0]), VMOVNTDQ(hword[r9 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x7D, 0x48, 0xE7, 0x50, 0xFF]), VMOVNTDQ(zword[r8 - 64], zmm26).encode())


class TestVMOVNTDQA(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x2A, 0x4C, 0xC2, 0xB3]), VMOVNTDQA(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0x08, 0x2A, 0x42, 0x04]), VMOVNTDQA(xmm16, oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x2A, 0x54, 0xD9, 0xBE]), VMOVNTDQA(ymm2, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0x28, 0x2A, 0x49, 0x02]), VMOVNTDQA(ymm17, hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7D, 0x48, 0x2A, 0x58, 0x01]), VMOVNTDQA(zmm3, zword[r8 + 64]).encode())


class TestVPMOVSXBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x20, 0xF4]), VPMOVSXBW(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x20, 0xDC]), VPMOVSXBW(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0x7D, 0xCE, 0x20, 0xCD]), VPMOVSXBW(zmm9(k6.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x20, 0x73, 0x08]), VPMOVSXBW(xmm30(k2.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x20, 0x5A, 0x04]), VPMOVSXBW(ymm19(k5.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x20, 0x49, 0x02]), VPMOVSXBW(zmm9(k6.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x20, 0xCE]), VPMOVSXBW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x20, 0x4C, 0xD3, 0xA8]), VPMOVSXBW(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x20, 0xD6]), VPMOVSXBW(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x20, 0x54, 0xC2, 0xB3]), VPMOVSXBW(ymm2, oword[r10 + rax*8 - 77]).encode())


class TestVPMOVSXBD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x21, 0xF4]), VPMOVSXBD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x21, 0xDC]), VPMOVSXBD(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0x7D, 0xCE, 0x21, 0xCC]), VPMOVSXBD(zmm9(k6.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x21, 0x74, 0x24, 0x10]), VPMOVSXBD(xmm30(k2.z), dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x21, 0x5B, 0x08]), VPMOVSXBD(ymm19(k5.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x21, 0x4A, 0x04]), VPMOVSXBD(zmm9(k6.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x21, 0xCE]), VPMOVSXBD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x21, 0x4C, 0xCC, 0x9D]), VPMOVSXBD(xmm1, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x21, 0xD6]), VPMOVSXBD(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x21, 0x54, 0xD3, 0xA8]), VPMOVSXBD(ymm2, qword[r11 + rdx*8 - 88]).encode())


class TestVPMOVSXBQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x22, 0xF4]), VPMOVSXBQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x22, 0xDC]), VPMOVSXBQ(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0x7D, 0xCE, 0x22, 0xCC]), VPMOVSXBQ(zmm9(k6.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x22, 0x75, 0x20]), VPMOVSXBQ(xmm30(k2.z), word[r13 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x22, 0x5C, 0x24, 0x10]), VPMOVSXBQ(ymm19(k5.z), dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x22, 0x4B, 0x08]), VPMOVSXBQ(zmm9(k6.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x22, 0xCE]), VPMOVSXBQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x22, 0x4C, 0xED, 0x95]), VPMOVSXBQ(xmm1, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x22, 0xD6]), VPMOVSXBQ(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x22, 0x54, 0xCC, 0x9D]), VPMOVSXBQ(ymm2, dword[r12 + rcx*8 - 99]).encode())


class TestVPMOVSXWD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x23, 0xF4]), VPMOVSXWD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x23, 0xDC]), VPMOVSXWD(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0x7D, 0xCE, 0x23, 0xCD]), VPMOVSXWD(zmm9(k6.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x23, 0x73, 0x08]), VPMOVSXWD(xmm30(k2.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x23, 0x5A, 0x04]), VPMOVSXWD(ymm19(k5.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x23, 0x49, 0x02]), VPMOVSXWD(zmm9(k6.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x23, 0xCE]), VPMOVSXWD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x23, 0x4C, 0xD3, 0xA8]), VPMOVSXWD(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x23, 0xD6]), VPMOVSXWD(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x23, 0x54, 0xC2, 0xB3]), VPMOVSXWD(ymm2, oword[r10 + rax*8 - 77]).encode())


class TestVPMOVSXWQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x24, 0xF4]), VPMOVSXWQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x24, 0xDC]), VPMOVSXWQ(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0x7D, 0xCE, 0x24, 0xCC]), VPMOVSXWQ(zmm9(k6.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x24, 0x74, 0x24, 0x10]), VPMOVSXWQ(xmm30(k2.z), dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x24, 0x5B, 0x08]), VPMOVSXWQ(ymm19(k5.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x24, 0x4A, 0x04]), VPMOVSXWQ(zmm9(k6.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x24, 0xCE]), VPMOVSXWQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x24, 0x4C, 0xCC, 0x9D]), VPMOVSXWQ(xmm1, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x24, 0xD6]), VPMOVSXWQ(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x24, 0x54, 0xD3, 0xA8]), VPMOVSXWQ(ymm2, qword[r11 + rdx*8 - 88]).encode())


class TestVPMOVSXDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x25, 0xF4]), VPMOVSXDQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x25, 0xDC]), VPMOVSXDQ(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0x7D, 0xCE, 0x25, 0xCD]), VPMOVSXDQ(zmm9(k6.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x25, 0x73, 0x08]), VPMOVSXDQ(xmm30(k2.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x25, 0x5A, 0x04]), VPMOVSXDQ(ymm19(k5.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x25, 0x49, 0x02]), VPMOVSXDQ(zmm9(k6.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x25, 0xCE]), VPMOVSXDQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x25, 0x4C, 0xD3, 0xA8]), VPMOVSXDQ(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x25, 0xD6]), VPMOVSXDQ(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x25, 0x54, 0xC2, 0xB3]), VPMOVSXDQ(ymm2, oword[r10 + rax*8 - 77]).encode())


class TestVPMOVZXBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x30, 0xF4]), VPMOVZXBW(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x30, 0xDC]), VPMOVZXBW(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0x7D, 0xCE, 0x30, 0xCD]), VPMOVZXBW(zmm9(k6.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x30, 0x73, 0x08]), VPMOVZXBW(xmm30(k2.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x30, 0x5A, 0x04]), VPMOVZXBW(ymm19(k5.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x30, 0x49, 0x02]), VPMOVZXBW(zmm9(k6.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x30, 0xCE]), VPMOVZXBW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x30, 0x4C, 0xD3, 0xA8]), VPMOVZXBW(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x30, 0xD6]), VPMOVZXBW(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x30, 0x54, 0xC2, 0xB3]), VPMOVZXBW(ymm2, oword[r10 + rax*8 - 77]).encode())


class TestVPMOVZXBD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x31, 0xF4]), VPMOVZXBD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x31, 0xDC]), VPMOVZXBD(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0x7D, 0xCE, 0x31, 0xCC]), VPMOVZXBD(zmm9(k6.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x31, 0x74, 0x24, 0x10]), VPMOVZXBD(xmm30(k2.z), dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x31, 0x5B, 0x08]), VPMOVZXBD(ymm19(k5.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x31, 0x4A, 0x04]), VPMOVZXBD(zmm9(k6.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x31, 0xCE]), VPMOVZXBD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x31, 0x4C, 0xCC, 0x9D]), VPMOVZXBD(xmm1, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x31, 0xD6]), VPMOVZXBD(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x31, 0x54, 0xD3, 0xA8]), VPMOVZXBD(ymm2, qword[r11 + rdx*8 - 88]).encode())


class TestVPMOVZXBQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x32, 0xF4]), VPMOVZXBQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x32, 0xDC]), VPMOVZXBQ(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0x7D, 0xCE, 0x32, 0xCC]), VPMOVZXBQ(zmm9(k6.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x32, 0x75, 0x20]), VPMOVZXBQ(xmm30(k2.z), word[r13 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x32, 0x5C, 0x24, 0x10]), VPMOVZXBQ(ymm19(k5.z), dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x32, 0x4B, 0x08]), VPMOVZXBQ(zmm9(k6.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x32, 0xCE]), VPMOVZXBQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x32, 0x4C, 0xED, 0x95]), VPMOVZXBQ(xmm1, word[r13 + rbp*8 - 107]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x32, 0xD6]), VPMOVZXBQ(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x32, 0x54, 0xCC, 0x9D]), VPMOVZXBQ(ymm2, dword[r12 + rcx*8 - 99]).encode())


class TestVPMOVZXWD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x33, 0xF4]), VPMOVZXWD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x33, 0xDC]), VPMOVZXWD(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0x7D, 0xCE, 0x33, 0xCD]), VPMOVZXWD(zmm9(k6.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x33, 0x73, 0x08]), VPMOVZXWD(xmm30(k2.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x33, 0x5A, 0x04]), VPMOVZXWD(ymm19(k5.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x33, 0x49, 0x02]), VPMOVZXWD(zmm9(k6.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x33, 0xCE]), VPMOVZXWD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x33, 0x4C, 0xD3, 0xA8]), VPMOVZXWD(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x33, 0xD6]), VPMOVZXWD(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x33, 0x54, 0xC2, 0xB3]), VPMOVZXWD(ymm2, oword[r10 + rax*8 - 77]).encode())


class TestVPMOVZXWQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x34, 0xF4]), VPMOVZXWQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x34, 0xDC]), VPMOVZXWQ(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0x7D, 0xCE, 0x34, 0xCC]), VPMOVZXWQ(zmm9(k6.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x34, 0x74, 0x24, 0x10]), VPMOVZXWQ(xmm30(k2.z), dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x34, 0x5B, 0x08]), VPMOVZXWQ(ymm19(k5.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x34, 0x4A, 0x04]), VPMOVZXWQ(zmm9(k6.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x34, 0xCE]), VPMOVZXWQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x34, 0x4C, 0xCC, 0x9D]), VPMOVZXWQ(xmm1, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x34, 0xD6]), VPMOVZXWQ(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x34, 0x54, 0xD3, 0xA8]), VPMOVZXWQ(ymm2, qword[r11 + rdx*8 - 88]).encode())


class TestVPMOVZXDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x35, 0xF4]), VPMOVZXDQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x35, 0xDC]), VPMOVZXDQ(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0x7D, 0xCE, 0x35, 0xCD]), VPMOVZXDQ(zmm9(k6.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x35, 0x73, 0x08]), VPMOVZXDQ(xmm30(k2.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x35, 0x5A, 0x04]), VPMOVZXDQ(ymm19(k5.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x35, 0x49, 0x02]), VPMOVZXDQ(zmm9(k6.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x35, 0xCE]), VPMOVZXDQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x35, 0x4C, 0xD3, 0xA8]), VPMOVZXDQ(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x35, 0xD6]), VPMOVZXDQ(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x35, 0x54, 0xC2, 0xB3]), VPMOVZXDQ(ymm2, oword[r10 + rax*8 - 77]).encode())


class TestVPMOVWB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0x8A, 0x30, 0xE6]), VPMOVWB(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x08, 0x30, 0x63, 0xF8]), VPMOVWB(qword[r11 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0xAA, 0x30, 0xEE]), VPMOVWB(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x28, 0x30, 0x6A, 0xFC]), VPMOVWB(oword[r10 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x7E, 0xCD, 0x30, 0xD3]), VPMOVWB(ymm19(k5.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7E, 0x48, 0x30, 0x51, 0xFE]), VPMOVWB(hword[r9 - 64], zmm26).encode())


class TestVPMOVDB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0x8A, 0x31, 0xE6]), VPMOVDB(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x08, 0x31, 0x64, 0x24, 0xF0]), VPMOVDB(dword[r12 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0xAA, 0x31, 0xEE]), VPMOVDB(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x28, 0x31, 0x6B, 0xF8]), VPMOVDB(qword[r11 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x02, 0x7E, 0xCA, 0x31, 0xD6]), VPMOVDB(xmm30(k2.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7E, 0x48, 0x31, 0x52, 0xFC]), VPMOVDB(oword[r10 - 64], zmm26).encode())


class TestVPMOVDW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0x8A, 0x33, 0xE6]), VPMOVDW(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x08, 0x33, 0x63, 0xF8]), VPMOVDW(qword[r11 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0xAA, 0x33, 0xEE]), VPMOVDW(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x28, 0x33, 0x6A, 0xFC]), VPMOVDW(oword[r10 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x7E, 0xCD, 0x33, 0xD3]), VPMOVDW(ymm19(k5.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7E, 0x48, 0x33, 0x51, 0xFE]), VPMOVDW(hword[r9 - 64], zmm26).encode())


class TestVPMOVQB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0x8A, 0x32, 0xE6]), VPMOVQB(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x08, 0x32, 0x65, 0xE0]), VPMOVQB(word[r13 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0xAA, 0x32, 0xEE]), VPMOVQB(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x28, 0x32, 0x6C, 0x24, 0xF0]), VPMOVQB(dword[r12 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x02, 0x7E, 0xCA, 0x32, 0xD6]), VPMOVQB(xmm30(k2.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7E, 0x48, 0x32, 0x53, 0xF8]), VPMOVQB(qword[r11 - 64], zmm26).encode())


class TestVPMOVQW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0x8A, 0x34, 0xE6]), VPMOVQW(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x08, 0x34, 0x64, 0x24, 0xF0]), VPMOVQW(dword[r12 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0xAA, 0x34, 0xEE]), VPMOVQW(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x28, 0x34, 0x6B, 0xF8]), VPMOVQW(qword[r11 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x02, 0x7E, 0xCA, 0x34, 0xD6]), VPMOVQW(xmm30(k2.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7E, 0x48, 0x34, 0x52, 0xFC]), VPMOVQW(oword[r10 - 64], zmm26).encode())


class TestVPMOVQD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0x8A, 0x35, 0xE6]), VPMOVQD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x08, 0x35, 0x63, 0xF8]), VPMOVQD(qword[r11 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0xAA, 0x35, 0xEE]), VPMOVQD(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x28, 0x35, 0x6A, 0xFC]), VPMOVQD(oword[r10 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x7E, 0xCD, 0x35, 0xD3]), VPMOVQD(ymm19(k5.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7E, 0x48, 0x35, 0x51, 0xFE]), VPMOVQD(hword[r9 - 64], zmm26).encode())


class TestVPMOVSWB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0x8A, 0x20, 0xE6]), VPMOVSWB(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x08, 0x20, 0x63, 0xF8]), VPMOVSWB(qword[r11 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0xAA, 0x20, 0xEE]), VPMOVSWB(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x28, 0x20, 0x6A, 0xFC]), VPMOVSWB(oword[r10 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x7E, 0xCD, 0x20, 0xD3]), VPMOVSWB(ymm19(k5.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7E, 0x48, 0x20, 0x51, 0xFE]), VPMOVSWB(hword[r9 - 64], zmm26).encode())


class TestVPMOVSDB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0x8A, 0x21, 0xE6]), VPMOVSDB(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x08, 0x21, 0x64, 0x24, 0xF0]), VPMOVSDB(dword[r12 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0xAA, 0x21, 0xEE]), VPMOVSDB(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x28, 0x21, 0x6B, 0xF8]), VPMOVSDB(qword[r11 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x02, 0x7E, 0xCA, 0x21, 0xD6]), VPMOVSDB(xmm30(k2.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7E, 0x48, 0x21, 0x52, 0xFC]), VPMOVSDB(oword[r10 - 64], zmm26).encode())


class TestVPMOVSDW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0x8A, 0x23, 0xE6]), VPMOVSDW(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x08, 0x23, 0x63, 0xF8]), VPMOVSDW(qword[r11 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0xAA, 0x23, 0xEE]), VPMOVSDW(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x28, 0x23, 0x6A, 0xFC]), VPMOVSDW(oword[r10 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x7E, 0xCD, 0x23, 0xD3]), VPMOVSDW(ymm19(k5.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7E, 0x48, 0x23, 0x51, 0xFE]), VPMOVSDW(hword[r9 - 64], zmm26).encode())


class TestVPMOVSQB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0x8A, 0x22, 0xE6]), VPMOVSQB(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x08, 0x22, 0x65, 0xE0]), VPMOVSQB(word[r13 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0xAA, 0x22, 0xEE]), VPMOVSQB(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x28, 0x22, 0x6C, 0x24, 0xF0]), VPMOVSQB(dword[r12 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x02, 0x7E, 0xCA, 0x22, 0xD6]), VPMOVSQB(xmm30(k2.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7E, 0x48, 0x22, 0x53, 0xF8]), VPMOVSQB(qword[r11 - 64], zmm26).encode())


class TestVPMOVSQW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0x8A, 0x24, 0xE6]), VPMOVSQW(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x08, 0x24, 0x64, 0x24, 0xF0]), VPMOVSQW(dword[r12 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0xAA, 0x24, 0xEE]), VPMOVSQW(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x28, 0x24, 0x6B, 0xF8]), VPMOVSQW(qword[r11 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x02, 0x7E, 0xCA, 0x24, 0xD6]), VPMOVSQW(xmm30(k2.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7E, 0x48, 0x24, 0x52, 0xFC]), VPMOVSQW(oword[r10 - 64], zmm26).encode())


class TestVPMOVSQD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0x8A, 0x25, 0xE6]), VPMOVSQD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x08, 0x25, 0x63, 0xF8]), VPMOVSQD(qword[r11 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0xAA, 0x25, 0xEE]), VPMOVSQD(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x28, 0x25, 0x6A, 0xFC]), VPMOVSQD(oword[r10 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x7E, 0xCD, 0x25, 0xD3]), VPMOVSQD(ymm19(k5.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7E, 0x48, 0x25, 0x51, 0xFE]), VPMOVSQD(hword[r9 - 64], zmm26).encode())


class TestVPMOVUSWB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0x8A, 0x10, 0xE6]), VPMOVUSWB(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x08, 0x10, 0x63, 0xF8]), VPMOVUSWB(qword[r11 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0xAA, 0x10, 0xEE]), VPMOVUSWB(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x28, 0x10, 0x6A, 0xFC]), VPMOVUSWB(oword[r10 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x7E, 0xCD, 0x10, 0xD3]), VPMOVUSWB(ymm19(k5.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7E, 0x48, 0x10, 0x51, 0xFE]), VPMOVUSWB(hword[r9 - 64], zmm26).encode())


class TestVPMOVUSDB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0x8A, 0x11, 0xE6]), VPMOVUSDB(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x08, 0x11, 0x64, 0x24, 0xF0]), VPMOVUSDB(dword[r12 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0xAA, 0x11, 0xEE]), VPMOVUSDB(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x28, 0x11, 0x6B, 0xF8]), VPMOVUSDB(qword[r11 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x02, 0x7E, 0xCA, 0x11, 0xD6]), VPMOVUSDB(xmm30(k2.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7E, 0x48, 0x11, 0x52, 0xFC]), VPMOVUSDB(oword[r10 - 64], zmm26).encode())


class TestVPMOVUSDW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0x8A, 0x13, 0xE6]), VPMOVUSDW(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x08, 0x13, 0x63, 0xF8]), VPMOVUSDW(qword[r11 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0xAA, 0x13, 0xEE]), VPMOVUSDW(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x28, 0x13, 0x6A, 0xFC]), VPMOVUSDW(oword[r10 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x7E, 0xCD, 0x13, 0xD3]), VPMOVUSDW(ymm19(k5.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7E, 0x48, 0x13, 0x51, 0xFE]), VPMOVUSDW(hword[r9 - 64], zmm26).encode())


class TestVPMOVUSQB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0x8A, 0x12, 0xE6]), VPMOVUSQB(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x08, 0x12, 0x65, 0xE0]), VPMOVUSQB(word[r13 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0xAA, 0x12, 0xEE]), VPMOVUSQB(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x28, 0x12, 0x6C, 0x24, 0xF0]), VPMOVUSQB(dword[r12 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x02, 0x7E, 0xCA, 0x12, 0xD6]), VPMOVUSQB(xmm30(k2.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7E, 0x48, 0x12, 0x53, 0xF8]), VPMOVUSQB(qword[r11 - 64], zmm26).encode())


class TestVPMOVUSQW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0x8A, 0x14, 0xE6]), VPMOVUSQW(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x08, 0x14, 0x64, 0x24, 0xF0]), VPMOVUSQW(dword[r12 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0xAA, 0x14, 0xEE]), VPMOVUSQW(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x28, 0x14, 0x6B, 0xF8]), VPMOVUSQW(qword[r11 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x02, 0x7E, 0xCA, 0x14, 0xD6]), VPMOVUSQW(xmm30(k2.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7E, 0x48, 0x14, 0x52, 0xFC]), VPMOVUSQW(oword[r10 - 64], zmm26).encode())


class TestVPMOVUSQD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0x8A, 0x15, 0xE6]), VPMOVUSQD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x08, 0x15, 0x63, 0xF8]), VPMOVUSQD(qword[r11 - 64], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0xAA, 0x15, 0xEE]), VPMOVUSQD(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7E, 0x28, 0x15, 0x6A, 0xFC]), VPMOVUSQD(oword[r10 - 64], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x7E, 0xCD, 0x15, 0xD3]), VPMOVUSQD(ymm19(k5.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7E, 0x48, 0x15, 0x51, 0xFE]), VPMOVUSQD(hword[r9 - 64], zmm26).encode())


class TestVPEXTRB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0x63, 0x79, 0x14, 0xF5, 0x02]), VPEXTRB(ebp, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xE3, 0x79, 0x14, 0xE5, 0x02]), VPEXTRB(ebp, xmm4, 2).encode())
        self.assertEqual(bytearray([0xC4, 0x43, 0x79, 0x14, 0x74, 0xBE, 0x85, 0x02]), VPEXTRB(byte[r14 + rdi*4 - 123], xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x14, 0x66, 0xC0, 0x02]), VPEXTRB(byte[r14 - 64], xmm4, 2).encode())


class TestVPEXTRW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0xC5, 0xEE, 0x02]), VPEXTRW(ebp, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC5, 0xF9, 0xC5, 0xEC, 0x02]), VPEXTRW(ebp, xmm4, 2).encode())
        self.assertEqual(bytearray([0xC4, 0x43, 0x79, 0x15, 0x74, 0xED, 0x95, 0x02]), VPEXTRW(word[r13 + rbp*8 - 107], xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x15, 0x65, 0xC0, 0x02]), VPEXTRW(word[r13 - 64], xmm4, 2).encode())


class TestVPEXTRD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0x63, 0x79, 0x16, 0xF5, 0x02]), VPEXTRD(ebp, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xE3, 0x79, 0x16, 0xE5, 0x02]), VPEXTRD(ebp, xmm4, 2).encode())
        self.assertEqual(bytearray([0xC4, 0x43, 0x79, 0x16, 0x74, 0xCC, 0x9D, 0x02]), VPEXTRD(dword[r12 + rcx*8 - 99], xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x16, 0x64, 0x24, 0xC0, 0x02]), VPEXTRD(dword[r12 - 64], xmm4, 2).encode())


class TestVPEXTRQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0x63, 0xF9, 0x16, 0xF1, 0x02]), VPEXTRQ(rcx, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xE3, 0xF9, 0x16, 0xE1, 0x02]), VPEXTRQ(rcx, xmm4, 2).encode())
        self.assertEqual(bytearray([0xC4, 0x43, 0xF9, 0x16, 0x74, 0xD3, 0xA8, 0x02]), VPEXTRQ(qword[r11 + rdx*8 - 88], xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0xF9, 0x16, 0x63, 0xC0, 0x02]), VPEXTRQ(qword[r11 - 64], xmm4, 2).encode())


class TestVPINSRB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x09, 0x20, 0xC8, 0x02]), VPINSRB(xmm1, xmm14, eax, 2).encode())
        self.assertEqual(bytearray([0x62, 0xE3, 0x5D, 0x08, 0x20, 0xC0, 0x02]), VPINSRB(xmm16, xmm4, eax, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x09, 0x20, 0x4C, 0xBE, 0x85, 0x02]), VPINSRB(xmm1, xmm14, byte[r14 + rdi*4 - 123], 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0x5D, 0x08, 0x20, 0x46, 0x80, 0x02]), VPINSRB(xmm16, xmm4, byte[r14 - 128], 2).encode())


class TestVPINSRW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x89, 0xC4, 0xC8, 0x02]), VPINSRW(xmm1, xmm14, eax, 2).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x5D, 0x08, 0xC4, 0xC0, 0x02]), VPINSRW(xmm16, xmm4, eax, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xC4, 0x4C, 0xED, 0x95, 0x02]), VPINSRW(xmm1, xmm14, word[r13 + rbp*8 - 107], 2).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x5D, 0x08, 0xC4, 0x45, 0xC0, 0x02]), VPINSRW(xmm16, xmm4, word[r13 - 128], 2).encode())


class TestVPINSRD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x09, 0x22, 0xC8, 0x02]), VPINSRD(xmm1, xmm14, eax, 2).encode())
        self.assertEqual(bytearray([0x62, 0xE3, 0x5D, 0x08, 0x22, 0xC0, 0x02]), VPINSRD(xmm16, xmm4, eax, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x09, 0x22, 0x4C, 0xCC, 0x9D, 0x02]), VPINSRD(xmm1, xmm14, dword[r12 + rcx*8 - 99], 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0x5D, 0x08, 0x22, 0x44, 0x24, 0xE0, 0x02]), VPINSRD(xmm16, xmm4, dword[r12 - 128], 2).encode())


class TestVPINSRQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x89, 0x22, 0xC8, 0x02]), VPINSRQ(xmm1, xmm14, rax, 2).encode())
        self.assertEqual(bytearray([0x62, 0xE3, 0xDD, 0x08, 0x22, 0xC0, 0x02]), VPINSRQ(xmm16, xmm4, rax, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x89, 0x22, 0x4C, 0xD3, 0xA8, 0x02]), VPINSRQ(xmm1, xmm14, qword[r11 + rdx*8 - 88], 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0xDD, 0x08, 0x22, 0x43, 0xF0, 0x02]), VPINSRQ(xmm16, xmm4, qword[r11 - 128], 2).encode())


class TestVPGATHERDD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF2, 0x7D, 0x09, 0x90, 0x6C, 0x86, 0xE0]), VPGATHERDD(xmm5(k1), [rsi + xmm0 * 4 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x02, 0x7D, 0x2B, 0x90, 0x44, 0x83, 0x0C]), VPGATHERDD(ymm24(k3), [r11 + ymm8 * 4 + 48]).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x47, 0x90, 0x54, 0x9F, 0xFC]), VPGATHERDD(zmm26(k7), [r15 + zmm19 * 4 - 16]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x61, 0x90, 0x4C, 0x86, 0x80]), VPGATHERDD(xmm1, [rsi + xmm0 * 4 - 128], xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0x82, 0x5D, 0x90, 0x54, 0x83, 0x30]), VPGATHERDD(ymm2, [r11 + ymm8 * 4 + 48], ymm4).encode())


class TestVPGATHERDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF2, 0xFD, 0x09, 0x90, 0x6C, 0x86, 0xF0]), VPGATHERDQ(xmm5(k1), [rsi + xmm0 * 4 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x62, 0xFD, 0x2B, 0x90, 0x44, 0x86, 0xF0]), VPGATHERDQ(ymm24(k3), [rsi + xmm0 * 4 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x02, 0xFD, 0x4F, 0x90, 0x54, 0x83, 0x06]), VPGATHERDQ(zmm26(k7), [r11 + ymm8 * 4 + 48]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0xE1, 0x90, 0x4C, 0x86, 0x80]), VPGATHERDQ(xmm1, [rsi + xmm0 * 4 - 128], xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0xDD, 0x90, 0x54, 0x86, 0x80]), VPGATHERDQ(ymm2, [rsi + xmm0 * 4 - 128], ymm4).encode())


class TestVPGATHERQD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF2, 0x7D, 0x09, 0x91, 0x6C, 0xCE, 0x0A]), VPGATHERQD(xmm5(k1), [rsi + xmm1 * 8 + 40]).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7D, 0x29, 0x91, 0x6C, 0xCB, 0xF2]), VPGATHERQD(xmm5(k1), [r11 + ymm9 * 8 - 56]).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x43, 0x91, 0x44, 0xE7, 0x12]), VPGATHERQD(ymm24(k3), [r15 + zmm20 * 8 + 72]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x61, 0x91, 0x4C, 0xCE, 0x28]), VPGATHERQD(xmm1, [rsi + xmm1 * 8 + 40], xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0x82, 0x65, 0x91, 0x4C, 0xCB, 0xC8]), VPGATHERQD(xmm1, [r11 + ymm9 * 8 - 56], xmm3).encode())


class TestVPGATHERQQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF2, 0xFD, 0x09, 0x91, 0x6C, 0xCE, 0x05]), VPGATHERQQ(xmm5(k1), [rsi + xmm1 * 8 + 40]).encode())
        self.assertEqual(bytearray([0x62, 0x02, 0xFD, 0x2B, 0x91, 0x44, 0xCB, 0xF9]), VPGATHERQQ(ymm24(k3), [r11 + ymm9 * 8 - 56]).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xFD, 0x47, 0x91, 0x54, 0xE7, 0x09]), VPGATHERQQ(zmm26(k7), [r15 + zmm20 * 8 + 72]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0xE1, 0x91, 0x4C, 0xCE, 0x28]), VPGATHERQQ(xmm1, [rsi + xmm1 * 8 + 40], xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0x82, 0xDD, 0x91, 0x54, 0xCB, 0xC8]), VPGATHERQQ(ymm2, [r11 + ymm9 * 8 - 56], ymm4).encode())


class TestVPSCATTERDD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF2, 0x7D, 0x09, 0xA0, 0x64, 0x86, 0xE0]), VPSCATTERDD([rsi + xmm0(k1) * 4 - 128], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7D, 0x2A, 0xA0, 0x6C, 0x83, 0x0C]), VPSCATTERDD([r11 + ymm8(k2) * 4 + 48], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x43, 0xA0, 0x54, 0x9F, 0xFC]), VPSCATTERDD([r15 + zmm19(k3) * 4 - 16], zmm26).encode())


class TestVPSCATTERDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF2, 0xFD, 0x09, 0xA0, 0x64, 0x86, 0xF0]), VPSCATTERDQ([rsi + xmm0(k1) * 4 - 128], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xF2, 0xFD, 0x29, 0xA0, 0x6C, 0x86, 0xF0]), VPSCATTERDQ([rsi + xmm0(k1) * 4 - 128], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x02, 0xFD, 0x4A, 0xA0, 0x54, 0x83, 0x06]), VPSCATTERDQ([r11 + ymm8(k2) * 4 + 48], zmm26).encode())


class TestVPSCATTERQD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF2, 0x7D, 0x0C, 0xA1, 0x64, 0xCE, 0x0A]), VPSCATTERQD([rsi + xmm1(k4) * 8 + 40], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7D, 0x2D, 0xA1, 0x64, 0xCB, 0xF2]), VPSCATTERQD([r11 + ymm9(k5) * 8 - 56], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x7D, 0x46, 0xA1, 0x6C, 0xE7, 0x12]), VPSCATTERQD([r15 + zmm20(k6) * 8 + 72], ymm5).encode())


class TestVPSCATTERQQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF2, 0xFD, 0x0C, 0xA1, 0x64, 0xCE, 0x05]), VPSCATTERQQ([rsi + xmm1(k4) * 8 + 40], xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0xFD, 0x2D, 0xA1, 0x6C, 0xCB, 0xF9]), VPSCATTERQQ([r11 + ymm9(k5) * 8 - 56], ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xFD, 0x46, 0xA1, 0x54, 0xE7, 0x09]), VPSCATTERQQ([r15 + zmm20(k6) * 8 + 72], zmm26).encode())


class TestVPCONFLICTD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0xC4, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPCONFLICTD(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0xC4, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPCONFLICTD(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0xC4, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPCONFLICTD(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0xC4, 0xF4]), VPCONFLICTD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0xC4, 0xDD]), VPCONFLICTD(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0x7D, 0xCE, 0xC4, 0xCA]), VPCONFLICTD(zmm9(k6.z), zmm26).encode())


class TestVPCONFLICTQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xFD, 0x8A, 0xC4, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPCONFLICTQ(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xFD, 0xAD, 0xC4, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPCONFLICTQ(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xFD, 0xCE, 0xC4, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPCONFLICTQ(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x62, 0xFD, 0x8A, 0xC4, 0xF4]), VPCONFLICTQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0xFD, 0xAD, 0xC4, 0xDD]), VPCONFLICTQ(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0xFD, 0xCE, 0xC4, 0xCA]), VPCONFLICTQ(zmm9(k6.z), zmm26).encode())


class TestVPLZCNTD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x44, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPLZCNTD(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x44, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPLZCNTD(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x44, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPLZCNTD(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x44, 0xF4]), VPLZCNTD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x44, 0xDD]), VPLZCNTD(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0x7D, 0xCE, 0x44, 0xCA]), VPLZCNTD(zmm9(k6.z), zmm26).encode())


class TestVPLZCNTQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xFD, 0x8A, 0x44, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPLZCNTQ(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xFD, 0xAD, 0x44, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPLZCNTQ(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xFD, 0xCE, 0x44, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPLZCNTQ(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x62, 0xFD, 0x8A, 0x44, 0xF4]), VPLZCNTQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0xFD, 0xAD, 0x44, 0xDD]), VPLZCNTQ(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0xFD, 0xCE, 0x44, 0xCA]), VPLZCNTQ(zmm9(k6.z), zmm26).encode())


class TestVPTEST(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x17, 0xCE]), VPTEST(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x17, 0x4C, 0xC2, 0xB3]), VPTEST(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x17, 0xD7]), VPTEST(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x17, 0x54, 0xD9, 0xBE]), VPTEST(ymm2, hword[r9 + rbx*8 - 66]).encode())


class TestVPMOVMSKB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0xD7, 0xEE]), VPMOVMSKB(ebp, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7D, 0xD7, 0xEF]), VPMOVMSKB(ebp, ymm15).encode())


class TestVPADDB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xFC, 0xF3]), VPADDB(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xFC, 0x72, 0xF8]), VPADDB(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xFC, 0xDC]), VPADDB(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xFC, 0x59, 0xFC]), VPADDB(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xFC, 0xC9]), VPADDB(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xFC, 0x48, 0xFE]), VPADDB(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xFC, 0xCB]), VPADDB(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xFC, 0x4C, 0xC2, 0xB3]), VPADDB(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xFC, 0xD4]), VPADDB(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xFC, 0x54, 0xD9, 0xBE]), VPADDB(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPADDW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xFD, 0xF3]), VPADDW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xFD, 0x72, 0xF8]), VPADDW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xFD, 0xDC]), VPADDW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xFD, 0x59, 0xFC]), VPADDW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xFD, 0xC9]), VPADDW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xFD, 0x48, 0xFE]), VPADDW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xFD, 0xCB]), VPADDW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xFD, 0x4C, 0xC2, 0xB3]), VPADDW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xFD, 0xD4]), VPADDW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xFD, 0x54, 0xD9, 0xBE]), VPADDW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPADDD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xFE, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPADDD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xFE, 0xF3]), VPADDD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xFE, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPADDD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xFE, 0xDC]), VPADDD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xFE, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPADDD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xFE, 0xC9]), VPADDD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xFE, 0xCB]), VPADDD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xFE, 0x4C, 0xC2, 0xB3]), VPADDD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xFE, 0xD4]), VPADDD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xFE, 0x54, 0xD9, 0xBE]), VPADDD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPADDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0xD4, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPADDQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0xD4, 0xF3]), VPADDQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0xD4, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPADDQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0xD4, 0xDC]), VPADDQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0xD4, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPADDQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0xD4, 0xC9]), VPADDQ(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xD4, 0xCB]), VPADDQ(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xD4, 0x4C, 0xC2, 0xB3]), VPADDQ(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xD4, 0xD4]), VPADDQ(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xD4, 0x54, 0xD9, 0xBE]), VPADDQ(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPADDSB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xEC, 0xF3]), VPADDSB(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xEC, 0x72, 0xF8]), VPADDSB(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xEC, 0xDC]), VPADDSB(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xEC, 0x59, 0xFC]), VPADDSB(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xEC, 0xC9]), VPADDSB(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xEC, 0x48, 0xFE]), VPADDSB(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xEC, 0xCB]), VPADDSB(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xEC, 0x4C, 0xC2, 0xB3]), VPADDSB(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xEC, 0xD4]), VPADDSB(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xEC, 0x54, 0xD9, 0xBE]), VPADDSB(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPADDSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xED, 0xF3]), VPADDSW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xED, 0x72, 0xF8]), VPADDSW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xED, 0xDC]), VPADDSW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xED, 0x59, 0xFC]), VPADDSW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xED, 0xC9]), VPADDSW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xED, 0x48, 0xFE]), VPADDSW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xED, 0xCB]), VPADDSW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xED, 0x4C, 0xC2, 0xB3]), VPADDSW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xED, 0xD4]), VPADDSW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xED, 0x54, 0xD9, 0xBE]), VPADDSW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPADDUSB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xDC, 0xF3]), VPADDUSB(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xDC, 0x72, 0xF8]), VPADDUSB(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xDC, 0xDC]), VPADDUSB(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xDC, 0x59, 0xFC]), VPADDUSB(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xDC, 0xC9]), VPADDUSB(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xDC, 0x48, 0xFE]), VPADDUSB(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xDC, 0xCB]), VPADDUSB(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xDC, 0x4C, 0xC2, 0xB3]), VPADDUSB(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xDC, 0xD4]), VPADDUSB(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xDC, 0x54, 0xD9, 0xBE]), VPADDUSB(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPADDUSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xDD, 0xF3]), VPADDUSW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xDD, 0x72, 0xF8]), VPADDUSW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xDD, 0xDC]), VPADDUSW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xDD, 0x59, 0xFC]), VPADDUSW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xDD, 0xC9]), VPADDUSW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xDD, 0x48, 0xFE]), VPADDUSW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xDD, 0xCB]), VPADDUSW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xDD, 0x4C, 0xC2, 0xB3]), VPADDUSW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xDD, 0xD4]), VPADDUSW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xDD, 0x54, 0xD9, 0xBE]), VPADDUSW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPHADDW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x01, 0xCB]), VPHADDW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x01, 0x4C, 0xC2, 0xB3]), VPHADDW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x01, 0xD4]), VPHADDW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x01, 0x54, 0xD9, 0xBE]), VPHADDW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPHADDD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x02, 0xCB]), VPHADDD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x02, 0x4C, 0xC2, 0xB3]), VPHADDD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x02, 0xD4]), VPHADDD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x02, 0x54, 0xD9, 0xBE]), VPHADDD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPHADDSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x03, 0xCB]), VPHADDSW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x03, 0x4C, 0xC2, 0xB3]), VPHADDSW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x03, 0xD4]), VPHADDSW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x03, 0x54, 0xD9, 0xBE]), VPHADDSW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPSUBB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xF8, 0xF3]), VPSUBB(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xF8, 0x72, 0xF8]), VPSUBB(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xF8, 0xDC]), VPSUBB(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xF8, 0x59, 0xFC]), VPSUBB(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xF8, 0xC9]), VPSUBB(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xF8, 0x48, 0xFE]), VPSUBB(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xF8, 0xCB]), VPSUBB(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xF8, 0x4C, 0xC2, 0xB3]), VPSUBB(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xF8, 0xD4]), VPSUBB(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xF8, 0x54, 0xD9, 0xBE]), VPSUBB(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPSUBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xF9, 0xF3]), VPSUBW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xF9, 0x72, 0xF8]), VPSUBW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xF9, 0xDC]), VPSUBW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xF9, 0x59, 0xFC]), VPSUBW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xF9, 0xC9]), VPSUBW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xF9, 0x48, 0xFE]), VPSUBW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xF9, 0xCB]), VPSUBW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xF9, 0x4C, 0xC2, 0xB3]), VPSUBW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xF9, 0xD4]), VPSUBW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xF9, 0x54, 0xD9, 0xBE]), VPSUBW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPSUBD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xFA, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPSUBD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xFA, 0xF3]), VPSUBD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xFA, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPSUBD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xFA, 0xDC]), VPSUBD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xFA, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPSUBD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xFA, 0xC9]), VPSUBD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xFA, 0xCB]), VPSUBD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xFA, 0x4C, 0xC2, 0xB3]), VPSUBD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xFA, 0xD4]), VPSUBD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xFA, 0x54, 0xD9, 0xBE]), VPSUBD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPSUBQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0xFB, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPSUBQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0xFB, 0xF3]), VPSUBQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0xFB, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPSUBQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0xFB, 0xDC]), VPSUBQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0xFB, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPSUBQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0xFB, 0xC9]), VPSUBQ(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xFB, 0xCB]), VPSUBQ(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xFB, 0x4C, 0xC2, 0xB3]), VPSUBQ(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xFB, 0xD4]), VPSUBQ(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xFB, 0x54, 0xD9, 0xBE]), VPSUBQ(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPSUBSB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xE8, 0xF3]), VPSUBSB(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xE8, 0x72, 0xF8]), VPSUBSB(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xE8, 0xDC]), VPSUBSB(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xE8, 0x59, 0xFC]), VPSUBSB(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xE8, 0xC9]), VPSUBSB(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xE8, 0x48, 0xFE]), VPSUBSB(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xE8, 0xCB]), VPSUBSB(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xE8, 0x4C, 0xC2, 0xB3]), VPSUBSB(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xE8, 0xD4]), VPSUBSB(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xE8, 0x54, 0xD9, 0xBE]), VPSUBSB(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPSUBSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xE9, 0xF3]), VPSUBSW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xE9, 0x72, 0xF8]), VPSUBSW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xE9, 0xDC]), VPSUBSW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xE9, 0x59, 0xFC]), VPSUBSW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xE9, 0xC9]), VPSUBSW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xE9, 0x48, 0xFE]), VPSUBSW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xE9, 0xCB]), VPSUBSW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xE9, 0x4C, 0xC2, 0xB3]), VPSUBSW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xE9, 0xD4]), VPSUBSW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xE9, 0x54, 0xD9, 0xBE]), VPSUBSW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPSUBUSB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xD8, 0xF3]), VPSUBUSB(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xD8, 0x72, 0xF8]), VPSUBUSB(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xD8, 0xDC]), VPSUBUSB(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xD8, 0x59, 0xFC]), VPSUBUSB(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xD8, 0xC9]), VPSUBUSB(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xD8, 0x48, 0xFE]), VPSUBUSB(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xD8, 0xCB]), VPSUBUSB(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xD8, 0x4C, 0xC2, 0xB3]), VPSUBUSB(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xD8, 0xD4]), VPSUBUSB(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xD8, 0x54, 0xD9, 0xBE]), VPSUBUSB(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPSUBUSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xD9, 0xF3]), VPSUBUSW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xD9, 0x72, 0xF8]), VPSUBUSW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xD9, 0xDC]), VPSUBUSW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xD9, 0x59, 0xFC]), VPSUBUSW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xD9, 0xC9]), VPSUBUSW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xD9, 0x48, 0xFE]), VPSUBUSW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xD9, 0xCB]), VPSUBUSW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xD9, 0x4C, 0xC2, 0xB3]), VPSUBUSW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xD9, 0xD4]), VPSUBUSW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xD9, 0x54, 0xD9, 0xBE]), VPSUBUSW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPHSUBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x05, 0xCB]), VPHSUBW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x05, 0x4C, 0xC2, 0xB3]), VPHSUBW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x05, 0xD4]), VPHSUBW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x05, 0x54, 0xD9, 0xBE]), VPHSUBW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPHSUBD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x06, 0xCB]), VPHSUBD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x06, 0x4C, 0xC2, 0xB3]), VPHSUBD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x06, 0xD4]), VPHSUBD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x06, 0x54, 0xD9, 0xBE]), VPHSUBD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPHSUBSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x07, 0xCB]), VPHSUBSW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x07, 0x4C, 0xC2, 0xB3]), VPHSUBSW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x07, 0xD4]), VPHSUBSW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x07, 0x54, 0xD9, 0xBE]), VPHSUBSW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMAXSB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x3C, 0xF3]), VPMAXSB(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x3C, 0x72, 0xF8]), VPMAXSB(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x3C, 0xDC]), VPMAXSB(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x3C, 0x59, 0xFC]), VPMAXSB(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x3C, 0xC9]), VPMAXSB(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x3C, 0x48, 0xFE]), VPMAXSB(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x3C, 0xCB]), VPMAXSB(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x3C, 0x4C, 0xC2, 0xB3]), VPMAXSB(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x3C, 0xD4]), VPMAXSB(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x3C, 0x54, 0xD9, 0xBE]), VPMAXSB(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMAXSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xEE, 0xF3]), VPMAXSW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xEE, 0x72, 0xF8]), VPMAXSW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xEE, 0xDC]), VPMAXSW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xEE, 0x59, 0xFC]), VPMAXSW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xEE, 0xC9]), VPMAXSW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xEE, 0x48, 0xFE]), VPMAXSW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xEE, 0xCB]), VPMAXSW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xEE, 0x4C, 0xC2, 0xB3]), VPMAXSW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xEE, 0xD4]), VPMAXSW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xEE, 0x54, 0xD9, 0xBE]), VPMAXSW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMAXSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x3D, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPMAXSD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x3D, 0xF3]), VPMAXSD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x3D, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMAXSD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x3D, 0xDC]), VPMAXSD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x3D, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMAXSD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x3D, 0xC9]), VPMAXSD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x3D, 0xCB]), VPMAXSD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x3D, 0x4C, 0xC2, 0xB3]), VPMAXSD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x3D, 0xD4]), VPMAXSD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x3D, 0x54, 0xD9, 0xBE]), VPMAXSD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMAXSQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x3D, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPMAXSQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x3D, 0xF3]), VPMAXSQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x3D, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMAXSQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x3D, 0xDC]), VPMAXSQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x3D, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMAXSQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x3D, 0xC9]), VPMAXSQ(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPMAXUB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xDE, 0xF3]), VPMAXUB(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xDE, 0x72, 0xF8]), VPMAXUB(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xDE, 0xDC]), VPMAXUB(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xDE, 0x59, 0xFC]), VPMAXUB(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xDE, 0xC9]), VPMAXUB(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xDE, 0x48, 0xFE]), VPMAXUB(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xDE, 0xCB]), VPMAXUB(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xDE, 0x4C, 0xC2, 0xB3]), VPMAXUB(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xDE, 0xD4]), VPMAXUB(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xDE, 0x54, 0xD9, 0xBE]), VPMAXUB(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMAXUW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x3E, 0xF3]), VPMAXUW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x3E, 0x72, 0xF8]), VPMAXUW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x3E, 0xDC]), VPMAXUW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x3E, 0x59, 0xFC]), VPMAXUW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x3E, 0xC9]), VPMAXUW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x3E, 0x48, 0xFE]), VPMAXUW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x3E, 0xCB]), VPMAXUW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x3E, 0x4C, 0xC2, 0xB3]), VPMAXUW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x3E, 0xD4]), VPMAXUW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x3E, 0x54, 0xD9, 0xBE]), VPMAXUW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMAXUD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x3F, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPMAXUD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x3F, 0xF3]), VPMAXUD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x3F, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMAXUD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x3F, 0xDC]), VPMAXUD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x3F, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMAXUD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x3F, 0xC9]), VPMAXUD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x3F, 0xCB]), VPMAXUD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x3F, 0x4C, 0xC2, 0xB3]), VPMAXUD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x3F, 0xD4]), VPMAXUD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x3F, 0x54, 0xD9, 0xBE]), VPMAXUD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMAXUQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x3F, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPMAXUQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x3F, 0xF3]), VPMAXUQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x3F, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMAXUQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x3F, 0xDC]), VPMAXUQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x3F, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMAXUQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x3F, 0xC9]), VPMAXUQ(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPMINSB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x38, 0xF3]), VPMINSB(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x38, 0x72, 0xF8]), VPMINSB(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x38, 0xDC]), VPMINSB(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x38, 0x59, 0xFC]), VPMINSB(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x38, 0xC9]), VPMINSB(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x38, 0x48, 0xFE]), VPMINSB(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x38, 0xCB]), VPMINSB(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x38, 0x4C, 0xC2, 0xB3]), VPMINSB(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x38, 0xD4]), VPMINSB(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x38, 0x54, 0xD9, 0xBE]), VPMINSB(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMINSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xEA, 0xF3]), VPMINSW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xEA, 0x72, 0xF8]), VPMINSW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xEA, 0xDC]), VPMINSW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xEA, 0x59, 0xFC]), VPMINSW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xEA, 0xC9]), VPMINSW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xEA, 0x48, 0xFE]), VPMINSW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xEA, 0xCB]), VPMINSW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xEA, 0x4C, 0xC2, 0xB3]), VPMINSW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xEA, 0xD4]), VPMINSW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xEA, 0x54, 0xD9, 0xBE]), VPMINSW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMINSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x39, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPMINSD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x39, 0xF3]), VPMINSD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x39, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMINSD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x39, 0xDC]), VPMINSD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x39, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMINSD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x39, 0xC9]), VPMINSD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x39, 0xCB]), VPMINSD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x39, 0x4C, 0xC2, 0xB3]), VPMINSD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x39, 0xD4]), VPMINSD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x39, 0x54, 0xD9, 0xBE]), VPMINSD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMINSQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x39, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPMINSQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x39, 0xF3]), VPMINSQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x39, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMINSQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x39, 0xDC]), VPMINSQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x39, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMINSQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x39, 0xC9]), VPMINSQ(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPMINUB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xDA, 0xF3]), VPMINUB(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xDA, 0x72, 0xF8]), VPMINUB(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xDA, 0xDC]), VPMINUB(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xDA, 0x59, 0xFC]), VPMINUB(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xDA, 0xC9]), VPMINUB(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xDA, 0x48, 0xFE]), VPMINUB(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xDA, 0xCB]), VPMINUB(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xDA, 0x4C, 0xC2, 0xB3]), VPMINUB(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xDA, 0xD4]), VPMINUB(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xDA, 0x54, 0xD9, 0xBE]), VPMINUB(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMINUW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x3A, 0xF3]), VPMINUW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x3A, 0x72, 0xF8]), VPMINUW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x3A, 0xDC]), VPMINUW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x3A, 0x59, 0xFC]), VPMINUW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x3A, 0xC9]), VPMINUW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x3A, 0x48, 0xFE]), VPMINUW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x3A, 0xCB]), VPMINUW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x3A, 0x4C, 0xC2, 0xB3]), VPMINUW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x3A, 0xD4]), VPMINUW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x3A, 0x54, 0xD9, 0xBE]), VPMINUW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMINUD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x3B, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPMINUD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x3B, 0xF3]), VPMINUD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x3B, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMINUD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x3B, 0xDC]), VPMINUD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x3B, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMINUD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x3B, 0xC9]), VPMINUD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x3B, 0xCB]), VPMINUD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x3B, 0x4C, 0xC2, 0xB3]), VPMINUD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x3B, 0xD4]), VPMINUD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x3B, 0x54, 0xD9, 0xBE]), VPMINUD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMINUQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x3B, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPMINUQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x3B, 0xF3]), VPMINUQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x3B, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMINUQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x3B, 0xDC]), VPMINUQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x3B, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMINUQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x3B, 0xC9]), VPMINUQ(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPSLLW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF1, 0x0D, 0x82, 0x71, 0xF4, 0x02]), VPSLLW(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xF1, 0xF3]), VPSLLW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xF1, 0x72, 0xF8]), VPSLLW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x65, 0xA5, 0x71, 0xF5, 0x02]), VPSLLW(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xF1, 0xDB]), VPSLLW(ymm19(k5.z), ymm5, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xF1, 0x5A, 0xF8]), VPSLLW(ymm19(k5.z), ymm5, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x91, 0x35, 0xCE, 0x71, 0xF2, 0x02]), VPSLLW(zmm9(k6.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x31, 0x2D, 0xC6, 0xF1, 0xCB]), VPSLLW(zmm9(k6.z), zmm26, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xF1, 0x4A, 0xF8]), VPSLLW(zmm9(k6.z), zmm26, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x0D, 0x82, 0x71, 0x72, 0x04, 0x02]), VPSLLW(xmm30(k2.z), oword[r10 + 64], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x65, 0xA5, 0x71, 0x71, 0x02, 0x02]), VPSLLW(ymm19(k5.z), hword[r9 + 64], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x35, 0xCE, 0x71, 0x70, 0x01, 0x02]), VPSLLW(zmm9(k6.z), zword[r8 + 64], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x71, 0x71, 0xF6, 0x02]), VPSLLW(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xF1, 0xCB]), VPSLLW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xF1, 0x4C, 0xC2, 0xB3]), VPSLLW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x6D, 0x71, 0xF7, 0x02]), VPSLLW(ymm2, ymm15, 2).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xF1, 0xD3]), VPSLLW(ymm2, ymm15, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xF1, 0x54, 0xC2, 0xB3]), VPSLLW(ymm2, ymm15, oword[r10 + rax*8 - 77]).encode())


class TestVPSLLD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x0D, 0x82, 0x72, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VPSLLD(xmm30(k2.z), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x65, 0xA5, 0x72, 0xB4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPSLLD(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x35, 0xCE, 0x72, 0xB4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPSLLD(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x0D, 0x82, 0x72, 0xF4, 0x02]), VPSLLD(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xF2, 0xF3]), VPSLLD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xF2, 0x72, 0xF8]), VPSLLD(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x65, 0xA5, 0x72, 0xF5, 0x02]), VPSLLD(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xF2, 0xDB]), VPSLLD(ymm19(k5.z), ymm5, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xF2, 0x5A, 0xF8]), VPSLLD(ymm19(k5.z), ymm5, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x91, 0x35, 0xCE, 0x72, 0xF2, 0x02]), VPSLLD(zmm9(k6.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x31, 0x2D, 0xC6, 0xF2, 0xCB]), VPSLLD(zmm9(k6.z), zmm26, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xF2, 0x4A, 0xF8]), VPSLLD(zmm9(k6.z), zmm26, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x71, 0x72, 0xF6, 0x02]), VPSLLD(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xF2, 0xCB]), VPSLLD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xF2, 0x4C, 0xC2, 0xB3]), VPSLLD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x6D, 0x72, 0xF7, 0x02]), VPSLLD(ymm2, ymm15, 2).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xF2, 0xD3]), VPSLLD(ymm2, ymm15, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xF2, 0x54, 0xC2, 0xB3]), VPSLLD(ymm2, ymm15, oword[r10 + rax*8 - 77]).encode())


class TestVPSLLQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x8D, 0x82, 0x73, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VPSLLQ(xmm30(k2.z), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0xE5, 0xA5, 0x73, 0xB4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPSLLQ(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0xB5, 0xCE, 0x73, 0xB4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPSLLQ(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x8D, 0x82, 0x73, 0xF4, 0x02]), VPSLLQ(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0xF3, 0xF3]), VPSLLQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0xF3, 0x72, 0xF8]), VPSLLQ(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0xE5, 0xA5, 0x73, 0xF5, 0x02]), VPSLLQ(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0xF3, 0xDB]), VPSLLQ(ymm19(k5.z), ymm5, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0xF3, 0x5A, 0xF8]), VPSLLQ(ymm19(k5.z), ymm5, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x91, 0xB5, 0xCE, 0x73, 0xF2, 0x02]), VPSLLQ(zmm9(k6.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x31, 0xAD, 0xC6, 0xF3, 0xCB]), VPSLLQ(zmm9(k6.z), zmm26, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0xF3, 0x4A, 0xF8]), VPSLLQ(zmm9(k6.z), zmm26, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x71, 0x73, 0xF6, 0x02]), VPSLLQ(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xF3, 0xCB]), VPSLLQ(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xF3, 0x4C, 0xC2, 0xB3]), VPSLLQ(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x6D, 0x73, 0xF7, 0x02]), VPSLLQ(ymm2, ymm15, 2).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xF3, 0xD3]), VPSLLQ(ymm2, ymm15, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xF3, 0x54, 0xC2, 0xB3]), VPSLLQ(ymm2, ymm15, oword[r10 + rax*8 - 77]).encode())


class TestVPSRLW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF1, 0x0D, 0x82, 0x71, 0xD4, 0x02]), VPSRLW(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xD1, 0xF3]), VPSRLW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xD1, 0x72, 0xF8]), VPSRLW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x65, 0xA5, 0x71, 0xD5, 0x02]), VPSRLW(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xD1, 0xDB]), VPSRLW(ymm19(k5.z), ymm5, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xD1, 0x5A, 0xF8]), VPSRLW(ymm19(k5.z), ymm5, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x91, 0x35, 0xCE, 0x71, 0xD2, 0x02]), VPSRLW(zmm9(k6.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x31, 0x2D, 0xC6, 0xD1, 0xCB]), VPSRLW(zmm9(k6.z), zmm26, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xD1, 0x4A, 0xF8]), VPSRLW(zmm9(k6.z), zmm26, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x0D, 0x82, 0x71, 0x52, 0x04, 0x02]), VPSRLW(xmm30(k2.z), oword[r10 + 64], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x65, 0xA5, 0x71, 0x51, 0x02, 0x02]), VPSRLW(ymm19(k5.z), hword[r9 + 64], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x35, 0xCE, 0x71, 0x50, 0x01, 0x02]), VPSRLW(zmm9(k6.z), zword[r8 + 64], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x71, 0x71, 0xD6, 0x02]), VPSRLW(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xD1, 0xCB]), VPSRLW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xD1, 0x4C, 0xC2, 0xB3]), VPSRLW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x6D, 0x71, 0xD7, 0x02]), VPSRLW(ymm2, ymm15, 2).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xD1, 0xD3]), VPSRLW(ymm2, ymm15, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xD1, 0x54, 0xC2, 0xB3]), VPSRLW(ymm2, ymm15, oword[r10 + rax*8 - 77]).encode())


class TestVPSRLD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x0D, 0x82, 0x72, 0x94, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VPSRLD(xmm30(k2.z), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x65, 0xA5, 0x72, 0x94, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPSRLD(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x35, 0xCE, 0x72, 0x94, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPSRLD(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x0D, 0x82, 0x72, 0xD4, 0x02]), VPSRLD(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xD2, 0xF3]), VPSRLD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xD2, 0x72, 0xF8]), VPSRLD(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x65, 0xA5, 0x72, 0xD5, 0x02]), VPSRLD(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xD2, 0xDB]), VPSRLD(ymm19(k5.z), ymm5, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xD2, 0x5A, 0xF8]), VPSRLD(ymm19(k5.z), ymm5, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x91, 0x35, 0xCE, 0x72, 0xD2, 0x02]), VPSRLD(zmm9(k6.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x31, 0x2D, 0xC6, 0xD2, 0xCB]), VPSRLD(zmm9(k6.z), zmm26, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xD2, 0x4A, 0xF8]), VPSRLD(zmm9(k6.z), zmm26, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x71, 0x72, 0xD6, 0x02]), VPSRLD(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xD2, 0xCB]), VPSRLD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xD2, 0x4C, 0xC2, 0xB3]), VPSRLD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x6D, 0x72, 0xD7, 0x02]), VPSRLD(ymm2, ymm15, 2).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xD2, 0xD3]), VPSRLD(ymm2, ymm15, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xD2, 0x54, 0xC2, 0xB3]), VPSRLD(ymm2, ymm15, oword[r10 + rax*8 - 77]).encode())


class TestVPSRLQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x8D, 0x82, 0x73, 0x94, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VPSRLQ(xmm30(k2.z), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0xE5, 0xA5, 0x73, 0x94, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPSRLQ(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0xB5, 0xCE, 0x73, 0x94, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPSRLQ(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x8D, 0x82, 0x73, 0xD4, 0x02]), VPSRLQ(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0xD3, 0xF3]), VPSRLQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0xD3, 0x72, 0xF8]), VPSRLQ(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0xE5, 0xA5, 0x73, 0xD5, 0x02]), VPSRLQ(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0xD3, 0xDB]), VPSRLQ(ymm19(k5.z), ymm5, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0xD3, 0x5A, 0xF8]), VPSRLQ(ymm19(k5.z), ymm5, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x91, 0xB5, 0xCE, 0x73, 0xD2, 0x02]), VPSRLQ(zmm9(k6.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x31, 0xAD, 0xC6, 0xD3, 0xCB]), VPSRLQ(zmm9(k6.z), zmm26, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0xD3, 0x4A, 0xF8]), VPSRLQ(zmm9(k6.z), zmm26, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x71, 0x73, 0xD6, 0x02]), VPSRLQ(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xD3, 0xCB]), VPSRLQ(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xD3, 0x4C, 0xC2, 0xB3]), VPSRLQ(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x6D, 0x73, 0xD7, 0x02]), VPSRLQ(ymm2, ymm15, 2).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xD3, 0xD3]), VPSRLQ(ymm2, ymm15, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xD3, 0x54, 0xC2, 0xB3]), VPSRLQ(ymm2, ymm15, oword[r10 + rax*8 - 77]).encode())


class TestVPSRAW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF1, 0x0D, 0x82, 0x71, 0xE4, 0x02]), VPSRAW(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xE1, 0xF3]), VPSRAW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xE1, 0x72, 0xF8]), VPSRAW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x65, 0xA5, 0x71, 0xE5, 0x02]), VPSRAW(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xE1, 0xDB]), VPSRAW(ymm19(k5.z), ymm5, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xE1, 0x5A, 0xF8]), VPSRAW(ymm19(k5.z), ymm5, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x91, 0x35, 0xCE, 0x71, 0xE2, 0x02]), VPSRAW(zmm9(k6.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x31, 0x2D, 0xC6, 0xE1, 0xCB]), VPSRAW(zmm9(k6.z), zmm26, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xE1, 0x4A, 0xF8]), VPSRAW(zmm9(k6.z), zmm26, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x0D, 0x82, 0x71, 0x62, 0x04, 0x02]), VPSRAW(xmm30(k2.z), oword[r10 + 64], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x65, 0xA5, 0x71, 0x61, 0x02, 0x02]), VPSRAW(ymm19(k5.z), hword[r9 + 64], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x35, 0xCE, 0x71, 0x60, 0x01, 0x02]), VPSRAW(zmm9(k6.z), zword[r8 + 64], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x71, 0x71, 0xE6, 0x02]), VPSRAW(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xE1, 0xCB]), VPSRAW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xE1, 0x4C, 0xC2, 0xB3]), VPSRAW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x6D, 0x71, 0xE7, 0x02]), VPSRAW(ymm2, ymm15, 2).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xE1, 0xD3]), VPSRAW(ymm2, ymm15, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xE1, 0x54, 0xC2, 0xB3]), VPSRAW(ymm2, ymm15, oword[r10 + rax*8 - 77]).encode())


class TestVPSRAD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x0D, 0x82, 0x72, 0xA4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VPSRAD(xmm30(k2.z), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x65, 0xA5, 0x72, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPSRAD(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x35, 0xCE, 0x72, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPSRAD(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x0D, 0x82, 0x72, 0xE4, 0x02]), VPSRAD(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xE2, 0xF3]), VPSRAD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xE2, 0x72, 0xF8]), VPSRAD(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x65, 0xA5, 0x72, 0xE5, 0x02]), VPSRAD(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xE2, 0xDB]), VPSRAD(ymm19(k5.z), ymm5, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xE2, 0x5A, 0xF8]), VPSRAD(ymm19(k5.z), ymm5, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x91, 0x35, 0xCE, 0x72, 0xE2, 0x02]), VPSRAD(zmm9(k6.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x31, 0x2D, 0xC6, 0xE2, 0xCB]), VPSRAD(zmm9(k6.z), zmm26, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xE2, 0x4A, 0xF8]), VPSRAD(zmm9(k6.z), zmm26, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x71, 0x72, 0xE6, 0x02]), VPSRAD(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xE2, 0xCB]), VPSRAD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xE2, 0x4C, 0xC2, 0xB3]), VPSRAD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x6D, 0x72, 0xE7, 0x02]), VPSRAD(ymm2, ymm15, 2).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xE2, 0xD3]), VPSRAD(ymm2, ymm15, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xE2, 0x54, 0xC2, 0xB3]), VPSRAD(ymm2, ymm15, oword[r10 + rax*8 - 77]).encode())


class TestVPSRAQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x8D, 0x82, 0x72, 0xA4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VPSRAQ(xmm30(k2.z), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0xE5, 0xA5, 0x72, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPSRAQ(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0xB5, 0xCE, 0x72, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPSRAQ(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x8D, 0x82, 0x72, 0xE4, 0x02]), VPSRAQ(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0xE2, 0xF3]), VPSRAQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0xE2, 0x72, 0xF8]), VPSRAQ(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0xE5, 0xA5, 0x72, 0xE5, 0x02]), VPSRAQ(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0xE2, 0xDB]), VPSRAQ(ymm19(k5.z), ymm5, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0xE2, 0x5A, 0xF8]), VPSRAQ(ymm19(k5.z), ymm5, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x91, 0xB5, 0xCE, 0x72, 0xE2, 0x02]), VPSRAQ(zmm9(k6.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x31, 0xAD, 0xC6, 0xE2, 0xCB]), VPSRAQ(zmm9(k6.z), zmm26, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0xE2, 0x4A, 0xF8]), VPSRAQ(zmm9(k6.z), zmm26, oword[r10 - 128]).encode())


class TestVPROLD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x0D, 0x82, 0x72, 0x8C, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VPROLD(xmm30(k2.z), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x65, 0xA5, 0x72, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPROLD(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x35, 0xCE, 0x72, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPROLD(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x0D, 0x82, 0x72, 0xCC, 0x02]), VPROLD(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x65, 0xA5, 0x72, 0xCD, 0x02]), VPROLD(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0x91, 0x35, 0xCE, 0x72, 0xCA, 0x02]), VPROLD(zmm9(k6.z), zmm26, 2).encode())


class TestVPROLQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x8D, 0x82, 0x72, 0x8C, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VPROLQ(xmm30(k2.z), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0xE5, 0xA5, 0x72, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPROLQ(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0xB5, 0xCE, 0x72, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPROLQ(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x8D, 0x82, 0x72, 0xCC, 0x02]), VPROLQ(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0xE5, 0xA5, 0x72, 0xCD, 0x02]), VPROLQ(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0x91, 0xB5, 0xCE, 0x72, 0xCA, 0x02]), VPROLQ(zmm9(k6.z), zmm26, 2).encode())


class TestVPRORD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x0D, 0x82, 0x72, 0x84, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VPRORD(xmm30(k2.z), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x65, 0xA5, 0x72, 0x84, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPRORD(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x35, 0xCE, 0x72, 0x84, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPRORD(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x0D, 0x82, 0x72, 0xC4, 0x02]), VPRORD(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x65, 0xA5, 0x72, 0xC5, 0x02]), VPRORD(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0x91, 0x35, 0xCE, 0x72, 0xC2, 0x02]), VPRORD(zmm9(k6.z), zmm26, 2).encode())


class TestVPRORQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x8D, 0x82, 0x72, 0x84, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VPRORQ(xmm30(k2.z), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0xE5, 0xA5, 0x72, 0x84, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPRORQ(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0xB5, 0xCE, 0x72, 0x84, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPRORQ(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x8D, 0x82, 0x72, 0xC4, 0x02]), VPRORQ(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0xE5, 0xA5, 0x72, 0xC5, 0x02]), VPRORQ(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0x91, 0xB5, 0xCE, 0x72, 0xC2, 0x02]), VPRORQ(zmm9(k6.z), zmm26, 2).encode())


class TestVPSLLVW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x12, 0xF3]), VPSLLVW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x12, 0x72, 0xF8]), VPSLLVW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x12, 0xDC]), VPSLLVW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x12, 0x59, 0xFC]), VPSLLVW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x12, 0xC9]), VPSLLVW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x12, 0x48, 0xFE]), VPSLLVW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())


class TestVPSLLVD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x47, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPSLLVD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x47, 0xF3]), VPSLLVD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x47, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPSLLVD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x47, 0xDC]), VPSLLVD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x47, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPSLLVD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x47, 0xC9]), VPSLLVD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x47, 0xCB]), VPSLLVD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x47, 0x4C, 0xC2, 0xB3]), VPSLLVD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x47, 0xD4]), VPSLLVD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x47, 0x54, 0xD9, 0xBE]), VPSLLVD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPSLLVQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x47, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPSLLVQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x47, 0xF3]), VPSLLVQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x47, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPSLLVQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x47, 0xDC]), VPSLLVQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x47, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPSLLVQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x47, 0xC9]), VPSLLVQ(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x89, 0x47, 0xCB]), VPSLLVQ(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x89, 0x47, 0x4C, 0xC2, 0xB3]), VPSLLVQ(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x85, 0x47, 0xD4]), VPSLLVQ(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x85, 0x47, 0x54, 0xD9, 0xBE]), VPSLLVQ(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPSRLVW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x10, 0xF3]), VPSRLVW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x10, 0x72, 0xF8]), VPSRLVW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x10, 0xDC]), VPSRLVW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x10, 0x59, 0xFC]), VPSRLVW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x10, 0xC9]), VPSRLVW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x10, 0x48, 0xFE]), VPSRLVW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())


class TestVPSRLVD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x45, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPSRLVD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x45, 0xF3]), VPSRLVD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x45, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPSRLVD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x45, 0xDC]), VPSRLVD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x45, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPSRLVD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x45, 0xC9]), VPSRLVD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x45, 0xCB]), VPSRLVD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x45, 0x4C, 0xC2, 0xB3]), VPSRLVD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x45, 0xD4]), VPSRLVD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x45, 0x54, 0xD9, 0xBE]), VPSRLVD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPSRLVQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x45, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPSRLVQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x45, 0xF3]), VPSRLVQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x45, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPSRLVQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x45, 0xDC]), VPSRLVQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x45, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPSRLVQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x45, 0xC9]), VPSRLVQ(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x89, 0x45, 0xCB]), VPSRLVQ(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x89, 0x45, 0x4C, 0xC2, 0xB3]), VPSRLVQ(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x85, 0x45, 0xD4]), VPSRLVQ(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x85, 0x45, 0x54, 0xD9, 0xBE]), VPSRLVQ(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPSRAVW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x11, 0xF3]), VPSRAVW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x11, 0x72, 0xF8]), VPSRAVW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x11, 0xDC]), VPSRAVW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x11, 0x59, 0xFC]), VPSRAVW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x11, 0xC9]), VPSRAVW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x11, 0x48, 0xFE]), VPSRAVW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())


class TestVPSRAVD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x46, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPSRAVD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x46, 0xF3]), VPSRAVD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x46, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPSRAVD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x46, 0xDC]), VPSRAVD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x46, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPSRAVD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x46, 0xC9]), VPSRAVD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x46, 0xCB]), VPSRAVD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x46, 0x4C, 0xC2, 0xB3]), VPSRAVD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x46, 0xD4]), VPSRAVD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x46, 0x54, 0xD9, 0xBE]), VPSRAVD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPSRAVQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x46, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPSRAVQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x46, 0xF3]), VPSRAVQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x46, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPSRAVQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x46, 0xDC]), VPSRAVQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x46, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPSRAVQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x46, 0xC9]), VPSRAVQ(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPROLVD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x15, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPROLVD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x15, 0xF3]), VPROLVD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x15, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPROLVD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x15, 0xDC]), VPROLVD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x15, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPROLVD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x15, 0xC9]), VPROLVD(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPROLVQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x15, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPROLVQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x15, 0xF3]), VPROLVQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x15, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPROLVQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x15, 0xDC]), VPROLVQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x15, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPROLVQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x15, 0xC9]), VPROLVQ(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPRORVD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x14, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPRORVD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x14, 0xF3]), VPRORVD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x14, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPRORVD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x14, 0xDC]), VPRORVD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x14, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPRORVD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x14, 0xC9]), VPRORVD(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPRORVQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x14, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPRORVQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x14, 0xF3]), VPRORVQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x14, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPRORVQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x14, 0xDC]), VPRORVQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x14, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPRORVQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x14, 0xC9]), VPRORVQ(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPMULLW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xD5, 0xF3]), VPMULLW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xD5, 0x72, 0xF8]), VPMULLW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xD5, 0xDC]), VPMULLW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xD5, 0x59, 0xFC]), VPMULLW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xD5, 0xC9]), VPMULLW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xD5, 0x48, 0xFE]), VPMULLW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xD5, 0xCB]), VPMULLW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xD5, 0x4C, 0xC2, 0xB3]), VPMULLW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xD5, 0xD4]), VPMULLW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xD5, 0x54, 0xD9, 0xBE]), VPMULLW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMULHW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xE5, 0xF3]), VPMULHW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xE5, 0x72, 0xF8]), VPMULHW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xE5, 0xDC]), VPMULHW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xE5, 0x59, 0xFC]), VPMULHW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xE5, 0xC9]), VPMULHW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xE5, 0x48, 0xFE]), VPMULHW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xE5, 0xCB]), VPMULHW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xE5, 0x4C, 0xC2, 0xB3]), VPMULHW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xE5, 0xD4]), VPMULHW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xE5, 0x54, 0xD9, 0xBE]), VPMULHW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMULHUW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xE4, 0xF3]), VPMULHUW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xE4, 0x72, 0xF8]), VPMULHUW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xE4, 0xDC]), VPMULHUW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xE4, 0x59, 0xFC]), VPMULHUW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xE4, 0xC9]), VPMULHUW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xE4, 0x48, 0xFE]), VPMULHUW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xE4, 0xCB]), VPMULHUW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xE4, 0x4C, 0xC2, 0xB3]), VPMULHUW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xE4, 0xD4]), VPMULHUW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xE4, 0x54, 0xD9, 0xBE]), VPMULHUW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMULLD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x40, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPMULLD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x40, 0xF3]), VPMULLD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x40, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMULLD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x40, 0xDC]), VPMULLD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x40, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMULLD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x40, 0xC9]), VPMULLD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x40, 0xCB]), VPMULLD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x40, 0x4C, 0xC2, 0xB3]), VPMULLD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x40, 0xD4]), VPMULLD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x40, 0x54, 0xD9, 0xBE]), VPMULLD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMULLQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x40, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPMULLQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x40, 0xF3]), VPMULLQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x40, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMULLQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x40, 0xDC]), VPMULLQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x40, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMULLQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x40, 0xC9]), VPMULLQ(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPMULDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x28, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPMULDQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x28, 0xF3]), VPMULDQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x28, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMULDQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x28, 0xDC]), VPMULDQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x28, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMULDQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x28, 0xC9]), VPMULDQ(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x28, 0xCB]), VPMULDQ(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x28, 0x4C, 0xC2, 0xB3]), VPMULDQ(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x28, 0xD4]), VPMULDQ(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x28, 0x54, 0xD9, 0xBE]), VPMULDQ(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMULUDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0xF4, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPMULUDQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0xF4, 0xF3]), VPMULUDQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0xF4, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMULUDQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0xF4, 0xDC]), VPMULUDQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0xF4, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMULUDQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0xF4, 0xC9]), VPMULUDQ(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xF4, 0xCB]), VPMULUDQ(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xF4, 0x4C, 0xC2, 0xB3]), VPMULUDQ(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xF4, 0xD4]), VPMULUDQ(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xF4, 0x54, 0xD9, 0xBE]), VPMULUDQ(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMULHRSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x0B, 0xF3]), VPMULHRSW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x0B, 0x72, 0xF8]), VPMULHRSW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x0B, 0xDC]), VPMULHRSW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x0B, 0x59, 0xFC]), VPMULHRSW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x0B, 0xC9]), VPMULHRSW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x0B, 0x48, 0xFE]), VPMULHRSW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x0B, 0xCB]), VPMULHRSW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x0B, 0x4C, 0xC2, 0xB3]), VPMULHRSW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x0B, 0xD4]), VPMULHRSW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x0B, 0x54, 0xD9, 0xBE]), VPMULHRSW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMADDWD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xF5, 0xF3]), VPMADDWD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xF5, 0x72, 0xF8]), VPMADDWD(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xF5, 0xDC]), VPMADDWD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xF5, 0x59, 0xFC]), VPMADDWD(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xF5, 0xC9]), VPMADDWD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xF5, 0x48, 0xFE]), VPMADDWD(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xF5, 0xCB]), VPMADDWD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xF5, 0x4C, 0xC2, 0xB3]), VPMADDWD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xF5, 0xD4]), VPMADDWD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xF5, 0x54, 0xD9, 0xBE]), VPMADDWD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMADDUBSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x04, 0xF3]), VPMADDUBSW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x04, 0x72, 0xF8]), VPMADDUBSW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x04, 0xDC]), VPMADDUBSW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x04, 0x59, 0xFC]), VPMADDUBSW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x04, 0xC9]), VPMADDUBSW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x04, 0x48, 0xFE]), VPMADDUBSW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x04, 0xCB]), VPMADDUBSW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x04, 0x4C, 0xC2, 0xB3]), VPMADDUBSW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x04, 0xD4]), VPMADDUBSW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x04, 0x54, 0xD9, 0xBE]), VPMADDUBSW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPMADD52LUQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0xB4, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPMADD52LUQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0xB4, 0xF3]), VPMADD52LUQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0xB4, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMADD52LUQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0xB4, 0xDC]), VPMADD52LUQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0xB4, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMADD52LUQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0xB4, 0xC9]), VPMADD52LUQ(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPMADD52HUQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0xB5, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPMADD52HUQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0xB5, 0xF3]), VPMADD52HUQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0xB5, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMADD52HUQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0xB5, 0xDC]), VPMADD52HUQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0xB5, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMADD52HUQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0xB5, 0xC9]), VPMADD52HUQ(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPAVGB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xE0, 0xF3]), VPAVGB(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xE0, 0x72, 0xF8]), VPAVGB(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xE0, 0xDC]), VPAVGB(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xE0, 0x59, 0xFC]), VPAVGB(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xE0, 0xC9]), VPAVGB(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xE0, 0x48, 0xFE]), VPAVGB(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xE0, 0xCB]), VPAVGB(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xE0, 0x4C, 0xC2, 0xB3]), VPAVGB(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xE0, 0xD4]), VPAVGB(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xE0, 0x54, 0xD9, 0xBE]), VPAVGB(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPAVGW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xE3, 0xF3]), VPAVGW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xE3, 0x72, 0xF8]), VPAVGW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xE3, 0xDC]), VPAVGW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xE3, 0x59, 0xFC]), VPAVGW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xE3, 0xC9]), VPAVGW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xE3, 0x48, 0xFE]), VPAVGW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0xE3, 0xCB]), VPAVGW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xE3, 0x4C, 0xC2, 0xB3]), VPAVGW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xE3, 0xD4]), VPAVGW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xE3, 0x54, 0xD9, 0xBE]), VPAVGW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPSADBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x89, 0xF6, 0xCB]), VPSADBW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x5D, 0x08, 0xF6, 0xC3]), VPSADBW(xmm16, xmm4, xmm19).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xF6, 0x4C, 0xC2, 0xB3]), VPSADBW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x5D, 0x08, 0xF6, 0x42, 0xF8]), VPSADBW(xmm16, xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xF6, 0xD4]), VPSADBW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0x28, 0xF6, 0xCC]), VPSADBW(ymm17, ymm5, ymm20).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xF6, 0x54, 0xD9, 0xBE]), VPSADBW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0x28, 0xF6, 0x49, 0xFC]), VPSADBW(ymm17, ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x2D, 0x40, 0xF6, 0xD9]), VPSADBW(zmm3, zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x2D, 0x40, 0xF6, 0x58, 0xFE]), VPSADBW(zmm3, zmm26, zword[r8 - 128]).encode())


class TestVMPSADBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x09, 0x42, 0xCB, 0x02]), VMPSADBW(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x09, 0x42, 0x4C, 0xC2, 0xB3, 0x02]), VMPSADBW(xmm1, xmm14, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xE3, 0x05, 0x42, 0xD4, 0x02]), VMPSADBW(ymm2, ymm15, ymm4, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x05, 0x42, 0x54, 0xD9, 0xBE, 0x02]), VMPSADBW(ymm2, ymm15, hword[r9 + rbx*8 - 66], 2).encode())


class TestVDBPSADBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x23, 0x5D, 0x8A, 0x42, 0xF3, 0x02]), VDBPSADBW(xmm30(k2.z), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0x43, 0x5D, 0x8A, 0x42, 0x72, 0xF8, 0x02]), VDBPSADBW(xmm30(k2.z), xmm4, oword[r10 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0xA3, 0x55, 0xAD, 0x42, 0xDC, 0x02]), VDBPSADBW(ymm19(k5.z), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0x55, 0xAD, 0x42, 0x59, 0xFC, 0x02]), VDBPSADBW(ymm19(k5.z), ymm5, hword[r9 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x2D, 0xC6, 0x42, 0xC9, 0x02]), VDBPSADBW(zmm9(k6.z), zmm26, zmm9, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x2D, 0xC6, 0x42, 0x48, 0xFE, 0x02]), VDBPSADBW(zmm9(k6.z), zmm26, zword[r8 - 128], 2).encode())


class TestVPHMINPOSUW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x41, 0xCE]), VPHMINPOSUW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x41, 0x4C, 0xC2, 0xB3]), VPHMINPOSUW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestVPCMPEQB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xB1, 0x5D, 0x0E, 0x74, 0xE3]), VPCMPEQB(k4(k6), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x5D, 0x0E, 0x74, 0x62, 0xF8]), VPCMPEQB(k4(k6), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xB1, 0x55, 0x2E, 0x74, 0xE4]), VPCMPEQB(k4(k6), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x55, 0x2E, 0x74, 0x61, 0xFC]), VPCMPEQB(k4(k6), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x2D, 0x46, 0x74, 0xE1]), VPCMPEQB(k4(k6), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x2D, 0x46, 0x74, 0x60, 0xFE]), VPCMPEQB(k4(k6), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x74, 0xCB]), VPCMPEQB(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x74, 0x4C, 0xC2, 0xB3]), VPCMPEQB(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x74, 0xD4]), VPCMPEQB(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x74, 0x54, 0xD9, 0xBE]), VPCMPEQB(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPCMPEQW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xB1, 0x5D, 0x0E, 0x75, 0xE3]), VPCMPEQW(k4(k6), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x5D, 0x0E, 0x75, 0x62, 0xF8]), VPCMPEQW(k4(k6), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xB1, 0x55, 0x2E, 0x75, 0xE4]), VPCMPEQW(k4(k6), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x55, 0x2E, 0x75, 0x61, 0xFC]), VPCMPEQW(k4(k6), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x2D, 0x46, 0x75, 0xE1]), VPCMPEQW(k4(k6), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x2D, 0x46, 0x75, 0x60, 0xFE]), VPCMPEQW(k4(k6), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x75, 0xCB]), VPCMPEQW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x75, 0x4C, 0xC2, 0xB3]), VPCMPEQW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x75, 0xD4]), VPCMPEQW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x75, 0x54, 0xD9, 0xBE]), VPCMPEQW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPCMPEQD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x5D, 0x0E, 0x76, 0xA4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPCMPEQD(k4(k6), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xB1, 0x5D, 0x0E, 0x76, 0xE3]), VPCMPEQD(k4(k6), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x55, 0x2E, 0x76, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPCMPEQD(k4(k6), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xB1, 0x55, 0x2E, 0x76, 0xE4]), VPCMPEQD(k4(k6), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x2D, 0x46, 0x76, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPCMPEQD(k4(k6), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x2D, 0x46, 0x76, 0xE1]), VPCMPEQD(k4(k6), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x76, 0xCB]), VPCMPEQD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x76, 0x4C, 0xC2, 0xB3]), VPCMPEQD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x76, 0xD4]), VPCMPEQD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x76, 0x54, 0xD9, 0xBE]), VPCMPEQD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPCMPEQQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD2, 0xDD, 0x0E, 0x29, 0xA4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPCMPEQQ(k4(k6), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xB2, 0xDD, 0x0E, 0x29, 0xE3]), VPCMPEQQ(k4(k6), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xD5, 0x2E, 0x29, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPCMPEQQ(k4(k6), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xB2, 0xD5, 0x2E, 0x29, 0xE4]), VPCMPEQQ(k4(k6), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xAD, 0x46, 0x29, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPCMPEQQ(k4(k6), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xAD, 0x46, 0x29, 0xE1]), VPCMPEQQ(k4(k6), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x29, 0xCB]), VPCMPEQQ(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x29, 0x4C, 0xC2, 0xB3]), VPCMPEQQ(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x29, 0xD4]), VPCMPEQQ(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x29, 0x54, 0xD9, 0xBE]), VPCMPEQQ(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPCMPGTB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xB1, 0x5D, 0x0E, 0x64, 0xE3]), VPCMPGTB(k4(k6), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x5D, 0x0E, 0x64, 0x62, 0xF8]), VPCMPGTB(k4(k6), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xB1, 0x55, 0x2E, 0x64, 0xE4]), VPCMPGTB(k4(k6), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x55, 0x2E, 0x64, 0x61, 0xFC]), VPCMPGTB(k4(k6), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x2D, 0x46, 0x64, 0xE1]), VPCMPGTB(k4(k6), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x2D, 0x46, 0x64, 0x60, 0xFE]), VPCMPGTB(k4(k6), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x64, 0xCB]), VPCMPGTB(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x64, 0x4C, 0xC2, 0xB3]), VPCMPGTB(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x64, 0xD4]), VPCMPGTB(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x64, 0x54, 0xD9, 0xBE]), VPCMPGTB(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPCMPGTW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xB1, 0x5D, 0x0E, 0x65, 0xE3]), VPCMPGTW(k4(k6), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x5D, 0x0E, 0x65, 0x62, 0xF8]), VPCMPGTW(k4(k6), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xB1, 0x55, 0x2E, 0x65, 0xE4]), VPCMPGTW(k4(k6), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x55, 0x2E, 0x65, 0x61, 0xFC]), VPCMPGTW(k4(k6), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x2D, 0x46, 0x65, 0xE1]), VPCMPGTW(k4(k6), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x2D, 0x46, 0x65, 0x60, 0xFE]), VPCMPGTW(k4(k6), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x65, 0xCB]), VPCMPGTW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x65, 0x4C, 0xC2, 0xB3]), VPCMPGTW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x65, 0xD4]), VPCMPGTW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x65, 0x54, 0xD9, 0xBE]), VPCMPGTW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPCMPGTD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x5D, 0x0E, 0x66, 0xA4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPCMPGTD(k4(k6), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xB1, 0x5D, 0x0E, 0x66, 0xE3]), VPCMPGTD(k4(k6), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x55, 0x2E, 0x66, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPCMPGTD(k4(k6), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xB1, 0x55, 0x2E, 0x66, 0xE4]), VPCMPGTD(k4(k6), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x2D, 0x46, 0x66, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPCMPGTD(k4(k6), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x2D, 0x46, 0x66, 0xE1]), VPCMPGTD(k4(k6), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x66, 0xCB]), VPCMPGTD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x66, 0x4C, 0xC2, 0xB3]), VPCMPGTD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x66, 0xD4]), VPCMPGTD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x66, 0x54, 0xD9, 0xBE]), VPCMPGTD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPCMPGTQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD2, 0xDD, 0x0E, 0x37, 0xA4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPCMPGTQ(k4(k6), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xB2, 0xDD, 0x0E, 0x37, 0xE3]), VPCMPGTQ(k4(k6), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xD5, 0x2E, 0x37, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPCMPGTQ(k4(k6), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xB2, 0xD5, 0x2E, 0x37, 0xE4]), VPCMPGTQ(k4(k6), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xAD, 0x46, 0x37, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPCMPGTQ(k4(k6), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xAD, 0x46, 0x37, 0xE1]), VPCMPGTQ(k4(k6), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x37, 0xCB]), VPCMPGTQ(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x37, 0x4C, 0xC2, 0xB3]), VPCMPGTQ(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x37, 0xD4]), VPCMPGTQ(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x37, 0x54, 0xD9, 0xBE]), VPCMPGTQ(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPCMPB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xB3, 0x5D, 0x0E, 0x3F, 0xE3, 0x02]), VPCMPB(k4(k6), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0x5D, 0x0E, 0x3F, 0x62, 0xF8, 0x02]), VPCMPB(k4(k6), xmm4, oword[r10 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0xB3, 0x55, 0x2E, 0x3F, 0xE4, 0x02]), VPCMPB(k4(k6), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0x55, 0x2E, 0x3F, 0x61, 0xFC, 0x02]), VPCMPB(k4(k6), ymm5, hword[r9 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0x2D, 0x46, 0x3F, 0xE1, 0x02]), VPCMPB(k4(k6), zmm26, zmm9, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0x2D, 0x46, 0x3F, 0x60, 0xFE, 0x02]), VPCMPB(k4(k6), zmm26, zword[r8 - 128], 2).encode())


class TestVPCMPW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xB3, 0xDD, 0x0E, 0x3F, 0xE3, 0x02]), VPCMPW(k4(k6), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0xDD, 0x0E, 0x3F, 0x62, 0xF8, 0x02]), VPCMPW(k4(k6), xmm4, oword[r10 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0xB3, 0xD5, 0x2E, 0x3F, 0xE4, 0x02]), VPCMPW(k4(k6), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0xD5, 0x2E, 0x3F, 0x61, 0xFC, 0x02]), VPCMPW(k4(k6), ymm5, hword[r9 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0xAD, 0x46, 0x3F, 0xE1, 0x02]), VPCMPW(k4(k6), zmm26, zmm9, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0xAD, 0x46, 0x3F, 0x60, 0xFE, 0x02]), VPCMPW(k4(k6), zmm26, zword[r8 - 128], 2).encode())


class TestVPCMPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD3, 0x5D, 0x0E, 0x1F, 0xA4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VPCMPD(k4(k6), xmm4, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xB3, 0x5D, 0x0E, 0x1F, 0xE3, 0x02]), VPCMPD(k4(k6), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0x55, 0x2E, 0x1F, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPCMPD(k4(k6), ymm5, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xB3, 0x55, 0x2E, 0x1F, 0xE4, 0x02]), VPCMPD(k4(k6), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0x2D, 0x46, 0x1F, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPCMPD(k4(k6), zmm26, zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0x2D, 0x46, 0x1F, 0xE1, 0x02]), VPCMPD(k4(k6), zmm26, zmm9, 2).encode())


class TestVPCMPQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD3, 0xDD, 0x0E, 0x1F, 0xA4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VPCMPQ(k4(k6), xmm4, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xB3, 0xDD, 0x0E, 0x1F, 0xE3, 0x02]), VPCMPQ(k4(k6), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0xD5, 0x2E, 0x1F, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPCMPQ(k4(k6), ymm5, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xB3, 0xD5, 0x2E, 0x1F, 0xE4, 0x02]), VPCMPQ(k4(k6), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0xAD, 0x46, 0x1F, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPCMPQ(k4(k6), zmm26, zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0xAD, 0x46, 0x1F, 0xE1, 0x02]), VPCMPQ(k4(k6), zmm26, zmm9, 2).encode())


class TestVPCMPUB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xB3, 0x5D, 0x0E, 0x3E, 0xE3, 0x02]), VPCMPUB(k4(k6), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0x5D, 0x0E, 0x3E, 0x62, 0xF8, 0x02]), VPCMPUB(k4(k6), xmm4, oword[r10 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0xB3, 0x55, 0x2E, 0x3E, 0xE4, 0x02]), VPCMPUB(k4(k6), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0x55, 0x2E, 0x3E, 0x61, 0xFC, 0x02]), VPCMPUB(k4(k6), ymm5, hword[r9 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0x2D, 0x46, 0x3E, 0xE1, 0x02]), VPCMPUB(k4(k6), zmm26, zmm9, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0x2D, 0x46, 0x3E, 0x60, 0xFE, 0x02]), VPCMPUB(k4(k6), zmm26, zword[r8 - 128], 2).encode())


class TestVPCMPUW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xB3, 0xDD, 0x0E, 0x3E, 0xE3, 0x02]), VPCMPUW(k4(k6), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0xDD, 0x0E, 0x3E, 0x62, 0xF8, 0x02]), VPCMPUW(k4(k6), xmm4, oword[r10 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0xB3, 0xD5, 0x2E, 0x3E, 0xE4, 0x02]), VPCMPUW(k4(k6), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0xD5, 0x2E, 0x3E, 0x61, 0xFC, 0x02]), VPCMPUW(k4(k6), ymm5, hword[r9 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0xAD, 0x46, 0x3E, 0xE1, 0x02]), VPCMPUW(k4(k6), zmm26, zmm9, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0xAD, 0x46, 0x3E, 0x60, 0xFE, 0x02]), VPCMPUW(k4(k6), zmm26, zword[r8 - 128], 2).encode())


class TestVPCMPUD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD3, 0x5D, 0x0E, 0x1E, 0xA4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VPCMPUD(k4(k6), xmm4, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xB3, 0x5D, 0x0E, 0x1E, 0xE3, 0x02]), VPCMPUD(k4(k6), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0x55, 0x2E, 0x1E, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPCMPUD(k4(k6), ymm5, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xB3, 0x55, 0x2E, 0x1E, 0xE4, 0x02]), VPCMPUD(k4(k6), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0x2D, 0x46, 0x1E, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPCMPUD(k4(k6), zmm26, zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0x2D, 0x46, 0x1E, 0xE1, 0x02]), VPCMPUD(k4(k6), zmm26, zmm9, 2).encode())


class TestVPCMPUQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD3, 0xDD, 0x0E, 0x1E, 0xA4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VPCMPUQ(k4(k6), xmm4, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xB3, 0xDD, 0x0E, 0x1E, 0xE3, 0x02]), VPCMPUQ(k4(k6), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0xD5, 0x2E, 0x1E, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPCMPUQ(k4(k6), ymm5, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xB3, 0xD5, 0x2E, 0x1E, 0xE4, 0x02]), VPCMPUQ(k4(k6), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0xAD, 0x46, 0x1E, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPCMPUQ(k4(k6), zmm26, zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0xAD, 0x46, 0x1E, 0xE1, 0x02]), VPCMPUQ(k4(k6), zmm26, zmm9, 2).encode())


class TestVPABSB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x1C, 0xF4]), VPABSB(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x1C, 0xDD]), VPABSB(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0x7D, 0xCE, 0x1C, 0xCA]), VPABSB(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x1C, 0x72, 0x04]), VPABSB(xmm30(k2.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x1C, 0x59, 0x02]), VPABSB(ymm19(k5.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x1C, 0x48, 0x01]), VPABSB(zmm9(k6.z), zword[r8 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x1C, 0xCE]), VPABSB(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x1C, 0x4C, 0xC2, 0xB3]), VPABSB(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x1C, 0xD7]), VPABSB(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x1C, 0x54, 0xD9, 0xBE]), VPABSB(ymm2, hword[r9 + rbx*8 - 66]).encode())


class TestVPABSW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x1D, 0xF4]), VPABSW(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x1D, 0xDD]), VPABSW(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0x7D, 0xCE, 0x1D, 0xCA]), VPABSW(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x1D, 0x72, 0x04]), VPABSW(xmm30(k2.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x1D, 0x59, 0x02]), VPABSW(ymm19(k5.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x1D, 0x48, 0x01]), VPABSW(zmm9(k6.z), zword[r8 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x1D, 0xCE]), VPABSW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x1D, 0x4C, 0xC2, 0xB3]), VPABSW(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x1D, 0xD7]), VPABSW(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x1D, 0x54, 0xD9, 0xBE]), VPABSW(ymm2, hword[r9 + rbx*8 - 66]).encode())


class TestVPABSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x1E, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPABSD(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x1E, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPABSD(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x1E, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPABSD(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x1E, 0xF4]), VPABSD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x1E, 0xDD]), VPABSD(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0x7D, 0xCE, 0x1E, 0xCA]), VPABSD(zmm9(k6.z), zmm26).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x1E, 0xCE]), VPABSD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x1E, 0x4C, 0xC2, 0xB3]), VPABSD(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x1E, 0xD7]), VPABSD(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x1E, 0x54, 0xD9, 0xBE]), VPABSD(ymm2, hword[r9 + rbx*8 - 66]).encode())


class TestVPABSQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xFD, 0x8A, 0x1F, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPABSQ(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xFD, 0xAD, 0x1F, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPABSQ(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xFD, 0xCE, 0x1F, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPABSQ(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x62, 0xFD, 0x8A, 0x1F, 0xF4]), VPABSQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0xFD, 0xAD, 0x1F, 0xDD]), VPABSQ(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0xFD, 0xCE, 0x1F, 0xCA]), VPABSQ(zmm9(k6.z), zmm26).encode())


class TestVPSIGNB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x08, 0xCB]), VPSIGNB(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x08, 0x4C, 0xC2, 0xB3]), VPSIGNB(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x08, 0xD4]), VPSIGNB(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x08, 0x54, 0xD9, 0xBE]), VPSIGNB(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPSIGNW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x09, 0xCB]), VPSIGNW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x09, 0x4C, 0xC2, 0xB3]), VPSIGNW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x09, 0xD4]), VPSIGNW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x09, 0x54, 0xD9, 0xBE]), VPSIGNW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPSIGND(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x0A, 0xCB]), VPSIGND(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x0A, 0x4C, 0xC2, 0xB3]), VPSIGND(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x0A, 0xD4]), VPSIGND(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x0A, 0x54, 0xD9, 0xBE]), VPSIGND(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPAND(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x89, 0xDB, 0xCB]), VPAND(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xDB, 0x4C, 0xC2, 0xB3]), VPAND(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xDB, 0xD4]), VPAND(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xDB, 0x54, 0xD9, 0xBE]), VPAND(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPANDD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xDB, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPANDD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xDB, 0xF3]), VPANDD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xDB, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPANDD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xDB, 0xDC]), VPANDD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xDB, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPANDD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xDB, 0xC9]), VPANDD(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPANDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0xDB, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPANDQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0xDB, 0xF3]), VPANDQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0xDB, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPANDQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0xDB, 0xDC]), VPANDQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0xDB, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPANDQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0xDB, 0xC9]), VPANDQ(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPANDN(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x89, 0xDF, 0xCB]), VPANDN(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xDF, 0x4C, 0xC2, 0xB3]), VPANDN(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xDF, 0xD4]), VPANDN(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xDF, 0x54, 0xD9, 0xBE]), VPANDN(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPANDND(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xDF, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPANDND(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xDF, 0xF3]), VPANDND(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xDF, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPANDND(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xDF, 0xDC]), VPANDND(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xDF, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPANDND(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xDF, 0xC9]), VPANDND(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPANDNQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0xDF, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPANDNQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0xDF, 0xF3]), VPANDNQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0xDF, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPANDNQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0xDF, 0xDC]), VPANDNQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0xDF, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPANDNQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0xDF, 0xC9]), VPANDNQ(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPOR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x89, 0xEB, 0xCB]), VPOR(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xEB, 0x4C, 0xC2, 0xB3]), VPOR(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xEB, 0xD4]), VPOR(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xEB, 0x54, 0xD9, 0xBE]), VPOR(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPORD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xEB, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPORD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xEB, 0xF3]), VPORD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xEB, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPORD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xEB, 0xDC]), VPORD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xEB, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPORD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xEB, 0xC9]), VPORD(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPORQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0xEB, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPORQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0xEB, 0xF3]), VPORQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0xEB, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPORQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0xEB, 0xDC]), VPORQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0xEB, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPORQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0xEB, 0xC9]), VPORQ(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPXOR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x89, 0xEF, 0xCB]), VPXOR(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0xEF, 0x4C, 0xC2, 0xB3]), VPXOR(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0xEF, 0xD4]), VPXOR(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0xEF, 0x54, 0xD9, 0xBE]), VPXOR(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPXORD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0xEF, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPXORD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0xEF, 0xF3]), VPXORD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0xEF, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPXORD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0xEF, 0xDC]), VPXORD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xEF, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPXORD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0xEF, 0xC9]), VPXORD(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPXORQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0xEF, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPXORQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0xEF, 0xF3]), VPXORQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0xEF, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPXORQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0xEF, 0xDC]), VPXORQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0xEF, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPXORQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0xEF, 0xC9]), VPXORQ(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPTERNLOGD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0x5D, 0x8A, 0x25, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VPTERNLOGD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0x23, 0x5D, 0x8A, 0x25, 0xF3, 0x02]), VPTERNLOGD(xmm30(k2.z), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0x55, 0xAD, 0x25, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPTERNLOGD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xA3, 0x55, 0xAD, 0x25, 0xDC, 0x02]), VPTERNLOGD(ymm19(k5.z), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x2D, 0xC6, 0x25, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPTERNLOGD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x2D, 0xC6, 0x25, 0xC9, 0x02]), VPTERNLOGD(zmm9(k6.z), zmm26, zmm9, 2).encode())


class TestVPTERNLOGQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0xDD, 0x8A, 0x25, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VPTERNLOGQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0x23, 0xDD, 0x8A, 0x25, 0xF3, 0x02]), VPTERNLOGQ(xmm30(k2.z), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0xD5, 0xAD, 0x25, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPTERNLOGQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xA3, 0xD5, 0xAD, 0x25, 0xDC, 0x02]), VPTERNLOGQ(ymm19(k5.z), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xAD, 0xC6, 0x25, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPTERNLOGQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xAD, 0xC6, 0x25, 0xC9, 0x02]), VPTERNLOGQ(zmm9(k6.z), zmm26, zmm9, 2).encode())


class TestVPBLENDW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x09, 0x0E, 0xCB, 0x02]), VPBLENDW(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x09, 0x0E, 0x4C, 0xC2, 0xB3, 0x02]), VPBLENDW(xmm1, xmm14, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xE3, 0x05, 0x0E, 0xD4, 0x02]), VPBLENDW(ymm2, ymm15, ymm4, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x05, 0x0E, 0x54, 0xD9, 0xBE, 0x02]), VPBLENDW(ymm2, ymm15, hword[r9 + rbx*8 - 66], 2).encode())


class TestVPBLENDVB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x09, 0x4C, 0xCB, 0x90]), VPBLENDVB(xmm1, xmm14, xmm3, xmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x09, 0x4C, 0x4C, 0xC2, 0xB3, 0x90]), VPBLENDVB(xmm1, xmm14, oword[r10 + rax*8 - 77], xmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xE3, 0x05, 0x4C, 0xD4, 0xA0]), VPBLENDVB(ymm2, ymm15, ymm4, ymm10).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x05, 0x4C, 0x54, 0xD9, 0xBE, 0xA0]), VPBLENDVB(ymm2, ymm15, hword[r9 + rbx*8 - 66], ymm10).encode())


class TestVPBLENDD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x09, 0x02, 0xCB, 0x02]), VPBLENDD(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x09, 0x02, 0x4C, 0xC2, 0xB3, 0x02]), VPBLENDD(xmm1, xmm14, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xE3, 0x05, 0x02, 0xD4, 0x02]), VPBLENDD(ymm2, ymm15, ymm4, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x05, 0x02, 0x54, 0xD9, 0xBE, 0x02]), VPBLENDD(ymm2, ymm15, hword[r9 + rbx*8 - 66], 2).encode())


class TestVPBLENDMB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x66, 0xF3]), VPBLENDMB(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x66, 0x72, 0xF8]), VPBLENDMB(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x66, 0xDC]), VPBLENDMB(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x66, 0x59, 0xFC]), VPBLENDMB(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x66, 0xC9]), VPBLENDMB(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x66, 0x48, 0xFE]), VPBLENDMB(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())


class TestVPBLENDMW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x66, 0xF3]), VPBLENDMW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x66, 0x72, 0xF8]), VPBLENDMW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x66, 0xDC]), VPBLENDMW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x66, 0x59, 0xFC]), VPBLENDMW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x66, 0xC9]), VPBLENDMW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x66, 0x48, 0xFE]), VPBLENDMW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())


class TestVPBLENDMD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x64, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPBLENDMD(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x64, 0xF3]), VPBLENDMD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x64, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPBLENDMD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x64, 0xDC]), VPBLENDMD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x64, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPBLENDMD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x64, 0xC9]), VPBLENDMD(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPBLENDMQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x64, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPBLENDMQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x64, 0xF3]), VPBLENDMQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x64, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPBLENDMQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x64, 0xDC]), VPBLENDMQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x64, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPBLENDMQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x64, 0xC9]), VPBLENDMQ(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPUNPCKLBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0x60, 0xF3]), VPUNPCKLBW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0x60, 0x72, 0xF8]), VPUNPCKLBW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0x60, 0xDC]), VPUNPCKLBW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0x60, 0x59, 0xFC]), VPUNPCKLBW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0x60, 0xC9]), VPUNPCKLBW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0x60, 0x48, 0xFE]), VPUNPCKLBW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x60, 0xCB]), VPUNPCKLBW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x60, 0x4C, 0xC2, 0xB3]), VPUNPCKLBW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x60, 0xD4]), VPUNPCKLBW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x60, 0x54, 0xD9, 0xBE]), VPUNPCKLBW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPUNPCKLWD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0x61, 0xF3]), VPUNPCKLWD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0x61, 0x72, 0xF8]), VPUNPCKLWD(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0x61, 0xDC]), VPUNPCKLWD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0x61, 0x59, 0xFC]), VPUNPCKLWD(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0x61, 0xC9]), VPUNPCKLWD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0x61, 0x48, 0xFE]), VPUNPCKLWD(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x61, 0xCB]), VPUNPCKLWD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x61, 0x4C, 0xC2, 0xB3]), VPUNPCKLWD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x61, 0xD4]), VPUNPCKLWD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x61, 0x54, 0xD9, 0xBE]), VPUNPCKLWD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPUNPCKLDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0x62, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPUNPCKLDQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0x62, 0xF3]), VPUNPCKLDQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0x62, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPUNPCKLDQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0x62, 0xDC]), VPUNPCKLDQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0x62, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPUNPCKLDQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0x62, 0xC9]), VPUNPCKLDQ(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x62, 0xCB]), VPUNPCKLDQ(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x62, 0x4C, 0xC2, 0xB3]), VPUNPCKLDQ(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x62, 0xD4]), VPUNPCKLDQ(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x62, 0x54, 0xD9, 0xBE]), VPUNPCKLDQ(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPUNPCKLQDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0x6C, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPUNPCKLQDQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0x6C, 0xF3]), VPUNPCKLQDQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0x6C, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPUNPCKLQDQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0x6C, 0xDC]), VPUNPCKLQDQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x6C, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPUNPCKLQDQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x6C, 0xC9]), VPUNPCKLQDQ(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x6C, 0xCB]), VPUNPCKLQDQ(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x6C, 0x4C, 0xC2, 0xB3]), VPUNPCKLQDQ(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x6C, 0xD4]), VPUNPCKLQDQ(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x6C, 0x54, 0xD9, 0xBE]), VPUNPCKLQDQ(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPUNPCKHBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0x68, 0xF3]), VPUNPCKHBW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0x68, 0x72, 0xF8]), VPUNPCKHBW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0x68, 0xDC]), VPUNPCKHBW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0x68, 0x59, 0xFC]), VPUNPCKHBW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0x68, 0xC9]), VPUNPCKHBW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0x68, 0x48, 0xFE]), VPUNPCKHBW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x68, 0xCB]), VPUNPCKHBW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x68, 0x4C, 0xC2, 0xB3]), VPUNPCKHBW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x68, 0xD4]), VPUNPCKHBW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x68, 0x54, 0xD9, 0xBE]), VPUNPCKHBW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPUNPCKHWD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0x69, 0xF3]), VPUNPCKHWD(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0x69, 0x72, 0xF8]), VPUNPCKHWD(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0x69, 0xDC]), VPUNPCKHWD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0x69, 0x59, 0xFC]), VPUNPCKHWD(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0x69, 0xC9]), VPUNPCKHWD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0x69, 0x48, 0xFE]), VPUNPCKHWD(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x69, 0xCB]), VPUNPCKHWD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x69, 0x4C, 0xC2, 0xB3]), VPUNPCKHWD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x69, 0xD4]), VPUNPCKHWD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x69, 0x54, 0xD9, 0xBE]), VPUNPCKHWD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPUNPCKHDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0x6A, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPUNPCKHDQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0x6A, 0xF3]), VPUNPCKHDQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0x6A, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPUNPCKHDQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0x6A, 0xDC]), VPUNPCKHDQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0x6A, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPUNPCKHDQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0x6A, 0xC9]), VPUNPCKHDQ(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x6A, 0xCB]), VPUNPCKHDQ(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x6A, 0x4C, 0xC2, 0xB3]), VPUNPCKHDQ(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x6A, 0xD4]), VPUNPCKHDQ(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x6A, 0x54, 0xD9, 0xBE]), VPUNPCKHDQ(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPUNPCKHQDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDD, 0x8A, 0x6D, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPUNPCKHQDQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDD, 0x8A, 0x6D, 0xF3]), VPUNPCKHQDQ(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xD5, 0xAD, 0x6D, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPUNPCKHQDQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0xD5, 0xAD, 0x6D, 0xDC]), VPUNPCKHQDQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x6D, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPUNPCKHQDQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xAD, 0xC6, 0x6D, 0xC9]), VPUNPCKHQDQ(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x6D, 0xCB]), VPUNPCKHQDQ(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x6D, 0x4C, 0xC2, 0xB3]), VPUNPCKHQDQ(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x6D, 0xD4]), VPUNPCKHQDQ(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x6D, 0x54, 0xD9, 0xBE]), VPUNPCKHQDQ(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPACKSSWB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0x63, 0xF3]), VPACKSSWB(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0x63, 0x72, 0xF8]), VPACKSSWB(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0x63, 0xDC]), VPACKSSWB(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0x63, 0x59, 0xFC]), VPACKSSWB(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0x63, 0xC9]), VPACKSSWB(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0x63, 0x48, 0xFE]), VPACKSSWB(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x63, 0xCB]), VPACKSSWB(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x63, 0x4C, 0xC2, 0xB3]), VPACKSSWB(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x63, 0xD4]), VPACKSSWB(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x63, 0x54, 0xD9, 0xBE]), VPACKSSWB(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPACKSSDW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0x6B, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPACKSSDW(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0x6B, 0xF3]), VPACKSSDW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0x6B, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPACKSSDW(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0x6B, 0xDC]), VPACKSSDW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0x6B, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPACKSSDW(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0x6B, 0xC9]), VPACKSSDW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x6B, 0xCB]), VPACKSSDW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x6B, 0x4C, 0xC2, 0xB3]), VPACKSSDW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x6B, 0xD4]), VPACKSSDW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x6B, 0x54, 0xD9, 0xBE]), VPACKSSDW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPACKUSWB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x21, 0x5D, 0x8A, 0x67, 0xF3]), VPACKUSWB(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x5D, 0x8A, 0x67, 0x72, 0xF8]), VPACKUSWB(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA1, 0x55, 0xAD, 0x67, 0xDC]), VPACKUSWB(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x55, 0xAD, 0x67, 0x59, 0xFC]), VPACKUSWB(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0x67, 0xC9]), VPACKUSWB(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x2D, 0xC6, 0x67, 0x48, 0xFE]), VPACKUSWB(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x89, 0x67, 0xCB]), VPACKUSWB(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x09, 0x67, 0x4C, 0xC2, 0xB3]), VPACKUSWB(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC5, 0x85, 0x67, 0xD4]), VPACKUSWB(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x05, 0x67, 0x54, 0xD9, 0xBE]), VPACKUSWB(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPACKUSDW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x2B, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPACKUSDW(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x2B, 0xF3]), VPACKUSDW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x2B, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPACKUSDW(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x2B, 0xDC]), VPACKUSDW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x2B, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPACKUSDW(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x2B, 0xC9]), VPACKUSDW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x2B, 0xCB]), VPACKUSDW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x2B, 0x4C, 0xC2, 0xB3]), VPACKUSDW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x2B, 0xD4]), VPACKUSDW(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x2B, 0x54, 0xD9, 0xBE]), VPACKUSDW(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPSHUFB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x00, 0xF3]), VPSHUFB(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x00, 0x72, 0xF8]), VPSHUFB(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x00, 0xDC]), VPSHUFB(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x00, 0x59, 0xFC]), VPSHUFB(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x00, 0xC9]), VPSHUFB(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x00, 0x48, 0xFE]), VPSHUFB(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x09, 0x00, 0xCB]), VPSHUFB(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x09, 0x00, 0x4C, 0xC2, 0xB3]), VPSHUFB(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x00, 0xD4]), VPSHUFB(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x00, 0x54, 0xD9, 0xBE]), VPSHUFB(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPSHUFLW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x61, 0x7F, 0x8A, 0x70, 0xF4, 0x02]), VPSHUFLW(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7F, 0xAD, 0x70, 0xDD, 0x02]), VPSHUFLW(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0x7F, 0xCE, 0x70, 0xCA, 0x02]), VPSHUFLW(zmm9(k6.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x7F, 0x8A, 0x70, 0x72, 0x04, 0x02]), VPSHUFLW(xmm30(k2.z), oword[r10 + 64], 2).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7F, 0xAD, 0x70, 0x59, 0x02, 0x02]), VPSHUFLW(ymm19(k5.z), hword[r9 + 64], 2).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7F, 0xCE, 0x70, 0x48, 0x01, 0x02]), VPSHUFLW(zmm9(k6.z), zword[r8 + 64], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7B, 0x70, 0xCE, 0x02]), VPSHUFLW(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7B, 0x70, 0x4C, 0xC2, 0xB3, 0x02]), VPSHUFLW(xmm1, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7F, 0x70, 0xD7, 0x02]), VPSHUFLW(ymm2, ymm15, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7F, 0x70, 0x54, 0xD9, 0xBE, 0x02]), VPSHUFLW(ymm2, hword[r9 + rbx*8 - 66], 2).encode())


class TestVPSHUFHW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x61, 0x7E, 0x8A, 0x70, 0xF4, 0x02]), VPSHUFHW(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7E, 0xAD, 0x70, 0xDD, 0x02]), VPSHUFHW(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0x7E, 0xCE, 0x70, 0xCA, 0x02]), VPSHUFHW(zmm9(k6.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0x7E, 0x8A, 0x70, 0x72, 0x04, 0x02]), VPSHUFHW(xmm30(k2.z), oword[r10 + 64], 2).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7E, 0xAD, 0x70, 0x59, 0x02, 0x02]), VPSHUFHW(ymm19(k5.z), hword[r9 + 64], 2).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7E, 0xCE, 0x70, 0x48, 0x01, 0x02]), VPSHUFHW(zmm9(k6.z), zword[r8 + 64], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7A, 0x70, 0xCE, 0x02]), VPSHUFHW(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7A, 0x70, 0x4C, 0xC2, 0xB3, 0x02]), VPSHUFHW(xmm1, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7E, 0x70, 0xD7, 0x02]), VPSHUFHW(ymm2, ymm15, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7E, 0x70, 0x54, 0xD9, 0xBE, 0x02]), VPSHUFHW(ymm2, hword[r9 + rbx*8 - 66], 2).encode())


class TestVPSHUFD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x7D, 0x8A, 0x70, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VPSHUFD(xmm30(k2.z), oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7D, 0xAD, 0x70, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPSHUFD(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7D, 0xCE, 0x70, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPSHUFD(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0x7D, 0x8A, 0x70, 0xF4, 0x02]), VPSHUFD(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7D, 0xAD, 0x70, 0xDD, 0x02]), VPSHUFD(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0x7D, 0xCE, 0x70, 0xCA, 0x02]), VPSHUFD(zmm9(k6.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x70, 0xCE, 0x02]), VPSHUFD(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x70, 0x4C, 0xC2, 0xB3, 0x02]), VPSHUFD(xmm1, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7D, 0x70, 0xD7, 0x02]), VPSHUFD(ymm2, ymm15, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7D, 0x70, 0x54, 0xD9, 0xBE, 0x02]), VPSHUFD(ymm2, hword[r9 + rbx*8 - 66], 2).encode())


class TestVPERMB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x8D, 0xF3]), VPERMB(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x8D, 0x72, 0xF8]), VPERMB(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x8D, 0xDC]), VPERMB(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x8D, 0x59, 0xFC]), VPERMB(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x8D, 0xC9]), VPERMB(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x8D, 0x48, 0xFE]), VPERMB(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())


class TestVPERMW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x8D, 0xF3]), VPERMW(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x8D, 0x72, 0xF8]), VPERMW(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x8D, 0xDC]), VPERMW(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x8D, 0x59, 0xFC]), VPERMW(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x8D, 0xC9]), VPERMW(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x8D, 0x48, 0xFE]), VPERMW(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())


class TestVPERMD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x36, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMD(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x36, 0xDC]), VPERMD(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x36, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMD(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x36, 0xC9]), VPERMD(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xE2, 0x05, 0x36, 0xD4]), VPERMD(ymm2, ymm15, ymm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x05, 0x36, 0x54, 0xD9, 0xBE]), VPERMD(ymm2, ymm15, hword[r9 + rbx*8 - 66]).encode())


class TestVPERMQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xC3, 0xFD, 0xAD, 0x00, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPERMQ(ymm19(k5.z), hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xFD, 0xCE, 0x00, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VPERMQ(zmm9(k6.z), zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x36, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xE3, 0xFD, 0xAD, 0x00, 0xDD, 0x02]), VPERMQ(ymm19(k5.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x36, 0xDC]), VPERMQ(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x36, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x13, 0xFD, 0xCE, 0x00, 0xCA, 0x02]), VPERMQ(zmm9(k6.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x36, 0xC9]), VPERMQ(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0xFD, 0x00, 0xD7, 0x02]), VPERMQ(ymm2, ymm15, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0xFD, 0x00, 0x54, 0xD9, 0xBE, 0x02]), VPERMQ(ymm2, hword[r9 + rbx*8 - 66], 2).encode())


class TestVPERMT2B(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x7D, 0xF3]), VPERMT2B(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x7D, 0x72, 0xF8]), VPERMT2B(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x7D, 0xDC]), VPERMT2B(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x7D, 0x59, 0xFC]), VPERMT2B(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x7D, 0xC9]), VPERMT2B(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x7D, 0x48, 0xFE]), VPERMT2B(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())


class TestVPERMT2W(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x7D, 0xF3]), VPERMT2W(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x7D, 0x72, 0xF8]), VPERMT2W(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x7D, 0xDC]), VPERMT2W(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x7D, 0x59, 0xFC]), VPERMT2W(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x7D, 0xC9]), VPERMT2W(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x7D, 0x48, 0xFE]), VPERMT2W(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())


class TestVPERMT2D(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x7E, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPERMT2D(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x7E, 0xF3]), VPERMT2D(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x7E, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMT2D(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x7E, 0xDC]), VPERMT2D(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x7E, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMT2D(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x7E, 0xC9]), VPERMT2D(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPERMT2Q(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x7E, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPERMT2Q(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x7E, 0xF3]), VPERMT2Q(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x7E, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMT2Q(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x7E, 0xDC]), VPERMT2Q(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x7E, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMT2Q(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x7E, 0xC9]), VPERMT2Q(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPERMI2B(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x75, 0xF3]), VPERMI2B(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x75, 0x72, 0xF8]), VPERMI2B(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x75, 0xDC]), VPERMI2B(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x75, 0x59, 0xFC]), VPERMI2B(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x75, 0xC9]), VPERMI2B(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x75, 0x48, 0xFE]), VPERMI2B(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())


class TestVPERMI2W(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x75, 0xF3]), VPERMI2W(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x75, 0x72, 0xF8]), VPERMI2W(xmm30(k2.z), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x75, 0xDC]), VPERMI2W(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x75, 0x59, 0xFC]), VPERMI2W(ymm19(k5.z), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x75, 0xC9]), VPERMI2W(zmm9(k6.z), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x75, 0x48, 0xFE]), VPERMI2W(zmm9(k6.z), zmm26, zword[r8 - 128]).encode())


class TestVPERMI2D(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0x5D, 0x8A, 0x76, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPERMI2D(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0x5D, 0x8A, 0x76, 0xF3]), VPERMI2D(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x55, 0xAD, 0x76, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMI2D(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0x55, 0xAD, 0x76, 0xDC]), VPERMI2D(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x76, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMI2D(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x2D, 0xC6, 0x76, 0xC9]), VPERMI2D(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPERMI2Q(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x76, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPERMI2Q(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x76, 0xF3]), VPERMI2Q(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x76, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMI2Q(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x76, 0xDC]), VPERMI2Q(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x76, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPERMI2Q(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x76, 0xC9]), VPERMI2Q(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPSLLDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x71, 0x73, 0xFE, 0x02]), VPSLLDQ(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x7D, 0x00, 0x73, 0xFC, 0x02]), VPSLLDQ(xmm16, xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x7D, 0x00, 0x73, 0x7A, 0x04, 0x02]), VPSLLDQ(xmm16, oword[r10 + 64], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x6D, 0x73, 0xFF, 0x02]), VPSLLDQ(ymm2, ymm15, 2).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x75, 0x20, 0x73, 0xFD, 0x02]), VPSLLDQ(ymm17, ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x75, 0x20, 0x73, 0x79, 0x02, 0x02]), VPSLLDQ(ymm17, hword[r9 + 64], 2).encode())
        self.assertEqual(bytearray([0x62, 0x91, 0x65, 0x48, 0x73, 0xFA, 0x02]), VPSLLDQ(zmm3, zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x65, 0x48, 0x73, 0x78, 0x01, 0x02]), VPSLLDQ(zmm3, zword[r8 + 64], 2).encode())


class TestVPSRLDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x71, 0x73, 0xDE, 0x02]), VPSRLDQ(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x7D, 0x00, 0x73, 0xDC, 0x02]), VPSRLDQ(xmm16, xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x7D, 0x00, 0x73, 0x5A, 0x04, 0x02]), VPSRLDQ(xmm16, oword[r10 + 64], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x6D, 0x73, 0xDF, 0x02]), VPSRLDQ(ymm2, ymm15, 2).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x75, 0x20, 0x73, 0xDD, 0x02]), VPSRLDQ(ymm17, ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x75, 0x20, 0x73, 0x59, 0x02, 0x02]), VPSRLDQ(ymm17, hword[r9 + 64], 2).encode())
        self.assertEqual(bytearray([0x62, 0x91, 0x65, 0x48, 0x73, 0xDA, 0x02]), VPSRLDQ(zmm3, zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0x65, 0x48, 0x73, 0x58, 0x01, 0x02]), VPSRLDQ(zmm3, zword[r8 + 64], 2).encode())


class TestVPALIGNR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x23, 0x5D, 0x8A, 0x0F, 0xF3, 0x02]), VPALIGNR(xmm30(k2.z), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0x43, 0x5D, 0x8A, 0x0F, 0x72, 0xF8, 0x02]), VPALIGNR(xmm30(k2.z), xmm4, oword[r10 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0xA3, 0x55, 0xAD, 0x0F, 0xDC, 0x02]), VPALIGNR(ymm19(k5.z), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0x55, 0xAD, 0x0F, 0x59, 0xFC, 0x02]), VPALIGNR(ymm19(k5.z), ymm5, hword[r9 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x2D, 0xC6, 0x0F, 0xC9, 0x02]), VPALIGNR(zmm9(k6.z), zmm26, zmm9, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x2D, 0xC6, 0x0F, 0x48, 0xFE, 0x02]), VPALIGNR(zmm9(k6.z), zmm26, zword[r8 - 128], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xE3, 0x09, 0x0F, 0xCB, 0x02]), VPALIGNR(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x09, 0x0F, 0x4C, 0xC2, 0xB3, 0x02]), VPALIGNR(xmm1, xmm14, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0xC4, 0xE3, 0x05, 0x0F, 0xD4, 0x02]), VPALIGNR(ymm2, ymm15, ymm4, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x05, 0x0F, 0x54, 0xD9, 0xBE, 0x02]), VPALIGNR(ymm2, ymm15, hword[r9 + rbx*8 - 66], 2).encode())


class TestVALIGND(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0x5D, 0x8A, 0x03, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VALIGND(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0x23, 0x5D, 0x8A, 0x03, 0xF3, 0x02]), VALIGND(xmm30(k2.z), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0x55, 0xAD, 0x03, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VALIGND(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xA3, 0x55, 0xAD, 0x03, 0xDC, 0x02]), VALIGND(ymm19(k5.z), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x2D, 0xC6, 0x03, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VALIGND(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x2D, 0xC6, 0x03, 0xC9, 0x02]), VALIGND(zmm9(k6.z), zmm26, zmm9, 2).encode())


class TestVALIGNQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x43, 0xDD, 0x8A, 0x03, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF, 0x02]), VALIGNQ(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x62, 0x23, 0xDD, 0x8A, 0x03, 0xF3, 0x02]), VALIGNQ(xmm30(k2.z), xmm4, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0xD5, 0xAD, 0x03, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VALIGNQ(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xA3, 0xD5, 0xAD, 0x03, 0xDC, 0x02]), VALIGNQ(ymm19(k5.z), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xAD, 0xC6, 0x03, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VALIGNQ(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xAD, 0xC6, 0x03, 0xC9, 0x02]), VALIGNQ(zmm9(k6.z), zmm26, zmm9, 2).encode())


class TestVPMULTISHIFTQB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x42, 0xDD, 0x8A, 0x83, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPMULTISHIFTQB(xmm30(k2.z), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x22, 0xDD, 0x8A, 0x83, 0xF3]), VPMULTISHIFTQB(xmm30(k2.z), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0xD5, 0xAD, 0x83, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMULTISHIFTQB(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xA2, 0xD5, 0xAD, 0x83, 0xDC]), VPMULTISHIFTQB(ymm19(k5.z), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x83, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPMULTISHIFTQB(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xAD, 0xC6, 0x83, 0xC9]), VPMULTISHIFTQB(zmm9(k6.z), zmm26, zmm9).encode())


class TestVPOPCNTD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x55, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPOPCNTD(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0x7D, 0xCE, 0x55, 0xCA]), VPOPCNTD(zmm9(k6.z), zmm26).encode())


class TestVPOPCNTQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x52, 0xFD, 0xCE, 0x55, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPOPCNTQ(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x12, 0xFD, 0xCE, 0x55, 0xCA]), VPOPCNTQ(zmm9(k6.z), zmm26).encode())


class TestVPCMPESTRI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x61, 0xCE, 0x02]), VPCMPESTRI(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x61, 0x4C, 0xC2, 0xB3, 0x02]), VPCMPESTRI(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestVPCMPESTRM(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x60, 0xCE, 0x02]), VPCMPESTRM(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x60, 0x4C, 0xC2, 0xB3, 0x02]), VPCMPESTRM(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestVPCMPISTRI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x63, 0xCE, 0x02]), VPCMPISTRI(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x63, 0x4C, 0xC2, 0xB3, 0x02]), VPCMPISTRI(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestVPCMPISTRM(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x62, 0xCE, 0x02]), VPCMPISTRM(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x62, 0x4C, 0xC2, 0xB3, 0x02]), VPCMPISTRM(xmm1, oword[r10 + rax*8 - 77], 2).encode())


class TestVCVTSS2SI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7A, 0x2D, 0xEE]), VCVTSS2SI(ebp, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7A, 0x2D, 0x6C, 0xCC, 0x9D]), VCVTSS2SI(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7A, 0x2D, 0x6C, 0x24, 0x40]), VCVTSS2SI(ebp, dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0xFA, 0x2D, 0xCE]), VCVTSS2SI(rcx, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0xFA, 0x2D, 0x4C, 0xCC, 0x9D]), VCVTSS2SI(rcx, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0xFA, 0x2D, 0x4C, 0x24, 0x40]), VCVTSS2SI(rcx, dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x7E, 0x18, 0x2D, 0xEC]), VCVTSS2SI(ebp, xmm4, {rn_sae}).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0xFE, 0x18, 0x2D, 0xCC]), VCVTSS2SI(rcx, xmm4, {rn_sae}).encode())


class TestVCVTSS2USI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x7E, 0x08, 0x79, 0x6C, 0x24, 0x10]), VCVTSS2USI(ebp, dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0xFE, 0x08, 0x79, 0x4C, 0x24, 0x10]), VCVTSS2USI(rcx, dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x7E, 0x18, 0x79, 0xEC]), VCVTSS2USI(ebp, xmm4, {rn_sae}).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0xFE, 0x18, 0x79, 0xCC]), VCVTSS2USI(rcx, xmm4, {rn_sae}).encode())


class TestVCVTTSS2SI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7A, 0x2C, 0xEE]), VCVTTSS2SI(ebp, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7A, 0x2C, 0x6C, 0xCC, 0x9D]), VCVTTSS2SI(ebp, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7A, 0x2C, 0x6C, 0x24, 0x40]), VCVTTSS2SI(ebp, dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0xFA, 0x2C, 0xCE]), VCVTTSS2SI(rcx, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0xFA, 0x2C, 0x4C, 0xCC, 0x9D]), VCVTTSS2SI(rcx, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0xFA, 0x2C, 0x4C, 0x24, 0x40]), VCVTTSS2SI(rcx, dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x7E, 0x18, 0x2C, 0xEC]), VCVTTSS2SI(ebp, xmm4, {sae}).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0xFE, 0x18, 0x2C, 0xCC]), VCVTTSS2SI(rcx, xmm4, {sae}).encode())


class TestVCVTTSS2USI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x7E, 0x08, 0x78, 0x6C, 0x24, 0x10]), VCVTTSS2USI(ebp, dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0xFE, 0x08, 0x78, 0x4C, 0x24, 0x10]), VCVTTSS2USI(rcx, dword[r12 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x7E, 0x18, 0x78, 0xEC]), VCVTTSS2USI(ebp, xmm4, {sae}).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0xFE, 0x18, 0x78, 0xCC]), VCVTTSS2USI(rcx, xmm4, {sae}).encode())


class TestVCVTSI2SS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x8A, 0x2A, 0xC8]), VCVTSI2SS(xmm1, xmm14, eax).encode())
        self.assertEqual(bytearray([0xC4, 0xE1, 0x8A, 0x2A, 0xC8]), VCVTSI2SS(xmm1, xmm14, rax).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0A, 0x2A, 0x4C, 0xCC, 0x9D]), VCVTSI2SS(xmm1, xmm14, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x5E, 0x08, 0x2A, 0x44, 0x24, 0xE0]), VCVTSI2SS(xmm16, xmm4, dword[r12 - 128]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x8A, 0x2A, 0x4C, 0xD3, 0xA8]), VCVTSI2SS(xmm1, xmm14, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xDE, 0x08, 0x2A, 0x43, 0xF0]), VCVTSI2SS(xmm16, xmm4, qword[r11 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x5E, 0x18, 0x2A, 0xC0]), VCVTSI2SS(xmm16, xmm4, eax, {rn_sae}).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0xDE, 0x18, 0x2A, 0xC0]), VCVTSI2SS(xmm16, xmm4, rax, {rn_sae}).encode())


class TestVCVTUSI2SS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xC1, 0x5E, 0x08, 0x7B, 0x44, 0x24, 0xE0]), VCVTUSI2SS(xmm16, xmm4, dword[r12 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xDE, 0x08, 0x7B, 0x43, 0xF0]), VCVTUSI2SS(xmm16, xmm4, qword[r11 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x5E, 0x18, 0x7B, 0xC0]), VCVTUSI2SS(xmm16, xmm4, eax, {rn_sae}).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0xDE, 0x18, 0x7B, 0xC0]), VCVTUSI2SS(xmm16, xmm4, rax, {rn_sae}).encode())


class TestVCVTSD2SI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7B, 0x2D, 0xEE]), VCVTSD2SI(ebp, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7B, 0x2D, 0x6C, 0xD3, 0xA8]), VCVTSD2SI(ebp, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7B, 0x2D, 0x6B, 0x40]), VCVTSD2SI(ebp, qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0xFB, 0x2D, 0xCE]), VCVTSD2SI(rcx, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0xFB, 0x2D, 0x4C, 0xD3, 0xA8]), VCVTSD2SI(rcx, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0xFB, 0x2D, 0x4B, 0x40]), VCVTSD2SI(rcx, qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x7F, 0x18, 0x2D, 0xEC]), VCVTSD2SI(ebp, xmm4, {rn_sae}).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0xFF, 0x18, 0x2D, 0xCC]), VCVTSD2SI(rcx, xmm4, {rn_sae}).encode())


class TestVCVTSD2USI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x7F, 0x08, 0x79, 0x6B, 0x08]), VCVTSD2USI(ebp, qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0xFF, 0x08, 0x79, 0x4B, 0x08]), VCVTSD2USI(rcx, qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x7F, 0x18, 0x79, 0xEC]), VCVTSD2USI(ebp, xmm4, {rn_sae}).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0xFF, 0x18, 0x79, 0xCC]), VCVTSD2USI(rcx, xmm4, {rn_sae}).encode())


class TestVCVTTSD2SI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7B, 0x2C, 0xEE]), VCVTTSD2SI(ebp, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7B, 0x2C, 0x6C, 0xD3, 0xA8]), VCVTTSD2SI(ebp, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7B, 0x2C, 0x6B, 0x40]), VCVTTSD2SI(ebp, qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0xFB, 0x2C, 0xCE]), VCVTTSD2SI(rcx, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0xFB, 0x2C, 0x4C, 0xD3, 0xA8]), VCVTTSD2SI(rcx, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0xFB, 0x2C, 0x4B, 0x40]), VCVTTSD2SI(rcx, qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x7F, 0x18, 0x2C, 0xEC]), VCVTTSD2SI(ebp, xmm4, {sae}).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0xFF, 0x18, 0x2C, 0xCC]), VCVTTSD2SI(rcx, xmm4, {sae}).encode())


class TestVCVTTSD2USI(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD1, 0x7F, 0x08, 0x78, 0x6B, 0x08]), VCVTTSD2USI(ebp, qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xD1, 0xFF, 0x08, 0x78, 0x4B, 0x08]), VCVTTSD2USI(rcx, qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0x7F, 0x18, 0x78, 0xEC]), VCVTTSD2USI(ebp, xmm4, {sae}).encode())
        self.assertEqual(bytearray([0x62, 0xF1, 0xFF, 0x18, 0x78, 0xCC]), VCVTTSD2USI(rcx, xmm4, {sae}).encode())


class TestVCVTSI2SD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0x8B, 0x2A, 0xC8]), VCVTSI2SD(xmm1, xmm14, eax).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x5F, 0x08, 0x2A, 0xC0]), VCVTSI2SD(xmm16, xmm4, eax).encode())
        self.assertEqual(bytearray([0xC4, 0xE1, 0x8B, 0x2A, 0xC8]), VCVTSI2SD(xmm1, xmm14, rax).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0B, 0x2A, 0x4C, 0xCC, 0x9D]), VCVTSI2SD(xmm1, xmm14, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x5F, 0x08, 0x2A, 0x44, 0x24, 0xE0]), VCVTSI2SD(xmm16, xmm4, dword[r12 - 128]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x8B, 0x2A, 0x4C, 0xD3, 0xA8]), VCVTSI2SD(xmm1, xmm14, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xDF, 0x08, 0x2A, 0x43, 0xF0]), VCVTSI2SD(xmm16, xmm4, qword[r11 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0xDF, 0x18, 0x2A, 0xC0]), VCVTSI2SD(xmm16, xmm4, rax, {rn_sae}).encode())


class TestVCVTUSI2SD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xE1, 0x5F, 0x08, 0x7B, 0xC0]), VCVTUSI2SD(xmm16, xmm4, eax).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x5F, 0x08, 0x7B, 0x44, 0x24, 0xE0]), VCVTUSI2SD(xmm16, xmm4, dword[r12 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xDF, 0x08, 0x7B, 0x43, 0xF0]), VCVTUSI2SD(xmm16, xmm4, qword[r11 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0xDF, 0x18, 0x7B, 0xC0]), VCVTUSI2SD(xmm16, xmm4, rax, {rn_sae}).encode())


class TestVCVTPS2DQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x7D, 0x8A, 0x5B, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTPS2DQ(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7D, 0xAD, 0x5B, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTPS2DQ(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7D, 0xCE, 0x5B, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTPS2DQ(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0x7D, 0x8A, 0x5B, 0xF4]), VCVTPS2DQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7D, 0xAD, 0x5B, 0xDD]), VCVTPS2DQ(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x5B, 0xCE]), VCVTPS2DQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x5B, 0x4C, 0xC2, 0xB3]), VCVTPS2DQ(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7D, 0x5B, 0xD7]), VCVTPS2DQ(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7D, 0x5B, 0x54, 0xD9, 0xBE]), VCVTPS2DQ(ymm2, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0x7D, 0x9E, 0x5B, 0xCA]), VCVTPS2DQ(zmm9(k6.z), zmm26, {rn_sae}).encode())


class TestVCVTPS2UDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x7C, 0x8A, 0x79, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTPS2UDQ(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7C, 0xAD, 0x79, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTPS2UDQ(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7C, 0xCE, 0x79, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTPS2UDQ(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0x7C, 0x8A, 0x79, 0xF4]), VCVTPS2UDQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7C, 0xAD, 0x79, 0xDD]), VCVTPS2UDQ(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0x7C, 0x9E, 0x79, 0xCA]), VCVTPS2UDQ(zmm9(k6.z), zmm26, {rn_sae}).encode())


class TestVCVTTPS2DQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x7E, 0x8A, 0x5B, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTTPS2DQ(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7E, 0xAD, 0x5B, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTTPS2DQ(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7E, 0xCE, 0x5B, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTTPS2DQ(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0x7E, 0x8A, 0x5B, 0xF4]), VCVTTPS2DQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7E, 0xAD, 0x5B, 0xDD]), VCVTTPS2DQ(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7A, 0x5B, 0xCE]), VCVTTPS2DQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7A, 0x5B, 0x4C, 0xC2, 0xB3]), VCVTTPS2DQ(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7E, 0x5B, 0xD7]), VCVTTPS2DQ(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7E, 0x5B, 0x54, 0xD9, 0xBE]), VCVTTPS2DQ(ymm2, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0x7E, 0x9E, 0x5B, 0xCA]), VCVTTPS2DQ(zmm9(k6.z), zmm26, {sae}).encode())


class TestVCVTTPS2UDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x7C, 0x8A, 0x78, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTTPS2UDQ(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7C, 0xAD, 0x78, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTTPS2UDQ(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7C, 0xCE, 0x78, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTTPS2UDQ(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0x7C, 0x8A, 0x78, 0xF4]), VCVTTPS2UDQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7C, 0xAD, 0x78, 0xDD]), VCVTTPS2UDQ(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0x7C, 0x9E, 0x78, 0xCA]), VCVTTPS2UDQ(zmm9(k6.z), zmm26, {sae}).encode())


class TestVCVTDQ2PS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x7C, 0x8A, 0x5B, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTDQ2PS(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7C, 0xAD, 0x5B, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTDQ2PS(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7C, 0xCE, 0x5B, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTDQ2PS(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0x7C, 0x8A, 0x5B, 0xF4]), VCVTDQ2PS(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7C, 0xAD, 0x5B, 0xDD]), VCVTDQ2PS(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x5B, 0xCE]), VCVTDQ2PS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x5B, 0x4C, 0xC2, 0xB3]), VCVTDQ2PS(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7C, 0x5B, 0xD7]), VCVTDQ2PS(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7C, 0x5B, 0x54, 0xD9, 0xBE]), VCVTDQ2PS(ymm2, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0x7C, 0x9E, 0x5B, 0xCA]), VCVTDQ2PS(zmm9(k6.z), zmm26, {rn_sae}).encode())


class TestVCVTUDQ2PS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x7F, 0x8A, 0x7A, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTUDQ2PS(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7F, 0xAD, 0x7A, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTUDQ2PS(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7F, 0xCE, 0x7A, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTUDQ2PS(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0x7F, 0x8A, 0x7A, 0xF4]), VCVTUDQ2PS(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7F, 0xAD, 0x7A, 0xDD]), VCVTUDQ2PS(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0x7F, 0x9E, 0x7A, 0xCA]), VCVTUDQ2PS(zmm9(k6.z), zmm26, {rn_sae}).encode())


class TestVCVTPS2QQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x7D, 0x8A, 0x7B, 0x74, 0xD3, 0xF5]), VCVTPS2QQ(xmm30(k2.z), qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7D, 0xAD, 0x7B, 0x9C, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTPS2QQ(ymm19(k5.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7D, 0xCE, 0x7B, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTPS2QQ(zmm9(k6.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0x7D, 0x8A, 0x7B, 0xF4]), VCVTPS2QQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7D, 0xAD, 0x7B, 0xDC]), VCVTPS2QQ(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x71, 0x7D, 0x9E, 0x7B, 0xCD]), VCVTPS2QQ(zmm9(k6.z), ymm5, {rn_sae}).encode())


class TestVCVTPS2UQQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x7D, 0x8A, 0x79, 0x74, 0xD3, 0xF5]), VCVTPS2UQQ(xmm30(k2.z), qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7D, 0xAD, 0x79, 0x9C, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTPS2UQQ(ymm19(k5.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7D, 0xCE, 0x79, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTPS2UQQ(zmm9(k6.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0x7D, 0x8A, 0x79, 0xF4]), VCVTPS2UQQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7D, 0xAD, 0x79, 0xDC]), VCVTPS2UQQ(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x71, 0x7D, 0x9E, 0x79, 0xCD]), VCVTPS2UQQ(zmm9(k6.z), ymm5, {rn_sae}).encode())


class TestVCVTTPS2QQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x7D, 0x8A, 0x7A, 0x74, 0xD3, 0xF5]), VCVTTPS2QQ(xmm30(k2.z), qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7D, 0xAD, 0x7A, 0x9C, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTTPS2QQ(ymm19(k5.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7D, 0xCE, 0x7A, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTTPS2QQ(zmm9(k6.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0x7D, 0x8A, 0x7A, 0xF4]), VCVTTPS2QQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7D, 0xAD, 0x7A, 0xDC]), VCVTTPS2QQ(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x71, 0x7D, 0x9E, 0x7A, 0xCD]), VCVTTPS2QQ(zmm9(k6.z), ymm5, {sae}).encode())


class TestVCVTTPS2UQQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x7D, 0x8A, 0x78, 0x74, 0xD3, 0xF5]), VCVTTPS2UQQ(xmm30(k2.z), qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7D, 0xAD, 0x78, 0x9C, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTTPS2UQQ(ymm19(k5.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7D, 0xCE, 0x78, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTTPS2UQQ(zmm9(k6.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0x7D, 0x8A, 0x78, 0xF4]), VCVTTPS2UQQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7D, 0xAD, 0x78, 0xDC]), VCVTTPS2UQQ(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x71, 0x7D, 0x9E, 0x78, 0xCD]), VCVTTPS2UQQ(zmm9(k6.z), ymm5, {sae}).encode())


class TestVCVTQQ2PS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xFC, 0x8A, 0x5B, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTQQ2PS(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xFC, 0xAA, 0x5B, 0xB4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTQQ2PS(xmm30(k2.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFC, 0xCD, 0x5B, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTQQ2PS(ymm19(k5.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFC, 0x8A, 0x5B, 0xF4]), VCVTQQ2PS(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFC, 0xAA, 0x5B, 0xF5]), VCVTQQ2PS(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x81, 0xFC, 0x9D, 0x5B, 0xDA]), VCVTQQ2PS(ymm19(k5.z), zmm26, {rn_sae}).encode())


class TestVCVTUQQ2PS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xFF, 0x8A, 0x7A, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTUQQ2PS(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xFF, 0xAA, 0x7A, 0xB4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTUQQ2PS(xmm30(k2.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFF, 0xCD, 0x7A, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTUQQ2PS(ymm19(k5.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFF, 0x8A, 0x7A, 0xF4]), VCVTUQQ2PS(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFF, 0xAA, 0x7A, 0xF5]), VCVTUQQ2PS(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x81, 0xFF, 0x9D, 0x7A, 0xDA]), VCVTUQQ2PS(ymm19(k5.z), zmm26, {rn_sae}).encode())


class TestVCVTPD2DQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xFF, 0x8A, 0xE6, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTPD2DQ(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xFF, 0xAA, 0xE6, 0xB4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTPD2DQ(xmm30(k2.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFF, 0xCD, 0xE6, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTPD2DQ(ymm19(k5.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFF, 0x8A, 0xE6, 0xF4]), VCVTPD2DQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFF, 0xAA, 0xE6, 0xF5]), VCVTPD2DQ(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7B, 0xE6, 0xCE]), VCVTPD2DQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7F, 0xE6, 0xCF]), VCVTPD2DQ(xmm1, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7B, 0xE6, 0x4C, 0xC2, 0xB3]), VCVTPD2DQ(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7F, 0xE6, 0x4C, 0xD9, 0xBE]), VCVTPD2DQ(xmm1, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x81, 0xFF, 0x9D, 0xE6, 0xDA]), VCVTPD2DQ(ymm19(k5.z), zmm26, {rn_sae}).encode())


class TestVCVTPD2UDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xFC, 0x8A, 0x79, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTPD2UDQ(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xFC, 0xAA, 0x79, 0xB4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTPD2UDQ(xmm30(k2.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFC, 0xCD, 0x79, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTPD2UDQ(ymm19(k5.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFC, 0x8A, 0x79, 0xF4]), VCVTPD2UDQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFC, 0xAA, 0x79, 0xF5]), VCVTPD2UDQ(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x81, 0xFC, 0x9D, 0x79, 0xDA]), VCVTPD2UDQ(ymm19(k5.z), zmm26, {rn_sae}).encode())


class TestVCVTTPD2DQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xFD, 0x8A, 0xE6, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTTPD2DQ(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xFD, 0xAA, 0xE6, 0xB4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTTPD2DQ(xmm30(k2.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFD, 0xCD, 0xE6, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTTPD2DQ(ymm19(k5.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFD, 0x8A, 0xE6, 0xF4]), VCVTTPD2DQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFD, 0xAA, 0xE6, 0xF5]), VCVTTPD2DQ(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0xE6, 0xCE]), VCVTTPD2DQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7D, 0xE6, 0xCF]), VCVTTPD2DQ(xmm1, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0xE6, 0x4C, 0xC2, 0xB3]), VCVTTPD2DQ(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7D, 0xE6, 0x4C, 0xD9, 0xBE]), VCVTTPD2DQ(xmm1, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x81, 0xFD, 0x9D, 0xE6, 0xDA]), VCVTTPD2DQ(ymm19(k5.z), zmm26, {sae}).encode())


class TestVCVTTPD2UDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xFC, 0x8A, 0x78, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTTPD2UDQ(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xFC, 0xAA, 0x78, 0xB4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTTPD2UDQ(xmm30(k2.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFC, 0xCD, 0x78, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTTPD2UDQ(ymm19(k5.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFC, 0x8A, 0x78, 0xF4]), VCVTTPD2UDQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFC, 0xAA, 0x78, 0xF5]), VCVTTPD2UDQ(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x81, 0xFC, 0x9D, 0x78, 0xDA]), VCVTTPD2UDQ(ymm19(k5.z), zmm26, {sae}).encode())


class TestVCVTDQ2PD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x7E, 0x8A, 0xE6, 0x74, 0xD3, 0xF5]), VCVTDQ2PD(xmm30(k2.z), qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7E, 0xAD, 0xE6, 0x9C, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTDQ2PD(ymm19(k5.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7E, 0xCE, 0xE6, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTDQ2PD(zmm9(k6.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0x7E, 0x8A, 0xE6, 0xF4]), VCVTDQ2PD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7E, 0xAD, 0xE6, 0xDC]), VCVTDQ2PD(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x71, 0x7E, 0xCE, 0xE6, 0xCD]), VCVTDQ2PD(zmm9(k6.z), ymm5).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7A, 0xE6, 0xCE]), VCVTDQ2PD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7A, 0xE6, 0x4C, 0xD3, 0xA8]), VCVTDQ2PD(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7E, 0xE6, 0xD6]), VCVTDQ2PD(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7E, 0xE6, 0x54, 0xC2, 0xB3]), VCVTDQ2PD(ymm2, oword[r10 + rax*8 - 77]).encode())


class TestVCVTUDQ2PD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x7E, 0x8A, 0x7A, 0x74, 0xD3, 0xF5]), VCVTUDQ2PD(xmm30(k2.z), qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7E, 0xAD, 0x7A, 0x9C, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTUDQ2PD(ymm19(k5.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7E, 0xCE, 0x7A, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTUDQ2PD(zmm9(k6.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0x7E, 0x8A, 0x7A, 0xF4]), VCVTUDQ2PD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7E, 0xAD, 0x7A, 0xDC]), VCVTUDQ2PD(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x71, 0x7E, 0xCE, 0x7A, 0xCD]), VCVTUDQ2PD(zmm9(k6.z), ymm5).encode())


class TestVCVTPD2QQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xFD, 0x8A, 0x7B, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTPD2QQ(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFD, 0xAD, 0x7B, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTPD2QQ(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xFD, 0xCE, 0x7B, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTPD2QQ(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFD, 0x8A, 0x7B, 0xF4]), VCVTPD2QQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0xFD, 0xAD, 0x7B, 0xDD]), VCVTPD2QQ(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0xFD, 0x9E, 0x7B, 0xCA]), VCVTPD2QQ(zmm9(k6.z), zmm26, {rn_sae}).encode())


class TestVCVTPD2UQQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xFD, 0x8A, 0x79, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTPD2UQQ(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFD, 0xAD, 0x79, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTPD2UQQ(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xFD, 0xCE, 0x79, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTPD2UQQ(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFD, 0x8A, 0x79, 0xF4]), VCVTPD2UQQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0xFD, 0xAD, 0x79, 0xDD]), VCVTPD2UQQ(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0xFD, 0x9E, 0x79, 0xCA]), VCVTPD2UQQ(zmm9(k6.z), zmm26, {rn_sae}).encode())


class TestVCVTTPD2QQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xFD, 0x8A, 0x7A, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTTPD2QQ(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFD, 0xAD, 0x7A, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTTPD2QQ(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xFD, 0xCE, 0x7A, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTTPD2QQ(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFD, 0x8A, 0x7A, 0xF4]), VCVTTPD2QQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0xFD, 0xAD, 0x7A, 0xDD]), VCVTTPD2QQ(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0xFD, 0x9E, 0x7A, 0xCA]), VCVTTPD2QQ(zmm9(k6.z), zmm26, {sae}).encode())


class TestVCVTTPD2UQQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xFD, 0x8A, 0x78, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTTPD2UQQ(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFD, 0xAD, 0x78, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTTPD2UQQ(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xFD, 0xCE, 0x78, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTTPD2UQQ(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFD, 0x8A, 0x78, 0xF4]), VCVTTPD2UQQ(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0xFD, 0xAD, 0x78, 0xDD]), VCVTTPD2UQQ(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0xFD, 0x9E, 0x78, 0xCA]), VCVTTPD2UQQ(zmm9(k6.z), zmm26, {sae}).encode())


class TestVCVTQQ2PD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xFE, 0x8A, 0xE6, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTQQ2PD(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFE, 0xAD, 0xE6, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTQQ2PD(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xFE, 0xCE, 0xE6, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTQQ2PD(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFE, 0x8A, 0xE6, 0xF4]), VCVTQQ2PD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0xFE, 0xAD, 0xE6, 0xDD]), VCVTQQ2PD(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0xFE, 0x9E, 0xE6, 0xCA]), VCVTQQ2PD(zmm9(k6.z), zmm26, {rn_sae}).encode())


class TestVCVTUQQ2PD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xFE, 0x8A, 0x7A, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTUQQ2PD(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFE, 0xAD, 0x7A, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTUQQ2PD(ymm19(k5.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0xFE, 0xCE, 0x7A, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTUQQ2PD(zmm9(k6.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFE, 0x8A, 0x7A, 0xF4]), VCVTUQQ2PD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0xFE, 0xAD, 0x7A, 0xDD]), VCVTUQQ2PD(ymm19(k5.z), ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x11, 0xFE, 0x9E, 0x7A, 0xCA]), VCVTUQQ2PD(zmm9(k6.z), zmm26, {rn_sae}).encode())


class TestVCVTSD2SS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xDF, 0x8A, 0x5A, 0x73, 0xF0]), VCVTSD2SS(xmm30(k2.z), xmm4, qword[r11 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x8B, 0x5A, 0xCB]), VCVTSD2SS(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0B, 0x5A, 0x4C, 0xD3, 0xA8]), VCVTSD2SS(xmm1, xmm14, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0xDF, 0x9A, 0x5A, 0xF3]), VCVTSD2SS(xmm30(k2.z), xmm4, xmm19, {rn_sae}).encode())


class TestVCVTSS2SD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x5E, 0x8A, 0x5A, 0x74, 0x24, 0xE0]), VCVTSS2SD(xmm30(k2.z), xmm4, dword[r12 - 128]).encode())
        self.assertEqual(bytearray([0xC5, 0x8A, 0x5A, 0xCB]), VCVTSS2SD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x0A, 0x5A, 0x4C, 0xCC, 0x9D]), VCVTSS2SD(xmm1, xmm14, dword[r12 + rcx*8 - 99]).encode())
        self.assertEqual(bytearray([0x62, 0x21, 0x5E, 0x9A, 0x5A, 0xF3]), VCVTSS2SD(xmm30(k2.z), xmm4, xmm19, {sae}).encode())


class TestVCVTPD2PS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0xFD, 0x8A, 0x5A, 0xB4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTPD2PS(xmm30(k2.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x41, 0xFD, 0xAA, 0x5A, 0xB4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTPD2PS(xmm30(k2.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0xFD, 0xCD, 0x5A, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTPD2PS(ymm19(k5.z), zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFD, 0x8A, 0x5A, 0xF4]), VCVTPD2PS(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0xFD, 0xAA, 0x5A, 0xF5]), VCVTPD2PS(xmm30(k2.z), ymm5).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x5A, 0xCE]), VCVTPD2PS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7D, 0x5A, 0xCF]), VCVTPD2PS(xmm1, ymm15).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x79, 0x5A, 0x4C, 0xC2, 0xB3]), VCVTPD2PS(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7D, 0x5A, 0x4C, 0xD9, 0xBE]), VCVTPD2PS(xmm1, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x81, 0xFD, 0x9D, 0x5A, 0xDA]), VCVTPD2PS(ymm19(k5.z), zmm26, {rn_sae}).encode())


class TestVCVTPS2PD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x41, 0x7C, 0x8A, 0x5A, 0x74, 0xD3, 0xF5]), VCVTPS2PD(xmm30(k2.z), qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0x62, 0xC1, 0x7C, 0xAD, 0x5A, 0x9C, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VCVTPS2PD(ymm19(k5.z), oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x51, 0x7C, 0xCE, 0x5A, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VCVTPS2PD(zmm9(k6.z), hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0x61, 0x7C, 0x8A, 0x5A, 0xF4]), VCVTPS2PD(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE1, 0x7C, 0xAD, 0x5A, 0xDC]), VCVTPS2PD(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x5A, 0xCE]), VCVTPS2PD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0x5A, 0x4C, 0xD3, 0xA8]), VCVTPS2PD(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7C, 0x5A, 0xD6]), VCVTPS2PD(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC1, 0x7C, 0x5A, 0x54, 0xC2, 0xB3]), VCVTPS2PD(ymm2, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x71, 0x7C, 0x9E, 0x5A, 0xCD]), VCVTPS2PD(zmm9(k6.z), ymm5, {sae}).encode())


class TestVCVTPS2PH(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x93, 0x7D, 0x8A, 0x1D, 0xE6, 0x02]), VCVTPS2PH(xmm30(k2.z), xmm4, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x79, 0x1D, 0x63, 0xC0, 0x02]), VCVTPS2PH(qword[r11 - 64], xmm4, 2).encode())
        self.assertEqual(bytearray([0x62, 0x93, 0x7D, 0xAA, 0x1D, 0xEE, 0x02]), VCVTPS2PH(xmm30(k2.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x7D, 0x1D, 0x6A, 0xC0, 0x02]), VCVTPS2PH(oword[r10 - 64], ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0x43, 0x7D, 0x48, 0x1D, 0x51, 0xFE, 0x02]), VCVTPS2PH(hword[r9 - 64], zmm26, 2).encode())
        self.assertEqual(bytearray([0xC4, 0x63, 0x79, 0x1D, 0xF1, 0x02]), VCVTPS2PH(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0x63, 0x7D, 0x1D, 0xF9, 0x02]), VCVTPS2PH(xmm1, ymm15, 2).encode())
        self.assertEqual(bytearray([0xC4, 0x43, 0x79, 0x1D, 0x74, 0xD3, 0xA8, 0x02]), VCVTPS2PH(qword[r11 + rdx*8 - 88], xmm14, 2).encode())
        self.assertEqual(bytearray([0xC4, 0x43, 0x7D, 0x1D, 0x7C, 0xC2, 0xB3, 0x02]), VCVTPS2PH(oword[r10 + rax*8 - 77], ymm15, 2).encode())
        self.assertEqual(bytearray([0x62, 0x23, 0x7D, 0x9D, 0x1D, 0xD3, 0x02]), VCVTPS2PH(ymm19(k5.z), zmm26, {sae}, 2).encode())


class TestVCVTPH2PS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x13, 0xF4]), VCVTPH2PS(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x13, 0xDC]), VCVTPH2PS(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x13, 0x73, 0x08]), VCVTPH2PS(xmm30(k2.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x13, 0x5A, 0x04]), VCVTPH2PS(ymm19(k5.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x13, 0x49, 0x02]), VCVTPH2PS(zmm9(k6.z), hword[r9 + 64]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x13, 0xCE]), VCVTPH2PS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x79, 0x13, 0x4C, 0xD3, 0xA8]), VCVTPH2PS(xmm1, qword[r11 + rdx*8 - 88]).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x13, 0xD6]), VCVTPH2PS(ymm2, xmm14).encode())
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x13, 0x54, 0xC2, 0xB3]), VCVTPH2PS(ymm2, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0x7D, 0x9E, 0x13, 0xCD]), VCVTPH2PS(zmm9(k6.z), ymm5, {sae}).encode())


class TestVBROADCASTF128(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x1A, 0x54, 0xC2, 0xB3]), VBROADCASTF128(ymm2, oword[r10 + rax*8 - 77]).encode())


class TestVBROADCASTI128(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC2, 0x7D, 0x5A, 0x54, 0xC2, 0xB3]), VBROADCASTI128(ymm2, oword[r10 + rax*8 - 77]).encode())


class TestVBROADCASTF32X2(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x19, 0xDC]), VBROADCASTF32X2(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0x7D, 0xCE, 0x19, 0xCC]), VBROADCASTF32X2(zmm9(k6.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x19, 0x5B, 0x08]), VBROADCASTF32X2(ymm19(k5.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x19, 0x4B, 0x08]), VBROADCASTF32X2(zmm9(k6.z), qword[r11 + 64]).encode())


class TestVBROADCASTI32X2(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x62, 0x7D, 0x8A, 0x59, 0xF4]), VBROADCASTI32X2(xmm30(k2.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7D, 0xAD, 0x59, 0xDC]), VBROADCASTI32X2(ymm19(k5.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x72, 0x7D, 0xCE, 0x59, 0xCC]), VBROADCASTI32X2(zmm9(k6.z), xmm4).encode())
        self.assertEqual(bytearray([0x62, 0x42, 0x7D, 0x8A, 0x59, 0x73, 0x08]), VBROADCASTI32X2(xmm30(k2.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x59, 0x5B, 0x08]), VBROADCASTI32X2(ymm19(k5.z), qword[r11 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x59, 0x4B, 0x08]), VBROADCASTI32X2(zmm9(k6.z), qword[r11 + 64]).encode())


class TestVBROADCASTF32X4(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x1A, 0x5A, 0x04]), VBROADCASTF32X4(ymm19(k5.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x1A, 0x4A, 0x04]), VBROADCASTF32X4(zmm9(k6.z), oword[r10 + 64]).encode())


class TestVBROADCASTI32X4(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xC2, 0x7D, 0xAD, 0x5A, 0x5A, 0x04]), VBROADCASTI32X4(ymm19(k5.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x5A, 0x4A, 0x04]), VBROADCASTI32X4(zmm9(k6.z), oword[r10 + 64]).encode())


class TestVBROADCASTF32X8(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x1B, 0x49, 0x02]), VBROADCASTF32X8(zmm9(k6.z), hword[r9 + 64]).encode())


class TestVBROADCASTI32X8(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x52, 0x7D, 0xCE, 0x5B, 0x49, 0x02]), VBROADCASTI32X8(zmm9(k6.z), hword[r9 + 64]).encode())


class TestVBROADCASTF64X2(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xC2, 0xFD, 0xAD, 0x1A, 0x5A, 0x04]), VBROADCASTF64X2(ymm19(k5.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xFD, 0xCE, 0x1A, 0x4A, 0x04]), VBROADCASTF64X2(zmm9(k6.z), oword[r10 + 64]).encode())


class TestVBROADCASTI64X2(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xC2, 0xFD, 0xAD, 0x5A, 0x5A, 0x04]), VBROADCASTI64X2(ymm19(k5.z), oword[r10 + 64]).encode())
        self.assertEqual(bytearray([0x62, 0x52, 0xFD, 0xCE, 0x5A, 0x4A, 0x04]), VBROADCASTI64X2(zmm9(k6.z), oword[r10 + 64]).encode())


class TestVBROADCASTF64X4(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x52, 0xFD, 0xCE, 0x1B, 0x49, 0x02]), VBROADCASTF64X4(zmm9(k6.z), hword[r9 + 64]).encode())


class TestVBROADCASTI64X4(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x52, 0xFD, 0xCE, 0x5B, 0x49, 0x02]), VBROADCASTI64X4(zmm9(k6.z), hword[r9 + 64]).encode())


class TestVEXTRACTF128(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0x63, 0x7D, 0x19, 0xF9, 0x02]), VEXTRACTF128(xmm1, ymm15, 2).encode())
        self.assertEqual(bytearray([0xC4, 0x43, 0x7D, 0x19, 0x7C, 0xC2, 0xB3, 0x02]), VEXTRACTF128(oword[r10 + rax*8 - 77], ymm15, 2).encode())


class TestVEXTRACTI128(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0x63, 0x7D, 0x39, 0xF9, 0x02]), VEXTRACTI128(xmm1, ymm15, 2).encode())
        self.assertEqual(bytearray([0xC4, 0x43, 0x7D, 0x39, 0x7C, 0xC2, 0xB3, 0x02]), VEXTRACTI128(oword[r10 + rax*8 - 77], ymm15, 2).encode())


class TestVEXTRACTF32X4(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x93, 0x7D, 0xAA, 0x19, 0xEE, 0x02]), VEXTRACTF32X4(xmm30(k2.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0x7D, 0x28, 0x19, 0x6A, 0xFC, 0x02]), VEXTRACTF32X4(oword[r10 - 64], ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0x03, 0x7D, 0xCA, 0x19, 0xD6, 0x02]), VEXTRACTF32X4(xmm30(k2.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x43, 0x7D, 0x48, 0x19, 0x52, 0xFC, 0x02]), VEXTRACTF32X4(oword[r10 - 64], zmm26, 2).encode())


class TestVEXTRACTI32X4(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x93, 0x7D, 0xAA, 0x39, 0xEE, 0x02]), VEXTRACTI32X4(xmm30(k2.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0x7D, 0x28, 0x39, 0x6A, 0xFC, 0x02]), VEXTRACTI32X4(oword[r10 - 64], ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0x03, 0x7D, 0xCA, 0x39, 0xD6, 0x02]), VEXTRACTI32X4(xmm30(k2.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x43, 0x7D, 0x48, 0x39, 0x52, 0xFC, 0x02]), VEXTRACTI32X4(oword[r10 - 64], zmm26, 2).encode())


class TestVEXTRACTF32X8(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x23, 0x7D, 0xCD, 0x1B, 0xD3, 0x02]), VEXTRACTF32X8(ymm19(k5.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x43, 0x7D, 0x48, 0x1B, 0x51, 0xFE, 0x02]), VEXTRACTF32X8(hword[r9 - 64], zmm26, 2).encode())


class TestVEXTRACTI32X8(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x23, 0x7D, 0xCD, 0x3B, 0xD3, 0x02]), VEXTRACTI32X8(ymm19(k5.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x43, 0x7D, 0x48, 0x3B, 0x51, 0xFE, 0x02]), VEXTRACTI32X8(hword[r9 - 64], zmm26, 2).encode())


class TestVEXTRACTF64X2(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x93, 0xFD, 0xAA, 0x19, 0xEE, 0x02]), VEXTRACTF64X2(xmm30(k2.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0xFD, 0x28, 0x19, 0x6A, 0xFC, 0x02]), VEXTRACTF64X2(oword[r10 - 64], ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0x03, 0xFD, 0xCA, 0x19, 0xD6, 0x02]), VEXTRACTF64X2(xmm30(k2.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x43, 0xFD, 0x48, 0x19, 0x52, 0xFC, 0x02]), VEXTRACTF64X2(oword[r10 - 64], zmm26, 2).encode())


class TestVEXTRACTI64X2(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x93, 0xFD, 0xAA, 0x39, 0xEE, 0x02]), VEXTRACTI64X2(xmm30(k2.z), ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0xD3, 0xFD, 0x28, 0x39, 0x6A, 0xFC, 0x02]), VEXTRACTI64X2(oword[r10 - 64], ymm5, 2).encode())
        self.assertEqual(bytearray([0x62, 0x03, 0xFD, 0xCA, 0x39, 0xD6, 0x02]), VEXTRACTI64X2(xmm30(k2.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x43, 0xFD, 0x48, 0x39, 0x52, 0xFC, 0x02]), VEXTRACTI64X2(oword[r10 - 64], zmm26, 2).encode())


class TestVEXTRACTF64X4(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x23, 0xFD, 0xCD, 0x1B, 0xD3, 0x02]), VEXTRACTF64X4(ymm19(k5.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x43, 0xFD, 0x48, 0x1B, 0x51, 0xFE, 0x02]), VEXTRACTF64X4(hword[r9 - 64], zmm26, 2).encode())


class TestVEXTRACTI64X4(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x23, 0xFD, 0xCD, 0x3B, 0xD3, 0x02]), VEXTRACTI64X4(ymm19(k5.z), zmm26, 2).encode())
        self.assertEqual(bytearray([0x62, 0x43, 0xFD, 0x48, 0x3B, 0x51, 0xFE, 0x02]), VEXTRACTI64X4(hword[r9 - 64], zmm26, 2).encode())


class TestVINSERTF128(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x05, 0x18, 0xD3, 0x02]), VINSERTF128(ymm2, ymm15, xmm3, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x05, 0x18, 0x54, 0xC2, 0xB3, 0x02]), VINSERTF128(ymm2, ymm15, oword[r10 + rax*8 - 77], 2).encode())


class TestVINSERTI128(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x05, 0x38, 0xD3, 0x02]), VINSERTI128(ymm2, ymm15, xmm3, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x05, 0x38, 0x54, 0xC2, 0xB3, 0x02]), VINSERTI128(ymm2, ymm15, oword[r10 + rax*8 - 77], 2).encode())


class TestVINSERTF32X4(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xA3, 0x55, 0xAD, 0x18, 0xDB, 0x02]), VINSERTF32X4(ymm19(k5.z), ymm5, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0x55, 0xAD, 0x18, 0x5A, 0xF8, 0x02]), VINSERTF32X4(ymm19(k5.z), ymm5, oword[r10 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0x33, 0x2D, 0xC6, 0x18, 0xCB, 0x02]), VINSERTF32X4(zmm9(k6.z), zmm26, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x2D, 0xC6, 0x18, 0x4A, 0xF8, 0x02]), VINSERTF32X4(zmm9(k6.z), zmm26, oword[r10 - 128], 2).encode())


class TestVINSERTI32X4(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xA3, 0x55, 0xAD, 0x38, 0xDB, 0x02]), VINSERTI32X4(ymm19(k5.z), ymm5, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0x55, 0xAD, 0x38, 0x5A, 0xF8, 0x02]), VINSERTI32X4(ymm19(k5.z), ymm5, oword[r10 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0x33, 0x2D, 0xC6, 0x38, 0xCB, 0x02]), VINSERTI32X4(zmm9(k6.z), zmm26, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x2D, 0xC6, 0x38, 0x4A, 0xF8, 0x02]), VINSERTI32X4(zmm9(k6.z), zmm26, oword[r10 - 128], 2).encode())


class TestVINSERTF32X8(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x33, 0x2D, 0xC6, 0x1A, 0xCC, 0x02]), VINSERTF32X8(zmm9(k6.z), zmm26, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x2D, 0xC6, 0x1A, 0x49, 0xFC, 0x02]), VINSERTF32X8(zmm9(k6.z), zmm26, hword[r9 - 128], 2).encode())


class TestVINSERTI32X8(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x33, 0x2D, 0xC6, 0x3A, 0xCC, 0x02]), VINSERTI32X8(zmm9(k6.z), zmm26, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x2D, 0xC6, 0x3A, 0x49, 0xFC, 0x02]), VINSERTI32X8(zmm9(k6.z), zmm26, hword[r9 - 128], 2).encode())


class TestVINSERTF64X2(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xA3, 0xD5, 0xAD, 0x18, 0xDB, 0x02]), VINSERTF64X2(ymm19(k5.z), ymm5, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0xD5, 0xAD, 0x18, 0x5A, 0xF8, 0x02]), VINSERTF64X2(ymm19(k5.z), ymm5, oword[r10 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0x33, 0xAD, 0xC6, 0x18, 0xCB, 0x02]), VINSERTF64X2(zmm9(k6.z), zmm26, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xAD, 0xC6, 0x18, 0x4A, 0xF8, 0x02]), VINSERTF64X2(zmm9(k6.z), zmm26, oword[r10 - 128], 2).encode())


class TestVINSERTI64X2(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xA3, 0xD5, 0xAD, 0x38, 0xDB, 0x02]), VINSERTI64X2(ymm19(k5.z), ymm5, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0xC3, 0xD5, 0xAD, 0x38, 0x5A, 0xF8, 0x02]), VINSERTI64X2(ymm19(k5.z), ymm5, oword[r10 - 128], 2).encode())
        self.assertEqual(bytearray([0x62, 0x33, 0xAD, 0xC6, 0x38, 0xCB, 0x02]), VINSERTI64X2(zmm9(k6.z), zmm26, xmm19, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xAD, 0xC6, 0x38, 0x4A, 0xF8, 0x02]), VINSERTI64X2(zmm9(k6.z), zmm26, oword[r10 - 128], 2).encode())


class TestVINSERTF64X4(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x33, 0xAD, 0xC6, 0x1A, 0xCC, 0x02]), VINSERTF64X4(zmm9(k6.z), zmm26, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xAD, 0xC6, 0x1A, 0x49, 0xFC, 0x02]), VINSERTF64X4(zmm9(k6.z), zmm26, hword[r9 - 128], 2).encode())


class TestVINSERTI64X4(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0x33, 0xAD, 0xC6, 0x3A, 0xCC, 0x02]), VINSERTI64X4(zmm9(k6.z), zmm26, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xAD, 0xC6, 0x3A, 0x49, 0xFC, 0x02]), VINSERTI64X4(zmm9(k6.z), zmm26, hword[r9 - 128], 2).encode())


class TestVPERM2F128(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x05, 0x06, 0xD4, 0x02]), VPERM2F128(ymm2, ymm15, ymm4, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x05, 0x06, 0x54, 0xD9, 0xBE, 0x02]), VPERM2F128(ymm2, ymm15, hword[r9 + rbx*8 - 66], 2).encode())


class TestVPERM2I128(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x05, 0x46, 0xD4, 0x02]), VPERM2I128(ymm2, ymm15, ymm4, 2).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x05, 0x46, 0x54, 0xD9, 0xBE, 0x02]), VPERM2I128(ymm2, ymm15, hword[r9 + rbx*8 - 66], 2).encode())


class TestVSHUFF32X4(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xC3, 0x55, 0xAD, 0x23, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VSHUFF32X4(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xA3, 0x55, 0xAD, 0x23, 0xDC, 0x02]), VSHUFF32X4(ymm19(k5.z), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x2D, 0xC6, 0x23, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VSHUFF32X4(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x2D, 0xC6, 0x23, 0xC9, 0x02]), VSHUFF32X4(zmm9(k6.z), zmm26, zmm9, 2).encode())


class TestVSHUFI32X4(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xC3, 0x55, 0xAD, 0x43, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VSHUFI32X4(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xA3, 0x55, 0xAD, 0x43, 0xDC, 0x02]), VSHUFI32X4(ymm19(k5.z), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x2D, 0xC6, 0x43, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VSHUFI32X4(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0x2D, 0xC6, 0x43, 0xC9, 0x02]), VSHUFI32X4(zmm9(k6.z), zmm26, zmm9, 2).encode())


class TestVSHUFF64X2(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xC3, 0xD5, 0xAD, 0x23, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VSHUFF64X2(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xA3, 0xD5, 0xAD, 0x23, 0xDC, 0x02]), VSHUFF64X2(ymm19(k5.z), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xAD, 0xC6, 0x23, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VSHUFF64X2(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xAD, 0xC6, 0x23, 0xC9, 0x02]), VSHUFF64X2(zmm9(k6.z), zmm26, zmm9, 2).encode())


class TestVSHUFI64X2(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xC3, 0xD5, 0xAD, 0x43, 0x9C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VSHUFI64X2(ymm19(k5.z), ymm5, hword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0xA3, 0xD5, 0xAD, 0x43, 0xDC, 0x02]), VSHUFI64X2(ymm19(k5.z), ymm5, ymm20, 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xAD, 0xC6, 0x43, 0x8C, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF, 0x02]), VSHUFI64X2(zmm9(k6.z), zmm26, zword[r9 + rbx*8 - 66], 2).encode())
        self.assertEqual(bytearray([0x62, 0x53, 0xAD, 0xC6, 0x43, 0xC9, 0x02]), VSHUFI64X2(zmm9(k6.z), zmm26, zmm9, 2).encode())


class TestVPMOVB2M(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF2, 0x7E, 0x08, 0x29, 0xEC]), VPMOVB2M(k5, xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xF2, 0x7E, 0x28, 0x29, 0xED]), VPMOVB2M(k5, ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0x48, 0x29, 0xEA]), VPMOVB2M(k5, zmm26).encode())


class TestVPMOVW2M(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF2, 0xFE, 0x08, 0x29, 0xEC]), VPMOVW2M(k5, xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xF2, 0xFE, 0x28, 0x29, 0xED]), VPMOVW2M(k5, ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0xFE, 0x48, 0x29, 0xEA]), VPMOVW2M(k5, zmm26).encode())


class TestVPMOVD2M(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF2, 0x7E, 0x08, 0x39, 0xEC]), VPMOVD2M(k5, xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xF2, 0x7E, 0x28, 0x39, 0xED]), VPMOVD2M(k5, ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0x7E, 0x48, 0x39, 0xEA]), VPMOVD2M(k5, zmm26).encode())


class TestVPMOVQ2M(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xF2, 0xFE, 0x08, 0x39, 0xEC]), VPMOVQ2M(k5, xmm4).encode())
        self.assertEqual(bytearray([0x62, 0xF2, 0xFE, 0x28, 0x39, 0xED]), VPMOVQ2M(k5, ymm5).encode())
        self.assertEqual(bytearray([0x62, 0x92, 0xFE, 0x48, 0x39, 0xEA]), VPMOVQ2M(k5, zmm26).encode())


class TestVPMOVM2B(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xE2, 0x7E, 0x08, 0x28, 0xC5]), VPMOVM2B(xmm16, k5).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7E, 0x28, 0x28, 0xCD]), VPMOVM2B(ymm17, k5).encode())
        self.assertEqual(bytearray([0x62, 0xF2, 0x7E, 0x48, 0x28, 0xDD]), VPMOVM2B(zmm3, k5).encode())


class TestVPMOVM2W(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xE2, 0xFE, 0x08, 0x28, 0xC5]), VPMOVM2W(xmm16, k5).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0xFE, 0x28, 0x28, 0xCD]), VPMOVM2W(ymm17, k5).encode())
        self.assertEqual(bytearray([0x62, 0xF2, 0xFE, 0x48, 0x28, 0xDD]), VPMOVM2W(zmm3, k5).encode())


class TestVPMOVM2D(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xE2, 0x7E, 0x08, 0x38, 0xC5]), VPMOVM2D(xmm16, k5).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7E, 0x28, 0x38, 0xCD]), VPMOVM2D(ymm17, k5).encode())
        self.assertEqual(bytearray([0x62, 0xF2, 0x7E, 0x48, 0x38, 0xDD]), VPMOVM2D(zmm3, k5).encode())


class TestVPMOVM2Q(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xE2, 0xFE, 0x08, 0x38, 0xC5]), VPMOVM2Q(xmm16, k5).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0xFE, 0x28, 0x38, 0xCD]), VPMOVM2Q(ymm17, k5).encode())
        self.assertEqual(bytearray([0x62, 0xF2, 0xFE, 0x48, 0x38, 0xDD]), VPMOVM2Q(zmm3, k5).encode())


class TestVPBROADCASTMB2Q(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xE2, 0xFE, 0x08, 0x2A, 0xC5]), VPBROADCASTMB2Q(xmm16, k5).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0xFE, 0x28, 0x2A, 0xCD]), VPBROADCASTMB2Q(ymm17, k5).encode())
        self.assertEqual(bytearray([0x62, 0xF2, 0xFE, 0x48, 0x2A, 0xDD]), VPBROADCASTMB2Q(zmm3, k5).encode())


class TestVPBROADCASTMW2D(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xE2, 0x7E, 0x08, 0x3A, 0xC5]), VPBROADCASTMW2D(xmm16, k5).encode())
        self.assertEqual(bytearray([0x62, 0xE2, 0x7E, 0x28, 0x3A, 0xCD]), VPBROADCASTMW2D(ymm17, k5).encode())
        self.assertEqual(bytearray([0x62, 0xF2, 0x7E, 0x48, 0x3A, 0xDD]), VPBROADCASTMW2D(zmm3, k5).encode())


class TestVPTESTMB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xB2, 0x5D, 0x0E, 0x26, 0xE3]), VPTESTMB(k4(k6), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x5D, 0x0E, 0x26, 0x62, 0xF8]), VPTESTMB(k4(k6), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xB2, 0x55, 0x2E, 0x26, 0xE4]), VPTESTMB(k4(k6), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x55, 0x2E, 0x26, 0x61, 0xFC]), VPTESTMB(k4(k6), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x2D, 0x46, 0x26, 0xE1]), VPTESTMB(k4(k6), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x2D, 0x46, 0x26, 0x60, 0xFE]), VPTESTMB(k4(k6), zmm26, zword[r8 - 128]).encode())


class TestVPTESTMW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xB2, 0xDD, 0x0E, 0x26, 0xE3]), VPTESTMW(k4(k6), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xDD, 0x0E, 0x26, 0x62, 0xF8]), VPTESTMW(k4(k6), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xB2, 0xD5, 0x2E, 0x26, 0xE4]), VPTESTMW(k4(k6), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xD5, 0x2E, 0x26, 0x61, 0xFC]), VPTESTMW(k4(k6), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xAD, 0x46, 0x26, 0xE1]), VPTESTMW(k4(k6), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xAD, 0x46, 0x26, 0x60, 0xFE]), VPTESTMW(k4(k6), zmm26, zword[r8 - 128]).encode())


class TestVPTESTMD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD2, 0x5D, 0x0E, 0x27, 0xA4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPTESTMD(k4(k6), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xB2, 0x5D, 0x0E, 0x27, 0xE3]), VPTESTMD(k4(k6), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x55, 0x2E, 0x27, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPTESTMD(k4(k6), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xB2, 0x55, 0x2E, 0x27, 0xE4]), VPTESTMD(k4(k6), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x2D, 0x46, 0x27, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPTESTMD(k4(k6), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x2D, 0x46, 0x27, 0xE1]), VPTESTMD(k4(k6), zmm26, zmm9).encode())


class TestVPTESTMQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD2, 0xDD, 0x0E, 0x27, 0xA4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPTESTMQ(k4(k6), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xB2, 0xDD, 0x0E, 0x27, 0xE3]), VPTESTMQ(k4(k6), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xD5, 0x2E, 0x27, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPTESTMQ(k4(k6), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xB2, 0xD5, 0x2E, 0x27, 0xE4]), VPTESTMQ(k4(k6), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xAD, 0x46, 0x27, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPTESTMQ(k4(k6), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xAD, 0x46, 0x27, 0xE1]), VPTESTMQ(k4(k6), zmm26, zmm9).encode())


class TestVPTESTNMB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xB2, 0x5E, 0x0E, 0x26, 0xE3]), VPTESTNMB(k4(k6), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x5E, 0x0E, 0x26, 0x62, 0xF8]), VPTESTNMB(k4(k6), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xB2, 0x56, 0x2E, 0x26, 0xE4]), VPTESTNMB(k4(k6), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x56, 0x2E, 0x26, 0x61, 0xFC]), VPTESTNMB(k4(k6), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x2E, 0x46, 0x26, 0xE1]), VPTESTNMB(k4(k6), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x2E, 0x46, 0x26, 0x60, 0xFE]), VPTESTNMB(k4(k6), zmm26, zword[r8 - 128]).encode())


class TestVPTESTNMW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xB2, 0xDE, 0x0E, 0x26, 0xE3]), VPTESTNMW(k4(k6), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xDE, 0x0E, 0x26, 0x62, 0xF8]), VPTESTNMW(k4(k6), xmm4, oword[r10 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xB2, 0xD6, 0x2E, 0x26, 0xE4]), VPTESTNMW(k4(k6), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xD6, 0x2E, 0x26, 0x61, 0xFC]), VPTESTNMW(k4(k6), ymm5, hword[r9 - 128]).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xAE, 0x46, 0x26, 0xE1]), VPTESTNMW(k4(k6), zmm26, zmm9).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xAE, 0x46, 0x26, 0x60, 0xFE]), VPTESTNMW(k4(k6), zmm26, zword[r8 - 128]).encode())


class TestVPTESTNMD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD2, 0x5E, 0x0E, 0x27, 0xA4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPTESTNMD(k4(k6), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xB2, 0x5E, 0x0E, 0x27, 0xE3]), VPTESTNMD(k4(k6), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x56, 0x2E, 0x27, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPTESTNMD(k4(k6), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xB2, 0x56, 0x2E, 0x27, 0xE4]), VPTESTNMD(k4(k6), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x2E, 0x46, 0x27, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPTESTNMD(k4(k6), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0x2E, 0x46, 0x27, 0xE1]), VPTESTNMD(k4(k6), zmm26, zmm9).encode())


class TestVPTESTNMQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x62, 0xD2, 0xDE, 0x0E, 0x27, 0xA4, 0xC2, 0xB3, 0xFF, 0xFF, 0xFF]), VPTESTNMQ(k4(k6), xmm4, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x62, 0xB2, 0xDE, 0x0E, 0x27, 0xE3]), VPTESTNMQ(k4(k6), xmm4, xmm19).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xD6, 0x2E, 0x27, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPTESTNMQ(k4(k6), ymm5, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xB2, 0xD6, 0x2E, 0x27, 0xE4]), VPTESTNMQ(k4(k6), ymm5, ymm20).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xAE, 0x46, 0x27, 0xA4, 0xD9, 0xBE, 0xFF, 0xFF, 0xFF]), VPTESTNMQ(k4(k6), zmm26, zword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x62, 0xD2, 0xAE, 0x46, 0x27, 0xE1]), VPTESTNMQ(k4(k6), zmm26, zmm9).encode())


class TestVLDMXCSR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0xAE, 0x54, 0xCC, 0x9D]), VLDMXCSR(dword[r12 + rcx*8 - 99]).encode())


class TestVSTMXCSR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xC1, 0x78, 0xAE, 0x5C, 0xCC, 0x9D]), VSTMXCSR(dword[r12 + rcx*8 - 99]).encode())


class TestVZEROUPPER(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0xF8, 0x77]), VZEROUPPER().encode())


class TestVZEROALL(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC5, 0xFC, 0x77]), VZEROALL().encode())


