# This file is auto-generated by /codegen/x86_64_test_encoding.py
# Reference opcodes are generated by:
#     GNU assembler (GNU Binutils) 2.28.51.20170402

from peachpy.x86_64 import *
import unittest


class TestPAVGUSB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0xBF]), PAVGUSB(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0xBF]), PAVGUSB(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPMULHRW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0xB7]), PMULHRW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0xB7]), PMULHRW(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPF2ID(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0x1D]), PF2ID(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0x1D]), PF2ID(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPF2IW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0x1C]), PF2IW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0x1C]), PF2IW(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPI2FW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0x0C]), PI2FW(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0x0C]), PI2FW(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPI2FD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0x0D]), PI2FD(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0x0D]), PI2FD(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPFADD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0x9E]), PFADD(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0x9E]), PFADD(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPFSUB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0x9A]), PFSUB(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0x9A]), PFSUB(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPFSUBR(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0xAA]), PFSUBR(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0xAA]), PFSUBR(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPFMUL(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0xB4]), PFMUL(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0xB4]), PFMUL(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPFMAX(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0xA4]), PFMAX(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0xA4]), PFMAX(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPFMIN(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0x94]), PFMIN(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0x94]), PFMIN(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPFACC(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0xAE]), PFACC(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0xAE]), PFACC(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPFNACC(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0x8A]), PFNACC(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0x8A]), PFNACC(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPFPNACC(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0x8E]), PFPNACC(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0x8E]), PFPNACC(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPSWAPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0xBB]), PSWAPD(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0xBB]), PSWAPD(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPFCMPEQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0xB0]), PFCMPEQ(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0xB0]), PFCMPEQ(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPFCMPGT(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0xA0]), PFCMPGT(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0xA0]), PFCMPGT(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPFCMPGE(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0x90]), PFCMPGE(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0x90]), PFCMPGE(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPFRCP(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0x96]), PFRCP(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0x96]), PFRCP(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPFRCPIT1(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0xA6]), PFRCPIT1(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0xA6]), PFRCPIT1(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPFRCPIT2(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0xB6]), PFRCPIT2(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0xB6]), PFRCPIT2(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPFRSQRT(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0x97]), PFRSQRT(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0x97]), PFRSQRT(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestPFRSQIT1(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0F, 0xDD, 0xA7]), PFRSQIT1(mm3, mm5).encode())
        self.assertEqual(bytearray([0x41, 0x0F, 0x0F, 0x5C, 0xD3, 0xA8, 0xA7]), PFRSQIT1(mm3, qword[r11 + rdx*8 - 88]).encode())


class TestFEMMS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x0F, 0x0E]), FEMMS().encode())


class TestMOVNTSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF3, 0x45, 0x0F, 0x2B, 0x74, 0xCC, 0x9D]), MOVNTSS(dword[r12 + rcx*8 - 99], xmm14).encode())


class TestMOVNTSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x45, 0x0F, 0x2B, 0x74, 0xD3, 0xA8]), MOVNTSD(qword[r11 + rdx*8 - 88], xmm14).encode())


class TestINSERTQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x79, 0xCE]), INSERTQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0xF2, 0x41, 0x0F, 0x78, 0xCE, 0x02, 0x02]), INSERTQ(xmm1, xmm14, 2, 2).encode())


class TestEXTRQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x66, 0x41, 0x0F, 0x79, 0xCE]), EXTRQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x66, 0x0F, 0x78, 0xC1, 0x02, 0x02]), EXTRQ(xmm1, 2, 2).encode())


class TestVPPERM(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0xA3, 0xCB, 0x90]), VPPERM(xmm1, xmm14, xmm3, xmm9).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x88, 0xA3, 0x4C, 0xC2, 0xB3, 0x30]), VPPERM(xmm1, xmm14, xmm3, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0xA3, 0x4C, 0xC2, 0xB3, 0x90]), VPPERM(xmm1, xmm14, oword[r10 + rax*8 - 77], xmm9).encode())


class TestVPCMOV(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0xA2, 0xCB, 0x90]), VPCMOV(xmm1, xmm14, xmm3, xmm9).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x88, 0xA2, 0x4C, 0xC2, 0xB3, 0x30]), VPCMOV(xmm1, xmm14, xmm3, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0xA2, 0x4C, 0xC2, 0xB3, 0x90]), VPCMOV(xmm1, xmm14, oword[r10 + rax*8 - 77], xmm9).encode())
        self.assertEqual(bytearray([0x8F, 0xE8, 0x04, 0xA2, 0xD4, 0xA0]), VPCMOV(ymm2, ymm15, ymm4, ymm10).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x84, 0xA2, 0x54, 0xD9, 0xBE, 0x40]), VPCMOV(ymm2, ymm15, ymm4, hword[r9 + rbx*8 - 66]).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x04, 0xA2, 0x54, 0xD9, 0xBE, 0xA0]), VPCMOV(ymm2, ymm15, hword[r9 + rbx*8 - 66], ymm10).encode())


class TestVPROTB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC8, 0x78, 0xC0, 0xCE, 0x02]), VPROTB(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x90, 0xCE]), VPROTB(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x88, 0x90, 0x4C, 0xC2, 0xB3]), VPROTB(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x78, 0xC0, 0x4C, 0xC2, 0xB3, 0x02]), VPROTB(xmm1, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x90, 0x4C, 0xC2, 0xB3]), VPROTB(xmm1, oword[r10 + rax*8 - 77], xmm3).encode())


class TestVPROTW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC8, 0x78, 0xC1, 0xCE, 0x02]), VPROTW(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x91, 0xCE]), VPROTW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x88, 0x91, 0x4C, 0xC2, 0xB3]), VPROTW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x78, 0xC1, 0x4C, 0xC2, 0xB3, 0x02]), VPROTW(xmm1, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x91, 0x4C, 0xC2, 0xB3]), VPROTW(xmm1, oword[r10 + rax*8 - 77], xmm3).encode())


class TestVPROTD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC8, 0x78, 0xC2, 0xCE, 0x02]), VPROTD(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x92, 0xCE]), VPROTD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x88, 0x92, 0x4C, 0xC2, 0xB3]), VPROTD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x78, 0xC2, 0x4C, 0xC2, 0xB3, 0x02]), VPROTD(xmm1, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x92, 0x4C, 0xC2, 0xB3]), VPROTD(xmm1, oword[r10 + rax*8 - 77], xmm3).encode())


class TestVPROTQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC8, 0x78, 0xC3, 0xCE, 0x02]), VPROTQ(xmm1, xmm14, 2).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x93, 0xCE]), VPROTQ(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x88, 0x93, 0x4C, 0xC2, 0xB3]), VPROTQ(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x78, 0xC3, 0x4C, 0xC2, 0xB3, 0x02]), VPROTQ(xmm1, oword[r10 + rax*8 - 77], 2).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x93, 0x4C, 0xC2, 0xB3]), VPROTQ(xmm1, oword[r10 + rax*8 - 77], xmm3).encode())


class TestVPSHAB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x98, 0xCE]), VPSHAB(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x88, 0x98, 0x4C, 0xC2, 0xB3]), VPSHAB(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x98, 0x4C, 0xC2, 0xB3]), VPSHAB(xmm1, oword[r10 + rax*8 - 77], xmm3).encode())


class TestVPSHAW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x99, 0xCE]), VPSHAW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x88, 0x99, 0x4C, 0xC2, 0xB3]), VPSHAW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x99, 0x4C, 0xC2, 0xB3]), VPSHAW(xmm1, oword[r10 + rax*8 - 77], xmm3).encode())


class TestVPSHAD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x9A, 0xCE]), VPSHAD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x88, 0x9A, 0x4C, 0xC2, 0xB3]), VPSHAD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x9A, 0x4C, 0xC2, 0xB3]), VPSHAD(xmm1, oword[r10 + rax*8 - 77], xmm3).encode())


class TestVPSHAQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x9B, 0xCE]), VPSHAQ(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x88, 0x9B, 0x4C, 0xC2, 0xB3]), VPSHAQ(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x9B, 0x4C, 0xC2, 0xB3]), VPSHAQ(xmm1, oword[r10 + rax*8 - 77], xmm3).encode())


class TestVPSHLB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x94, 0xCE]), VPSHLB(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x88, 0x94, 0x4C, 0xC2, 0xB3]), VPSHLB(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x94, 0x4C, 0xC2, 0xB3]), VPSHLB(xmm1, oword[r10 + rax*8 - 77], xmm3).encode())


class TestVPSHLW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x95, 0xCE]), VPSHLW(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x88, 0x95, 0x4C, 0xC2, 0xB3]), VPSHLW(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x95, 0x4C, 0xC2, 0xB3]), VPSHLW(xmm1, oword[r10 + rax*8 - 77], xmm3).encode())


class TestVPSHLD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x96, 0xCE]), VPSHLD(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x88, 0x96, 0x4C, 0xC2, 0xB3]), VPSHLD(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x96, 0x4C, 0xC2, 0xB3]), VPSHLD(xmm1, oword[r10 + rax*8 - 77], xmm3).encode())


class TestVPSHLQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x97, 0xCE]), VPSHLQ(xmm1, xmm14, xmm3).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x88, 0x97, 0x4C, 0xC2, 0xB3]), VPSHLQ(xmm1, xmm14, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x60, 0x97, 0x4C, 0xC2, 0xB3]), VPSHLQ(xmm1, oword[r10 + rax*8 - 77], xmm3).encode())


class TestVPCOMB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0xCC, 0xCB, 0x02]), VPCOMB(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0xCC, 0x4C, 0xC2, 0xB3, 0x02]), VPCOMB(xmm1, xmm14, oword[r10 + rax*8 - 77], 2).encode())


class TestVPCOMW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0xCD, 0xCB, 0x02]), VPCOMW(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0xCD, 0x4C, 0xC2, 0xB3, 0x02]), VPCOMW(xmm1, xmm14, oword[r10 + rax*8 - 77], 2).encode())


class TestVPCOMD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0xCE, 0xCB, 0x02]), VPCOMD(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0xCE, 0x4C, 0xC2, 0xB3, 0x02]), VPCOMD(xmm1, xmm14, oword[r10 + rax*8 - 77], 2).encode())


class TestVPCOMQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0xCF, 0xCB, 0x02]), VPCOMQ(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0xCF, 0x4C, 0xC2, 0xB3, 0x02]), VPCOMQ(xmm1, xmm14, oword[r10 + rax*8 - 77], 2).encode())


class TestVPCOMUB(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0xEC, 0xCB, 0x02]), VPCOMUB(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0xEC, 0x4C, 0xC2, 0xB3, 0x02]), VPCOMUB(xmm1, xmm14, oword[r10 + rax*8 - 77], 2).encode())


class TestVPCOMUW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0xED, 0xCB, 0x02]), VPCOMUW(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0xED, 0x4C, 0xC2, 0xB3, 0x02]), VPCOMUW(xmm1, xmm14, oword[r10 + rax*8 - 77], 2).encode())


class TestVPCOMUD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0xEE, 0xCB, 0x02]), VPCOMUD(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0xEE, 0x4C, 0xC2, 0xB3, 0x02]), VPCOMUD(xmm1, xmm14, oword[r10 + rax*8 - 77], 2).encode())


class TestVPCOMUQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0xEF, 0xCB, 0x02]), VPCOMUQ(xmm1, xmm14, xmm3, 2).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0xEF, 0x4C, 0xC2, 0xB3, 0x02]), VPCOMUQ(xmm1, xmm14, oword[r10 + rax*8 - 77], 2).encode())


class TestVPHADDBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xC1, 0xCE]), VPHADDBW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xC1, 0x4C, 0xC2, 0xB3]), VPHADDBW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestVPHADDBD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xC2, 0xCE]), VPHADDBD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xC2, 0x4C, 0xC2, 0xB3]), VPHADDBD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestVPHADDBQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xC3, 0xCE]), VPHADDBQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xC3, 0x4C, 0xC2, 0xB3]), VPHADDBQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestVPHADDWD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xC6, 0xCE]), VPHADDWD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xC6, 0x4C, 0xC2, 0xB3]), VPHADDWD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestVPHADDWQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xC7, 0xCE]), VPHADDWQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xC7, 0x4C, 0xC2, 0xB3]), VPHADDWQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestVPHADDDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xCB, 0xCE]), VPHADDDQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xCB, 0x4C, 0xC2, 0xB3]), VPHADDDQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestVPHADDUBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xD1, 0xCE]), VPHADDUBW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xD1, 0x4C, 0xC2, 0xB3]), VPHADDUBW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestVPHADDUBD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xD2, 0xCE]), VPHADDUBD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xD2, 0x4C, 0xC2, 0xB3]), VPHADDUBD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestVPHADDUBQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xD3, 0xCE]), VPHADDUBQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xD3, 0x4C, 0xC2, 0xB3]), VPHADDUBQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestVPHADDUWD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xD6, 0xCE]), VPHADDUWD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xD6, 0x4C, 0xC2, 0xB3]), VPHADDUWD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestVPHADDUWQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xD7, 0xCE]), VPHADDUWQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xD7, 0x4C, 0xC2, 0xB3]), VPHADDUWQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestVPHADDUDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xDB, 0xCE]), VPHADDUDQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xDB, 0x4C, 0xC2, 0xB3]), VPHADDUDQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestVPHSUBBW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xE1, 0xCE]), VPHSUBBW(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xE1, 0x4C, 0xC2, 0xB3]), VPHSUBBW(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestVPHSUBWD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xE2, 0xCE]), VPHSUBWD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xE2, 0x4C, 0xC2, 0xB3]), VPHSUBWD(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestVPHSUBDQ(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xE3, 0xCE]), VPHSUBDQ(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0xE3, 0x4C, 0xC2, 0xB3]), VPHSUBDQ(xmm1, oword[r10 + rax*8 - 77]).encode())


class TestVPMACSDQH(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0x9F, 0xCB, 0x90]), VPMACSDQH(xmm1, xmm14, xmm3, xmm9).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0x9F, 0x4C, 0xC2, 0xB3, 0x90]), VPMACSDQH(xmm1, xmm14, oword[r10 + rax*8 - 77], xmm9).encode())


class TestVPMACSDQL(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0x97, 0xCB, 0x90]), VPMACSDQL(xmm1, xmm14, xmm3, xmm9).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0x97, 0x4C, 0xC2, 0xB3, 0x90]), VPMACSDQL(xmm1, xmm14, oword[r10 + rax*8 - 77], xmm9).encode())


class TestVPMACSDD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0x9E, 0xCB, 0x90]), VPMACSDD(xmm1, xmm14, xmm3, xmm9).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0x9E, 0x4C, 0xC2, 0xB3, 0x90]), VPMACSDD(xmm1, xmm14, oword[r10 + rax*8 - 77], xmm9).encode())


class TestVPMACSWD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0x96, 0xCB, 0x90]), VPMACSWD(xmm1, xmm14, xmm3, xmm9).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0x96, 0x4C, 0xC2, 0xB3, 0x90]), VPMACSWD(xmm1, xmm14, oword[r10 + rax*8 - 77], xmm9).encode())


class TestVPMACSWW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0x95, 0xCB, 0x90]), VPMACSWW(xmm1, xmm14, xmm3, xmm9).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0x95, 0x4C, 0xC2, 0xB3, 0x90]), VPMACSWW(xmm1, xmm14, oword[r10 + rax*8 - 77], xmm9).encode())


class TestVPMADCSWD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0xB6, 0xCB, 0x90]), VPMADCSWD(xmm1, xmm14, xmm3, xmm9).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0xB6, 0x4C, 0xC2, 0xB3, 0x90]), VPMADCSWD(xmm1, xmm14, oword[r10 + rax*8 - 77], xmm9).encode())


class TestVPMACSSDD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0x8E, 0xCB, 0x90]), VPMACSSDD(xmm1, xmm14, xmm3, xmm9).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0x8E, 0x4C, 0xC2, 0xB3, 0x90]), VPMACSSDD(xmm1, xmm14, oword[r10 + rax*8 - 77], xmm9).encode())


class TestVPMACSSDQH(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0x8F, 0xCB, 0x90]), VPMACSSDQH(xmm1, xmm14, xmm3, xmm9).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0x8F, 0x4C, 0xC2, 0xB3, 0x90]), VPMACSSDQH(xmm1, xmm14, oword[r10 + rax*8 - 77], xmm9).encode())


class TestVPMACSSDQL(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0x87, 0xCB, 0x90]), VPMACSSDQL(xmm1, xmm14, xmm3, xmm9).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0x87, 0x4C, 0xC2, 0xB3, 0x90]), VPMACSSDQL(xmm1, xmm14, oword[r10 + rax*8 - 77], xmm9).encode())


class TestVPMACSSWD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0x86, 0xCB, 0x90]), VPMACSSWD(xmm1, xmm14, xmm3, xmm9).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0x86, 0x4C, 0xC2, 0xB3, 0x90]), VPMACSSWD(xmm1, xmm14, oword[r10 + rax*8 - 77], xmm9).encode())


class TestVPMACSSWW(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0x85, 0xCB, 0x90]), VPMACSSWW(xmm1, xmm14, xmm3, xmm9).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0x85, 0x4C, 0xC2, 0xB3, 0x90]), VPMACSSWW(xmm1, xmm14, oword[r10 + rax*8 - 77], xmm9).encode())


class TestVPMADCSSWD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xE8, 0x08, 0xA6, 0xCB, 0x90]), VPMADCSSWD(xmm1, xmm14, xmm3, xmm9).encode())
        self.assertEqual(bytearray([0x8F, 0xC8, 0x08, 0xA6, 0x4C, 0xC2, 0xB3, 0x90]), VPMADCSSWD(xmm1, xmm14, oword[r10 + rax*8 - 77], xmm9).encode())


class TestVFRCZSS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0x82, 0xCE]), VFRCZSS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0x82, 0x4C, 0xCC, 0x9D]), VFRCZSS(xmm1, dword[r12 + rcx*8 - 99]).encode())


class TestVFRCZSD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0x83, 0xCE]), VFRCZSD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0x83, 0x4C, 0xD3, 0xA8]), VFRCZSD(xmm1, qword[r11 + rdx*8 - 88]).encode())


class TestVFRCZPS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0x80, 0xCE]), VFRCZPS(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0x80, 0x4C, 0xC2, 0xB3]), VFRCZPS(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x7C, 0x80, 0xD7]), VFRCZPS(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x7C, 0x80, 0x54, 0xD9, 0xBE]), VFRCZPS(ymm2, hword[r9 + rbx*8 - 66]).encode())


class TestVFRCZPD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0x81, 0xCE]), VFRCZPD(xmm1, xmm14).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x78, 0x81, 0x4C, 0xC2, 0xB3]), VFRCZPD(xmm1, oword[r10 + rax*8 - 77]).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x7C, 0x81, 0xD7]), VFRCZPD(ymm2, ymm15).encode())
        self.assertEqual(bytearray([0x8F, 0xC9, 0x7C, 0x81, 0x54, 0xD9, 0xBE]), VFRCZPD(ymm2, hword[r9 + rbx*8 - 66]).encode())


class TestVPERMIL2PD(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x09, 0x49, 0xCB, 0x93]), VPERMIL2PD(xmm1, xmm14, xmm3, xmm9, 0b11).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x89, 0x49, 0x4C, 0xC2, 0xB3, 0x33]), VPERMIL2PD(xmm1, xmm14, xmm3, oword[r10 + rax*8 - 77], 0b11).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x09, 0x49, 0x4C, 0xC2, 0xB3, 0x93]), VPERMIL2PD(xmm1, xmm14, oword[r10 + rax*8 - 77], xmm9, 0b11).encode())
        self.assertEqual(bytearray([0xC4, 0xE3, 0x05, 0x49, 0xD4, 0xA3]), VPERMIL2PD(ymm2, ymm15, ymm4, ymm10, 0b11).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x85, 0x49, 0x54, 0xD9, 0xBE, 0x43]), VPERMIL2PD(ymm2, ymm15, ymm4, hword[r9 + rbx*8 - 66], 0b11).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x05, 0x49, 0x54, 0xD9, 0xBE, 0xA3]), VPERMIL2PD(ymm2, ymm15, hword[r9 + rbx*8 - 66], ymm10, 0b11).encode())


class TestVPERMIL2PS(unittest.TestCase):
    def runTest(self):
        self.assertEqual(bytearray([0xC4, 0xE3, 0x09, 0x48, 0xCB, 0x93]), VPERMIL2PS(xmm1, xmm14, xmm3, xmm9, 0b11).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x89, 0x48, 0x4C, 0xC2, 0xB3, 0x33]), VPERMIL2PS(xmm1, xmm14, xmm3, oword[r10 + rax*8 - 77], 0b11).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x09, 0x48, 0x4C, 0xC2, 0xB3, 0x93]), VPERMIL2PS(xmm1, xmm14, oword[r10 + rax*8 - 77], xmm9, 0b11).encode())
        self.assertEqual(bytearray([0xC4, 0xE3, 0x05, 0x48, 0xD4, 0xA3]), VPERMIL2PS(ymm2, ymm15, ymm4, ymm10, 0b11).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x85, 0x48, 0x54, 0xD9, 0xBE, 0x43]), VPERMIL2PS(ymm2, ymm15, ymm4, hword[r9 + rbx*8 - 66], 0b11).encode())
        self.assertEqual(bytearray([0xC4, 0xC3, 0x05, 0x48, 0x54, 0xD9, 0xBE, 0xA3]), VPERMIL2PS(ymm2, ymm15, hword[r9 + rbx*8 - 66], ymm10, 0b11).encode())


