
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <XCAFApp_Application.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_XCAFApp(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("XCAFApp"));
py::object klass;

//Python trampoline classes

// classes

    // Class XCAFApp_Application from ./opencascade/XCAFApp_Application.hxx
    klass = m.attr("XCAFApp_Application");


    // nested enums

    static_cast<py::class_<XCAFApp_Application ,opencascade::handle<XCAFApp_Application>  , TDocStd_Application >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("ResourcesName",
             (Standard_CString (XCAFApp_Application::*)() ) static_cast<Standard_CString (XCAFApp_Application::*)() >(&XCAFApp_Application::ResourcesName),
             R"#(methods from TDocStd_Application ================================)#" 
          )
        .def("InitDocument",
             (void (XCAFApp_Application::*)( const opencascade::handle<CDM_Document> &  ) const) static_cast<void (XCAFApp_Application::*)( const opencascade::handle<CDM_Document> &  ) const>(&XCAFApp_Application::InitDocument),
             R"#(Set XCAFDoc_DocumentTool attribute)#"  , py::arg("aDoc")
          )
        .def("DumpJson",
             (void (XCAFApp_Application::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (XCAFApp_Application::*)( std::ostream & ,  Standard_Integer  ) const>(&XCAFApp_Application::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("GetApplication_s",
                    (opencascade::handle<XCAFApp_Application> (*)() ) static_cast<opencascade::handle<XCAFApp_Application> (*)() >(&XCAFApp_Application::GetApplication),
                    R"#(Initializes (for the first time) and returns the static object (XCAFApp_Application) This is the only valid method to get XCAFApp_Application object, and it should be called at least once before any actions with documents in order to init application)#" 
          )
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&XCAFApp_Application::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&XCAFApp_Application::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (XCAFApp_Application::*)() const) static_cast<const opencascade::handle<Standard_Type> & (XCAFApp_Application::*)() const>(&XCAFApp_Application::DynamicType),
             R"#(None)#"
             
         )
;

// functions
// ./opencascade/XCAFApp_Application.hxx

// Additional functions

// operators

// register typdefs


// exceptions

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
