# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.appcontainers.aio import ContainerAppsAPIClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestContainerAppsAPIHttpRouteConfigOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ContainerAppsAPIClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_http_route_config_get(self, resource_group):
        response = await self.client.http_route_config.get(
            resource_group_name=resource_group.name,
            environment_name="str",
            http_route_name="str",
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_http_route_config_create_or_update(self, resource_group):
        response = await self.client.http_route_config.create_or_update(
            resource_group_name=resource_group.name,
            environment_name="str",
            http_route_name="str",
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_http_route_config_update(self, resource_group):
        response = await self.client.http_route_config.update(
            resource_group_name=resource_group.name,
            environment_name="str",
            http_route_name="str",
            http_route_config_envelope={
                "id": "str",
                "name": "str",
                "properties": {
                    "customDomains": [{"name": "str", "bindingType": "str", "certificateId": "str"}],
                    "fqdn": "str",
                    "provisioningErrors": [{"message": "str", "timestamp": "2020-02-20 00:00:00"}],
                    "provisioningState": "str",
                    "rules": [
                        {
                            "description": "str",
                            "routes": [
                                {
                                    "action": {"prefixRewrite": "str"},
                                    "match": {
                                        "caseSensitive": bool,
                                        "path": "str",
                                        "pathSeparatedPrefix": "str",
                                        "prefix": "str",
                                    },
                                }
                            ],
                            "targets": [{"containerApp": "str", "label": "str", "revision": "str"}],
                        }
                    ],
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_http_route_config_begin_delete(self, resource_group):
        response = await (
            await self.client.http_route_config.begin_delete(
                resource_group_name=resource_group.name,
                environment_name="str",
                http_route_name="str",
                api_version="2025-07-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_http_route_config_list(self, resource_group):
        response = self.client.http_route_config.list(
            resource_group_name=resource_group.name,
            environment_name="str",
            api_version="2025-07-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
