require 'spec_helper'

describe 'collectd::plugin::openvpn', type: :class do
  on_supported_os(baseline_os_hash).each do |os, facts|
    context "on #{os} " do
      let :facts do
        facts
      end

      options = os_specific_options(facts)
      context ':ensure => present, default params' do
        it "Will create #{options[:plugin_conf_dir]}/10-openvpn.conf" do
          is_expected.to contain_file('openvpn.load').with(
            ensure: 'present',
            path: "#{options[:plugin_conf_dir]}/10-openvpn.conf",
            content: "#\ Generated by Puppet\n<LoadPlugin openvpn>\n  Globals false\n</LoadPlugin>\n\n<Plugin openvpn>\n  StatusFile \"/etc/openvpn/openvpn-status.log\"\n  ImprovedNamingSchema false\n  CollectCompression true\n  CollectIndividualUsers true\n  CollectUserCount false\n</Plugin>\n\n"
          )
        end
      end

      context ':statusfile param is an array' do
        let :params do
          { statusfile: ['/etc/openvpn/openvpn-tcp.status', '/etc/openvpn/openvpn-udp.status'] }
        end

        it "Will create #{options[:plugin_conf_dir]}/10-openvpn.conf with two :statusfile params" do
          is_expected.to contain_file('openvpn.load').with(
            ensure: 'present',
            path: "#{options[:plugin_conf_dir]}/10-openvpn.conf",
            content: "#\ Generated by Puppet\n<LoadPlugin openvpn>\n  Globals false\n</LoadPlugin>\n\n<Plugin openvpn>\n  StatusFile \"/etc/openvpn/openvpn-tcp.status\"\n  StatusFile \"/etc/openvpn/openvpn-udp.status\"\n  ImprovedNamingSchema false\n  CollectCompression true\n  CollectIndividualUsers true\n  CollectUserCount false\n</Plugin>\n\n"
          )
        end
      end

      context ':interval is not default and is an integer' do
        let :params do
          { interval: 15 }
        end

        it "Will create #{options[:plugin_conf_dir]}/10-openvpn.conf" do
          is_expected.to contain_file('openvpn.load').with(
            ensure: 'present',
            path: "#{options[:plugin_conf_dir]}/10-openvpn.conf",
            content: %r{^  Interval 15}
          )
        end
      end

      context ':ensure => absent' do
        let :params do
          { ensure: 'absent' }
        end

        it "Will not create #{options[:plugin_conf_dir]}/10-openvpn.conf" do
          is_expected.to contain_file('openvpn.load').with(
            ensure: 'absent',
            path: "#{options[:plugin_conf_dir]}/10-openvpn.conf"
          )
        end
      end
    end
  end
end
