/*
	PsychtoolboxGL/Source/Common/PsychHID/PsychHIDKbQueueStart.c		
  
	PROJECTS: 
	
		PsychHID only.
  
	PLATFORMS:  
	
		All.  
  
	AUTHORS:
	
		rwoods@ucla.edu		rpw 
        mario.kleiner@tuebingen.mpg.de      mk
      
	HISTORY:
		8/19/07  rpw		Created.
		8/23/07  rpw        Added PsychHIDQueueFlush to documentation; removed call to PsychHIDVerifyInit()

  
	NOTES:

*/

#include "PsychHID.h"

static char useString[]= "PsychHID('KbQueueStart' [, deviceIndex])";
static char synopsisString[] = 
        "Starts the queue for input events generated by a device.\n"
        "PsychHID('KbQueueCreate') must be called before this routine.\n"
        "The optional 'deviceIndex' is the index of the HID input device whose queue should be started. "
        "If omitted, the queue of the default device will be started.\n";

static char seeAlsoString[] = "KbQueueCreate, KbQueueStop, KbQueueCheck, KbQueueFlush, KbQueueRelease";

PsychError PSYCHHIDKbQueueStart(void) 
{
    int deviceIndex;
    
    PsychPushHelp(useString, synopsisString, seeAlsoString);
    if(PsychIsGiveHelp()){PsychGiveHelp();return(PsychError_none);};

    PsychErrorExit(PsychCapNumOutputArgs(0));
    PsychErrorExit(PsychCapNumInputArgs(1));

    deviceIndex = -1;
    PsychCopyInIntegerArg(1, kPsychArgOptional, &deviceIndex);

    PsychHIDOSKbQueueStart(deviceIndex);
    
    return(PsychError_none);	
}
