# Third-Party Add-ons for Protocol Buffers

This page lists code related to Protocol Buffers which is developed and maintained by third parties.  You may find this code useful, but note that **these projects are not affiliated with or endorsed by Google (unless explicitly marked)**; try them at your own risk.  Also note that many projects here are in the early stages of development and not production-ready.

If you have a project that should be listed here, please
[send us a pull request](https://github.com/protocolbuffers/protobuf/pulls) to update this page.

## Programming Languages

These are projects we know about implementing Protocol Buffers for other programming languages:
* Action Script: https://code.google.com/p/protobuf-actionscript3/
* Action Script: https://code.google.com/p/protoc-gen-as3/
* Action Script: https://github.com/matrix3d/JProtoc
* Action Script: https://github.com/zhongfq/protobuf-as3/
* Ada: https://github.com/reznikmm/protobuf
* C: https://github.com/protobuf-c/protobuf-c
* C: https://koti.kapsi.fi/jpa/nanopb/
* C: https://github.com/cloudwu/pbc/
* C: https://github.com/haberman/upb/wiki
* C: https://github.com/squidfunk/protobluff
* C: https://github.com/eerimoq/pbtools
* C++: https://github.com/protocolbuffers/protobuf (Google-official implementation)
* C++: https://EmbeddedProto.com
* C/C++: http://spbc.sf.net/
* C#: https://code.google.com/p/protobuf-csharp-port
* C#: https://silentorbit.com/protobuf/
* C#/.NET/WCF/VB: https://code.google.com/p/protobuf-net/
* Clojure: http://github.com/ninjudd/clojure-protobuf
* Clojure: https://github.com/clojusc/protobuf
* Clojure: https://protojure.readthedocs.io
* Common Lisp: http://github.com/brown/protobuf
* Common Lisp: http://github.com/qitab/cl-protobuf
* D: https://github.com/dcarp/protobuf-d
* D: https://github.com/msoucy/dproto
* D: https://github.com/opticron/ProtocolBuffer
* Dart: https://github.com/dart-lang/dart-protobuf (runtime) https://github.com/dart-lang/dart-protoc-plugin (code generator)
* Delphi: http://sourceforge.net/projects/protobuf-delphi/
* Delphi: http://fundementals.sourceforge.net/dl.html
* Elixir: https://github.com/jeremyong/exprotoc
* Elixir: https://github.com/tony612/protobuf-elixir
* Elixir: https://github.com/ahamez/protox
* Elm: https://github.com/tiziano88/elm-protobuf
* Erlang: https://github.com/tomas-abrahamsson/gpb
* Erlang: http://piqi.org/
* Erlang: https://github.com/basho/erlang_protobuffs (no longer maintained, use gpb instead)
* Hacklang/HHVM: https://github.com/y3llowcake/proto-hack
* GDScript: https://github.com/oniksan/godobuf (Godot v3 engine plugin)
* Go: https://github.com/golang/protobuf (Google-official implementation)
* Go: https://github.com/akunspy/gopbuf
* Go: https://github.com/gogo/protobuf
* GopherJS: https://github.com/johanbrandhorst/protobuf
* Haskell: https://hackage.haskell.org/package/hprotoc
* Haskell: https://github.com/google/proto-lens (Google-unofficial implementation)
* Haskell: https://github.com/awakesecurity/proto3-suite (code generator) https://github.com/awakesecurity/proto3-wire (binary serializer/deserializer)
* Haxe: https://github.com/Atry/protoc-gen-haxe
* Java: https://github.com/protocolbuffers/protobuf (Google-official implementation)
* Java/Android: https://github.com/square/wire
* Java: https://github.com/HebiRobotics/QuickBuffers/
* Java ME: https://code.google.com/p/protobuf-javame/
* Java ME: http://swingme.sourceforge.net/encode.shtml
* Javascript: https://code.google.com/p/protobuf-js/
* Javascript: http://github.com/sirikata/protojs
* Javascript: https://github.com/dcodeIO/ProtoBuf.js
* Javascript: https://code.google.com/p/protobuf-for-node/
* Javascript: https://code.google.com/p/protostuff/
* Javascript: https://github.com/seishun/node-protoc-plugin (Node.js port of plugin.h)
* Javascript: https://github.com/seishun/node-protoc-gen-javascript (Node.js port of the Google-official implementation)
* Javascript: https://github.com/ButterCam/sisyphus-js
* Julia: https://github.com/tanmaykm/ProtoBuf.jl
* Kotlin: https://github.com/marcoferrer/kroto-plus
* Kotlin: https://github.com/Kotlin/kotlinx.serialization
* Kotlin: https://github.com/ButterCam/sisyphus
* Kotlin: https://github.com/open-toast/protokt
* Kotlin Multiplatform: https://github.com/streem/pbandk
* Lua: https://code.google.com/p/protoc-gen-lua/
* Lua: http://github.com/indygreg/lua-protobuf
* Lua: https://github.com/Neopallium/lua-pb
* Matlab: https://code.google.com/p/protobuf-matlab/
* Mercury: https://code.google.com/p/protobuf-mercury/
* Objective C: https://code.google.com/p/protobuf-objc/
* Objective C: https://github.com/alexeyxo/protobuf-objc
* OCaml: http://piqi.org/
* Perl: http://groups.google.com/group/protobuf-perl
* Perl: https://metacpan.org/pod/Google::ProtocolBuffers
* Perl: https://metacpan.org/pod/Google::ProtocolBuffers::Dynamic
* Perl/XS: https://code.google.com/p/protobuf-perlxs/
* PHP: https://code.google.com/p/pb4php/
* PHP: https://github.com/allegro/php-protobuf/
* PHP: https://github.com/chobie/php-protocolbuffers
* Prolog: http://www.swi-prolog.org/pldoc/package/protobufs.html
* Purescript: https://github.com/xc-jp/purescript-protobuf
* Python: https://github.com/protocolbuffers/protobuf (Google-official implementation)
* Python: https://github.com/eigenein/protobuf
* Python: https://github.com/danielgtaylor/python-betterproto
* R: http://cran.r-project.org/package=RProtoBuf
* Ruby: https://code.google.com/p/ruby-protobuf/
* Ruby: http://github.com/mozy/ruby-protocol-buffers
* Ruby: https://github.com/bmizerany/beefcake/tree/master/lib/beefcake
* Ruby: https://github.com/localshred/protobuf
* Rust: https://github.com/tokio-rs/prost
* Rust: https://github.com/stepancheg/rust-protobuf/
* Rust: https://github.com/tafia/quick-protobuf
* Scala: http://github.com/jeffplaisance/scala-protobuf
* Scala: https://code.google.com/p/protobuf-scala
* Scala: https://github.com/SandroGrzicic/ScalaBuff
* Scala: https://scalapb.github.io
* Solidity: https://github.com/celer-network/pb3-gen-sol
* Swift: https://github.com/alexeyxo/protobuf-swift
* Swift: https://github.com/apple/swift-protobuf/
* Typescript: https://github.com/thesayyn/protoc-gen-ts
* Typescript: https://github.com/pbkit/pbkit
* Vala: https://launchpad.net/protobuf-vala
* Visual Basic: https://code.google.com/p/protobuf-net/

## RPC Implementations

GRPC (http://www.grpc.io/) is Google's RPC implementation for Protocol Buffers. There are other third-party RPC implementations as well.  Some of these actually work with Protocol Buffers service definitions (defined using the `service` keyword in `.proto` files) while others just use Protocol Buffers message objects.

* https://github.com/grpc/grpc (C++, Node.js, Python, Ruby, Objective-C, PHP, C#, Google-official implementation)
* https://zeroc.com/products/ice (Multiple languages)
* https://github.com/protobuf-net/protobuf-net (C#/.NET/WCF/VB)
* http://www.deltavsoft.com/doc/_external_serialization.html#Protobufs (C++)
* https://protojure.github.io (Clojure)
* https://code.google.com/p/protobuf-rpc-pro/ (Java)
* https://github.com/baidu/sofa-pbrpc (C++)
* https://github.com/madhon/protobuf-csharp-rpc (C#)
* https://github.com/madwyn/libpbrpc (C++)
* https://github.com/SeriousMa/grpc-protobuf-validation (Java)
* https://github.com/elixir-grpc/grpc (Elixir)
* https://github.com/johanbrandhorst/protobuf (GopherJS)
* https://github.com/awakesecurity/gRPC-haskell (Haskell)
* https://github.com/Yeolar/raster (C++)
* https://github.com/jnordberg/wsrpc (JavaScript Node.js/Browser)
* https://github.com/pbkit/npm-packages/blob/main/frpc-test/src/index.spec.ts (TypeScript Node.js/Browser)
* https://github.com/ppissias/xsrpcj (Java)
* https://github.com/twitchtv/twirp (Multiple languages)

Inactive:

* https://launchpad.net/txprotobuf/ (Python)
* https://github.com/modeswitch/protobuf-rpc (Python)
* https://github.com/sdeo/protobuf-socket-rpc (Java, Python)
* https://code.google.com/p/proto-streamer/ (Java)
* https://code.google.com/p/server1/ (C++)
* https://code.google.com/p/protobuf-mina-rpc/ (Python client, Java server)
* https://code.google.com/p/casocklib/ (C++)
* https://code.google.com/p/cxf-protobuf/ (Java)
* https://code.google.com/p/protobuf-remote/ (C++/C#)
* https://code.google.com/p/eneter-protobuf-serializer/ (Java/.NET)
* https://github.com/robbinfan/claire/tree/master/protorpc (C++)
* https://github.com/ebencheung/arab (C++)
* https://code.google.com/p/protobuf-csharp-rpc/ (C#)
* https://github.com/thesamet/rpcz (C++/Python, based on ZeroMQ)
* https://github.com/w359405949/libmaid (C++, Python)

## Other Utilities

There are miscellaneous other things you may find useful as a Protocol Buffers developer.

* [Bazel Build](https://bazel.build)
    * [rules_closure](https://github.com/bazelbuild/rules_closure) `js-closure`
    * [rules_go](https://github.com/bazelbuild/rules_go) `go`
    * [rules_protobuf](https://github.com/pubref/rules_protobuf) `java` `c++` `c#` `go` `js-closure` `js-node` `python` `ruby`
* [NetBeans IDE plugin](https://code.google.com/p/protobuf-netbeans-plugin/)
* [Wireshark/Ethereal packet sniffer plugin](https://code.google.com/p/protobuf-wireshark/)
* [Alternate encodings (JSON, XML, HTML) for Java protobufs](https://code.google.com/p/protobuf-java-format/)
* [Another JSON encoder/decoder for Java](https://github.com/sijuv/protobuf-codec)
* [Editor for serialized protobufs](https://code.google.com/p/protobufeditor/)
* [IntelliJ IDEA plugin](http://github.com/jvolkman/intellij-protobuf-editor)
* [IntelliJ Protobuf Plugin](https://github.com/devkanro/intellij-protobuf-plugin)
* [TextMate syntax highlighting](http://github.com/michaeledgar/protobuf-tmbundle)
* [Oracle PL SQL plugin](https://code.google.com/p/protocol-buffer-plsql/)
* [Eclipse editor for protobuf (from Google)](https://code.google.com/p/protobuf-dt/)
* [C++ Builder compatible protobuf](https://github.com/saadware/protobuf-cppbuilder)
* Maven Protobuf Compiler Plugin
    * By xolstice.org ([Documentation](https://www.xolstice.org/protobuf-maven-plugin/)) ([Source](https://github.com/xolstice/protobuf-maven-plugin/)) [![Maven Central](https://img.shields.io/maven-central/v/org.xolstice.maven.plugins/protobuf-maven-plugin.svg)](https://repo1.maven.org/maven2/org/xolstice/maven/plugins/protobuf-maven-plugin/)
    * https://code.google.com/p/maven-protoc-plugin/
    * https://github.com/os72/protoc-jar-maven-plugin
* [Documentation generator plugin (Markdown/HTML/DocBook/...)](https://github.com/pseudomuto/protoc-gen-doc)
* [DocBook generator for .proto files](https://code.google.com/p/protoc-gen-docbook/)
* [Protobuf for nginx module](https://github.com/dbcode/protobuf-nginx/)
* [RSpec matchers and Cucumber step defs for testing Protocol Buffers](https://github.com/connamara/protobuf_spec)
* [Sbt plugin for Protocol Buffers](https://github.com/Atry/sbt-cppp)
* [Protobuf Plugin for Gradle](https://github.com/google/protobuf-gradle-plugin)
* [Multi-platform executable JAR and Java API for protoc](https://github.com/os72/protoc-jar)
* [Python scripts to convert between Protocol Buffers and JSON](https://github.com/NextTuesday/py-pb-converters)
* [Visual Studio Language Service support for Protocol Buffers](http://visualstudiogallery.msdn.microsoft.com/4bc0f38c-b058-4e05-ae38-155e053c19c5)
* [Visual Studio Code Support for Protocol Buffers](https://marketplace.visualstudio.com/items?itemName=zxh404.vscode-proto3)
* [C++ library for serialization/de-serialization between Protocol Buffers and JSON.](https://github.com/yinqiwen/pbjson)
* [ProtoBuf with Java EE7 Expression Language 3.0; pure Java ProtoBuf Parser and Builder.](https://github.com/protobufel/protobuf-el)
* [Notepad++ Syntax Highlighting for .proto files](https://github.com/chai2010/notepadplus-protobuf)
* [Linter for .proto files](https://github.com/ckaznocha/protoc-gen-lint)
* [Protocol Buffers Dynamic Schema - create protobuf schemas programmatically (Java)](https://github.com/os72/protobuf-dynamic)
* [Make protoc plugins in NodeJS](https://github.com/konsumer/node-protoc-plugin)
* [ProfaneDB - A Protocol Buffers database](https://profanedb.gitlab.io)
* [Protocol Buffer property-based testing utility and example message generator (Python / Hypothesis)](https://github.com/CurataEng/hypothesis-protobuf)
* [Protolock - CLI utility to prevent backward-incompatible changes to .proto files](https://github.com/nilslice/protolock)
* [Optional GRPC - GRPC for testable microservices (Python)](https://github.com/mattpaletta/optional-grpc.git)
* [Protobuf Parser - Yet another Go package which parses a Protocol Buffer file (proto2+proto3)](https://github.com/yoheimuta/go-protoparser)
* [Protolint - A tool to enforce Protocol Buffer style and conventions.](https://github.com/yoheimuta/protolint)
    * [vscode-protolint: A protobuf linter for visual studio code](https://github.com/plexsystems/vscode-protolint)
    * [intellij-protolint: A protobuf linter for JetBrains IDEs](https://github.com/yoheimuta/intellij-protolint)
    * [vim-protolint: A protobuf linter for Vim](https://github.com/yoheimuta/vim-protolint)
* [super-linter: Protocol Buffer lint as GitHub Action](https://github.com/github/super-linter)
* [protoc-gen-fieldmask - A plugin to generate static type fieldmask paths](https://github.com/idodod/protoc-gen-fieldmask)
