/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.AdditionalMeasureProducer;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class PerformanceStats
implements AdditionalMeasureProducer,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = -7215110351388368092L;
    protected int m_NumQueries;
    public double m_MinP;
    public double m_MaxP;
    public double m_SumP;
    public double m_SumSqP;
    public double m_PointCount;
    public double m_MinC;
    public double m_MaxC;
    public double m_SumC;
    public double m_SumSqC;
    public double m_CoordCount;

    public PerformanceStats() {
        this.reset();
    }

    public void reset() {
        this.m_NumQueries = 0;
        this.m_PointCount = 0.0;
        this.m_SumSqP = 0.0;
        this.m_SumP = 0.0;
        this.m_MinP = 2.147483647E9;
        this.m_MaxP = -2.147483648E9;
        this.m_CoordCount = 0.0;
        this.m_SumSqC = 0.0;
        this.m_SumC = 0.0;
        this.m_MinC = 2.147483647E9;
        this.m_MaxC = -2.147483648E9;
    }

    public void searchStart() {
        this.m_PointCount = 0.0;
        this.m_CoordCount = 0.0;
    }

    public void searchFinish() {
        ++this.m_NumQueries;
        this.m_SumP += this.m_PointCount;
        this.m_SumSqP += this.m_PointCount * this.m_PointCount;
        if (this.m_PointCount < this.m_MinP) {
            this.m_MinP = this.m_PointCount;
        }
        if (this.m_PointCount > this.m_MaxP) {
            this.m_MaxP = this.m_PointCount;
        }
        double coordsPerPt = this.m_CoordCount / this.m_PointCount;
        this.m_SumC += coordsPerPt;
        this.m_SumSqC += coordsPerPt * coordsPerPt;
        if (coordsPerPt < this.m_MinC) {
            this.m_MinC = coordsPerPt;
        }
        if (coordsPerPt > this.m_MaxC) {
            this.m_MaxC = coordsPerPt;
        }
    }

    public void incrPointCount() {
        this.m_PointCount += 1.0;
    }

    public void incrCoordCount() {
        this.m_CoordCount += 1.0;
    }

    public void updatePointCount(int n) {
        this.m_PointCount += (double)n;
    }

    public int getNumQueries() {
        return this.m_NumQueries;
    }

    public double getTotalPointsVisited() {
        return this.m_SumP;
    }

    public double getMeanPointsVisited() {
        return this.m_SumP / (double)this.m_NumQueries;
    }

    public double getStdDevPointsVisited() {
        return Math.sqrt((this.m_SumSqP - this.m_SumP * this.m_SumP / (double)this.m_NumQueries) / (double)(this.m_NumQueries - 1));
    }

    public double getMinPointsVisited() {
        return this.m_MinP;
    }

    public double getMaxPointsVisited() {
        return this.m_MaxP;
    }

    public double getTotalCoordsPerPoint() {
        return this.m_SumC;
    }

    public double getMeanCoordsPerPoint() {
        return this.m_SumC / (double)this.m_NumQueries;
    }

    public double getStdDevCoordsPerPoint() {
        return Math.sqrt((this.m_SumSqC - this.m_SumC * this.m_SumC / (double)this.m_NumQueries) / (double)(this.m_NumQueries - 1));
    }

    public double getMinCoordsPerPoint() {
        return this.m_MinC;
    }

    public double getMaxCoordsPerPoint() {
        return this.m_MaxC;
    }

    public Enumeration enumerateMeasures() {
        Vector<String> newVector = new Vector<String>();
        newVector.addElement("measureTotal_points_visited");
        newVector.addElement("measureMean_points_visited");
        newVector.addElement("measureStdDev_points_visited");
        newVector.addElement("measureMin_points_visited");
        newVector.addElement("measureMax_points_visited");
        newVector.addElement("measureTotalCoordsPerPoint");
        newVector.addElement("measureMeanCoordsPerPoint");
        newVector.addElement("measureStdDevCoordsPerPoint");
        newVector.addElement("measureMinCoordsPerPoint");
        newVector.addElement("measureMaxCoordsPerPoint");
        return newVector.elements();
    }

    public double getMeasure(String additionalMeasureName) throws IllegalArgumentException {
        if (additionalMeasureName.compareToIgnoreCase("measureTotal_points_visited") == 0) {
            return this.getTotalPointsVisited();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureMean_points_visited") == 0) {
            return this.getMeanPointsVisited();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureStdDev_points_visited") == 0) {
            return this.getStdDevPointsVisited();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureMin_points_visited") == 0) {
            return this.getMinPointsVisited();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureMax_points_visited") == 0) {
            return this.getMaxPointsVisited();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureTotalCoordsPerPoint") == 0) {
            return this.getTotalCoordsPerPoint();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureMeanCoordsPerPoint") == 0) {
            return this.getMeanCoordsPerPoint();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureStdDevCoordsPerPoint") == 0) {
            return this.getStdDevCoordsPerPoint();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureMinCoordsPerPoint") == 0) {
            return this.getMinCoordsPerPoint();
        }
        if (additionalMeasureName.compareToIgnoreCase("measureMaxCoordsPerPoint") == 0) {
            return this.getMaxCoordsPerPoint();
        }
        throw new IllegalArgumentException(additionalMeasureName + " not supported by PerformanceStats.");
    }

    public String getStats() {
        StringBuffer buf = new StringBuffer();
        buf.append("           min, max, total, mean, stddev\n");
        buf.append("Points:    " + this.getMinPointsVisited() + ", " + this.getMaxPointsVisited() + "," + this.getTotalPointsVisited() + "," + this.getMeanPointsVisited() + ", " + this.getStdDevPointsVisited() + "\n");
        return buf.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

