# Power Calibrate

Power-calibrate calibrates the power consumption of a mobile device that has a battery power source. It will attempt to calculate the power usage of 1% of CPU utiltisation and 1 context switch.

# Example:

```
$ power-calibrate -p -s 11 -d 20 -r 60 -R 
  CPU load  User   Sys  Idle  Run  Ctxt/s  IRQ/s  Ops/s Cycl/s Inst/s  Watts
    0% x 1   0.5   1.4  96.3  1.1   372.7  108.8   0.0    2.1K 370.4   3.039
    0% x 2   0.2   0.0  99.7  1.0   104.2   36.9   0.0    5.3K   0.7K  2.230
    0% x 3   0.1   0.0  99.9  1.0    96.2   29.7   0.0    7.7K   1.3K  2.196
    0% x 4   0.2   0.0  99.8  1.0   113.3   35.9   0.0   11.9K   1.6K  2.237
   10% x 1   2.4   0.0  97.6  1.0   135.9   72.4  21.0M 121.4M 294.2M  2.455
   10% x 2   5.0   0.1  94.9  1.2   170.1  121.4  32.3M 240.9M 452.4M  2.518
   10% x 3   7.5   0.1  92.4  1.3   197.7  158.9  53.1M 362.7M   0.7B  2.731
   10% x 4  10.1   0.1  89.9  1.4   235.2  203.1  69.8M 485.5M   1.0B  2.874
   20% x 1   5.0   0.1  94.9  1.3   221.5  148.2  66.0M 381.5M   0.9B  2.988
   20% x 2  10.1   0.3  89.6  1.4   365.9  273.9 135.1M   1.1B   1.9B  3.688
   20% x 3  14.8   0.2  85.0  1.4   569.8  419.1 237.5M   1.7B   3.3B  4.944
   20% x 4  20.2   0.2  79.6  1.9   666.1  524.8 286.3M   2.3B   4.0B  4.972
   30% x 1   7.4   0.0  92.6  1.3   314.1  215.9 109.4M   0.6B   1.5B  3.477
   30% x 2  14.5   0.2  85.3  1.9   507.7  389.6 204.8M   1.7B   2.9B  4.343
   30% x 3  22.6   0.3  77.2  2.0   822.2  627.2 363.3M   2.6B   5.1B  6.357
   30% x 4  29.8   0.4  69.8  1.9   972.4  774.9 440.9M   3.4B   6.2B  6.338
   40% x 1   9.9   0.2  89.9  1.4   459.4  314.8 179.5M   1.0B   2.5B  4.563
   40% x 2  20.2   0.3  79.6  1.9   645.8  516.2 275.9M   2.3B   3.9B  5.134
   40% x 3  29.8   0.3  69.9  1.9  1059.4  817.9 480.6M   3.5B   6.7B  7.577
   40% x 4  40.1   0.5  59.4  2.8  1207.6 1007.1   0.6B   4.6B   7.8B  7.015
   50% x 1  12.2   0.1  87.7  1.4   483.2  352.2 194.0M   1.1B   2.7B  4.553
   50% x 2  24.7   0.3  75.1  2.1   797.0  641.4 351.6M   2.9B   4.9B  6.106
   50% x 3  36.4   0.4  63.2  2.3  1260.1  987.2   0.6B   4.2B   8.1B  8.462
   50% x 4  49.5   0.7  49.8  2.3  1473.9 1231.5   0.7B   5.7B   9.7B  8.083
   60% x 1  14.7   0.2  85.0  1.6   696.0  483.1 297.2M   1.7B   4.2B  6.698
   60% x 2  29.4   0.4  70.3  2.3   936.1  758.8 420.0M   3.5B   5.9B  6.871
   60% x 3  44.2   0.3  55.5  2.9  1513.2 1198.4   0.7B   5.1B  10.0B  9.687
   60% x 4  58.6   0.7  40.6  3.3  1740.3 1452.9   0.8B   6.7B  11.5B  9.192
   70% x 1  16.8   0.3  83.0  1.7   788.0  552.2 345.8M   2.0B   4.8B  7.504
   70% x 2  33.8   0.4  65.8  2.5  1002.5  837.1 456.2M   3.8B   6.4B  6.904
   70% x 3  49.1   0.4  50.5  3.1  1723.0 1333.5   0.8B   5.9B  11.4B 10.545
   70% x 4  68.3   0.5  31.2  3.4  1971.1 1656.7   0.9B   7.4B  13.2B 10.050
   80% x 1  19.4   0.3  80.3  1.9   888.0  632.4 393.6M   2.3B   5.5B  8.243
   80% x 2  39.2   0.4  60.4  2.7  1205.3  996.3   0.6B   4.6B   7.8B  8.452
   80% x 3  59.1   0.4  40.5  3.5  2012.2 1603.4   0.9B   6.8B  13.3B 11.767
   80% x 4  78.5   0.6  20.9  4.2  2426.5 2004.6   1.2B   9.0B  16.2B 12.467
   90% x 1  21.9   0.2  77.9  2.0   994.8  706.9 446.5M   2.6B   6.3B  8.944
   90% x 2  44.3   0.2  55.5  2.8  1355.9 1121.2   0.6B   5.2B   8.8B  9.226
   90% x 3  66.1   0.6  32.7  3.8  2297.8 1807.9   1.1B   7.6B  14.9B 12.690
   90% x 4  87.5   1.3  11.0  4.6  2814.5 2262.2   1.3B  10.0B  17.8B 13.465
  100% x 1  25.0   0.0  75.0  2.0   101.9  293.6   0.5B   3.1B   7.5B 10.222
  100% x 2  50.0   0.0  50.0  3.0    93.9  550.4   0.7B   6.2B  10.4B 10.397
  100% x 3  75.1   0.0  24.9  4.0    82.2  793.5   1.2B   8.7B  16.8B 12.889
  100% x 4 100.0   0.0   0.0  5.0    77.8 1038.9   1.4B  11.6B  19.5B 13.132

For 4 CPUs (of a 4 CPU system):
  Power (Watts) = (% CPU load * 1.226129e-01) + 3.187491
  1% CPU load is about 122.61 mW
  Coefficient of determination R^2 = 0.849442 (good)

  Energy (Watt-seconds) = (bogo op * 8.666398e-09) + 2.972347
  1 bogo op is about 8.67 nWs
  Coefficient of determination R^2 = 0.930446 (strong)

  Energy (Watt-seconds) = (CPU cycle * 1.061961e-09) + 3.281099
  1 CPU cycle is about 1.06 nWs
  Coefficient of determination R^2 = 0.871018 (good)

  Energy (Watt-seconds) = (CPU instruction * 6.188774e-10) + 2.972191
  1 CPU instruction is about 0.62 nWs
  Coefficient of determination R^2 = 0.930441 (strong)
```
