/*
 * Decompiled with CFR 0.152.
 */
package com.sixlegs.png;

import com.sixlegs.png.Destination;
import java.awt.Rectangle;
import java.awt.image.WritableRaster;

final class SourceRegionDestination
extends Destination {
    private final Destination dst;
    private final int xoff;
    private final int yoff;
    private final int xlen;
    private final int ylen;
    private final int samples;

    public SourceRegionDestination(Destination dst, Rectangle sourceRegion) {
        this.dst = dst;
        this.xoff = sourceRegion.x;
        this.yoff = sourceRegion.y;
        this.xlen = sourceRegion.width;
        this.ylen = sourceRegion.height;
        this.samples = dst.getRaster().getNumBands();
    }

    public void setPixels(int x, int y, int w, int[] pixels) {
        if (y >= this.yoff && y < this.yoff + this.ylen) {
            int newx = Math.max(x, this.xoff);
            int neww = Math.min(x + w, this.xoff + this.xlen) - newx;
            if (neww > 0) {
                if (newx > x) {
                    System.arraycopy(pixels, newx * this.samples, pixels, 0, neww * this.samples);
                }
                this.dst.setPixels(newx - this.xoff, y - this.yoff, neww, pixels);
            }
        }
    }

    public void setPixel(int x, int y, int[] pixel) {
        if ((x -= this.xoff) >= 0 && (y -= this.yoff) >= 0 && x < this.xlen && y < this.ylen) {
            this.dst.setPixel(x, y, pixel);
        }
    }

    public void getPixel(int x, int y, int[] pixel) {
        throw new UnsupportedOperationException();
    }

    public WritableRaster getRaster() {
        return this.dst.getRaster();
    }

    public int getSourceWidth() {
        return this.dst.getSourceWidth();
    }

    public void done() {
        this.dst.done();
    }
}

