# How to contribute

We are really glad you are reading this, because we need volunteer developers to help this project.

If you have not already, come find us in [![Join the chat at https://gitter.im/pgRouting/pgrouting](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/pgRouting/pgrouting?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge) or contact us via [mailing list](http://lists.osgeo.org/mailman/listinfo/pgrouting-dev). We want you working on things you're excited about. Drop a message and if some one can assist you, will contact you back ASAP.

Here are some important resources:

  * [pgRouting for Developers](http://docs.pgrouting.org/doxy/2.4/index.html) has the internals C/C++ code information,
  * [Wish list on the wiki](https://github.com/pgRouting/pgrouting/wiki/GSoC-Ideas) is the foot view of what we think the community needs.
  * [Additional wish lst](https://github.com/pgRouting/pgrouting/issues?q=is%3Aopen+is%3Aissue+label%3A%22Functionality+Request%22). (TODO to move the information to the wiki wish list)
  * Participate on the [discussions](https://github.com/pgRouting/pgrouting/issues?q=is%3Aopen+is%3Aissue+label%3ADiscussion).
  * Participate fixing [Documentation](https://github.com/pgRouting/pgrouting/issues?q=is%3Aopen+is%3Aissue+label%3ADocumentation).
  * Find a bug? [Let us know](https://github.com/pgRouting/pgrouting/issues).

## Contribution agreement

Any kind of contribution will automatically fall to the following Licences:

- Code contribution: GNU General Public License v2.0 or later,
  - Directly by making a pul explicit pull request.
  - Indirectly by posting code on issues/wiki/gitter/mailng lists
- Documentation contribution:
  - Creative Commons Attribution-Share Alike 3.0

## Submitting changes


Write a clear log message for your commits. One-line messages are fine for small changes, but bigger changes should have more information.
Fill the commit message template.

## Coding conventions

Start reading our code and you'll get the hang of it. We optimize for readability:
This is open source software. Consider the people who will read your code, and make it look nice for them.

  * We indent using four spaces (soft tabs)
  * We use cpplint for linting C/C++ code.

Thanks,
pgRouting team

