#!/bin/sh

eval `grep '^HPDF_EXTRA_VERSION=' configure.in`
case "$HPDF_EXTRA_VERSION" in
  *dev)
    rebuildok=1
    ;;
  *)
    rebuildok=0
    ;;
esac

cvsclean=0

while test $# -gt 0; do
  if test "$1" = "--force"; then
    rebuildok=1
    echo "Forcing buildconf"
  fi
  if test "$1" = "--clean"; then
    cvsclean=1
  fi
  shift
done

if test "$rebuildok" = "0"; then
  echo "You should not run buildconf in a release package."
  echo "use buildconf --force to override this check."
  exit 1
fi

if test "$cvsclean" = "1"; then
	echo "Cleaning autogenerated files"
	${MAKE:-make} -s -f build.mk cvsclean
else 
	${MAKE:-make} -s -f build.mk
fi

