/* copyleft (c) 2003-2021 forum::für::umläute -- IOhannes m zmölnig @ IEM
 * based on d_delay.c from pd:
 * Copyright (c) 1997-1999 Miller Puckette.
 * For information on usage and redistribution, and for a DISCLAIMER OF ALL
 * WARRANTIES, see the file, "LICENSE.txt," in this distribution.  */


#define IEM16_INTERNAL
#include "iem16_delay.h"

#ifdef __m_imp_h_
# define HAVE_CLASS_STRUCT
#endif

t_class *sigdel16write_class;

/* routine to check that all del16writes/del16reads/vds have same vecsize */
void sigdel16write_checkvecsize(t_sigdel16write *x, int vecsize){
  if (x->x_rsortno != ugen_getsortno())    {
    x->x_vecsize = vecsize;
    x->x_rsortno = ugen_getsortno();
  }
  else if (vecsize != x->x_vecsize) {
    const char*objname="del16read/del16write/vd";
#ifdef HAVE_CLASS_STRUCT
    t_object*obj=&x->x_obj;
    objname = obj->te_g.g_pd->c_name->s_name;
#endif
    pd_error(x, "%s vector size mismatch", objname);
  }
}
