# norootforbuild
# neededforbuild gwenhywfar gwenhywfar-devel python python-ctypes pyyxml libchipcard2-devel libchipcard2 pkgconfig gettext-devel libacl-devel libacl libattr-devel libattr

%define name aqbanking
%define version 6.7.14beta

%define dist    Debian
%define disttag debian
%define distver 

%define aq_plugindir   %{_libdir}/aqbanking/plugins/44
%define fronts_libdir  %{aq_plugindir}/frontends
%define imex_plugindir %{aq_plugindir}/imexporters
%define imex_datadir   %{_datadir}/%{name}/imexporters
%define fronts_datadir %{_datadir}/%{name}/frontends
%define qb_cfgmoddir   %{fronts_libdir}/qbanking/cfgmodules

### Optionally disable chipcard and ofx sub-packages - resulting
### rpms should not be released!
%define have_libchipcard 0
%define have_libofx      1
%define with_yellownet   0


# Note: There is not yet a special symbol for the rpm release
# version. We set it to one here.
%define release 1.%{disttag}%{distver}

### Choose backends to be built
%if %have_libofx
%if %have_libchipcard
%if %with_yellownet
%define backendlist "aqhbci aqofxconnect aqyellownet"
%else
%define backendlist "aqhbci aqofxconnect"
%endif
%else
%if %with_yellownet
%define backendlist "aqhbci aqofxconnect aqyellownet"
%else
%define backendlist "aqhbci aqofxconnect"
%endif
%endif
%else
%if %have_libchipcard
%if %with_yellownet
%define backendlist "aqhbci aqyellownet"
%else
%define backendlist "aqhbci"
%endif
%else
%if %with_yellownet
%define backendlist "aqhbci aqyellownet"
%else
%define backendlist "aqhbci"
%endif
%endif
%endif

# versions of required helper-libraries
%define _gwenhywfar_version   2.9.15
%define _libchipcard3_version 3.9.13


### The standard information fields.
Name:          %{name}
Summary:       A library for online banking functions and financial data import/export
Version:       %{version}
Release:       %{release}
Source:        http://download.sourceforge.net/aqbanking/%{name}-%{version}.tar.gz
Group:         System Environment/Libraries
License:       GPL
Packager:      Martin Preuss <martin@aquamaniac.de>
URL:           http://sourceforge.net/projects/aqbanking
BuildRoot:     %{_tmppath}/%{name}-%{version}-root
Requires:      gwenhywfar >= %{_gwenhywfar_version}
BuildRequires: gwenhywfar-devel >= %{_gwenhywfar_version}
#BuildRequires: python-ctypes
BuildRequires: python >= 2.3
BuildRequires: pyxml
BuildRequires: pkgconfig >= 0.9
#BuildRequires: gettext-devel
#BuildRequires: libacl-devel
#BuildRequires: libattr-devel
Prefix:        %{_prefix}
Obsoletes:     aqdtaus
Obsoletes:     aqhbci
Obsoletes:     kbanking
Obsoletes:     aqofxconnect

%description
The intention of AqBanking is to provide a middle layer between
the program and the various Online Banking libraries
(e.g. AqHBCI). The first backend which is already supported is
AqHBCI, a library which implements a client for the German HBCI
(Home Banking Computer Interface) protocol. Additionally,
Aqbanking provides various plugins to simplify import and export
of financial data. Currently there are import plugins for the
following formats: DTAUS (German financial format), SWIFT (MT940
and MT942). Further information in German can be found on
http://linuxwiki.de/AqBanking


%package devel
Summary:   Aqbanking development kit
Group:     Development/Libraries/C and C++
Requires:  %{name} = %{version}
Obsoletes: aqhbci-devel
Obsoletes: aqofxconnect-devel
Obsoletes: aqdtaus-devel
%description devel
This package contains aqbanking-config and header files for writing and
compiling programs using Aqbanking.

%package -n python-%{name}
Summary:  Aqbanking python-bindings
Group:    Development/Libraries/Python
%py_requires
Requires: %{name} = %{version}
#Requires: python-ctypes
Requires: python >= 2.3
Requires: pyxml

%description -n python-%{name}
This package contains the python-bindings for aqbanking.

%package    qt3
Summary:    Aqbanking tools for Qt3
Group:      Productivity/Office/Finance
Obsoletes:  aqhbci-qt-tools
Obsoletes:  aqdtaus-qt-tools
Requires:   %{name} = %{version}
Requires:   gwenhywfar >= %{_gwenhywfar_version}

%description qt3
This package contains the QT3 setup wizard for AqBanking.

### Sub-packages for OFX
%if %have_libofx
%package       ofx
Summary:       Aqbanking tools for Qt3
Group:         Development/Libraries/C and C++
Requires:      %{name} = %{version}
Obsoletes:     %{name}-ofx-qt3

%description ofx
Aqbanking tools for Qt3. Necessary for OFX direct connect access.

Author: Martin Preuss <martin@libchipcard.de>

%package    ofx-qt3
Summary:    Aqbanking tools for Qt3
Group:      Development/Libraries/C and C++
Requires:   %{name} = %{version}
Requires:   gwenhywfar >= %{_gwenhywfar_version}

%description ofx-qt3
Aqbanking tools for Qt3. Necessary for OFX direct connect access.

Author: Martin Preuss <martin@libchipcard.de>
%endif


### Sub-packages for yellownet
%if %with_yellownet
%package       yellownet
Summary:       YellowNet backend
Group:         Development/Libraries/C and C++
Requires:      %{name} = %{version}

%description yellownet
This backend provides support for Suisse YellowNet (Post-Finance)

Author: Martin Preuss <martin@libchipcard.de>

%package       yellownet-qt3
Summary:       Configuration plugins for Aqbanking with Qt3
Group:         Development/Libraries/C and C++
Requires:      %{name} = %{version}

%description yellownet-qt3
This backend provides support for Suisse YellowNet (Post-Finance)

Author: Martin Preuss <martin@libchipcard.de>
%endif


### The build commands

%prep
%setup -q

%build
%{configure} \
	--enable-release \
	--with-docpath=%{_docdir} \
	--enable-python \
	--with-backends=%{backendlist}
make

%install
[ "$RPM_BUILD_ROOT" != "/" ] && rm -rf $RPM_BUILD_ROOT

make install-strip \
	DESTDIR=%{buildroot} \
	idatadir=%{_docdir}/%{name}

%clean
[ -d %{buildroot} -a "%{buildroot}" != "" ] && rm -rf %{buildroot}

%post -p /sbin/ldconfig
%postun -p /sbin/ldconfig

%post -n %{name}-qt3 -p /sbin/ldconfig
%postun -n %{name}-qt3 -p /sbin/ldconfig

### The file list for all packages, starting with the base package
%files
%defattr(-,root,root)
%doc AUTHORS COPYING ChangeLog README
# The directories used by the base package
%dir %{_libdir}/%{name}
%dir %{_libdir}/%{name}/plugins
%dir %{aq_plugindir}
%dir %{aq_plugindir}/debugger
%dir %{aq_plugindir}/providers
%dir %{imex_plugindir}
%dir %{fronts_libdir}
%dir %{fronts_libdir}/qbanking
%dir %{qb_cfgmoddir}
%dir %{_datadir}/%{name}
%dir %{fronts_datadir}
%dir %{imex_datadir}
### The original aqbanking files
%{_libdir}/lib%{name}*.so.*
%{_libdir}/gwenhywfar
%{_datadir}/%{name}/bankinfo
%{_datadir}/locale/*/LC_MESSAGES/%{name}.mo
%{aq_plugindir}/bankinfo
%{imex_plugindir}/csv.*
%{imex_plugindir}/dtaus.*
%{imex_plugindir}/eri2.*
%{imex_plugindir}/openhbci1.*
%{imex_plugindir}/swift.*
%{imex_plugindir}/xmldb.*
%{imex_plugindir}/yellownet.*
%{imex_datadir}/csv
%{imex_datadir}/dtaus
%{imex_datadir}/eri
%{imex_datadir}/eri2
%{imex_datadir}/openhbci1
%{imex_datadir}/swift
%{imex_datadir}/xmldb
%{imex_datadir}/yellownet
### The aqhbci files
%{_bindir}/aqhbci-tool@QBANKING_SO_EFFECTIVE@
%{_libdir}/libaqhbci.so.*
%{aq_plugindir}/providers/aqhbci.*
#%{_datadir}/doc/aqhbci
### The aqnone files
%{_libdir}/libaqnone.so.*
%{aq_plugindir}/providers/aqnone.*
%{_libdir}/libaqgivve.so.*
%{aq_plugindir}/providers/aqgivve.*

%files devel
%defattr(-,root,root)
### The aqbanking files
%{_bindir}/%{name}-config
%{_includedir}/%{name}
%{_libdir}/*.la
%{_libdir}/libaqbanking.so
%{_libdir}/libaqhbci.so
%{_libdir}/libaqnone.so
%{_libdir}/libaqgivve.so
%{_libdir}/pkgconfig/%{name}.pc
%{_datadir}/aclocal
### The aqhbci files
%{_bindir}/hbcixml3
%{_includedir}/aqhbci
%{_datadir}/%{name}/backends/aqhbci
### The qbanking files
%{_includedir}/qbanking

%files -n python-aqbanking
%defattr(644,root,root,755)
%{py_sitedir}/*

%files qt3
%defattr(-,root,root)
%{_bindir}/qb-help@QBANKING_SO_EFFECTIVE@
%{_libdir}/libqbanking.so.*
%{_libdir}/libqbanking.so
%{aq_plugindir}/debugger/aqhbci
%{aq_plugindir}/wizards
%{qb_cfgmoddir}/aqhbci*
%{_datadir}/%{name}/i18n
%{fronts_datadir}/qbanking

%if %have_libofx
%files ofx
%defattr(-,root,root)
%{_libdir}/libaqofxconnect.so.*
%{_libdir}/libaqofxconnect.so
%{_includedir}/aqofxconnect
%{aq_plugindir}/providers/aqofxconnect.*
%{imex_plugindir}/ofx.*
%{imex_datadir}/ofx

%files ofx-qt3
%defattr(-,root,root)
%{qb_cfgmoddir}/aqofxconnect*
%endif

%if %with_yellownet
%files yellownet
%{_libdir}/libaqyellownet.so
%{_includedir}/aqyellownet
%{aq_plugindir}/providers/aqyellownet.*

%files yellownet-qt3
%{qb_cfgmoddir}/aqyellownet*
%endif

