// Copyright 2023 gRPC authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This file is autogenerated: see
// tools/codegen/core/gen_huffman_decompressor.cc

#ifndef GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_8_7_15_H
#define GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_8_7_15_H
#include <grpc/support/port_platform.h>

#include <cstddef>
#include <cstdint>
namespace grpc_core {
namespace geometry_8_7_15 {
class HuffDecoderCommon {
 protected:
  static inline uint64_t GetOp2(size_t i) { return table2_0_ops_[i]; }
  static inline uint64_t GetEmit2(size_t, size_t emit) {
    return table2_0_emit_[emit];
  }
  static inline uint64_t GetOp3(size_t i) { return table3_0_ops_[i]; }
  static inline uint64_t GetEmit3(size_t, size_t emit) {
    return table3_0_emit_[emit];
  }
  static inline uint64_t GetOp4(size_t i) {
    return table4_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit4(size_t i, size_t emit) {
    return table4_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp1(size_t i) {
    return table1_0_inner_[table1_0_outer_[i]];
  }
  static inline uint64_t GetEmit1(size_t, size_t emit) {
    return table1_0_emit_[emit];
  }
  static inline uint64_t GetOp5(size_t i) {
    return (i < 2 ? (i ? 6 : 2) : ((i - 2) ? 14 : 10));
  }
  static inline uint64_t GetEmit5(size_t, size_t emit) {
    return (emit < 2 ? (emit + 33) : ((emit - 2) + 40));
  }
  static inline uint64_t GetOp7(size_t i) {
    return (i < 2 ? (i) : ((i - 2) + 1));
  }
  static inline uint64_t GetEmit7(size_t, size_t emit) {
    return ((void)emit, 63);
  }
  static inline uint64_t GetOp8(size_t i) {
    return table8_0_inner_[table8_0_outer_[i]];
  }
  static inline uint64_t GetEmit8(size_t, size_t emit) {
    return (emit < 2 ? (emit ? 39 : 63) : ((emit - 2) ? 124 : 43));
  }
  static inline uint64_t GetOp9(size_t i) {
    return table9_0_inner_[table9_0_outer_[i]];
  }
  static inline uint64_t GetEmit9(size_t, size_t emit) {
    return table9_0_emit_[emit];
  }
  static inline uint64_t GetOp10(size_t i) { return table10_0_ops_[i]; }
  static inline uint64_t GetEmit10(size_t, size_t emit) {
    return table10_0_emit_[emit];
  }
  static inline uint64_t GetOp11(size_t i) { return table11_0_ops_[i]; }
  static inline uint64_t GetEmit11(size_t, size_t emit) {
    return table11_0_emit_[emit];
  }
  static inline uint64_t GetOp6(size_t i) {
    return table6_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit6(size_t i, size_t emit) {
    return table6_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp13(size_t i) {
    return table13_0_inner_[(i < 3 ? (i) : ((i - 3) / 12 + 3))];
  }
  static inline uint64_t GetEmit13(size_t, size_t emit) {
    return (emit < 1 ? (((void)emit, 92)) : ((emit - 1) ? 208 : 195));
  }
  static inline uint64_t GetOp14(size_t i) { return table14_0_ops_[i]; }
  static inline uint64_t GetEmit14(size_t, size_t emit) {
    return table14_0_emit_[emit];
  }
  static inline uint64_t GetOp15(size_t i) { return table15_0_ops_[i]; }
  static inline uint64_t GetEmit15(size_t, size_t emit) {
    return table15_0_emit_[emit];
  }
  static inline uint64_t GetOp16(size_t i) { return table16_0_ops_[i]; }
  static inline uint64_t GetEmit16(size_t, size_t emit) {
    return table16_0_emit_[emit];
  }
  static inline uint64_t GetOp17(size_t i) {
    return table17_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit17(size_t i, size_t emit) {
    return table17_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp18(size_t i) {
    return table18_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit18(size_t i, size_t emit) {
    return table18_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp19(size_t i) {
    return table19_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit19(size_t i, size_t emit) {
    return table19_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp20(size_t i) {
    return table20_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit20(size_t i, size_t emit) {
    return table20_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp21(size_t i) {
    return table21_ops_[i >> 6][i & 0x3f];
  }
  static inline uint64_t GetEmit21(size_t i, size_t emit) {
    return table21_emit_[i >> 6][emit];
  }
  static inline uint64_t GetOp22(size_t i) {
    return table22_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit22(size_t i, size_t emit) {
    return table22_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp23(size_t i) {
    return table23_ops_[i >> 7][i & 0x7f];
  }
  static inline uint64_t GetEmit23(size_t i, size_t emit) {
    return table23_emit_[i >> 7][emit];
  }
  static inline uint64_t GetOp12(size_t i) {
    return table12_ops_[i >> 8][i & 0xff];
  }
  static inline uint64_t GetEmit12(size_t i, size_t emit) {
    return table12_emit_[i >> 8][emit];
  }

 private:
  static const uint8_t table2_0_emit_[10];
  static const uint8_t table2_0_ops_[32];
  static const uint8_t table3_0_emit_[36];
  static const uint8_t table3_0_ops_[64];
  static const uint8_t table4_0_emit_[22];
  static const uint8_t table4_0_ops_[64];
  static const uint8_t table4_1_emit_[46];
  static const uint8_t table4_1_ops_[64];
  static const uint8_t* const table4_emit_[2];
  static const uint8_t* const table4_ops_[2];
  static const uint8_t table1_0_emit_[74];
  static const uint16_t table1_0_inner_[76];
  static const uint8_t table1_0_outer_[256];
  static const uint8_t table8_0_inner_[6];
  static const uint8_t table8_0_outer_[8];
  static const uint8_t table9_0_emit_[6];
  static const uint8_t table9_0_inner_[8];
  static const uint8_t table9_0_outer_[16];
  static const uint8_t table10_0_emit_[12];
  static const uint8_t table10_0_ops_[32];
  static const uint8_t table11_0_emit_[14];
  static const uint8_t table11_0_ops_[64];
  static const uint8_t table6_0_emit_[3];
  static const uint8_t table6_0_ops_[64];
  static const uint8_t table6_1_emit_[14];
  static const uint8_t table6_1_ops_[64];
  static const uint8_t* const table6_emit_[2];
  static const uint8_t* const table6_ops_[2];
  static const uint8_t table13_0_inner_[5];
  static const uint8_t table14_0_emit_[11];
  static const uint8_t table14_0_ops_[32];
  static const uint8_t table15_0_emit_[24];
  static const uint8_t table15_0_ops_[64];
  static const uint8_t table16_0_emit_[50];
  static const uint8_t table16_0_ops_[128];
  static const uint8_t table17_0_emit_[15];
  static const uint8_t table17_0_ops_[128];
  static const uint8_t table17_1_emit_[64];
  static const uint8_t table17_1_ops_[128];
  static const uint8_t* const table17_emit_[2];
  static const uint8_t* const table17_ops_[2];
  static const uint8_t table18_0_emit_[62];
  static const uint8_t table18_0_ops_[128];
  static const uint8_t table18_1_emit_[10];
  static const uint8_t table18_1_ops_[128];
  static const uint8_t table18_2_emit_[23];
  static const uint8_t table18_2_ops_[128];
  static const uint8_t table18_3_emit_[53];
  static const uint8_t table18_3_ops_[128];
  static const uint8_t* const table18_emit_[4];
  static const uint8_t* const table18_ops_[4];
  static const uint8_t table19_0_emit_[72];
  static const uint16_t table19_0_ops_[64];
  static const uint8_t table19_1_emit_[72];
  static const uint8_t table19_2_emit_[72];
  static const uint8_t table19_3_emit_[40];
  static const uint16_t table19_3_ops_[64];
  static const uint8_t table19_4_emit_[40];
  static const uint8_t table19_5_emit_[40];
  static const uint8_t table19_6_emit_[40];
  static const uint8_t table19_7_emit_[4];
  static const uint16_t table19_7_ops_[64];
  static const uint8_t table19_8_emit_[4];
  static const uint8_t table19_9_emit_[4];
  static const uint8_t table19_10_emit_[7];
  static const uint16_t table19_10_ops_[64];
  static const uint8_t table19_11_emit_[8];
  static const uint16_t table19_11_ops_[64];
  static const uint8_t table19_12_emit_[8];
  static const uint8_t table19_13_emit_[12];
  static const uint16_t table19_13_ops_[64];
  static const uint8_t table19_14_emit_[16];
  static const uint16_t table19_14_ops_[64];
  static const uint8_t table19_15_emit_[21];
  static const uint16_t table19_15_ops_[64];
  static const uint8_t* const table19_emit_[16];
  static const uint16_t* const table19_ops_[16];
  static const uint8_t table20_0_emit_[44];
  static const uint16_t table20_0_ops_[64];
  static const uint8_t table20_1_emit_[92];
  static const uint16_t table20_1_ops_[64];
  static const uint8_t table20_2_emit_[44];
  static const uint8_t table20_3_emit_[92];
  static const uint8_t table20_4_emit_[44];
  static const uint8_t table20_5_emit_[92];
  static const uint8_t table20_6_emit_[72];
  static const uint8_t table20_7_emit_[72];
  static const uint8_t table20_8_emit_[72];
  static const uint8_t table20_9_emit_[72];
  static const uint8_t table20_10_emit_[72];
  static const uint8_t table20_11_emit_[72];
  static const uint8_t table20_12_emit_[72];
  static const uint8_t table20_13_emit_[72];
  static const uint8_t table20_14_emit_[40];
  static const uint8_t table20_15_emit_[40];
  static const uint8_t table20_16_emit_[40];
  static const uint8_t table20_17_emit_[40];
  static const uint8_t table20_18_emit_[40];
  static const uint8_t table20_19_emit_[40];
  static const uint8_t table20_20_emit_[22];
  static const uint16_t table20_20_ops_[64];
  static const uint8_t table20_21_emit_[4];
  static const uint8_t table20_22_emit_[4];
  static const uint8_t table20_23_emit_[4];
  static const uint8_t table20_24_emit_[4];
  static const uint8_t table20_25_emit_[4];
  static const uint8_t table20_26_emit_[4];
  static const uint8_t table20_27_emit_[8];
  static const uint8_t table20_28_emit_[8];
  static const uint8_t table20_29_emit_[8];
  static const uint8_t table20_30_emit_[11];
  static const uint16_t table20_30_ops_[64];
  static const uint8_t table20_31_emit_[25];
  static const uint16_t table20_31_ops_[64];
  static const uint8_t* const table20_emit_[32];
  static const uint16_t* const table20_ops_[32];
  static const uint8_t table21_0_emit_[16];
  static const uint16_t table21_0_ops_[64];
  static const uint8_t table21_1_emit_[28];
  static const uint16_t table21_1_ops_[64];
  static const uint8_t table21_2_emit_[36];
  static const uint16_t table21_2_ops_[64];
  static const uint8_t table21_3_emit_[68];
  static const uint16_t table21_3_ops_[64];
  static const uint8_t table21_4_emit_[16];
  static const uint8_t table21_5_emit_[28];
  static const uint8_t table21_6_emit_[36];
  static const uint8_t table21_7_emit_[68];
  static const uint8_t table21_8_emit_[16];
  static const uint8_t table21_9_emit_[28];
  static const uint8_t table21_10_emit_[36];
  static const uint8_t table21_11_emit_[68];
  static const uint8_t table21_12_emit_[44];
  static const uint8_t table21_13_emit_[92];
  static const uint8_t table21_14_emit_[44];
  static const uint8_t table21_15_emit_[92];
  static const uint8_t table21_16_emit_[44];
  static const uint8_t table21_17_emit_[92];
  static const uint8_t table21_18_emit_[44];
  static const uint8_t table21_19_emit_[92];
  static const uint8_t table21_20_emit_[44];
  static const uint8_t table21_21_emit_[92];
  static const uint8_t table21_22_emit_[44];
  static const uint8_t table21_23_emit_[92];
  static const uint8_t table21_24_emit_[44];
  static const uint8_t table21_25_emit_[92];
  static const uint8_t table21_26_emit_[44];
  static const uint8_t table21_27_emit_[92];
  static const uint8_t table21_28_emit_[72];
  static const uint8_t table21_29_emit_[72];
  static const uint8_t table21_30_emit_[72];
  static const uint8_t table21_31_emit_[72];
  static const uint8_t table21_32_emit_[72];
  static const uint8_t table21_33_emit_[72];
  static const uint8_t table21_34_emit_[72];
  static const uint8_t table21_35_emit_[72];
  static const uint8_t table21_36_emit_[72];
  static const uint8_t table21_37_emit_[72];
  static const uint8_t table21_38_emit_[72];
  static const uint8_t table21_39_emit_[72];
  static const uint8_t table21_40_emit_[72];
  static const uint8_t table21_41_emit_[40];
  static const uint8_t table21_42_emit_[40];
  static const uint8_t table21_43_emit_[40];
  static const uint8_t table21_44_emit_[40];
  static const uint8_t table21_45_emit_[40];
  static const uint8_t table21_46_emit_[40];
  static const uint8_t table21_47_emit_[40];
  static const uint8_t table21_48_emit_[40];
  static const uint8_t table21_49_emit_[40];
  static const uint8_t table21_50_emit_[40];
  static const uint8_t table21_51_emit_[40];
  static const uint8_t table21_52_emit_[40];
  static const uint8_t table21_53_emit_[40];
  static const uint8_t table21_54_emit_[4];
  static const uint8_t table21_55_emit_[4];
  static const uint8_t table21_56_emit_[4];
  static const uint8_t table21_57_emit_[4];
  static const uint8_t table21_58_emit_[4];
  static const uint8_t table21_59_emit_[4];
  static const uint8_t table21_60_emit_[4];
  static const uint8_t table21_61_emit_[7];
  static const uint8_t table21_62_emit_[10];
  static const uint16_t table21_62_ops_[64];
  static const uint8_t table21_63_emit_[34];
  static const uint16_t table21_63_ops_[64];
  static const uint8_t* const table21_emit_[64];
  static const uint16_t* const table21_ops_[64];
  static const uint16_t table22_0_ops_[128];
  static const uint16_t table22_1_ops_[128];
  static const uint16_t table22_2_ops_[128];
  static const uint16_t table22_3_ops_[128];
  static const uint16_t table22_12_ops_[128];
  static const uint8_t table22_13_emit_[104];
  static const uint16_t table22_13_ops_[128];
  static const uint8_t table22_15_emit_[104];
  static const uint8_t table22_17_emit_[104];
  static const uint8_t table22_19_emit_[104];
  static const uint8_t table22_21_emit_[104];
  static const uint8_t table22_23_emit_[104];
  static const uint8_t table22_25_emit_[104];
  static const uint8_t table22_27_emit_[104];
  static const uint8_t table22_28_emit_[136];
  static const uint16_t table22_28_ops_[128];
  static const uint8_t table22_29_emit_[136];
  static const uint8_t table22_30_emit_[136];
  static const uint8_t table22_31_emit_[136];
  static const uint8_t table22_32_emit_[136];
  static const uint8_t table22_33_emit_[136];
  static const uint8_t table22_34_emit_[136];
  static const uint8_t table22_35_emit_[136];
  static const uint8_t table22_36_emit_[136];
  static const uint8_t table22_37_emit_[136];
  static const uint8_t table22_38_emit_[136];
  static const uint8_t table22_39_emit_[136];
  static const uint8_t table22_40_emit_[136];
  static const uint8_t table22_41_emit_[144];
  static const uint16_t table22_41_ops_[128];
  static const uint8_t table22_42_emit_[144];
  static const uint8_t table22_43_emit_[144];
  static const uint8_t table22_44_emit_[144];
  static const uint8_t table22_45_emit_[144];
  static const uint8_t table22_46_emit_[144];
  static const uint8_t table22_47_emit_[144];
  static const uint8_t table22_48_emit_[144];
  static const uint8_t table22_49_emit_[144];
  static const uint8_t table22_50_emit_[144];
  static const uint8_t table22_51_emit_[144];
  static const uint8_t table22_52_emit_[144];
  static const uint8_t table22_53_emit_[144];
  static const uint8_t table22_54_emit_[80];
  static const uint16_t table22_54_ops_[128];
  static const uint8_t table22_55_emit_[80];
  static const uint8_t table22_56_emit_[80];
  static const uint8_t table22_57_emit_[80];
  static const uint8_t table22_58_emit_[80];
  static const uint8_t table22_59_emit_[80];
  static const uint8_t table22_60_emit_[80];
  static const uint8_t table22_61_emit_[26];
  static const uint16_t table22_61_ops_[128];
  static const uint16_t table22_62_ops_[128];
  static const uint8_t table22_63_emit_[63];
  static const uint16_t table22_63_ops_[128];
  static const uint8_t* const table22_emit_[64];
  static const uint16_t* const table22_ops_[64];
  static const uint8_t table23_0_emit_[120];
  static const uint16_t table23_0_ops_[128];
  static const uint8_t table23_1_emit_[120];
  static const uint8_t table23_2_emit_[68];
  static const uint16_t table23_2_ops_[128];
  static const uint8_t table23_3_emit_[16];
  static const uint16_t table23_3_ops_[128];
  static const uint8_t table23_4_emit_[16];
  static const uint8_t table23_5_emit_[20];
  static const uint16_t table23_5_ops_[128];
  static const uint8_t table23_6_emit_[32];
  static const uint16_t table23_6_ops_[128];
  static const uint8_t table23_7_emit_[46];
  static const uint16_t table23_7_ops_[128];
  static const uint8_t table23_8_emit_[120];
  static const uint8_t table23_9_emit_[120];
  static const uint8_t table23_10_emit_[68];
  static const uint8_t table23_11_emit_[16];
  static const uint8_t table23_12_emit_[16];
  static const uint8_t table23_13_emit_[20];
  static const uint8_t table23_14_emit_[32];
  static const uint8_t table23_15_emit_[46];
  static const uint8_t table23_16_emit_[120];
  static const uint8_t table23_17_emit_[120];
  static const uint8_t table23_18_emit_[68];
  static const uint8_t table23_19_emit_[16];
  static const uint8_t table23_20_emit_[16];
  static const uint8_t table23_21_emit_[20];
  static const uint8_t table23_22_emit_[32];
  static const uint8_t table23_23_emit_[46];
  static const uint8_t table23_24_emit_[16];
  static const uint8_t table23_25_emit_[28];
  static const uint16_t table23_25_ops_[128];
  static const uint8_t table23_26_emit_[36];
  static const uint16_t table23_26_ops_[128];
  static const uint8_t table23_27_emit_[68];
  static const uint16_t table23_27_ops_[128];
  static const uint8_t table23_28_emit_[16];
  static const uint8_t table23_29_emit_[28];
  static const uint8_t table23_30_emit_[36];
  static const uint8_t table23_31_emit_[68];
  static const uint8_t table23_32_emit_[16];
  static const uint8_t table23_33_emit_[28];
  static const uint8_t table23_34_emit_[36];
  static const uint8_t table23_35_emit_[68];
  static const uint8_t table23_36_emit_[16];
  static const uint8_t table23_37_emit_[28];
  static const uint8_t table23_38_emit_[36];
  static const uint8_t table23_39_emit_[68];
  static const uint8_t table23_40_emit_[16];
  static const uint8_t table23_41_emit_[28];
  static const uint8_t table23_42_emit_[36];
  static const uint8_t table23_43_emit_[68];
  static const uint8_t table23_44_emit_[16];
  static const uint8_t table23_45_emit_[28];
  static const uint8_t table23_46_emit_[36];
  static const uint8_t table23_47_emit_[68];
  static const uint8_t table23_48_emit_[16];
  static const uint8_t table23_49_emit_[28];
  static const uint8_t table23_50_emit_[36];
  static const uint8_t table23_51_emit_[68];
  static const uint8_t table23_52_emit_[16];
  static const uint8_t table23_53_emit_[28];
  static const uint8_t table23_54_emit_[36];
  static const uint8_t table23_55_emit_[68];
  static const uint8_t table23_56_emit_[44];
  static const uint16_t table23_56_ops_[128];
  static const uint8_t table23_57_emit_[104];
  static const uint16_t table23_57_ops_[128];
  static const uint8_t table23_58_emit_[44];
  static const uint8_t table23_59_emit_[104];
  static const uint8_t table23_60_emit_[44];
  static const uint8_t table23_61_emit_[104];
  static const uint8_t table23_62_emit_[44];
  static const uint8_t table23_63_emit_[104];
  static const uint8_t table23_64_emit_[44];
  static const uint8_t table23_65_emit_[104];
  static const uint8_t table23_66_emit_[44];
  static const uint8_t table23_67_emit_[104];
  static const uint8_t table23_68_emit_[44];
  static const uint8_t table23_69_emit_[104];
  static const uint8_t table23_70_emit_[44];
  static const uint8_t table23_71_emit_[104];
  static const uint8_t table23_72_emit_[44];
  static const uint8_t table23_73_emit_[104];
  static const uint8_t table23_74_emit_[44];
  static const uint8_t table23_75_emit_[104];
  static const uint8_t table23_76_emit_[44];
  static const uint8_t table23_77_emit_[104];
  static const uint8_t table23_78_emit_[44];
  static const uint8_t table23_79_emit_[104];
  static const uint8_t table23_80_emit_[44];
  static const uint8_t table23_81_emit_[104];
  static const uint8_t table23_82_emit_[136];
  static const uint16_t table23_82_ops_[128];
  static const uint8_t table23_83_emit_[136];
  static const uint8_t table23_84_emit_[136];
  static const uint8_t table23_85_emit_[136];
  static const uint8_t table23_86_emit_[136];
  static const uint8_t table23_87_emit_[136];
  static const uint8_t table23_88_emit_[136];
  static const uint8_t table23_89_emit_[136];
  static const uint8_t table23_90_emit_[136];
  static const uint8_t table23_91_emit_[136];
  static const uint8_t table23_92_emit_[136];
  static const uint8_t table23_93_emit_[136];
  static const uint8_t table23_94_emit_[136];
  static const uint8_t table23_95_emit_[136];
  static const uint8_t table23_96_emit_[136];
  static const uint8_t table23_97_emit_[136];
  static const uint8_t table23_98_emit_[136];
  static const uint8_t table23_99_emit_[136];
  static const uint8_t table23_100_emit_[136];
  static const uint8_t table23_101_emit_[136];
  static const uint8_t table23_102_emit_[136];
  static const uint8_t table23_103_emit_[136];
  static const uint8_t table23_104_emit_[136];
  static const uint8_t table23_105_emit_[136];
  static const uint8_t table23_106_emit_[136];
  static const uint8_t table23_107_emit_[136];
  static const uint8_t table23_108_emit_[144];
  static const uint16_t table23_108_ops_[128];
  static const uint8_t table23_109_emit_[144];
  static const uint8_t table23_110_emit_[144];
  static const uint8_t table23_111_emit_[144];
  static const uint8_t table23_112_emit_[144];
  static const uint8_t table23_113_emit_[144];
  static const uint8_t table23_114_emit_[144];
  static const uint8_t table23_115_emit_[144];
  static const uint8_t table23_116_emit_[144];
  static const uint8_t table23_117_emit_[144];
  static const uint8_t table23_118_emit_[144];
  static const uint8_t table23_119_emit_[144];
  static const uint8_t table23_120_emit_[144];
  static const uint8_t table23_121_emit_[144];
  static const uint8_t table23_122_emit_[112];
  static const uint16_t table23_122_ops_[128];
  static const uint8_t table23_123_emit_[80];
  static const uint16_t table23_123_ops_[128];
  static const uint8_t table23_124_emit_[80];
  static const uint8_t table23_125_emit_[44];
  static const uint16_t table23_125_ops_[128];
  static const uint8_t table23_126_emit_[17];
  static const uint16_t table23_126_ops_[128];
  static const uint8_t table23_127_emit_[46];
  static const uint16_t table23_127_ops_[128];
  static const uint8_t* const table23_emit_[128];
  static const uint16_t* const table23_ops_[128];
  static const uint8_t table12_0_emit_[1];
  static const uint16_t table12_0_ops_[256];
  static const uint8_t table12_8_emit_[1];
  static const uint8_t table12_16_emit_[1];
  static const uint8_t table12_24_emit_[1];
  static const uint16_t table12_24_ops_[256];
  static const uint8_t table12_28_emit_[1];
  static const uint8_t table12_32_emit_[1];
  static const uint8_t table12_36_emit_[1];
  static const uint8_t table12_40_emit_[1];
  static const uint8_t table12_44_emit_[1];
  static const uint8_t table12_48_emit_[1];
  static const uint8_t table12_52_emit_[1];
  static const uint8_t table12_56_emit_[1];
  static const uint16_t table12_56_ops_[256];
  static const uint8_t table12_58_emit_[1];
  static const uint8_t table12_60_emit_[1];
  static const uint8_t table12_62_emit_[1];
  static const uint8_t table12_64_emit_[1];
  static const uint8_t table12_66_emit_[1];
  static const uint8_t table12_68_emit_[1];
  static const uint8_t table12_70_emit_[1];
  static const uint8_t table12_72_emit_[1];
  static const uint8_t table12_74_emit_[1];
  static const uint8_t table12_76_emit_[1];
  static const uint8_t table12_78_emit_[1];
  static const uint8_t table12_80_emit_[1];
  static const uint8_t table12_82_emit_[1];
  static const uint16_t table12_82_ops_[256];
  static const uint8_t table12_83_emit_[1];
  static const uint8_t table12_84_emit_[1];
  static const uint8_t table12_85_emit_[1];
  static const uint8_t table12_86_emit_[1];
  static const uint8_t table12_87_emit_[1];
  static const uint8_t table12_88_emit_[1];
  static const uint8_t table12_89_emit_[1];
  static const uint8_t table12_90_emit_[1];
  static const uint8_t table12_91_emit_[1];
  static const uint8_t table12_92_emit_[1];
  static const uint8_t table12_93_emit_[1];
  static const uint8_t table12_94_emit_[1];
  static const uint8_t table12_95_emit_[1];
  static const uint8_t table12_96_emit_[1];
  static const uint8_t table12_97_emit_[1];
  static const uint8_t table12_98_emit_[1];
  static const uint8_t table12_99_emit_[1];
  static const uint8_t table12_100_emit_[1];
  static const uint8_t table12_101_emit_[1];
  static const uint8_t table12_102_emit_[1];
  static const uint8_t table12_103_emit_[1];
  static const uint8_t table12_104_emit_[1];
  static const uint8_t table12_105_emit_[1];
  static const uint8_t table12_106_emit_[1];
  static const uint8_t table12_107_emit_[1];
  static const uint8_t table12_108_emit_[2];
  static const uint16_t table12_108_ops_[256];
  static const uint8_t table12_109_emit_[2];
  static const uint8_t table12_110_emit_[2];
  static const uint8_t table12_111_emit_[2];
  static const uint8_t table12_112_emit_[2];
  static const uint8_t table12_113_emit_[2];
  static const uint8_t table12_114_emit_[2];
  static const uint8_t table12_115_emit_[2];
  static const uint8_t table12_116_emit_[2];
  static const uint8_t table12_117_emit_[2];
  static const uint8_t table12_118_emit_[2];
  static const uint8_t table12_119_emit_[2];
  static const uint8_t table12_120_emit_[2];
  static const uint8_t table12_121_emit_[2];
  static const uint8_t table12_122_emit_[3];
  static const uint16_t table12_122_ops_[256];
  static const uint8_t table12_123_emit_[4];
  static const uint16_t table12_123_ops_[256];
  static const uint8_t table12_124_emit_[4];
  static const uint8_t table12_125_emit_[6];
  static const uint16_t table12_125_ops_[256];
  static const uint16_t table12_126_ops_[256];
  static const uint8_t table12_127_emit_[49];
  static const uint16_t table12_127_ops_[256];
  static const uint8_t* const table12_emit_[128];
  static const uint16_t* const table12_ops_[128];
};
template <typename F>
class HuffDecoder : public HuffDecoderCommon {
 public:
  HuffDecoder(F sink, const uint8_t* begin, const uint8_t* end)
      : sink_(sink), begin_(begin), end_(end) {}
  bool Run() {
    while (!done_) {
      if (!RefillTo8()) {
        Done0();
        break;
      }
      const auto index = (buffer_ >> (buffer_len_ - 8)) & 0xff;
      const auto op = GetOp1(index);
      const int consumed = op & 15;
      buffer_len_ -= consumed;
      const auto emit_ofs = op >> 6;
      switch ((op >> 4) & 3) {
        case 0: {
          sink_(GetEmit1(index, emit_ofs + 0));
          break;
        }
        case 1: {
          DecodeStep0();
          break;
        }
        case 2: {
          DecodeStep1();
          break;
        }
      }
    }
    return ok_;
  }

 private:
  bool RefillTo8() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  bool Read1to8Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      case 7: {
        Fill7();
        return true;
      }
      default: {
        Fill8();
        return true;
      }
    }
  }
  void Fill1() {
    buffer_ = (buffer_ << 8) | (static_cast<uint64_t>(begin_[0]) << 0);
    begin_ += 1;
    buffer_len_ += 8;
  }
  void Fill2() {
    buffer_ = (buffer_ << 16) | (static_cast<uint64_t>(begin_[0]) << 8) |
              (static_cast<uint64_t>(begin_[1]) << 0);
    begin_ += 2;
    buffer_len_ += 16;
  }
  void Fill3() {
    buffer_ = (buffer_ << 24) | (static_cast<uint64_t>(begin_[0]) << 16) |
              (static_cast<uint64_t>(begin_[1]) << 8) |
              (static_cast<uint64_t>(begin_[2]) << 0);
    begin_ += 3;
    buffer_len_ += 24;
  }
  void Fill4() {
    buffer_ = (buffer_ << 32) | (static_cast<uint64_t>(begin_[0]) << 24) |
              (static_cast<uint64_t>(begin_[1]) << 16) |
              (static_cast<uint64_t>(begin_[2]) << 8) |
              (static_cast<uint64_t>(begin_[3]) << 0);
    begin_ += 4;
    buffer_len_ += 32;
  }
  void Fill5() {
    buffer_ = (buffer_ << 40) | (static_cast<uint64_t>(begin_[0]) << 32) |
              (static_cast<uint64_t>(begin_[1]) << 24) |
              (static_cast<uint64_t>(begin_[2]) << 16) |
              (static_cast<uint64_t>(begin_[3]) << 8) |
              (static_cast<uint64_t>(begin_[4]) << 0);
    begin_ += 5;
    buffer_len_ += 40;
  }
  void Fill6() {
    buffer_ = (buffer_ << 48) | (static_cast<uint64_t>(begin_[0]) << 40) |
              (static_cast<uint64_t>(begin_[1]) << 32) |
              (static_cast<uint64_t>(begin_[2]) << 24) |
              (static_cast<uint64_t>(begin_[3]) << 16) |
              (static_cast<uint64_t>(begin_[4]) << 8) |
              (static_cast<uint64_t>(begin_[5]) << 0);
    begin_ += 6;
    buffer_len_ += 48;
  }
  void Fill7() {
    buffer_ = (buffer_ << 56) | (static_cast<uint64_t>(begin_[0]) << 48) |
              (static_cast<uint64_t>(begin_[1]) << 40) |
              (static_cast<uint64_t>(begin_[2]) << 32) |
              (static_cast<uint64_t>(begin_[3]) << 24) |
              (static_cast<uint64_t>(begin_[4]) << 16) |
              (static_cast<uint64_t>(begin_[5]) << 8) |
              (static_cast<uint64_t>(begin_[6]) << 0);
    begin_ += 7;
    buffer_len_ += 56;
  }
  void Fill8() {
    buffer_ = 0 | (static_cast<uint64_t>(begin_[0]) << 56) |
              (static_cast<uint64_t>(begin_[1]) << 48) |
              (static_cast<uint64_t>(begin_[2]) << 40) |
              (static_cast<uint64_t>(begin_[3]) << 32) |
              (static_cast<uint64_t>(begin_[4]) << 24) |
              (static_cast<uint64_t>(begin_[5]) << 16) |
              (static_cast<uint64_t>(begin_[6]) << 8) |
              (static_cast<uint64_t>(begin_[7]) << 0);
    begin_ += 8;
    buffer_len_ += 64;
  }
  bool Read1to7Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      default: {
        Fill7();
        return true;
      }
    }
  }
  void Done0() {
    done_ = true;
    switch (end_ - begin_) {}
    switch (buffer_len_) {
      case 1:
      case 2:
      case 3:
      case 4: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp2(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit2(index, (op >> 2) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp3(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit3(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 7: {
        const auto index = buffer_ & 127;
        const auto op = GetOp4(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit4(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  void DecodeStep0() {
    if (!RefillTo2()) {
      Done1();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 2)) & 0x3;
    const auto op = GetOp5(index);
    const int consumed = op & 3;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 2;
    sink_(GetEmit5(index, emit_ofs + 0));
  }
  bool RefillTo2() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  void Done1() {
    done_ = true;
    switch (buffer_len_) {
      case 1:
      case 0: {
        ok_ = false;
        return;
      }
    }
  }
  void DecodeStep1() {
    if (!RefillTo7()) {
      Done2();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 7)) & 0x7f;
    const auto op = GetOp6(index);
    const int consumed = op & 7;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 4;
    switch ((op >> 3) & 1) {
      case 0: {
        sink_(GetEmit6(index, emit_ofs + 0));
        break;
      }
      case 1: {
        DecodeStep2();
        break;
      }
    }
  }
  bool RefillTo7() {
    switch (buffer_len_) {
      case 0: {
        return Read1to8Bytes();
      }
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6: {
        return Read1to7Bytes();
      }
    }
    return true;
  }
  void Done2() {
    done_ = true;
    switch (buffer_len_) {
      case 1: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 2: {
        const auto index = buffer_ & 3;
        const auto op = GetOp7(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit7(index, (op >> 2) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
      case 3: {
        const auto index = buffer_ & 7;
        const auto op = GetOp8(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit8(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 4: {
        const auto index = buffer_ & 15;
        const auto op = GetOp9(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit9(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp10(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit10(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp11(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit11(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  void DecodeStep2() {
    if (!RefillTo15()) {
      Done3();
      return;
    }
    const auto index = (buffer_ >> (buffer_len_ - 15)) & 0x7fff;
    const auto op = GetOp12(index);
    const int consumed = op & 15;
    buffer_len_ -= consumed;
    const auto emit_ofs = op >> 5;
    switch ((op >> 4) & 1) {
      case 0: {
        sink_(GetEmit12(index, emit_ofs + 0));
        break;
      }
      case 1: {
        begin_ = end_;
        buffer_len_ = 0;
        break;
      }
    }
  }
  bool RefillTo15() {
    switch (buffer_len_) {
      case 0: {
        return Read2to8Bytes();
      }
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6: {
        return Read2to7Bytes();
      }
      case 7:
      case 8: {
        return Read1to7Bytes();
      }
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14: {
        return Read1to6Bytes();
      }
    }
    return true;
  }
  bool Read2to8Bytes() {
    switch (end_ - begin_) {
      case 0:
      case 1: {
        return false;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      case 7: {
        Fill7();
        return true;
      }
      default: {
        Fill8();
        return true;
      }
    }
  }
  bool Read2to7Bytes() {
    switch (end_ - begin_) {
      case 0:
      case 1: {
        return false;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      case 6: {
        Fill6();
        return true;
      }
      default: {
        Fill7();
        return true;
      }
    }
  }
  bool Read1to6Bytes() {
    switch (end_ - begin_) {
      case 0: {
        return false;
      }
      case 1: {
        Fill1();
        return true;
      }
      case 2: {
        Fill2();
        return true;
      }
      case 3: {
        Fill3();
        return true;
      }
      case 4: {
        Fill4();
        return true;
      }
      case 5: {
        Fill5();
        return true;
      }
      default: {
        Fill6();
        return true;
      }
    }
  }
  void Done3() {
    done_ = true;
    switch (end_ - begin_) {
      case 1: {
        Fill1();
        break;
      }
    }
    switch (buffer_len_) {
      case 1:
      case 2:
      case 3: {
        ok_ = (buffer_ & ((1 << buffer_len_) - 1)) == (1 << buffer_len_) - 1;
        return;
      }
      case 4: {
        const auto index = buffer_ & 15;
        const auto op = GetOp13(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit13(index, (op >> 2) + 0));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
        }
        return;
      }
      case 5: {
        const auto index = buffer_ & 31;
        const auto op = GetOp14(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit14(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 6: {
        const auto index = buffer_ & 63;
        const auto op = GetOp15(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit15(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 7: {
        const auto index = buffer_ & 127;
        const auto op = GetOp16(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit16(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 8: {
        const auto index = buffer_ & 255;
        const auto op = GetOp17(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit17(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 9: {
        const auto index = buffer_ & 511;
        const auto op = GetOp18(index);
        switch (op & 3) {
          case 0: {
            sink_(GetEmit18(index, (op >> 2) + 0));
            sink_(GetEmit18(index, (op >> 2) + 1));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit18(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 10: {
        const auto index = buffer_ & 1023;
        const auto op = GetOp19(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit19(index, (op >> 2) + 0));
            sink_(GetEmit19(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit19(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 11: {
        const auto index = buffer_ & 2047;
        const auto op = GetOp20(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit20(index, (op >> 2) + 0));
            sink_(GetEmit20(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit20(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 12: {
        const auto index = buffer_ & 4095;
        const auto op = GetOp21(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit21(index, (op >> 2) + 0));
            sink_(GetEmit21(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit21(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 13: {
        const auto index = buffer_ & 8191;
        const auto op = GetOp22(index);
        switch (op & 3) {
          case 0: {
            ok_ = false;
            break;
          }
          case 1: {
            sink_(GetEmit22(index, (op >> 2) + 0));
            sink_(GetEmit22(index, (op >> 2) + 1));
            break;
          }
          case 2: {
            sink_(GetEmit22(index, (op >> 2) + 0));
            break;
          }
        }
        return;
      }
      case 14: {
        const auto index = buffer_ & 16383;
        const auto op = GetOp23(index);
        switch (op & 7) {
          case 0: {
            sink_(GetEmit23(index, (op >> 3) + 0));
            sink_(GetEmit23(index, (op >> 3) + 1));
            sink_(GetEmit23(index, (op >> 3) + 2));
            break;
          }
          case 1: {
            ok_ = false;
            break;
          }
          case 2: {
            sink_(GetEmit23(index, (op >> 3) + 0));
            sink_(GetEmit23(index, (op >> 3) + 1));
            break;
          }
          case 3: {
            sink_(GetEmit23(index, (op >> 3) + 0));
            break;
          }
        }
        return;
      }
      case 0: {
        return;
      }
    }
  }
  F sink_;
  const uint8_t* begin_;
  const uint8_t* const end_;
  uint64_t buffer_ = 0;
  int buffer_len_ = 0;
  bool ok_ = true;
  bool done_ = false;
};
}  // namespace geometry_8_7_15
}  // namespace grpc_core
#endif  // GRPC_TEST_CPP_MICROBENCHMARKS_HUFFMAN_GEOMETRIES_DECODE_HUFF_8_7_15_H
