// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/bigtable/admin/v2/bigtable_instance_admin.proto

package admin

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for BigtableInstanceAdmin.CreateInstance.
type CreateInstanceRequest struct {
	// Required. The unique name of the project in which to create the new instance.
	// Values are of the form `projects/{project}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID to be used when referring to the new instance within its project,
	// e.g., just `myinstance` rather than
	// `projects/myproject/instances/myinstance`.
	InstanceId string `protobuf:"bytes,2,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// Required. The instance to create.
	// Fields marked `OutputOnly` must be left blank.
	Instance *Instance `protobuf:"bytes,3,opt,name=instance,proto3" json:"instance,omitempty"`
	// Required. The clusters to be created within the instance, mapped by desired
	// cluster ID, e.g., just `mycluster` rather than
	// `projects/myproject/instances/myinstance/clusters/mycluster`.
	// Fields marked `OutputOnly` must be left blank.
	// Currently, at most four clusters can be specified.
	Clusters             map[string]*Cluster `protobuf:"bytes,4,rep,name=clusters,proto3" json:"clusters,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *CreateInstanceRequest) Reset()         { *m = CreateInstanceRequest{} }
func (m *CreateInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateInstanceRequest) ProtoMessage()    {}
func (*CreateInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{0}
}

func (m *CreateInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInstanceRequest.Unmarshal(m, b)
}
func (m *CreateInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInstanceRequest.Marshal(b, m, deterministic)
}
func (m *CreateInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInstanceRequest.Merge(m, src)
}
func (m *CreateInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateInstanceRequest.Size(m)
}
func (m *CreateInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInstanceRequest proto.InternalMessageInfo

func (m *CreateInstanceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstanceId() string {
	if m != nil {
		return m.InstanceId
	}
	return ""
}

func (m *CreateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

func (m *CreateInstanceRequest) GetClusters() map[string]*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

// Request message for BigtableInstanceAdmin.GetInstance.
type GetInstanceRequest struct {
	// Required. The unique name of the requested instance. Values are of the form
	// `projects/{project}/instances/{instance}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetInstanceRequest) Reset()         { *m = GetInstanceRequest{} }
func (m *GetInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*GetInstanceRequest) ProtoMessage()    {}
func (*GetInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{1}
}

func (m *GetInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetInstanceRequest.Unmarshal(m, b)
}
func (m *GetInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetInstanceRequest.Marshal(b, m, deterministic)
}
func (m *GetInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetInstanceRequest.Merge(m, src)
}
func (m *GetInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_GetInstanceRequest.Size(m)
}
func (m *GetInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetInstanceRequest proto.InternalMessageInfo

func (m *GetInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for BigtableInstanceAdmin.ListInstances.
type ListInstancesRequest struct {
	// Required. The unique name of the project for which a list of instances is requested.
	// Values are of the form `projects/{project}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// DEPRECATED: This field is unused and ignored.
	PageToken            string   `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstancesRequest) Reset()         { *m = ListInstancesRequest{} }
func (m *ListInstancesRequest) String() string { return proto.CompactTextString(m) }
func (*ListInstancesRequest) ProtoMessage()    {}
func (*ListInstancesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{2}
}

func (m *ListInstancesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstancesRequest.Unmarshal(m, b)
}
func (m *ListInstancesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstancesRequest.Marshal(b, m, deterministic)
}
func (m *ListInstancesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstancesRequest.Merge(m, src)
}
func (m *ListInstancesRequest) XXX_Size() int {
	return xxx_messageInfo_ListInstancesRequest.Size(m)
}
func (m *ListInstancesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstancesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstancesRequest proto.InternalMessageInfo

func (m *ListInstancesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListInstancesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for BigtableInstanceAdmin.ListInstances.
type ListInstancesResponse struct {
	// The list of requested instances.
	Instances []*Instance `protobuf:"bytes,1,rep,name=instances,proto3" json:"instances,omitempty"`
	// Locations from which Instance information could not be retrieved,
	// due to an outage or some other transient condition.
	// Instances whose Clusters are all in one of the failed locations
	// may be missing from `instances`, and Instances with at least one
	// Cluster in a failed location may only have partial information returned.
	// Values are of the form `projects/<project>/locations/<zone_id>`
	FailedLocations []string `protobuf:"bytes,2,rep,name=failed_locations,json=failedLocations,proto3" json:"failed_locations,omitempty"`
	// DEPRECATED: This field is unused and ignored.
	NextPageToken        string   `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListInstancesResponse) Reset()         { *m = ListInstancesResponse{} }
func (m *ListInstancesResponse) String() string { return proto.CompactTextString(m) }
func (*ListInstancesResponse) ProtoMessage()    {}
func (*ListInstancesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{3}
}

func (m *ListInstancesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListInstancesResponse.Unmarshal(m, b)
}
func (m *ListInstancesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListInstancesResponse.Marshal(b, m, deterministic)
}
func (m *ListInstancesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListInstancesResponse.Merge(m, src)
}
func (m *ListInstancesResponse) XXX_Size() int {
	return xxx_messageInfo_ListInstancesResponse.Size(m)
}
func (m *ListInstancesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListInstancesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListInstancesResponse proto.InternalMessageInfo

func (m *ListInstancesResponse) GetInstances() []*Instance {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *ListInstancesResponse) GetFailedLocations() []string {
	if m != nil {
		return m.FailedLocations
	}
	return nil
}

func (m *ListInstancesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for BigtableInstanceAdmin.PartialUpdateInstance.
type PartialUpdateInstanceRequest struct {
	// Required. The Instance which will (partially) replace the current value.
	Instance *Instance `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Required. The subset of Instance fields which should be replaced.
	// Must be explicitly set.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *PartialUpdateInstanceRequest) Reset()         { *m = PartialUpdateInstanceRequest{} }
func (m *PartialUpdateInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*PartialUpdateInstanceRequest) ProtoMessage()    {}
func (*PartialUpdateInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{4}
}

func (m *PartialUpdateInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PartialUpdateInstanceRequest.Unmarshal(m, b)
}
func (m *PartialUpdateInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PartialUpdateInstanceRequest.Marshal(b, m, deterministic)
}
func (m *PartialUpdateInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PartialUpdateInstanceRequest.Merge(m, src)
}
func (m *PartialUpdateInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_PartialUpdateInstanceRequest.Size(m)
}
func (m *PartialUpdateInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PartialUpdateInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PartialUpdateInstanceRequest proto.InternalMessageInfo

func (m *PartialUpdateInstanceRequest) GetInstance() *Instance {
	if m != nil {
		return m.Instance
	}
	return nil
}

func (m *PartialUpdateInstanceRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for BigtableInstanceAdmin.DeleteInstance.
type DeleteInstanceRequest struct {
	// Required. The unique name of the instance to be deleted.
	// Values are of the form `projects/{project}/instances/{instance}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteInstanceRequest) Reset()         { *m = DeleteInstanceRequest{} }
func (m *DeleteInstanceRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteInstanceRequest) ProtoMessage()    {}
func (*DeleteInstanceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{5}
}

func (m *DeleteInstanceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteInstanceRequest.Unmarshal(m, b)
}
func (m *DeleteInstanceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteInstanceRequest.Marshal(b, m, deterministic)
}
func (m *DeleteInstanceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteInstanceRequest.Merge(m, src)
}
func (m *DeleteInstanceRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteInstanceRequest.Size(m)
}
func (m *DeleteInstanceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteInstanceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteInstanceRequest proto.InternalMessageInfo

func (m *DeleteInstanceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for BigtableInstanceAdmin.CreateCluster.
type CreateClusterRequest struct {
	// Required. The unique name of the instance in which to create the new cluster.
	// Values are of the form
	// `projects/{project}/instances/{instance}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID to be used when referring to the new cluster within its instance,
	// e.g., just `mycluster` rather than
	// `projects/myproject/instances/myinstance/clusters/mycluster`.
	ClusterId string `protobuf:"bytes,2,opt,name=cluster_id,json=clusterId,proto3" json:"cluster_id,omitempty"`
	// Required. The cluster to be created.
	// Fields marked `OutputOnly` must be left blank.
	Cluster              *Cluster `protobuf:"bytes,3,opt,name=cluster,proto3" json:"cluster,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateClusterRequest) Reset()         { *m = CreateClusterRequest{} }
func (m *CreateClusterRequest) String() string { return proto.CompactTextString(m) }
func (*CreateClusterRequest) ProtoMessage()    {}
func (*CreateClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{6}
}

func (m *CreateClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClusterRequest.Unmarshal(m, b)
}
func (m *CreateClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClusterRequest.Marshal(b, m, deterministic)
}
func (m *CreateClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClusterRequest.Merge(m, src)
}
func (m *CreateClusterRequest) XXX_Size() int {
	return xxx_messageInfo_CreateClusterRequest.Size(m)
}
func (m *CreateClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClusterRequest proto.InternalMessageInfo

func (m *CreateClusterRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateClusterRequest) GetClusterId() string {
	if m != nil {
		return m.ClusterId
	}
	return ""
}

func (m *CreateClusterRequest) GetCluster() *Cluster {
	if m != nil {
		return m.Cluster
	}
	return nil
}

// Request message for BigtableInstanceAdmin.GetCluster.
type GetClusterRequest struct {
	// Required. The unique name of the requested cluster. Values are of the form
	// `projects/{project}/instances/{instance}/clusters/{cluster}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetClusterRequest) Reset()         { *m = GetClusterRequest{} }
func (m *GetClusterRequest) String() string { return proto.CompactTextString(m) }
func (*GetClusterRequest) ProtoMessage()    {}
func (*GetClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{7}
}

func (m *GetClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetClusterRequest.Unmarshal(m, b)
}
func (m *GetClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetClusterRequest.Marshal(b, m, deterministic)
}
func (m *GetClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetClusterRequest.Merge(m, src)
}
func (m *GetClusterRequest) XXX_Size() int {
	return xxx_messageInfo_GetClusterRequest.Size(m)
}
func (m *GetClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetClusterRequest proto.InternalMessageInfo

func (m *GetClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for BigtableInstanceAdmin.ListClusters.
type ListClustersRequest struct {
	// Required. The unique name of the instance for which a list of clusters is requested.
	// Values are of the form `projects/{project}/instances/{instance}`.
	// Use `{instance} = '-'` to list Clusters for all Instances in a project,
	// e.g., `projects/myproject/instances/-`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// DEPRECATED: This field is unused and ignored.
	PageToken            string   `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClustersRequest) Reset()         { *m = ListClustersRequest{} }
func (m *ListClustersRequest) String() string { return proto.CompactTextString(m) }
func (*ListClustersRequest) ProtoMessage()    {}
func (*ListClustersRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{8}
}

func (m *ListClustersRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClustersRequest.Unmarshal(m, b)
}
func (m *ListClustersRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClustersRequest.Marshal(b, m, deterministic)
}
func (m *ListClustersRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClustersRequest.Merge(m, src)
}
func (m *ListClustersRequest) XXX_Size() int {
	return xxx_messageInfo_ListClustersRequest.Size(m)
}
func (m *ListClustersRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClustersRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListClustersRequest proto.InternalMessageInfo

func (m *ListClustersRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListClustersRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for BigtableInstanceAdmin.ListClusters.
type ListClustersResponse struct {
	// The list of requested clusters.
	Clusters []*Cluster `protobuf:"bytes,1,rep,name=clusters,proto3" json:"clusters,omitempty"`
	// Locations from which Cluster information could not be retrieved,
	// due to an outage or some other transient condition.
	// Clusters from these locations may be missing from `clusters`,
	// or may only have partial information returned.
	// Values are of the form `projects/<project>/locations/<zone_id>`
	FailedLocations []string `protobuf:"bytes,2,rep,name=failed_locations,json=failedLocations,proto3" json:"failed_locations,omitempty"`
	// DEPRECATED: This field is unused and ignored.
	NextPageToken        string   `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListClustersResponse) Reset()         { *m = ListClustersResponse{} }
func (m *ListClustersResponse) String() string { return proto.CompactTextString(m) }
func (*ListClustersResponse) ProtoMessage()    {}
func (*ListClustersResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{9}
}

func (m *ListClustersResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListClustersResponse.Unmarshal(m, b)
}
func (m *ListClustersResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListClustersResponse.Marshal(b, m, deterministic)
}
func (m *ListClustersResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListClustersResponse.Merge(m, src)
}
func (m *ListClustersResponse) XXX_Size() int {
	return xxx_messageInfo_ListClustersResponse.Size(m)
}
func (m *ListClustersResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListClustersResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListClustersResponse proto.InternalMessageInfo

func (m *ListClustersResponse) GetClusters() []*Cluster {
	if m != nil {
		return m.Clusters
	}
	return nil
}

func (m *ListClustersResponse) GetFailedLocations() []string {
	if m != nil {
		return m.FailedLocations
	}
	return nil
}

func (m *ListClustersResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for BigtableInstanceAdmin.DeleteCluster.
type DeleteClusterRequest struct {
	// Required. The unique name of the cluster to be deleted. Values are of the form
	// `projects/{project}/instances/{instance}/clusters/{cluster}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteClusterRequest) Reset()         { *m = DeleteClusterRequest{} }
func (m *DeleteClusterRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteClusterRequest) ProtoMessage()    {}
func (*DeleteClusterRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{10}
}

func (m *DeleteClusterRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteClusterRequest.Unmarshal(m, b)
}
func (m *DeleteClusterRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteClusterRequest.Marshal(b, m, deterministic)
}
func (m *DeleteClusterRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteClusterRequest.Merge(m, src)
}
func (m *DeleteClusterRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteClusterRequest.Size(m)
}
func (m *DeleteClusterRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteClusterRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteClusterRequest proto.InternalMessageInfo

func (m *DeleteClusterRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The metadata for the Operation returned by CreateInstance.
type CreateInstanceMetadata struct {
	// The request that prompted the initiation of this CreateInstance operation.
	OriginalRequest *CreateInstanceRequest `protobuf:"bytes,1,opt,name=original_request,json=originalRequest,proto3" json:"original_request,omitempty"`
	// The time at which the original request was received.
	RequestTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=request_time,json=requestTime,proto3" json:"request_time,omitempty"`
	// The time at which the operation failed or was completed successfully.
	FinishTime           *timestamp.Timestamp `protobuf:"bytes,3,opt,name=finish_time,json=finishTime,proto3" json:"finish_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CreateInstanceMetadata) Reset()         { *m = CreateInstanceMetadata{} }
func (m *CreateInstanceMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateInstanceMetadata) ProtoMessage()    {}
func (*CreateInstanceMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{11}
}

func (m *CreateInstanceMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateInstanceMetadata.Unmarshal(m, b)
}
func (m *CreateInstanceMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateInstanceMetadata.Marshal(b, m, deterministic)
}
func (m *CreateInstanceMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateInstanceMetadata.Merge(m, src)
}
func (m *CreateInstanceMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateInstanceMetadata.Size(m)
}
func (m *CreateInstanceMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateInstanceMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateInstanceMetadata proto.InternalMessageInfo

func (m *CreateInstanceMetadata) GetOriginalRequest() *CreateInstanceRequest {
	if m != nil {
		return m.OriginalRequest
	}
	return nil
}

func (m *CreateInstanceMetadata) GetRequestTime() *timestamp.Timestamp {
	if m != nil {
		return m.RequestTime
	}
	return nil
}

func (m *CreateInstanceMetadata) GetFinishTime() *timestamp.Timestamp {
	if m != nil {
		return m.FinishTime
	}
	return nil
}

// The metadata for the Operation returned by UpdateInstance.
type UpdateInstanceMetadata struct {
	// The request that prompted the initiation of this UpdateInstance operation.
	OriginalRequest *PartialUpdateInstanceRequest `protobuf:"bytes,1,opt,name=original_request,json=originalRequest,proto3" json:"original_request,omitempty"`
	// The time at which the original request was received.
	RequestTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=request_time,json=requestTime,proto3" json:"request_time,omitempty"`
	// The time at which the operation failed or was completed successfully.
	FinishTime           *timestamp.Timestamp `protobuf:"bytes,3,opt,name=finish_time,json=finishTime,proto3" json:"finish_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *UpdateInstanceMetadata) Reset()         { *m = UpdateInstanceMetadata{} }
func (m *UpdateInstanceMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateInstanceMetadata) ProtoMessage()    {}
func (*UpdateInstanceMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{12}
}

func (m *UpdateInstanceMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateInstanceMetadata.Unmarshal(m, b)
}
func (m *UpdateInstanceMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateInstanceMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateInstanceMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateInstanceMetadata.Merge(m, src)
}
func (m *UpdateInstanceMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateInstanceMetadata.Size(m)
}
func (m *UpdateInstanceMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateInstanceMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateInstanceMetadata proto.InternalMessageInfo

func (m *UpdateInstanceMetadata) GetOriginalRequest() *PartialUpdateInstanceRequest {
	if m != nil {
		return m.OriginalRequest
	}
	return nil
}

func (m *UpdateInstanceMetadata) GetRequestTime() *timestamp.Timestamp {
	if m != nil {
		return m.RequestTime
	}
	return nil
}

func (m *UpdateInstanceMetadata) GetFinishTime() *timestamp.Timestamp {
	if m != nil {
		return m.FinishTime
	}
	return nil
}

// The metadata for the Operation returned by CreateCluster.
type CreateClusterMetadata struct {
	// The request that prompted the initiation of this CreateCluster operation.
	OriginalRequest *CreateClusterRequest `protobuf:"bytes,1,opt,name=original_request,json=originalRequest,proto3" json:"original_request,omitempty"`
	// The time at which the original request was received.
	RequestTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=request_time,json=requestTime,proto3" json:"request_time,omitempty"`
	// The time at which the operation failed or was completed successfully.
	FinishTime           *timestamp.Timestamp `protobuf:"bytes,3,opt,name=finish_time,json=finishTime,proto3" json:"finish_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CreateClusterMetadata) Reset()         { *m = CreateClusterMetadata{} }
func (m *CreateClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateClusterMetadata) ProtoMessage()    {}
func (*CreateClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{13}
}

func (m *CreateClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClusterMetadata.Unmarshal(m, b)
}
func (m *CreateClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClusterMetadata.Marshal(b, m, deterministic)
}
func (m *CreateClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClusterMetadata.Merge(m, src)
}
func (m *CreateClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateClusterMetadata.Size(m)
}
func (m *CreateClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClusterMetadata proto.InternalMessageInfo

func (m *CreateClusterMetadata) GetOriginalRequest() *CreateClusterRequest {
	if m != nil {
		return m.OriginalRequest
	}
	return nil
}

func (m *CreateClusterMetadata) GetRequestTime() *timestamp.Timestamp {
	if m != nil {
		return m.RequestTime
	}
	return nil
}

func (m *CreateClusterMetadata) GetFinishTime() *timestamp.Timestamp {
	if m != nil {
		return m.FinishTime
	}
	return nil
}

// The metadata for the Operation returned by UpdateCluster.
type UpdateClusterMetadata struct {
	// The request that prompted the initiation of this UpdateCluster operation.
	OriginalRequest *Cluster `protobuf:"bytes,1,opt,name=original_request,json=originalRequest,proto3" json:"original_request,omitempty"`
	// The time at which the original request was received.
	RequestTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=request_time,json=requestTime,proto3" json:"request_time,omitempty"`
	// The time at which the operation failed or was completed successfully.
	FinishTime           *timestamp.Timestamp `protobuf:"bytes,3,opt,name=finish_time,json=finishTime,proto3" json:"finish_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *UpdateClusterMetadata) Reset()         { *m = UpdateClusterMetadata{} }
func (m *UpdateClusterMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateClusterMetadata) ProtoMessage()    {}
func (*UpdateClusterMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{14}
}

func (m *UpdateClusterMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateClusterMetadata.Unmarshal(m, b)
}
func (m *UpdateClusterMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateClusterMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateClusterMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateClusterMetadata.Merge(m, src)
}
func (m *UpdateClusterMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateClusterMetadata.Size(m)
}
func (m *UpdateClusterMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateClusterMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateClusterMetadata proto.InternalMessageInfo

func (m *UpdateClusterMetadata) GetOriginalRequest() *Cluster {
	if m != nil {
		return m.OriginalRequest
	}
	return nil
}

func (m *UpdateClusterMetadata) GetRequestTime() *timestamp.Timestamp {
	if m != nil {
		return m.RequestTime
	}
	return nil
}

func (m *UpdateClusterMetadata) GetFinishTime() *timestamp.Timestamp {
	if m != nil {
		return m.FinishTime
	}
	return nil
}

// Request message for BigtableInstanceAdmin.CreateAppProfile.
type CreateAppProfileRequest struct {
	// Required. The unique name of the instance in which to create the new app profile.
	// Values are of the form
	// `projects/{project}/instances/{instance}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID to be used when referring to the new app profile within its
	// instance, e.g., just `myprofile` rather than
	// `projects/myproject/instances/myinstance/appProfiles/myprofile`.
	AppProfileId string `protobuf:"bytes,2,opt,name=app_profile_id,json=appProfileId,proto3" json:"app_profile_id,omitempty"`
	// Required. The app profile to be created.
	// Fields marked `OutputOnly` will be ignored.
	AppProfile *AppProfile `protobuf:"bytes,3,opt,name=app_profile,json=appProfile,proto3" json:"app_profile,omitempty"`
	// If true, ignore safety checks when creating the app profile.
	IgnoreWarnings       bool     `protobuf:"varint,4,opt,name=ignore_warnings,json=ignoreWarnings,proto3" json:"ignore_warnings,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateAppProfileRequest) Reset()         { *m = CreateAppProfileRequest{} }
func (m *CreateAppProfileRequest) String() string { return proto.CompactTextString(m) }
func (*CreateAppProfileRequest) ProtoMessage()    {}
func (*CreateAppProfileRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{15}
}

func (m *CreateAppProfileRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateAppProfileRequest.Unmarshal(m, b)
}
func (m *CreateAppProfileRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateAppProfileRequest.Marshal(b, m, deterministic)
}
func (m *CreateAppProfileRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateAppProfileRequest.Merge(m, src)
}
func (m *CreateAppProfileRequest) XXX_Size() int {
	return xxx_messageInfo_CreateAppProfileRequest.Size(m)
}
func (m *CreateAppProfileRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateAppProfileRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateAppProfileRequest proto.InternalMessageInfo

func (m *CreateAppProfileRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateAppProfileRequest) GetAppProfileId() string {
	if m != nil {
		return m.AppProfileId
	}
	return ""
}

func (m *CreateAppProfileRequest) GetAppProfile() *AppProfile {
	if m != nil {
		return m.AppProfile
	}
	return nil
}

func (m *CreateAppProfileRequest) GetIgnoreWarnings() bool {
	if m != nil {
		return m.IgnoreWarnings
	}
	return false
}

// Request message for BigtableInstanceAdmin.GetAppProfile.
type GetAppProfileRequest struct {
	// Required. The unique name of the requested app profile. Values are of the form
	// `projects/{project}/instances/{instance}/appProfiles/{app_profile}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetAppProfileRequest) Reset()         { *m = GetAppProfileRequest{} }
func (m *GetAppProfileRequest) String() string { return proto.CompactTextString(m) }
func (*GetAppProfileRequest) ProtoMessage()    {}
func (*GetAppProfileRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{16}
}

func (m *GetAppProfileRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetAppProfileRequest.Unmarshal(m, b)
}
func (m *GetAppProfileRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetAppProfileRequest.Marshal(b, m, deterministic)
}
func (m *GetAppProfileRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetAppProfileRequest.Merge(m, src)
}
func (m *GetAppProfileRequest) XXX_Size() int {
	return xxx_messageInfo_GetAppProfileRequest.Size(m)
}
func (m *GetAppProfileRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetAppProfileRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetAppProfileRequest proto.InternalMessageInfo

func (m *GetAppProfileRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for BigtableInstanceAdmin.ListAppProfiles.
type ListAppProfilesRequest struct {
	// Required. The unique name of the instance for which a list of app profiles is
	// requested. Values are of the form
	// `projects/{project}/instances/{instance}`.
	// Use `{instance} = '-'` to list AppProfiles for all Instances in a project,
	// e.g., `projects/myproject/instances/-`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of results per page.
	//
	// A page_size of zero lets the server choose the number of items to return.
	// A page_size which is strictly positive will return at most that many items.
	// A negative page_size will cause an error.
	//
	// Following the first request, subsequent paginated calls are not required
	// to pass a page_size. If a page_size is set in subsequent calls, it must
	// match the page_size given in the first request.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value of `next_page_token` returned by a previous call.
	PageToken            string   `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAppProfilesRequest) Reset()         { *m = ListAppProfilesRequest{} }
func (m *ListAppProfilesRequest) String() string { return proto.CompactTextString(m) }
func (*ListAppProfilesRequest) ProtoMessage()    {}
func (*ListAppProfilesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{17}
}

func (m *ListAppProfilesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAppProfilesRequest.Unmarshal(m, b)
}
func (m *ListAppProfilesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAppProfilesRequest.Marshal(b, m, deterministic)
}
func (m *ListAppProfilesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAppProfilesRequest.Merge(m, src)
}
func (m *ListAppProfilesRequest) XXX_Size() int {
	return xxx_messageInfo_ListAppProfilesRequest.Size(m)
}
func (m *ListAppProfilesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAppProfilesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAppProfilesRequest proto.InternalMessageInfo

func (m *ListAppProfilesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListAppProfilesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListAppProfilesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for BigtableInstanceAdmin.ListAppProfiles.
type ListAppProfilesResponse struct {
	// The list of requested app profiles.
	AppProfiles []*AppProfile `protobuf:"bytes,1,rep,name=app_profiles,json=appProfiles,proto3" json:"app_profiles,omitempty"`
	// Set if not all app profiles could be returned in a single response.
	// Pass this value to `page_token` in another request to get the next
	// page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations from which AppProfile information could not be retrieved,
	// due to an outage or some other transient condition.
	// AppProfiles from these locations may be missing from `app_profiles`.
	// Values are of the form `projects/<project>/locations/<zone_id>`
	FailedLocations      []string `protobuf:"bytes,3,rep,name=failed_locations,json=failedLocations,proto3" json:"failed_locations,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAppProfilesResponse) Reset()         { *m = ListAppProfilesResponse{} }
func (m *ListAppProfilesResponse) String() string { return proto.CompactTextString(m) }
func (*ListAppProfilesResponse) ProtoMessage()    {}
func (*ListAppProfilesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{18}
}

func (m *ListAppProfilesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAppProfilesResponse.Unmarshal(m, b)
}
func (m *ListAppProfilesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAppProfilesResponse.Marshal(b, m, deterministic)
}
func (m *ListAppProfilesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAppProfilesResponse.Merge(m, src)
}
func (m *ListAppProfilesResponse) XXX_Size() int {
	return xxx_messageInfo_ListAppProfilesResponse.Size(m)
}
func (m *ListAppProfilesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAppProfilesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListAppProfilesResponse proto.InternalMessageInfo

func (m *ListAppProfilesResponse) GetAppProfiles() []*AppProfile {
	if m != nil {
		return m.AppProfiles
	}
	return nil
}

func (m *ListAppProfilesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListAppProfilesResponse) GetFailedLocations() []string {
	if m != nil {
		return m.FailedLocations
	}
	return nil
}

// Request message for BigtableInstanceAdmin.UpdateAppProfile.
type UpdateAppProfileRequest struct {
	// Required. The app profile which will (partially) replace the current value.
	AppProfile *AppProfile `protobuf:"bytes,1,opt,name=app_profile,json=appProfile,proto3" json:"app_profile,omitempty"`
	// Required. The subset of app profile fields which should be replaced.
	// If unset, all fields will be replaced.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// If true, ignore safety checks when updating the app profile.
	IgnoreWarnings       bool     `protobuf:"varint,3,opt,name=ignore_warnings,json=ignoreWarnings,proto3" json:"ignore_warnings,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateAppProfileRequest) Reset()         { *m = UpdateAppProfileRequest{} }
func (m *UpdateAppProfileRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateAppProfileRequest) ProtoMessage()    {}
func (*UpdateAppProfileRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{19}
}

func (m *UpdateAppProfileRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateAppProfileRequest.Unmarshal(m, b)
}
func (m *UpdateAppProfileRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateAppProfileRequest.Marshal(b, m, deterministic)
}
func (m *UpdateAppProfileRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateAppProfileRequest.Merge(m, src)
}
func (m *UpdateAppProfileRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateAppProfileRequest.Size(m)
}
func (m *UpdateAppProfileRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateAppProfileRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateAppProfileRequest proto.InternalMessageInfo

func (m *UpdateAppProfileRequest) GetAppProfile() *AppProfile {
	if m != nil {
		return m.AppProfile
	}
	return nil
}

func (m *UpdateAppProfileRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateAppProfileRequest) GetIgnoreWarnings() bool {
	if m != nil {
		return m.IgnoreWarnings
	}
	return false
}

// Request message for BigtableInstanceAdmin.DeleteAppProfile.
type DeleteAppProfileRequest struct {
	// Required. The unique name of the app profile to be deleted. Values are of the form
	// `projects/{project}/instances/{instance}/appProfiles/{app_profile}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// If true, ignore safety checks when deleting the app profile.
	IgnoreWarnings       bool     `protobuf:"varint,2,opt,name=ignore_warnings,json=ignoreWarnings,proto3" json:"ignore_warnings,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteAppProfileRequest) Reset()         { *m = DeleteAppProfileRequest{} }
func (m *DeleteAppProfileRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteAppProfileRequest) ProtoMessage()    {}
func (*DeleteAppProfileRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{20}
}

func (m *DeleteAppProfileRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteAppProfileRequest.Unmarshal(m, b)
}
func (m *DeleteAppProfileRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteAppProfileRequest.Marshal(b, m, deterministic)
}
func (m *DeleteAppProfileRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteAppProfileRequest.Merge(m, src)
}
func (m *DeleteAppProfileRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteAppProfileRequest.Size(m)
}
func (m *DeleteAppProfileRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteAppProfileRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteAppProfileRequest proto.InternalMessageInfo

func (m *DeleteAppProfileRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DeleteAppProfileRequest) GetIgnoreWarnings() bool {
	if m != nil {
		return m.IgnoreWarnings
	}
	return false
}

// The metadata for the Operation returned by UpdateAppProfile.
type UpdateAppProfileMetadata struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateAppProfileMetadata) Reset()         { *m = UpdateAppProfileMetadata{} }
func (m *UpdateAppProfileMetadata) String() string { return proto.CompactTextString(m) }
func (*UpdateAppProfileMetadata) ProtoMessage()    {}
func (*UpdateAppProfileMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_7e62c0eb67875591, []int{21}
}

func (m *UpdateAppProfileMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateAppProfileMetadata.Unmarshal(m, b)
}
func (m *UpdateAppProfileMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateAppProfileMetadata.Marshal(b, m, deterministic)
}
func (m *UpdateAppProfileMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateAppProfileMetadata.Merge(m, src)
}
func (m *UpdateAppProfileMetadata) XXX_Size() int {
	return xxx_messageInfo_UpdateAppProfileMetadata.Size(m)
}
func (m *UpdateAppProfileMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateAppProfileMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateAppProfileMetadata proto.InternalMessageInfo

func init() {
	proto.RegisterType((*CreateInstanceRequest)(nil), "google.bigtable.admin.v2.CreateInstanceRequest")
	proto.RegisterMapType((map[string]*Cluster)(nil), "google.bigtable.admin.v2.CreateInstanceRequest.ClustersEntry")
	proto.RegisterType((*GetInstanceRequest)(nil), "google.bigtable.admin.v2.GetInstanceRequest")
	proto.RegisterType((*ListInstancesRequest)(nil), "google.bigtable.admin.v2.ListInstancesRequest")
	proto.RegisterType((*ListInstancesResponse)(nil), "google.bigtable.admin.v2.ListInstancesResponse")
	proto.RegisterType((*PartialUpdateInstanceRequest)(nil), "google.bigtable.admin.v2.PartialUpdateInstanceRequest")
	proto.RegisterType((*DeleteInstanceRequest)(nil), "google.bigtable.admin.v2.DeleteInstanceRequest")
	proto.RegisterType((*CreateClusterRequest)(nil), "google.bigtable.admin.v2.CreateClusterRequest")
	proto.RegisterType((*GetClusterRequest)(nil), "google.bigtable.admin.v2.GetClusterRequest")
	proto.RegisterType((*ListClustersRequest)(nil), "google.bigtable.admin.v2.ListClustersRequest")
	proto.RegisterType((*ListClustersResponse)(nil), "google.bigtable.admin.v2.ListClustersResponse")
	proto.RegisterType((*DeleteClusterRequest)(nil), "google.bigtable.admin.v2.DeleteClusterRequest")
	proto.RegisterType((*CreateInstanceMetadata)(nil), "google.bigtable.admin.v2.CreateInstanceMetadata")
	proto.RegisterType((*UpdateInstanceMetadata)(nil), "google.bigtable.admin.v2.UpdateInstanceMetadata")
	proto.RegisterType((*CreateClusterMetadata)(nil), "google.bigtable.admin.v2.CreateClusterMetadata")
	proto.RegisterType((*UpdateClusterMetadata)(nil), "google.bigtable.admin.v2.UpdateClusterMetadata")
	proto.RegisterType((*CreateAppProfileRequest)(nil), "google.bigtable.admin.v2.CreateAppProfileRequest")
	proto.RegisterType((*GetAppProfileRequest)(nil), "google.bigtable.admin.v2.GetAppProfileRequest")
	proto.RegisterType((*ListAppProfilesRequest)(nil), "google.bigtable.admin.v2.ListAppProfilesRequest")
	proto.RegisterType((*ListAppProfilesResponse)(nil), "google.bigtable.admin.v2.ListAppProfilesResponse")
	proto.RegisterType((*UpdateAppProfileRequest)(nil), "google.bigtable.admin.v2.UpdateAppProfileRequest")
	proto.RegisterType((*DeleteAppProfileRequest)(nil), "google.bigtable.admin.v2.DeleteAppProfileRequest")
	proto.RegisterType((*UpdateAppProfileMetadata)(nil), "google.bigtable.admin.v2.UpdateAppProfileMetadata")
}

func init() {
	proto.RegisterFile("google/bigtable/admin/v2/bigtable_instance_admin.proto", fileDescriptor_7e62c0eb67875591)
}

var fileDescriptor_7e62c0eb67875591 = []byte{
	// 1955 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x59, 0x4f, 0x6c, 0xdb, 0xd6,
	0x19, 0xc7, 0x93, 0xfa, 0xc7, 0xfe, 0xe4, 0x7f, 0x7b, 0xb3, 0x63, 0x97, 0x4d, 0x53, 0x87, 0x0d,
	0x12, 0x47, 0x75, 0xc8, 0x5a, 0x05, 0xd2, 0xc2, 0x9e, 0x03, 0x33, 0x59, 0xe7, 0xa5, 0x4b, 0x51,
	0x43, 0x49, 0x33, 0x2c, 0x08, 0x2a, 0x3c, 0x4b, 0xcf, 0x32, 0x17, 0x8a, 0xe4, 0x48, 0x4a, 0xae,
	0xbb, 0xf5, 0x92, 0xc3, 0x2e, 0x3b, 0x0c, 0x5b, 0x86, 0x01, 0x2b, 0xb0, 0xdb, 0x0a, 0x0c, 0x43,
	0x77, 0x1c, 0xb0, 0xcb, 0x76, 0xdb, 0xc5, 0xa7, 0x61, 0xc3, 0x2e, 0xc2, 0x0e, 0x1d, 0xb0, 0xc3,
	0x4e, 0xc3, 0x6e, 0x05, 0xba, 0x4b, 0xc1, 0xf7, 0x87, 0x22, 0x29, 0x52, 0xa2, 0x1a, 0x07, 0xc8,
	0xc9, 0xd2, 0x7b, 0xdf, 0xf7, 0xbd, 0xdf, 0xf7, 0xff, 0xfb, 0x2c, 0xb8, 0xda, 0x76, 0x9c, 0xb6,
	0x45, 0xf5, 0x7d, 0xb3, 0x1d, 0x90, 0x7d, 0x8b, 0xea, 0xa4, 0xd5, 0x31, 0x6d, 0xbd, 0x57, 0x8b,
	0x4e, 0x1a, 0xa6, 0xed, 0x07, 0xc4, 0x6e, 0xd2, 0x06, 0xbb, 0xd2, 0x5c, 0xcf, 0x09, 0x1c, 0xbc,
	0xc2, 0xf9, 0x34, 0x49, 0xa5, 0xf1, 0xcb, 0x5e, 0x4d, 0x39, 0x2b, 0x24, 0x12, 0xd7, 0xd4, 0x89,
	0x6d, 0x3b, 0x01, 0x09, 0x4c, 0xc7, 0xf6, 0x39, 0x9f, 0xb2, 0x1c, 0xbb, 0x6d, 0x5a, 0x26, 0xb5,
	0x03, 0x71, 0xf1, 0x72, 0xec, 0xe2, 0xc0, 0xa4, 0x56, 0xab, 0xb1, 0x4f, 0x0f, 0x49, 0xcf, 0x74,
	0x3c, 0x41, 0xf0, 0x42, 0x8c, 0xc0, 0xa3, 0xbe, 0xd3, 0xf5, 0x9a, 0x54, 0x5c, 0x5d, 0xca, 0x55,
	0x42, 0x62, 0x17, 0x84, 0xe7, 0x04, 0xa1, 0x49, 0x3a, 0x7a, 0x6f, 0x23, 0xfc, 0xd3, 0x70, 0x1d,
	0xcb, 0x6c, 0x1e, 0x8b, 0x7b, 0x25, 0x79, 0x9f, 0xb8, 0x7b, 0x45, 0xdc, 0x59, 0x8e, 0xdd, 0xf6,
	0xba, 0xb6, 0x6d, 0xda, 0x6d, 0xdd, 0x71, 0xa9, 0x97, 0x50, 0xef, 0x45, 0x41, 0xc4, 0xbe, 0xed,
	0x77, 0x0f, 0x74, 0xda, 0x71, 0x03, 0x29, 0x61, 0x35, 0x7d, 0xc9, 0xf5, 0xec, 0x10, 0xff, 0x41,
	0xca, 0x08, 0x11, 0x45, 0x60, 0x76, 0xa8, 0x1f, 0x90, 0x8e, 0xcb, 0x09, 0xd4, 0x9f, 0x96, 0x61,
	0xe9, 0x86, 0x47, 0x49, 0x40, 0x6f, 0x0a, 0xcd, 0xea, 0xf4, 0x07, 0x5d, 0xea, 0x07, 0xf8, 0x3b,
	0xf0, 0x9c, 0x4b, 0x3c, 0x6a, 0x07, 0x2b, 0x68, 0x15, 0xad, 0x4d, 0x5f, 0x7f, 0xfd, 0x33, 0xa3,
	0xf4, 0x85, 0x71, 0x05, 0x5e, 0x6d, 0x5a, 0x4e, 0xb7, 0x25, 0x0d, 0xd6, 0x21, 0x36, 0x69, 0x53,
	0x4f, 0xe3, 0xef, 0x10, 0xd7, 0xf4, 0xb5, 0xa6, 0xd3, 0xd1, 0xf7, 0x3c, 0xe7, 0xfb, 0xb4, 0x19,
	0xd4, 0x85, 0x08, 0x7c, 0x01, 0x2a, 0x91, 0xd7, 0xcd, 0xd6, 0x4a, 0x89, 0x49, 0x2c, 0x7f, 0x66,
	0x94, 0xea, 0x20, 0xcf, 0x6f, 0xb6, 0xf0, 0x0d, 0x98, 0x92, 0xdf, 0x56, 0xca, 0xab, 0x68, 0xad,
	0x52, 0x53, 0xb5, 0xbc, 0xb0, 0xd0, 0x24, 0x5e, 0x2e, 0x26, 0x62, 0xc4, 0xef, 0xc3, 0x54, 0xd3,
	0xea, 0xfa, 0x01, 0xf5, 0xfc, 0x95, 0x67, 0x56, 0xcb, 0x6b, 0x95, 0xda, 0x76, 0xbe, 0x90, 0x4c,
	0xd5, 0xb5, 0x1b, 0x82, 0xff, 0x2d, 0x3b, 0xf0, 0x8e, 0x85, 0x7c, 0x29, 0x53, 0x79, 0x1f, 0x66,
	0x13, 0xf7, 0x78, 0x01, 0xca, 0x0f, 0xe8, 0x31, 0xb7, 0x52, 0x3d, 0xfc, 0x88, 0xdf, 0x80, 0x67,
	0x7b, 0xc4, 0xea, 0x52, 0xa6, 0x67, 0xa5, 0x76, 0x7e, 0xc4, 0xfb, 0x5c, 0x52, 0x9d, 0xd3, 0x6f,
	0x96, 0xde, 0x44, 0x6a, 0x1d, 0xf0, 0x2e, 0x0d, 0xd2, 0xde, 0xf8, 0x06, 0x3c, 0x63, 0x93, 0x0e,
	0x15, 0xbe, 0x58, 0x63, 0xbe, 0x50, 0x61, 0x35, 0x92, 0x98, 0xb2, 0x7f, 0xc4, 0xce, 0xb8, 0xd4,
	0x87, 0x08, 0x16, 0x6f, 0x99, 0x7e, 0x24, 0xd5, 0x7f, 0x22, 0x4e, 0x7e, 0x09, 0xc0, 0x25, 0x6d,
	0xda, 0x08, 0x9c, 0x07, 0xd4, 0xe6, 0x3e, 0xae, 0x4f, 0x87, 0x27, 0x77, 0xc2, 0x03, 0xf5, 0x53,
	0x04, 0x4b, 0x29, 0x10, 0xbe, 0xeb, 0xd8, 0x3e, 0xc5, 0x3b, 0x30, 0x2d, 0xdd, 0xe7, 0xaf, 0x20,
	0xe6, 0xb3, 0x02, 0x8e, 0xaf, 0x0f, 0x98, 0xf0, 0x65, 0x58, 0x38, 0x20, 0xa6, 0x45, 0x5b, 0x0d,
	0xcb, 0x69, 0xf2, 0x04, 0x5a, 0x29, 0xad, 0x96, 0xd7, 0xa6, 0xeb, 0xf3, 0xfc, 0xfc, 0x96, 0x3c,
	0xc6, 0x17, 0x61, 0xde, 0xa6, 0x1f, 0x04, 0x8d, 0x18, 0xd4, 0x32, 0x83, 0x3a, 0x1b, 0x1e, 0xef,
	0x45, 0x70, 0x3f, 0x41, 0x70, 0x76, 0x8f, 0x78, 0x81, 0x49, 0xac, 0xf7, 0xdc, 0x56, 0x46, 0x82,
	0xc4, 0xa3, 0x15, 0x7d, 0xd5, 0x68, 0xdd, 0x81, 0x4a, 0x97, 0x49, 0x67, 0x59, 0x2b, 0x02, 0x46,
	0x91, 0x72, 0x64, 0xda, 0x6a, 0xdf, 0x0a, 0x13, 0xfb, 0x1d, 0xe2, 0x3f, 0x10, 0x49, 0xc3, 0x79,
	0xc2, 0x03, 0xf5, 0x3d, 0x58, 0xfa, 0x26, 0xb5, 0xe8, 0x30, 0xbe, 0xc7, 0x0b, 0x99, 0x3f, 0x23,
	0x58, 0xe4, 0xd9, 0x21, 0x63, 0x54, 0x88, 0xdd, 0x49, 0x85, 0x4c, 0x71, 0xc1, 0x32, 0x4e, 0x54,
	0x00, 0x91, 0x4d, 0xa9, 0x5a, 0x30, 0x2d, 0x8e, 0x6f, 0xb6, 0xf0, 0x0e, 0x3c, 0x2f, 0xbe, 0x88,
	0x4a, 0x30, 0x3e, 0x89, 0xb8, 0x0c, 0xc9, 0xa6, 0xee, 0xc1, 0xd7, 0x76, 0x69, 0x90, 0x02, 0xbf,
	0x95, 0xb0, 0xc9, 0x25, 0x06, 0xfd, 0x3c, 0xbc, 0x9c, 0x07, 0x5d, 0x72, 0x73, 0x93, 0xf4, 0xe0,
	0xeb, 0x61, 0xfc, 0xca, 0xec, 0x3f, 0x3d, 0x83, 0x8c, 0x49, 0x9c, 0xdf, 0x8a, 0xec, 0x1d, 0x3c,
	0x2c, 0xf2, 0x66, 0x3b, 0x56, 0xea, 0x78, 0xda, 0x14, 0x28, 0x35, 0x11, 0xcb, 0x93, 0x48, 0x9a,
	0xdb, 0xb0, 0xc8, 0x83, 0xf1, 0x34, 0xed, 0xfe, 0x3f, 0x04, 0x67, 0x92, 0x85, 0xfa, 0x1d, 0x1a,
	0x90, 0x16, 0x09, 0x08, 0xbe, 0x07, 0x0b, 0x8e, 0x67, 0xb6, 0x4d, 0x9b, 0x58, 0x0d, 0x8f, 0xbf,
	0x25, 0x72, 0x51, 0x9f, 0xb0, 0xe8, 0xd7, 0xe7, 0xa5, 0x20, 0x89, 0x79, 0x1b, 0x66, 0x84, 0xc8,
	0x46, 0xd8, 0x35, 0x73, 0x73, 0xf3, 0x8e, 0x6c, 0xa9, 0xf5, 0x8a, 0xa0, 0x0f, 0x4f, 0xf0, 0x16,
	0x54, 0x0e, 0x4c, 0xdb, 0xf4, 0x0f, 0x39, 0x77, 0x79, 0x2c, 0x37, 0x70, 0xf2, 0xf0, 0x40, 0xfd,
	0x1c, 0xc1, 0x99, 0x64, 0xd5, 0x89, 0x54, 0x26, 0xb9, 0x2a, 0x5f, 0xcd, 0x57, 0x79, 0x54, 0x21,
	0x7b, 0xba, 0x34, 0xff, 0x2f, 0x92, 0x03, 0x89, 0x08, 0x82, 0x48, 0xf1, 0xef, 0xe5, 0x2a, 0xae,
	0x8d, 0xf3, 0x75, 0x32, 0x1a, 0x9f, 0x2e, 0x85, 0xff, 0x85, 0x60, 0x89, 0xfb, 0x25, 0xad, 0xf0,
	0xad, 0x5c, 0x85, 0x0b, 0xa4, 0xf9, 0x53, 0xa5, 0xe3, 0xff, 0x11, 0x2c, 0x73, 0x4f, 0x18, 0xae,
	0xbb, 0xe7, 0x39, 0x07, 0xa6, 0x45, 0x4f, 0xaf, 0x7c, 0x5e, 0x86, 0x39, 0xe2, 0xba, 0x0d, 0x97,
	0xcb, 0x4d, 0xf5, 0x94, 0x19, 0x12, 0xbd, 0x78, 0xb3, 0x85, 0xdf, 0x86, 0x4a, 0x8c, 0x54, 0x68,
	0x71, 0x21, 0xdf, 0x9a, 0x03, 0xb8, 0xa2, 0xf1, 0x0e, 0xa4, 0xe1, 0x4b, 0x30, 0x6f, 0xb6, 0x6d,
	0xc7, 0xa3, 0x8d, 0x23, 0xe2, 0x85, 0xd3, 0x7b, 0x38, 0x6f, 0xa2, 0xb5, 0xa9, 0xfa, 0x1c, 0x3f,
	0xfe, 0xae, 0x38, 0x55, 0xef, 0xc2, 0xe2, 0x2e, 0x0d, 0x86, 0x35, 0xbf, 0x96, 0x28, 0x8a, 0x55,
	0xa6, 0xf7, 0x05, 0x50, 0xf3, 0xf4, 0x8e, 0x09, 0xe0, 0x75, 0xf1, 0x97, 0x08, 0xce, 0x84, 0x7d,
	0x61, 0x70, 0x71, 0x8a, 0x3d, 0xe9, 0x45, 0x60, 0x1d, 0xa8, 0xe1, 0x9b, 0x1f, 0x72, 0x3b, 0x3d,
	0x5b, 0x9f, 0x0a, 0x0f, 0x6e, 0x9b, 0x1f, 0xd2, 0x71, 0x0d, 0xeb, 0x0f, 0x08, 0x96, 0x87, 0x80,
	0x89, 0x9e, 0xb5, 0x0b, 0x33, 0x31, 0x0f, 0xc8, 0xbe, 0x55, 0xc8, 0x05, 0xf5, 0xca, 0xc0, 0xfa,
	0x99, 0x2d, 0xa9, 0x94, 0xd1, 0x92, 0x32, 0xbb, 0x5c, 0x39, 0xb3, 0xcb, 0xa9, 0x7f, 0x45, 0xb0,
	0xcc, 0x53, 0x71, 0xd8, 0x59, 0xa9, 0xc8, 0x41, 0x8f, 0x13, 0x39, 0x8f, 0x3d, 0xf4, 0x65, 0xc5,
	0x5e, 0x39, 0x33, 0xf6, 0x1e, 0x22, 0x58, 0xe6, 0x1d, 0xf9, 0xd4, 0xe3, 0x2f, 0x0b, 0x44, 0x29,
	0x13, 0x84, 0x02, 0x2b, 0x69, 0xb3, 0xca, 0x22, 0x57, 0xfb, 0xf9, 0x39, 0x58, 0xba, 0x2e, 0x5e,
	0x94, 0x41, 0x68, 0x84, 0x46, 0xc4, 0x7d, 0x04, 0x73, 0xc9, 0x56, 0x8d, 0x27, 0x6d, 0xea, 0xca,
	0x4b, 0x92, 0x21, 0xb6, 0x64, 0x6b, 0xef, 0xca, 0x25, 0x5b, 0xfd, 0xe0, 0xc4, 0x50, 0x61, 0x2a,
	0x12, 0x9f, 0x33, 0x65, 0xf4, 0x8d, 0x0b, 0x3c, 0x29, 0xd6, 0x63, 0x3b, 0x6c, 0xf4, 0x79, 0x5d,
	0xce, 0x53, 0x0f, 0xff, 0xfe, 0xef, 0x47, 0xa5, 0x8b, 0xea, 0x79, 0xbd, 0x57, 0xd3, 0x7f, 0xc8,
	0x19, 0xb6, 0x5d, 0xbe, 0x22, 0xf9, 0x7a, 0xf5, 0xa3, 0xe8, 0x5f, 0x07, 0xfe, 0x26, 0xaa, 0xe2,
	0x9f, 0x21, 0xa8, 0xc4, 0xd6, 0x3c, 0xbc, 0x9e, 0xaf, 0xd9, 0xf0, 0x36, 0xa8, 0x14, 0x58, 0x34,
	0xd4, 0xd7, 0xfa, 0x06, 0x73, 0x13, 0x83, 0xf5, 0x0a, 0xe6, 0xb0, 0xc2, 0x83, 0x18, 0xa8, 0x01,
	0x26, 0xbd, 0xfa, 0x11, 0xfe, 0x0d, 0x82, 0xd9, 0xc4, 0x82, 0x86, 0x47, 0x34, 0xd6, 0xac, 0x75,
	0x52, 0xd1, 0x0b, 0xd3, 0xf3, 0x6a, 0xa0, 0xd6, 0xfa, 0x86, 0x28, 0x38, 0x09, 0x98, 0xa3, 0xac,
	0x87, 0x7f, 0x8c, 0x60, 0x2e, 0x39, 0xc8, 0xe0, 0x02, 0xf6, 0x28, 0x64, 0xb3, 0x75, 0xee, 0x43,
	0x65, 0xbc, 0xb1, 0x42, 0x1f, 0xfe, 0x07, 0xc1, 0x52, 0xe6, 0x60, 0x85, 0xbf, 0xe2, 0x24, 0x36,
	0x69, 0xb8, 0x66, 0x4f, 0x88, 0x7d, 0x63, 0x31, 0x8a, 0xcd, 0x58, 0x99, 0x61, 0xaa, 0x5d, 0xad,
	0x55, 0x99, 0x6a, 0xd1, 0xbf, 0xb1, 0x46, 0xea, 0x38, 0x58, 0x53, 0x7f, 0x82, 0x60, 0x2e, 0xb9,
	0x65, 0x8e, 0xca, 0xc5, 0xcc, 0x7d, 0x54, 0x39, 0x33, 0x54, 0xe0, 0xde, 0xea, 0xb8, 0xc1, 0x71,
	0x2a, 0x50, 0xab, 0x05, 0x02, 0xf5, 0x9f, 0x08, 0x66, 0x13, 0x83, 0x1d, 0x9e, 0x70, 0x02, 0x1c,
	0x67, 0xe8, 0x1f, 0x9d, 0x18, 0xab, 0xf0, 0xbc, 0x14, 0x9e, 0x3d, 0x8f, 0xf6, 0x8d, 0x17, 0x44,
	0x55, 0x18, 0x2c, 0xb3, 0xf2, 0x23, 0x53, 0xe5, 0x0d, 0x75, 0x3d, 0x3b, 0x98, 0x13, 0xca, 0xe8,
	0xb2, 0x7c, 0x6c, 0xca, 0xcd, 0x15, 0xff, 0x0a, 0x01, 0x0c, 0x56, 0x57, 0xfc, 0xea, 0xc8, 0xd2,
	0x90, 0x52, 0x6c, 0xfc, 0x64, 0xa8, 0x6e, 0xc5, 0xed, 0xad, 0xe1, 0xf5, 0x71, 0xf6, 0x8e, 0x10,
	0x86, 0xa6, 0xff, 0x14, 0xc1, 0x4c, 0x7c, 0x17, 0xc5, 0x57, 0x46, 0xa7, 0x7c, 0x6a, 0x59, 0x56,
	0xb4, 0xa2, 0xe4, 0xa2, 0x40, 0x6c, 0x27, 0x0b, 0x84, 0x84, 0x5b, 0xd0, 0xa6, 0xf8, 0xf7, 0x08,
	0x66, 0x13, 0xc3, 0x35, 0x1e, 0x6f, 0xa0, 0x71, 0xc1, 0x71, 0x2f, 0x19, 0x1c, 0x99, 0xb3, 0x3b,
	0x03, 0xbb, 0xa1, 0x4c, 0x64, 0xdb, 0xb0, 0xa4, 0xfc, 0x02, 0xc1, 0x6c, 0x62, 0x81, 0x1e, 0x15,
	0xd9, 0x59, 0x9b, 0x76, 0x6e, 0x96, 0x25, 0xbd, 0x5e, 0x9d, 0xcc, 0xeb, 0xff, 0x40, 0xb0, 0x90,
	0x9e, 0xdf, 0xf1, 0xc6, 0xb8, 0x9c, 0x1b, 0x9a, 0x38, 0x94, 0x42, 0xf3, 0x92, 0x7a, 0xd8, 0x37,
	0xce, 0x8b, 0xd4, 0x4a, 0xce, 0xf5, 0xf1, 0xaf, 0x4c, 0x8f, 0x6b, 0xaa, 0x5e, 0x24, 0x1c, 0x62,
	0x63, 0xe3, 0x66, 0x7c, 0x8a, 0xc3, 0x9f, 0x20, 0x98, 0x4d, 0x8c, 0xe6, 0xa3, 0xcc, 0x9d, 0x35,
	0xc3, 0x17, 0xd4, 0xe8, 0x5a, 0xdc, 0xf8, 0x1b, 0x58, 0x1f, 0x6b, 0xfc, 0x18, 0xe2, 0xd0, 0xfe,
	0x7f, 0x44, 0x30, 0x9f, 0x1a, 0xa8, 0xf1, 0x6b, 0xa3, 0x33, 0x69, 0x78, 0x29, 0x50, 0x36, 0x26,
	0xe0, 0x10, 0xe9, 0xb7, 0x93, 0x4c, 0x3f, 0x09, 0xbd, 0xb8, 0xbd, 0xf1, 0x17, 0x08, 0x16, 0xd2,
	0xc3, 0xdf, 0xa8, 0xd0, 0xc9, 0x99, 0xbf, 0xc7, 0x25, 0xe5, 0x23, 0x74, 0x62, 0x5c, 0x04, 0x88,
	0xbd, 0x91, 0x3b, 0x72, 0xf6, 0x8d, 0xe5, 0x58, 0x0c, 0x0c, 0xb5, 0xc8, 0xb7, 0x6b, 0x5b, 0x4c,
	0xc7, 0x18, 0x8d, 0x56, 0xdc, 0x55, 0xc9, 0xf8, 0xfa, 0x35, 0x82, 0x85, 0xf4, 0xf4, 0x3d, 0x4a,
	0xf9, 0x9c, 0x49, 0x3d, 0x37, 0xa9, 0x93, 0x71, 0x55, 0x9d, 0x38, 0xae, 0x1e, 0x21, 0x98, 0x09,
	0xc7, 0x4b, 0xd2, 0xd9, 0x63, 0xbf, 0x4c, 0x0d, 0x06, 0x29, 0x93, 0x74, 0xb4, 0xde, 0x86, 0x16,
	0xbf, 0x94, 0x60, 0x96, 0x52, 0x34, 0xfc, 0x56, 0xfd, 0x76, 0xdf, 0x98, 0x92, 0x3f, 0x18, 0x88,
	0xfe, 0x57, 0x63, 0x78, 0xe4, 0x61, 0xee, 0x98, 0xd1, 0x8e, 0x3d, 0x12, 0x16, 0xc1, 0x8f, 0x11,
	0xcc, 0xdc, 0x1e, 0x85, 0xea, 0x76, 0x71, 0x54, 0xef, 0xf6, 0x8d, 0x79, 0x09, 0x60, 0x9d, 0xff,
	0xfc, 0x36, 0x19, 0x38, 0x3f, 0x05, 0xee, 0x2f, 0x08, 0xf0, 0x1d, 0xea, 0xb3, 0x43, 0xea, 0x75,
	0x4c, 0xdf, 0x67, 0xff, 0x20, 0x5d, 0x4b, 0x3d, 0x3f, 0x4c, 0x22, 0x81, 0x5e, 0x2e, 0x40, 0x29,
	0xb2, 0xef, 0x5e, 0xdf, 0x58, 0x1c, 0x80, 0x1f, 0x10, 0x30, 0x0d, 0xb6, 0xd5, 0x37, 0x8b, 0x69,
	0x10, 0x0c, 0x3d, 0xb0, 0x89, 0xaa, 0xca, 0xc7, 0xe5, 0x13, 0xe3, 0xac, 0x8c, 0x40, 0x1e, 0x80,
	0xc9, 0x7d, 0xef, 0x6f, 0xc6, 0xe7, 0xa5, 0xc3, 0x20, 0x70, 0xfd, 0x4d, 0x5d, 0x3f, 0x3a, 0x3a,
	0x4a, 0x6f, 0x83, 0xa4, 0x1b, 0x1c, 0xea, 0xc9, 0x08, 0x5e, 0x9f, 0x8c, 0x5c, 0x13, 0x1d, 0x66,
	0x52, 0xb6, 0x68, 0xb8, 0x1d, 0xc7, 0xc7, 0x7e, 0xc3, 0xba, 0x32, 0x21, 0xc6, 0x2c, 0xa6, 0xc2,
	0x48, 0x39, 0xb3, 0x6b, 0x91, 0xe0, 0xc0, 0xf1, 0x3a, 0x13, 0x92, 0x6b, 0x1e, 0x25, 0xad, 0x2b,
	0x8e, 0x6d, 0x1d, 0x5f, 0xff, 0x13, 0x82, 0xb3, 0x4d, 0xa7, 0x93, 0x5b, 0x28, 0xae, 0x2b, 0x99,
	0x2b, 0xf3, 0x5e, 0x58, 0x1d, 0xf6, 0xd0, 0xbd, 0x6d, 0xc1, 0xd7, 0x76, 0x2c, 0x62, 0xb7, 0x35,
	0xc7, 0x6b, 0xeb, 0x6d, 0x6a, 0xb3, 0xda, 0xa1, 0x0f, 0x70, 0x0c, 0xff, 0xba, 0xbd, 0xc5, 0x3e,
	0xfc, 0xae, 0x74, 0x6e, 0x97, 0xf3, 0xdf, 0x08, 0xf1, 0x69, 0xf2, 0x29, 0x8d, 0xbd, 0xa1, 0xdd,
	0xad, 0x9d, 0x48, 0x82, 0xfb, 0x8c, 0xe0, 0xbe, 0x24, 0xb8, 0xcf, 0x08, 0xee, 0xdf, 0xad, 0xed,
	0x3f, 0xc7, 0xde, 0x7a, 0xfd, 0xcb, 0x00, 0x00, 0x00, 0xff, 0xff, 0x88, 0x5c, 0xb0, 0x13, 0x0d,
	0x20, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// BigtableInstanceAdminClient is the client API for BigtableInstanceAdmin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type BigtableInstanceAdminClient interface {
	// Create an instance within a project.
	CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets information about an instance.
	GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Lists information about instances in a project.
	ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error)
	// Updates an instance within a project. This method updates only the display
	// name and type for an Instance. To update other Instance properties, such as
	// labels, use PartialUpdateInstance.
	UpdateInstance(ctx context.Context, in *Instance, opts ...grpc.CallOption) (*Instance, error)
	// Partially updates an instance within a project. This method can modify all
	// fields of an Instance and is the preferred way to update an Instance.
	PartialUpdateInstance(ctx context.Context, in *PartialUpdateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Delete an instance from a project.
	DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates a cluster within an instance.
	CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets information about a cluster.
	GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error)
	// Lists information about clusters in an instance.
	ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error)
	// Updates a cluster within an instance.
	UpdateCluster(ctx context.Context, in *Cluster, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes a cluster from an instance.
	DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Creates an app profile within an instance.
	CreateAppProfile(ctx context.Context, in *CreateAppProfileRequest, opts ...grpc.CallOption) (*AppProfile, error)
	// Gets information about an app profile.
	GetAppProfile(ctx context.Context, in *GetAppProfileRequest, opts ...grpc.CallOption) (*AppProfile, error)
	// Lists information about app profiles in an instance.
	ListAppProfiles(ctx context.Context, in *ListAppProfilesRequest, opts ...grpc.CallOption) (*ListAppProfilesResponse, error)
	// Updates an app profile within an instance.
	UpdateAppProfile(ctx context.Context, in *UpdateAppProfileRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes an app profile from an instance.
	DeleteAppProfile(ctx context.Context, in *DeleteAppProfileRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Gets the access control policy for an instance resource. Returns an empty
	// policy if an instance exists but does not have a policy set.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Sets the access control policy on an instance resource. Replaces any
	// existing policy.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns permissions that the caller has on the specified instance resource.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type bigtableInstanceAdminClient struct {
	cc grpc.ClientConnInterface
}

func NewBigtableInstanceAdminClient(cc grpc.ClientConnInterface) BigtableInstanceAdminClient {
	return &bigtableInstanceAdminClient{cc}
}

func (c *bigtableInstanceAdminClient) CreateInstance(ctx context.Context, in *CreateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) GetInstance(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) ListInstances(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*ListInstancesResponse, error) {
	out := new(ListInstancesResponse)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListInstances", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) UpdateInstance(ctx context.Context, in *Instance, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) PartialUpdateInstance(ctx context.Context, in *PartialUpdateInstanceRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/PartialUpdateInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) DeleteInstance(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteInstance", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) CreateCluster(ctx context.Context, in *CreateClusterRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) GetCluster(ctx context.Context, in *GetClusterRequest, opts ...grpc.CallOption) (*Cluster, error) {
	out := new(Cluster)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) ListClusters(ctx context.Context, in *ListClustersRequest, opts ...grpc.CallOption) (*ListClustersResponse, error) {
	out := new(ListClustersResponse)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListClusters", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) UpdateCluster(ctx context.Context, in *Cluster, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) DeleteCluster(ctx context.Context, in *DeleteClusterRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteCluster", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) CreateAppProfile(ctx context.Context, in *CreateAppProfileRequest, opts ...grpc.CallOption) (*AppProfile, error) {
	out := new(AppProfile)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateAppProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) GetAppProfile(ctx context.Context, in *GetAppProfileRequest, opts ...grpc.CallOption) (*AppProfile, error) {
	out := new(AppProfile)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetAppProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) ListAppProfiles(ctx context.Context, in *ListAppProfilesRequest, opts ...grpc.CallOption) (*ListAppProfilesResponse, error) {
	out := new(ListAppProfilesResponse)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListAppProfiles", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) UpdateAppProfile(ctx context.Context, in *UpdateAppProfileRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateAppProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) DeleteAppProfile(ctx context.Context, in *DeleteAppProfileRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteAppProfile", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *bigtableInstanceAdminClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.bigtable.admin.v2.BigtableInstanceAdmin/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BigtableInstanceAdminServer is the server API for BigtableInstanceAdmin service.
type BigtableInstanceAdminServer interface {
	// Create an instance within a project.
	CreateInstance(context.Context, *CreateInstanceRequest) (*longrunning.Operation, error)
	// Gets information about an instance.
	GetInstance(context.Context, *GetInstanceRequest) (*Instance, error)
	// Lists information about instances in a project.
	ListInstances(context.Context, *ListInstancesRequest) (*ListInstancesResponse, error)
	// Updates an instance within a project. This method updates only the display
	// name and type for an Instance. To update other Instance properties, such as
	// labels, use PartialUpdateInstance.
	UpdateInstance(context.Context, *Instance) (*Instance, error)
	// Partially updates an instance within a project. This method can modify all
	// fields of an Instance and is the preferred way to update an Instance.
	PartialUpdateInstance(context.Context, *PartialUpdateInstanceRequest) (*longrunning.Operation, error)
	// Delete an instance from a project.
	DeleteInstance(context.Context, *DeleteInstanceRequest) (*empty.Empty, error)
	// Creates a cluster within an instance.
	CreateCluster(context.Context, *CreateClusterRequest) (*longrunning.Operation, error)
	// Gets information about a cluster.
	GetCluster(context.Context, *GetClusterRequest) (*Cluster, error)
	// Lists information about clusters in an instance.
	ListClusters(context.Context, *ListClustersRequest) (*ListClustersResponse, error)
	// Updates a cluster within an instance.
	UpdateCluster(context.Context, *Cluster) (*longrunning.Operation, error)
	// Deletes a cluster from an instance.
	DeleteCluster(context.Context, *DeleteClusterRequest) (*empty.Empty, error)
	// Creates an app profile within an instance.
	CreateAppProfile(context.Context, *CreateAppProfileRequest) (*AppProfile, error)
	// Gets information about an app profile.
	GetAppProfile(context.Context, *GetAppProfileRequest) (*AppProfile, error)
	// Lists information about app profiles in an instance.
	ListAppProfiles(context.Context, *ListAppProfilesRequest) (*ListAppProfilesResponse, error)
	// Updates an app profile within an instance.
	UpdateAppProfile(context.Context, *UpdateAppProfileRequest) (*longrunning.Operation, error)
	// Deletes an app profile from an instance.
	DeleteAppProfile(context.Context, *DeleteAppProfileRequest) (*empty.Empty, error)
	// Gets the access control policy for an instance resource. Returns an empty
	// policy if an instance exists but does not have a policy set.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Sets the access control policy on an instance resource. Replaces any
	// existing policy.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Returns permissions that the caller has on the specified instance resource.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

// UnimplementedBigtableInstanceAdminServer can be embedded to have forward compatible implementations.
type UnimplementedBigtableInstanceAdminServer struct {
}

func (*UnimplementedBigtableInstanceAdminServer) CreateInstance(ctx context.Context, req *CreateInstanceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInstance not implemented")
}
func (*UnimplementedBigtableInstanceAdminServer) GetInstance(ctx context.Context, req *GetInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetInstance not implemented")
}
func (*UnimplementedBigtableInstanceAdminServer) ListInstances(ctx context.Context, req *ListInstancesRequest) (*ListInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (*UnimplementedBigtableInstanceAdminServer) UpdateInstance(ctx context.Context, req *Instance) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateInstance not implemented")
}
func (*UnimplementedBigtableInstanceAdminServer) PartialUpdateInstance(ctx context.Context, req *PartialUpdateInstanceRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PartialUpdateInstance not implemented")
}
func (*UnimplementedBigtableInstanceAdminServer) DeleteInstance(ctx context.Context, req *DeleteInstanceRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstance not implemented")
}
func (*UnimplementedBigtableInstanceAdminServer) CreateCluster(ctx context.Context, req *CreateClusterRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCluster not implemented")
}
func (*UnimplementedBigtableInstanceAdminServer) GetCluster(ctx context.Context, req *GetClusterRequest) (*Cluster, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCluster not implemented")
}
func (*UnimplementedBigtableInstanceAdminServer) ListClusters(ctx context.Context, req *ListClustersRequest) (*ListClustersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListClusters not implemented")
}
func (*UnimplementedBigtableInstanceAdminServer) UpdateCluster(ctx context.Context, req *Cluster) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCluster not implemented")
}
func (*UnimplementedBigtableInstanceAdminServer) DeleteCluster(ctx context.Context, req *DeleteClusterRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCluster not implemented")
}
func (*UnimplementedBigtableInstanceAdminServer) CreateAppProfile(ctx context.Context, req *CreateAppProfileRequest) (*AppProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAppProfile not implemented")
}
func (*UnimplementedBigtableInstanceAdminServer) GetAppProfile(ctx context.Context, req *GetAppProfileRequest) (*AppProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAppProfile not implemented")
}
func (*UnimplementedBigtableInstanceAdminServer) ListAppProfiles(ctx context.Context, req *ListAppProfilesRequest) (*ListAppProfilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAppProfiles not implemented")
}
func (*UnimplementedBigtableInstanceAdminServer) UpdateAppProfile(ctx context.Context, req *UpdateAppProfileRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAppProfile not implemented")
}
func (*UnimplementedBigtableInstanceAdminServer) DeleteAppProfile(ctx context.Context, req *DeleteAppProfileRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAppProfile not implemented")
}
func (*UnimplementedBigtableInstanceAdminServer) GetIamPolicy(ctx context.Context, req *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedBigtableInstanceAdminServer) SetIamPolicy(ctx context.Context, req *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedBigtableInstanceAdminServer) TestIamPermissions(ctx context.Context, req *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterBigtableInstanceAdminServer(s *grpc.Server, srv BigtableInstanceAdminServer) {
	s.RegisterService(&_BigtableInstanceAdmin_serviceDesc, srv)
}

func _BigtableInstanceAdmin_CreateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).CreateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).CreateInstance(ctx, req.(*CreateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_GetInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).GetInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).GetInstance(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListInstances",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).ListInstances(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_UpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Instance)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).UpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).UpdateInstance(ctx, req.(*Instance))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_PartialUpdateInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PartialUpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).PartialUpdateInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/PartialUpdateInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).PartialUpdateInstance(ctx, req.(*PartialUpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_DeleteInstance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).DeleteInstance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteInstance",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).DeleteInstance(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_CreateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).CreateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).CreateCluster(ctx, req.(*CreateClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_GetCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).GetCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).GetCluster(ctx, req.(*GetClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_ListClusters_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListClustersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).ListClusters(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListClusters",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).ListClusters(ctx, req.(*ListClustersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_UpdateCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(Cluster)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).UpdateCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).UpdateCluster(ctx, req.(*Cluster))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_DeleteCluster_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteClusterRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).DeleteCluster(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteCluster",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).DeleteCluster(ctx, req.(*DeleteClusterRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_CreateAppProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAppProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).CreateAppProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/CreateAppProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).CreateAppProfile(ctx, req.(*CreateAppProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_GetAppProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAppProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).GetAppProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetAppProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).GetAppProfile(ctx, req.(*GetAppProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_ListAppProfiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAppProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).ListAppProfiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/ListAppProfiles",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).ListAppProfiles(ctx, req.(*ListAppProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_UpdateAppProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAppProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).UpdateAppProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/UpdateAppProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).UpdateAppProfile(ctx, req.(*UpdateAppProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_DeleteAppProfile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAppProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).DeleteAppProfile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/DeleteAppProfile",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).DeleteAppProfile(ctx, req.(*DeleteAppProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BigtableInstanceAdmin_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BigtableInstanceAdminServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.bigtable.admin.v2.BigtableInstanceAdmin/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BigtableInstanceAdminServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _BigtableInstanceAdmin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.bigtable.admin.v2.BigtableInstanceAdmin",
	HandlerType: (*BigtableInstanceAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateInstance",
			Handler:    _BigtableInstanceAdmin_CreateInstance_Handler,
		},
		{
			MethodName: "GetInstance",
			Handler:    _BigtableInstanceAdmin_GetInstance_Handler,
		},
		{
			MethodName: "ListInstances",
			Handler:    _BigtableInstanceAdmin_ListInstances_Handler,
		},
		{
			MethodName: "UpdateInstance",
			Handler:    _BigtableInstanceAdmin_UpdateInstance_Handler,
		},
		{
			MethodName: "PartialUpdateInstance",
			Handler:    _BigtableInstanceAdmin_PartialUpdateInstance_Handler,
		},
		{
			MethodName: "DeleteInstance",
			Handler:    _BigtableInstanceAdmin_DeleteInstance_Handler,
		},
		{
			MethodName: "CreateCluster",
			Handler:    _BigtableInstanceAdmin_CreateCluster_Handler,
		},
		{
			MethodName: "GetCluster",
			Handler:    _BigtableInstanceAdmin_GetCluster_Handler,
		},
		{
			MethodName: "ListClusters",
			Handler:    _BigtableInstanceAdmin_ListClusters_Handler,
		},
		{
			MethodName: "UpdateCluster",
			Handler:    _BigtableInstanceAdmin_UpdateCluster_Handler,
		},
		{
			MethodName: "DeleteCluster",
			Handler:    _BigtableInstanceAdmin_DeleteCluster_Handler,
		},
		{
			MethodName: "CreateAppProfile",
			Handler:    _BigtableInstanceAdmin_CreateAppProfile_Handler,
		},
		{
			MethodName: "GetAppProfile",
			Handler:    _BigtableInstanceAdmin_GetAppProfile_Handler,
		},
		{
			MethodName: "ListAppProfiles",
			Handler:    _BigtableInstanceAdmin_ListAppProfiles_Handler,
		},
		{
			MethodName: "UpdateAppProfile",
			Handler:    _BigtableInstanceAdmin_UpdateAppProfile_Handler,
		},
		{
			MethodName: "DeleteAppProfile",
			Handler:    _BigtableInstanceAdmin_DeleteAppProfile_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _BigtableInstanceAdmin_GetIamPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _BigtableInstanceAdmin_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _BigtableInstanceAdmin_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/bigtable/admin/v2/bigtable_instance_admin.proto",
}
