/*
 * CLOUD API
 *
 *  IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.
 *
 * API version: 6.0
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package ionoscloud

import (
	_context "context"
	"fmt"
	"io"
	_nethttp "net/http"
	_neturl "net/url"
	"strings"
)

// Linger please
var (
	_ _context.Context
)

// ApplicationLoadBalancersApiService ApplicationLoadBalancersApi service
type ApplicationLoadBalancersApiService service

type ApiDatacentersApplicationloadbalancersDeleteRequest struct {
	ctx                       _context.Context
	ApiService                *ApplicationLoadBalancersApiService
	datacenterId              string
	applicationLoadBalancerId string
	pretty                    *bool
	depth                     *int32
	xContractNumber           *int32
}

func (r ApiDatacentersApplicationloadbalancersDeleteRequest) Pretty(pretty bool) ApiDatacentersApplicationloadbalancersDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersApplicationloadbalancersDeleteRequest) Depth(depth int32) ApiDatacentersApplicationloadbalancersDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersApplicationloadbalancersDeleteRequest) XContractNumber(xContractNumber int32) ApiDatacentersApplicationloadbalancersDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersApplicationloadbalancersDeleteRequest) Execute() (*APIResponse, error) {
	return r.ApiService.DatacentersApplicationloadbalancersDeleteExecute(r)
}

/*
 * DatacentersApplicationloadbalancersDelete Delete an Application Load Balancer by ID
 * Removes the specified Application Load Balancer from the data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param applicationLoadBalancerId The unique ID of the Application Load Balancer.
 * @return ApiDatacentersApplicationloadbalancersDeleteRequest
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersDelete(ctx _context.Context, datacenterId string, applicationLoadBalancerId string) ApiDatacentersApplicationloadbalancersDeleteRequest {
	return ApiDatacentersApplicationloadbalancersDeleteRequest{
		ApiService:                a,
		ctx:                       ctx,
		datacenterId:              datacenterId,
		applicationLoadBalancerId: applicationLoadBalancerId,
	}
}

/*
 * Execute executes the request
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersDeleteExecute(r ApiDatacentersApplicationloadbalancersDeleteRequest) (*APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ApplicationLoadBalancersApiService.DatacentersApplicationloadbalancersDelete")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/applicationloadbalancers/{applicationLoadBalancerId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"applicationLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.applicationLoadBalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersApplicationloadbalancersDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarAPIResponse, newErr
	}

	return localVarAPIResponse, nil
}

type ApiDatacentersApplicationloadbalancersFindByApplicationLoadBalancerIdRequest struct {
	ctx                       _context.Context
	ApiService                *ApplicationLoadBalancersApiService
	datacenterId              string
	applicationLoadBalancerId string
	pretty                    *bool
	depth                     *int32
	xContractNumber           *int32
}

func (r ApiDatacentersApplicationloadbalancersFindByApplicationLoadBalancerIdRequest) Pretty(pretty bool) ApiDatacentersApplicationloadbalancersFindByApplicationLoadBalancerIdRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersApplicationloadbalancersFindByApplicationLoadBalancerIdRequest) Depth(depth int32) ApiDatacentersApplicationloadbalancersFindByApplicationLoadBalancerIdRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersApplicationloadbalancersFindByApplicationLoadBalancerIdRequest) XContractNumber(xContractNumber int32) ApiDatacentersApplicationloadbalancersFindByApplicationLoadBalancerIdRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersApplicationloadbalancersFindByApplicationLoadBalancerIdRequest) Execute() (ApplicationLoadBalancer, *APIResponse, error) {
	return r.ApiService.DatacentersApplicationloadbalancersFindByApplicationLoadBalancerIdExecute(r)
}

/*
 * DatacentersApplicationloadbalancersFindByApplicationLoadBalancerId Get an Application Load Balancer by ID
 * Retrieves the properties of the specified Application Load Balancer within the data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param applicationLoadBalancerId The unique ID of the Application Load Balancer.
 * @return ApiDatacentersApplicationloadbalancersFindByApplicationLoadBalancerIdRequest
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersFindByApplicationLoadBalancerId(ctx _context.Context, datacenterId string, applicationLoadBalancerId string) ApiDatacentersApplicationloadbalancersFindByApplicationLoadBalancerIdRequest {
	return ApiDatacentersApplicationloadbalancersFindByApplicationLoadBalancerIdRequest{
		ApiService:                a,
		ctx:                       ctx,
		datacenterId:              datacenterId,
		applicationLoadBalancerId: applicationLoadBalancerId,
	}
}

/*
 * Execute executes the request
 * @return ApplicationLoadBalancer
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersFindByApplicationLoadBalancerIdExecute(r ApiDatacentersApplicationloadbalancersFindByApplicationLoadBalancerIdRequest) (ApplicationLoadBalancer, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ApplicationLoadBalancer
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ApplicationLoadBalancersApiService.DatacentersApplicationloadbalancersFindByApplicationLoadBalancerId")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/applicationloadbalancers/{applicationLoadBalancerId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"applicationLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.applicationLoadBalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersApplicationloadbalancersFindByApplicationLoadBalancerId",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersApplicationloadbalancersFlowlogsDeleteRequest struct {
	ctx                       _context.Context
	ApiService                *ApplicationLoadBalancersApiService
	datacenterId              string
	applicationLoadBalancerId string
	flowLogId                 string
	pretty                    *bool
	depth                     *int32
	xContractNumber           *int32
}

func (r ApiDatacentersApplicationloadbalancersFlowlogsDeleteRequest) Pretty(pretty bool) ApiDatacentersApplicationloadbalancersFlowlogsDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersApplicationloadbalancersFlowlogsDeleteRequest) Depth(depth int32) ApiDatacentersApplicationloadbalancersFlowlogsDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersApplicationloadbalancersFlowlogsDeleteRequest) XContractNumber(xContractNumber int32) ApiDatacentersApplicationloadbalancersFlowlogsDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersApplicationloadbalancersFlowlogsDeleteRequest) Execute() (*APIResponse, error) {
	return r.ApiService.DatacentersApplicationloadbalancersFlowlogsDeleteExecute(r)
}

/*
 * DatacentersApplicationloadbalancersFlowlogsDelete Delete an ALB Flow Log by ID
 * Deletes the Application Load Balancer flow log specified by its ID.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param applicationLoadBalancerId The unique ID of the Application Load Balancer.
 * @param flowLogId The unique ID of the flow log.
 * @return ApiDatacentersApplicationloadbalancersFlowlogsDeleteRequest
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersFlowlogsDelete(ctx _context.Context, datacenterId string, applicationLoadBalancerId string, flowLogId string) ApiDatacentersApplicationloadbalancersFlowlogsDeleteRequest {
	return ApiDatacentersApplicationloadbalancersFlowlogsDeleteRequest{
		ApiService:                a,
		ctx:                       ctx,
		datacenterId:              datacenterId,
		applicationLoadBalancerId: applicationLoadBalancerId,
		flowLogId:                 flowLogId,
	}
}

/*
 * Execute executes the request
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersFlowlogsDeleteExecute(r ApiDatacentersApplicationloadbalancersFlowlogsDeleteRequest) (*APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ApplicationLoadBalancersApiService.DatacentersApplicationloadbalancersFlowlogsDelete")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/applicationloadbalancers/{applicationLoadBalancerId}/flowlogs/{flowLogId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"applicationLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.applicationLoadBalancerId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"flowLogId"+"}", _neturl.PathEscape(parameterToString(r.flowLogId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersApplicationloadbalancersFlowlogsDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarAPIResponse, newErr
	}

	return localVarAPIResponse, nil
}

type ApiDatacentersApplicationloadbalancersFlowlogsFindByFlowLogIdRequest struct {
	ctx                       _context.Context
	ApiService                *ApplicationLoadBalancersApiService
	datacenterId              string
	applicationLoadBalancerId string
	flowLogId                 string
	pretty                    *bool
	depth                     *int32
	xContractNumber           *int32
}

func (r ApiDatacentersApplicationloadbalancersFlowlogsFindByFlowLogIdRequest) Pretty(pretty bool) ApiDatacentersApplicationloadbalancersFlowlogsFindByFlowLogIdRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersApplicationloadbalancersFlowlogsFindByFlowLogIdRequest) Depth(depth int32) ApiDatacentersApplicationloadbalancersFlowlogsFindByFlowLogIdRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersApplicationloadbalancersFlowlogsFindByFlowLogIdRequest) XContractNumber(xContractNumber int32) ApiDatacentersApplicationloadbalancersFlowlogsFindByFlowLogIdRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersApplicationloadbalancersFlowlogsFindByFlowLogIdRequest) Execute() (FlowLog, *APIResponse, error) {
	return r.ApiService.DatacentersApplicationloadbalancersFlowlogsFindByFlowLogIdExecute(r)
}

/*
 * DatacentersApplicationloadbalancersFlowlogsFindByFlowLogId Get an ALB Flow Log by ID
 * Retrieves the Application Load Balancer flow log specified by its ID.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param applicationLoadBalancerId The unique ID of the Application Load Balancer.
 * @param flowLogId The unique ID of the flow log.
 * @return ApiDatacentersApplicationloadbalancersFlowlogsFindByFlowLogIdRequest
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersFlowlogsFindByFlowLogId(ctx _context.Context, datacenterId string, applicationLoadBalancerId string, flowLogId string) ApiDatacentersApplicationloadbalancersFlowlogsFindByFlowLogIdRequest {
	return ApiDatacentersApplicationloadbalancersFlowlogsFindByFlowLogIdRequest{
		ApiService:                a,
		ctx:                       ctx,
		datacenterId:              datacenterId,
		applicationLoadBalancerId: applicationLoadBalancerId,
		flowLogId:                 flowLogId,
	}
}

/*
 * Execute executes the request
 * @return FlowLog
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersFlowlogsFindByFlowLogIdExecute(r ApiDatacentersApplicationloadbalancersFlowlogsFindByFlowLogIdRequest) (FlowLog, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FlowLog
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ApplicationLoadBalancersApiService.DatacentersApplicationloadbalancersFlowlogsFindByFlowLogId")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/applicationloadbalancers/{applicationLoadBalancerId}/flowlogs/{flowLogId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"applicationLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.applicationLoadBalancerId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"flowLogId"+"}", _neturl.PathEscape(parameterToString(r.flowLogId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersApplicationloadbalancersFlowlogsFindByFlowLogId",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersApplicationloadbalancersFlowlogsGetRequest struct {
	ctx                       _context.Context
	ApiService                *ApplicationLoadBalancersApiService
	filters                   _neturl.Values
	orderBy                   *string
	maxResults                *int32
	datacenterId              string
	applicationLoadBalancerId string
	pretty                    *bool
	depth                     *int32
	xContractNumber           *int32
}

func (r ApiDatacentersApplicationloadbalancersFlowlogsGetRequest) Pretty(pretty bool) ApiDatacentersApplicationloadbalancersFlowlogsGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersApplicationloadbalancersFlowlogsGetRequest) Depth(depth int32) ApiDatacentersApplicationloadbalancersFlowlogsGetRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersApplicationloadbalancersFlowlogsGetRequest) XContractNumber(xContractNumber int32) ApiDatacentersApplicationloadbalancersFlowlogsGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

// Filters query parameters limit results to those containing a matching value for a specific property.
func (r ApiDatacentersApplicationloadbalancersFlowlogsGetRequest) Filter(key string, value string) ApiDatacentersApplicationloadbalancersFlowlogsGetRequest {
	filterKey := fmt.Sprintf(FilterQueryParam, key)
	r.filters[filterKey] = append(r.filters[filterKey], value)
	return r
}

// OrderBy query param sorts the results alphanumerically in ascending order based on the specified property.
func (r ApiDatacentersApplicationloadbalancersFlowlogsGetRequest) OrderBy(orderBy string) ApiDatacentersApplicationloadbalancersFlowlogsGetRequest {
	r.orderBy = &orderBy
	return r
}

// MaxResults query param limits the number of results returned.
func (r ApiDatacentersApplicationloadbalancersFlowlogsGetRequest) MaxResults(maxResults int32) ApiDatacentersApplicationloadbalancersFlowlogsGetRequest {
	r.maxResults = &maxResults
	return r
}

func (r ApiDatacentersApplicationloadbalancersFlowlogsGetRequest) Execute() (FlowLogs, *APIResponse, error) {
	return r.ApiService.DatacentersApplicationloadbalancersFlowlogsGetExecute(r)
}

/*
 * DatacentersApplicationloadbalancersFlowlogsGet Get ALB Flow Logs
 * Retrieves the flow logs for the specified Application Load Balancer.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param applicationLoadBalancerId The unique ID of the Application Load Balancer.
 * @return ApiDatacentersApplicationloadbalancersFlowlogsGetRequest
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersFlowlogsGet(ctx _context.Context, datacenterId string, applicationLoadBalancerId string) ApiDatacentersApplicationloadbalancersFlowlogsGetRequest {
	return ApiDatacentersApplicationloadbalancersFlowlogsGetRequest{
		ApiService:                a,
		ctx:                       ctx,
		datacenterId:              datacenterId,
		applicationLoadBalancerId: applicationLoadBalancerId,
		filters:                   _neturl.Values{},
	}
}

/*
 * Execute executes the request
 * @return FlowLogs
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersFlowlogsGetExecute(r ApiDatacentersApplicationloadbalancersFlowlogsGetRequest) (FlowLogs, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FlowLogs
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ApplicationLoadBalancersApiService.DatacentersApplicationloadbalancersFlowlogsGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/applicationloadbalancers/{applicationLoadBalancerId}/flowlogs"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"applicationLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.applicationLoadBalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}
	if r.orderBy != nil {
		localVarQueryParams.Add("orderBy", parameterToString(*r.orderBy, ""))
	}
	if r.maxResults != nil {
		localVarQueryParams.Add("maxResults", parameterToString(*r.maxResults, ""))
	}
	if len(r.filters) > 0 {
		for k, v := range r.filters {
			for _, iv := range v {
				localVarQueryParams.Add(k, iv)
			}
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersApplicationloadbalancersFlowlogsGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersApplicationloadbalancersFlowlogsPatchRequest struct {
	ctx                                      _context.Context
	ApiService                               *ApplicationLoadBalancersApiService
	datacenterId                             string
	applicationLoadBalancerId                string
	flowLogId                                string
	applicationLoadBalancerFlowLogProperties *FlowLogProperties
	pretty                                   *bool
	depth                                    *int32
	xContractNumber                          *int32
}

func (r ApiDatacentersApplicationloadbalancersFlowlogsPatchRequest) ApplicationLoadBalancerFlowLogProperties(applicationLoadBalancerFlowLogProperties FlowLogProperties) ApiDatacentersApplicationloadbalancersFlowlogsPatchRequest {
	r.applicationLoadBalancerFlowLogProperties = &applicationLoadBalancerFlowLogProperties
	return r
}
func (r ApiDatacentersApplicationloadbalancersFlowlogsPatchRequest) Pretty(pretty bool) ApiDatacentersApplicationloadbalancersFlowlogsPatchRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersApplicationloadbalancersFlowlogsPatchRequest) Depth(depth int32) ApiDatacentersApplicationloadbalancersFlowlogsPatchRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersApplicationloadbalancersFlowlogsPatchRequest) XContractNumber(xContractNumber int32) ApiDatacentersApplicationloadbalancersFlowlogsPatchRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersApplicationloadbalancersFlowlogsPatchRequest) Execute() (FlowLog, *APIResponse, error) {
	return r.ApiService.DatacentersApplicationloadbalancersFlowlogsPatchExecute(r)
}

/*
 * DatacentersApplicationloadbalancersFlowlogsPatch Partially Modify an ALB Flow Log by ID
 * Updates the properties of the Application Load Balancer flow log specified by its ID.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param applicationLoadBalancerId The unique ID of the Application Load Balancer.
 * @param flowLogId The unique ID of the flow log.
 * @return ApiDatacentersApplicationloadbalancersFlowlogsPatchRequest
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersFlowlogsPatch(ctx _context.Context, datacenterId string, applicationLoadBalancerId string, flowLogId string) ApiDatacentersApplicationloadbalancersFlowlogsPatchRequest {
	return ApiDatacentersApplicationloadbalancersFlowlogsPatchRequest{
		ApiService:                a,
		ctx:                       ctx,
		datacenterId:              datacenterId,
		applicationLoadBalancerId: applicationLoadBalancerId,
		flowLogId:                 flowLogId,
	}
}

/*
 * Execute executes the request
 * @return FlowLog
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersFlowlogsPatchExecute(r ApiDatacentersApplicationloadbalancersFlowlogsPatchRequest) (FlowLog, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FlowLog
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ApplicationLoadBalancersApiService.DatacentersApplicationloadbalancersFlowlogsPatch")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/applicationloadbalancers/{applicationLoadBalancerId}/flowlogs/{flowLogId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"applicationLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.applicationLoadBalancerId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"flowLogId"+"}", _neturl.PathEscape(parameterToString(r.flowLogId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.applicationLoadBalancerFlowLogProperties == nil {
		return localVarReturnValue, nil, reportError("applicationLoadBalancerFlowLogProperties is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.applicationLoadBalancerFlowLogProperties
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersApplicationloadbalancersFlowlogsPatch",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersApplicationloadbalancersFlowlogsPostRequest struct {
	ctx                            _context.Context
	ApiService                     *ApplicationLoadBalancersApiService
	datacenterId                   string
	applicationLoadBalancerId      string
	applicationLoadBalancerFlowLog *FlowLog
	pretty                         *bool
	depth                          *int32
	xContractNumber                *int32
}

func (r ApiDatacentersApplicationloadbalancersFlowlogsPostRequest) ApplicationLoadBalancerFlowLog(applicationLoadBalancerFlowLog FlowLog) ApiDatacentersApplicationloadbalancersFlowlogsPostRequest {
	r.applicationLoadBalancerFlowLog = &applicationLoadBalancerFlowLog
	return r
}
func (r ApiDatacentersApplicationloadbalancersFlowlogsPostRequest) Pretty(pretty bool) ApiDatacentersApplicationloadbalancersFlowlogsPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersApplicationloadbalancersFlowlogsPostRequest) Depth(depth int32) ApiDatacentersApplicationloadbalancersFlowlogsPostRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersApplicationloadbalancersFlowlogsPostRequest) XContractNumber(xContractNumber int32) ApiDatacentersApplicationloadbalancersFlowlogsPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersApplicationloadbalancersFlowlogsPostRequest) Execute() (FlowLog, *APIResponse, error) {
	return r.ApiService.DatacentersApplicationloadbalancersFlowlogsPostExecute(r)
}

/*
 * DatacentersApplicationloadbalancersFlowlogsPost Create an ALB Flow Log
 * Creates a flow log for the Application Load Balancer specified by ID.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param applicationLoadBalancerId The unique ID of the Application Load Balancer.
 * @return ApiDatacentersApplicationloadbalancersFlowlogsPostRequest
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersFlowlogsPost(ctx _context.Context, datacenterId string, applicationLoadBalancerId string) ApiDatacentersApplicationloadbalancersFlowlogsPostRequest {
	return ApiDatacentersApplicationloadbalancersFlowlogsPostRequest{
		ApiService:                a,
		ctx:                       ctx,
		datacenterId:              datacenterId,
		applicationLoadBalancerId: applicationLoadBalancerId,
	}
}

/*
 * Execute executes the request
 * @return FlowLog
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersFlowlogsPostExecute(r ApiDatacentersApplicationloadbalancersFlowlogsPostRequest) (FlowLog, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FlowLog
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ApplicationLoadBalancersApiService.DatacentersApplicationloadbalancersFlowlogsPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/applicationloadbalancers/{applicationLoadBalancerId}/flowlogs"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"applicationLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.applicationLoadBalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.applicationLoadBalancerFlowLog == nil {
		return localVarReturnValue, nil, reportError("applicationLoadBalancerFlowLog is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.applicationLoadBalancerFlowLog
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersApplicationloadbalancersFlowlogsPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersApplicationloadbalancersFlowlogsPutRequest struct {
	ctx                            _context.Context
	ApiService                     *ApplicationLoadBalancersApiService
	datacenterId                   string
	applicationLoadBalancerId      string
	flowLogId                      string
	applicationLoadBalancerFlowLog *FlowLogPut
	pretty                         *bool
	depth                          *int32
	xContractNumber                *int32
}

func (r ApiDatacentersApplicationloadbalancersFlowlogsPutRequest) ApplicationLoadBalancerFlowLog(applicationLoadBalancerFlowLog FlowLogPut) ApiDatacentersApplicationloadbalancersFlowlogsPutRequest {
	r.applicationLoadBalancerFlowLog = &applicationLoadBalancerFlowLog
	return r
}
func (r ApiDatacentersApplicationloadbalancersFlowlogsPutRequest) Pretty(pretty bool) ApiDatacentersApplicationloadbalancersFlowlogsPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersApplicationloadbalancersFlowlogsPutRequest) Depth(depth int32) ApiDatacentersApplicationloadbalancersFlowlogsPutRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersApplicationloadbalancersFlowlogsPutRequest) XContractNumber(xContractNumber int32) ApiDatacentersApplicationloadbalancersFlowlogsPutRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersApplicationloadbalancersFlowlogsPutRequest) Execute() (FlowLog, *APIResponse, error) {
	return r.ApiService.DatacentersApplicationloadbalancersFlowlogsPutExecute(r)
}

/*
 * DatacentersApplicationloadbalancersFlowlogsPut Modify an ALB Flow Log by ID
 * Modifies the Application Load Balancer flow log specified by its ID.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param applicationLoadBalancerId The unique ID of the Application Load Balancer.
 * @param flowLogId The unique ID of the flow log.
 * @return ApiDatacentersApplicationloadbalancersFlowlogsPutRequest
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersFlowlogsPut(ctx _context.Context, datacenterId string, applicationLoadBalancerId string, flowLogId string) ApiDatacentersApplicationloadbalancersFlowlogsPutRequest {
	return ApiDatacentersApplicationloadbalancersFlowlogsPutRequest{
		ApiService:                a,
		ctx:                       ctx,
		datacenterId:              datacenterId,
		applicationLoadBalancerId: applicationLoadBalancerId,
		flowLogId:                 flowLogId,
	}
}

/*
 * Execute executes the request
 * @return FlowLog
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersFlowlogsPutExecute(r ApiDatacentersApplicationloadbalancersFlowlogsPutRequest) (FlowLog, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  FlowLog
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ApplicationLoadBalancersApiService.DatacentersApplicationloadbalancersFlowlogsPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/applicationloadbalancers/{applicationLoadBalancerId}/flowlogs/{flowLogId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"applicationLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.applicationLoadBalancerId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"flowLogId"+"}", _neturl.PathEscape(parameterToString(r.flowLogId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.applicationLoadBalancerFlowLog == nil {
		return localVarReturnValue, nil, reportError("applicationLoadBalancerFlowLog is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.applicationLoadBalancerFlowLog
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersApplicationloadbalancersFlowlogsPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersApplicationloadbalancersForwardingrulesDeleteRequest struct {
	ctx                       _context.Context
	ApiService                *ApplicationLoadBalancersApiService
	datacenterId              string
	applicationLoadBalancerId string
	forwardingRuleId          string
	pretty                    *bool
	depth                     *int32
	xContractNumber           *int32
}

func (r ApiDatacentersApplicationloadbalancersForwardingrulesDeleteRequest) Pretty(pretty bool) ApiDatacentersApplicationloadbalancersForwardingrulesDeleteRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersApplicationloadbalancersForwardingrulesDeleteRequest) Depth(depth int32) ApiDatacentersApplicationloadbalancersForwardingrulesDeleteRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersApplicationloadbalancersForwardingrulesDeleteRequest) XContractNumber(xContractNumber int32) ApiDatacentersApplicationloadbalancersForwardingrulesDeleteRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersApplicationloadbalancersForwardingrulesDeleteRequest) Execute() (*APIResponse, error) {
	return r.ApiService.DatacentersApplicationloadbalancersForwardingrulesDeleteExecute(r)
}

/*
 * DatacentersApplicationloadbalancersForwardingrulesDelete Delete an ALB Forwarding Rule by ID
 * Deletes the Application Load Balancer forwarding rule specified by its ID.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param applicationLoadBalancerId The unique ID of the Application Load Balancer.
 * @param forwardingRuleId The unique ID of the forwarding rule.
 * @return ApiDatacentersApplicationloadbalancersForwardingrulesDeleteRequest
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersForwardingrulesDelete(ctx _context.Context, datacenterId string, applicationLoadBalancerId string, forwardingRuleId string) ApiDatacentersApplicationloadbalancersForwardingrulesDeleteRequest {
	return ApiDatacentersApplicationloadbalancersForwardingrulesDeleteRequest{
		ApiService:                a,
		ctx:                       ctx,
		datacenterId:              datacenterId,
		applicationLoadBalancerId: applicationLoadBalancerId,
		forwardingRuleId:          forwardingRuleId,
	}
}

/*
 * Execute executes the request
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersForwardingrulesDeleteExecute(r ApiDatacentersApplicationloadbalancersForwardingrulesDeleteRequest) (*APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodDelete
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ApplicationLoadBalancersApiService.DatacentersApplicationloadbalancersForwardingrulesDelete")
	if err != nil {
		return nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/applicationloadbalancers/{applicationLoadBalancerId}/forwardingrules/{forwardingRuleId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"applicationLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.applicationLoadBalancerId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"forwardingRuleId"+"}", _neturl.PathEscape(parameterToString(r.forwardingRuleId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersApplicationloadbalancersForwardingrulesDelete",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarAPIResponse, newErr
	}

	return localVarAPIResponse, nil
}

type ApiDatacentersApplicationloadbalancersForwardingrulesFindByForwardingRuleIdRequest struct {
	ctx                       _context.Context
	ApiService                *ApplicationLoadBalancersApiService
	datacenterId              string
	applicationLoadBalancerId string
	forwardingRuleId          string
	pretty                    *bool
	depth                     *int32
	xContractNumber           *int32
}

func (r ApiDatacentersApplicationloadbalancersForwardingrulesFindByForwardingRuleIdRequest) Pretty(pretty bool) ApiDatacentersApplicationloadbalancersForwardingrulesFindByForwardingRuleIdRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersApplicationloadbalancersForwardingrulesFindByForwardingRuleIdRequest) Depth(depth int32) ApiDatacentersApplicationloadbalancersForwardingrulesFindByForwardingRuleIdRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersApplicationloadbalancersForwardingrulesFindByForwardingRuleIdRequest) XContractNumber(xContractNumber int32) ApiDatacentersApplicationloadbalancersForwardingrulesFindByForwardingRuleIdRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersApplicationloadbalancersForwardingrulesFindByForwardingRuleIdRequest) Execute() (ApplicationLoadBalancerForwardingRule, *APIResponse, error) {
	return r.ApiService.DatacentersApplicationloadbalancersForwardingrulesFindByForwardingRuleIdExecute(r)
}

/*
 * DatacentersApplicationloadbalancersForwardingrulesFindByForwardingRuleId Get an ALB Forwarding Rule by ID
 * Retrieves the Application Load Balancer forwarding rule specified by its ID.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param applicationLoadBalancerId The unique ID of the Application Load Balancer.
 * @param forwardingRuleId The unique ID of the forwarding rule.
 * @return ApiDatacentersApplicationloadbalancersForwardingrulesFindByForwardingRuleIdRequest
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersForwardingrulesFindByForwardingRuleId(ctx _context.Context, datacenterId string, applicationLoadBalancerId string, forwardingRuleId string) ApiDatacentersApplicationloadbalancersForwardingrulesFindByForwardingRuleIdRequest {
	return ApiDatacentersApplicationloadbalancersForwardingrulesFindByForwardingRuleIdRequest{
		ApiService:                a,
		ctx:                       ctx,
		datacenterId:              datacenterId,
		applicationLoadBalancerId: applicationLoadBalancerId,
		forwardingRuleId:          forwardingRuleId,
	}
}

/*
 * Execute executes the request
 * @return ApplicationLoadBalancerForwardingRule
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersForwardingrulesFindByForwardingRuleIdExecute(r ApiDatacentersApplicationloadbalancersForwardingrulesFindByForwardingRuleIdRequest) (ApplicationLoadBalancerForwardingRule, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ApplicationLoadBalancerForwardingRule
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ApplicationLoadBalancersApiService.DatacentersApplicationloadbalancersForwardingrulesFindByForwardingRuleId")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/applicationloadbalancers/{applicationLoadBalancerId}/forwardingrules/{forwardingRuleId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"applicationLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.applicationLoadBalancerId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"forwardingRuleId"+"}", _neturl.PathEscape(parameterToString(r.forwardingRuleId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersApplicationloadbalancersForwardingrulesFindByForwardingRuleId",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersApplicationloadbalancersForwardingrulesGetRequest struct {
	ctx                       _context.Context
	ApiService                *ApplicationLoadBalancersApiService
	filters                   _neturl.Values
	orderBy                   *string
	maxResults                *int32
	datacenterId              string
	applicationLoadBalancerId string
	pretty                    *bool
	depth                     *int32
	xContractNumber           *int32
}

func (r ApiDatacentersApplicationloadbalancersForwardingrulesGetRequest) Pretty(pretty bool) ApiDatacentersApplicationloadbalancersForwardingrulesGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersApplicationloadbalancersForwardingrulesGetRequest) Depth(depth int32) ApiDatacentersApplicationloadbalancersForwardingrulesGetRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersApplicationloadbalancersForwardingrulesGetRequest) XContractNumber(xContractNumber int32) ApiDatacentersApplicationloadbalancersForwardingrulesGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}

// Filters query parameters limit results to those containing a matching value for a specific property.
func (r ApiDatacentersApplicationloadbalancersForwardingrulesGetRequest) Filter(key string, value string) ApiDatacentersApplicationloadbalancersForwardingrulesGetRequest {
	filterKey := fmt.Sprintf(FilterQueryParam, key)
	r.filters[filterKey] = append(r.filters[filterKey], value)
	return r
}

// OrderBy query param sorts the results alphanumerically in ascending order based on the specified property.
func (r ApiDatacentersApplicationloadbalancersForwardingrulesGetRequest) OrderBy(orderBy string) ApiDatacentersApplicationloadbalancersForwardingrulesGetRequest {
	r.orderBy = &orderBy
	return r
}

// MaxResults query param limits the number of results returned.
func (r ApiDatacentersApplicationloadbalancersForwardingrulesGetRequest) MaxResults(maxResults int32) ApiDatacentersApplicationloadbalancersForwardingrulesGetRequest {
	r.maxResults = &maxResults
	return r
}

func (r ApiDatacentersApplicationloadbalancersForwardingrulesGetRequest) Execute() (ApplicationLoadBalancerForwardingRules, *APIResponse, error) {
	return r.ApiService.DatacentersApplicationloadbalancersForwardingrulesGetExecute(r)
}

/*
 * DatacentersApplicationloadbalancersForwardingrulesGet Get ALB Forwarding Rules
 * Lists the forwarding rules of the specified Application Load Balancer.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param applicationLoadBalancerId The unique ID of the Application Load Balancer.
 * @return ApiDatacentersApplicationloadbalancersForwardingrulesGetRequest
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersForwardingrulesGet(ctx _context.Context, datacenterId string, applicationLoadBalancerId string) ApiDatacentersApplicationloadbalancersForwardingrulesGetRequest {
	return ApiDatacentersApplicationloadbalancersForwardingrulesGetRequest{
		ApiService:                a,
		ctx:                       ctx,
		datacenterId:              datacenterId,
		applicationLoadBalancerId: applicationLoadBalancerId,
		filters:                   _neturl.Values{},
	}
}

/*
 * Execute executes the request
 * @return ApplicationLoadBalancerForwardingRules
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersForwardingrulesGetExecute(r ApiDatacentersApplicationloadbalancersForwardingrulesGetRequest) (ApplicationLoadBalancerForwardingRules, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ApplicationLoadBalancerForwardingRules
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ApplicationLoadBalancersApiService.DatacentersApplicationloadbalancersForwardingrulesGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/applicationloadbalancers/{applicationLoadBalancerId}/forwardingrules"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"applicationLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.applicationLoadBalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}
	if r.orderBy != nil {
		localVarQueryParams.Add("orderBy", parameterToString(*r.orderBy, ""))
	}
	if r.maxResults != nil {
		localVarQueryParams.Add("maxResults", parameterToString(*r.maxResults, ""))
	}
	if len(r.filters) > 0 {
		for k, v := range r.filters {
			for _, iv := range v {
				localVarQueryParams.Add(k, iv)
			}
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersApplicationloadbalancersForwardingrulesGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersApplicationloadbalancersForwardingrulesPatchRequest struct {
	ctx                                             _context.Context
	ApiService                                      *ApplicationLoadBalancersApiService
	datacenterId                                    string
	applicationLoadBalancerId                       string
	forwardingRuleId                                string
	applicationLoadBalancerForwardingRuleProperties *ApplicationLoadBalancerForwardingRuleProperties
	pretty                                          *bool
	depth                                           *int32
	xContractNumber                                 *int32
}

func (r ApiDatacentersApplicationloadbalancersForwardingrulesPatchRequest) ApplicationLoadBalancerForwardingRuleProperties(applicationLoadBalancerForwardingRuleProperties ApplicationLoadBalancerForwardingRuleProperties) ApiDatacentersApplicationloadbalancersForwardingrulesPatchRequest {
	r.applicationLoadBalancerForwardingRuleProperties = &applicationLoadBalancerForwardingRuleProperties
	return r
}
func (r ApiDatacentersApplicationloadbalancersForwardingrulesPatchRequest) Pretty(pretty bool) ApiDatacentersApplicationloadbalancersForwardingrulesPatchRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersApplicationloadbalancersForwardingrulesPatchRequest) Depth(depth int32) ApiDatacentersApplicationloadbalancersForwardingrulesPatchRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersApplicationloadbalancersForwardingrulesPatchRequest) XContractNumber(xContractNumber int32) ApiDatacentersApplicationloadbalancersForwardingrulesPatchRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersApplicationloadbalancersForwardingrulesPatchRequest) Execute() (ApplicationLoadBalancerForwardingRule, *APIResponse, error) {
	return r.ApiService.DatacentersApplicationloadbalancersForwardingrulesPatchExecute(r)
}

/*
 * DatacentersApplicationloadbalancersForwardingrulesPatch Partially modify an ALB Forwarding Rule by ID
 * Updates the properties of the Application Load Balancer forwarding rule specified by its ID.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param applicationLoadBalancerId The unique ID of the Application Load Balancer.
 * @param forwardingRuleId The unique ID of the forwarding rule.
 * @return ApiDatacentersApplicationloadbalancersForwardingrulesPatchRequest
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersForwardingrulesPatch(ctx _context.Context, datacenterId string, applicationLoadBalancerId string, forwardingRuleId string) ApiDatacentersApplicationloadbalancersForwardingrulesPatchRequest {
	return ApiDatacentersApplicationloadbalancersForwardingrulesPatchRequest{
		ApiService:                a,
		ctx:                       ctx,
		datacenterId:              datacenterId,
		applicationLoadBalancerId: applicationLoadBalancerId,
		forwardingRuleId:          forwardingRuleId,
	}
}

/*
 * Execute executes the request
 * @return ApplicationLoadBalancerForwardingRule
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersForwardingrulesPatchExecute(r ApiDatacentersApplicationloadbalancersForwardingrulesPatchRequest) (ApplicationLoadBalancerForwardingRule, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ApplicationLoadBalancerForwardingRule
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ApplicationLoadBalancersApiService.DatacentersApplicationloadbalancersForwardingrulesPatch")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/applicationloadbalancers/{applicationLoadBalancerId}/forwardingrules/{forwardingRuleId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"applicationLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.applicationLoadBalancerId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"forwardingRuleId"+"}", _neturl.PathEscape(parameterToString(r.forwardingRuleId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.applicationLoadBalancerForwardingRuleProperties == nil {
		return localVarReturnValue, nil, reportError("applicationLoadBalancerForwardingRuleProperties is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.applicationLoadBalancerForwardingRuleProperties
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersApplicationloadbalancersForwardingrulesPatch",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersApplicationloadbalancersForwardingrulesPostRequest struct {
	ctx                                   _context.Context
	ApiService                            *ApplicationLoadBalancersApiService
	datacenterId                          string
	applicationLoadBalancerId             string
	applicationLoadBalancerForwardingRule *ApplicationLoadBalancerForwardingRule
	pretty                                *bool
	depth                                 *int32
	xContractNumber                       *int32
}

func (r ApiDatacentersApplicationloadbalancersForwardingrulesPostRequest) ApplicationLoadBalancerForwardingRule(applicationLoadBalancerForwardingRule ApplicationLoadBalancerForwardingRule) ApiDatacentersApplicationloadbalancersForwardingrulesPostRequest {
	r.applicationLoadBalancerForwardingRule = &applicationLoadBalancerForwardingRule
	return r
}
func (r ApiDatacentersApplicationloadbalancersForwardingrulesPostRequest) Pretty(pretty bool) ApiDatacentersApplicationloadbalancersForwardingrulesPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersApplicationloadbalancersForwardingrulesPostRequest) Depth(depth int32) ApiDatacentersApplicationloadbalancersForwardingrulesPostRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersApplicationloadbalancersForwardingrulesPostRequest) XContractNumber(xContractNumber int32) ApiDatacentersApplicationloadbalancersForwardingrulesPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersApplicationloadbalancersForwardingrulesPostRequest) Execute() (ApplicationLoadBalancerForwardingRule, *APIResponse, error) {
	return r.ApiService.DatacentersApplicationloadbalancersForwardingrulesPostExecute(r)
}

/*
 * DatacentersApplicationloadbalancersForwardingrulesPost Create an ALB Forwarding Rule
 * Creates a forwarding rule for the specified Application Load Balancer.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param applicationLoadBalancerId The unique ID of the Application Load Balancer.
 * @return ApiDatacentersApplicationloadbalancersForwardingrulesPostRequest
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersForwardingrulesPost(ctx _context.Context, datacenterId string, applicationLoadBalancerId string) ApiDatacentersApplicationloadbalancersForwardingrulesPostRequest {
	return ApiDatacentersApplicationloadbalancersForwardingrulesPostRequest{
		ApiService:                a,
		ctx:                       ctx,
		datacenterId:              datacenterId,
		applicationLoadBalancerId: applicationLoadBalancerId,
	}
}

/*
 * Execute executes the request
 * @return ApplicationLoadBalancerForwardingRule
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersForwardingrulesPostExecute(r ApiDatacentersApplicationloadbalancersForwardingrulesPostRequest) (ApplicationLoadBalancerForwardingRule, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ApplicationLoadBalancerForwardingRule
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ApplicationLoadBalancersApiService.DatacentersApplicationloadbalancersForwardingrulesPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/applicationloadbalancers/{applicationLoadBalancerId}/forwardingrules"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"applicationLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.applicationLoadBalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.applicationLoadBalancerForwardingRule == nil {
		return localVarReturnValue, nil, reportError("applicationLoadBalancerForwardingRule is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.applicationLoadBalancerForwardingRule
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersApplicationloadbalancersForwardingrulesPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersApplicationloadbalancersForwardingrulesPutRequest struct {
	ctx                                   _context.Context
	ApiService                            *ApplicationLoadBalancersApiService
	datacenterId                          string
	applicationLoadBalancerId             string
	forwardingRuleId                      string
	applicationLoadBalancerForwardingRule *ApplicationLoadBalancerForwardingRulePut
	pretty                                *bool
	depth                                 *int32
	xContractNumber                       *int32
}

func (r ApiDatacentersApplicationloadbalancersForwardingrulesPutRequest) ApplicationLoadBalancerForwardingRule(applicationLoadBalancerForwardingRule ApplicationLoadBalancerForwardingRulePut) ApiDatacentersApplicationloadbalancersForwardingrulesPutRequest {
	r.applicationLoadBalancerForwardingRule = &applicationLoadBalancerForwardingRule
	return r
}
func (r ApiDatacentersApplicationloadbalancersForwardingrulesPutRequest) Pretty(pretty bool) ApiDatacentersApplicationloadbalancersForwardingrulesPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersApplicationloadbalancersForwardingrulesPutRequest) Depth(depth int32) ApiDatacentersApplicationloadbalancersForwardingrulesPutRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersApplicationloadbalancersForwardingrulesPutRequest) XContractNumber(xContractNumber int32) ApiDatacentersApplicationloadbalancersForwardingrulesPutRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersApplicationloadbalancersForwardingrulesPutRequest) Execute() (ApplicationLoadBalancerForwardingRule, *APIResponse, error) {
	return r.ApiService.DatacentersApplicationloadbalancersForwardingrulesPutExecute(r)
}

/*
 * DatacentersApplicationloadbalancersForwardingrulesPut Modify an ALB Forwarding Rule by ID
 * Modifies the Application Load Balancer forwarding rule specified by its ID.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param applicationLoadBalancerId The unique ID of the Application Load Balancer.
 * @param forwardingRuleId The unique ID of the forwarding rule.
 * @return ApiDatacentersApplicationloadbalancersForwardingrulesPutRequest
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersForwardingrulesPut(ctx _context.Context, datacenterId string, applicationLoadBalancerId string, forwardingRuleId string) ApiDatacentersApplicationloadbalancersForwardingrulesPutRequest {
	return ApiDatacentersApplicationloadbalancersForwardingrulesPutRequest{
		ApiService:                a,
		ctx:                       ctx,
		datacenterId:              datacenterId,
		applicationLoadBalancerId: applicationLoadBalancerId,
		forwardingRuleId:          forwardingRuleId,
	}
}

/*
 * Execute executes the request
 * @return ApplicationLoadBalancerForwardingRule
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersForwardingrulesPutExecute(r ApiDatacentersApplicationloadbalancersForwardingrulesPutRequest) (ApplicationLoadBalancerForwardingRule, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ApplicationLoadBalancerForwardingRule
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ApplicationLoadBalancersApiService.DatacentersApplicationloadbalancersForwardingrulesPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/applicationloadbalancers/{applicationLoadBalancerId}/forwardingrules/{forwardingRuleId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"applicationLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.applicationLoadBalancerId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"forwardingRuleId"+"}", _neturl.PathEscape(parameterToString(r.forwardingRuleId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.applicationLoadBalancerForwardingRule == nil {
		return localVarReturnValue, nil, reportError("applicationLoadBalancerForwardingRule is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.applicationLoadBalancerForwardingRule
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersApplicationloadbalancersForwardingrulesPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersApplicationloadbalancersGetRequest struct {
	ctx             _context.Context
	ApiService      *ApplicationLoadBalancersApiService
	filters         _neturl.Values
	orderBy         *string
	maxResults      *int32
	datacenterId    string
	pretty          *bool
	depth           *int32
	xContractNumber *int32
	offset          *int32
	limit           *int32
}

func (r ApiDatacentersApplicationloadbalancersGetRequest) Pretty(pretty bool) ApiDatacentersApplicationloadbalancersGetRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersApplicationloadbalancersGetRequest) Depth(depth int32) ApiDatacentersApplicationloadbalancersGetRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersApplicationloadbalancersGetRequest) XContractNumber(xContractNumber int32) ApiDatacentersApplicationloadbalancersGetRequest {
	r.xContractNumber = &xContractNumber
	return r
}
func (r ApiDatacentersApplicationloadbalancersGetRequest) Offset(offset int32) ApiDatacentersApplicationloadbalancersGetRequest {
	r.offset = &offset
	return r
}
func (r ApiDatacentersApplicationloadbalancersGetRequest) Limit(limit int32) ApiDatacentersApplicationloadbalancersGetRequest {
	r.limit = &limit
	return r
}

// Filters query parameters limit results to those containing a matching value for a specific property.
func (r ApiDatacentersApplicationloadbalancersGetRequest) Filter(key string, value string) ApiDatacentersApplicationloadbalancersGetRequest {
	filterKey := fmt.Sprintf(FilterQueryParam, key)
	r.filters[filterKey] = append(r.filters[filterKey], value)
	return r
}

// OrderBy query param sorts the results alphanumerically in ascending order based on the specified property.
func (r ApiDatacentersApplicationloadbalancersGetRequest) OrderBy(orderBy string) ApiDatacentersApplicationloadbalancersGetRequest {
	r.orderBy = &orderBy
	return r
}

// MaxResults query param limits the number of results returned.
func (r ApiDatacentersApplicationloadbalancersGetRequest) MaxResults(maxResults int32) ApiDatacentersApplicationloadbalancersGetRequest {
	r.maxResults = &maxResults
	return r
}

func (r ApiDatacentersApplicationloadbalancersGetRequest) Execute() (ApplicationLoadBalancers, *APIResponse, error) {
	return r.ApiService.DatacentersApplicationloadbalancersGetExecute(r)
}

/*
 * DatacentersApplicationloadbalancersGet Get Application Load Balancers
 * Lists all Application Load Balancers within a data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @return ApiDatacentersApplicationloadbalancersGetRequest
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersGet(ctx _context.Context, datacenterId string) ApiDatacentersApplicationloadbalancersGetRequest {
	return ApiDatacentersApplicationloadbalancersGetRequest{
		ApiService:   a,
		ctx:          ctx,
		datacenterId: datacenterId,
		filters:      _neturl.Values{},
	}
}

/*
 * Execute executes the request
 * @return ApplicationLoadBalancers
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersGetExecute(r ApiDatacentersApplicationloadbalancersGetRequest) (ApplicationLoadBalancers, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodGet
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ApplicationLoadBalancers
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ApplicationLoadBalancersApiService.DatacentersApplicationloadbalancersGet")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/applicationloadbalancers"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}
	if r.offset != nil {
		localVarQueryParams.Add("offset", parameterToString(*r.offset, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("offset")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("offset", parameterToString(0, ""))
		}
	}
	if r.limit != nil {
		localVarQueryParams.Add("limit", parameterToString(*r.limit, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("limit")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("limit", parameterToString(1000, ""))
		}
	}
	if r.orderBy != nil {
		localVarQueryParams.Add("orderBy", parameterToString(*r.orderBy, ""))
	}
	if r.maxResults != nil {
		localVarQueryParams.Add("maxResults", parameterToString(*r.maxResults, ""))
	}
	if len(r.filters) > 0 {
		for k, v := range r.filters {
			for _, iv := range v {
				localVarQueryParams.Add(k, iv)
			}
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersApplicationloadbalancersGet",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersApplicationloadbalancersPatchRequest struct {
	ctx                               _context.Context
	ApiService                        *ApplicationLoadBalancersApiService
	datacenterId                      string
	applicationLoadBalancerId         string
	applicationLoadBalancerProperties *ApplicationLoadBalancerProperties
	pretty                            *bool
	depth                             *int32
	xContractNumber                   *int32
}

func (r ApiDatacentersApplicationloadbalancersPatchRequest) ApplicationLoadBalancerProperties(applicationLoadBalancerProperties ApplicationLoadBalancerProperties) ApiDatacentersApplicationloadbalancersPatchRequest {
	r.applicationLoadBalancerProperties = &applicationLoadBalancerProperties
	return r
}
func (r ApiDatacentersApplicationloadbalancersPatchRequest) Pretty(pretty bool) ApiDatacentersApplicationloadbalancersPatchRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersApplicationloadbalancersPatchRequest) Depth(depth int32) ApiDatacentersApplicationloadbalancersPatchRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersApplicationloadbalancersPatchRequest) XContractNumber(xContractNumber int32) ApiDatacentersApplicationloadbalancersPatchRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersApplicationloadbalancersPatchRequest) Execute() (ApplicationLoadBalancer, *APIResponse, error) {
	return r.ApiService.DatacentersApplicationloadbalancersPatchExecute(r)
}

/*
 * DatacentersApplicationloadbalancersPatch Partially Modify an Application Load Balancer by ID
 * Updates the properties of the specified Application Load Balancer within the data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param applicationLoadBalancerId The unique ID of the Application Load Balancer.
 * @return ApiDatacentersApplicationloadbalancersPatchRequest
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersPatch(ctx _context.Context, datacenterId string, applicationLoadBalancerId string) ApiDatacentersApplicationloadbalancersPatchRequest {
	return ApiDatacentersApplicationloadbalancersPatchRequest{
		ApiService:                a,
		ctx:                       ctx,
		datacenterId:              datacenterId,
		applicationLoadBalancerId: applicationLoadBalancerId,
	}
}

/*
 * Execute executes the request
 * @return ApplicationLoadBalancer
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersPatchExecute(r ApiDatacentersApplicationloadbalancersPatchRequest) (ApplicationLoadBalancer, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPatch
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ApplicationLoadBalancer
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ApplicationLoadBalancersApiService.DatacentersApplicationloadbalancersPatch")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/applicationloadbalancers/{applicationLoadBalancerId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"applicationLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.applicationLoadBalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.applicationLoadBalancerProperties == nil {
		return localVarReturnValue, nil, reportError("applicationLoadBalancerProperties is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.applicationLoadBalancerProperties
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersApplicationloadbalancersPatch",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersApplicationloadbalancersPostRequest struct {
	ctx                     _context.Context
	ApiService              *ApplicationLoadBalancersApiService
	datacenterId            string
	applicationLoadBalancer *ApplicationLoadBalancer
	pretty                  *bool
	depth                   *int32
	xContractNumber         *int32
}

func (r ApiDatacentersApplicationloadbalancersPostRequest) ApplicationLoadBalancer(applicationLoadBalancer ApplicationLoadBalancer) ApiDatacentersApplicationloadbalancersPostRequest {
	r.applicationLoadBalancer = &applicationLoadBalancer
	return r
}
func (r ApiDatacentersApplicationloadbalancersPostRequest) Pretty(pretty bool) ApiDatacentersApplicationloadbalancersPostRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersApplicationloadbalancersPostRequest) Depth(depth int32) ApiDatacentersApplicationloadbalancersPostRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersApplicationloadbalancersPostRequest) XContractNumber(xContractNumber int32) ApiDatacentersApplicationloadbalancersPostRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersApplicationloadbalancersPostRequest) Execute() (ApplicationLoadBalancer, *APIResponse, error) {
	return r.ApiService.DatacentersApplicationloadbalancersPostExecute(r)
}

/*
 * DatacentersApplicationloadbalancersPost Create an Application Load Balancer
 * Creates an Application Load Balancer within the data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @return ApiDatacentersApplicationloadbalancersPostRequest
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersPost(ctx _context.Context, datacenterId string) ApiDatacentersApplicationloadbalancersPostRequest {
	return ApiDatacentersApplicationloadbalancersPostRequest{
		ApiService:   a,
		ctx:          ctx,
		datacenterId: datacenterId,
	}
}

/*
 * Execute executes the request
 * @return ApplicationLoadBalancer
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersPostExecute(r ApiDatacentersApplicationloadbalancersPostRequest) (ApplicationLoadBalancer, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPost
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ApplicationLoadBalancer
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ApplicationLoadBalancersApiService.DatacentersApplicationloadbalancersPost")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/applicationloadbalancers"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.applicationLoadBalancer == nil {
		return localVarReturnValue, nil, reportError("applicationLoadBalancer is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.applicationLoadBalancer
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersApplicationloadbalancersPost",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}

type ApiDatacentersApplicationloadbalancersPutRequest struct {
	ctx                       _context.Context
	ApiService                *ApplicationLoadBalancersApiService
	datacenterId              string
	applicationLoadBalancerId string
	applicationLoadBalancer   *ApplicationLoadBalancerPut
	pretty                    *bool
	depth                     *int32
	xContractNumber           *int32
}

func (r ApiDatacentersApplicationloadbalancersPutRequest) ApplicationLoadBalancer(applicationLoadBalancer ApplicationLoadBalancerPut) ApiDatacentersApplicationloadbalancersPutRequest {
	r.applicationLoadBalancer = &applicationLoadBalancer
	return r
}
func (r ApiDatacentersApplicationloadbalancersPutRequest) Pretty(pretty bool) ApiDatacentersApplicationloadbalancersPutRequest {
	r.pretty = &pretty
	return r
}
func (r ApiDatacentersApplicationloadbalancersPutRequest) Depth(depth int32) ApiDatacentersApplicationloadbalancersPutRequest {
	r.depth = &depth
	return r
}
func (r ApiDatacentersApplicationloadbalancersPutRequest) XContractNumber(xContractNumber int32) ApiDatacentersApplicationloadbalancersPutRequest {
	r.xContractNumber = &xContractNumber
	return r
}

func (r ApiDatacentersApplicationloadbalancersPutRequest) Execute() (ApplicationLoadBalancer, *APIResponse, error) {
	return r.ApiService.DatacentersApplicationloadbalancersPutExecute(r)
}

/*
 * DatacentersApplicationloadbalancersPut Modify an Application Load Balancer by ID
 * Modifies the properties of the specified Application Load Balancer within the data center.
 * @param ctx _context.Context - for authentication, logging, cancellation, deadlines, tracing, etc. Passed from http.Request or context.Background().
 * @param datacenterId The unique ID of the data center.
 * @param applicationLoadBalancerId The unique ID of the Application Load Balancer.
 * @return ApiDatacentersApplicationloadbalancersPutRequest
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersPut(ctx _context.Context, datacenterId string, applicationLoadBalancerId string) ApiDatacentersApplicationloadbalancersPutRequest {
	return ApiDatacentersApplicationloadbalancersPutRequest{
		ApiService:                a,
		ctx:                       ctx,
		datacenterId:              datacenterId,
		applicationLoadBalancerId: applicationLoadBalancerId,
	}
}

/*
 * Execute executes the request
 * @return ApplicationLoadBalancer
 */
func (a *ApplicationLoadBalancersApiService) DatacentersApplicationloadbalancersPutExecute(r ApiDatacentersApplicationloadbalancersPutRequest) (ApplicationLoadBalancer, *APIResponse, error) {
	var (
		localVarHTTPMethod   = _nethttp.MethodPut
		localVarPostBody     interface{}
		localVarFormFileName string
		localVarFileName     string
		localVarFileBytes    []byte
		localVarReturnValue  ApplicationLoadBalancer
	)

	localBasePath, err := a.client.cfg.ServerURLWithContext(r.ctx, "ApplicationLoadBalancersApiService.DatacentersApplicationloadbalancersPut")
	if err != nil {
		return localVarReturnValue, nil, GenericOpenAPIError{error: err.Error()}
	}

	localVarPath := localBasePath + "/datacenters/{datacenterId}/applicationloadbalancers/{applicationLoadBalancerId}"
	localVarPath = strings.Replace(localVarPath, "{"+"datacenterId"+"}", _neturl.PathEscape(parameterToString(r.datacenterId, "")), -1)
	localVarPath = strings.Replace(localVarPath, "{"+"applicationLoadBalancerId"+"}", _neturl.PathEscape(parameterToString(r.applicationLoadBalancerId, "")), -1)

	localVarHeaderParams := make(map[string]string)
	localVarQueryParams := _neturl.Values{}
	localVarFormParams := _neturl.Values{}
	if r.applicationLoadBalancer == nil {
		return localVarReturnValue, nil, reportError("applicationLoadBalancer is required and must be specified")
	}

	if r.pretty != nil {
		localVarQueryParams.Add("pretty", parameterToString(*r.pretty, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("pretty")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("pretty", parameterToString(true, ""))
		}
	}
	if r.depth != nil {
		localVarQueryParams.Add("depth", parameterToString(*r.depth, ""))
	} else {
		defaultQueryParam := a.client.cfg.DefaultQueryParams.Get("depth")
		if defaultQueryParam == "" {
			localVarQueryParams.Add("depth", parameterToString(0, ""))
		}
	}

	// to determine the Content-Type header
	localVarHTTPContentTypes := []string{"application/json"}

	// set Content-Type header
	localVarHTTPContentType := selectHeaderContentType(localVarHTTPContentTypes)
	if localVarHTTPContentType != "" {
		localVarHeaderParams["Content-Type"] = localVarHTTPContentType
	}

	// to determine the Accept header
	localVarHTTPHeaderAccepts := []string{"application/json"}

	// set Accept header
	localVarHTTPHeaderAccept := selectHeaderAccept(localVarHTTPHeaderAccepts)
	if localVarHTTPHeaderAccept != "" {
		localVarHeaderParams["Accept"] = localVarHTTPHeaderAccept
	}
	if r.xContractNumber != nil {
		localVarHeaderParams["X-Contract-Number"] = parameterToString(*r.xContractNumber, "")
	}
	// body params
	localVarPostBody = r.applicationLoadBalancer
	if r.ctx != nil {
		// API Key Authentication
		if auth, ok := r.ctx.Value(ContextAPIKeys).(map[string]APIKey); ok {
			if apiKey, ok := auth["TokenAuthentication"]; ok {
				var key string
				if apiKey.Prefix != "" {
					key = apiKey.Prefix + " " + apiKey.Key
				} else {
					key = apiKey.Key
				}
				localVarHeaderParams["Authorization"] = key
			}
		}
	}
	req, err := a.client.prepareRequest(r.ctx, localVarPath, localVarHTTPMethod, localVarPostBody, localVarHeaderParams, localVarQueryParams, localVarFormParams, localVarFormFileName, localVarFileName, localVarFileBytes)
	if err != nil {
		return localVarReturnValue, nil, err
	}

	localVarHTTPResponse, httpRequestTime, err := a.client.callAPI(req)

	localVarAPIResponse := &APIResponse{
		Response:    localVarHTTPResponse,
		Method:      localVarHTTPMethod,
		RequestURL:  localVarPath,
		RequestTime: httpRequestTime,
		Operation:   "DatacentersApplicationloadbalancersPut",
	}

	if err != nil || localVarHTTPResponse == nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	localVarBody, err := io.ReadAll(localVarHTTPResponse.Body)
	localVarHTTPResponse.Body.Close()
	localVarAPIResponse.Payload = localVarBody
	if err != nil {
		return localVarReturnValue, localVarAPIResponse, err
	}

	if localVarHTTPResponse.StatusCode >= 300 {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, string(localVarBody)),
		}
		var v Error
		err = a.client.decode(&v, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
		if err != nil {
			newErr.error = fmt.Sprintf(FormatStringErr, localVarHTTPResponse.Status, err.Error())
			return localVarReturnValue, localVarAPIResponse, newErr
		}
		newErr.model = v
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	err = a.client.decode(&localVarReturnValue, localVarBody, localVarHTTPResponse.Header.Get("Content-Type"))
	if err != nil {
		newErr := GenericOpenAPIError{
			statusCode: localVarHTTPResponse.StatusCode,
			body:       localVarBody,
			error:      err.Error(),
		}
		return localVarReturnValue, localVarAPIResponse, newErr
	}

	return localVarReturnValue, localVarAPIResponse, nil
}
